//  Copyright John Maddock 2015.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const boost::array<boost::array<typename table_type<T>::type, 3>, 900> ellint_d2_data = {{
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(1.6900929544760856515495106577873229980469e-09), SC_(-7.8732233320862771639280819567039935203140e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(2.1149908491224778117612004280090332031250e-09), SC_(-7.8732233320862771686912327739413416253147e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(7.0996275525203600409440696239471435546875e-09), SC_(-7.8732233320862773040094892394481766236413e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(1.3671879628418537322431802749633789062500e-08), SC_(-7.8732233320862777061962311270009485876061e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(1.6793407553450379054993391036987304687500e-08), SC_(-7.8732233320862779863639076277990913817347e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(5.8676832281889801379293203353881835937500e-08), SC_(-7.8732233320862872988029644567747349940542e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(1.1404608812881633639335632324218750000000e-07), SC_(-7.8732233320863154738199654417598345858119e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(1.4555860161635791882872581481933593750000e-07), SC_(-7.8732233320863395751553299211683365778187e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(3.8918472000659676268696784973144531250000e-07), SC_(-7.8732233320867233837916108266938568745684e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(6.2378262555284891277551651000976562500000e-07), SC_(-7.8732233320874234918936314457509845665294e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(1.0466960702615324407815933227539062500000e-06), SC_(-7.8732233320895048075961800643068367799212e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(2.9510883905459195375442504882812500000000e-06), SC_(-7.8732233321119343970604024759286096900163e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(4.8770834837341681122779846191406250000000e-06), SC_(-7.8732233321563526074010427269286136824309e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(9.0666326286736875772476196289062500000000e-06), SC_(-7.8732233323284567598867407494011434890031e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(2.3603533918503671884536743164062500000000e-05), SC_(-7.8732233337276210668971915341274684374079e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(6.0817910707555711269378662109375000000000e-05), SC_(-7.8732233429833165735721604834460196035801e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(1.1947672464884817600250244140625000000000e-04), SC_(-7.8732233741407456045279716007492903731599e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(2.4370866594836115837097167968750000000000e-04), SC_(-7.8732235070659049826721771893117827793630e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(4.7970912419259548187255859375000000000000e-04), SC_(-7.8732240100423384592953702904358834225824e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(9.6078845672309398651123046875000000000000e-04), SC_(-7.8732260516631005030439216215704935088944e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(1.1304812505841255187988281250000000000000e-03), SC_(-7.8732270971523503035692113472253819905238e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(3.3707786351442337036132812500000000000000e-03), SC_(-7.8732568061991404297875494369487831261691e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(7.6976269483566284179687500000000000000000e-03), SC_(-7.8733979043836641416900536713300906266451e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(1.5477418899536132812500000000000000000000e-02), SC_(-7.8739291742767640768396325723497092471770e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(3.0580729246139526367187500000000000000000e-02), SC_(-7.8759800674545974072460670879983596961217e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(3.4683167934417724609375000000000000000000e-02), SC_(-7.8767699111095026342327081674718259137011e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(9.2835962772369384765625000000000000000000e-02), SC_(-7.8987518284015183880900122991006802628935e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(2.2476321458816528320312500000000000000000e-01), SC_(-8.0269335104926377301523131658299640546457e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(4.5007002353668212890625000000000000000000e-01), SC_(-8.5588199641614171029457261894174425351056e+00) }}, 
      {{ SC_(-1.6098388671875000000000000000000000000000e+01), SC_(6.4851474761962890625000000000000000000000e-01), SC_(-9.5887811073974781509819096986492335481206e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(1.6900929544760856515495106577873229980469e-09), SC_(-7.8536241199028447606481998927044443242379e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(2.1149908491224778117612004280090332031250e-09), SC_(-7.8536241199028447654099849623516320011347e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(7.0996275525203600409440696239471435546875e-09), SC_(-7.8536241199028449006894413583742788397395e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(1.3671879628418537322431802749633789062500e-08), SC_(-7.8536241199028453027608634514037298550959e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(1.6793407553450379054993391036987304687500e-08), SC_(-7.8536241199028455828482069239809137416614e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(5.8676832281889801379293203353881835937500e-08), SC_(-7.8536241199028548926170898096177741594499e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(1.1404608812881633639335632324218750000000e-07), SC_(-7.8536241199028830595554128252702619975820e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(1.4555860161635791882872581481933593750000e-07), SC_(-7.8536241199029071539801540729799856204226e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(3.8918472000659676268696784973144531250000e-07), SC_(-7.8536241199032908525662307761981174553050e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(6.2378262555284891277551651000976562500000e-07), SC_(-7.8536241199039907599248800693073983096345e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(1.0466960702615324407815933227539062500000e-06), SC_(-7.8536241199060714788476889345835975984184e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(2.9510883905459195375442504882812500000000e-06), SC_(-7.8536241199284946370316654999062188570463e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(4.8770834837341681122779846191406250000000e-06), SC_(-7.8536241199729001112516035986060087500198e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(9.0666326286736875772476196289062500000000e-06), SC_(-7.8536241201449549159755952954844380731418e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(2.3603533918503671884536743164062500000000e-05), SC_(-7.8536241215437180378560362500270281262505e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(6.0817910707555711269378662109375000000000e-05), SC_(-7.8536241307967596407834421160003079781623e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(1.1947672464884817600250244140625000000000e-04), SC_(-7.8536241619452548409979926475368621989964e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(2.4370866594836115837097167968750000000000e-04), SC_(-7.8536242948323003286224053216988930855360e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(4.7970912419259548187255859375000000000000e-04), SC_(-7.8536247976645144073074634875862774201818e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(9.6078845672309398651123046875000000000000e-04), SC_(-7.8536268386998788888163134075555165329902e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(1.1304812505841255187988281250000000000000e-03), SC_(-7.8536278838893538639749223653894915438564e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(3.3707786351442337036132812500000000000000e-03), SC_(-7.8536575844176695397200882069513152446755e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(7.6976269483566284179687500000000000000000e-03), SC_(-7.8537986421463962560905822510139694445886e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(1.5477418899536132812500000000000000000000e-02), SC_(-7.8543297597323325872109401753579247969996e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(3.0580729246139526367187500000000000000000e-02), SC_(-7.8563800652314045417041971119076973697391e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(3.4683167934417724609375000000000000000000e-02), SC_(-7.8571696826777312655783430985032793792979e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(9.2835962772369384765625000000000000000000e-02), SC_(-7.8791453309455206534625742760243878333456e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(2.2476321458816528320312500000000000000000e-01), SC_(-8.0072914547270791783894707537478515443766e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(4.5007002353668212890625000000000000000000e-01), SC_(-8.5390468871174588968639414462701177158352e+00) }}, 
      {{ SC_(-1.5605529785156250000000000000000000000000e+01), SC_(6.4851474761962890625000000000000000000000e-01), SC_(-9.5688145028458733856391297589630554846530e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6900929544760856515495106577873229980469e-09), SC_(-7.7102621318769358264739783085513078293889e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.1149908491224778117612004280090332031250e-09), SC_(-7.7102621318769358311993590729545391429197e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(7.0996275525203600409440696239471435546875e-09), SC_(-7.7102621318769359654445910023440919141982e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.3671879628418537322431802749633789062500e-08), SC_(-7.7102621318769363644421383686356634809673e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6793407553450379054993391036987304687500e-08), SC_(-7.7102621318769366423881871381530928899883e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(5.8676832281889801379293203353881835937500e-08), SC_(-7.7102621318769458809829907223976255767943e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.1404608812881633639335632324218750000000e-07), SC_(-7.7102621318769738325823588081245354455570e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.4555860161635791882872581481933593750000e-07), SC_(-7.7102621318769977428029034932844577690519e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(3.8918472000659676268696784973144531250000e-07), SC_(-7.7102621318773785079763534386826099350523e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.2378262555284891277551651000976562500000e-07), SC_(-7.7102621318780730644758702671802704488329e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.0466960702615324407815933227539062500000e-06), SC_(-7.7102621318801378761022168032640838679766e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.9510883905459195375442504882812500000000e-06), SC_(-7.7102621319023896070833438532787883699985e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(4.8770834837341681122779846191406250000000e-06), SC_(-7.7102621319464555971782442247198224367950e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.0666326286736875772476196289062500000000e-06), SC_(-7.7102621321171950263575573833198327101993e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.3603533918503671884536743164062500000000e-05), SC_(-7.7102621335052644695236604237289890089459e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.0817910707555711269378662109375000000000e-05), SC_(-7.7102621426875656787710284416390204758535e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.1947672464884817600250244140625000000000e-04), SC_(-7.7102621735979276362111335756488617977164e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4370866594836115837097167968750000000000e-04), SC_(-7.7102623054690388950764205048412191505629e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(4.7970912419259548187255859375000000000000e-04), SC_(-7.7102628044570526819692418206682410496465e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.6078845672309398651123046875000000000000e-04), SC_(-7.7102648298885116186371641831182360345320e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.1304812505841255187988281250000000000000e-03), SC_(-7.7102658670874185956042983530400239829324e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(3.3707786351442337036132812500000000000000e-03), SC_(-7.7102953405533400853077762376104308709146e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(7.6976269483566284179687500000000000000000e-03), SC_(-7.7104353199087876812582449742221819385682e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.5477418899536132812500000000000000000000e-02), SC_(-7.7109623774740450993192262713892694954824e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(3.0580729246139526367187500000000000000000e-02), SC_(-7.7129970146325284312779421824832442487961e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(3.4683167934417724609375000000000000000000e-02), SC_(-7.7137805998934622811549718993117638856182e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.2835962772369384765625000000000000000000e-02), SC_(-7.7355888210879261554101998085280228338561e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.2476321458816528320312500000000000000000e-01), SC_(-7.8627758733978314803431883871461063199135e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(4.5007002353668212890625000000000000000000e-01), SC_(-8.3908511887010372723798772317091543918816e+00) }}, 
      {{ SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.4851474761962890625000000000000000000000e-01), SC_(-9.4147063108553474119210040066897994009155e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6900929544760856515495106577873229980469e-09), SC_(-7.4843358701527580172845015870458159082054e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.1149908491224778117612004280090332031250e-09), SC_(-7.4843358701527580218860947325637098834597e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(7.0996275525203600409440696239471435546875e-09), SC_(-7.4843358701527581526145946913926492867230e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.3671879628418537322431802749633789062500e-08), SC_(-7.4843358701527585411598719037889251845575e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6793407553450379054993391036987304687500e-08), SC_(-7.4843358701527588118247551395249560408089e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(5.8676832281889801379293203353881835937500e-08), SC_(-7.4843358701527678084023098287860445435286e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.1404608812881633639335632324218750000000e-07), SC_(-7.4843358701527950277724455366228449083870e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.4555860161635791882872581481933593750000e-07), SC_(-7.4843358701528183116330383325659932075236e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(3.8918472000659676268696784973144531250000e-07), SC_(-7.4843358701531891021575603237175019732930e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.2378262555284891277551651000976562500000e-07), SC_(-7.4843358701538654638280161387317720014659e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.0466960702615324407815933227539062500000e-06), SC_(-7.4843358701558761849741631524859419522404e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.9510883905459195375442504882812500000000e-06), SC_(-7.4843358701775450023380474041909082058583e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(4.8770834837341681122779846191406250000000e-06), SC_(-7.4843358702204566253544797834078975607066e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.0666326286736875772476196289062500000000e-06), SC_(-7.4843358703867233086448443052203427272626e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.3603533918503671884536743164062500000000e-05), SC_(-7.4843358717384304310220535219015690263141e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.0817910707555711269378662109375000000000e-05), SC_(-7.4843358806801890768829764554614554405761e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.1947672464884817600250244140625000000000e-04), SC_(-7.4843359107808130917585289848892905656097e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4370866594836115837097167968750000000000e-04), SC_(-7.4843360391973856491738915343322157737845e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(4.7970912419259548187255859375000000000000e-04), SC_(-7.4843365251137467621092525573559731317598e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.6078845672309398651123046875000000000000e-04), SC_(-7.4843384974863479913796040324613493085283e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.1304812505841255187988281250000000000000e-03), SC_(-7.4843395075144600201875353854260772805654e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(3.3707786351442337036132812500000000000000e-03), SC_(-7.4843682088849130970954486304876274152032e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(7.6976269483566284179687500000000000000000e-03), SC_(-7.4845045213240086061763990418354530116388e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.5477418899536132812500000000000000000000e-02), SC_(-7.4850177723726286761361963518065111193347e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(3.0580729246139526367187500000000000000000e-02), SC_(-7.4869991164290587497275057993205039592557e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(3.4683167934417724609375000000000000000000e-02), SC_(-7.4877621794849276449398957172370474971148e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.2835962772369384765625000000000000000000e-02), SC_(-7.5089997288168637556524175283093556945504e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.2476321458816528320312500000000000000000e-01), SC_(-7.6328775224168531769647589733249883442265e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(4.5007002353668212890625000000000000000000e-01), SC_(-8.1475705164514879311256745039621254807800e+00) }}, 
      {{ SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.4851474761962890625000000000000000000000e-01), SC_(-9.1472315467572231336049240957267524532702e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(1.6900929544760856515495106577873229980469e-09), SC_(-6.6545161254090465431688754618979582073025e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(2.1149908491224778117612004280090332031250e-09), SC_(-6.6545161254090465471396108855980476486447e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(7.0996275525203600409440696239471435546875e-09), SC_(-6.6545161254090466599458215301238788482933e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(1.3671879628418537322431802749633789062500e-08), SC_(-6.6545161254090469952232889527668793134941e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(1.6793407553450379054993391036987304687500e-08), SC_(-6.6545161254090472287812341749812794353869e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(5.8676832281889801379293203353881835937500e-08), SC_(-6.6545161254090549919684736346897911637097e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(1.1404608812881633639335632324218750000000e-07), SC_(-6.6545161254090784796853992246529527838179e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(1.4555860161635791882872581481933593750000e-07), SC_(-6.6545161254090985714334379148446941667679e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(3.8918472000659676268696784973144531250000e-07), SC_(-6.6545161254094185282449013281587596355616e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(6.2378262555284891277551651000976562500000e-07), SC_(-6.6545161254100021637726810427674612670291e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(1.0466960702615324407815933227539062500000e-06), SC_(-6.6545161254117372240941189281286826552823e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(2.9510883905459195375442504882812500000000e-06), SC_(-6.6545161254304353440659507327922090902769e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(4.8770834837341681122779846191406250000000e-06), SC_(-6.6545161254674639765876482788587402228090e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(9.0666326286736875772476196289062500000000e-06), SC_(-6.6545161256109362454831233214016409815585e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(2.3603533918503671884536743164062500000000e-05), SC_(-6.6545161267773304014890316646971922568044e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(6.0817910707555711269378662109375000000000e-05), SC_(-6.6545161344932141575380195810118844890981e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(1.1947672464884817600250244140625000000000e-04), SC_(-6.6545161604671780099227634791276612753094e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(2.4370866594836115837097167968750000000000e-04), SC_(-6.6545162712784160006171452995008225811903e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(4.7970912419259548187255859375000000000000e-04), SC_(-6.6545166905778282209528788970515666214546e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(9.6078845672309398651123046875000000000000e-04), SC_(-6.6545183925469937416812002106008652850334e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(1.1304812505841255187988281250000000000000e-03), SC_(-6.6545192641047713511753484552424012480380e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(3.3707786351442337036132812500000000000000e-03), SC_(-6.6545440306426071629934103815972988892192e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(7.6976269483566284179687500000000000000000e-03), SC_(-6.6546616551578316783810626020383541167792e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(1.5477418899536132812500000000000000000000e-02), SC_(-6.6551045401771755387880172780174964414980e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(3.0580729246139526367187500000000000000000e-02), SC_(-6.6568142262931336104556027158528913222875e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(3.4683167934417724609375000000000000000000e-02), SC_(-6.6574726596021050234347769507072715929195e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(9.2835962772369384765625000000000000000000e-02), SC_(-6.6757964241852907755308049219960749866581e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(2.2476321458816528320312500000000000000000e-01), SC_(-6.7826116429864763632478157054470679624122e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(4.5007002353668212890625000000000000000000e-01), SC_(-7.2252022844817872320166023869201100802862e+00) }}, 
      {{ SC_(-1.3695476531982421875000000000000000000000e+01), SC_(6.4851474761962890625000000000000000000000e-01), SC_(-8.0793584334246047198016948545897396776123e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(1.6900929544760856515495106577873229980469e-09), SC_(-6.2828359338689295803673888298378969095068e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(2.1149908491224778117612004280090332031250e-09), SC_(-6.2828359338689295841768165909998547225457e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(7.0996275525203600409440696239471435546875e-09), SC_(-6.2828359338689296924003733396646679854548e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(1.3671879628418537322431802749633789062500e-08), SC_(-6.2828359338689300140574861426451512492274e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(1.6793407553450379054993391036987304687500e-08), SC_(-6.2828359338689302381273435949880406074328e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(5.8676832281889801379293203353881835937500e-08), SC_(-6.2828359338689376859418740172889780448461e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(1.1404608812881633639335632324218750000000e-07), SC_(-6.2828359338689602194907900717007527479834e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(1.4555860161635791882872581481933593750000e-07), SC_(-6.2828359338689794950290926304080032837596e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(3.8918472000659676268696784973144531250000e-07), SC_(-6.2828359338692864538742190617783370094620e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(6.2378262555284891277551651000976562500000e-07), SC_(-6.2828359338698463797178434370457366528305e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(1.0466960702615324407815933227539062500000e-06), SC_(-6.2828359338715109547273808538075998182456e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(2.9510883905459195375442504882812500000000e-06), SC_(-6.2828359338894494798875043055259397508559e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(4.8770834837341681122779846191406250000000e-06), SC_(-6.2828359339249738565166089166017474325375e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(9.0666326286736875772476196289062500000000e-06), SC_(-6.2828359340626176896527894995228383257085e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(2.3603533918503671884536743164062500000000e-05), SC_(-6.2828359351816281006320737319587368828613e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(6.0817910707555711269378662109375000000000e-05), SC_(-6.2828359425840608105968428531404555714583e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(1.1947672464884817600250244140625000000000e-04), SC_(-6.2828359675028550439764405638117526267674e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(2.4370866594836115837097167968750000000000e-04), SC_(-6.2828360738124832139134447288604851185429e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(4.7970912419259548187255859375000000000000e-04), SC_(-6.2828364760782233725355970658665818408808e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(9.6078845672309398651123046875000000000000e-04), SC_(-6.2828381089063887029137905330570384000773e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(1.1304812505841255187988281250000000000000e-03), SC_(-6.2828389450579040295148764207499282453148e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(3.3707786351442337036132812500000000000000e-03), SC_(-6.2828627054787193611709311052021617269494e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(7.6976269483566284179687500000000000000000e-03), SC_(-6.2829755516529755289869725565207645349772e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(1.5477418899536132812500000000000000000000e-02), SC_(-6.2834004456888766637143653669008458752668e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(3.0580729246139526367187500000000000000000e-02), SC_(-6.2850406899613982314332514396806511365431e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(3.4683167934417724609375000000000000000000e-02), SC_(-6.2856723838696799696292986530580868337244e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(9.2835962772369384765625000000000000000000e-02), SC_(-6.3032529011328147487359704437038655365372e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(2.2476321458816528320312500000000000000000e-01), SC_(-6.4057697925221023349110620662867644114773e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(4.5007002353668212890625000000000000000000e-01), SC_(-6.8311741106979960892221843082344266910689e+00) }}, 
      {{ SC_(-1.2464721679687500000000000000000000000000e+01), SC_(6.4851474761962890625000000000000000000000e-01), SC_(-7.6549881634357611008358908276486752012727e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6900929544760856515495106577873229980469e-09), SC_(-5.6594132473990352523977534697268885105705e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.1149908491224778117612004280090332031250e-09), SC_(-5.6594132473990352558605168373670107502664e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(7.0996275525203600409440696239471435546875e-09), SC_(-5.6594132473990353542355461910384433268045e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.3671879628418537322431802749633789062500e-08), SC_(-5.6594132473990356466213156524620796189223e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6793407553450379054993391036987304687500e-08), SC_(-5.6594132473990358503004356737984236683049e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(5.8676832281889801379293203353881835937500e-08), SC_(-5.6594132473990426203511996913445889190624e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.1404608812881633639335632324218750000000e-07), SC_(-5.6594132473990631033089092344897285857011e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.4555860161635791882872581481933593750000e-07), SC_(-5.6594132473990806247405022266089332607957e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(3.8918472000659676268696784973144531250000e-07), SC_(-5.6594132473993596498095988800312679551077e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.2378262555284891277551651000976562500000e-07), SC_(-5.6594132473998686214508687171677244602020e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.0466960702615324407815933227539062500000e-06), SC_(-5.6594132474013817173085933582639926071532e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.9510883905459195375442504882812500000000e-06), SC_(-5.6594132474176878062249564442346518312171e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(4.8770834837341681122779846191406250000000e-06), SC_(-5.6594132474499794042711707592220909295584e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.0666326286736875772476196289062500000000e-06), SC_(-5.6594132475750974149144222595830635513667e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.3603533918503671884536743164062500000000e-05), SC_(-5.6594132485922759787562634683679241195458e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.0817910707555711269378662109375000000000e-05), SC_(-5.6594132553210747451494125226294845969430e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.1947672464884817600250244140625000000000e-04), SC_(-5.6594132779722164005200570380599121301977e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4370866594836115837097167968750000000000e-04), SC_(-5.6594133746074879569446150094599199180590e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(4.7970912419259548187255859375000000000000e-04), SC_(-5.6594137402663633046707123316045941797733e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.6078845672309398651123046875000000000000e-04), SC_(-5.6594152245044011262407661391403211108753e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.1304812505841255187988281250000000000000e-03), SC_(-5.6594159845647164388533013801634409465848e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(3.3707786351442337036132812500000000000000e-03), SC_(-5.6594375827481092825536078044146354433853e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(7.6976269483566284179687500000000000000000e-03), SC_(-5.6595401597610274533561746823805391222585e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.5477418899536132812500000000000000000000e-02), SC_(-5.6599263882297730933653002721737649992224e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(3.0580729246139526367187500000000000000000e-02), SC_(-5.6614173752544381093040919961314502081568e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(3.4683167934417724609375000000000000000000e-02), SC_(-5.6619915893892358765353379484406304090117e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.2835962772369384765625000000000000000000e-02), SC_(-5.6779729491212661686135567934902509188042e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.2476321458816528320312500000000000000000e-01), SC_(-5.7711858694364291735827885671985839819801e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(4.5007002353668212890625000000000000000000e-01), SC_(-6.1583762547144789038396109598765143104764e+00) }}, 
      {{ SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.4851474761962890625000000000000000000000e-01), SC_(-6.9100820040802293133574285608791477501184e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(1.6900929544760856515495106577873229980469e-09), SC_(-4.6560765929555429982697418972875158870921e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(2.1149908491224778117612004280090332031250e-09), SC_(-4.6560765929555430011188393054555411524637e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(7.0996275525203600409440696239471435546875e-09), SC_(-4.6560765929555430820599869967024595172887e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(1.3671879628418537322431802749633789062500e-08), SC_(-4.6560765929555433226295695857289345821781e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(1.6793407553450379054993391036987304687500e-08), SC_(-4.6560765929555434902129679702999989135958e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(5.8676832281889801379293203353881835937500e-08), SC_(-4.6560765929555490604850417659492189405415e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(1.1404608812881633639335632324218750000000e-07), SC_(-4.6560765929555659134823523057267735010902e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(1.4555860161635791882872581481933593750000e-07), SC_(-4.6560765929555803297909587491181772689385e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(3.8918472000659676268696784973144531250000e-07), SC_(-4.6560765929558099064373465015168453913002e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(6.2378262555284891277551651000976562500000e-07), SC_(-4.6560765929562286788540597949173391787460e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(1.0466960702615324407815933227539062500000e-06), SC_(-4.6560765929574736260331940576418303702231e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(2.9510883905459195375442504882812500000000e-06), SC_(-4.6560765929708899732497313955563238040994e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(4.8770834837341681122779846191406250000000e-06), SC_(-4.6560765929974589005864448418557140807158e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(9.0666326286736875772476196289062500000000e-06), SC_(-4.6560765931004036767643349874983825065836e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(2.3603533918503671884536743164062500000000e-05), SC_(-4.6560765939373193138426805807939904383752e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(6.0817910707555711269378662109375000000000e-05), SC_(-4.6560765994736500098167862087380529141609e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(1.1947672464884817600250244140625000000000e-04), SC_(-4.6560766181105888147717616987169140822374e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(2.4370866594836115837097167968750000000000e-04), SC_(-4.6560766976202960730679939145997346441418e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(4.7970912419259548187255859375000000000000e-04), SC_(-4.6560769984776295029698027186994873207049e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(9.6078845672309398651123046875000000000000e-04), SC_(-4.6560782196811258155027152676485103222122e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(1.1304812505841255187988281250000000000000e-03), SC_(-4.6560788450446374525093006592535686022915e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(3.3707786351442337036132812500000000000000e-03), SC_(-4.6560966156282346202853281443866516336116e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(7.6976269483566284179687500000000000000000e-03), SC_(-4.6561810140714145992167605873074085230223e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(1.5477418899536132812500000000000000000000e-02), SC_(-4.6564987953887106116328239169361571785383e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(3.0580729246139526367187500000000000000000e-02), SC_(-4.6577255473363407794352627056593266993484e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(3.4683167934417724609375000000000000000000e-02), SC_(-4.6581979969141308550566149209182048671427e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(9.2835962772369384765625000000000000000000e-02), SC_(-4.6713467576615013551694097433529905346970e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(2.2476321458816528320312500000000000000000e-01), SC_(-4.7480258741808745813249167311574513596541e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(4.5007002353668212890625000000000000000000e-01), SC_(-5.0662986124296308548307502146199148189434e+00) }}, 
      {{ SC_(-8.8600730895996093750000000000000000000000e+00), SC_(6.4851474761962890625000000000000000000000e-01), SC_(-5.6829696435063062655668487820874959505602e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(1.6900929544760856515495106577873229980469e-09), SC_(-4.1857273299432753485081363513452980045993e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(2.1149908491224778117612004280090332031250e-09), SC_(-4.1857273299432753510934566297095865198831e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(7.0996275525203600409440696239471435546875e-09), SC_(-4.1857273299432754245408543495415836612143e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(1.3671879628418537322431802749633789062500e-08), SC_(-4.1857273299432756428378555127826867941217e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(1.6793407553450379054993391036987304687500e-08), SC_(-4.1857273299432757949059304472292401696599e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(5.8676832281889801379293203353881835937500e-08), SC_(-4.1857273299432808494671774949457967234378e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(1.1404608812881633639335632324218750000000e-07), SC_(-4.1857273299432961421684987085125332375358e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(1.4555860161635791882872581481933593750000e-07), SC_(-4.1857273299433092237763344198584633792999e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(3.8918472000659676268696784973144531250000e-07), SC_(-4.1857273299435175455970077133412772646335e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(6.2378262555284891277551651000976562500000e-07), SC_(-4.1857273299438975469328148504559902293449e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(1.0466960702615324407815933227539062500000e-06), SC_(-4.1857273299450272335411003214133300622717e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(2.9510883905459195375442504882812500000000e-06), SC_(-4.1857273299572014591119963329388941860630e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(4.8770834837341681122779846191406250000000e-06), SC_(-4.1857273299813105634273086054548352080310e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(9.0666326286736875772476196289062500000000e-06), SC_(-4.1857273300747244343050013254970787923703e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(2.3603533918503671884536743164062500000000e-05), SC_(-4.1857273308341561622711245181333310057305e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(6.0817910707555711269378662109375000000000e-05), SC_(-4.1857273358579184160431754957543747778117e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(1.1947672464884817600250244140625000000000e-04), SC_(-4.1857273527693991141869071614981780975395e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(2.4370866594836115837097167968750000000000e-04), SC_(-4.1857274249178830593804332958959743651629e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(4.7970912419259548187255859375000000000000e-04), SC_(-4.1857276979210329040123138187989274661005e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(9.6078845672309398651123046875000000000000e-04), SC_(-4.1857288060622218925633382214989133608054e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(1.1304812505841255187988281250000000000000e-03), SC_(-4.1857293735279003763714166913526655761420e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(3.3707786351442337036132812500000000000000e-03), SC_(-4.1857454988643707864701944300915542258730e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(7.6976269483566284179687500000000000000000e-03), SC_(-4.1858220835110514120906613990904580854761e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(1.5477418899536132812500000000000000000000e-02), SC_(-4.1861104444010481805820447775601589963776e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(3.0580729246139526367187500000000000000000e-02), SC_(-4.1872236298310440952412376734535855838659e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(3.4683167934417724609375000000000000000000e-02), SC_(-4.1876523454049459426502493768230331934946e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(9.2835962772369384765625000000000000000000e-02), SC_(-4.1995846133469030846768955184098912275186e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(2.2476321458816528320312500000000000000000e-01), SC_(-4.2691954868652964379930426265493526557413e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(4.5007002353668212890625000000000000000000e-01), SC_(-4.5586168844097061652355818767562373094147e+00) }}, 
      {{ SC_(-8.1188240051269531250000000000000000000000e+00), SC_(6.4851474761962890625000000000000000000000e-01), SC_(-5.1217608915437394749612541150795542371593e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(1.6900929544760856515495106577873229980469e-09), SC_(-3.7482808079358339480636318361918089537622e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(2.1149908491224778117612004280090332031250e-09), SC_(-3.7482808079358339503016065489928205467472e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(7.0996275525203600409440696239471435546875e-09), SC_(-3.7482808079358340138811251848890415902045e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(1.3671879628418537322431802749633789062500e-08), SC_(-3.7482808079358342028492668004895501274777e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(1.6793407553450379054993391036987304687500e-08), SC_(-3.7482808079358343344865378866627993187677e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(5.8676832281889801379293203353881835937500e-08), SC_(-3.7482808079358387099522586575281108669056e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(1.1404608812881633639335632324218750000000e-07), SC_(-3.7482808079358519480331005980301193372931e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(1.4555860161635791882872581481933593750000e-07), SC_(-3.7482808079358632720875259261105831209822e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(3.8918472000659676268696784973144531250000e-07), SC_(-3.7482808079360436052441924840915500228808e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(6.2378262555284891277551651000976562500000e-07), SC_(-3.7482808079363725522560903807335943329352e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(1.0466960702615324407815933227539062500000e-06), SC_(-3.7482808079373504620662947643254185437527e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(2.9510883905459195375442504882812500000000e-06), SC_(-3.7482808079478890437668315066489684702776e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(4.8770834837341681122779846191406250000000e-06), SC_(-3.7482808079687590173083919909355107714711e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(9.0666326286736875772476196289062500000000e-06), SC_(-3.7482808080496224533005658324791711259086e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(2.3603533918503671884536743164062500000000e-05), SC_(-3.7482808087070222414401020436291199199910e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(6.0817910707555711269378662109375000000000e-05), SC_(-3.7482808130558269061417942869665256161114e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(1.1947672464884817600250244140625000000000e-04), SC_(-3.7482808276951992362508277883031102507919e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(2.4370866594836115837097167968750000000000e-04), SC_(-3.7482808901503170012420298514298789157401e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(4.7970912419259548187255859375000000000000e-04), SC_(-3.7482811264746703677766214446663752410566e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(9.6078845672309398651123046875000000000000e-04), SC_(-3.7482820857337355000586303679207020356876e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(1.1304812505841255187988281250000000000000e-03), SC_(-3.7482825769586737084027487669282634030556e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(3.3707786351442337036132812500000000000000e-03), SC_(-3.7482965358047945427486632542079411271024e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(7.6976269483566284179687500000000000000000e-03), SC_(-3.7483628309984452200745406634863924518430e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(1.5477418899536132812500000000000000000000e-02), SC_(-3.7486124485377750368153067963290462930884e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(3.0580729246139526367187500000000000000000e-02), SC_(-3.7495760559838061210007728764835872222803e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(3.4683167934417724609375000000000000000000e-02), SC_(-3.7499471595907809385468485320196396937926e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(9.2835962772369384765625000000000000000000e-02), SC_(-3.7602746552700541271919901258254563540874e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(2.2476321458816528320312500000000000000000e-01), SC_(-3.8204740943152470645494251175866190751639e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(4.5007002353668212890625000000000000000000e-01), SC_(-4.0698489641237441713018016378443582204615e+00) }}, 
      {{ SC_(-7.6733188629150390625000000000000000000000e+00), SC_(6.4851474761962890625000000000000000000000e-01), SC_(-4.5507163106291069946686588268889031073160e+00) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.6900929544760856515495106577873229980469e-09), SC_(-6.2304510947112120014969206029755621123789e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(2.1149908491224778117612004280090332031250e-09), SC_(-6.2304510947112120024376382312953774968043e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(7.0996275525203600409440696239471435546875e-09), SC_(-6.2304510947112120291628615498458070866872e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.3671879628418537322431802749633789062500e-08), SC_(-6.2304510947112121085943497573877856260040e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.6793407553450379054993391036987304687500e-08), SC_(-6.2304510947112121639271918785972558294469e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(5.8676832281889801379293203353881835937500e-08), SC_(-6.2304510947112140031247985783616425733934e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.1404608812881633639335632324218750000000e-07), SC_(-6.2304510947112195676631027443747518655742e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.4555860161635791882872581481933593750000e-07), SC_(-6.2304510947112243276532675242928699027208e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(3.8918472000659676268696784973144531250000e-07), SC_(-6.2304510947113001294835904661807696266419e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(6.2378262555284891277551651000976562500000e-07), SC_(-6.2304510947114384001490744858982320557917e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.0466960702615324407815933227539062500000e-06), SC_(-6.2304510947118494579649218120506578824059e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(2.9510883905459195375442504882812500000000e-06), SC_(-6.2304510947162792799492513805372401161877e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(4.8770834837341681122779846191406250000000e-06), SC_(-6.2304510947250518330529696708869595039172e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(9.0666326286736875772476196289062500000000e-06), SC_(-6.2304510947590422348593847333030214617820e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(2.3603533918503671884536743164062500000000e-05), SC_(-6.2304510950353758171114170746050060595924e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(6.0817910707555711269378662109375000000000e-05), SC_(-6.2304510968633666245723788458194550660008e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.1947672464884817600250244140625000000000e-04), SC_(-6.2304511030169283372045004127571316327221e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(2.4370866594836115837097167968750000000000e-04), SC_(-6.2304511292695164325293661964337345529438e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(4.7970912419259548187255859375000000000000e-04), SC_(-6.2304512286068569457363334858696669394152e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(9.6078845672309398651123046875000000000000e-04), SC_(-6.2304516318247471660153823651662653544365e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.1304812505841255187988281250000000000000e-03), SC_(-6.2304518383076427091757873215411573528739e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(3.3707786351442337036132812500000000000000e-03), SC_(-6.2304577057812463250513950354655671347572e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(7.6976269483566284179687500000000000000000e-03), SC_(-6.2304855716303620650695318930017025791259e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.5477418899536132812500000000000000000000e-02), SC_(-6.2305904825059546196153110416854926726407e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(3.0580729246139526367187500000000000000000e-02), SC_(-6.2309953131966554880130908451563521341683e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(3.4683167934417724609375000000000000000000e-02), SC_(-6.2311511532472844334711764557503746821249e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(9.2835962772369384765625000000000000000000e-02), SC_(-6.2354729275171593802177083499065688712669e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(2.2476321458816528320312500000000000000000e-01), SC_(-6.2600931847257232872403194568466513091566e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(4.5007002353668212890625000000000000000000e-01), SC_(-6.3524249253624354173400043472913431838930e-02) }}, 
      {{ SC_(-5.8497428894042968750000000000000000000000e-01), SC_(6.4851474761962890625000000000000000000000e-01), SC_(-6.4937416380573549473268550199954319347158e-02) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(1.6900929544760856515495106577873229980469e-09), SC_(1.0806264364664671552279627282136401947538e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(2.1149908491224778117612004280090332031250e-09), SC_(1.0806264364664671559357392598211237778523e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(7.0996275525203600409440696239471435546875e-09), SC_(1.0806264364664671760432458031218898322255e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(1.3671879628418537322431802749633789062500e-08), SC_(1.0806264364664672358058584421207182040892e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(1.6793407553450379054993391036987304687500e-08), SC_(1.0806264364664672774371470472703560426991e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(5.8676832281889801379293203353881835937500e-08), SC_(1.0806264364664686612114740318115858828984e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(1.1404608812881633639335632324218750000000e-07), SC_(1.0806264364664728478552684656160505998918e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(1.4555860161635791882872581481933593750000e-07), SC_(1.0806264364664764291736448746959859245828e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(3.8918472000659676268696784973144531250000e-07), SC_(1.0806264364665334609065903911931180719938e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(6.2378262555284891277551651000976562500000e-07), SC_(1.0806264364666374929020513002633767819306e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(1.0466960702615324407815933227539062500000e-06), SC_(1.0806264364669467643204156126922578523249e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(2.9510883905459195375442504882812500000000e-06), SC_(1.0806264364702796709709717762747727785332e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(4.8770834837341681122779846191406250000000e-06), SC_(1.0806264364768799589025176911647631686069e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(9.0666326286736875772476196289062500000000e-06), SC_(1.0806264365024536358226750661083034766337e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(2.3603533918503671884536743164062500000000e-05), SC_(1.0806264367103613209630616978268093026055e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(6.0817910707555711269378662109375000000000e-05), SC_(1.0806264380857038863442499626975566482281e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(1.1947672464884817600250244140625000000000e-04), SC_(1.0806264427155167797336950445115834801608e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(2.4370866594836115837097167968750000000000e-04), SC_(1.0806264624674230521665534794839111255626e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(4.7970912419259548187255859375000000000000e-04), SC_(1.0806265372067988829915026162652725115630e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(9.6078845672309398651123046875000000000000e-04), SC_(1.0806268405797916529929594822200794078377e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(1.1304812505841255187988281250000000000000e-03), SC_(1.0806269959334301986148704377646792083837e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(3.3707786351442337036132812500000000000000e-03), SC_(1.0806314105270327231277752781764206580819e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(7.6976269483566284179687500000000000000000e-03), SC_(1.0806523769476055655062137371927841148786e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(1.5477418899536132812500000000000000000000e-02), SC_(1.0807313213679987810475741987234556389288e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(3.0580729246139526367187500000000000000000e-02), SC_(1.0810360843468692948533221268978871939951e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(3.4683167934417724609375000000000000000000e-02), SC_(1.0811534590570251652863929456972129718841e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(9.2835962772369384765625000000000000000000e-02), SC_(1.0844209400022459663035000509642831132376e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(2.2476321458816528320312500000000000000000e-01), SC_(1.1035074639993055527086845012276931279388e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(4.5007002353668212890625000000000000000000e-01), SC_(1.1833160041491633345513085376995760733901e+00) }}, 
      {{ SC_(1.8752593994140625000000000000000000000000e+00), SC_(6.4851474761962890625000000000000000000000e-01), SC_(1.3407149200686851587174286483077484944883e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(1.6900929544760856515495106577873229980469e-09), SC_(1.0929191209791892466700087669705896929350e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(2.1149908491224778117612004280090332031250e-09), SC_(1.0929191209791892473867904953650264751650e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(7.0996275525203600409440696239471435546875e-09), SC_(1.0929191209791892677501292755812019249125e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(1.3671879628418537322431802749633789062500e-08), SC_(1.0929191209791893282731148052922356897684e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(1.6793407553450379054993391036987304687500e-08), SC_(1.0929191209791893704340874698050123764608e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(5.8676832281889801379293203353881835937500e-08), SC_(1.0929191209791907718144801639962296433280e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(1.1404608812881633639335632324218750000000e-07), SC_(1.0929191209791950117258662204362736396327e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(1.4555860161635791882872581481933593750000e-07), SC_(1.0929191209791986386101455608398521546059e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(3.8918472000659676268696784973144531250000e-07), SC_(1.0929191209792563959703976353913129938571e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(6.2378262555284891277551651000976562500000e-07), SC_(1.0929191209793617515878627061679038670185e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(1.0466960702615324407815933227539062500000e-06), SC_(1.0929191209796749579346381450836305526874e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(2.9510883905459195375442504882812500000000e-06), SC_(1.0929191209830502698909942108078465986841e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(4.8770834837341681122779846191406250000000e-06), SC_(1.0929191209897345347404229099423036255041e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(9.0666326286736875772476196289062500000000e-06), SC_(1.0929191210156335911878011815271360157931e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(2.3603533918503671884536743164062500000000e-05), SC_(1.0929191212261865316236436057522821805418e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(6.0817910707555711269378662109375000000000e-05), SC_(1.0929191226190278835550160520708468317673e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(1.1947672464884817600250244140625000000000e-04), SC_(1.0929191273077469066979720577542750042358e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(2.4370866594836115837097167968750000000000e-04), SC_(1.0929191473109610358208378847966728206202e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(4.7970912419259548187255859375000000000000e-04), SC_(1.0929192230012624216687366728039457674743e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(9.6078845672309398651123046875000000000000e-04), SC_(1.0929195302341367268603125365781779878042e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(1.1304812505841255187988281250000000000000e-03), SC_(1.0929196875643739422098696686261862512178e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(3.3707786351442337036132812500000000000000e-03), SC_(1.0929241583258385262568081127845051568753e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(7.6976269483566284179687500000000000000000e-03), SC_(1.0929453915071932986818649872469050105848e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(1.5477418899536132812500000000000000000000e-02), SC_(1.0930253403610983301551035631759805695869e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(3.0580729246139526367187500000000000000000e-02), SC_(1.0933339810014181648230652836495816466287e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(3.4683167934417724609375000000000000000000e-02), SC_(1.0934528491623904125187942735534334252246e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(9.2835962772369384765625000000000000000000e-02), SC_(1.0967619114895366171508834578743666878883e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(2.2476321458816528320312500000000000000000e-01), SC_(1.1160915748978438381072921795344859194350e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(4.5007002353668212890625000000000000000000e-01), SC_(1.1969206033424463133021517620479579624999e+00) }}, 
      {{ SC_(1.8888244628906250000000000000000000000000e+00), SC_(6.4851474761962890625000000000000000000000e-01), SC_(1.3563408416012793861644249967390987198898e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(1.6900929544760856515495106577873229980469e-09), SC_(2.8767799813845867884305969619199403866319e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(2.1149908491224778117612004280090332031250e-09), SC_(2.8767799813845867902395195626357804792126e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(7.0996275525203600409440696239471435546875e-09), SC_(2.8767799813845868416299251580419467423270e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(1.3671879628418537322431802749633789062500e-08), SC_(2.8767799813845869943701416709908928255199e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(1.6793407553450379054993391036987304687500e-08), SC_(2.8767799813845871007706445016540394012172e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(5.8676832281889801379293203353881835937500e-08), SC_(2.8767799813845906373963202465388151246480e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(1.1404608812881633639335632324218750000000e-07), SC_(2.8767799813846013375456508519398446329878e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(1.4555860161635791882872581481933593750000e-07), SC_(2.8767799813846104906151044716144228700571e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(3.8918472000659676268696784973144531250000e-07), SC_(2.8767799813847562512981393084383814918321e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(6.2378262555284891277551651000976562500000e-07), SC_(2.8767799813850221344114991159434890680829e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(1.0466960702615324407815933227539062500000e-06), SC_(2.8767799813858125647711551886356718802754e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(2.9510883905459195375442504882812500000000e-06), SC_(2.8767799813943307479787462549565114329110e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(4.8770834837341681122779846191406250000000e-06), SC_(2.8767799814111996458263206261677218188663e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(9.0666326286736875772476196289062500000000e-06), SC_(2.8767799814765603919068763398738548200127e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(2.3603533918503671884536743164062500000000e-05), SC_(2.8767799820079271350986380134397529896024e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(6.0817910707555711269378662109375000000000e-05), SC_(2.8767799855230030650228176936279485658089e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(1.1947672464884817600250244140625000000000e-04), SC_(2.8767799973557960480085525214899157554751e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(2.4370866594836115837097167968750000000000e-04), SC_(2.8767800478373647518092710370766083245435e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(4.7970912419259548187255859375000000000000e-04), SC_(2.8767802388549235875400529481356843136470e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(9.6078845672309398651123046875000000000000e-04), SC_(2.8767810142101735319951108835432530178803e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(1.1304812505841255187988281250000000000000e-03), SC_(2.8767814112602057455370347575888916803980e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(3.3707786351442337036132812500000000000000e-03), SC_(2.8767926939965369229099750912562564263573e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(7.6976269483566284179687500000000000000000e-03), SC_(2.8768462795185319064594284854401627800243e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(1.5477418899536132812500000000000000000000e-02), SC_(2.8770480429700963326422949055557319814248e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(3.0580729246139526367187500000000000000000e-02), SC_(2.8778269312123183255171406206737191657313e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(3.4683167934417724609375000000000000000000e-02), SC_(2.8781269017051963294046712275973741541488e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(9.2835962772369384765625000000000000000000e-02), SC_(2.8864761117700456576228760150877061908924e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(2.2476321458816528320312500000000000000000e-01), SC_(2.9351935116079805273625379676159217503103e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(4.5007002353668212890625000000000000000000e-01), SC_(3.1379021877755390844081419839366594988536e+00) }}, 
      {{ SC_(5.2943706512451171875000000000000000000000e+00), SC_(6.4851474761962890625000000000000000000000e-01), SC_(3.5328413237708909315076883006157250116118e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(1.6900929544760856515495106577873229980469e-09), SC_(4.6930319586107302536546915312818246736383e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(2.1149908491224778117612004280090332031250e-09), SC_(4.6930319586107302565103861990220114536513e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(7.0996275525203600409440696239471435546875e-09), SC_(4.6930319586107303376389580758572961967015e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(1.3671879628418537322431802749633789062500e-08), SC_(4.6930319586107305787655942696346396877486e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(1.6793407553450379054993391036987304687500e-08), SC_(4.6930319586107307467370422786089864745576e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(5.8676832281889801379293203353881835937500e-08), SC_(4.6930319586107363299074222722276281847494e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(1.1404608812881633639335632324218750000000e-07), SC_(4.6930319586107532219288804272533501243440e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(1.4555860161635791882872581481933593750000e-07), SC_(4.6930319586107676716193325304062808564327e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(3.8918472000659676268696784973144531250000e-07), SC_(4.6930319586109977798645078792231630254753e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(6.2378262555284891277551651000976562500000e-07), SC_(4.6930319586114175219744042831159077986445e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(1.0466960702615324407815933227539062500000e-06), SC_(4.6930319586126653519049919805505803212612e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(2.9510883905459195375442504882812500000000e-06), SC_(4.6930319586261127654953372470875214117690e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(4.8770834837341681122779846191406250000000e-06), SC_(4.6930319586527432148107970468868928133322e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(9.0666326286736875772476196289062500000000e-06), SC_(4.6930319587559263659238732604866648155054e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(2.3603533918503671884536743164062500000000e-05), SC_(4.6930319595947799324251901591526265431141e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(6.0817910707555711269378662109375000000000e-05), SC_(4.6930319651439303412329825095784077796088e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(1.1947672464884817600250244140625000000000e-04), SC_(4.6930319838240241192571323413827242155364e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(2.4370866594836115837097167968750000000000e-04), SC_(4.6930320635178409689620584809760112807763e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(4.7970912419259548187255859375000000000000e-04), SC_(4.6930323650718278918572353628089762138914e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(9.6078845672309398651123046875000000000000e-04), SC_(4.6930335891030942215329978953501083232908e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(1.1304812505841255187988281250000000000000e-03), SC_(4.6930342159146719261148922734416380544260e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(3.3707786351442337036132812500000000000000e-03), SC_(4.6930520276469072266246274986418002239015e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(7.6976269483566284179687500000000000000000e-03), SC_(4.6931366215135709502259979855551001335107e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(1.5477418899536132812500000000000000000000e-02), SC_(4.6934551385728934461291218596497299697184e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(3.0580729246139526367187500000000000000000e-02), SC_(4.6946847296207114954142328417538311968447e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(3.4683167934417724609375000000000000000000e-02), SC_(4.6951582721196476830658587105861937214160e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(9.2835962772369384765625000000000000000000e-02), SC_(4.7083373432504075355533500093722654238973e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(2.2476321458816528320312500000000000000000e-01), SC_(4.7851891815702436403709310050556607471303e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(4.5007002353668212890625000000000000000000e-01), SC_(5.1041103848076853469941644665766372160294e+00) }}, 
      {{ SC_(9.0335578918457031250000000000000000000000e+00), SC_(6.4851474761962890625000000000000000000000e-01), SC_(5.7217758637709515879494832991841844242487e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(1.6900929544760856515495106577873229980469e-09), SC_(6.2019245331642782688855399444333371443455e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(2.1149908491224778117612004280090332031250e-09), SC_(6.2019245331642782726804694996744449436137e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(7.0996275525203600409440696239471435546875e-09), SC_(6.2019245331642783804921409181524623157591e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(1.3671879628418537322431802749633789062500e-08), SC_(6.2019245331642787009250669535378990807391e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(1.6793407553450379054993391036987304687500e-08), SC_(6.2019245331642789241421425347766940386827e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(5.8676832281889801379293203353881835937500e-08), SC_(6.2019245331642863436112217522423474089935e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(1.1404608812881633639335632324218750000000e-07), SC_(6.2019245331643087914002670871600684803578e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(1.4555860161635791882872581481933593750000e-07), SC_(6.2019245331643279935782801045105342914567e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(3.8918472000659676268696784973144531250000e-07), SC_(6.2019245331646337841764085900461970643541e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(6.2378262555284891277551651000976562500000e-07), SC_(6.2019245331651915790122569328765570942800e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(1.0466960702615324407815933227539062500000e-06), SC_(6.2019245331668498188573623044057812289797e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(2.9510883905459195375442504882812500000000e-06), SC_(6.2019245331847200722328523094068310908044e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(4.8770834837341681122779846191406250000000e-06), SC_(6.2019245332201092475246793511637450144634e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(9.0666326286736875772476196289062500000000e-06), SC_(6.2019245333572292254359891479824701782051e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(2.3603533918503671884536743164062500000000e-05), SC_(6.2019245344719808226567093023333415801423e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(6.0817910707555711269378662109375000000000e-05), SC_(6.2019245418462407990046161809840266011442e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(1.1947672464884817600250244140625000000000e-04), SC_(6.2019245666701972168503661378645888409857e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(2.4370866594836115837097167968750000000000e-04), SC_(6.2019246725752242423674184251163334999466e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(4.7970912419259548187255859375000000000000e-04), SC_(6.2019250733099914635005799515332800036707e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(9.6078845672309398651123046875000000000000e-04), SC_(6.2019266999238199645613941551268825218421e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(1.1304812505841255187988281250000000000000e-03), SC_(6.2019275328930501459294167145162999757700e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(3.3707786351442337036132812500000000000000e-03), SC_(6.2019512028851651729248003244447403473537e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(7.6976269483566284179687500000000000000000e-03), SC_(6.2020636195940281350893842194511492755932e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(1.5477418899536132812500000000000000000000e-02), SC_(6.2024868967441244685206060971935958891410e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(3.0580729246139526367187500000000000000000e-02), SC_(6.2041209016060001779476354745691921543713e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(3.4683167934417724609375000000000000000000e-02), SC_(6.2047501935770460978087913067932458124690e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(9.2835962772369384765625000000000000000000e-02), SC_(6.2222640847962912574692199640467520471018e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(2.2476321458816528320312500000000000000000e-01), SC_(6.3244008571739074517124645255647588874376e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(4.5007002353668212890625000000000000000000e-01), SC_(6.7483709040594367935628681399618953531340e+00) }}, 
      {{ SC_(1.1924232482910156250000000000000000000000e+01), SC_(6.4851474761962890625000000000000000000000e-01), SC_(7.5699617696334243596770300509706974601701e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(1.6900929544760856515495106577873229980469e-09), SC_(6.2295678765104491137757659776451703826839e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(2.1149908491224778117612004280090332031250e-09), SC_(6.2295678765104491175778353780162336940014e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(7.0996275525203600409440696239471435546875e-09), SC_(6.2295678765104492255923455121870060357610e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(1.3671879628418537322431802749633789062500e-08), SC_(6.2295678765104495466281395147186169126276e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(1.6793407553450379054993391036987304687500e-08), SC_(6.2295678765104497702651795055234709382894e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(5.8676832281889801379293203353881835937500e-08), SC_(6.2295678765104572036933742746717699130341e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(1.1404608812881633639335632324218750000000e-07), SC_(6.2295678765104796937160724246334650435576e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(1.4555860161635791882872581481933593750000e-07), SC_(6.2295678765104989320213903563615464506636e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(3.8918472000659676268696784973144531250000e-07), SC_(6.2295678765108052979391607620991031052253e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(6.2378262555284891277551651000976562500000e-07), SC_(6.2295678765113641422197179652142486477962e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(1.0466960702615324407815933227539062500000e-06), SC_(6.2295678765130255019055239409398535185947e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(2.9510883905459195375442504882812500000000e-06), SC_(6.2295678765309293766802194641151619988844e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(4.8770834837341681122779846191406250000000e-06), SC_(6.2295678765663851337694631044858099741370e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(9.0666326286736875772476196289062500000000e-06), SC_(6.2295678767037630915436975097857460195393e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(2.3603533918503671884536743164062500000000e-05), SC_(6.2295678778206120014140217686028356673590e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(6.0817910707555711269378662109375000000000e-05), SC_(6.2295678852087460361143431408040807909388e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(1.1947672464884817600250244140625000000000e-04), SC_(6.2295679100794066682353211945447559751978e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(2.4370866594836115837097167968750000000000e-04), SC_(6.2295680161836852105333611869992147432887e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(4.7970912419259548187255859375000000000000e-04), SC_(6.2295684176724015669460059109685709427279e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(9.6078845672309398651123046875000000000000e-04), SC_(6.2295700473465676806955314138306987822014e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(1.1304812505841255187988281250000000000000e-03), SC_(6.2295708818829590347365995800579674669914e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(3.3707786351442337036132812500000000000000e-03), SC_(6.2295945964079834242182183013026757598076e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(7.6976269483566284179687500000000000000000e-03), SC_(6.2297072246137967616385024830658793472286e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(1.5477418899536132812500000000000000000000e-02), SC_(6.2301312980329412415131044059070933271983e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(3.0580729246139526367187500000000000000000e-02), SC_(6.2317683757459831068749447660902959038484e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(3.4683167934417724609375000000000000000000e-02), SC_(6.2323988507009072557199442179229668073370e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(9.2835962772369384765625000000000000000000e-02), SC_(6.2499455676727866552537512349332568270121e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(2.2476321458816528320312500000000000000000e-01), SC_(6.3522700484019511502932104459415293012305e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(4.5007002353668212890625000000000000000000e-01), SC_(6.7769549653883313516675813944923971033860e+00) }}, 
      {{ SC_(1.2011219024658203125000000000000000000000e+01), SC_(6.4851474761962890625000000000000000000000e-01), SC_(7.5996747776507331531028261370346886894312e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6900929544760856515495106577873229980469e-09), SC_(6.2831891426161814715874885711819943234873e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.1149908491224778117612004280090332031250e-09), SC_(6.2831891426161814753969180792187996898960e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(7.0996275525203600409440696239471435546875e-09), SC_(6.2831891426161815836205244555497743770207e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.3671879628418537322431802749633789062500e-08), SC_(6.2831891426161819052777847596131291462711e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6793407553450379054993391036987304687500e-08), SC_(6.2831891426161821293477449628211402975980e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(5.8676832281889801379293203353881835937500e-08), SC_(6.2831891426161895771656907011979150009371e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.1404608812881633639335632324218750000000e-07), SC_(6.2831891426162121107249398797153327773538e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.4555860161635791882872581481933593750000e-07), SC_(6.2831891426162313862720815489517510837301e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(3.8918472000659676268696784973144531250000e-07), SC_(6.2831891426165383452579689343037341694051e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.2378262555284891277551651000976562500000e-07), SC_(6.2831891426170982713583563810997161283803e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.0466960702615324407815933227539062500000e-06), SC_(6.2831891426187628471312116498680986141755e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.9510883905459195375442504882812500000000e-06), SC_(6.2831891426367013805173365823637895773350e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(4.8770834837341681122779846191406250000000e-06), SC_(6.2831891426722257734367199171442272747869e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.0666326286736875772476196289062500000000e-06), SC_(6.2831891428098696696917112731820732500356e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.3603533918503671884536743164062500000000e-05), SC_(6.2831891439288805938113574899662238090095e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.0817910707555711269378662109375000000000e-05), SC_(6.2831891513313166982816241262592180621961e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.1947672464884817600250244140625000000000e-04), SC_(6.2831891762501223585781033619692931769946e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4370866594836115837097167968750000000000e-04), SC_(6.2831892825597992785160711923027914545127e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(4.7970912419259548187255859375000000000000e-04), SC_(6.2831896848257239025806842314544383441356e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.6078845672309398651123046875000000000000e-04), SC_(6.2831913176546379922459606531696443879252e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.1304812505841255187988281250000000000000e-03), SC_(6.2831921538065367491548968375553049367602e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(3.3707786351442337036132812500000000000000e-03), SC_(6.2832159142382477215949075551670941582573e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(7.6976269483566284179687500000000000000000e-03), SC_(6.2833287604642490680491928243349847189137e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.5477418899536132812500000000000000000000e-02), SC_(6.2837536546949561840301652637953700602701e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(3.0580729246139526367187500000000000000000e-02), SC_(6.2853938997190909867651711763202642342533e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(3.4683167934417724609375000000000000000000e-02), SC_(6.2860255939166625844271731483395391064078e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.2835962772369384765625000000000000000000e-02), SC_(6.3036061191925631216068228022141769843301e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.2476321458816528320312500000000000000000e-01), SC_(6.4061230558683283699573547416965850155916e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(4.5007002353668212890625000000000000000000e-01), SC_(6.8315275385534985632697506868944682108965e+00) }}, 
      {{ SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.4851474761962890625000000000000000000000e-01), SC_(7.6553418276550558589039011974186448365625e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6900929544760856515495106577873229980469e-09), SC_(6.4513492216068756911845460493923125364808e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.1149908491224778117612004280090332031250e-09), SC_(6.4513492216068756950407683411935954433220e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(7.0996275525203600409440696239471435546875e-09), SC_(6.4513492216068758045937296250496526451712e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.3671879628418537322431802749633789062500e-08), SC_(6.4513492216068761302020378736749155307186e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6793407553450379054993391036987304687500e-08), SC_(6.4513492216068763570243412226961653051503e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(5.8676832281889801379293203353881835937500e-08), SC_(6.4513492216068838963268869298837136645946e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.1404608812881633639335632324218750000000e-07), SC_(6.4513492216069067066750786958276165799449e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.4555860161635791882872581481933593750000e-07), SC_(6.4513492216069262189916650914310128845346e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(3.8918472000659676268696784973144531250000e-07), SC_(6.4513492216072369484805689752206630927144e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.2378262555284891277551651000976562500000e-07), SC_(6.4513492216078037523827071137695413356613e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.0466960702615324407815933227539062500000e-06), SC_(6.4513492216094887748219292076515217694933e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.9510883905459195375442504882812500000000e-06), SC_(6.4513492216276476545649076436758753181760e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(4.8770834837341681122779846191406250000000e-06), SC_(6.4513492216636084081605330855623121000316e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.0666326286736875772476196289062500000000e-06), SC_(6.4513492218029430408001067433020365671406e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.3603533918503671884536743164062500000000e-05), SC_(6.4513492229356992346723832688507549786841e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.0817910707555711269378662109375000000000e-05), SC_(6.4513492304290624952324171788140268954563e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.1947672464884817600250244140625000000000e-04), SC_(6.4513492556539560554875750925899447558480e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4370866594836115837097167968750000000000e-04), SC_(6.4513493632694782720008966124484255977015e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(4.7970912419259548187255859375000000000000e-04), SC_(6.4513497704765996356709822384326610180669e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.6078845672309398651123046875000000000000e-04), SC_(6.4513514233622129378706002623390835540720e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.1304812505841255187988281250000000000000e-03), SC_(6.4513522697849008161095439684342765669705e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(3.3707786351442337036132812500000000000000e-03), SC_(6.4513763220745388733758478575986870124730e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(7.6976269483566284179687500000000000000000e-03), SC_(6.4514905544053321361124648432246002948574e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.5477418899536132812500000000000000000000e-02), SC_(6.4519206672817593632496438364400432364286e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(3.0580729246139526367187500000000000000000e-02), SC_(6.4535810524531510574451782538858612482267e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(3.4683167934417724609375000000000000000000e-02), SC_(6.4542205006435678956384276491719096455278e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.2835962772369384765625000000000000000000e-02), SC_(6.4720162867621837839422562732762965755256e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.2476321458816528320312500000000000000000e-01), SC_(6.5757679464083309714737662563168220048788e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(4.5007002353668212890625000000000000000000e-01), SC_(7.0059370626712629985273249604283101867701e+00) }}, 
      {{ SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.4851474761962890625000000000000000000000e-01), SC_(7.8375014538551344426965584894986174491450e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6900929544760856515495106577873229980469e-09), SC_(7.8993027139712729689184780948810342346905e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.1149908491224778117612004280090332031250e-09), SC_(7.8993027139712729736858537523899432852480e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(7.0996275525203600409440696239471435546875e-09), SC_(7.8993027139712731091241353947868254778437e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.3671879628418537322431802749633789062500e-08), SC_(7.8993027139712735116676106315472864499807e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6793407553450379054993391036987304687500e-08), SC_(7.8993027139712737920837914791292167702310e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(5.8676832281889801379293203353881835937500e-08), SC_(7.8993027139712831127828360900091686655371e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.1404608812881633639335632324218750000000e-07), SC_(7.8993027139713113127906364523517165969240e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.4555860161635791882872581481933593750000e-07), SC_(7.8993027139713354355035084164603517137220e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(3.8918472000659676268696784973144531250000e-07), SC_(7.8993027139717195845720463196387431104820e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.2378262555284891277551651000976562500000e-07), SC_(7.8993027139724203136590026157110955862641e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.0466960702615324407815933227539062500000e-06), SC_(7.8993027139745034754560242733406198653546e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.9510883905459195375442504882812500000000e-06), SC_(7.8993027139969529596152665563546091825821e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(4.8770834837341681122779846191406250000000e-06), SC_(7.8993027140414105682137062050488728416204e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.0666326286736875772476196289062500000000e-06), SC_(7.8993027142136673743906660683399274567524e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.3603533918503671884536743164062500000000e-05), SC_(7.8993027156140727182558844448718933441608e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.0817910707555711269378662109375000000000e-05), SC_(7.8993027248779778820548703566944244951575e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.1947672464884817600250244140625000000000e-04), SC_(7.8993027560630430649748930348238876833507e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4370866594836115837097167968750000000000e-04), SC_(7.8993028891061049762324853829526387274492e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(4.7970912419259548187255859375000000000000e-04), SC_(7.8993033925286706211389265998053050134741e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.6078845672309398651123046875000000000000e-04), SC_(7.8993054359603173627071513167459522938201e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.1304812505841255187988281250000000000000e-03), SC_(7.8993064823768988130371385886260623930941e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(3.3707786351442337036132812500000000000000e-03), SC_(7.8993362177749918195520018929900683926421e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(7.6976269483566284179687500000000000000000e-03), SC_(7.8994774411072345097070588593027612958017e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.5477418899536132812500000000000000000000e-02), SC_(7.9000091821620803492559253736550144869220e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(3.0580729246139526367187500000000000000000e-02), SC_(7.9020618934431437453784143607127899112219e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(3.4683167934417724609375000000000000000000e-02), SC_(7.9028524369712220206487374358887014105738e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.2835962772369384765625000000000000000000e-02), SC_(7.9248537614955567068868576026278739828482e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.2476321458816528320312500000000000000000e-01), SC_(8.0531459382087377065723709570276732585828e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(4.5007002353668212890625000000000000000000e-01), SC_(8.5854457571722943867854563671039441714470e+00) }}, 
      {{ SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.4851474761962890625000000000000000000000e-01), SC_(9.6160362046370378730889649756995027841578e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6900929544760856515495106577873229980469e-09), SC_(8.0183848962969513226912974645250151373839e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.1149908491224778117612004280090332031250e-09), SC_(8.0183848962969513274982200939571186604168e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(7.0996275525203600409440696239471435546875e-09), SC_(8.0183848962969514640600074775055864929981e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.3671879628418537322431802749633789062500e-08), SC_(8.0183848962969518699427151676556395881103e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6793407553450379054993391036987304687500e-08), SC_(8.0183848962969521526850418085362220535483e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(5.8676832281889801379293203353881835937500e-08), SC_(8.0183848962969615507023952548433650440221e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.1404608812881633639335632324218750000000e-07), SC_(8.0183848962969899846386704916677391207612e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.4555860161635791882872581481933593750000e-07), SC_(8.0183848962970143074574953307630970904144e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(3.8918472000659676268696784973144531250000e-07), SC_(8.0183848962974016431707449551049389095544e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.2378262555284891277551651000976562500000e-07), SC_(8.0183848962981081850393065719455574730052e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.0466960702615324407815933227539062500000e-06), SC_(8.0183848963002086273585728930140871516693e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.9510883905459195375442504882812500000000e-06), SC_(8.0183848963228443374801713743043699276762e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(4.8770834837341681122779846191406250000000e-06), SC_(8.0183848963676707367771640718990759916567e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.0666326286736875772476196289062500000000e-06), SC_(8.0183848965413564706423606317612303745821e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.3603533918503671884536743164062500000000e-05), SC_(8.0183848979533786441394009745131808413685e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.0817910707555711269378662109375000000000e-05), SC_(8.0183849072941309924813819262312873334754e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.1947672464884817600250244140625000000000e-04), SC_(8.0183849387378866959475719617664516071670e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4370866594836115837097167968750000000000e-04), SC_(8.0183850728845851767251925367850224099978e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(4.7970912419259548187255859375000000000000e-04), SC_(8.0183855804832086255151015180397522789551e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.6078845672309398651123046875000000000000e-04), SC_(8.0183876408657968206792681319476294126386e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.1304812505841255187988281250000000000000e-03), SC_(8.0183886959627471944174015000937972568243e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(3.3707786351442337036132812500000000000000e-03), SC_(8.0184186780249430092771475799317134311350e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(7.6976269483566284179687500000000000000000e-03), SC_(8.0185610728267278779662857961015964849876e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.5477418899536132812500000000000000000000e-02), SC_(8.0190972244507488181666937524992241051245e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(3.0580729246139526367187500000000000000000e-02), SC_(8.0211669575797731055737246652955082204642e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(3.4683167934417724609375000000000000000000e-02), SC_(8.0219640546700637811783187376676992385812e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.2835962772369384765625000000000000000000e-02), SC_(8.0441473411835622519220950135870314544118e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.2476321458816528320312500000000000000000e-01), SC_(8.1734842282446373884601121875373442958163e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(4.5007002353668212890625000000000000000000e-01), SC_(8.7098307848897166646286539842573554043340e+00) }}, 
      {{ SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.4851474761962890625000000000000000000000e-01), SC_(9.7470524024218480313816574066580283888105e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(1.6900929544760856515495106577873229980469e-09), SC_(9.3689863127509946793128686280217905375143e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(2.1149908491224778117612004280090332031250e-09), SC_(9.3689863127509946850191583838848807719037e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(7.0996275525203600409440696239471435546875e-09), SC_(9.3689863127509948471314261407634657909968e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(1.3671879628418537322431802749633789062500e-08), SC_(9.3689863127509953289541047071338521949354e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(1.6793407553450379054993391036987304687500e-08), SC_(9.3689863127509956645970443669225970360364e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(5.8676832281889801379293203353881835937500e-08), SC_(9.3689863127510068209676131459498718222009e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(1.1404608812881633639335632324218750000000e-07), SC_(9.3689863127510405748454668896707463251384e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(1.4555860161635791882872581481933593750000e-07), SC_(9.3689863127510694484227206784377228402117e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(3.8918472000659676268696784973144531250000e-07), SC_(9.3689863127515292539954301726605562878663e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(6.2378262555284891277551651000976562500000e-07), SC_(9.3689863127523679886573895316193539319301e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(1.0466960702615324407815933227539062500000e-06), SC_(9.3689863127548614201962755226924749267217e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(2.9510883905459195375442504882812500000000e-06), SC_(9.3689863127817322335504793182540913729404e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(4.8770834837341681122779846191406250000000e-06), SC_(9.3689863128349455766433155048783436247275e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(9.0666326286736875772476196289062500000000e-06), SC_(9.3689863130411276187312313329326082405346e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(2.3603533918503671884536743164062500000000e-05), SC_(9.3689863147173367622615436282132125124035e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(6.0817910707555711269378662109375000000000e-05), SC_(9.3689863258057281401229831387146635749492e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(1.1947672464884817600250244140625000000000e-04), SC_(9.3689863631325575694012171809717076201919e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(2.4370866594836115837097167968750000000000e-04), SC_(9.3689865223778774018046868593237661103921e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(4.7970912419259548187255859375000000000000e-04), SC_(9.3689871249473488680722640981009612090141e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(9.6078845672309398651123046875000000000000e-04), SC_(9.3689895708240589772582725273926573350623e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(1.1304812505841255187988281250000000000000e-03), SC_(9.3689908233278816523981182220710854647745e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(3.3707786351442337036132812500000000000000e-03), SC_(9.3690264149850816954978118342051216098685e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(7.6976269483566284179687500000000000000000e-03), SC_(9.3691954516588217991450442094503722980531e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(1.5477418899536132812500000000000000000000e-02), SC_(9.3698319170561682355201920018678482110560e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(3.0580729246139526367187500000000000000000e-02), SC_(9.3722889045092022713649068602545178906292e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(3.4683167934417724609375000000000000000000e-02), SC_(9.3732351446524451315918228156749977483477e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(9.2835962772369384765625000000000000000000e-02), SC_(9.3995698519128100887476450752166487937303e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(2.2476321458816528320312500000000000000000e-01), SC_(9.5531398264081798506678520916237889617031e+00) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(4.5007002353668212890625000000000000000000e-01), SC_(1.0190477877609286264748348676092164730093e+01) }}, 
      {{ SC_(1.8286674499511718750000000000000000000000e+01), SC_(6.4851474761962890625000000000000000000000e-01), SC_(1.1425028281271019620211304278992477038315e+01) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(1.6900929544760856515495106577873229980469e-09), SC_(9.3727746832029842953435795501831249972630e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(2.1149908491224778117612004280090332031250e-09), SC_(9.3727746832029843010507227896446156975370e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(7.0996275525203600409440696239471435546875e-09), SC_(9.3727746832029844631872375033987849713368e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(1.3671879628418537322431802749633789062500e-08), SC_(9.3727746832029849450819817676372561663751e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(1.6793407553450379054993391036987304687500e-08), SC_(9.3727746832029852807751231795582353516660e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(5.8676832281889801379293203353881835937500e-08), SC_(9.3727746832029964388143382603873311706054e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(1.1404608812881633639335632324218750000000e-07), SC_(9.3727746832030301977407230747540302512019e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(1.4555860161635791882872581481933593750000e-07), SC_(9.3727746832030590756365666420959286066537e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(3.8918472000659676268696784973144531250000e-07), SC_(9.3727746832035189499818992505652587850449e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(6.2378262555284891277551651000976562500000e-07), SC_(9.3727746832043578100924965194013357430372e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(1.0466960702615324407815933227539062500000e-06), SC_(9.3727746832068516145712459279832716107688e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(2.9510883905459195375442504882812500000000e-06), SC_(9.3727746832337264469639939607156220298618e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(4.8770834837341681122779846191406250000000e-06), SC_(9.3727746832869477491191084890396435870643e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(9.0666326286736875772476196289062500000000e-06), SC_(9.3727746834931606296324684810824018372482e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(2.3603533918503671884536743164062500000000e-05), SC_(9.3727746851696204819547135819949632232163e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(6.0817910707555711269378662109375000000000e-05), SC_(9.3727746962596703385408177020754108648859e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(1.1947672464884817600250244140625000000000e-04), SC_(9.3727747335920827013577676750190960666117e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(2.4370866594836115837097167968750000000000e-04), SC_(9.3727748928612206835998712591434293896920e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(4.7970912419259548187255859375000000000000e-04), SC_(9.3727754955208178043238904918024176801116e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(9.6078845672309398651123046875000000000000e-04), SC_(9.3727779417633548767710973396215711027129e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(1.1304812505841255187988281250000000000000e-03), SC_(9.3727791944545130247118163878530368083840e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(3.3707786351442337036132812500000000000000e-03), SC_(9.3728147914350907790149787839849464896468e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(7.6976269483566284179687500000000000000000e-03), SC_(9.3729838533907199051251713446281232493147e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(1.5477418899536132812500000000000000000000e-02), SC_(9.3736204139716580307895897977368111577047e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(3.0580729246139526367187500000000000000000e-02), SC_(9.3760777687337670224493745890616925667507e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(3.4683167934417724609375000000000000000000e-02), SC_(9.3770241502790336510229437640091760359289e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(9.2835962772369384765625000000000000000000e-02), SC_(9.4033627802376448478668102083549421164429e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(2.2476321458816528320312500000000000000000e-01), SC_(9.5569551502445411840591558856285969273013e+00) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(4.5007002353668212890625000000000000000000e-01), SC_(1.0194377932119572071997766991106841556931e+01) }}, 
      {{ SC_(1.8300270080566406250000000000000000000000e+01), SC_(6.4851474761962890625000000000000000000000e-01), SC_(1.1429060314735059273078848118932676749938e+01) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(1.6900929544760856515495106577873229980469e-09), SC_(9.4193843529130724135977060716663787344005e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(2.1149908491224778117612004280090332031250e-09), SC_(9.4193843529130724193116845090942069983936e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(7.0996275525203600409440696239471435546875e-09), SC_(9.4193843529130725816423830954341785467371e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(1.3671879628418537322431802749633789062500e-08), SC_(9.4193843529130730641142717974026690138755e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(1.6793407553450379054993391036987304687500e-08), SC_(9.4193843529130734002094583273832283897468e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(5.8676832281889801379293203353881835937500e-08), SC_(9.4193843529130845716121731052045978555904e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(1.1404608812881633639335632324218750000000e-07), SC_(9.4193843529131183709701600871373017780184e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(1.4555860161635791882872581481933593750000e-07), SC_(9.4193843529131472834518072097936886197880e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(3.8918472000659676268696784973144531250000e-07), SC_(9.4193843529136077085687006674351822084038e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(6.2378262555284891277551651000976562500000e-07), SC_(9.4193843529144475733456750387504254536116e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(1.0466960702615324407815933227539062500000e-06), SC_(9.4193843529169443645459042446073646730526e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(2.9510883905459195375442504882812500000000e-06), SC_(9.4193843529438513837599756985327569298101e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(4.8770834837341681122779846191406250000000e-06), SC_(9.4193843529971364267607265425202688465980e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(9.0666326286736875772476196289062500000000e-06), SC_(9.4193843532035962794985964489603253794300e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(2.3603533918503671884536743164062500000000e-05), SC_(9.4193843548820639550852947442669135373272e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(6.0817910707555711269378662109375000000000e-05), SC_(9.4193843659853958834352286774858704751953e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(1.1947672464884817600250244140625000000000e-04), SC_(9.4193844033625196572286091073347591391414e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(2.4370866594836115837097167968750000000000e-04), SC_(9.4193845628224073726106575633359019812674e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(4.7970912419259548187255859375000000000000e-04), SC_(9.4193851662037836590152326842018224373985e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(9.6078845672309398651123046875000000000000e-04), SC_(9.4193876153760777303703074493054398714283e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(1.1304812505841255187988281250000000000000e-03), SC_(9.4193888695675281856211166702679300785536e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(3.3707786351442337036132812500000000000000e-03), SC_(9.4194245091808097761587926468504755583350e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(7.6976269483566284179687500000000000000000e-03), SC_(9.4195937736078158517475556428529594754431e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(1.5477418899536132812500000000000000000000e-02), SC_(9.4202310964614794935689256839805388219462e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(3.0580729246139526367187500000000000000000e-02), SC_(9.4226913926473265074957470934021021440356e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(3.4683167934417724609375000000000000000000e-02), SC_(9.4236389064807578350904158145771196616245e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(9.2835962772369384765625000000000000000000e-02), SC_(9.4500089335590732769670561845691247726318e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(2.2476321458816528320312500000000000000000e-01), SC_(9.6037800324564059246930644353038763013011e+00) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(4.5007002353668212890625000000000000000000e-01), SC_(1.0241871027027686622117307719738033539773e+01) }}, 
      {{ SC_(1.8595535278320312500000000000000000000000e+01), SC_(6.4851474761962890625000000000000000000000e-01), SC_(1.1477569618636525496405332879236487374151e+01) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(1.6900929544760856515495106577873229980469e-09), SC_(9.4238321373547555828763680755381696971188e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(2.1149908491224778117612004280090332031250e-09), SC_(9.4238321373547555885905031679013060547434e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(7.0996275525203600409440696239471435546875e-09), SC_(9.4238321373547557509256522269485229097303e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(1.3671879628418537322431802749633789062500e-08), SC_(9.4238321373547562334107684206445817424609e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(1.6793407553450379054993391036987304687500e-08), SC_(9.4238321373547565695151693658140995160458e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(5.8676832281889801379293203353881835937500e-08), SC_(9.4238321373547677412241603028384729435240e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(1.1404608812881633639335632324218750000000e-07), SC_(9.4238321373548015415087934555413266747911e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(1.4555860161635791882872581481933593750000e-07), SC_(9.4238321373548304547831077174992102215134e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(3.8918472000659676268696784973144531250000e-07), SC_(9.4238321373552908925230566680885171781389e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(6.2378262555284891277551651000976562500000e-07), SC_(9.4238321373561307803258376197399313616259e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(1.0466960702615324407815933227539062500000e-06), SC_(9.4238321373586276399783139302345555007681e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(2.9510883905459195375442504882812500000000e-06), SC_(9.4238321373855353968775902634202231507158e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(4.8770834837341681122779846191406250000000e-06), SC_(9.4238321374388219007457656910473768775021e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(9.0666326286736875772476196289062500000000e-06), SC_(9.4238321376452874138051132730599430028468e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(2.3603533918503671884536743164062500000000e-05), SC_(9.4238321393238011064091867656078871823199e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(6.0817910707555711269378662109375000000000e-05), SC_(9.4238321504274374446828930237054959767168e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(1.1947672464884817600250244140625000000000e-04), SC_(9.4238321878055859529776090189296670535853e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(2.4370866594836115837097167968750000000000e-04), SC_(9.4238323472698454344736767188997430205137e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(4.7970912419259548187255859375000000000000e-04), SC_(9.4238329506677640749252952988521606642257e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(9.6078845672309398651123046875000000000000e-04), SC_(9.4238353999072048235978981352716309133933e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(1.1304812505841255187988281250000000000000e-03), SC_(9.4238366541330402573078413332019624700309e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(3.3707786351442337036132812500000000000000e-03), SC_(9.4238722947234133356868640970553309593526e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(7.6976269483566284179687500000000000000000e-03), SC_(9.4240415637907945642912640235190712409402e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(1.5477418899536132812500000000000000000000e-02), SC_(9.4246789041142784741944402784805729452517e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(3.0580729246139526367187500000000000000000e-02), SC_(9.4271392677050899115012124453126631078777e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(3.4683167934417724609375000000000000000000e-02), SC_(9.4280868074828907052707918954730828619098e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(9.2835962772369384765625000000000000000000e-02), SC_(9.4544575533340052337167212758308852002632e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(2.2476321458816528320312500000000000000000e-01), SC_(9.6082327205570350997749324749537287175446e+00) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(4.5007002353668212890625000000000000000000e-01), SC_(1.0246338579906908109718828474723882986591e+01) }}, 
      {{ SC_(1.8707794189453125000000000000000000000000e+01), SC_(6.4851474761962890625000000000000000000000e-01), SC_(1.1482058768806297270078478485726068979469e+01) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6900929544760856515495106577873229980469e-09), SC_(9.4244940447630607868123462076739660848466e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.1149908491224778117612004280090332031250e-09), SC_(9.4244940447630607925264892325231877105318e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(7.0996275525203600409440696239471435546875e-09), SC_(9.4244940447630609548618636487399929832844e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3671879628418537322431802749633789062500e-08), SC_(9.4244940447630614373476496387234498125799e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6793407553450379054993391036987304687500e-08), SC_(9.4244940447630617734525171713013153828594e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(5.8676832281889801379293203353881835937500e-08), SC_(9.4244940447630729451770169166907046263157e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.1404608812881633639335632324218750000000e-07), SC_(9.4244940447631067455085723565283025253873e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.4555860161635791882872581481933593750000e-07), SC_(9.4244940447631356588230246520590963960853e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(3.8918472000659676268696784973144531250000e-07), SC_(9.4244940447635960972021632448671079468552e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.2378262555284891277551651000976562500000e-07), SC_(9.4244940447644359861708946336456141488035e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.0466960702615324407815933227539062500000e-06), SC_(9.4244940447669328492895655877685273137295e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.9510883905459195375442504882812500000000e-06), SC_(9.4244940447938406435427727850089161985284e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(4.8770834837341681122779846191406250000000e-06), SC_(9.4244940448471272213844268976928163999954e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.0666326286736875772476196289062500000000e-06), SC_(9.4244940450535930210636710784761835809056e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.3603533918503671884536743164062500000000e-05), SC_(9.4244940467321090438168030151114055369560e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.0817910707555711269378662109375000000000e-05), SC_(9.4244940578357607963989033846568818343174e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.1947672464884817600250244140625000000000e-04), SC_(9.4244940952139611938482987263258655150158e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4370866594836115837097167968750000000000e-04), SC_(9.4244942546784420470728658005520906439089e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(4.7970912419259548187255859375000000000000e-04), SC_(9.4244948580771983374340744230787032537537e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.6078845672309398651123046875000000000000e-04), SC_(9.4244973073200391709359536729228791234345e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.1304812505841255187988281250000000000000e-03), SC_(9.4244985615476157457624553885815114621355e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(3.3707786351442337036132812500000000000000e-03), SC_(9.4245342021874654799524571632947571209932e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(7.6976269483566284179687500000000000000000e-03), SC_(9.4247034714898195155831554338842769222569e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.5477418899536132812500000000000000000000e-02), SC_(9.4253408126979109039401068939923919775322e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(3.0580729246139526367187500000000000000000e-02), SC_(9.4278011797017912790804243557051027381358e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(3.4683167934417724609375000000000000000000e-02), SC_(9.4287487207932624468816210716997224425357e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.2835962772369384765625000000000000000000e-02), SC_(9.4551195030321948399769990227125879279454e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.2476321458816528320312500000000000000000e-01), SC_(9.6088948759735195682429231869911668209752e+00) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(4.5007002353668212890625000000000000000000e-01), SC_(1.0247001483510368300408632217413499502801e+01) }}, 
      {{ SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.4851474761962890625000000000000000000000e-01), SC_(1.1482722749835182286110171754705035575268e+01) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(1.6900929544760856515495106577873229980469e-09), SC_(9.4247722047965757235686124799438126842992e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(2.1149908491224778117612004280090332031250e-09), SC_(9.4247722047965757292827567387119248854906e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(7.0996275525203600409440696239471435546875e-09), SC_(9.4247722047965758916181662098239663696519e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(1.3671879628418537322431802749633789062500e-08), SC_(9.4247722047965763741040563883660886378026e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(1.6793407553450379054993391036987304687500e-08), SC_(9.4247722047965767102089964998317173069285e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(5.8676832281889801379293203353881835937500e-08), SC_(9.4247722047965878819359086807937889025163e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(1.1404608812881633639335632324218750000000e-07), SC_(9.4247722047966216822747630047217220593598e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(1.4555860161635791882872581481933593750000e-07), SC_(9.4247722047966505955954588760147410780088e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(3.8918472000659676268696784973144531250000e-07), SC_(9.4247722047971110340740250840389481294128e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(6.2378262555284891277551651000976562500000e-07), SC_(9.4247722047979509232241231029484248270084e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(1.0466960702615324407815933227539062500000e-06), SC_(9.4247722048004477868819696702662529206139e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(2.9510883905459195375442504882812500000000e-06), SC_(9.4247722048273555869456781952058399400044e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(4.8770834837341681122779846191406250000000e-06), SC_(9.4247722048806421762940997664009980375309e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(9.0666326286736875772476196289062500000000e-06), SC_(9.4247722050871080205578160819142513638216e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(2.3603533918503671884536743164062500000000e-05), SC_(9.4247722067656244057717087626656465949811e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(6.0817910707555711269378662109375000000000e-05), SC_(9.4247722178692785560896649092631704643585e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(1.1947672464884817600250244140625000000000e-04), SC_(9.4247722552474870250323447984337046362725e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(2.4370866594836115837097167968750000000000e-04), SC_(9.4247724147120023132063793625258371133468e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(4.7970912419259548187255859375000000000000e-04), SC_(9.4247730181108889021945234830645307443669e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(9.6078845672309398651123046875000000000000e-04), SC_(9.4247754673542586277514754920567142196631e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(1.1304812505841255187988281250000000000000e-03), SC_(9.4247767215821060416137599548081918747088e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(3.3707786351442337036132812500000000000000e-03), SC_(9.4248123622296519979388287873892847975299e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(7.6976269483566284179687500000000000000000e-03), SC_(9.4249816315685566487104406464964283639616e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(1.5477418899536132812500000000000000000000e-02), SC_(9.4256189729142507566744347546634240590998e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(3.0580729246139526367187500000000000000000e-02), SC_(9.4280793404490386581592725535513322240781e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(3.4683167934417724609375000000000000000000e-02), SC_(9.4290268817448517037292655459964361580191e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(9.2835962772369384765625000000000000000000e-02), SC_(9.4553976696436256506923240072221388916256e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(2.2476321458816528320312500000000000000000e-01), SC_(9.6091730745720840965751961378281053066292e+00) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(4.5007002353668212890625000000000000000000e-01), SC_(1.0247279798290689106503000903555377886952e+01) }}, 
      {{ SC_(1.8823707580566406250000000000000000000000e+01), SC_(6.4851474761962890625000000000000000000000e-01), SC_(1.1483001231499698630315369373375904196003e+01) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(1.6900929544760856515495106577873229980469e-09), SC_(9.4446643087556620575632109457720174042481e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(2.1149908491224778117612004280090332031250e-09), SC_(9.4446643087556620632787954338688988701362e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(7.0996275525203600409440696239471435546875e-09), SC_(9.4446643087556622256551209559643062184928e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(1.3671879628418537322431802749633789062500e-08), SC_(9.4446643087556627082626199526048170658002e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(1.6793407553450379054993391036987304687500e-08), SC_(9.4446643087556630444522740947934166861832e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(5.8676832281889801379293203353881835937500e-08), SC_(9.4446643087556742189949795115028521127597e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(1.1404608812881633639335632324218750000000e-07), SC_(9.4446643087557080278530866116690553029335e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(1.4555860161635791882872581481933593750000e-07), SC_(9.4446643087557369484612800630952375372503e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(3.8918472000659676268696784973144531250000e-07), SC_(9.4446643087561975029916942634646142560160e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(6.2378262555284891277551651000976562500000e-07), SC_(9.4446643087570376038328053382259527862068e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(1.0466960702615324407815933227539062500000e-06), SC_(9.4446643087595350968160779214909989135012e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(2.9510883905459195375442504882812500000000e-06), SC_(9.4446643087864496788931674946690258695747e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(4.8770834837341681122779846191406250000000e-06), SC_(9.4446643088397496989331034704732617811403e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(9.0666326286736875772476196289062500000000e-06), SC_(9.4446643090462675821637787039541494589690e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(2.3603533918503671884536743164062500000000e-05), SC_(9.4446643107252070313425428546493484894575e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(6.0817910707555711269378662109375000000000e-05), SC_(9.4446643218316598173971002418367974424180e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(1.1947672464884817600250244140625000000000e-04), SC_(9.4446643592192893280790700347293300277721e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(2.4370866594836115837097167968750000000000e-04), SC_(9.4446645187239970671589587113303344134733e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(4.7970912419259548187255859375000000000000e-04), SC_(9.4446651222749681322915500983923125232215e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(9.6078845672309398651123046875000000000000e-04), SC_(9.4446675721356603747866167372900738103194e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(1.1304812505841255187988281250000000000000e-03), SC_(9.4446688266796309876378451516545267691378e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(3.3707786351442337036132812500000000000000e-03), SC_(9.4447044763102109281577015220680656575534e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(7.6976269483566284179687500000000000000000e-03), SC_(9.4448737883111953821606853033028368320740e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(1.5477418899536132812500000000000000000000e-02), SC_(9.4455112902702871403796733601903653719889e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(3.0580729246139526367187500000000000000000e-02), SC_(9.4479722775344934246590390378767424782094e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(3.4683167934417724609375000000000000000000e-02), SC_(9.4489200573761935617153062358948497113145e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(9.2835962772369384765625000000000000000000e-02), SC_(9.4752974562993978022477085479470007660241e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(2.2476321458816528320312500000000000000000e-01), SC_(9.6291103626986495537946117037922160698815e+00) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(4.5007002353668212890625000000000000000000e-01), SC_(1.0267355316567780317788733241099718655876e+01) }}, 
      {{ SC_(1.9244384765625000000000000000000000000000e+01), SC_(6.4851474761962890625000000000000000000000e-01), SC_(1.1503281067912779764273515689185898594968e+01) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(1.6900929544760856515495106577873229980469e-09), SC_(9.6108406973889338055844671579084295261597e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(2.1149908491224778117612004280090332031250e-09), SC_(9.6108406973889338113535704558978826239277e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(7.0996275525203600409440696239471435546875e-09), SC_(9.6108406973889339752503332516910712236510e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(1.3671879628418537322431802749633789062500e-08), SC_(9.6108406973889344623768064749081539292232e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(1.6793407553450379054993391036987304687500e-08), SC_(9.6108406973889348017144274130308908468793e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(5.8676832281889801379293203353881835937500e-08), SC_(9.6108406973889460808917905682617365801205e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(1.1404608812881633639335632324218750000000e-07), SC_(9.6108406973889802063246685404255683482402e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(1.4555860161635791882872581481933593750000e-07), SC_(9.6108406973890093977357055341454431376106e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(3.8918472000659676268696784973144531250000e-07), SC_(9.6108406973894742647437691736668633829110e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(6.2378262555284891277551651000976562500000e-07), SC_(9.6108406973903222320064683888585293637160e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(1.0466960702615324407815933227539062500000e-06), SC_(9.6108406973928431106736475087645094755318e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(2.9510883905459195375442504882812500000000e-06), SC_(9.6108406974200097118407387026540657056288e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(4.8770834837341681122779846191406250000000e-06), SC_(9.6108406974738088153332420512016215417344e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(9.0666326286736875772476196289062500000000e-06), SC_(9.6108406976822604625306133961826174941486e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(2.3603533918503671884536743164062500000000e-05), SC_(9.6108406993769209357571737849968725766955e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(6.0817910707555711269378662109375000000000e-05), SC_(9.6108407105873708083249519954553738032763e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(1.1947672464884817600250244140625000000000e-04), SC_(9.6108407483250854991916492068365073384396e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(2.4370866594836115837097167968750000000000e-04), SC_(9.6108409093233416164715567647785185702091e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(4.7970912419259548187255859375000000000000e-04), SC_(9.6108415185257603954022309398094749087866e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(9.6078845672309398651123046875000000000000e-04), SC_(9.6108439913261158991419174058046461602226e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(1.1304812505841255187988281250000000000000e-03), SC_(9.6108452576172063862029464960665002526608e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(3.3707786351442337036132812500000000000000e-03), SC_(9.6108812410576712057507039833669631628670e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(7.6976269483566284179687500000000000000000e-03), SC_(9.6110521384058281672529762052450355196936e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(1.5477418899536132812500000000000000000000e-02), SC_(9.6116956091860575202038780621473066344686e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(3.0580729246139526367187500000000000000000e-02), SC_(9.6141796322202144275858191569455719714466e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(3.4683167934417724609375000000000000000000e-02), SC_(9.6151362810845327314537762056932361448658e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(9.2835962772369384765625000000000000000000e-02), SC_(9.6417599421159483793971631218230031812243e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(2.2476321458816528320312500000000000000000e-01), SC_(9.7969871367883594180454529616663577226964e+00) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(4.5007002353668212890625000000000000000000e-01), SC_(1.0440717922431910758288156431279958593266e+01) }}, 
      {{ SC_(1.9715248107910156250000000000000000000000e+01), SC_(6.4851474761962890625000000000000000000000e-01), SC_(1.1685666518693880867708987478704867925187e+01) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(1.6900929544760856515495106577873229980469e-09), SC_(9.7037884508903213882929851769049358839975e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(2.1149908491224778117612004280090332031250e-09), SC_(9.7037884508903213941110367135676132683908e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(7.0996275525203600409440696239471435546875e-09), SC_(9.7037884508903215593983895974067479601679e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(1.3671879628418537322431802749633789062500e-08), SC_(9.7037884508903220506579111721216650275154e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(1.6793407553450379054993391036987304687500e-08), SC_(9.7037884508903223928746587270744318168159e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(5.8676832281889801379293203353881835937500e-08), SC_(9.7037884508903337677507530528421825718405e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(1.1404608812881633639335632324218750000000e-07), SC_(9.7037884508903681827225328366973671008911e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(1.4555860161635791882872581481933593750000e-07), SC_(9.7037884508903976218095223731494824765825e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(3.8918472000659676268696784973144531250000e-07), SC_(9.7037884508908664330044182949358841675651e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(6.2378262555284891277551651000976562500000e-07), SC_(9.7037884508917215948867694314283391601802e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(1.0466960702615324407815933227539062500000e-06), SC_(9.7037884508942638620721105162237491820551e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(2.9510883905459195375442504882812500000000e-06), SC_(9.7037884509216609595935188150740736746088e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(4.8770834837341681122779846191406250000000e-06), SC_(9.7037884509759165242069493989180921991259e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(9.0666326286736875772476196289062500000000e-06), SC_(9.7037884511861367895849411368335869294642e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(2.3603533918503671884536743164062500000000e-05), SC_(9.7037884528951756923562620178125231568078e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(6.0817910707555711269378662109375000000000e-05), SC_(9.7037884642007411742909681304118303685862e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(1.1947672464884817600250244140625000000000e-04), SC_(9.7037885022586433476630918901822530697264e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(2.4370866594836115837097167968750000000000e-04), SC_(9.7037886646228970182664942687338933229896e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(4.7970912419259548187255859375000000000000e-04), SC_(9.7037892789941232733647420257807653452696e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(9.6078845672309398651123046875000000000000e-04), SC_(9.7037917727750709683579317258388292040361e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(1.1304812505841255187988281250000000000000e-03), SC_(9.7037930498100669383100334038643335965433e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(3.3707786351442337036132812500000000000000e-03), SC_(9.7038293385532813090566554404190669072476e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(7.6976269483566284179687500000000000000000e-03), SC_(9.7040016858748458327704247706248667993220e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(1.5477418899536132812500000000000000000000e-02), SC_(9.7046506159993990770373472738156154701166e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(3.0580729246139526367187500000000000000000e-02), SC_(9.7071557115847027366419558336421844257613e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(3.4683167934417724609375000000000000000000e-02), SC_(9.7081204748947710715456692851594495500141e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(9.2835962772369384765625000000000000000000e-02), SC_(9.7349697316093177706242812847197284550031e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(2.2476321458816528320312500000000000000000e-01), SC_(9.8915033186482039632092471512404270101860e+00) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(4.5007002353668212890625000000000000000000e-01), SC_(1.0540483903359546719391352849008609099627e+01) }}, 
      {{ SC_(1.9858451843261718750000000000000000000000e+01), SC_(6.4851474761962890625000000000000000000000e-01), SC_(1.1794772549994821404136319306287886692241e+01) }}
   }};
//#undef SC_

