/***************************************************************************

  cbedic.h

  This file is part of the CBE Dictionary package

  Copyright (c) 2003 Antoby - antoby@users.sourceforge.net

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/

#ifndef _CBEDIC_H_
#define _CBEDIC_H_


struct DICT_OPTIONS
{
    bool separate_meanings;
    bool latin_input;
    bool latin_output;
    bool html_output;
    bool exact_match;
};

enum INTERACTIVE_CMD
{
    NORMAL_WORD         = 0,
    CMD_HELP            = 100,
    CMD_STATUS,
    CMD_QUIT,
    CMD_TOG_SEPARATE    = 200,
    CMD_TOG_LATININ,
    CMD_TOG_LATINOUT,
    CMD_TOG_HTML,
    CMD_TOG_EXACT,
    CMD_UNKNOWN         = 300
};


int interactive_loop(Translator *dict, int exact_match);
INTERACTIVE_CMD check_word(const char *word);
void cbeconfig();
const char *get_home();
void init_globals();


#endif // _CBEDIC_H_
