/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SequenceUtil {
    public static final byte a = 97;
    public static final byte c = 99;
    public static final byte g = 103;
    public static final byte t = 116;
    public static final byte n = 110;
    public static final byte A = 65;
    public static final byte C = 67;
    public static final byte G = 71;
    public static final byte T = 84;
    public static final byte N = 78;
    public static final byte[] VALID_BASES_UPPER = new byte[]{65, 67, 71, 84};
    public static final byte[] VALID_BASES_LOWER = new byte[]{97, 99, 103, 116};
    static final Pattern mdPat = Pattern.compile("\\G(?:([0-9]+)|([ACTGNactgn])|(\\^[ACTGNactgn]+))");

    public static String reverseComplement(String sequenceData) {
        byte[] bases = StringUtil.stringToBytes(sequenceData);
        SequenceUtil.reverseComplement(bases);
        return StringUtil.bytesToString(bases);
    }

    public static boolean basesEqual(byte lhs, byte rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs > 90) {
            lhs = (byte)(lhs - 32);
        }
        if (rhs > 90) {
            rhs = (byte)(rhs - 32);
        }
        return lhs == rhs;
    }

    public static boolean isNoCall(byte base) {
        return base == 78 || base == 110 || base == 46;
    }

    public static boolean isValidBase(byte b) {
        for (byte validBase : VALID_BASES_UPPER) {
            if (b != validBase) continue;
            return true;
        }
        for (byte validBase : VALID_BASES_LOWER) {
            if (b != validBase) continue;
            return true;
        }
        return false;
    }

    public static double calculateGc(byte[] bases) {
        int gcs = 0;
        for (int i = 0; i < bases.length; ++i) {
            byte b = bases[i];
            if (b != 67 && b != 71 && b != 99 && b != 103) continue;
            ++gcs;
        }
        return (double)gcs / (double)bases.length;
    }

    public static void assertSequenceListsEqual(List<SAMSequenceRecord> s1, List<SAMSequenceRecord> s2) {
        if (s1 != null && s2 != null) {
            if (s1.size() != s2.size()) {
                throw new SequenceListsDifferException("Sequence dictionaries are not the same size (" + s1.size() + ", " + s2.size() + ")");
            }
            for (int i = 0; i < s1.size(); ++i) {
                if (s1.get(i).isSameSequence(s2.get(i))) continue;
                String s1Attrs = "";
                for (Map.Entry<String, String> entry : s1.get(i).getAttributes()) {
                    s1Attrs = s1Attrs + "/" + entry.getKey() + "=" + entry.getValue();
                }
                String s2Attrs = "";
                for (Map.Entry<String, String> entry : s2.get(i).getAttributes()) {
                    s2Attrs = s2Attrs + "/" + entry.getKey() + "=" + entry.getValue();
                }
                throw new SequenceListsDifferException("Sequences at index " + i + " don't match: " + s1.get(i).getSequenceIndex() + "/" + s1.get(i).getSequenceLength() + "/" + s1.get(i).getSequenceName() + s1Attrs + " " + s2.get(i).getSequenceIndex() + "/" + s2.get(i).getSequenceLength() + "/" + s2.get(i).getSequenceName() + s2Attrs);
            }
        }
    }

    public static boolean areSequenceDictionariesEqual(SAMSequenceDictionary s1, SAMSequenceDictionary s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        try {
            SequenceUtil.assertSequenceListsEqual(s1.getSequences(), s2.getSequences());
            return true;
        }
        catch (SequenceListsDifferException e) {
            return false;
        }
    }

    public static void assertSequenceDictionariesEqual(SAMSequenceDictionary s1, SAMSequenceDictionary s2) {
        if (s1 == null || s2 == null) {
            return;
        }
        SequenceUtil.assertSequenceListsEqual(s1.getSequences(), s2.getSequences());
    }

    public static void assertSequenceDictionariesEqual(SAMSequenceDictionary s1, SAMSequenceDictionary s2, File f1, File f2) {
        try {
            SequenceUtil.assertSequenceDictionariesEqual(s1, s2);
        }
        catch (SequenceListsDifferException e) {
            throw new SequenceListsDifferException("In files " + f1.getAbsolutePath() + " and " + f2.getAbsolutePath(), e);
        }
    }

    public static String makeCigarStringWithPossibleClipping(int alignmentStart, int readLength, int referenceSequenceLength) {
        int matchLength;
        int start = alignmentStart;
        int leftSoftClip = 0;
        if (start < 1) {
            leftSoftClip = 1 - start;
            start = 1;
        }
        int rightSoftClip = 0;
        if (alignmentStart + readLength > referenceSequenceLength + 1) {
            rightSoftClip = alignmentStart + readLength - referenceSequenceLength - 1;
        }
        if ((matchLength = readLength - leftSoftClip - rightSoftClip) < 1) {
            throw new SAMException("Unexpected cigar string with no M op for read.");
        }
        return SequenceUtil.makeSoftClipCigar(leftSoftClip) + Integer.toString(matchLength) + "M" + SequenceUtil.makeSoftClipCigar(rightSoftClip);
    }

    public static String makeCigarStringWithIndelPossibleClipping(int alignmentStart, int readLength, int referenceSequenceLength, int indelPosition, int indelLength) {
        int start = alignmentStart;
        int leftSoftClip = 0;
        if (start < 1) {
            leftSoftClip = 1 - start;
            start = 1;
        }
        int rightSoftClip = 0;
        int alignmentEnd = alignmentStart + readLength - indelLength;
        if (alignmentEnd > referenceSequenceLength + 1) {
            rightSoftClip = alignmentEnd - referenceSequenceLength - 1;
        }
        if (leftSoftClip >= indelPosition) {
            throw new IllegalStateException("Soft clipping entire pre-indel match. leftSoftClip: " + leftSoftClip + "; indelPosition: " + indelPosition);
        }
        int firstMatchLength = indelPosition - leftSoftClip;
        int secondMatchLength = readLength - indelPosition - (indelLength > 0 ? indelLength : 0) - rightSoftClip;
        if (secondMatchLength < 1) {
            throw new SAMException("Unexpected cigar string with no M op for read.");
        }
        return SequenceUtil.makeSoftClipCigar(leftSoftClip) + Integer.toString(firstMatchLength) + "M" + Math.abs(indelLength) + (indelLength > 0 ? "I" : "D") + Integer.toString(secondMatchLength) + "M" + SequenceUtil.makeSoftClipCigar(rightSoftClip);
    }

    public static String makeSoftClipCigar(int clipLength) {
        if (clipLength == 0) {
            return "";
        }
        return Integer.toString(clipLength) + "S";
    }

    public static int countMismatches(SAMRecord read, byte[] referenceBases) {
        return SequenceUtil.countMismatches(read, referenceBases, 0, false);
    }

    public static int countMismatches(SAMRecord read, byte[] referenceBases, int referenceOffset) {
        return SequenceUtil.countMismatches(read, referenceBases, referenceOffset, false);
    }

    public static int countMismatches(SAMRecord read, byte[] referenceBases, int referenceOffset, boolean bisulfiteSequence) {
        try {
            int mismatches = 0;
            byte[] readBases = read.getReadBases();
            for (AlignmentBlock block : read.getAlignmentBlocks()) {
                int readBlockStart = block.getReadStart() - 1;
                int referenceBlockStart = block.getReferenceStart() - 1 - referenceOffset;
                int length = block.getLength();
                for (int i = 0; i < length; ++i) {
                    if (!bisulfiteSequence) {
                        if (SequenceUtil.basesEqual(readBases[readBlockStart + i], referenceBases[referenceBlockStart + i])) continue;
                        ++mismatches;
                        continue;
                    }
                    if (SequenceUtil.bisulfiteBasesEqual(read.getReadNegativeStrandFlag(), readBases[readBlockStart + i], referenceBases[referenceBlockStart + i])) continue;
                    ++mismatches;
                }
            }
            return mismatches;
        }
        catch (Exception e) {
            throw new SAMException("Exception counting mismatches for read " + read, e);
        }
    }

    public static int countMismatches(SAMRecord read, byte[] referenceBases, boolean bisulfiteSequence) {
        return SequenceUtil.countMismatches(read, referenceBases, 0, bisulfiteSequence);
    }

    @Deprecated
    private static int countMismatches(SAMRecord read, char[] referenceBases, int referenceOffset) {
        int mismatches = 0;
        byte[] readBases = read.getReadBases();
        for (AlignmentBlock block : read.getAlignmentBlocks()) {
            int readBlockStart = block.getReadStart() - 1;
            int referenceBlockStart = block.getReferenceStart() - 1 - referenceOffset;
            int length = block.getLength();
            for (int i = 0; i < length; ++i) {
                if (SequenceUtil.basesEqual(readBases[readBlockStart + i], StringUtil.charToByte(referenceBases[referenceBlockStart + i]))) continue;
                ++mismatches;
            }
        }
        return mismatches;
    }

    public static int sumQualitiesOfMismatches(SAMRecord read, byte[] referenceBases) {
        return SequenceUtil.sumQualitiesOfMismatches(read, referenceBases, 0, false);
    }

    public static int sumQualitiesOfMismatches(SAMRecord read, byte[] referenceBases, int referenceOffset) {
        return SequenceUtil.sumQualitiesOfMismatches(read, referenceBases, referenceOffset, false);
    }

    public static int sumQualitiesOfMismatches(SAMRecord read, byte[] referenceBases, int referenceOffset, boolean bisulfiteSequence) {
        int qualities = 0;
        byte[] readBases = read.getReadBases();
        byte[] readQualities = read.getBaseQualities();
        if (read.getAlignmentStart() <= referenceOffset) {
            throw new IllegalArgumentException("read.getAlignmentStart(" + read.getAlignmentStart() + ") <= referenceOffset(" + referenceOffset + ")");
        }
        for (AlignmentBlock block : read.getAlignmentBlocks()) {
            int readBlockStart = block.getReadStart() - 1;
            int referenceBlockStart = block.getReferenceStart() - 1 - referenceOffset;
            int length = block.getLength();
            for (int i = 0; i < length; ++i) {
                if (!bisulfiteSequence) {
                    if (SequenceUtil.basesEqual(readBases[readBlockStart + i], referenceBases[referenceBlockStart + i])) continue;
                    qualities += readQualities[readBlockStart + i];
                    continue;
                }
                if (SequenceUtil.bisulfiteBasesEqual(read.getReadNegativeStrandFlag(), readBases[readBlockStart + i], referenceBases[referenceBlockStart + i])) continue;
                qualities += readQualities[readBlockStart + i];
            }
        }
        return qualities;
    }

    @Deprecated
    public static int sumQualitiesOfMismatches(SAMRecord read, char[] referenceBases, int referenceOffset) {
        int qualities = 0;
        byte[] readBases = read.getReadBases();
        byte[] readQualities = read.getBaseQualities();
        if (read.getAlignmentStart() <= referenceOffset) {
            throw new IllegalArgumentException("read.getAlignmentStart(" + read.getAlignmentStart() + ") <= referenceOffset(" + referenceOffset + ")");
        }
        for (AlignmentBlock block : read.getAlignmentBlocks()) {
            int readBlockStart = block.getReadStart() - 1;
            int referenceBlockStart = block.getReferenceStart() - 1 - referenceOffset;
            int length = block.getLength();
            for (int i = 0; i < length; ++i) {
                if (SequenceUtil.basesEqual(readBases[readBlockStart + i], StringUtil.charToByte(referenceBases[referenceBlockStart + i]))) continue;
                qualities += readQualities[readBlockStart + i];
            }
        }
        return qualities;
    }

    public static int countInsertedBases(Cigar cigar) {
        int ret = 0;
        for (CigarElement element : cigar.getCigarElements()) {
            if (element.getOperator() != CigarOperator.INSERTION) continue;
            ret += element.getLength();
        }
        return ret;
    }

    public static int countDeletedBases(Cigar cigar) {
        int ret = 0;
        for (CigarElement element : cigar.getCigarElements()) {
            if (element.getOperator() != CigarOperator.DELETION) continue;
            ret += element.getLength();
        }
        return ret;
    }

    public static int countInsertedBases(SAMRecord read) {
        return SequenceUtil.countInsertedBases(read.getCigar());
    }

    public static int countDeletedBases(SAMRecord read) {
        return SequenceUtil.countDeletedBases(read.getCigar());
    }

    public static int calculateSamNmTag(SAMRecord read, byte[] referenceBases) {
        return SequenceUtil.calculateSamNmTag(read, referenceBases, 0, false);
    }

    public static int calculateSamNmTag(SAMRecord read, byte[] referenceBases, int referenceOffset) {
        return SequenceUtil.calculateSamNmTag(read, referenceBases, referenceOffset, false);
    }

    public static int calculateSamNmTag(SAMRecord read, byte[] referenceBases, int referenceOffset, boolean bisulfiteSequence) {
        int samNm = SequenceUtil.countMismatches(read, referenceBases, referenceOffset, bisulfiteSequence);
        for (CigarElement el : read.getCigar().getCigarElements()) {
            if (el.getOperator() != CigarOperator.INSERTION && el.getOperator() != CigarOperator.DELETION) continue;
            samNm += el.getLength();
        }
        return samNm;
    }

    public static int calculateSamNmTagFromCigar(SAMRecord record) {
        int samNm = 0;
        for (CigarElement el : record.getCigar().getCigarElements()) {
            if (el.getOperator() != CigarOperator.X && el.getOperator() != CigarOperator.INSERTION && el.getOperator() != CigarOperator.DELETION) continue;
            samNm += el.getLength();
        }
        return samNm;
    }

    @Deprecated
    public static int calculateSamNmTag(SAMRecord read, char[] referenceBases, int referenceOffset) {
        int samNm = SequenceUtil.countMismatches(read, referenceBases, referenceOffset);
        for (CigarElement el : read.getCigar().getCigarElements()) {
            if (el.getOperator() != CigarOperator.INSERTION && el.getOperator() != CigarOperator.DELETION) continue;
            samNm += el.getLength();
        }
        return samNm;
    }

    public static byte complement(byte b) {
        switch (b) {
            case 97: {
                return 116;
            }
            case 99: {
                return 103;
            }
            case 103: {
                return 99;
            }
            case 116: {
                return 97;
            }
            case 65: {
                return 84;
            }
            case 67: {
                return 71;
            }
            case 71: {
                return 67;
            }
            case 84: {
                return 65;
            }
        }
        return b;
    }

    public static void reverseComplement(byte[] bases) {
        int lastIndex = bases.length - 1;
        int i = 0;
        for (int j = lastIndex; i < j; ++i, --j) {
            byte tmp = SequenceUtil.complement(bases[i]);
            bases[i] = SequenceUtil.complement(bases[j]);
            bases[j] = tmp;
        }
        if (bases.length % 2 == 1) {
            bases[i] = SequenceUtil.complement(bases[i]);
        }
    }

    public static void reverseQualities(byte[] quals) {
        int lastIndex = quals.length - 1;
        int i = 0;
        for (int j = lastIndex; i < j; ++i, --j) {
            byte tmp = quals[i];
            quals[i] = quals[j];
            quals[j] = tmp;
        }
    }

    public static boolean bisulfiteBasesEqual(boolean negativeStrand, byte read, byte reference) {
        return SequenceUtil.basesEqual(read, reference) || SequenceUtil.isBisulfiteConverted(read, reference, negativeStrand);
    }

    public static boolean bisulfiteBasesEqual(byte read, byte reference) {
        return SequenceUtil.bisulfiteBasesEqual(false, read, reference);
    }

    public static boolean isBisulfiteConverted(byte read, byte reference, boolean negativeStrand) {
        return negativeStrand ? SequenceUtil.basesEqual(reference, (byte)71) && SequenceUtil.basesEqual(read, (byte)65) : SequenceUtil.basesEqual(reference, (byte)67) && SequenceUtil.basesEqual(read, (byte)84);
    }

    public static boolean isBisulfiteConverted(byte read, byte reference) {
        return SequenceUtil.isBisulfiteConverted(read, reference, false);
    }

    public static byte[] makeReferenceFromAlignment(SAMRecord rec, boolean includeReferenceBasesForDeletions) {
        String md = rec.getStringAttribute(SAMTag.MD.name());
        if (md == null) {
            throw new SAMException("Cannot create reference from SAMRecord with no MD tag, read: " + rec.getReadName());
        }
        int maxOutputLength = 0;
        Cigar cigar = rec.getCigar();
        if (cigar == null) {
            throw new SAMException("Cannot create reference from SAMRecord with no CIGAR, read: " + rec.getReadName());
        }
        for (CigarElement cigarElement : cigar.getCigarElements()) {
            maxOutputLength += cigarElement.getLength();
        }
        byte[] ret = new byte[maxOutputLength];
        int outIndex = 0;
        Matcher match = mdPat.matcher(md);
        int curSeqPos = 0;
        int savedBases = 0;
        byte[] seq = rec.getReadBases();
        for (CigarElement cigEl : cigar.getCigarElements()) {
            int i;
            int cigElLen = cigEl.getLength();
            CigarOperator cigElOp = cigEl.getOperator();
            if (cigElOp == CigarOperator.SKIPPED_REGION) {
                if (!includeReferenceBasesForDeletions) continue;
                for (i = 0; i < cigElLen; ++i) {
                    ret[outIndex++] = 78;
                }
                continue;
            }
            if (cigElOp.consumesReferenceBases()) {
                int basesMatched;
                for (basesMatched = 0; savedBases > 0 && basesMatched < cigElLen; --savedBases, ++basesMatched) {
                    ret[outIndex++] = seq[curSeqPos++];
                }
                while (basesMatched < cigElLen) {
                    boolean matched = match.find();
                    if (matched) {
                        String mg = match.group(1);
                        if (mg != null && mg.length() > 0) {
                            int num = Integer.parseInt(mg);
                            for (int i2 = 0; i2 < num; ++i2) {
                                if (basesMatched < cigElLen) {
                                    ret[outIndex++] = seq[curSeqPos++];
                                } else {
                                    ++savedBases;
                                }
                                ++basesMatched;
                            }
                        } else {
                            mg = match.group(2);
                            if (mg != null && mg.length() > 0) {
                                if (basesMatched < cigElLen) {
                                    ret[outIndex++] = StringUtil.charToByte(mg.charAt(0));
                                    ++curSeqPos;
                                } else {
                                    throw new IllegalStateException("Should never happen.");
                                }
                                ++basesMatched;
                            } else {
                                mg = match.group(3);
                                if (mg != null && mg.length() > 0) {
                                    if (includeReferenceBasesForDeletions) {
                                        byte[] deletedBases = StringUtil.stringToBytes(mg);
                                        System.arraycopy(deletedBases, 1, ret, outIndex, deletedBases.length - 1);
                                        outIndex += deletedBases.length - 1;
                                    }
                                    if ((basesMatched += mg.length() - 1) != cigElLen) {
                                        throw new SAMException("Got a deletion in CIGAR (" + cigar + ", deletion " + cigElLen + " length) with an unequal ref insertion in MD (" + md + ", md " + basesMatched + " length");
                                    }
                                    if (cigElOp != CigarOperator.DELETION) {
                                        throw new SAMException("Got an insertion in MD (" + md + ") without a corresponding deletion in cigar (" + cigar + ")");
                                    }
                                } else {
                                    matched = false;
                                }
                            }
                        }
                    }
                    if (matched) continue;
                    throw new SAMException("Illegal MD pattern: " + md + " for read " + rec.getReadName() + " with CIGAR " + rec.getCigarString());
                }
                continue;
            }
            if (!cigElOp.consumesReadBases()) continue;
            for (i = 0; i < cigElLen; ++i) {
                char c = cigElOp == CigarOperator.SOFT_CLIP ? (char)'0' : '-';
                ret[outIndex++] = StringUtil.charToByte(c);
                ++curSeqPos;
            }
        }
        if (outIndex < ret.length) {
            byte[] shorter = new byte[outIndex];
            System.arraycopy(ret, 0, shorter, 0, outIndex);
            return shorter;
        }
        return ret;
    }

    public static void reverse(byte[] array, int offset, int len) {
        int lastIndex = len - 1;
        int i = offset;
        for (int j = offset + lastIndex; i < j; ++i, --j) {
            byte tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
        if (len % 2 == 1) {
            array[i] = array[i];
        }
    }

    public static void reverseComplement(byte[] bases, int offset, int len) {
        int lastIndex = len - 1;
        int i = offset;
        for (int j = offset + lastIndex; i < j; ++i, --j) {
            byte tmp = SequenceUtil.complement(bases[i]);
            bases[i] = SequenceUtil.complement(bases[j]);
            bases[j] = tmp;
        }
        if (len % 2 == 1) {
            bases[i] = SequenceUtil.complement(bases[i]);
        }
    }

    public static String calculateMD5String(byte[] data) throws NoSuchAlgorithmException {
        return SequenceUtil.calculateMD5String(data, 0, data.length);
    }

    public static String calculateMD5String(byte[] data, int offset, int len) {
        byte[] digest = SequenceUtil.calculateMD5(data, offset, len);
        return String.format("%032x", new BigInteger(1, digest));
    }

    public static byte[] calculateMD5(byte[] data, int offset, int len) {
        try {
            MessageDigest md5_MessageDigest = MessageDigest.getInstance("MD5");
            md5_MessageDigest.reset();
            md5_MessageDigest.update(data, offset, len);
            return md5_MessageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static void calculateMdAndNmTags(SAMRecord record, byte[] ref, boolean calcMD, boolean calcNM) {
        if (!calcMD && !calcNM) {
            return;
        }
        Cigar cigar = record.getCigar();
        List<CigarElement> cigarElements = cigar.getCigarElements();
        byte[] seq = record.getReadBases();
        int start = record.getAlignmentStart() - 1;
        int u = 0;
        int nm = 0;
        StringBuilder str = new StringBuilder();
        int size = cigarElements.size();
        int y = 0;
        int x = start;
        for (int i = 0; i < size; ++i) {
            int j;
            CigarElement ce = cigarElements.get(i);
            int length = ce.getLength();
            CigarOperator op = ce.getOperator();
            if (op == CigarOperator.MATCH_OR_MISMATCH || op == CigarOperator.EQ || op == CigarOperator.X) {
                for (j = 0; j < length; ++j) {
                    int z = y + j;
                    if (ref.length <= x + j) break;
                    byte c1 = 0;
                    byte c2 = 0;
                    c1 = seq[z];
                    c2 = ref[x + j];
                    if (c1 == c2 || c1 == 0) {
                        ++u;
                        continue;
                    }
                    str.append(u);
                    str.appendCodePoint(ref[x + j]);
                    u = 0;
                    ++nm;
                }
                if (j < length) break;
                x += length;
                y += length;
                continue;
            }
            if (op == CigarOperator.DELETION) {
                str.append(u);
                str.append('^');
                for (j = 0; j < length && ref[x + j] != 0; ++j) {
                    str.appendCodePoint(ref[x + j]);
                }
                u = 0;
                if (j < length) break;
                x += length;
                nm += length;
                continue;
            }
            if (op == CigarOperator.INSERTION || op == CigarOperator.SOFT_CLIP) {
                y += length;
                if (op != CigarOperator.INSERTION) continue;
                nm += length;
                continue;
            }
            if (op != CigarOperator.SKIPPED_REGION) continue;
            x += length;
        }
        str.append(u);
        if (calcMD) {
            record.setAttribute(SAMTag.MD.name(), (Object)str.toString());
        }
        if (calcNM) {
            record.setAttribute(SAMTag.NM.name(), (Object)nm);
        }
    }

    public static byte upperCase(byte base) {
        return base >= 97 ? (byte)(base - 32) : base;
    }

    public static byte[] upperCase(byte[] bases) {
        for (int i = 0; i < bases.length; ++i) {
            bases[i] = SequenceUtil.upperCase(bases[i]);
        }
        return bases;
    }

    public static List<byte[]> generateAllKmers(int length) {
        LinkedList<byte[]> sofar = new LinkedList<byte[]>();
        if (sofar.size() == 0) {
            sofar.add(new byte[length]);
        }
        block0: while (true) {
            byte[] bs = (byte[])sofar.remove(0);
            int indexOfNextBase = -1;
            for (int i = 0; i < bs.length; ++i) {
                if (bs[i] != 0) continue;
                indexOfNextBase = i;
                break;
            }
            if (indexOfNextBase == -1) {
                sofar.add(bs);
                break;
            }
            byte[] byArray = VALID_BASES_UPPER;
            int n = byArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block0;
                byte b = byArray[n2];
                byte[] next = Arrays.copyOf(bs, bs.length);
                next[indexOfNextBase] = b;
                sofar.add(next);
                ++n2;
            }
            break;
        }
        return sofar;
    }

    public static class SequenceListsDifferException
    extends SAMException {
        public SequenceListsDifferException() {
        }

        public SequenceListsDifferException(String s) {
            super(s);
        }

        public SequenceListsDifferException(String s, Throwable throwable) {
            super(s, throwable);
        }

        public SequenceListsDifferException(Throwable throwable) {
            super(throwable);
        }
    }
}

