/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.keystroke;

import javax.swing.KeyStroke;

public class KeyStrokeMapping {
    private final char character;
    private final KeyStroke keyStroke;

    public static KeyStrokeMapping mapping(char character, int keyCode, int modifiers) {
        return new KeyStrokeMapping(character, keyCode, modifiers);
    }

    public KeyStrokeMapping(char character, int keyCode, int modifiers) {
        this(character, KeyStroke.getKeyStroke(keyCode, modifiers));
    }

    public KeyStrokeMapping(char character, KeyStroke keyStroke) {
        this.character = character;
        this.keyStroke = keyStroke;
    }

    public char character() {
        return this.character;
    }

    public KeyStroke keyStroke() {
        return this.keyStroke;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof KeyStrokeMapping)) {
            return false;
        }
        KeyStrokeMapping other = (KeyStrokeMapping)o;
        if (this.character != other.character) {
            return false;
        }
        if (this.keyStroke == null) {
            return other.keyStroke == null;
        }
        if (other.keyStroke == null) {
            return false;
        }
        if (this.keyStroke.getKeyCode() != other.keyStroke.getKeyCode()) {
            return false;
        }
        return this.keyStroke.getModifiers() == other.keyStroke.getModifiers();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.character;
        if (this.keyStroke == null) {
            return result;
        }
        result = prime * result + this.keyStroke.getKeyCode();
        result = prime * result + this.keyStroke.getModifiers();
        return result;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName()).append("[");
        b.append("character='").append(this.character).append("',");
        b.append("keyStroke=").append(this.keyStroke).append("]");
        return b.toString();
    }
}

