/****************************************************************************
 *    lib/c/LTLQuery.h - This file is part of coala							*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/


#ifndef LTLQUERY_H
#define LTLQUERY_H

#include <string>
#include <map>

#include "Query.h"
#include "FluentAction.h"

namespace C {
	
class LTLNode;

class LTLQuery : virtual public Query
{
public:
	LTLQuery(LTLNode*, int line, Types* types=NULL);

	virtual ~LTLQuery();

	LTLNode* getNode();
	void setNode(LTLNode*);

	
	void print(Printer*, map<string, FluentAction*>*);
	void printLoopGuessCheck(Printer*, map<string, FluentAction*>*);

private:
	LTLNode* node_;

};


class LTLNode
{
public:
	LTLNode(int, LTLNode*, LTLNode*, int);
	LTLNode(int, FluentAction*, int);
	virtual ~LTLNode();
	int getType();
	string getClass();
	LTLNode* getRightNode();
	void printLTLCondition(Printer*, string);
	void print(Printer*, bool, bool);
	bool printContent(Printer*, string, bool);
	void check_and_print(Printer*, bool);
	void printAND(Printer*, bool, bool);
	void printOR(Printer*, bool, bool);
	void printX(Printer*, bool, bool);
	void printF(Printer*, bool, bool);
	void printG(Printer*, bool, bool);
	void printU(Printer*, bool, bool);
	void printR(Printer*, bool, bool);
	void print_debug(Printer*);
    LTLNode* negate(bool);
	void printIncPropagator(Printer*);
	void printIncPropagatorForThisNode(Printer*);

private:
	int type_;
	LTLNode* left_;
	LTLNode* right_;
	int num_;
	FluentAction* content_;
};

}; // end of package namespace

#endif // LTLQUERY_H
