rho = thermo.rho();

volScalarField rUA = 1.0/UEqn.A();
U = rUA*UEqn.H();

surfaceScalarField phid
(
    "phid",
    fvc::interpolate(psi)
   *(
        (fvc::interpolate(U) & mesh.Sf())
      + fvc::ddtPhiCorr(rUA, rho, U, phi)
    )
);

for (int nonOrth=0; nonOrth<=nNonOrthCorr; nonOrth++)
{
    fvScalarMatrix pEqn
    (
        fvm::ddt(psi, p)
      + fvm::div(phid, p)
      - fvm::laplacian(rho*rUA, p)
    );

    pEqn.solve();

    if (nonOrth == nNonOrthCorr)
    {
        phi = pEqn.flux();
    }
}

#include <finiteVolume/rhoEqn.H>
#include <finiteVolume/compressibleContinuityErrs.H>

U -= rUA*fvc::grad(p);
U.correctBoundaryConditions();
