/* IMSpector - Instant Messenger Transparent Proxy Service
 * http://www.imspector.org/
 * (c) Lawrence Manning <lawrence@aslak.net>, 2006
 * 
 * Released under the GPL v2. */

#include "imspector.h"

#define PLUGIN_NAME "Cats IMSpector logging plugin"
#define PLUGIN_SHORT_NAME "Cats"

extern "C"
{
	bool initloggingplugin(struct loggingplugininfo &ploggingplugininfo,
		class Options &options, bool debugmode);
	void closeloggingplugin(void);
	int logevents(std::vector<struct imevent> &imevents);
};

std::string catsloggingfilename;
bool localdebugmode = false;

bool initloggingplugin(struct loggingplugininfo &loggingplugininfo,
	class Options &options, bool debugmode)
{
	catsloggingfilename = options["cats_logging_filename"];

	if (catsloggingfilename.empty()) return false;

	localdebugmode = debugmode;
		
	loggingplugininfo.pluginname = PLUGIN_NAME;
		
	return true;
}

void closeloggingplugin(void)
{
	return;
}

/* The main plugin function. See loggingplugin.cpp. */
int logevents(std::vector<struct imevent> &imevents)
{
	for (std::vector<struct imevent>::iterator i = imevents.begin();
		i != imevents.end(); i++)
	{
		if ((*i).categories.empty()) continue;
	
		FILE *hfile = NULL;
		if (!(hfile = fopen(catsloggingfilename.c_str(), "a"))) return 1;

		fprintf(hfile, "%s,", (*i).protocolname.c_str());
		fprintf(hfile, "%s,", (*i).localid.c_str());
		fprintf(hfile, "%s,", (*i).remoteid.c_str());
		fprintf(hfile, "%s,", (*i).clientaddress.c_str());
		fprintf(hfile, "%ld,", (*i).timestamp);
		fprintf(hfile, "%d,", (*i).outgoing ? 1 : 0);
		fprintf(hfile, "%d,", (*i).type);
		fprintf(hfile, "%d,", (*i).filtered ? 1 : 0);
		fprintf(hfile, "%s,", (*i).categories.c_str());
		
		std::string eventdata = (*i).eventdata;
		
		size_t pos = 0;
		while ((pos = eventdata.find("\n"), pos) != std::string::npos)
			eventdata.replace(pos, 1, "\\n");
		
		fprintf(hfile, "%s", eventdata.c_str());
		fprintf(hfile, "\n");
		
		fclose(hfile);
	}

	return 0;
}
