/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.javax.sql.rowset.serial;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import javax.sql.rowset.serial.SQLInputImpl;
import javax.sql.rowset.serial.SerialDatalink;
import junit.framework.TestCase;
import org.apache.harmony.sql.tests.javax.sql.rowset.MockArray;
import org.apache.harmony.sql.tests.javax.sql.rowset.MockBlob;
import org.apache.harmony.sql.tests.javax.sql.rowset.MockClob;
import org.apache.harmony.sql.tests.javax.sql.rowset.MockRef;
import org.apache.harmony.sql.tests.javax.sql.rowset.serial.SQLInputImplTest;

/*
 * Exception performing whole class analysis ignored.
 */
public class SQLInputImplTest
extends TestCase {
    public void test_Constructor() {
        try {
            new SQLInputImpl(null, new HashMap());
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            new SQLInputImpl(null, null);
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            new SQLInputImpl(new Object[0], null);
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testReadArray() throws SQLException {
        MockArray mockArray = new MockArray();
        Object[] objectArray = new Object[]{mockArray};
        SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((Object)mockArray, (Object)sQLInputImpl.readArray());
        try {
            sQLInputImpl.readArray();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        objectArray = new Object[1];
        sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertNull((Object)sQLInputImpl.readArray());
    }

    public void testReadAsciiStream() throws SQLException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("abc".getBytes());
        Object[] objectArray = new Object[]{byteArrayInputStream};
        SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((Object)byteArrayInputStream, (Object)sQLInputImpl.readAsciiStream());
        try {
            sQLInputImpl.readAsciiStream();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        objectArray = new Object[1];
        sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertNull((Object)sQLInputImpl.readAsciiStream());
    }

    public void testReadBigDecimal() throws SQLException {
        BigDecimal bigDecimal = new BigDecimal("12.5");
        Object[] objectArray = new Object[]{bigDecimal};
        SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((Object)bigDecimal, (Object)sQLInputImpl.readBigDecimal());
        try {
            sQLInputImpl.readBigDecimal();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        objectArray = new Object[1];
        sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertNull((Object)sQLInputImpl.readBigDecimal());
    }

    public void testReadBinaryStream() throws SQLException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("abc".getBytes());
        Object[] objectArray = new Object[]{byteArrayInputStream};
        SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((Object)byteArrayInputStream, (Object)sQLInputImpl.readBinaryStream());
        objectArray = new Object[1];
        sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertNull((Object)sQLInputImpl.readBinaryStream());
    }

    public void testReadBlob() throws SQLException {
        MockBlob mockBlob = new MockBlob();
        Object[] objectArray = new Object[]{mockBlob};
        SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((Object)mockBlob, (Object)sQLInputImpl.readBlob());
        try {
            sQLInputImpl.readBlob();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        objectArray = new Object[1];
        sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertNull((Object)sQLInputImpl.readBlob());
    }

    public void testReadBoolean() throws SQLException {
        Object[] objectArray = new Object[]{Boolean.TRUE};
        SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((boolean)true, (boolean)sQLInputImpl.readBoolean());
        try {
            sQLInputImpl.readBoolean();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        objectArray = new Object[1];
        sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertFalse((boolean)sQLInputImpl.readBoolean());
    }

    public void testReadByte() throws SQLException {
        Object[] objectArray = new Object[]{Byte.valueOf("3")};
        SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((byte)3, (byte)sQLInputImpl.readByte());
        try {
            sQLInputImpl.readByte();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        objectArray = new Object[1];
        sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((byte)0, (byte)sQLInputImpl.readByte());
    }

    public void testReadBytes() throws SQLException {
        byte[] byArray = new byte[]{1, 2, 3};
        Object[] objectArray = new Object[]{byArray};
        SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((Object)byArray, (Object)sQLInputImpl.readBytes());
        try {
            sQLInputImpl.readBytes();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        objectArray = new Object[1];
        sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertNull((Object)sQLInputImpl.readBytes());
    }

    public void testReadCharacterStream() throws SQLException {
        StringReader stringReader = new StringReader("abc");
        Object[] objectArray = new Object[]{stringReader};
        SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((Object)stringReader, (Object)sQLInputImpl.readCharacterStream());
        try {
            sQLInputImpl.readCharacterStream();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        objectArray = new Object[1];
        sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertNull((Object)sQLInputImpl.readCharacterStream());
    }

    public void testReadClob() throws SQLException {
        MockClob mockClob = new MockClob();
        Object[] objectArray = new Object[]{mockClob};
        SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((Object)mockClob, (Object)sQLInputImpl.readClob());
        try {
            sQLInputImpl.readClob();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        objectArray = new Object[1];
        sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertNull((Object)sQLInputImpl.readClob());
    }

    public void testReadDate() throws SQLException {
        Date date = new Date(12L);
        Object[] objectArray = new Object[]{date};
        SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((Object)date, (Object)sQLInputImpl.readDate());
        try {
            sQLInputImpl.readDate();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        objectArray = new Object[1];
        sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertNull((Object)sQLInputImpl.readDate());
    }

    public void testReadDouble() throws SQLException {
        Object[] objectArray = new Object[]{Double.valueOf("3")};
        SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((Object)new Double(3.0), (Object)new Double(sQLInputImpl.readDouble()));
        try {
            sQLInputImpl.readDouble();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        objectArray = new Object[1];
        sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((double)0.0, (double)sQLInputImpl.readDouble(), (double)0.0);
    }

    public void testReadFloat() throws SQLException {
        Object[] objectArray = new Object[]{Float.valueOf("3.5")};
        SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((Object)new Float(3.5f), (Object)new Float(sQLInputImpl.readFloat()));
        try {
            sQLInputImpl.readFloat();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        objectArray = new Object[1];
        sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((float)0.0f, (float)sQLInputImpl.readFloat(), (float)0.0f);
    }

    public void testReadInt() throws SQLException {
        Object[] objectArray = new Object[]{Integer.valueOf("3")};
        SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((int)3, (int)sQLInputImpl.readInt());
        try {
            sQLInputImpl.readInt();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        objectArray = new Object[1];
        sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((int)0, (int)sQLInputImpl.readInt());
    }

    public void testReadLong() throws SQLException {
        Object[] objectArray = new Object[]{Long.valueOf("3")};
        SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((long)3L, (long)sQLInputImpl.readLong());
        try {
            sQLInputImpl.readLong();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        objectArray = new Object[1];
        sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((long)0L, (long)sQLInputImpl.readLong());
    }

    public void testReadObject() throws SQLException {
        Class<?> clazz;
        Object[] objectArray = new Object[]{"hello", Boolean.TRUE, "abc", 99};
        MockStruct mockStruct = new MockStruct(objectArray, "harmonytests.MockSQLData");
        MockStruct mockStruct2 = new MockStruct(objectArray, "not stored name");
        HashMap hashMap = new HashMap();
        try {
            clazz = Class.forName("org.apache.harmony.sql.tests.javax.sql.rowset.serial.SQLInputImplTest$MockSQLData");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        hashMap.put("harmonytests.MockSQLData", clazz);
        Object[] objectArray2 = new Object[4];
        objectArray2[0] = mockStruct;
        objectArray2[1] = mockStruct2;
        objectArray2[3] = "xyz";
        Object[] objectArray3 = objectArray2;
        SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray3, hashMap);
        Object object = sQLInputImpl.readObject();
        SQLInputImplTest.assertTrue((boolean)(object instanceof MockSQLData));
        MockSQLData mockSQLData = (MockSQLData)object;
        SQLInputImplTest.assertEquals((Object)objectArray[0], (Object)mockSQLData.firstAttribute);
        SQLInputImplTest.assertEquals((Object)objectArray[1], (Object)mockSQLData.secondAttribute);
        SQLInputImplTest.assertEquals((Object)objectArray[2], (Object)mockSQLData.thirdAttribute);
        SQLInputImplTest.assertEquals((Object)objectArray[3], (Object)mockSQLData.fourthAttribute);
        Object object2 = sQLInputImpl.readObject();
        SQLInputImplTest.assertEquals((Object)mockStruct2, (Object)object2);
        Object object3 = sQLInputImpl.readObject();
        SQLInputImplTest.assertNull((Object)object3);
        Object object4 = sQLInputImpl.readObject();
        SQLInputImplTest.assertEquals((Object)objectArray3[3], (Object)object4);
    }

    public void testReadRef() throws SQLException {
        MockRef mockRef = new MockRef();
        Object[] objectArray = new Object[]{mockRef};
        SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((Object)mockRef, (Object)sQLInputImpl.readRef());
        try {
            sQLInputImpl.readRef();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        objectArray = new Object[1];
        sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertNull((Object)sQLInputImpl.readRef());
    }

    public void testReadShort() throws SQLException {
        Object[] objectArray = new Object[]{Short.valueOf("3")};
        SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((short)3, (short)sQLInputImpl.readShort());
        try {
            sQLInputImpl.readShort();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        objectArray = new Object[1];
        sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((short)0, (short)sQLInputImpl.readShort());
    }

    public void testReadString() throws SQLException {
        Object[] objectArray = new Object[]{"hello"};
        SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((String)"hello", (String)sQLInputImpl.readString());
        try {
            sQLInputImpl.readString();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        objectArray = new Object[1];
        sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertNull((Object)sQLInputImpl.readString());
    }

    public void testReadTime() throws SQLException {
        Time time = new Time(345L);
        Object[] objectArray = new Object[]{time};
        SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((Object)time, (Object)sQLInputImpl.readTime());
        try {
            sQLInputImpl.readTime();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        objectArray = new Object[1];
        sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertNull((Object)sQLInputImpl.readTime());
    }

    public void testReadTimestamp() throws SQLException {
        Timestamp timestamp = new Timestamp(345L);
        Object[] objectArray = new Object[]{timestamp};
        SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        SQLInputImplTest.assertEquals((Object)timestamp, (Object)sQLInputImpl.readTimestamp());
        try {
            sQLInputImpl.readTimestamp();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testReadURL() throws SQLException, MalformedURLException {
        URL uRL = new URL("http://www.apache.org");
        SerialDatalink serialDatalink = new SerialDatalink(uRL);
        Object[] objectArray = new Object[]{serialDatalink};
        SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, new HashMap());
        try {
            sQLInputImpl.readURL();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            sQLInputImpl.readURL();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testWasNull() throws SQLException {
        Object[] objectArray = new Object[2];
        objectArray[1] = "hello";
        Object[] objectArray2 = objectArray;
        SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray2, new HashMap());
        SQLInputImplTest.assertFalse((boolean)sQLInputImpl.wasNull());
        SQLInputImplTest.assertEquals(null, (String)sQLInputImpl.readString());
        SQLInputImplTest.assertTrue((boolean)sQLInputImpl.wasNull());
        SQLInputImplTest.assertEquals((String)"hello", (String)sQLInputImpl.readString());
        SQLInputImplTest.assertFalse((boolean)sQLInputImpl.wasNull());
        try {
            sQLInputImpl.readString();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        SQLInputImplTest.assertFalse((boolean)sQLInputImpl.wasNull());
        SQLInputImplTest.assertFalse((boolean)sQLInputImpl.wasNull());
    }
}

