/* Copyright (C) 2014, 2015 D. V. Wiebe
 *
 ***************************************************************************
 *
 * This file is part of the GetData project.
 *
 * GetData is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * GetData is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with GetData; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "test.h"

int main(void)
{
#ifndef TEST_BZIP2
  return 77;
#else
  const char *filedir = "dirfile";
  const char *format = "dirfile/format";
  const char *data_bz2 = "dirfile/data.bz2";
  const char *data = "dirfile/data";
  const char *format_data = "data RAW UINT8 8\n";
  const unsigned char bz2data[425] = {
    0x42, 0x5a, 0x68, 0x39, 0x31, 0x41, 0x59, 0x26,
    0x53, 0x59, 0xb6, 0xb5, 0xee, 0x95, 0x00, 0x00,
    0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xb0, 0x00, 0xc5, 0x52, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
    0x30, 0x09, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x04,
    0xc0, 0x04, 0x98, 0x00, 0x26, 0x00, 0x02, 0x60,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x02, 0x4c, 0x00, 0x13, 0x00,
    0x01, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x08,
    0x0c, 0x10, 0x14, 0x18, 0x1c, 0x20, 0x24, 0x28,
    0x2c, 0x30, 0x34, 0x38, 0x3c, 0x40, 0x44, 0x48,
    0x4c, 0x50, 0x54, 0x58, 0x5c, 0x60, 0x64, 0x68,
    0x6c, 0x70, 0x74, 0x78, 0x7c, 0x80, 0x84, 0x88,
    0x8c, 0x90, 0x94, 0x98, 0x9c, 0xa0, 0xa4, 0xa8,
    0xac, 0xb0, 0xb4, 0xb8, 0xbc, 0xc0, 0xc4, 0xc8,
    0xcc, 0xd0, 0xd4, 0xd8, 0xdc, 0xe0, 0xe4, 0xe8,
    0xec, 0xf0, 0xf4, 0xf8, 0xfd, 0x01, 0x05, 0x09,
    0x0d, 0x11, 0x15, 0x19, 0x1d, 0x21, 0x25, 0x29,
    0x2d, 0x31, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49,
    0x4d, 0x51, 0x55, 0x59, 0x5d, 0x61, 0x65, 0x69,
    0x6d, 0x71, 0x75, 0x79, 0x7d, 0x81, 0x85, 0x89,
    0x8d, 0x91, 0x85, 0x89, 0x8d, 0x91, 0x95, 0x99,
    0x9d, 0xa1, 0xa5, 0xa9, 0xad, 0xb1, 0xb5, 0xb9,
    0xbd, 0xc1, 0xc5, 0xc9, 0xcd, 0xd1, 0xd5, 0xd9,
    0xdd, 0xe1, 0xe5, 0xe9, 0xed, 0xf1, 0xf5, 0xf9,
    0xfe, 0x02, 0x06, 0x0a, 0x0e, 0x12, 0x16, 0x1a,
    0x1e, 0x22, 0x26, 0x2a, 0x2e, 0x32, 0x36, 0x3a,
    0x3e, 0x42, 0x46, 0x4a, 0x56, 0x5a, 0x5e, 0x62,
    0x66, 0x6a, 0x6e, 0x72, 0x76, 0x7a, 0x7e, 0x82,
    0x86, 0x8a, 0x8e, 0x92, 0x96, 0x9a, 0x9e, 0xa2,
    0xa6, 0xaa, 0xae, 0xb2, 0xb6, 0xba, 0xbe, 0xc2,
    0xc6, 0xca, 0xce, 0xd2, 0xd6, 0xda, 0xde, 0xe2,
    0xe6, 0xea, 0xee, 0xf2, 0xf6, 0xfa, 0xff, 0x03,
    0x07, 0x0b, 0x0f, 0x13, 0x17, 0x1b, 0x17, 0x1b,
    0x1f, 0x23, 0x27, 0x2b, 0x2f, 0x33, 0x37, 0x3b,
    0x3f, 0x43, 0x47, 0x4b, 0x4f, 0x53, 0x57, 0x5b,
    0x5f, 0x63, 0x67, 0x6b, 0x6f, 0x73, 0x77, 0x7b,
    0x7f, 0x83, 0x87, 0x8b, 0x8f, 0x93, 0x97, 0x9b,
    0x9f, 0xa3, 0xa7, 0xab, 0xaf, 0xb3, 0xb7, 0xbb,
    0xbf, 0xc3, 0xc7, 0xcb, 0xcf, 0xd3, 0xd7, 0xdb,
    0xdf, 0xe3, 0xe7, 0xeb, 0xef, 0xf3, 0xf4, 0x5d,
    0xc9, 0x14, 0xe1, 0x42, 0x42, 0xda, 0xd7, 0xba,
    0x54
  };
  uint8_t c[8], d[8];
#ifdef USE_BZIP2
  uint8_t b;
  char command[4096];
#endif
  int fd, i, m, n, e1, e2, e3, unlink_data, unlink_databz2, r = 0;
  DIRFILE *D;

  memset(c, 0, 8);
  rmdirfile();
  mkdir(filedir, 0777);

  for (i = 0; i < 8; ++i)
    d[i] = (uint8_t)(80 + i);

  fd = open(format, O_CREAT | O_EXCL | O_WRONLY, 0666);
  write(fd, format_data, strlen(format_data));
  close(fd);

  fd = open(data_bz2, O_CREAT | O_EXCL | O_WRONLY | O_BINARY, 0666);
  write(fd, bz2data, 425);
  close(fd);

#ifdef USE_BZIP2
  D = gd_open(filedir, GD_RDWR | GD_BZIP2_ENCODED | GD_VERBOSE);
#else
  D = gd_open(filedir, GD_RDWR | GD_BZIP2_ENCODED);
#endif
  n = gd_getdata(D, "data", 5, 0, 1, 0, GD_UINT8, c);
  e1 = gd_error(D);
  m = gd_putdata(D, "data", 5, 0, 1, 0, GD_UINT8, d);
  e2 = gd_error(D);

  e3 = gd_close(D);
  CHECKI(e3, 0);

#ifdef USE_BZIP2
  /* uncompress */
  snprintf(command, 4096, "%s -f %s > /dev/null", BUNZIP2, data_bz2);
  if (gd_system(command)) {
    r = 1;
  } else {
    fd = open(data, O_RDONLY | O_BINARY);
    if (fd >= 0) {
      i = 0;
      while (read(fd, &b, sizeof(uint8_t))) {
        if (i < 40 || i >= 48) {
          CHECKIi(i, b, i);
        } else
          CHECKIi(i, b, i + 40);
        i++;
      }
      CHECKI(i, 256);
      close(fd);
    }
  }

  for (i = 0; i < 8; ++i)
    CHECKIi(i, c[i], 40 + i);
#endif

  unlink_data = unlink(data);
  unlink_databz2 = unlink(data_bz2);
  unlink(format);
  rmdir(filedir);

#ifdef USE_BZIP2
  CHECKI(unlink_data, 0);
  CHECKI(unlink_databz2, -1);
  CHECKI(e1, GD_E_OK);
  CHECKI(e2, GD_E_OK);
  CHECKI(n, 8);
  CHECKI(m, 8);
#else
  CHECKI(unlink_data, -1);
  CHECKI(unlink_databz2, 0);
  CHECKI(e1, GD_E_UNSUPPORTED);
  CHECKI(e2, GD_E_UNSUPPORTED);
  CHECKI(n, 0);
  CHECKI(m, 0);
#endif

  return r;
#endif
}
