package org.jboss.cache;

/**
 * Thrown whenever operations are attempted on a node that is no longer valid.  See {@link org.jboss.cache.Node#isValid()}
 * for details.
 *
 * @author <a href="mailto:manik@jboss.org">Manik Surtani</a>
 * @since 2.1.0
 */
public class NodeNotValidException extends CacheException
{
   public NodeNotValidException()
   {
   }

   public NodeNotValidException(Throwable cause)
   {
      super(cause);
   }

   public NodeNotValidException(String msg)
   {
      super(msg);
   }

   public NodeNotValidException(String msg, Throwable cause)
   {
      super(msg, cause);
   }
}
