/*
 *  Copyright (c) 2011 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_MATH_H_
#define _GTLCORE_MATH_H_

#include <cmath>

#if _MSC_VER

#define M_PI 3.14159265358979323846

namespace std {
  inline long lround(double num) {
    return (long)(num > 0 ? num + 0.5 : ceil(num - 0.5));
  }
  inline int round(double d) {
    return (d>0) ? int(d+0.5) : int(d-0.5);
  }
}

#endif

#endif

