###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_fms_prv_esc_vuln.nasl 2107 04-05-2009 18:12:53Z may $
#
# Adobe Flash Media Server Privilege Escalation Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800560);
  script_version("Revision: 1.0");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-1365");
  script_bugtraq_id(34790);
  script_name("Adobe Flash Media Server Privilege Escalation Vulnerability");
  desc = "

  Overview: This host has Adobe Flash Media Server installed and is prone to
  Privilege Escalation vulnerability.

  Vulnerability Insight:
  This flaw is caused while executing RPC calls made to an ActionScript file
  running under Flash Media Server.

  Impact:
  Successful attack could result in execution of crafted RPC Calls to the
  ActionScript file and cause injection of remote procedures into the context
  of the affected system.

  Impact Level: System

  Affected Software/OS:
  Adobe Flash Media Server before 3.0.4, 3.5.x before 3.5.2 on all platforms.

  Fix: Upgrade to Adobe Flash Media Server 3.5.2 or 3.0.4 or greater.
  http://www.adobe.com/downloads

  References:
  http://www.adobe.com/support/security/bulletins/apsb09-05.html

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.5
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Adobe Flash Media Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Privilege escalation");
  script_dependencies("gb_adobe_fms_detect.nasl");
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

mediaPort = get_http_port(default:1111);
if(!mediaPort){
  exit(0);
}

fmsVer = get_kb_item("www/" + mediaPort + "/Adobe/FMS");
if(fmsVer == NULL){
  exit(0);
}

if(version_in_range(version:fmsVer, test_version:"3.5", test_version2:"3.5.1")||
    version_is_less(version:fmsVer, test_version:"3.0.4")){
  security_hole(mediaPort);
}
