;;; Snd tests
;;;
;;;  test 0: constants                          [554]
;;;  test 1: defaults                           [1226]
;;;  test 2: headers                            [1596]
;;;  test 3: variables                          [1911]
;;;  test 4: sndlib                             [2475]
;;;  test 5: simple overall checks              [4490]
;;;  test 6: float-vectors                      [9242]
;;;  test 7: colors                             [9513]
;;;  test 8: clm                                [10032]
;;;  test 9: mix                                [22115]
;;;  test 10: marks                             [23894]
;;;  test 11: dialogs                           [24832]
;;;  test 12: extensions                        [25005]
;;;  test 13: menus, edit lists, hooks, etc     [25271]
;;;  test 14: all together now                  [26604]
;;;  test 15: chan-local vars                   [27487]
;;;  test 16: regularized funcs                 [29224]
;;;  test 17: dialogs and graphics              [32973]
;;;  test 18: save and restore                  [33085]
;;;  test 19: transforms                        [34737]
;;;  test 20: new stuff                         [36837]
;;;  test 21: optimizer                         [38030]
;;;  test 22: with-sound                        [40924]
;;;  test 23: X/Xt/Xm                           [43909]
;;;  test 24: GL                                [47583]
;;;  test 25: errors                            [47706]
;;;  test 26: s7                                [49224]
;;;  test all done                              [49295]
;;;  test the end                               [49477]

;;; (set! (hook-functions *load-hook*) (list (lambda (hook) (format *stderr* "loading ~S...~%" (hook 'name)))))

;(set! (*s7* 'gc-stats) 6)

(when (provided? 'pure-s7)
  (define (make-polar mag ang)
    (if (and (real? mag) (real? ang))
	(complex (* mag (cos ang)) (* mag (sin ang)))
	(error 'wrong-type-arg "make-polar args should be real")))
  (define (memq a b) (member a b eq?))
  (define (memv a b) (member a b eqv?)))

(define tests 1)
(define keep-going #f)
(define all-args #f)
(define test-at-random 0)
(if (<= tests 0) (set! tests 1))

#|
(set! *#readers* 
      (cons (cons #\_ (lambda (str)
			(if (string=? str "__line__")
			    (port-line-number)
			    #f)))
            *#readers*))
|#
(set! *#readers* (cons (cons #\_ _snd-line-reader_) *#readers*))

(define (copy-file source dest) (system (string-append "cp " source " " dest)))

(define-expansion (fill-float-vector v body)
  `(let ((len (length ,v)))
     (do ((i 0 (+ i 1)))
	 ((= i len) ,v)
       (float-vector-set! ,v i ,body))))

(define-expansion (outa->fv v body) 
  `(let ((len (length ,v)))
     (set! *output* ,v) 
     (do ((i 0 (+ i 1)))
	 ((= i len) (set! *output* #f) ,v)
       (outa i ,body))))

(define* (cfft! data n (dir 1))
  (if (not n) (set! n (length data)))
  (let ((t0 (complex 0.0 (* pi dir))))
    (do ((i 0 (+ i 1))
	 (j 0))
	((= i n))
      (if (> j i)
	  (let ((temp (data j)))
	    (set! (data j) (data i))
	    (set! (data i) temp)))
      (let ((m (/ n 2)))
	(do () 
	    ((or (< m 2) (< j m)))
	  (set! j (- j m))
	  (set! m (/ m 2)))
	(set! j (+ j m))))
    (let ((ipow (floor (log n 2)))
	  (prev 1))
      (do ((lg 0 (+ lg 1))
	   (mmax 2 (* mmax 2))
	   (pow (/ n 2) (/ pow 2))
	   (theta t0 (* theta 0.5)))
	  ((= lg ipow))
	(let ((wpc (exp theta))
	      (wc 1.0))
	  (do ((ii 0 (+ ii 1)))
	      ((= ii prev))
	    (do ((jj 0 (+ jj 1))
		 (i ii (+ i mmax))
		 (j (+ ii prev) (+ j mmax)))
		((>= jj pow))
	      (let ((tc (* wc (data j))))
		(set! (data j) (- (data i) tc))
		(set! (data i) (+ (data i) tc))))
	    (set! wc (* wc wpc)))
	  (set! prev mmax))))
    data))

(define* (fft! rl im n (dir 1))
  (if (not im)
      (set! im (make-float-vector (length rl))))
  (if (not n)
      (set! n (length rl)))
  (do ((i 0 (+ i 1))
       (j 0))
      ((= i n))
    (if (> j i)
	(let ((tempr (rl j))
	      (tempi (im j)))
	  (set! (rl j) (rl i))
	  (set! (im j) (im i))
	  (set! (rl i) tempr)
	  (set! (im i) tempi)))
    (let ((m (/ n 2)))
      (do () 
	  ((or (< m 2) (< j m)))
	(set! j (- j m))
	(set! m (/ m 2)))
      (set! j (+ j m))))
  (let ((ipow (floor (log n 2)))
	(prev 1))
    (do ((lg 0 (+ lg 1))
	 (mmax 2 (* mmax 2))
	 (pow (/ n 2) (/ pow 2))
	 (theta (* pi dir) (* theta 0.5)))
	((= lg ipow))
      (let ((wpr (cos theta))
	    (wpi (sin theta))
	    (wr 1.0)
	    (wi 0.0))
	(do ((ii 0 (+ ii 1)))
	    ((= ii prev))
	  (do ((jj 0 (+ jj 1))
	       (i ii (+ i mmax))
	       (j (+ ii prev) (+ j mmax)))
	      ((>= jj pow))
	    (let ((tempr (- (* wr (rl j)) (* wi (im j))))
		  (tempi (+ (* wr (im j)) (* wi (rl j)))))
	      (set! (rl j) (- (rl i) tempr))
	      (set! (im j) (- (im i) tempi))
	      (set! (rl i) (+ (rl i) tempr))
	      (set! (im i) (+ (im i) tempi))))
	  (let ((wtemp wr))
	    (set! wr (- (* wr wpr) (* wi wpi)))
	    (set! wi (+ (* wi wpr) (* wtemp wpi)))))
	(set! prev mmax))))
  rl)

(if (not (defined? 'snd-test)) (define snd-test -1))
(define full-test (< snd-test 0))
(define total-tests 26)
(if (not (defined? 'with-exit)) (define with-exit (< snd-test 0)))
(define s7test-exits #f)
(define test-number -1)

(define-constant (snd-display line . args)
  (let ((str (if (null? (cdr args))
		 (car args)
		 (if (or (string? (car args))
			 (and (not (car args))
			      (string? (cadr args))))
		     (apply format #f args)
		     (object->string args)))))
    (format *stderr* "~%~A: ~8T~A" line str)
    (if (not (provided? 'snd-nogui))
	(snd-print (format #f "~%~A: ~A" line str)))))

(define with-big-file #f)
(define big-file-name "/home/bil/zap/sounds/bigger.snd")
(if with-big-file 
    (begin
      (set! with-big-file (file-exists? big-file-name))
      (if (not with-big-file) (snd-display #__line__ ";no big file"))))
(define big-file-framples 0)

(define original-save-dir (or *save-dir* "~/zap/snd"))
(define original-temp-dir (or *temp-dir* "~/zap/tmp"))
(define original-sound-file-extensions (sound-file-extensions))

(unbind-key #\c 4 #t)
;;; clear out old junk!
(if (file-exists? original-save-dir) 
    (system (format #f "rm ~A/snd_*" original-save-dir)))
(if (file-exists? original-temp-dir) 
    (system (format #f "rm ~A/snd_*" original-temp-dir)))
(if (file-exists? "/tmp")
    (begin ; -noinit possibly
      (system "rm /tmp/snd_*")
      (system "rm /tmp/*.snd")))
(if (file-exists? "/var/tmp")
    (begin ; -noinit possibly
      (system "rm /var/tmp/snd_*")
      (system "rm /var/tmp/*.snd")))
(system "rm core*")

(define home-dir (getenv "HOME"))
(define sf-dir "/sf1")

(if (not (file-exists? (string-append home-dir "/cl/oboe.snd")))
    (if (file-exists? "/export/home/bil/cl/oboe.snd")
	(set! home-dir "/export/home/bil")
	(if (file-exists? "/Users/bil/cl/oboe.snd")
	    (set! home-dir "/Users/bil")
	    (if (file-exists? "/users/b/bil/cl/oboe.snd")
		(set! home-dir "/users/b/bil")
		(if (file-exists? "/usr/home/bil/cl/oboe.snd")
		    (set! home-dir "/usr/home/bil"))))))
(define cwd (string-append (getcwd) "/"))

(define sf-dir1 (string-append home-dir sf-dir "/"))
(if (not (file-exists? (string-append sf-dir1 "alaw.wav")))
    (begin
      (set! sf-dir "/sf")
      (set! sf-dir1 (string-append home-dir sf-dir "/"))
      (if (not (file-exists? (string-append sf-dir1 "alaw.wav")))
	  (begin
	    (snd-display #__line__ ";;;can't find sf directory!")
	    (set! sf-dir1 #f)))))
(set! sf-dir sf-dir1)

(if (not (string=? (getcwd) (string-append home-dir "/cl")))
    (for-each
     (lambda (file)
       (if (not (file-exists? file))
	   (begin
	     (format #t "copying ~A~%" file)
	     (copy-file (string-append home-dir "/cl/" file) (string-append (getcwd) "/" file)))))
     (list "4.aiff" "2.snd" "obtest.snd" "oboe.snd" "pistol.snd" "1a.snd" "now.snd" "fyow.snd"
	   "storm.snd" "z.snd" "1.snd" "cardinal.snd" "now.snd.scm" "2a.snd" "4a.snd" "zero.snd"
	   "loop.scm" "cmn-glyphs.lisp" "bullet.xpm" "mb.snd" "funcs.scm" "trumpet.snd" "1234.snd")))

(for-each mus-sound-preload (list "4.aiff" "2.snd" "obtest.snd" "oboe.snd" "pistol.snd" "1a.snd" "now.snd" 
				  "fyow.snd" "storm.snd" "1.snd" "cardinal.snd" "2a.snd"))



;;(setlocale LC_ALL "de_DE")
(set! *with-background-processes* #f)

;; try to get a different random number sequence on each run
(set! (mus-rand-seed) (current-time))

(set! (hook-functions bad-header-hook) ())
(hook-push bad-header-hook (lambda (hook) (set! (hook 'result) #t)))

(define with-motif (provided? 'snd-motif))

(define with-gui (or (provided? 'snd-gtk)
		     (provided? 'snd-motif)))

(if (not with-gui)
    (define y-bounds (dilambda
		      (lambda args (list -1.0 1.0))
		      (lambda args (list -1.0 1.0)))))

(if (not with-gui)
    (define x-bounds (dilambda
		      (lambda args (list 0.0 0.1))
		      (lambda args (list 0.0 0.1)))))

(define real-time get-internal-real-time)
(define (hundred n) (round (* 100 n)))
(define times ())
(define-macro (time a) 
  `(let ((start (real-time))) 
     ,a 
     (let ((val (hundred (- (real-time) start))))
       (set! times (cons (list ',a val) times)))))

(define original-prompt *listener-prompt*)
(set! (show-listener) #t)
(set! (window-x) 600)
(set! (window-y) 10)


(define-expansion (fneq a b)
  `(> (magnitude (- ,a ,b)) .001))

(define-expansion (ffneq a b)
  `(> (magnitude (- ,a ,b)) .01))

(define-expansion (fffneq a b) 
  `(> (magnitude (- ,a ,b)) .1))

(define (cneq a b)
  (> (magnitude (- a b)) .001))

(define-constant (feql a b)
  (let ((old-eps (*s7* 'morally-equal-float-epsilon)))
    (set! (*s7* 'morally-equal-float-epsilon) .001)
    (let ((res (morally-equal? a b)))
      (set! (*s7* 'morally-equal-float-epsilon) old-eps)
      res)))

(define-constant (ffeql a b)
  (let ((old-eps (*s7* 'morally-equal-float-epsilon)))
    (set! (*s7* 'morally-equal-float-epsilon) .1)
    (let ((res (morally-equal? a b)))
      (set! (*s7* 'morally-equal-float-epsilon) old-eps)
      res)))

(define-constant (fveql a b i)
  (or (null? b)
      (and (not (fneq (car b) (a i)))
	   (fveql a (cdr b) (+ i 1)))))

(define* (mus-arrays-equal? x y (err .001))
  (let ((old-eps (*s7* 'morally-equal-float-epsilon)))
    (set! (*s7* 'morally-equal-float-epsilon) err)
    (let ((res (morally-equal? x y)))
      (set! (*s7* 'morally-equal-float-epsilon) old-eps)
      res)))

(define-constant sd-equal mus-arrays-equal?)
(define-constant vequal mus-arrays-equal?)

(define (vequal1 v0 v1)
  (mus-arrays-equal? v0 v1 .01))

(define (vvequal v0 v1)
  (mus-arrays-equal? v0 v1 .00002))

(define (vmaxdiff v0 v1)
  (float-vector-peak (float-vector-subtract! (copy v0) v1)))

(define (within-.01? a b) (< (abs (- a b)) .01))

(define-constant (string-=? a b) ;(format *stderr* "str: ~A ~A~%" a b)
  (or (string=? a b)
      (and (or (char-position #\- a) 
	       (char-position #\- b))
	   (let ((alen (length a))
		 (blen (length b))
		 (j 0)
		 (happy #t))
	     (do ((i 0 (+ i 1)))
		 ((or (not happy) 
		      (= i alen))
		  (and happy 
		       (= j blen)))
	       (let ((ac (a i))
		     (bc (b j)))
		 (if (char=? ac bc)
		     (set! j (+ j 1))
		     (if (not (and (char=? ac #\-)	
				   (<= i (- alen 7))
				   (string=? (substring a i (+ i 6)) "-0.000")))
			 (if (and (char=? bc #\-)
				  (<= j (- blen 7))
				  (string=? (substring b j (+ j 6)) "-0.000"))
			     (begin
			       (set! j (+ j 1))
			       (if (not (char=? ac (b j)))
				   (set! happy #f)
				   (set! j (+ j 1))))
			     (set! happy #f))))))))))

(define dismiss-all-dialogs
  (let ((documentation "(dismiss-all-dialogs) hides all dialogs"))
    (lambda ()
      (if (or (provided? 'xm)
	      (provided? 'xg))
	  (for-each
	   (lambda (dialog)
	     (if dialog
		 (if (symbol? (car dialog))
		     (if (provided? 'snd-motif)
			 (if ((*motif* 'XtIsManaged) dialog)
			     ((*motif* 'XtUnmanageChild) dialog))
			 (if (provided? 'snd-gtk)
			     ((*gtk* 'gtk_widget_hide) dialog)))
		     (for-each
		      (lambda (d)
			(if (symbol? (car d))
			    (if (provided? 'snd-motif)
				(if ((*motif* 'XtIsManaged) d)
				    ((*motif* 'XtUnmanageChild) d))
				(if (provided? 'snd-gtk)
				    ((*gtk* 'gtk_widget_hide) d)))))
		      dialog))))
	   (dialog-widgets))))))

(define safe-color (make-color 1 0 0))
(define make-color-with-catch 
  (let ((documentation "make-color but catch 'no-such-color"))
    (lambda (c1 c2 c3)
      (catch 'no-such-color
	(lambda () (make-color c1 c2 c3))
	(lambda args safe-color)))))

(define safe-display-edits 
  (let ((documentation "display-edits but catch all errors"))
    (lambda* (snd chn edpos)
      (catch #t
	(lambda () (display-edits snd chn edpos))
	(lambda args (snd-display #__line__ ";display-edits error: ~A" args))))))

(define (safe-divide a b)
  (if (zero? b)
      a
      (/ a b)))

(define timings (make-vector (+ total-tests 1) 0))
(define default-srate *clm-srate*)

(snd-display #__line__ ";;~A" (snd-version))
(if (not (defined? 'before-test-hook)) (define before-test-hook (make-hook 'n)))
(if (not (defined? 'after-test-hook)) (define after-test-hook (make-hook 'n)))
(set! (hook-functions before-test-hook) ())
(hook-push before-test-hook (lambda (hook)
			      (let ((n (hook 'n)))
				(set! *clm-srate* default-srate)
				(dismiss-all-dialogs)
				(set! *clipping* #f)
				(set! (mus-clipping) #f) ; this cost me a morning of confusion!
				(set! test-number n)
				(set! (timings n) (real-time))
				(snd-display #__line__ ";test ~D" n)
				)))


(define (clear-save-state-files)
  (for-each forget-region (regions))
  (system (format #f "rm -f ~A/snd_*" (or *save-dir* original-save-dir)))
  (if (file-exists? "/var/tmp") 
      (system "rm -f /var/tmp/snd_save_*"))
  (if (file-exists? "/tmp") 
      (system "rm -f /tmp/snd_save_*"))
  (mus-sound-prune))

(set! (hook-functions after-test-hook) ())
(hook-push after-test-hook
	   (lambda (hook)
	     (let ((n (hook 'n)))
	       (clear-save-state-files)
	       (clear-listener)
	       (set! *ask-about-unsaved-edits* #f)
	       (if (pair? (sounds))
		   (begin
		     (snd-display #__line__ ";end test ~D: open sounds: ~A" n (map short-file-name (sounds)))
		     (for-each close-sound (sounds))))
	       (if (number? (vector-ref timings n))
		   (set! (timings n) (hundred (- (real-time) (vector-ref timings n))))))))

(define overall-start-time (real-time))
(snd-display #__line__ ";~A~%" (strftime "%d-%b %H:%M %Z" (localtime (current-time))))

(define (log-mem tst) 
  (if (> tests 1) (snd-display #__line__ ";test ~D:~D " test-number (+ 1 tst))))

(define-macro (without-errors func)
  `(catch #t ; but this also squelches syntax errors!
	  (lambda ()
	    ,func)
	  (lambda args 
	    (car args))))

(require snd-hooks.scm snd-ws.scm)

(define (set-arity-ok func args)
  (let ((arit (if (dilambda? func)
		   (arity (procedure-setter func))
		   (and (procedure? (procedure-setter func))
			(arity (procedure-setter func))))))
    (and (pair? arit)
	 (>= args (car arit))
	 (<= args (cdr arit)))))

(define* (scale-sound-by scl beg dur snd chn edpos)
  (if (integer? chn)
      (scale-channel scl beg dur snd chn edpos)
      (do ((i 0 (+ i 1)))
	  ((= i (channels snd)))
	(scale-channel scl beg dur snd i))))

(define* (scale-sound-to norm beg dur snd chn)
  (if (integer? chn)
      (let ((mx (maxamp snd chn)))
	(if (and (not (= mx 0.0))
		 (not (= mx norm)))
	    (scale-channel (/ norm mx) beg dur snd chn)))
      (let ((mx (apply max (maxamp snd #t))))
	(if (and (not (= mx 0.0))
		 (not (= mx norm)))
	    (do ((i 0 (+ i 1)))
		((= i (channels snd)))
	      (scale-channel (/ norm mx) beg dur snd i))))))

(define (file->floats file) (samples 0 (framples file) file))

(define* (floats->file v file (srate 22050) (comment ""))
  (if (float-vector? v)
      (begin
	(array->file file v (length v) srate 1)
	file)
      (error 'wrong-type-arg "file->floats: ~A" v)))


(if (and (> (length (script-args)) 0)
	 (> (script-arg) 0))
    (let ((arg (script-arg))
	  (args (script-args)))
      (if (not (string=? (args (- arg 1)) "-l")) 
	  (snd-display #__line__ ";script-args[~A]: ~A (~A)?" (- arg 1) (args (- arg 1)) args))
      (if (not (string=? (args arg) "snd-test")) 
	  (snd-display #__line__ ";script-args[~A]: ~A (~A)?" arg (args arg) args))
      (if (> (length args) (+ 1 arg))
	  (begin
	    ;; test-number tests
	    (set! snd-test (string->number (args (+ 1 arg))))
	    (set! test-at-random 0)
	    (set! full-test (< snd-test 0))
	    (set! with-exit #t)
	    (set! (script-arg) (+ 1 arg))
	    (if (> (length (script-args)) (+ arg 2))
		(begin
		  (set! tests (string->number (args (+ arg 2))))
		  (set! (script-arg) (+ arg 2))))))))

(if (and (provided? 'snd-motif)
	 (provided? 'xm))
    (require snd-snd-motif.scm)
    (if (and (provided? 'snd-gtk)
	     (provided? 'xg))
	(require snd-snd-gtk.scm)))


(define default-file-buffer-size *clm-file-buffer-size*)
;(set! *clm-file-buffer-size* default-file-buffer-size)

(if (not (defined? 'pi)) 
    (snd-display #__line__ ";pi is not defined!")
    (if (fneq pi 3.14159)
	(snd-display #__line__ ";pi is ~A" pi)))


;;; ---------------- test 0: constants ----------------

(define (snd_test_0)
  (letrec ((test-constants 
	    (lambda (lst)
	      (if (pair? lst)
		  (begin
		    (if (not (= (cadr lst) (caddr lst)))
			(snd-display #__line__ ";~A is not ~A (~A)~%"
				     (car lst) (cadr lst) (caddr lst)))
		    (test-constants (cdddr lst)))))))
    
    (if (or (pair? (sounds))
	    (pair? (mixes))
	    (pair? (marks))
	    (pair? (regions)))
	(snd-display #__line__ ";start up: ~A ~A ~A ~A" (sounds) (mixes) (marks) (regions)))
    (test-constants
     (list
      'enved-amplitude enved-amplitude 0 
      'bartlett-window bartlett-window 4 
      'bartlett-hann-window bartlett-hann-window 21
      'blackman2-window blackman2-window 6 
      'blackman3-window blackman3-window 7 
      'blackman4-window blackman4-window 8
      'blackman5-window blackman5-window 24
      'blackman6-window blackman6-window 25
      'blackman7-window blackman7-window 26
      'blackman8-window blackman8-window 27
      'blackman9-window blackman9-window 28
      'blackman10-window blackman10-window 29
      'bohman-window bohman-window 22
      'cauchy-window cauchy-window 12 
      'mlt-sine-window mlt-sine-window 33
      'papoulis-window papoulis-window 34
      'dpss-window dpss-window 35
      'sinc-window sinc-window 36
      'channels-combined channels-combined 1 
      'channels-separate channels-separate 0 
      'channels-superimposed channels-superimposed 2
      'connes-window connes-window 18
      'cursor-in-middle cursor-in-middle 3
      'cursor-in-view cursor-in-view 0 
      'cursor-on-left cursor-on-left 1 
      'cursor-on-right cursor-on-right 2 
      'dolph-chebyshev-window dolph-chebyshev-window 16
      'exponential-window exponential-window 9 
      'flat-top-window flat-top-window 23
      'sync-none sync-none 0
      'sync-all sync-all 1
      'sync-by-sound sync-by-sound 2
      'zoom-focus-active zoom-focus-active 2
      'zoom-focus-left zoom-focus-left 0
      'zoom-focus-middle zoom-focus-middle 3
      'zoom-focus-right zoom-focus-right 1 
      'gaussian-window gaussian-window 14 
      'graph-dots graph-dots 1
      'graph-dots-and-lines graph-dots-and-lines 3 
      'graph-filled graph-filled 2 
      'graph-lines graph-lines 0 
      'graph-lollipops graph-lollipops 4
      'hamming-window hamming-window 5
      'hann-window hann-window 1
      'hann-poisson-window hann-poisson-window 17
      'kaiser-window kaiser-window 11 
      'keyboard-no-action keyboard-no-action 4
      'graph-once graph-once 0 
      'parzen-window parzen-window 3
      'poisson-window poisson-window 13
      'rectangular-window rectangular-window 0 
      'riemann-window riemann-window 10 
      'rv2-window rv2-window 30
      'rv3-window rv3-window 31
      'rv4-window rv4-window 32
      'samaraki-window samaraki-window 19
      'ultraspherical-window ultraspherical-window 20
      'graph-as-sonogram graph-as-sonogram 1
      'graph-as-spectrogram graph-as-spectrogram 2 
      'graph-once graph-once 0
      'graph-as-wavogram graph-as-wavogram 3
      'enved-spectrum enved-spectrum 1
      'speed-control-as-float speed-control-as-float 0 
      'speed-control-as-ratio speed-control-as-ratio 1 
      'speed-control-as-semitone speed-control-as-semitone 2 
      'enved-srate enved-srate 2 
      'tukey-window tukey-window 15 
      'welch-window welch-window 2 
      'cursor-cross cursor-cross 0
      'cursor-line cursor-line 1
      'dont-normalize dont-normalize 0
      'envelope-linear envelope-linear 0
      'envelope-exponential envelope-exponential 1
      'normalize-by-channel normalize-by-channel 1
      'normalize-by-sound normalize-by-sound 2
      'normalize-globally normalize-globally 3
      'x-axis-in-samples x-axis-in-samples 1 
      'x-axis-in-beats x-axis-in-beats 3
      'x-axis-in-measures x-axis-in-measures 4
      'x-axis-in-seconds x-axis-in-seconds 0 
      'x-axis-as-clock x-axis-as-clock 5
      'x-axis-as-percentage x-axis-as-percentage 2
      'enved-add-point enved-add-point 0
      'enved-delete-point enved-delete-point 1
      'enved-move-point enved-move-point 2
      'time-graph time-graph 0
      'transform-graph transform-graph 1
      'lisp-graph lisp-graph 2
      'copy-context copy-context 0
      'cursor-context cursor-context 3
      'selection-context selection-context 2
      'mark-context mark-context 4
      'show-no-axes show-no-axes 0
      'show-all-axes show-all-axes 1
      'show-x-axis show-x-axis 2
      'show-all-axes-unlabelled show-all-axes-unlabelled 3
      'show-x-axis-unlabelled show-x-axis-unlabelled 4
      'show-bare-x-axis show-bare-x-axis 5
      
      ;; sndlib constants
      'mus-unknown-header mus-unknown-header 0
      'mus-next mus-next 1
      'mus-aifc mus-aifc 2
      'mus-riff mus-riff 3
      'mus-nist mus-nist 6
      'mus-raw mus-raw 12
      'mus-ircam mus-ircam 15
      'mus-aiff mus-aiff 49
      'mus-bicsf mus-bicsf 5
      'mus-voc mus-voc 10
      'mus-svx mus-svx 9
      'mus-soundfont mus-soundfont 26
      'mus-rf64 mus-rf64 4
      'mus-caff mus-caff 60
      
      'mus-interp-none mus-interp-none 0
      'mus-interp-linear mus-interp-linear 1
      'mus-interp-sinusoidal mus-interp-sinusoidal 2
      'mus-interp-all-pass mus-interp-all-pass 3
      'mus-interp-lagrange mus-interp-lagrange 4
      'mus-interp-bezier mus-interp-bezier 5
      'mus-interp-hermite mus-interp-hermite 6
      
      'mus-chebyshev-first-kind mus-chebyshev-first-kind 1
      'mus-chebyshev-second-kind mus-chebyshev-second-kind 2
      
      'mus-unknown-sample mus-unknown-sample 0
      'mus-bshort mus-bshort 1
      'mus-lshort mus-lshort 10
      'mus-mulaw mus-mulaw 2
      'mus-alaw mus-alaw 6
      'mus-byte mus-byte 3
      'mus-ubyte mus-ubyte 7
      'mus-bfloat mus-bfloat 4
      'mus-lfloat mus-lfloat 12
      'mus-bint mus-bint 5
      'mus-lint mus-lint 11
      'mus-bintn mus-bintn 17
      'mus-lintn mus-lintn 18
      'mus-b24int mus-b24int 8
      'mus-l24int mus-l24int 16
      'mus-bdouble mus-bdouble 9
      'mus-ldouble mus-ldouble 13
      'mus-ubshort mus-ubshort 14
      'mus-ulshort mus-ulshort 15
      'mus-bfloat-unscaled mus-bfloat-unscaled 19
      'mus-lfloat-unscaled mus-lfloat-unscaled 20
      'mus-bdouble-unscaled mus-bdouble-unscaled 21
      'mus-ldouble-unscaled mus-ldouble-unscaled 22
      ))
    
    (if (not (equal? *region-graph-style* graph-lines))
	(snd-display #__line__ ";region-graph-style set default: ~A" *region-graph-style*))
    (if *ask-about-unsaved-edits*
	(snd-display #__line__ ";ask-about-unsaved-edits set default: ~A" *ask-about-unsaved-edits*))
    (if (not (boolean? *show-full-duration*))
	(snd-display #__line__ ";show-full-duration set default: ~A" *show-full-duration*))
    (if *show-full-range*
	(snd-display #__line__ ";show-full-range set default: ~A" *show-full-range*))
    (if (fneq *initial-beg* 0.0)
	(snd-display #__line__ ";initial-beg set default: ~A" *initial-beg*))
    (if (fneq *initial-dur* 0.1)
	(snd-display #__line__ ";initial-dur set default: ~A" *initial-dur*))
    (if *ask-before-overwrite*
	(snd-display #__line__ ";ask-before-overwrite set default: ~A" *ask-before-overwrite*))
    (if (not *auto-resize*)
	(snd-display #__line__ ";auto-resize set default: ~A" *auto-resize*))
    (if *auto-update*
	(snd-display #__line__ ";auto-update set default: ~A" *auto-update*))
    (if (not (eqv? *channel-style*  1 )) 
	(snd-display #__line__ ";channel-style set default: ~A" *channel-style*))
    (if (and (fneq *color-cutoff*  0.003 ) (fneq *color-cutoff*  0.001))
	(snd-display #__line__ ";color-cutoff set default: ~A" *color-cutoff*))
    (if (not *color-inverted*)
	(snd-display #__line__ ";color-inverted set default: ~A" *color-inverted*))
    (if (fneq *color-scale*  1.0 )
	(snd-display #__line__ ";color-scale set default: ~A" *color-scale*))
    (if (fneq *auto-update-interval*  60.0 )
	(snd-display #__line__ ";auto-update-interval set default: ~A" *auto-update-interval*))
    (if (fneq *cursor-update-interval*  0.05 )
	(snd-display #__line__ ";cursor-update-interval set default: ~A" *cursor-update-interval*))
    (if (not (= *cursor-location-offset*  0))
	(snd-display #__line__ ";cursor-location-offset set default: ~A" *cursor-location-offset*))
    (if (not *dac-combines-channels*)
	(snd-display #__line__ ";dac-combines-channels set default: ~A" *dac-combines-channels*))
    (if (not (eqv? *dac-size*  256 )) 
	(snd-display #__line__ ";dac-size set default: ~A" *dac-size*))
    (if *clipping*
	(snd-display #__line__ ";clipping set default: ~A" *clipping*))
    (if (not (eqv? *default-output-chans*  1 )) 
	(snd-display #__line__ ";default-output-chans set default: ~A" *default-output-chans*))
    (if (and (not (equal? *default-output-sample-type* mus-bdouble))
	     (not (equal? *default-output-sample-type* mus-ldouble)))
	(snd-display #__line__ ";default-output-sample-type set default: ~A" *default-output-sample-type*))
    (if (not (eqv? *default-output-srate*  44100 )) 
	(snd-display #__line__ ";default-output-srate set default: ~A" *default-output-srate*))
    (if (not (equal? *default-output-header-type*  mus-next)) 
	(snd-display #__line__ ";default-output-header-type set default: ~A" *default-output-header-type*))
    (if (not (eqv? *dot-size*  1 )) 
	(snd-display #__line__ ";dot-size set default: ~A" *dot-size*))
    (if (not (eqv? *cursor-size*  15 )) 
	(snd-display #__line__ ";cursor-size set default: ~A" *cursor-size*))
    (if (not (equal? *cursor-style*  cursor-cross )) 
	(snd-display #__line__ ";cursor-style set default: ~A" *cursor-style*))
    (if (not (equal? *tracking-cursor-style*  cursor-line )) 
	(snd-display #__line__ ";tracking-cursor-style set default: ~A" *tracking-cursor-style*))
    (if (fneq *enved-base*  1.0 )
	(snd-display #__line__ ";enved-base set default: ~A" *enved-base*))
    (if (not (enved-clip?))
	(snd-display #__line__ ";enved-clip? set default: ~A" (enved-clip?)))
    (if (not (enved-filter))
	(snd-display #__line__ ";enved-filter set default: ~A" (enved-filter)))
    (if (not (eqv? *enved-filter-order*  40)) 
	(snd-display #__line__ ";enved-filter-order set default: ~A" *enved-filter-order*))
    (if (enved-in-dB)
	(snd-display #__line__ ";enved-in-dB set default: ~A" (enved-in-dB)))
    (if (not (equal? *enved-style*  envelope-linear )) 
	(snd-display #__line__ ";enved-style set default: ~A" *enved-style*))
    (if (fneq *enved-power*  3.0)
	(snd-display #__line__ ";enved-power set default: ~A" *enved-power*))
    (if (not (eqv? *enved-target*  0 )) 
	(snd-display #__line__ ";enved-target set default: ~A" *enved-target*))
    (if *enved-wave?*
	(snd-display #__line__ ";enved-wave? set default: ~A" *enved-wave?*))
    (if (and with-gui
	     (pair? (enved-envelope)))
	(snd-display #__line__ ";enved-envelope set default: ~A" (enved-envelope)))
    (if (not (equal? *eps-file*  "snd.eps" )) 
	(snd-display #__line__ ";eps-file set default: ~A" *eps-file*))
    (if (fneq *eps-bottom-margin*  0.0)
	(snd-display #__line__ ";eps-bottom-margin set default: ~A" *eps-bottom-margin*))
    (if (fneq *eps-left-margin*  0.0)
	(snd-display #__line__ ";eps-left-margin set default: ~A" *eps-left-margin*))
    (if (fneq *eps-size*  1.0)
	(snd-display #__line__ ";eps-size set default: ~A" *eps-size*))
    (if (fneq *fft-window-alpha*  0.0 )
	(snd-display #__line__ ";fft-window-alpha set default: ~A" *fft-window-alpha*))
    (if (fneq *fft-window-beta*  0.0 )
	(snd-display #__line__ ";fft-window-beta set default: ~A" *fft-window-beta*))
    (if *fft-log-frequency*
	(snd-display #__line__ ";fft-log-frequency set default: ~A" *fft-log-frequency*))
    (if *fft-log-magnitude*
	(snd-display #__line__ ";fft-log-magnitude set default: ~A" *fft-log-magnitude*))
    (if *fft-with-phases*
	(snd-display #__line__ ";fft-with-phases set default: ~A" *fft-with-phases*))
    (if (not (member *transform-size* (list 1024 4096)))
	(snd-display #__line__ ";transform-size set default: ~A" *transform-size*))
    (if (not (equal? *transform-graph-type* graph-once))
	(snd-display #__line__ ";transform-graph-type set default: ~A" *transform-graph-type*))
    (if (not (eqv? *fft-window*  6 )) 
	(snd-display #__line__ ";fft-window set default: ~A" *fft-window*))
    (if (not (eqv? *graph-cursor*  34)) 
	(snd-display #__line__ ";graph-cursor set default: ~A" *graph-cursor*))
    (if (not (equal? *graph-style*  graph-lines )) 
	(snd-display #__line__ ";graph-style set default: ~A" *graph-style*))
    (if (not *graphs-horizontal*)
	(snd-display #__line__ ";graphs-horizontal set default: ~A" *graphs-horizontal*))
    (if (not (equal? *html-dir*  ".")) 
	(snd-display #__line__ ";html-dir set default: ~A" *html-dir*))
    (if (not (equal? *html-program*  "firefox")) 
	(snd-display #__line__ ";html-program set default: ~A" *html-program*))
    (if (not *just-sounds*) 
	(snd-display #__line__ ";just-sounds set default: ~A" *just-sounds*))
    (if (not (string? *listener-prompt*)) 
	(snd-display #__line__ ";listener-prompt set default: ~A" *listener-prompt*))
    (if (not (eqv? *max-transform-peaks*  100)) 
	(snd-display #__line__ ";max-transform-peaks set default: ~A" *max-transform-peaks*))
    (if (not (eqv? *max-transform-peaks* 100)) 
	(snd-display #__line__ ";max-transform-peaks set -123: ~A" *max-transform-peaks*))
    (if (not (eqv? *max-regions*  16 )) 
	(snd-display #__line__ ";max-regions set default: ~A" *max-regions*))
    (if (fneq *min-dB*  -60.0 )
	(snd-display #__line__ ";min-dB set default: ~A" *min-dB*))
    (if (fneq *log-freq-start*  32.0 )
	(snd-display #__line__ ";log-freq-start set default: ~A" *log-freq-start*))
    (if (not *selection-creates-region*) 
	(snd-display #__line__ ";selection-creates-region set default: ~A" *selection-creates-region*))
    (if (not (equal? *transform-normalization*  normalize-by-channel)) 
	(snd-display #__line__ ";transform-normalization set default: ~A" *transform-normalization*))

    (if (and with-motif 
	     (not (eqv? (view-files-sort)  0 ))) 
	(snd-display #__line__ ";view-files-sort set default: ~A" (view-files-sort)))

    (if (not (member *print-length*  '(12 32) ))
	(snd-display #__line__ ";print-length set default: ~A" *print-length*))
    (if (not (eqv? *play-arrow-size*  10 )) 
	(snd-display #__line__ ";play-arrow-size set default: ~A" *play-arrow-size*))
    (if (not (equal? *save-state-file*  "saved-snd.scm" )) 
	(snd-display #__line__ ";save-state-file set default: ~A" *save-state-file*))
    (if (not (eqv? *show-axes*  1)) 
	(snd-display #__line__ ";show-axes set default: ~A" *show-axes*))
    (if (not (boolean? *show-transform-peaks*)) 
	(snd-display #__line__ ";show-transform-peaks set default: ~A" *show-transform-peaks*))
    (if (not (boolean? *show-indices*)) 
	(snd-display #__line__ ";show-indices set default: ~A" *show-indices*))
    (if (not *show-marks*)
	(snd-display #__line__ ";show-marks set default: ~A" *show-marks*))
    (if (not *show-mix-waveforms*) 
	(snd-display #__line__ ";show-mix-waveforms set default: ~A" *show-mix-waveforms*))
    (if *show-selection-transform*
	(snd-display #__line__ ";show-selection-transform set default: ~A" *show-selection-transform*))
    (if *show-y-zero*
	(snd-display #__line__ ";show-y-zero set default: ~A" *show-y-zero*))
    (if *show-grid*
	(snd-display #__line__ ";show-grid set default: ~A" *show-grid*))
    (if (fneq *grid-density* 1.0)
	(snd-display #__line__ ";grid-density set default: ~A" *grid-density*))
    (if *show-sonogram-cursor* 
	(snd-display #__line__ ";show-sonogram-cursor set default: ~A" *show-sonogram-cursor*))
    (if (not (eqv? *sinc-width*  10 )) 
	(snd-display #__line__ ";sinc-width set default: ~A" *sinc-width*))
    (if (fneq *spectrum-end*  1.0)
	(snd-display #__line__ ";spectrum-end set default: ~A" *spectrum-end*))
    (if (not (eqv? *spectro-hop*  4 )) 
	(snd-display #__line__ ";spectro-hop set default: ~A" *spectro-hop*))
    (if (fneq *spectrum-start*  0.0 )
	(snd-display #__line__ ";spectrum-start set default: ~A" *spectrum-start*))
    (if (fneq *spectro-x-angle*  (if (provided? 'gl) 300.0 90.0))
	(snd-display #__line__ ";spectro-x-angle set default: ~A" *spectro-x-angle*))
    (if (fneq *spectro-x-scale* (if (provided? 'gl) 1.5 1.0))
	(snd-display #__line__ ";spectro-x-scale set default: ~A" *spectro-x-scale*))
    (if (fneq *spectro-y-angle* (if (provided? 'gl) 320.0 0.0))
	(snd-display #__line__ ";spectro-y-angle set default: ~A" *spectro-y-angle*))
    (if (fneq *spectro-y-scale*  1.0 )
	(snd-display #__line__ ";spectro-y-scale set default: ~A" *spectro-y-scale*))
    (if (fneq *spectro-z-angle* (if (provided? 'gl) 0.0 358.0))
	(snd-display #__line__ ";spectro-z-angle set default: ~A" *spectro-z-angle*))
    (if (fneq *spectro-z-scale* (if (provided? 'gl) 1.0 0.1))
	(snd-display #__line__ ";spectro-z-scale set default: ~A" *spectro-z-scale*))
    (if (and *temp-dir* (not (equal? *temp-dir* "/home/bil/zap/tmp")))
	(snd-display #__line__ ";temp-dir set default: ~A" *temp-dir*))
    (if (not (equal? *ladspa-dir*  "" )) 
	(snd-display #__line__ ";ladspa-dir set default: ~A" *ladspa-dir*))
    (if (and *peak-env-dir* (not (equal? *peak-env-dir* "/home/bil/peaks")))
	(snd-display #__line__ ";peak-env-dir set default: ~A" *peak-env-dir*))
    (if (and (not (equal? *tiny-font* "6x12"))
	     (not (equal? *tiny-font* "Sans 8")))
	(snd-display #__line__ ";tiny-font set default: ~A" *tiny-font*))
    (if (not (equal? *transform-type*  fourier-transform )) 
	(snd-display #__line__ ";transform-type set default: ~A" *transform-type*))
    (if (not (eq? *with-file-monitor*  #t)) 
	(snd-display #__line__ ";with-file-monitor set default: ~A" *with-file-monitor*))
    (if (not (eqv? *clm-table-size* 512)) 
	(snd-display #__line__ ";clm-table-size set default: ~A" *clm-table-size*))
    (if (not (eqv? *clm-table-size* 512)) 
	(snd-display #__line__ ";*clm-table-size*: ~A" *clm-table-size*))
    (if (fneq *clm-default-frequency* 0.0)
	(snd-display #__line__ ";clm-default-frequency set default: ~A" *clm-default-frequency*))
    (if (fneq *clm-default-frequency* 0.0)
	(snd-display #__line__ ";*clm-default-frequency*: ~A" *clm-default-frequency*))
    (if (not (boolean? *with-verbose-cursor*)) 
	(snd-display #__line__ ";with-verbose-cursor set default: ~A" *with-verbose-cursor*))
    (if (not (boolean? *with-inset-graph*))
	(snd-display #__line__ ";with-inset-graph set default: ~A" *with-inset-graph*))
    (if (not *with-interrupts*)
	(snd-display #__line__ ";with-interrupts set default: ~A" *with-interrupts*))
    (if *remember-sound-state*
	(snd-display #__line__ ";remember-sound-state set default: ~A" *remember-sound-state*))
    (if *with-smpte-label*
	(snd-display #__line__ ";with-smpte-label set default: ~A" *with-smpte-label*))
    (if (not (eq? *with-toolbar* (provided? 'snd-gtk)))
	(snd-display #__line__ ";with-toolbar set default: ~A" *with-toolbar*))
    (if (not *with-tooltips*)
	(snd-display #__line__ ";with-tooltips set default: ~A" *with-tooltips*))
    (if (not (boolean? *with-menu-icons*))
	(snd-display #__line__ ";with-menu-icons set default: ~A" *with-menu-icons*))
    (if *save-as-dialog-src*
	(snd-display #__line__ ";save-as-dialog-src set default: ~A" *save-as-dialog-src*))
    (if *save-as-dialog-auto-comment*
	(snd-display #__line__ ";save-as-dialog-auto-comment set default: ~A" *save-as-dialog-auto-comment*))
    (if (not (boolean? *with-pointer-focus*)) 
	(snd-display #__line__ ";with-pointer-focus set default: ~A" *with-pointer-focus*))
    (if (not (eqv? *wavelet-type*  0 )) 
	(snd-display #__line__ ";wavelet-type set default: ~A" *wavelet-type*))
    (if (not (equal? *time-graph-type*  graph-once)) 
	(snd-display #__line__ ";time-graph-type set default: ~A" *time-graph-type*))
    (if (not (eqv? *wavo-hop*  3 )) 
	(snd-display #__line__ ";wavo-hop set default: ~A" *wavo-hop*))
    (if (not (eqv? *wavo-trace*  64 )) 
	(snd-display #__line__ ";wavo-trace set default: ~A" *wavo-trace*))
    (if (not (eqv? *x-axis-style*  0 )) 
	(snd-display #__line__ ";x-axis-style set default: ~A" *x-axis-style*))
    (if (fneq *beats-per-minute*  60.0 )
	(snd-display #__line__ ";beats-per-minute set default: ~A" *beats-per-minute*))
    (if (not (= *beats-per-measure*  4))
	(snd-display #__line__ ";beats-per-measure set default: ~A" *beats-per-measure*))
    (if (not (eqv? *zero-pad*  0)) 
	(snd-display #__line__ ";zero-pad set default: ~A" *zero-pad*))
    (if (not (eqv? *zero-pad*  0)) 
	(snd-display #__line__ ";zero-pad set -123: ~A" *zero-pad*))
    (if (not (null? (zero-pad #t #t)))
	(snd-display #__line__ ";zero-pad #t: ~A" (zero-pad #t #t)))
    (if (not (eqv? *zoom-focus-style*  2 )) 
	(snd-display #__line__ ";zoom-focus-style set default: ~A" *zoom-focus-style*))
    (if (not (equal? *sync-style*  sync-by-sound )) 
	(snd-display #__line__ ";sync-style set default: ~A" *sync-style*))    
    (if (not (eqv? *mix-waveform-height*  20 )) 
	(snd-display #__line__ ";mix-waveform-height set default: ~A" *mix-waveform-height*))
    (if (not (eqv? *mix-tag-width*  6)) 
	(snd-display #__line__ ";mix-tag-width set default: ~A" *mix-tag-width*))
    (if (not (eqv? *mix-tag-height*  14)) 
	(snd-display #__line__ ";mix-tag-height set default: ~A" *mix-tag-height*))
    (if (not (eqv? *mark-tag-width*  10)) 
	(snd-display #__line__ ";mark-tag-width set default: ~A" *mark-tag-width*))
    (if (not (eqv? *mark-tag-height*  4)) 
	(snd-display #__line__ ";mark-tag-height set default: ~A" *mark-tag-height*))

    (if (not (equal? *region-graph-style* graph-lines))
	(snd-display #__line__ ";* region-graph-style set default: ~A" *region-graph-style*))
    (if *ask-about-unsaved-edits*
	(snd-display #__line__ ";* ask-about-unsaved-edits set default: ~A" *ask-about-unsaved-edits*))
    (if *show-full-range*
	(snd-display #__line__ ";* show-full-range set default: ~A" *show-full-range*))
    (if (fneq *initial-beg* 0.0)
	(snd-display #__line__ ";* initial-beg set default: ~A" *initial-beg*))
    (if (fneq *initial-dur* 0.1)
	(snd-display #__line__ ";* initial-dur set default: ~A" *initial-dur*))
    (if *ask-before-overwrite*
	(snd-display #__line__ ";* ask-before-overwrite set default: ~A" *ask-before-overwrite*))
    (if (not *auto-resize*) 
	(snd-display #__line__ ";* auto-resize set default: ~A" *auto-resize*))
    (if *auto-update*
	(snd-display #__line__ ";* auto-update set default: ~A" *auto-update*))
    (if (not (eqv? *channel-style*  1 )) 
	(snd-display #__line__ ";* channel-style set default: ~A" *channel-style*))
    (if (and (fneq *color-cutoff*  0.003 ) (fneq *color-cutoff*  0.001))
	(snd-display #__line__ ";* color-cutoff set default: ~A" *color-cutoff*))
    (if (not (eq? *color-inverted*  #t)) 
	(snd-display #__line__ ";* color-inverted set default: ~A" *color-inverted*))
    (if (fneq *color-scale*  1.0 )
	(snd-display #__line__ ";* color-scale set default: ~A" *color-scale*))
    (if (fneq *auto-update-interval*  60.0 )
	(snd-display #__line__ ";* auto-update-interval set default: ~A" *auto-update-interval*))
    (if (fneq *cursor-update-interval*  0.05 )
	(snd-display #__line__ ";* cursor-update-interval set default: ~A" *cursor-update-interval*))
    (if (not (= *cursor-location-offset*  0))
	(snd-display #__line__ ";* cursor-location-offset set default: ~A" *cursor-location-offset*))
    (if (not (eq? *dac-combines-channels*  #t)) 
	(snd-display #__line__ ";* dac-combines-channels set default: ~A" *dac-combines-channels*))
    (if (not (eqv? *dac-size*  256 )) 
	(snd-display #__line__ ";* dac-size set default: ~A" *dac-size*))
    (if *clipping*
	(snd-display #__line__ ";* clipping set default: ~A" *clipping*))
    (if (not (eqv? *default-output-chans*  1 )) 
	(snd-display #__line__ ";* default-output-chans set default: ~A" *default-output-chans*))
    (if (and (not (equal? *default-output-sample-type* mus-bdouble))
	     (not (equal? *default-output-sample-type* mus-ldouble)))
	(snd-display #__line__ ";* default-output-sample-type set default: ~A" *default-output-sample-type*))
    (if (not (eqv? *default-output-srate*  44100 )) 
	(snd-display #__line__ ";* default-output-srate set default: ~A" *default-output-srate*))
    (if (not (equal? *default-output-header-type*  mus-next)) 
	(snd-display #__line__ ";* default-output-header-type set default: ~A" *default-output-header-type*))
    (if (not (eqv? *dot-size*  1 )) 
	(snd-display #__line__ ";* dot-size set default: ~A" *dot-size*))
    (if (not (eqv? *cursor-size*  15 )) 
	(snd-display #__line__ ";* cursor-size set default: ~A" *cursor-size*))
    (if (not (equal? *cursor-style*  cursor-cross )) 
	(snd-display #__line__ ";* cursor-style set default: ~A" *cursor-style*))
    (if (not (equal? *tracking-cursor-style*  cursor-line )) 
	(snd-display #__line__ ";* tracking-cursor-style set default: ~A" *tracking-cursor-style*))
    (if (fneq *enved-base*  1.0 )
	(snd-display #__line__ ";* enved-base set default: ~A" *enved-base*))
    (if (not (eqv? *enved-filter-order*  40)) 
	(snd-display #__line__ ";* enved-filter-order set default: ~A" *enved-filter-order*))
    (if (not (equal? *enved-style*  envelope-linear )) 
	(snd-display #__line__ ";* enved-style set default: ~A" *enved-style*))
    (if (fneq *enved-power*  3.0)
	(snd-display #__line__ ";* enved-power set default: ~A" *enved-power*))
    (if (not (eqv? *enved-target*  0 )) 
	(snd-display #__line__ ";* enved-target set default: ~A" *enved-target*))
    (if *enved-wave?*
	(snd-display #__line__ ";* enved-wave? set default: ~A" *enved-wave?*))
    (if (not (equal? *eps-file*  "snd.eps" )) 
	(snd-display #__line__ ";* eps-file set default: ~A" *eps-file*))
    (if (fneq *eps-bottom-margin*  0.0)
	(snd-display #__line__ ";* eps-bottom-margin set default: ~A" *eps-bottom-margin*))
    (if (fneq *eps-left-margin*  0.0)
	(snd-display #__line__ ";* eps-left-margin set default: ~A" *eps-left-margin*))
    (if (fneq *eps-size*  1.0)
	(snd-display #__line__ ";* eps-size set default: ~A" *eps-size*))
    (if (fneq *fft-window-alpha*  0.0 )
	(snd-display #__line__ ";* fft-window-alpha set default: ~A" *fft-window-alpha*))
    (if (fneq *fft-window-beta*  0.0 )
	(snd-display #__line__ ";* fft-window-beta set default: ~A" *fft-window-beta*))
    (if *fft-log-frequency*
	(snd-display #__line__ ";* fft-log-frequency set default: ~A" *fft-log-frequency*))
    (if *fft-log-magnitude*
	(snd-display #__line__ ";* fft-log-magnitude set default: ~A" *fft-log-magnitude*))
    (if *fft-with-phases*
	(snd-display #__line__ ";* fft-with-phases set default: ~A" *fft-with-phases*))
    (if (not (member *transform-size* (list 1024 4096)))
	(snd-display #__line__ ";* transform-size set default: ~A" *transform-size*))
    (if (not (equal? *transform-graph-type* graph-once))
	(snd-display #__line__ ";* transform-graph-type set default: ~A" *transform-graph-type*))
    (if (not (eqv? *fft-window*  6 )) 
	(snd-display #__line__ ";* fft-window set default: ~A" *fft-window*))
    (if (not (eqv? *graph-cursor*  34)) 
	(snd-display #__line__ ";* graph-cursor set default: ~A" *graph-cursor*))
    (if (not (equal? *graph-style*  graph-lines )) 
	(snd-display #__line__ ";* graph-style set default: ~A" *graph-style*))
    (if (not *graphs-horizontal*) 
	(snd-display #__line__ ";* graphs-horizontal set default: ~A" *graphs-horizontal*))
    (if (not (equal? *html-dir*  ".")) 
	(snd-display #__line__ ";* html-dir set default: ~A" *html-dir*))
    (if (not (equal? *html-program*  "firefox")) 
	(snd-display #__line__ ";* html-program set default: ~A" *html-program*))
    (if (not *just-sounds*) 
	(snd-display #__line__ ";* just-sounds set default: ~A" *just-sounds*))
    (if (not (eqv? *max-transform-peaks*  100)) 
	(snd-display #__line__ ";* max-transform-peaks set default: ~A" *max-transform-peaks*))
    (if (not (eqv? *max-transform-peaks* 100)) 
	(snd-display #__line__ ";* max-transform-peaks set -123: ~A" *max-transform-peaks*))
    (if (not (eqv? *max-regions*  16 )) 
	(snd-display #__line__ ";* max-regions set default: ~A" *max-regions*))
    (if (fneq *min-dB*  -60.0 )
	(snd-display #__line__ ";* min-dB set default: ~A" *min-dB*))
    (if (fneq *log-freq-start*  32.0 )
	(snd-display #__line__ ";* log-freq-start set default: ~A" *log-freq-start*))
    (if (not (eq? *selection-creates-region*  #t )) 
	(snd-display #__line__ ";* selection-creates-region set default: ~A" *selection-creates-region*))
    (if (not (equal? *transform-normalization*  normalize-by-channel)) 
	(snd-display #__line__ ";* transform-normalization set default: ~A" *transform-normalization*))

    (if (and with-motif 
	     (not (eqv? *view-files-sort*  0 )) )
	(snd-display #__line__ ";* view-files-sort set default: ~A" *view-files-sort*))

    (if (not (eqv? *play-arrow-size*  10 )) 
	(snd-display #__line__ ";* play-arrow-size set default: ~A" *play-arrow-size*))
    (if (not (equal? *save-state-file*  "saved-snd.scm" )) 
	(snd-display #__line__ ";* save-state-file set default: ~A" *save-state-file*))
    (if (not (eqv? *show-axes*  1)) 
	(snd-display #__line__ ";* show-axes set default: ~A" *show-axes*))
    (if (not *show-marks*) 
	(snd-display #__line__ ";* show-marks set default: ~A" *show-marks*))
    (if (not *show-mix-waveforms*) 
	(snd-display #__line__ ";* show-mix-waveforms set default: ~A" *show-mix-waveforms*))
    (if *show-selection-transform*
	(snd-display #__line__ ";* show-selection-transform set default: ~A" *show-selection-transform*))
    (if *show-y-zero*
	(snd-display #__line__ ";* show-y-zero set default: ~A" *show-y-zero*))
    (if *show-grid*
	(snd-display #__line__ ";* show-grid set default: ~A" *show-grid*))
    (if (fneq *grid-density* 1.0)
	(snd-display #__line__ ";* grid-density set default: ~A" *grid-density*))
    (if *show-sonogram-cursor*
	(snd-display #__line__ ";* show-sonogram-cursor set default: ~A" *show-sonogram-cursor*))
    (if (not (eqv? *sinc-width*  10 )) 
	(snd-display #__line__ ";* sinc-width set default: ~A" *sinc-width*))
    (if (fneq *spectrum-end*  1.0)
	(snd-display #__line__ ";* spectrum-end set default: ~A" *spectrum-end*))
    (if (not (eqv? *spectro-hop*  4 )) 
	(snd-display #__line__ ";* spectro-hop set default: ~A" *spectro-hop*))
    (if (fneq *spectrum-start*  0.0 )
	(snd-display #__line__ ";* spectrum-start set default: ~A" *spectrum-start*))
    (if (fneq *spectro-x-angle*  (if (provided? 'gl) 300.0 90.0))
	(snd-display #__line__ ";* spectro-x-angle set default: ~A" *spectro-x-angle*))
    (if (fneq *spectro-x-scale* (if (provided? 'gl) 1.5 1.0))
	(snd-display #__line__ ";* spectro-x-scale set default: ~A" *spectro-x-scale*))
    (if (fneq *spectro-y-angle* (if (provided? 'gl) 320.0 0.0))
	(snd-display #__line__ ";* spectro-y-angle set default: ~A" *spectro-y-angle*))
    (if (fneq *spectro-y-scale*  1.0 )
	(snd-display #__line__ ";* spectro-y-scale set default: ~A" *spectro-y-scale*))
    (if (fneq *spectro-z-angle* (if (provided? 'gl) 0.0 358.0))
	(snd-display #__line__ ";* spectro-z-angle set default: ~A" *spectro-z-angle*))
    (if (fneq *spectro-z-scale* (if (provided? 'gl) 1.0 0.1))
	(snd-display #__line__ ";* spectro-z-scale set default: ~A" *spectro-z-scale*))
    (if (and (not (equal? *tiny-font* "6x12"))
	     (not (equal? *tiny-font* "Sans 8")))
	(snd-display #__line__ ";* tiny-font set default: ~A" *tiny-font*))
    (if (not *with-file-monitor*) 
	(snd-display #__line__ ";* with-file-monitor set default: ~A" *with-file-monitor*))
    (if (not *with-interrupts*)
	(snd-display #__line__ ";* with-interrupts set default: ~A" *with-interrupts*))
    (if *remember-sound-state*
	(snd-display #__line__ ";* remember-sound-state set default: ~A" *remember-sound-state*))
    (if *with-smpte-label*
	(snd-display #__line__ ";* with-smpte-label set default: ~A" *with-smpte-label*))
    (if (not (eq? *with-toolbar* (provided? 'snd-gtk)))
	(snd-display #__line__ ";* with-toolbar set default: ~A" *with-toolbar*))
    (if (not *with-tooltips*)
	(snd-display #__line__ ";* with-tooltips set default: ~A" *with-tooltips*))
    (if *save-as-dialog-src*
	(snd-display #__line__ ";* save-as-dialog-src set default: ~A" *save-as-dialog-src*))
    (if *save-as-dialog-auto-comment*
	(snd-display #__line__ ";* save-as-dialog-auto-comment set default: ~A" *save-as-dialog-auto-comment*))
    (if (not (eqv? *wavelet-type*  0 )) 
	(snd-display #__line__ ";* wavelet-type set default: ~A" *wavelet-type*))
    (if (not (equal? *time-graph-type*  graph-once)) 
	(snd-display #__line__ ";* time-graph-type set default: ~A" *time-graph-type*))
    (if (not (eqv? *wavo-hop*  3 )) 
	(snd-display #__line__ ";* wavo-hop set default: ~A" *wavo-hop*))
    (if (not (eqv? *wavo-trace*  64 )) 
	(snd-display #__line__ ";* wavo-trace set default: ~A" *wavo-trace*))
    (if (not (eqv? *x-axis-style*  0 )) 
	(snd-display #__line__ ";* x-axis-style set default: ~A" *x-axis-style*))
    (if (fneq *beats-per-minute*  60.0 )
	(snd-display #__line__ ";* beats-per-minute set default: ~A" *beats-per-minute*))
    (if (not (= *beats-per-measure*  4))
	(snd-display #__line__ ";* beats-per-measure set default: ~A" *beats-per-measure*))
    (if (not (eqv? *zero-pad*  0)) 
	(snd-display #__line__ ";* zero-pad set default: ~A" *zero-pad*))
    (if (not (eqv? *zoom-focus-style*  2 )) 
	(snd-display #__line__ ";* zoom-focus-style set default: ~A" *zoom-focus-style*))
    (if (not (equal? *sync-style*  sync-by-sound )) 
	(snd-display #__line__ ";* sync-style set default: ~A" *sync-style*))    
    (if (not (eqv? *mix-waveform-height*  20 )) 
	(snd-display #__line__ ";* mix-waveform-height set default: ~A" *mix-waveform-height*))
    (if (not (eqv? *mix-tag-width*  6)) 
	(snd-display #__line__ ";* mix-tag-width set default: ~A" *mix-tag-width*))
    (if (not (eqv? *mix-tag-height*  14)) 
	(snd-display #__line__ ";* mix-tag-height set default: ~A" *mix-tag-height*))
    (if (not (eqv? *mark-tag-width*  10)) 
	(snd-display #__line__ ";* mark-tag-width set default: ~A" *mark-tag-width*))
    (if (not (eqv? *mark-tag-height*  4)) 
	(snd-display #__line__ ";* mark-tag-height set default: ~A" *mark-tag-height*))

    (if (and with-motif
	     (not (= (view-files-sort) 0)))
	(snd-display #__line__ ";view-files-sort def: ~A" (view-files-sort)))
    
    (if (> most-positive-fixnum (expt 2 36))
	(begin
	  (let ((old-max-malloc *mus-max-malloc*))
	    (set! *mus-max-malloc* (expt 2 36))
	    (if (not (= *mus-max-malloc* (expt 2 36)))
		(snd-display #__line__ ";mus-max-malloc as bignum: ~A" *mus-max-malloc*))
	    (set! *mus-max-malloc* old-max-malloc))
	  
	  (let ((old-max-table-size *mus-max-table-size*))
	    (set! *mus-max-table-size* (expt 2 36))
	    (if (not (= *mus-max-table-size* (expt 2 36)))
		(snd-display #__line__ ";mus-max-table-size as bignum: ~A" *mus-max-table-size*))
	    (set! *mus-max-table-size* old-max-table-size))))
    
    (if (not (provided? 'snd-gtk))
	(for-each
	 (lambda (func name)
	   (let ((val (func)))
	     (set! (func) "8x123")
	     (if (or (not (string? (func)))
		     (not (string=? val (func))))
		 (snd-display #__line__ ";set ~A to bogus value: ~A ~A" name val (func)))))
	 (list axis-label-font axis-numbers-font tiny-font peaks-font bold-peaks-font)
	 (list 'axis-label-font 'axis-numbers-font 'tiny-font 'peaks-font 'bold-peaks-font)))

    (set! *ask-about-unsaved-edits* #f)
    (set! *remember-sound-state* #f)
    ))



;;; ---------------- test 1: defaults ----------------

(define good-colormap hot-colormap)
(define better-colormap black-and-white-colormap)
(if (and with-gui
	 (not (colormap? good-colormap)))
    (set! good-colormap
	  (call-with-exit
	   (lambda (return)
	     (do ((i 1 (+ i 1)))
		 ((= i 20))
	       (if (colormap? (integer->colormap i))
		   (return (integer->colormap i))))))))
(if (and with-gui
	 (not (colormap? better-colormap)))
    (set! better-colormap
	  (call-with-exit
	   (lambda (return)
	     (do ((i good-colormap (+ i 1)))
		 ((= i 20))
	       (if (colormap? (integer->colormap i))
		   (return (integer->colormap i))))))))

(define (snd_test_1)
  (when with-gui
    (letrec ((test-defaults
	      (lambda (lst)
		(if (pair? lst)
		    (begin
		      (if (and (not (equal? (cadr lst)  (caddr lst)))
			       (or (not (pair? (caddr lst)))
				   (not (member (cadr lst) (caddr lst)))))
			  (if (and (number? (caddr lst))
				   (not (rational? (caddr lst))))
			      (if (fneq (cadr lst) (caddr lst))
				  (snd-display #__line__ ";~A is not ~A (~A)" (car lst) (caddr lst) (cadr lst)))
			      (snd-display #__line__ ";~A is not ~A (~A)" (car lst) (caddr lst) (cadr lst))))
		      (test-defaults (cdddr lst)))))))
      
      (for-each close-sound (sounds)) ; in case others opened elsewhere
      (test-defaults
       (list
	'amp-control (without-errors (amp-control)) 'no-such-sound
	'amp-control-bounds (cadr (amp-control-bounds)) 8.0
	'ask-about-unsaved-edits *ask-about-unsaved-edits* #f 
	'ask-before-overwrite *ask-before-overwrite* #f 
	'auto-resize *auto-resize* #t 
	'auto-update *auto-update* #f
	'auto-update-interval *auto-update-interval* 60.0 

	'beats-per-measure *beats-per-measure* 4
	'beats-per-minute *beats-per-minute* 60.0
	'channel-style *channel-style* 1
	'clipping *clipping* #f 
	'clm-table-size *clm-table-size* 512
	'clm-default-frequency *clm-default-frequency* 0.0

	'color-cutoff *color-cutoff* '(0.003 0.001)
	'color-inverted *color-inverted* #t
	'color-scale *color-scale* 1.0 
	'colormap *colormap* (list hot-colormap jet-colormap)
	'contrast-control (without-errors (contrast-control)) 'no-such-sound
	'contrast-control-amp *contrast-control-amp* 1.0
	'contrast-control-bounds (cadr (contrast-control-bounds)) 10.0
	'contrast-control? (without-errors (contrast-control?)) 'no-such-sound
	'cursor-location-offset *cursor-location-offset* 0
	'cursor-size *cursor-size* 15
	'cursor-style *cursor-style* cursor-cross
	'cursor-update-interval *cursor-update-interval* 0.05
	'dac-combines-channels *dac-combines-channels* #t
	'dac-size *dac-size* 256 
	'default-output-chans *default-output-chans* 1 
	'default-output-sample-type *default-output-sample-type* mus-ldouble
	'default-output-header-type *default-output-header-type* mus-next
	'default-output-srate *default-output-srate* 44100
	'dot-size *dot-size* 1 

	'enved-base *enved-base* 1.0 
	'enved-clip? (enved-clip?) #t
	'enved-envelope (enved-envelope) ()
	'enved-filter (enved-filter) #t
	'enved-filter-order *enved-filter-order* 40
	'enved-in-dB (enved-in-dB) #f 
	'enved-power *enved-power* 3.0
	'enved-style *enved-style* envelope-linear
	'enved-target *enved-target* 0 
	'enved-wave? *enved-wave?* #f 
	'eps-bottom-margin *eps-bottom-margin* 0.0
	'eps-file *eps-file* "snd.eps" 
	'eps-left-margin *eps-left-margin* 0.0
	'eps-size *eps-size* 1.0
	'expand-control (without-errors (expand-control)) 'no-such-sound
	'expand-control-bounds (cadr (expand-control-bounds)) 20.0
	'expand-control-hop *expand-control-hop* 0.05
	'expand-control-jitter *expand-control-jitter* 0.1
	'expand-control-length *expand-control-length* 0.15
	'expand-control-ramp *expand-control-ramp* 0.4
	'expand-control? (without-errors (expand-control?)) 'no-such-sound
	'fft-log-frequency *fft-log-frequency* #f 
	'fft-log-magnitude *fft-log-magnitude* #f 
	'fft-with-phases *fft-with-phases* #f 
	'fft-window *fft-window* 6 
	'fft-window-alpha *fft-window-alpha* 0.0 
	'fft-window-beta *fft-window-beta* 0.0 
	'filter-control-coeffs (without-errors (filter-control-coeffs)) 'no-such-sound
	'filter-control-envelope (without-errors (filter-control-envelope)) 'no-such-sound
	'filter-control-in-dB *filter-control-in-dB* #f
	'filter-control-in-hz *filter-control-in-hz* #f
	'filter-control-order *filter-control-order* 20
	'filter-control? (without-errors (filter-control?)) 'no-such-sound
	'graph-cursor *graph-cursor* 34
	'graph-style *graph-style* graph-lines
	'graphs-horizontal *graphs-horizontal* #t
	'grid-density *grid-density* 1.0
	'html-dir *html-dir* "."
	'html-program *html-program* "firefox"
	'initial-beg *initial-beg* 0.0
	'initial-dur *initial-dur* 0.1
	'just-sounds *just-sounds* #t
	'ladspa-dir *ladspa-dir* ""
	'peak-env-dir *peak-env-dir* (list "" "/home/bil/peaks")
	'lisp-graph? (without-errors (lisp-graph?)) 'no-such-sound
					;      'listener-prompt *listener-prompt* ">" 
	'log-freq-start *log-freq-start* 32.0	
	'mark-tag-height *mark-tag-height* 4
	'mark-tag-width *mark-tag-width* 10
	'max-regions *max-regions* 16 
	'max-transform-peaks *max-transform-peaks* 100
	'min-dB *min-dB* -60.0 
	'mix-tag-height *mix-tag-height* 14
	'mix-tag-width *mix-tag-width* 6
	'mix-waveform-height *mix-waveform-height* 20 
	'mus-array-print-length *mus-array-print-length* 8
	'mus-clipping (mus-clipping) #f
	'mus-float-equal-fudge-factor *mus-float-equal-fudge-factor* .0000001
	'play-arrow-size *play-arrow-size* 10
	'print-length *print-length* '(12 32)
	'read-only (without-errors (read-only)) 'no-such-sound
	'region-graph-style *region-graph-style* graph-lines
	'remember-sound-state *remember-sound-state* #f
	'reverb-control-feedback *reverb-control-feedback* 1.09
	'reverb-control-length (without-errors (reverb-control-length)) 'no-such-sound
	'reverb-control-length-bounds (cadr (reverb-control-length-bounds)) 5.0
	'reverb-control-lowpass *reverb-control-lowpass* 0.7
	'reverb-control-scale (without-errors (reverb-control-scale)) 'no-such-sound
	'reverb-control-scale-bounds (cadr (reverb-control-scale-bounds)) 4.0
	'reverb-control? (without-errors (reverb-control?)) 'no-such-sound
	'save-as-dialog-auto-comment *save-as-dialog-auto-comment* #f
	'save-as-dialog-src *save-as-dialog-src* #f
	'save-state-file *save-state-file* "saved-snd.scm" 
	'selection-creates-region *selection-creates-region* #t 
	'show-axes *show-axes* 1
	'show-controls *show-controls* #f
	'show-full-duration *show-full-duration* '(#f #t)
	'show-full-range *show-full-range* #f 
	'show-grid *show-grid* #f 
	'show-indices *show-indices* '(#f #t)
	'show-marks *show-marks* #t 
	'show-mix-waveforms *show-mix-waveforms* #t
	'show-selection-transform *show-selection-transform* #f 
	'show-sonogram-cursor *show-sonogram-cursor* #f 
	'show-transform-peaks *show-transform-peaks* '(#f #t)
	'show-y-zero *show-y-zero* #f 
	'sinc-width *sinc-width* 10 
	'spectrum-end *spectrum-end* 1.0
	'spectro-hop *spectro-hop* 4 
	'spectrum-start *spectrum-start* 0.0 
	'spectro-x-angle *spectro-x-angle* (if (provided? 'gl) 300.0 90.0)
	'spectro-x-scale *spectro-x-scale* (if (provided? 'gl) 1.5 1.0)
	'spectro-y-angle *spectro-y-angle* (if (provided? 'gl) 320.0 0.0)
	'spectro-y-scale *spectro-y-scale* 1.0 
	'spectro-z-angle *spectro-z-angle* (if (provided? 'gl) 0.0 358.0)
	'spectro-z-scale *spectro-z-scale* (if (provided? 'gl) 1.0 0.1)
	'speed-control (without-errors (speed-control)) 'no-such-sound
	'speed-control-bounds (cadr (speed-control-bounds)) 20.0
	'sync (without-errors (sync)) 'no-such-sound
	'sync-style *sync-style* sync-by-sound
	'temp-dir *temp-dir* (list "" "/home/bil/zap/tmp")
	'time-graph-type *time-graph-type* graph-once
	'time-graph? (without-errors (time-graph?)) 'no-such-sound
	'tiny-font *tiny-font* (if (provided? 'snd-motif) "6x12" "Sans 8")
	'tracking-cursor-style *tracking-cursor-style* cursor-line
	'transform-graph-type *transform-graph-type* graph-once
	'transform-graph? (without-errors (transform-graph?)) 'no-such-sound
	'transform-normalization *transform-normalization* normalize-by-channel
	'transform-size *transform-size* *transform-size*
	'transform-type *transform-type* fourier-transform
	'wavelet-type *wavelet-type* 0 
	'wavo-hop *wavo-hop* 3 
	'wavo-trace *wavo-trace* 64 
	'with-mix-tags *with-mix-tags* #t
	'with-relative-panes *with-relative-panes* #t
					;      'with-tracking-cursor *with-tracking-cursor* '(#f 1)
	'with-verbose-cursor *with-verbose-cursor* '(#f #t)
	'with-inset-graph *with-inset-graph* '(#f #t)
	'with-interrupts *with-interrupts* #t
	'with-smpte-label *with-smpte-label* #f
	'with-toolbar *with-toolbar* '(#f #t)
	'with-tooltips *with-tooltips* #t
	'with-menu-icons *with-menu-icons* '(#f #t)
	'with-pointer-focus *with-pointer-focus* '(#f #t)
	'x-axis-style *x-axis-style* 0 
	'zero-pad *zero-pad* 0
	'zoom-focus-style *zoom-focus-style* 2 
	))
      (if *snd-opened-sound* (snd-display #__line__ ";*snd-opened-sound*: ~A" *snd-opened-sound*))

      (let ((s (open-sound "oboe.snd")))
	(letrec ((test-vars
		  (lambda (lst)
		    (if (pair? lst)
			(let* ((args (car lst))
			       (name (args 0))
			       (getfnc (args 1))
			       (setfnc (lambda (val) (set! (getfnc) val)))
			       (initval (args 2))
			       (newval (args 3))
			       (star-name (args 4)))
			  (setfnc newval)
			  (let ((nowval (symbol->value star-name)))
			    (if (and (not (equal? newval nowval))
				     (or (not (list? newval))
					 (not (feql newval nowval))))
				(if (and (number? newval) (not (rational? newval)))
				    (if (> (abs (- newval nowval)) .01)
					(snd-display #__line__ ";~A is not ~A (~A)" star-name newval nowval))
				    (snd-display #__line__ ";~A is not ~A (~A)" star-name newval nowval)))
			    (eval `(set! ,star-name ,initval))
			    (if (not (morally-equal? (getfnc) initval))
				(snd-display #__line__ ";* ~A is not ~A" name initval))
			    (eval `(set! ,star-name ,newval))
			    (let ((nowval (getfnc)))
			      (if (and (not (equal? newval nowval))
				       (or (not (list? newval))
					   (not (feql newval nowval))))
				  (if (and (number? newval) (not (rational? newval)))
				      (if (> (abs (- newval nowval)) .01)
					  (snd-display #__line__ ";set! ~A is not ~A (~A)" star-name newval nowval))
				      (snd-display #__line__ ";set! ~A is not ~A (~A)" star-name newval nowval)))
			      (setfnc initval))
			    (test-vars (cdr lst))))))))
	  (test-vars 
	   (list
	    (list 'ask-about-unsaved-edits ask-about-unsaved-edits #f #t '*ask-about-unsaved-edits*)
	    (list 'ask-before-overwrite ask-before-overwrite #f #t '*ask-before-overwrite*)
	    (list 'auto-resize auto-resize #t #f '*auto-resize*)
	    (list 'auto-update auto-update #f #t '*auto-update*)
	    (list 'channel-style channel-style 0 1 '*channel-style*)
	    (list 'color-cutoff color-cutoff 0.003 0.01 '*color-cutoff*)
	    (list 'color-inverted color-inverted #t #f '*color-inverted*)
	    (list 'color-scale color-scale 1.0 0.5 '*color-scale*)
	    (list 'contrast-control-amp contrast-control-amp 1.0 0.5 '*contrast-control-amp*)
	    (list 'auto-update-interval auto-update-interval 60.0 120.0 '*auto-update-interval*)
	    (list 'cursor-update-interval cursor-update-interval 0.05 0.10 '*cursor-update-interval*)
	    (list 'cursor-location-offset cursor-location-offset 0 32768 '*cursor-location-offset*)
					;	(list 'with-tracking-cursor with-tracking-cursor 2 1 '*with-tracking-cursor*)
	    (list 'cursor-size cursor-size 15 30 '*cursor-size*)
	    (list 'cursor-style cursor-style cursor-cross cursor-line '*cursor-style*)
	    (list 'tracking-cursor-style tracking-cursor-style cursor-line cursor-cross '*tracking-cursor-style*)
	    (list 'dac-combines-channels dac-combines-channels #t #f '*dac-combines-channels*)
	    (list 'dac-size dac-size 256 512 '*dac-size*)
	    (list 'clipping clipping #f #t '*clipping*)
	    (list 'default-output-chans default-output-chans 1 2 '*default-output-chans*)
	    (list 'default-output-sample-type default-output-sample-type 1 1 '*default-output-sample-type*)
	    (list 'default-output-srate default-output-srate 22050 44100 '*default-output-srate*)
	    (list 'default-output-header-type default-output-header-type mus-next mus-aifc '*default-output-header-type*)
	    (list 'dot-size dot-size 1 4 '*dot-size*)

	    (list 'enved-base enved-base 1.0  1.5 '*enved-base*)
	    (list 'enved-style enved-style envelope-linear envelope-exponential '*enved-style*)
	    (list 'enved-power enved-power 3.0 3.5 '*enved-power*)
	    (list 'enved-target enved-target 0 1 '*enved-target*)
	    (list 'enved-wave? enved-wave? #f #t '*enved-wave?*)
	    (list 'eps-file eps-file "snd.eps" "snd-1.eps" '*eps-file*)
	    (list 'eps-left-margin eps-left-margin 0.0 72.0 '*eps-left-margin*)
	    (list 'eps-size eps-size 1.0 2.0 '*eps-size*)
	    (list 'eps-bottom-margin eps-bottom-margin 0.0 36.0 '*eps-bottom-margin*)
	    (list 'expand-control-hop expand-control-hop 0.05 0.1 '*expand-control-hop*)
	    (list 'expand-control-jitter expand-control-jitter 0.1 0.2 '*expand-control-jitter*)
	    (list 'expand-control-length expand-control-length 0.15 0.2 '*expand-control-length*)
	    (list 'expand-control-ramp expand-control-ramp 0.4 0.2 '*expand-control-ramp*)

	    (list 'fft-window-alpha fft-window-alpha 0.0  1.0 '*fft-window-alpha*)
	    (list 'fft-window-beta fft-window-beta 0.0  0.5 '*fft-window-beta*)
	    (list 'fft-log-frequency fft-log-frequency #f #t '*fft-log-frequency*)
	    (list 'fft-log-magnitude fft-log-magnitude #f #t '*fft-log-magnitude*)
	    (list 'fft-with-phases fft-with-phases #f #t '*fft-with-phases*)
	    (list 'transform-size transform-size 512 1024 '*transform-size*)
	    (list 'transform-graph-type transform-graph-type graph-once graph-as-sonogram '*transform-graph-type*)
	    (list 'fft-window fft-window 6 5 '*fft-window*)
	    (list 'filter-control-in-dB filter-control-in-dB #f #t '*filter-control-in-dB*)
	    (list 'enved-filter-order enved-filter-order 40 20 '*enved-filter-order*)
	    (list 'filter-control-in-hz filter-control-in-hz #f #t '*filter-control-in-hz*)
	    (list 'filter-control-order filter-control-order 20 40 '*filter-control-order*)
					;	(list 'graph-cursor graph-cursor 34 32 '*graph-cursor*)

	    (list 'graph-style graph-style 0 1 '*graph-style*)
	    (list 'initial-beg initial-beg 0.0 1.0 '*initial-beg*)
	    (list 'initial-dur initial-dur 0.1 1.0 '*initial-dur*)
	    (list 'just-sounds just-sounds #f #t '*just-sounds*)
	    (list 'listener-prompt listener-prompt ">" ":" '*listener-prompt*)
	    (list 'max-transform-peaks max-transform-peaks 100 10 '*max-transform-peaks*)
	    (list 'max-regions max-regions 16 6 '*max-regions*)
	    (list 'min-dB min-dB -60.0 -90.0 '*min-dB*)
	    (list 'log-freq-start log-freq-start 32.0 10.0 '*log-freq-start*)
	    (list 'mix-waveform-height mix-waveform-height 20 40 '*mix-waveform-height*)
	    (list 'mix-tag-height mix-tag-height 14 20 '*mix-tag-height*)
	    (list 'mix-tag-width mix-tag-width 6 20 '*mix-tag-width*)
	    (list 'mark-tag-height mark-tag-height 4 20 '*mark-tag-height*)
	    (list 'mark-tag-width mark-tag-width 10 20 '*mark-tag-width*)
	    (list 'selection-creates-region selection-creates-region #t #f '*selection-creates-region*)
	    (list 'transform-normalization transform-normalization normalize-by-channel dont-normalize '*transform-normalization*)
	    (list 'play-arrow-size play-arrow-size 10 16 '*play-arrow-size*)
	    (list 'print-length print-length 12 16 '*print-length*)
	    (list 'region-graph-style region-graph-style graph-lines graph-lollipops '*region-graph-style*)
	    (list 'reverb-control-decay reverb-control-decay 1.0 2.0 '*reverb-control-decay*)
	    (list 'reverb-control-feedback reverb-control-feedback 1.09 1.6 '*reverb-control-feedback*)
	    (list 'reverb-control-lowpass reverb-control-lowpass 0.7 0.9 '*reverb-control-lowpass*)
	    (list 'show-axes show-axes 1 0 '*show-axes*)
	    (list 'show-full-duration show-full-duration #f #t '*show-full-duration*)
	    (list 'show-full-range show-full-range #f #t '*show-full-range*)
	    (list 'show-transform-peaks show-transform-peaks #f #t '*show-transform-peaks*)
	    (list 'show-indices show-indices #f #t '*show-indices*)
	    (list 'show-marks show-marks #t #f '*show-marks*)
	    (list 'show-mix-waveforms show-mix-waveforms #t #f '*show-mix-waveforms*)
	    (list 'show-selection-transform show-selection-transform #f #t '*show-selection-transform*)
	    (list 'show-y-zero show-y-zero #f #t '*show-y-zero*)
	    (list 'show-grid show-grid #f #t '*show-grid*)
	    (list 'grid-density grid-density 1.0 0.5 '*grid-density*)
	    (list 'show-sonogram-cursor show-sonogram-cursor #f #t '*show-sonogram-cursor*)
	    (list 'sinc-width sinc-width 10 40 '*sinc-width*)
	    (list 'spectrum-end spectrum-end 1.0 0.7 '*spectrum-end*)
	    (list 'spectro-hop spectro-hop 4 10 '*spectro-hop*)
	    (list 'spectrum-start spectrum-start 0.0 0.1 '*spectrum-start*)
	    (list 'spectro-x-angle spectro-x-angle (if (provided? 'gl) 300.0 90.0) 60.0 '*spectro-x-angle*)
	    (list 'spectro-x-scale spectro-x-scale (if (provided? 'gl) 1.5 1.0) 2.0 '*spectro-x-scale*)
	    (list 'spectro-y-angle spectro-y-angle (if (provided? 'gl) 320.0 0.0) 60.0 '*spectro-y-angle*)
	    (list 'spectro-y-scale spectro-y-scale 1.0 2.0 '*spectro-y-scale*)
	    (list 'spectro-z-angle spectro-z-angle (if (provided? 'gl) 0.0 358.0) 60.0 '*spectro-z-angle*)
	    (list 'spectro-z-scale spectro-z-scale (if (provided? 'gl) 1.0 0.1) 0.2 '*spectro-z-scale*)
	    (list 'speed-control-style speed-control-style 0 1 '*speed-control-style*)
	    (list 'speed-control-tones speed-control-tones 12 18 '*speed-control-tones*)
	    (list 'sync-style sync-style sync-by-sound sync-all '*sync-style*)
	    (list 'tiny-font tiny-font (if (provided? 'snd-gtk) "Sans 8" "6x12") (if (provided? 'snd-gtk) "Monospace 10" "9x15") '*tiny-font*)
	    (list 'with-verbose-cursor with-verbose-cursor #f #t '*with-verbose-cursor*)
	    (list 'wavelet-type wavelet-type 0 1 '*wavelet-type*)
	    (list 'time-graph-type time-graph-type graph-once graph-as-wavogram '*time-graph-type*)
	    (list 'wavo-hop wavo-hop 3 6 '*wavo-hop*)
	    (list 'wavo-trace wavo-trace 64 128 '*wavo-trace*)
	    ;(list 'with-mix-tags with-mix-tags #t #f '*with-mix-tags*)
	    (list 'with-relative-panes with-relative-panes #t #f '*with-relative-panes*)
	    (list 'with-gl with-gl (provided? 'gl) #f '*with-gl*)
	    (list 'x-axis-style x-axis-style 0 1 '*x-axis-style*)
	    (list 'beats-per-minute beats-per-minute 30.0 120.0 '*beats-per-minute*)
	    (list 'beats-per-measure beats-per-measure 1 120 '*beats-per-measure*)
	    (list 'zero-pad zero-pad 0 1 '*zero-pad*)
	    (list 'zoom-focus-style zoom-focus-style 2 1 '*zoom-focus-style*)
	    )))
	(close-sound s)
	))

    (set! *ask-about-unsaved-edits* #f)
    (set! *remember-sound-state* #f)
    ))


(set! (with-mix-tags) #t) ; assumed in test 16(!)
(set! *default-output-sample-type* mus-ldouble)


;;; ---------------- test 2: headers ----------------
(define (snd_test_2)
  (if (string? sf-dir)
      (letrec ((test-headers
		(lambda (base-files)
		  (if (pair? base-files)
		      (let ((testf (car base-files)))
			(let ((file (string-append sf-dir (testf 0))))
			  (if (file-exists? file)
			      (begin
				(if (not (equal? (mus-sound-chans file) (testf 1)))
				    (snd-display #__line__ ";~A: chans ~A is not ~A" 
						 (testf 0) 
						 (mus-sound-chans file) 
						 (testf 1)))
				(if (not (equal? (mus-sound-srate file) (testf 2)))
				    (snd-display #__line__ ";~A: srate ~A is not ~A" 
						 (testf 0) 
						 (mus-sound-srate file) 
						 (testf 2)))
				(if (fneq (mus-sound-duration file) (testf 3))
				    (snd-display #__line__ ";~A: duration ~A is not ~A" 
						 (testf 0)
						 (mus-sound-duration file) 
						 (testf 3)))
				(if (and (not (= (mus-sound-sample-type file) mus-unknown-sample))
					 (not (= (mus-sound-header-type file) 27)) ; bogus header on test case (comdisco)
					 (< (+ (mus-sound-length file) 1)
					    (* (mus-sound-datum-size file) (mus-sound-duration file)
					       (mus-sound-srate file) (mus-sound-chans file))))
				    (snd-display #__line__ ";mus-sound-length ~A: ~A (~A)" file
						 (mus-sound-length file)
						 (* (mus-sound-duration file) (mus-sound-srate file) 
						    (mus-sound-chans file) (mus-sound-datum-size file))))
				(if (fneq (/ (mus-sound-framples file) (mus-sound-srate file)) (mus-sound-duration file))
				    (snd-display #__line__ ";mus-sound-framples ~A: ~A (~A ~A)" file
						 (mus-sound-framples file)
						 (mus-sound-duration file)
						 (/ (mus-sound-framples file) (mus-sound-srate file))))
				(if (> (abs (- (mus-sound-framples file) (/ (mus-sound-samples file) (mus-sound-chans file)))) 1)
				    (snd-display #__line__ ";mus-sound-samples ~A: ~A ~A" file
						 (mus-sound-samples file)
						 (* (mus-sound-framples file) (mus-sound-chans file))))
				(if (not (equal? (mus-header-type-name (mus-sound-header-type file)) (testf 4)))
				    (snd-display #__line__ ";~A: type ~A is not ~A" 
						 (testf 0) 
						 (mus-header-type-name (mus-sound-header-type file))
						 (testf 4)))
				(if (not (equal? (mus-sample-type-name (mus-sound-sample-type file)) (testf 5)))
				    (snd-display #__line__ ";~A: type ~A is not ~A"
						 (testf 0) 
						 (mus-sample-type-name (mus-sound-sample-type file)) 
						 (testf 5)))
				(let ((lst (mus-sound-loop-info file)))
				  (if (> (length testf) 6)
				      (begin
					(if (not (equal? (car lst) (testf 6))) 
					    (snd-display #__line__ ";~A: loop start: ~A" (car lst) (testf 6)))
					(if (not (equal? (cadr lst) (testf 7))) 
					    (snd-display #__line__ ";~A: loop end: ~A" (cadr lst) (testf 7))))
				      (if (pair? lst)
					  (snd-display #__line__ ";~A thinks it has loop info: ~A" file lst))))
				(mus-sound-forget file))
			      (snd-display #__line__ ";~A missing?" file))
			  (test-headers (cdr base-files))))))))
	
	;; need to make sure raw defaults are consistent with following tests
	(let ((ind (open-raw-sound :file (string-append sf-dir "addf8.nh") :channels 2 :srate 44100 :sample-type mus-bshort)))
	  (if (sound? ind) (close-sound ind)))
	(catch #t
	       (lambda ()
		 (if (not (= (mus-sound-header-type (string-append sf-dir "midi60.mid")) -1)) (snd-display #__line__ ";midi60?")))
	       (lambda args args))
	(test-headers
	 (list
	  (list "5_secs.aiff" 1 44100 5.303107 "AIFF" "big endian short (16 bits)")
	  (list "8svx-8.snd" 1 22050 1.88766443729401 "SVX8" "signed byte (8 bits)")
	  (list "Fnonull.aif" 1 8000 0.00112499995157123 "AIFC" "mulaw (8 bits)")
	  (list "Pmiscck.aif" 1 8000 0.00112499995157123 "AIFC" "mulaw (8 bits)")
	  (list "Pmiscck.wav" 1 8000 0.00112499995157123 "RIFF" "mulaw (8 bits)")
					;	    (list "Pnossnd.aif" 1 8000 0.0 "AIFC" "mulaw (8 bits)")
	  (list "Poffset.aif" 1 8000 0.00112499995157123 "AIFC" "mulaw (8 bits)")
	  (list "Porder.aif" 1 8000 0.00112499995157123 "AIFC" "mulaw (8 bits)")
	  (list "Ptjunk.aif" 1 8000 0.00112499995157123 "AIFC" "mulaw (8 bits)")
	  (list "Ptjunk.wav" 1 8000 0.00112499995157123 "RIFF" "mulaw (8 bits)")
	  (list "SINE24-S.WAV" 2 44100 2.0 "RIFF" "little endian int (24 bits)")
	  (list "a1.asf" 1 16000 3.73656249046326 "asf" "unknown")
	  (list "a2.asf" 1 8000 4.63062477111816 "asf" "unknown")
	  (list "addf8.afsp" 1 8000 2.9760000705719 "Sun/Next" "big endian short (16 bits)")
	  (list "addf8.d" 1 8000 2.9760000705719 "SPPACK" "big endian short (16 bits)")
	  (list "addf8.dwd" 1 8000 2.9760000705719 "DiamondWare" "little endian short (16 bits)")
	  (list "addf8.nh" 2 44100 0.269931972026825 "raw (no header)" "big endian short (16 bits)")
	  (list "addf8.sd" 1 8000 2.9760000705719 "ESPS" "big endian short (16 bits)")
	  (list "addf8.sf_mipseb" 1 8000 2.9760000705719 "IRCAM" "big endian short (16 bits)")
	  (list "addf8.sf_sun" 1 8000 2.9760000705719 "IRCAM" "big endian short (16 bits)")
	  (list "addf8.sf_vax_b" 1 8000 2.9760000705719 "IRCAM" "big endian short (16 bits)")
	  (list "addf8.wav" 1 8000 2.9760000705719 "RIFF" "little endian short (16 bits)")
	  (list "aebass.krz" 1 44100 3.0 "Kurzweil 2000" "big endian short (16 bits)")
	  (list "aiff-16.snd" 2 44100 0.746666669845581 "AIFF" "big endian short (16 bits)")
	  (list "aiff-8.snd" 2 44100 0.746666669845581 "AIFF" "signed byte (8 bits)")
	  (list "alaw.aifc" 1 44100 0.0367800444364548 "AIFC" "alaw (8 bits)")
	  (list "alaw.wav" 1 11025 8.70666694641113 "RIFF" "alaw (8 bits)")
	  (list "astor_basia.mp2" 2 44100 1.02179133892059 "raw (no header)" "big endian short (16 bits)")
	  (list "c.asf" 1 8000 21.3681259155273 "asf" "unknown")
	  (list "ce-c3.w02" 1 33000 3.88848495483398 "TX-16W" "unknown")
	  (list "ce-c4.w03" 1 33000 2.91618180274963 "TX-16W" "unknown")
	  (list "ce-d2.w01" 1 33000 3.46439385414124 "TX-16W" "unknown")
	  (list "clbonef.wav" 1 22050 2.57832193374634 "RIFF" "little endian float (32 bits)")
	  (list "cranker.krz" 1 44100 3.48267579078674 "Kurzweil 2000" "big endian short (16 bits)")
	  (list "d40130.aif" 1 10000 0.100000001490116 "AIFF" "big endian short (16 bits)")
	  (list "d40130.au" 1 10000 0.100000001490116 "Sun/Next" "big endian short (16 bits)")
	  (list "d40130.dsf" 1 8000 0.125 "Delusion" "little endian short (16 bits)")
	  (list "d40130.fsm" 1 8000 0.125249996781349 "Farandole" "little endian short (16 bits)")
	  (list "d40130.iff" 1 10000 0.100000001490116 "SVX8" "signed byte (8 bits)")
	  (list "d40130.pat" 1 10000 0.100000001490116 "Gravis Ultrasound patch" "little endian short (16 bits)")
	  (list "d40130.sds" 1 10000 0.100000001490116 "MIDI sample dump" "unknown")
	  (list "d40130.sdx" 1 10000 0.100000001490116 "Sample dump" "unsigned little endian short (16 bits)")
	  (list "d40130.sf" 1 10000 0.100000001490116 "IRCAM" "little endian short (16 bits)")
	  (list "d40130.smp" 1 8000 0.125 "SMP" "little endian short (16 bits)")
	  (list "d40130.sou" 1 8000 0.125 "SBStudioII" "little endian short (16 bits)")
	  (list "d40130.st3" 1 8000 0.125 "Digiplayer ST3" "unsigned little endian short (16 bits)")
	  (list "d40130.uwf" 1 8000 0.125249996781349 "Ultratracker" "little endian short (16 bits)")
	  (list "d40130.voc" 1 10000 0.100100003182888 "VOC" "unsigned byte (8 bits)")
	  (list "d40130.w00" 1 16000 0.0625 "TX-16W" "unknown")
	  (list "d40130.wav" 1 10000 0.100000001490116 "RIFF" "little endian short (16 bits)")
	  (list "d43.wav" 1 10000 0.100000001490116 "RIFF" "little endian short (16 bits)")
	  (list "digit0v0.aiff" 1 8000 0.560000002384186 "AIFC" "big endian short (16 bits)")
	  (list "esps-16.snd" 1 8000 3.09737491607666 "ESPS" "big endian short (16 bits)")
	  (list "forest.aiff" 2 44100 3.907143 "AIFF" "big endian short (16 bits)" 24981 144332)
;	  (list "g721.au" 1 11025 4.35328817367554 "Sun/Next" "unknown")
;	  (list "g722.aifc" 1 44100 0.0184353739023209 "AIFC" "unknown")
	  (list "gong.wve" 1 8000 3.96799993515015 "PSION" "alaw (8 bits)")
	  (list "gsm610.wav" 1 11025 1.7687075138092 "RIFF" "unknown")
	  (list "inrs-16.snd" 1 8000 2.46399998664856 "INRS" "little endian short (16 bits)")
	  (list "kirk.wve" 1 8000 1.40799999237061 "PSION" "alaw (8 bits)")
	  (list "loop.aiff" 1 44100 0.0367120169103146 "AIFC" "big endian short (16 bits)" 12 23)
	  (list "m.asf" 1 8000 64.9646224975586 "asf" "unknown")
	  (list "mary-sun4.sig" 1 8000 4.47612476348877 "Comdisco SPW signal" "big endian double (64 bits)")
	  (list "mocksong.wav" 1 11025 7.86956930160522 "RIFF" "little endian short (16 bits)")
	  (list "mono24.wav" 1 22050 1.98997735977173 "RIFF" "little endian int (24 bits)")
	  (list "msadpcm.wav" 1 11025 4.43501138687134 "RIFF" "unknown")
	  (list "n8.snd" 1 44100 0.0367800444364548 "Sun/Next" "signed byte (8 bits)")
	  (list "nasahal.aif" 1 11025 9.89841270446777 "AIFF" "signed byte (8 bits)")
	  (list "nasahal.avi" 1 11025 10.4327440261841 "AVI" "little endian short (16 bits)")
	  (list "nasahal.dig" 1 11025 9.89841270446777 "Sound Designer 1" "big endian short (16 bits)")
	  (list "nasahal.ivc" 2 44100 0.449002265930176 "raw (no header)" "big endian short (16 bits)")
	  (list "nasahal.pat" 1 11025 3.95410442352295 "Gravis Ultrasound patch" "unsigned byte (8 bits)")
	  (list "nasahal.snd" 1 11025 9.89841270446777 "SNDT" "unsigned byte (8 bits)")
	  (list "nasahal.svx" 1 11025 9.89841270446777 "SVX8" "signed byte (8 bits)")
	  (list "nasahal.v8" 1 8000 13.6412496566772 "Covox V8" "unsigned byte (8 bits)")
	  (list "nasahal.voc" 1 11025 9.89941024780273 "VOC" "unsigned byte (8 bits)")
	  (list "nasahal.vox" 2 44100 0.224444448947906 "raw (no header)" "big endian short (16 bits)")
	  (list "nasahal8.wav" 1 11025 9.89841270446777 "RIFF" "unsigned byte (8 bits)")
	  (list "nasahalad.smp" 1 11025 4.94920635223389 "Goldwave sample" "little endian short (16 bits)")
	  (list "next-16.snd" 1 22050 1.00004529953003 "Sun/Next" "big endian short (16 bits)")
	  (list "next-8.snd" 1 22050 0.226757362484932 "Sun/Next" "signed byte (8 bits)")
	  (list "next-dbl.snd" 1 22050 0.226757362484932 "Sun/Next" "big endian double (64 bits)")
	  (list "oboe.ldbl" 1 22050 2.30512475967407 "RIFF" "little endian double (64 bits)")
	  (list "next-flt.snd" 1 22050 0.226757362484932 "Sun/Next" "big endian float (32 bits)")
	  (list "aifc-float.snd" 1 22050 0.226757362484932 "AIFC" "big endian float (32 bits)")
	  (list "next-mulaw.snd" 1 8012 2.03295063972473 "Sun/Next" "mulaw (8 bits)")
	  (list "next24.snd" 1 44100 0.0367800444364548 "Sun/Next" "big endian int (24 bits)")
	  (list "nist-01.wav" 1 16000 2.26912498474121 "NIST" "little endian short (16 bits)")
	  (list "nist-10.wav" 1 16000 2.26912498474121 "NIST" "big endian short (16 bits)")
	  (list "nist-16.snd" 1 16000 1.02400004863739 "NIST" "big endian short (16 bits)")
	  (list "nist-shortpack.wav" 1 16000 4.53824996948242 "NIST" "unknown")
	  (list "none.aifc" 1 44100 0.0367800444364548 "AIFC" "big endian short (16 bits)")
	  (list "nylon2.wav" 2 22050 1.14376413822174 "RIFF" "unknown")
	  (list "o2.adf" 1 44100 0.036780 "CSRE adf" "little endian short (16 bits)")
	  (list "o2.avr" 1 44100 0.0183900222182274 "AVR" "big endian short (16 bits)")
	  (list "o2.bicsf" 1 44100 0.0367800444364548 "IRCAM" "big endian short (16 bits)")
	  (list "o2.mpeg1" 2 44100 0.00709750549867749 "raw (no header)" "big endian short (16 bits)")
	  (list "o2.sd2" 2 44100 0.0183900222182274 "raw (no header)" "big endian short (16 bits)")
	  (list "o2.sf2" 1 44100 0.0367800444364548 "SoundFont" "little endian short (16 bits)")
	  (list "o2.smp" 1 8000 0.202749997377396 "SMP" "little endian short (16 bits)")
	  (list "o2.voc" 1 44100 0.0368934236466885 "VOC" "little endian short (16 bits)")
	  (list "o2.wave" 1 44100 0.0367800444364548 "RIFF" "little endian short (16 bits)")
	  (list "o2_12bit.aiff" 1 44100 0.0367800444364548 "AIFF" "big endian short (16 bits)")
	  (list "o2_18bit.aiff" 1 44100 0.0367800444364548 "AIFF" "big endian int (24 bits)")
;	  (list "o2_711u.wave" 1 44100 0.0367800444364548 "RIFF" "mulaw (8 bits)")
;	  (list "o2_722.snd" 1 44100 0.0183900222182274 "Sun/Next" "unknown")
;	  (list "o2_726.aiff" 1 8000 0.0367499999701977 "AIFC" "unknown")
;	  (list "o2_726.snd" 1 44100 0.0230158735066652 "Sun/Next" "unknown")
;	  (list "o2_728.aiff" 1 8000 0.0367499999701977 "AIFC" "unknown")
	  (list "o2_8.iff" 1 44100 0.0367800444364548 "SVX8" "signed byte (8 bits)")
	  (list "o2_8.voc" 1 44100 0.0370294786989689 "VOC" "unsigned byte (8 bits)")
	  (list "o2_dvi.wave" 1 44100 0.0232199542224407 "RIFF" "unknown")
	  (list "o2_float.bicsf" 1 44100 0.0367800444364548 "IRCAM" "big endian float (32 bits)")
	  (list "o2_gsm.aiff" 1 8000 0.0367499999701977 "AIFC" "unknown")
	  (list "o2_u8.avr" 1 44100 0.0367800444364548 "AVR" "unsigned byte (8 bits)")
	  (list "o2_u8.wave" 1 44100 0.0367800444364548 "RIFF" "unsigned byte (8 bits)")
	  (list "o28.mpc" 1 44100 0.036780 "AKAI 4" "little endian short (16 bits)")
;	  (list "oboe.g721" 1 22050 1.15287983417511 "Sun/Next" "unknown")
;	  (list "oboe.g723_24" 1 22050 0.864761888980865 "Sun/Next" "unknown")
;	  (list "oboe.g723_40" 1 22050 1.44126987457275 "Sun/Next" "unknown")
	  (list "oboe.kts" 1 22050 2.305125 "Korg" "big endian short (16 bits)")
	  (list "oboe.its" 1 22050 2.305125 "Impulse Tracker" "little endian short (16 bits)")
	  (list "oboe.sf2" 1 22050 2.30512475967407 "SoundFont" "little endian short (16 bits)")
	  (list "oboe.paf" 1 22050 2.305125 "Ensoniq Paris" "big endian short (16 bits)")
	  (list "oboe.pf1" 1 22050 2.305125 "Ensoniq Paris" "little endian short (16 bits)")
	  (list "oboe.smp" 1 22050 2.305125 "snack SMP" "little endian short (16 bits)")
	  (list "oboe.rf64" 1 22050 2.305125 "rf64" "little endian short (16 bits)")
	  (list "oboe-be32.caf" 1 22050 2.305125 "caff" "normalized big endian int (32 bits)")
	  (list "oboe-bf64.caf" 1 22050 2.305125 "caff" "big endian double (64 bits)")
	  (list "oboe-lf32.caf" 1 22050 2.305125 "caff" "little endian float (32 bits)")
	  (list "oboe-ulaw.caf" 1 22050 2.305125 "caff" "mulaw (8 bits)")
	  (list "oboe.nsp" 1 22050 2.305125 "CSL" "little endian short (16 bits)")
;	  (list "oboe.nvf" 1 8000 6.353500 "Creative NVF" "unknown")
	  (list "oboe-ulaw.voc" 1 22050 2.305669 "VOC" "mulaw (8 bits)")
	  (list "oboe-lf32.sf" 1 22050 2.305669 "IRCAM" "little endian float (32 bits)")
	  (list "oboe.wfp" 1 22050 2.305125 "Turtle Beach" "little endian short (16 bits)")
	  (list "oboe.sox" 1 22050 2.305125 "Sox" "normalized little endian int (32 bits)")
	  (list "oki.snd" 2 44100 0.0041950112208724 "raw (no header)" "big endian short (16 bits)")
	  (list "oki.wav" 1 44100 0.016780 "RIFF" "unknown")
	  (list "orv-dvi-adpcm.wav" 1 44100 1.92725622653961 "RIFF" "unknown")
	  (list "riff-16.snd" 1 22050 1.88766443729401 "RIFF" "little endian short (16 bits)")
	  (list "riff-8-u.snd" 1 11025 0.506848096847534 "RIFF" "unsigned byte (8 bits)")
	  (list "rooster.wve" 1 8000 2.04800009727478 "PSION" "alaw (8 bits)")
	  (list "sd1-16.snd" 1 44100 0.400544226169586 "Sound Designer 1" "big endian short (16 bits)")
					;	    (list "segfault.snd" 16777216 576061440 1.24986669902682e-7 "Sun/Next" "unknown")
	  (list "sf-16.snd" 1 22050 1.88766443729401 "IRCAM" "big endian short (16 bits)")
	  (list "si654.adc" 1 16000 6.71362495422363 "ADC/OGI" "big endian short (16 bits)")
	  (list "smp-16.snd" 1 8000 5.2028751373291 "SMP" "little endian short (16 bits)")
	  (list "sound.pat" 1 8000 1.95050001144409 "Gravis Ultrasound patch" "unsigned little endian short (16 bits)")
	  (list "sound.sap" 1 8000 1.95050001144409 "Goldwave sample" "little endian short (16 bits)")
	  (list "sound.sds" 1 8000 1.95050001144409 "MIDI sample dump" "unknown")
	  (list "sound.sfr" 1 8000 1.95050001144409 "SRFS" "little endian short (16 bits)")
	  (list "sound.v8" 1 8000 1.95050001144409 "Covox V8" "unsigned byte (8 bits)")
	  (list "sound.vox" 2 44100 0.044217687100172 "raw (no header)" "big endian short (16 bits)")
	  (list "step.omf" 1 11025 8.70666694641113 "OMF" "signed byte (8 bits)")
	  (list "step.qt" 1 11025 8.70630359649658 "Quicktime" "unsigned byte (8 bits)")
	  (list "sun-16-afsp.snd" 1 8000 2.9760000705719 "Sun/Next" "big endian short (16 bits)")
	  (list "sun-mulaw.snd" 1 8000 4.61950016021729 "Sun/Next" "mulaw (8 bits)")
	  (list "sw1038t_short.wav" 2 8000 6.0 "NIST" "mulaw (8 bits)")
	  (list "swirl.pat" 1 22050 1.0619500875473 "Gravis Ultrasound patch" "unsigned little endian short (16 bits)")
	  (list "sy85.snd" 1 8000 5.05600023269653 "Sy-85" "big endian short (16 bits)")
	  (list "sy99.snd" 1 8000 4.54400014877319 "Sy-99" "big endian short (16 bits)")
	  (list "telephone.wav" 1 16000 2.27881240844727 "NIST" "little endian short (16 bits)")
	  (list "trumps22.adp" 1 22050 3.092880 "RIFF" "unknown")
	  (list "truspech.wav" 1 8000 1.1599999666214 "RIFF" "unknown")
	  (list "ulaw.aifc" 1 44100 0.0367800444364548 "AIFC" "mulaw (8 bits)")
	  (list "voc-8-u.snd" 1 8000 1.49937498569489 "VOC" "unsigned byte (8 bits)")
	  (list "o28.voc" 1 44100 0.036893 "VOC" "little endian short (16 bits)")
	  (list "voxware.wav" 1 8000 0.324000000953674 "RIFF" "unknown")
	  (list "wd.w00" 1 8000 0.202749997377396 "Sy-99" "big endian short (16 bits)")
	  (list "wd1.smp" 1 8000 0.202749997377396 "SMP" "little endian short (16 bits)")
	  (list "wd1.wav" 1 44100 0.0367800444364548 "RIFF" "little endian short (16 bits)")
	  (list "wheel.mat" 2 44100 0.145646259188652 "raw (no header)" "big endian short (16 bits)")
	  (list "b8.pvf" 1 44100 0.036803 "Portable Voice Format" "signed byte (8 bits)")
	  (list "b16.pvf" 1 44100 0.036803 "Portable Voice Format" "big endian short (16 bits)")
	  (list "b32.pvf" 1 44100 0.036803 "Portable Voice Format" "big endian int (32 bits)")
	  (list "water.voc" 2 32000 42.3463897705078 "VOC" "little endian short (16 bits)")
	  (list "wood.dsf" 1 8000 0.202749997377396 "Delusion" "little endian short (16 bits)")
	  (list "wood.dvi" 1 22100 0.0278733037412167 "RIFF" "unknown")
	  (list "wood.dwd" 1 22100 0.0733936652541161 "DiamondWare" "signed byte (8 bits)")
	  (list "wood.fsm" 1 8000 0.202999994158745 "Farandole" "little endian short (16 bits)")
	  (list "wood.mad" 1 22100 0.0372398197650909 "RIFF" "unknown")
	  (list "wood.maud" 1 44100 0.0183900222182274 "MAUD" "big endian short (16 bits)")
	  (list "wood.pat" 1 22100 0.0733936652541161 "Gravis Ultrasound patch" "little endian short (16 bits)")
	  (list "wood.riff" 1 44100 0.0367800444364548 "RIFF" "little endian short (16 bits)")
	  (list "wood.rifx" 1 44100 0.0367800444364548 "RIFF" "big endian short (16 bits)")
	  (list "wood.sds" 1 22100 0.0733936652541161 "MIDI sample dump" "unknown")
	  (list "wood.sdx" 1 22100 0.0733936652541161 "Sample dump" "unsigned little endian short (16 bits)")
	  (list "wood.sf" 1 44100 0.0367800444364548 "IRCAM" "big endian short (16 bits)")
	  (list "wood.sndr" 2 44100 0.0092290248721838 "raw (no header)" "big endian short (16 bits)")
	  (list "wood.sndt" 1 44100 0.0367800444364548 "SNDT" "unsigned byte (8 bits)")
	  (list "wood.st3" 1 8000 0.202749997377396 "Digiplayer ST3" "unsigned little endian short (16 bits)")
	  (list "wood.uwf" 1 8000 0.202999994158745 "Ultratracker" "little endian short (16 bits)")
	  (list "wood.w00" 1 16000 0.101374998688698 "TX-16W" "unknown")
	  (list "wood12.aiff" 1 44100 0.0367800444364548 "AIFF" "big endian short (16 bits)")
	  (list "wood16.dwd" 2 44100 0.0367800444364548 "DiamondWare" "little endian short (16 bits)")
	  (list "wood16.wav" 2 44100 0.0367800444364548 "RIFF" "little endian short (16 bits)")
	  (list "wood16.nsp" 2 44100 0.0367800444364548 "CSL" "little endian short (16 bits)")
	  (list "wood16.smp" 2 44100 0.0367800444364548 "snack SMP" "little endian short (16 bits)")
	  (list "wood24.aiff" 1 44100 0.0367800444364548 "AIFF" "big endian int (24 bits)")
	  (list "woodblock.aiff" 1 44100 0.0367800444364548 "AIFF" "big endian short (16 bits)")
	  (list "woodflt.snd" 1 44100 0.0367800444364548 "Sun/Next" "big endian float (32 bits)")
	  (list "RealDrums.sf2" 1 44100 6.39725637435913 "SoundFont" "little endian short (16 bits)")
	  (list "32bit.sf" 1 44100 4.6 "IRCAM" "little endian float (32 bits, unscaled)")
	  (list "PCM_48_8bit_m.w64" 1 48000 0.375 "SoundForge" "unsigned byte (8 bits)")
	  (list "oboe.sf6" 1 22050 2.305125 "SoundForge" "little endian short (16 bits)")
	  (list "addf8.24we" 1 8000 2.976000 "RIFF" "little endian int (24 bits)")
	  (list "hybrid.snd" 1 44100 4.600000 "BICSF" "big endian float (32 bits)")
	  (list "litmanna.sf" 1 44100 .533 "IRCAM" "little endian short (16 bits)")
	  (list "M1F1-float64C-AFsp.aif" 2 8000 2.9366 "AIFC" "big endian double (64 bits)")
	  (list "MacBoing.wav" 1 11127 0.696 "RIFF" "unsigned byte (8 bits)")
	  (list "t15.aiff" 2 44100 135.00 "AIFC" "little endian short (16 bits)")
	  (list "tomf8.aud" 1 8000 2.016000 "INRS" "little endian short (16 bits)")
	  (list "Xhs001x.nsp" 1 10000 6.017400 "CSL" "little endian short (16 bits)")
	  (list "zulu_a4.w11" 1 33000 1.21987879276276 "TX-16W" "unknown" 23342 40042)))
	
	(for-each (lambda (in-name real-name)
		    (if (not (string=? (mus-expand-filename in-name) real-name))
			(snd-display #__line__ ";mus-expand-filename ~A -> ~A" in-name (mus-expand-filename in-name)))
		    (if (file-exists? "/home/bil/./sf1/o2.voc")
			(let ((ind (open-sound in-name)))
			  (if (not (sound? ind))
			      (snd-display #__line__ ";can't open ~A" in-name)
			      (begin
				(if (not (string=? (file-name ind) real-name))
				    (snd-display #__line__ ";expand file name ~A: ~A" in-name (file-name ind)))
				(close-sound ind))))))
		  (list "/home/bil/./sf1/o2.voc" "~/./sf1/o2.voc" "~/cl/../sf1/o2.voc" "/home/bil/cl/../sf1/o2.voc")
		  (list "/home/bil/sf1/o2.voc" "/home/bil/sf1/o2.voc" "/home/bil/sf1/o2.voc" "/home/bil/sf1/o2.voc"))
	
	(let ((lst (mus-sound-mark-info (string-append sf-dir "forest.aiff"))))
	  (if (not (equal? lst '((4 0) (3 0) (2 144332) (1 24981))))
	      (snd-display #__line__ ";mus-sound-mark-info forest: ~A" lst)))
	(let ((lst (mus-sound-mark-info (string-append sf-dir "traffic.aiff"))))
	  (if (not (equal? lst '((4 1) (3 0) (2 171931) (1 99461))))
	      (snd-display #__line__ ";mus-sound-mark-info traffic: ~A" lst)))
	)))



;;; ---------------- test 3: variables ----------------

(define (snd_test_3)
  (let ((ind #f))
    
    (set! ind (open-sound "oboe.snd"))
    (if (and (file-exists? "funcs.scm") 
	     (not (defined? 'swellf)))
	(load "funcs.scm"))
    (let ((td *temp-dir*))
      (catch #t
	     (lambda ()
	       (set! *temp-dir* (string-append home-dir "/test"))
	       (if (not (string=? *temp-dir* (string-append home-dir "/test")))
		   (snd-display #__line__ ";set temp-dir: ~A?" *temp-dir*)))
	     (lambda args args))
      (if td 
	  (set! *temp-dir* td)
	  (set! *temp-dir* "")))
    (if (fneq (sample 1000) 0.0328) (snd-display #__line__ ";sample: ~A?" (sample 1000)))
    
    (when with-gui
      (set! *show-controls* #t)
      
      (let ((wid (enved-dialog) ))
	(if (not (equal? wid ((dialog-widgets) 1)))
	    (snd-display #__line__ ";enved-dialog -> ~A ~A" wid ((dialog-widgets) 1))))
					;(if (not ((dialog-widgets) 1)) (snd-display #__line__ ";enved-dialog?"))
      (set! (enved-envelope) '(0.0 0.0 1.0 1.0 2.0 0.0))
      (if (not (equal? (enved-envelope) (list 0.0 0.0 1.0 1.0 2.0 0.0)))
	  (snd-display #__line__ ";set enved-envelope to self: ~A?" (enved-envelope)))
      
      (letrec ((test-vars
		(lambda (lst)
		  (if (pair? lst)
		      (let* ((name ((car lst) 0))
			     (getfnc ((car lst) 1))
			     (setfnc (lambda (val) (set! (getfnc) val)))
			     (initval ((car lst) 2))
			     (newval ((car lst) 3)))
			
			(setfnc newval)
			(let ((nowval (getfnc)))
			  (if (and (not (equal? newval nowval))
				   (or (not (list? newval))
				       (not (feql newval nowval))))
			      (if (and (number? newval) (not (rational? newval)))
				  (if (> (abs (- newval nowval)) .01)
				      (snd-display #__line__ ";~A is not ~A (~A)" name newval nowval))
				  (snd-display #__line__ ";~A is not ~A (~A)" name newval nowval)))
			  (setfnc initval)
			  (set! (getfnc) newval)
			  (let ((nowval (getfnc)))
			    (if (and (not (equal? newval nowval))
				     (or (not (list? newval))
					 (not (feql newval nowval))))
				(if (and (number? newval) (not (rational? newval)))
				    (if (> (abs (- newval nowval)) .01)
					(snd-display #__line__ ";set! ~A is not ~A (~A)" name newval nowval))
				    (snd-display #__line__ ";set! ~A is not ~A (~A)" name newval nowval)))
			    (setfnc initval))
			  (test-vars (cdr lst))))))))
	(test-vars 
	 (list
	  (list 'amp-control amp-control 1.0 0.5)
	  (list 'amp-control-bounds amp-control-bounds (list 0.0 8.0) (list 1.0 5.0))
	  (list 'ask-about-unsaved-edits ask-about-unsaved-edits #f #t)
	  (list 'ask-before-overwrite ask-before-overwrite #f #t)
	  (list 'auto-resize auto-resize #t #f)
	  (list 'auto-update auto-update #f #t)
	  (list 'channel-style channel-style 0 1)
	  (list 'colormap colormap good-colormap better-colormap)
	  (list 'color-cutoff color-cutoff 0.003 0.01)
	  (list 'color-inverted color-inverted #t #f)
	  (list 'color-scale color-scale 1.0 0.5)
	  (list 'contrast-control contrast-control 0.0 0.5)
	  (list 'contrast-control-bounds contrast-control-bounds (list 0.0 10.0) (list 1.0 5.0))
	  (list 'contrast-control-amp contrast-control-amp 1.0 0.5)
	  (list 'contrast-control? contrast-control? #f #t)
	  (list 'auto-update-interval auto-update-interval 60.0 120.0)
	  (list 'cursor-update-interval cursor-update-interval 0.05 0.10)
	  (list 'cursor-location-offset cursor-location-offset 0 32768)
	  (list 'with-tracking-cursor with-tracking-cursor #f #t)
	  (list 'cursor-size cursor-size 15 30)
	  (list 'cursor-style cursor-style cursor-cross cursor-line)
	  (list 'tracking-cursor-style tracking-cursor-style cursor-line cursor-cross)
	  (list 'dac-combines-channels dac-combines-channels #t #f)
	  (list 'dac-size dac-size 256 512)
	  (list 'clipping clipping #f #t)
	  (list 'default-output-chans default-output-chans 1 2)
	  (list 'default-output-sample-type default-output-sample-type 1 1)
	  (list 'default-output-srate default-output-srate 22050 44100)
	  (list 'default-output-header-type default-output-header-type mus-next mus-aifc)
	  (list 'dot-size dot-size 1 4)
	  (list 'enved-base enved-base 1.0  1.5)
	  (list 'enved-clip? enved-clip? #f #t)
	  (list 'enved-in-dB enved-in-dB #f #t)
	  (list 'enved-style enved-style envelope-linear envelope-exponential)
	  (list 'enved-power enved-power 3.0 3.5)
	  (list 'enved-target enved-target 0 1)
	  (list 'enved-wave? enved-wave? #f #t)
	  (list 'eps-file eps-file "snd.eps" "snd-1.eps")
	  (list 'eps-left-margin eps-left-margin 0.0 72.0)
	  (list 'eps-size eps-size 1.0 2.0)
	  (list 'eps-bottom-margin eps-bottom-margin 0.0 36.0)
	  (list 'expand-control expand-control 1.0 2.0)
	  (list 'expand-control-bounds expand-control-bounds (list .001 20.0) (list 1.0 2.0))
	  (list 'expand-control-hop expand-control-hop 0.05 0.1)
	  (list 'expand-control-jitter expand-control-jitter 0.1 0.2)
	  (list 'expand-control-length expand-control-length 0.15 0.2)
	  (list 'expand-control-ramp expand-control-ramp 0.4 0.2)
	  (list 'expand-control? expand-control? #f #t)
	  (list 'fft-window-alpha fft-window-alpha 0.0  1.0)
	  (list 'fft-window-beta fft-window-beta 0.0  0.5)
	  (list 'fft-log-frequency fft-log-frequency #f #t)
	  (list 'fft-log-magnitude fft-log-magnitude #f #t)
	  (list 'fft-with-phases fft-with-phases #f #t)
	  (list 'transform-size transform-size 512 1024)
	  (list 'transform-graph-type transform-graph-type graph-once graph-as-sonogram)
	  (list 'fft-window fft-window 6 5)
	  (list 'transform-graph? transform-graph? #f #t)
	  (list 'filter-control-in-dB filter-control-in-dB #f #t)
	  (list 'filter-control-envelope filter-control-envelope (list 0.0 1.0 1.0 1.0) (list 0.0 1.0 1.0 0.0))
	  (list 'enved-filter enved-filter #t #f)
	  (list 'enved-filter-order enved-filter-order 40 20)
	  (list 'filter-control-in-hz filter-control-in-hz #f #t)
	  (list 'filter-control-order filter-control-order 20 40)
	  (list 'filter-control? filter-control? #f #t)
	  (list 'graph-cursor graph-cursor 34 32)
	  (list 'graph-style graph-style 0 1)
	  (list 'initial-beg initial-beg 0.0 1.0)
	  (list 'initial-dur initial-dur 0.1 1.0)
	  (list 'just-sounds just-sounds #f #t)
	  (list 'listener-prompt listener-prompt ">" ":")
	  (list 'max-transform-peaks max-transform-peaks 100 10)
	  (list 'max-regions max-regions 16 6)
	  (list 'min-dB min-dB -60.0 -90.0)
	  (list 'log-freq-start log-freq-start 32.0 10.0)
	  (list 'mix-waveform-height mix-waveform-height 20 40)
	  (list 'mix-tag-height mix-tag-height 14 20)
	  (list 'mix-tag-width mix-tag-width 6 20)
	  (list 'mark-tag-height mark-tag-height 4 20)
	  (list 'mark-tag-width mark-tag-width 10 20)
	  (list 'mus-clipping mus-clipping #f #t)
	  (list 'selection-creates-region selection-creates-region #t #f)
	  (list 'transform-normalization transform-normalization normalize-by-channel dont-normalize)
	  (list 'play-arrow-size play-arrow-size 10 16)
	  (list 'print-length print-length 12 16)
	  (list 'region-graph-style region-graph-style graph-lines graph-lollipops)
	  (list 'reverb-control-decay reverb-control-decay 1.0 2.0)
	  (list 'reverb-control-feedback reverb-control-feedback 1.09 1.6)
	  (list 'reverb-control-length reverb-control-length 1.0 2.0)
	  (list 'reverb-control-length-bounds reverb-control-length-bounds (list 0.0 5.0) (list 1.0 2.0))
	  (list 'reverb-control-lowpass reverb-control-lowpass 0.7 0.9)
	  (list 'reverb-control-scale reverb-control-scale 0.0 0.2)
	  (list 'reverb-control-scale-bounds reverb-control-scale-bounds (list 0.0 4.0) (list 0.0 0.2))
	  (list 'reverb-control? reverb-control? #f #t)
	  (list 'show-axes show-axes 1 0)
	  (list 'show-full-duration show-full-duration #f #t)
	  (list 'show-full-range show-full-range #f #t)
	  (list 'show-transform-peaks show-transform-peaks #f #t)
	  (list 'show-indices show-indices #f #t)
	  (list 'show-marks show-marks #t #f)
	  (list 'show-mix-waveforms show-mix-waveforms #t #f)
	  (list 'show-selection-transform show-selection-transform #f #t)
	  (list 'show-y-zero show-y-zero #f #t)
	  (list 'show-grid show-grid #f #t)
	  (list 'grid-density grid-density 1.0 0.5)
	  (list 'show-sonogram-cursor show-sonogram-cursor #f #t)
	  (list 'sinc-width sinc-width 10 40)
	  (list 'spectrum-end spectrum-end 1.0 0.7)
	  (list 'spectro-hop spectro-hop 4 10)
	  (list 'spectrum-start spectrum-start 0.0 0.1)
	  (list 'spectro-x-angle spectro-x-angle (if (provided? 'gl) 300.0 90.0) 60.0)
	  (list 'spectro-x-scale spectro-x-scale (if (provided? 'gl) 1.5 1.0) 2.0)
	  (list 'spectro-y-angle spectro-y-angle (if (provided? 'gl) 320.0 0.0) 60.0)
	  (list 'spectro-y-scale spectro-y-scale 1.0 2.0)
	  (list 'spectro-z-angle spectro-z-angle (if (provided? 'gl) 0.0 358.0) 60.0)
	  (list 'spectro-z-scale spectro-z-scale (if (provided? 'gl) 1.0 0.1) 0.2)
	  (list 'speed-control speed-control 1.0 0.5)
	  (list 'speed-control-bounds speed-control-bounds (list 0.05 20.0) (list 1.0 5.0))
	  (list 'speed-control-style speed-control-style 0 1)
	  (list 'speed-control-tones speed-control-tones 12 18)
	  (list 'sync sync 0 1)
	  (list 'sync-style sync-style sync-by-sound sync-all)
	  (list 'tiny-font tiny-font (if (provided? 'snd-gtk) "Sans 8" "6x12") (if (provided? 'snd-gtk) "Monospace 10" "9x15"))
	  (list 'transform-type transform-type fourier-transform autocorrelation)
	  (list 'with-verbose-cursor with-verbose-cursor #f #t)
	  (list 'wavelet-type wavelet-type 0 1)
	  (list 'time-graph? time-graph? #f #t)
	  (list 'time-graph-type time-graph-type graph-once graph-as-wavogram)
	  (list 'wavo-hop wavo-hop 3 6)
	  (list 'wavo-trace wavo-trace 64 128)
	  (list 'with-mix-tags with-mix-tags #t #f)
	  (list 'with-relative-panes with-relative-panes #t #f)
	  (list 'with-gl with-gl (provided? 'gl) #f)
	  (list 'x-axis-style x-axis-style 0 1)
	  (list 'beats-per-minute beats-per-minute 30.0 120.0)
	  (list 'beats-per-measure beats-per-measure 1 120)
	  (list 'zero-pad zero-pad 0 1)
	  (list 'zoom-focus-style zoom-focus-style 2 1))))
      
      (set! *ask-about-unsaved-edits* #f)    
      (letrec ((test-bad-args
		(lambda (lst)
		  (if (pair? lst)
		      (let* ((name ((car lst) 0))
			     (getfnc ((car lst) 1))
			     (setfnc (lambda (val) (set! (getfnc) val)))
			     (initval ((car lst) 2))
			     (newvals ((car lst) 3)))
			(for-each
			 (lambda (n)
			   (catch #t 
			     (lambda ()
			       (setfnc n))
			     (lambda args (car args)))
			   (let ((nowval (getfnc)))
			     (if (equal? n nowval)
				 (snd-display #__line__ ";(bad set) ~A = ~A (~A)" name n initval))
			     (setfnc initval)))
			 newvals)
			(test-bad-args (cdr lst)))))))
	(test-bad-args
	 (list
	  (list 'amp-control amp-control 1.0 '(-1.0 123.123))
	  (list 'amp-control-bounds amp-control-bounds (list 0.0 8.0) (list #f (list 0.0) (list 1.0 0.0) 2.0))
	  (list 'channel-style channel-style 0 '(32 -1 1.0))
	  (list 'colormap colormap good-colormap '(321 -123))
	  (list 'color-cutoff color-cutoff 0.003 '(-1.0 123.123))
	  (list 'color-scale color-scale 1.0 '(-32.0 2000.0))
	  (list 'contrast-control contrast-control 0.0 '(-123.123 123.123))
	  (list 'contrast-control-bounds contrast-control-bounds (list 0.0 10.0) (list #f (list 0.0) (list 1.0 0.0) 2.0))
	  (list 'cursor-size cursor-size 15 '(1.123 -2.5))
	  (list 'dac-size dac-size 256 '(-1 0 -123))
	  (list 'dot-size dot-size 1 '(0 -1 -123))
	  (list 'enved-target enved-target 0 '(123 -321))
	  (list 'expand-control expand-control 1.0 '(-1.0 0.0))
	  (list 'expand-control-bounds expand-control-bounds (list 0.001 20.0) (list #f (list 0.0) (list 1.0 0.0) 2.0))
	  (list 'expand-control-hop expand-control-hop 0.05 '(-1.0))
	  (list 'expand-control-length expand-control-length 0.15 '(-1.0 0.0))
	  (list 'expand-control-ramp expand-control-ramp 0.4 '(-1.0 1.0 123.123))
	  (list 'fft-window-alpha fft-window-alpha 0.0  '(-1.0 123.123))
	  (list 'fft-window-beta fft-window-beta 0.0  '(-1.0 123.123))
	  (list 'transform-size transform-size 512 '(-1 0))
	  (list 'zero-pad zero-pad 0 '(-1 -123))
	  (list 'cursor-style cursor-style cursor-cross '(-1))
	  (list 'cursor-style cursor-style cursor-line '(2 123))
	  (list 'tracking-cursor-style tracking-cursor-style cursor-line '(-1))
	  (list 'tracking-cursor-style tracking-cursor-style cursor-line '(2 123))
	  (list 'transform-graph-type transform-graph-type graph-once '(-1 123))
	  (list 'fft-window fft-window 6 '(-1 123))
	  (list 'enved-filter-order enved-filter-order 40 '(-1 0))
	  (list 'filter-control-order filter-control-order 20 '(-10 -1 0))
	  (list 'max-transform-peaks max-transform-peaks 100 '(-1))
	  (list 'max-regions max-regions 16 '(-1 -123))
	  (list 'reverb-control-length reverb-control-length 1.0 '(-1.0))
	  (list 'show-axes show-axes 1 '(-1 123))
	  (list 'sinc-width sinc-width 10 '(-10))
	  (list 'spectrum-end spectrum-end 1.0 '(-1.0))
	  (list 'spectro-hop spectro-hop 4 '(-10 -1 0))
	  (list 'spectrum-start spectrum-start 0.0 '(-1.0))
	  (list 'speed-control speed-control 1.0 '(0.0))
	  (list 'speed-control-bounds speed-control-bounds (list 0.05 20.0) (list #f (list 0.0) (list 1.0 0.0) 2.0))
	  (list 'speed-control-style speed-control-style 0 '(-1 10))
	  (list 'sync-style sync-style sync-by-sound '(-1 123))
	  (list 'transform-type transform-type fourier-transform (list (integer->transform -1) (integer->transform 123)))
	  (list 'wavelet-type wavelet-type 0 '(-1 123))
	  (list 'wavo-hop wavo-hop 1 '(0 -123))
	  (list 'wavo-trace wavo-trace 1 '(0 -123))
	  (list 'x-axis-style x-axis-style 0 '(-1 123))
	  (list 'zoom-focus-style zoom-focus-style 2 '(-1 123)))))
      
      (set! *sync-style* sync-none)
      
      (set! (window-width) 300)
      (set! (window-height) 300)
      (if (<= (window-width) 30)
	  (snd-display #__line__ ";window width: ~A is not 300?" (window-width)))
      (if (<= (window-height) 30)
	  (snd-display #__line__ ";window height: ~A is not 300?" (window-height)))
					;    (set! (window-x) 123)
					;    (set! (window-y) 321)
					;    (if (not (equal? (window-x) 123))
					;	(snd-display #__line__ ";window x: ~A is not 123?" (window-x)))
					;    (if (not (equal? (window-y) 321))
					;	(snd-display #__line__ ";window y: ~A is not 321?" (window-y)))
					;    (set! (window-y) 10) ; get it back out of harm's way
      (set! *color-scale* 100.0)
      (if (fneq *color-scale* 100.0) (snd-display #__line__ ";color-scale to 100: ~A" *color-scale*))
      
      (if (procedure? (search-procedure))
	  (snd-display #__line__ ";global search procedure: ~A?" (search-procedure)))
      (set! (search-procedure) (lambda (y) (> y .1)))
      (if (not (procedure? (search-procedure)))
	  (snd-display #__line__ ";set global search procedure: ~A?" (search-procedure)))
      (if (not ((search-procedure) .2))
	  (snd-display #__line__ ";search > .1 .2"))
      (if ((search-procedure) .02)
	  (snd-display #__line__ ";search > .1 .02"))
      (set! (search-procedure) (lambda (y) (< y 0.0)))
      (if ((search-procedure) .02)
	  (snd-display #__line__ ";search < 0.0 .02"))
      (set! (search-procedure) #f)
      (if (procedure? (search-procedure))
	  (snd-display #__line__ ";global search procedure after reset: ~A?" (search-procedure)))
      (set! (search-procedure) (lambda (y) (> y .1)))
      (if (not (procedure? (search-procedure)))
	  (snd-display #__line__ ";set global search procedure: ~A?" (search-procedure)))
      
      (set! *enved-filter-order* 5)
      (if (not (= *enved-filter-order* 6)) (snd-display #__line__ ";set enved-filter-order 5: ~A" *enved-filter-order*))
      (if with-gui
	  (begin
	    (set! (enved-envelope) 'zero_to_one) ; funcs.scm above
	    (if (not (feql (enved-envelope) zero_to_one)) (snd-display #__line__ ";set symbol enved-envelope: ~A ~A" (enved-envelope) zero_to_one))
	    (set! (enved-envelope) "mod_down")
	    (if (not (feql (enved-envelope) mod_down)) (snd-display #__line__ ";set string enved-envelope: ~A ~A" (enved-envelope) mod_down))))
      
      (dismiss-all-dialogs))
    (close-sound ind) 
      
    (let ((undef ())
	  (names (list '*snd-opened-sound* 'abort 'add-colormap 'add-mark
		       'add-player 'add-sound-file-extension 'add-source-file-extension 'add-to-main-menu 'add-to-menu
		       'add-transform 'after-apply-controls-hook 'after-edit-hook 'after-graph-hook 'after-lisp-graph-hook
		       'after-open-hook 'after-save-as-hook 'after-save-state-hook 'after-transform-hook 'all-pass
		       'all-pass? 'amp-control 'amp-control-bounds 'amplitude-modulate
		       'apply-controls 'array->file 'array-interp 'as-one-edit 'ask-about-unsaved-edits
		       'ask-before-overwrite 'asymmetric-fm 'asymmetric-fm? 
		       'auto-resize 'auto-update 'auto-update-interval 'autocorrelate 'autocorrelation
		       'axis-color 'axis-info 'axis-label-font 'axis-numbers-font
		       'bad-header-hook 'bartlett-window 'bartlett-hann-window 'basic-color 'beats-per-measure 'beats-per-minute
		       'before-close-hook 'before-exit-hook 'before-save-as-hook 'before-save-state-hook 'before-transform-hook
		       'bind-key 'blackman2-window 'blackman3-window 'blackman4-window 
		       'blackman5-window 'blackman6-window 'blackman7-window 'blackman8-window 'blackman9-window 'blackman10-window 
		       'bohman-window 'bold-peaks-font 'cauchy-window 'mlt-sine-window
		       'cepstrum 'change-samples-with-origin 'channel->float-vector 'channel-amp-envs 
		       'channel-properties 'channel-property 'channel-style 'channel-widgets 'channels 'channels-combined
		       'channels-separate 'channels-superimposed 'chans 'clear-listener
		       'clip-hook 'clipping 'clm-channel 
		       'clm-table-size 'clm-default-frequency 'close-hook 'close-sound 'color->list
		       'color-cutoff 'color-orientation-dialog 'color-hook 'color-inverted 'color-scale
		       'color? 'colormap 'colormap-name 'colormap-ref 'colormap-size
		       'colormap? 'comb 'comb? 'combined-data-color 'comment 'connes-window
		       'continue-frample->file 'continue-sample->file 'contrast-control 'contrast-control-amp 'contrast-control-bounds
		       'contrast-control? 'contrast-enhancement 'controls->channel 'convolution 'convolve
		       'convolve-files 'convolve-selection-with 'convolve-with 'convolve? 'copy-context
		       'copy-sampler 'current-edit-position
		       'current-font 'cursor 'cursor-color 'cursor-context 'cursor-cross
		       'cursor-in-middle 'cursor-in-view 'cursor-line 'cursor-location-offset 'cursor-on-left
		       'cursor-on-right 'cursor-position 'cursor-size 'cursor-style 'cursor-update-interval
		       'dac-combines-channels 'dac-size 'data-color 'sample-type
		       'data-location 'data-size 'db->linear 'default-output-chans 'default-output-sample-type
		       'default-output-header-type 'default-output-srate 'define-envelope 'degrees->radians 'delay
		       'delay-tick 'delay? 'delete-colormap
		       'delete-mark 'delete-marks 'delete-sample 'delete-samples 'delete-samples-and-smooth
		       'delete-selection 'delete-selection-and-smooth 'delete-transform 'dialog-widgets 'disk-kspace
		       'display-edits 'dolph-chebyshev-window 'dont-normalize
		       'dot-product 'dot-size 'draw-axes 'draw-dot 'draw-dots
		       'draw-line 'draw-lines 'draw-mark-hook 'draw-mix-hook 'draw-string 'drop-hook
		       'during-open-hook 'edit-fragment 'edit-header-dialog 'edit-hook 'edit-list->function
		       'edit-position 'edit-tree 'edits 'edot-product 'env
		       'env-channel 'env-channel-with-base 'env-interp 'env-selection 'env-sound
		       'env? 'enved-add-point 'enved-amplitude 'enved-base 'enved-clip?
		       'enved-delete-point 'enved-dialog 'enved-envelope 'enved-filter 'enved-filter-order
		       'enved-hook 'enved-in-dB 'enved-move-point 'enved-power 'enved-spectrum
		       'enved-srate 'enved-style 'enved-target 'enved-wave? 'enved-waveform-color
		       'envelope-exponential 'envelope-linear 'eps-bottom-margin 'eps-file
		       'eps-left-margin 'eps-size 'even-multiple 'even-weight 'exit 'exit-hook
		       'expand-control 'expand-control-bounds 'expand-control-hop 'expand-control-jitter 'expand-control-length
		       'expand-control-ramp 'expand-control? 'exponential-window 'fft 'fft-log-frequency
		       'fft-log-magnitude 'fft-window 'fft-window-alpha 'fft-window-beta 'fft-with-phases 'file->array
		       'file->frample 'file->frample? 'file->sample 'file->sample? 'file->string
		       'file-name 'file-write-date 'fill-polygon 'fill-rectangle 'filter
		       'filtered-comb 'filtered-comb?
		       'filter-channel 'filter-control-coeffs 'filter-control-envelope 'filter-control-in-dB 'filter-control-in-hz
		       'filter-control-order 'filter-control-waveform-color 'filter-control? 'filter-selection 'filter-sound
		       'filter? 'find-dialog 'find-mark 'find-sound
		       'finish-progress-report 'fir-filter 'fir-filter? 'flat-top-window 'focus-widget 'foreground-color
		       'forget-region 'formant 'formant-bank 'formant-bank? 'formant? 'firmant 'firmant? 
		       'comb-bank 'comb-bank? 'all-pass-bank 'all-pass-bank? 'filtered-comb-bank 'filtered-comb-bank?
		       'make-comb-bank 'make-all-pass-bank 'make-filtered-comb-bank
		       'fourier-transform
		       'free-player 'free-sampler 'gaussian-window 'gc-off 'gc-on
		       ;'gl-graph->ps 'glSpectrogram 
		       'goto-listener-end 'granulate 'granulate?
		       'graph 'graph->ps 'graph-as-sonogram 'graph-as-spectrogram 'graph-as-wavogram
		       'graph-color 'graph-cursor 'graph-data 'graph-dots 'graph-dots-and-lines
		       'graph-filled 'graph-hook 'graph-lines 'graph-lollipops 'graph-once
		       'graph-style 'graphs-horizontal 'grid-density 'haar-transform 'hamming-window
		       'hann-poisson-window 'hann-window 'header-type 'help-dialog
		       'help-hook 'hide-widget 'highlight-color 'html-dir 'html-program
		       'hz->radians 'iir-filter 'iir-filter? 'in 'in-any
		       'ina 'inb 'info-dialog 'initial-graph-hook
		       'insert-file-dialog 'insert-region 'insert-sample 'insert-samples 'insert-samples-with-origin
		       'insert-selection 'insert-silence 'insert-sound 'just-sounds 'kaiser-window
		       'key 'key-binding 'key-press-hook 'keyboard-no-action  'peak-env-dir
;		       'ladspa-activate 'ladspa-cleanup 'ladspa-connect-port 'ladspa-deactivate 'ladspa-descriptor 'ladspa-dir
;		       'ladspa-instantiate 'ladspa-run 'ladspa-run-adding 'ladspa-set-run-adding-gain 'list-ladspa 'init-ladspa 'apply-ladspa 'analyse-ladspa
		       'left-sample
		       'linear->db 'lisp-graph 'lisp-graph-hook 'lisp-graph-style 'lisp-graph?
		       'listener-click-hook 'listener-color 'listener-font
		       'listener-prompt 'listener-selection 'listener-text-color 'little-endian? 'locsig
		       'locsig-ref 'locsig-reverb-ref 'locsig-reverb-set! 'locsig-set! 'locsig-type
		       'locsig? 'log-freq-start 'main-menu 'main-widgets 'make-all-pass
		       'make-asymmetric-fm 'make-moving-average 'make-moving-max 'make-moving-norm 'make-bezier 'make-color 'make-comb 'make-filtered-comb
		       'make-convolve 'make-delay 'make-env 'make-fft-window 'make-file->frample
		       'make-file->sample 'make-filter 'make-fir-coeffs 'make-fir-filter 'make-formant 'make-firmant 'make-formant-bank
		       'make-granulate 'make-graph-data 'make-iir-filter
		       'make-locsig 'make-mix-sampler 'make-move-sound 'make-notch 'make-one-pole 'make-one-pole-all-pass
		       'make-one-zero 'make-oscil 'make-phase-vocoder 'make-player 'make-polyshape 'make-polywave
		       'make-pulse-train 'make-rand 'make-rand-interp 'make-readin
		       'make-region 'make-region-sampler 'make-sample->file 'make-sampler 'make-sawtooth-wave
		       'make-nrxysin 'make-nrxycos 'make-rxyk!cos 'make-rxyk!sin 
		       'make-snd->sample 'make-square-wave
		       'make-src 'make-ssb-am 'make-ncos 'make-nsin 'make-table-lookup
		       'make-triangle-wave 'make-two-pole 'make-two-zero
		       'make-variable-graph 'make-float-vector 'make-wave-train 
		       'map-channel 'mark-click-hook 'mark-color 'mark-context
		       'mark-drag-hook 'mark-home 'mark-hook 'mark-name 'mark-properties 'mark-property
		       'mark-sample 'mark-sync 'mark-sync-max 'mark-tag-height 'mark-tag-width
		       'mark? 'marks 'max-regions 'max-transform-peaks 'maxamp
		       'maxamp-position 'menu-widgets 'min-dB 'mix
		       'mix-amp 'mix-amp-env 'mix-click-hook 'mix-color
		       'mix-dialog-mix 'mix-drag-hook 'mix-file-dialog 'mix-length 'mix-home
		       'mix-name 'mix-position 'mix-properties 'mix-property 'mix-region 'mix-release-hook 'mix-sync 'mix-sync-max
		       'mix-sampler? 'mix-selection 'mix-speed 'mix-tag-height
		       'mix-tag-width 'mix-tag-y
		       'mix-float-vector 'mix-waveform-height 'mix?
		       'mixes 'mouse-click-hook 'mouse-drag-hook 'mouse-enter-graph-hook
		       'mouse-enter-label-hook 'mouse-enter-listener-hook 'mouse-enter-text-hook 'mouse-leave-graph-hook 'mouse-leave-label-hook
		       'mouse-leave-listener-hook 'mouse-leave-text-hook 'mouse-press-hook 'move-locsig 'move-sound 'move-sound? 
		       'moving-average 'moving-average? 'moving-max 'moving-max? 'moving-norm 'moving-norm?
		       'mus-aifc 'mus-aiff 'mus-alaw 'mus-alsa-buffer-size 'mus-alsa-buffers
		       'mus-alsa-capture-device 'mus-alsa-device 'mus-alsa-playback-device 'mus-alsa-squelch-warning 'mus-apply
		       'mus-array-print-length 'mus-float-equal-fudge-factor 
		       'mus-b24int 'mus-bdouble 'mus-bdouble-unscaled
		       'mus-bfloat 'mus-bfloat-unscaled 'mus-bicsf 'mus-bint 'mus-bintn
		       'mus-bshort 'mus-byte 'mus-bytes-per-sample 'mus-caff 'mus-channel 'mus-channels
		       'mus-chebyshev-first-kind 'mus-chebyshev-second-kind 'mus-clipping 'mus-close
		       'mus-data 'mus-sample-type->string 'mus-sample-type-name 'mus-describe 'mus-error-hook
		       'mus-error-type->string 'mus-expand-filename 'mus-feedback 'mus-feedforward 'mus-fft
		       'mus-file-buffer-size 'mus-file-clipping 'mus-file-name
		       'mus-frequency 'mus-generator? 'mus-header-raw-defaults 'mus-header-type->string 'mus-header-type-name
		       'mus-hop 'mus-increment 'mus-input? 'mus-interp-all-pass 'mus-interp-bezier
		       'mus-interp-hermite 'mus-interp-lagrange 'mus-interp-linear 'mus-interp-none 'mus-interp-sinusoidal
		       'mus-interp-type 'mus-interpolate 'mus-ircam 'mus-l24int 'mus-ldouble
		       'mus-ldouble-unscaled 'mus-length 'mus-lfloat 'mus-lfloat-unscaled 'mus-lint
		       'mus-lintn 'mus-location 'mus-lshort 'mus-max-malloc 'mus-max-table-size
		       'mus-file-mix 'mus-mulaw 'mus-name 
		       'mus-next 'mus-nist 'mus-offset 'mus-order 'mus-oss-set-buffers
		       'mus-out-format 'mus-output? 'mus-phase 'mus-ramp
		       'mus-rand-seed 'mus-random 'mus-raw 'mus-reset 'mus-riff
		       'mus-run 'mus-scaler 'mus-set-formant-radius-and-frequency 'mus-sound-chans 
		       'mus-sound-comment 'mus-sound-sample-type 'mus-sound-data-location 'mus-sound-datum-size
		       'mus-sound-duration 'mus-sound-forget 'mus-sound-framples 'mus-sound-header-type 'mus-sound-length
		       'mus-sound-loop-info 'mus-sound-mark-info 'mus-sound-maxamp 'mus-sound-maxamp-exists? 'mus-sound-path
		       'mus-sound-prune 'mus-sound-report-cache 'mus-sound-samples
		       'mus-sound-srate 'mus-sound-type-specifier 'mus-sound-write-date
		       'mus-soundfont 'mus-srate 'mus-svx 'mus-ubshort
		       'mus-ubyte 'mus-ulshort 'mus-unknown-sample 'mus-unknown-header 'mus-voc
		       'mus-width 'mus-xcoeff 'mus-xcoeffs 'mus-ycoeff 'mus-ycoeffs
		       'name-click-hook 'new-sound 'new-sound-dialog 'new-sound-hook 'new-widget-hook
		       'next-sample 'normalize-by-channel 'normalize-by-sound 'normalize-channel 'normalize-globally
		       'notch 'notch? 'odd-multiple 'odd-weight 'one-pole 'one-pole? 'one-pole-all-pass 'one-pole-all-pass? 
		       'one-zero 'one-zero? 'open-file-dialog 'open-file-dialog-directory 'open-hook 'open-raw-sound 'open-raw-sound-hook
		       'open-sound
		       'orientation-hook 'oscil 'oscil? 'out-any 'outa
		       'outb 'outc 'outd 'output-comment-hook
		       'override-samples-with-origin 'pad-channel 'partials->polynomial 'partials->wave
		       'parzen-window 'pausing 'peaks 'peaks-font
		       'phase-partials->wave 'phase-vocoder 'phase-vocoder-amp-increments 'phase-vocoder-amps 'phase-vocoder-freqs
		       'phase-vocoder-phase-increments 'phase-vocoder-phases 'phase-vocoder? 'play 'play-arrow-size
		       'play-hook 'player-home 'player? 'players
		       'playing 'poisson-window 'polar->rectangular 'polynomial 'polyshape 'polywave
		       'polyshape? 'polywave? 'position->x 'position->y 'position-color 'preferences-dialog
		       'previous-sample 'print-dialog 'print-length 'progress-report
		       'pulse-train
		       'pulse-train? 'radians->degrees 'radians->hz
		       'ramp-channel 'rand 'rand-interp 'rand-interp? 'rand?
		       'read-mix-sample 'read-only 'read-region-sample
		       'read-sample 'readin 'readin? 
		       'rectangular->magnitudes 'rectangular->polar 'rectangular-window 'redo 'redo-edit
		       'region->float-vector 'region-chans 'region-home 'region-framples 'region-graph-style 'region-maxamp
		       'region-maxamp-position 'region-position 'region-sample 'region-sampler? 'region-srate
		       'region? 'regions 'remember-sound-state 'remove-from-menu 'status-report
		       'reset-controls 'reset-listener-cursor 'restore-controls 'restore-region
		       'reverb-control-decay 'reverb-control-feedback 'reverb-control-length 'reverb-control-length-bounds 'reverb-control-lowpass
		       'reverb-control-scale 'reverb-control-scale-bounds 'reverb-control? 'reverse-channel 'reverse-selection
		       'reverse-sound 'revert-sound 'riemann-window 'right-sample 'ring-modulate
		       'rv2-window 'rv3-window 'rv4-window 
		       'samaraki-window 'sample 'sample->file
		       'sample->file? 'sampler-at-end? 'sampler-home 'sampler-position
		       'sampler? 'samples 'samples->seconds 'sash-color
		       'save-controls 'save-dir 'save-edit-history 'save-envelopes 'save-hook
		       'save-listener 'save-marks 'save-region 'save-region-dialog
		       'save-selection 'save-selection-dialog 'save-sound 'save-sound-as 'save-sound-dialog
		       'save-state 'save-state-file 'save-state-hook 'sawtooth-wave 'sawtooth-wave?
		       'scale-by 'scale-channel 'scale-selection-by 'scale-selection-to 'scale-to
		       'scan-channel 'script-arg 'script-args 'search-procedure
		       'seconds->samples 'select-all 'select-channel 'select-channel-hook 'select-sound
		       'select-sound-hook 'selected-channel 'selected-data-color 'selected-graph-color 'selected-sound
		       'selection-chans 'selection-color 'selection-context 'selection-creates-region
		       'selection-framples 'selection-maxamp 'selection-maxamp-position 'selection-member? 'selection-position
		       'selection-srate 'selection?
		       'short-file-name 'show-all-axes 'show-all-axes-unlabelled 'show-bare-x-axis
		       'show-axes 'show-controls 'show-grid 'show-indices 'show-full-duration 'show-full-range 'initial-beg 'initial-dur
		       'show-listener 'show-marks 'show-mix-waveforms 'show-no-axes 'show-selection 'show-selection-transform
		       'show-sonogram-cursor 'show-transform-peaks 'show-widget 'show-x-axis 'show-x-axis-unlabelled
		       'show-y-zero 'sinc-width 'nrxysin 'nrxysin? 'nrxycos 'nrxycos? 'rxyk!cos 'rxyk!cos? 'rxyk!sin 'rxyk!sin? 
		       'smooth-channel 'smooth-selection 'smooth-sound 'snd->sample 'snd->sample?
		       'snd-error 'snd-error-hook 'snd-gcs 'snd-help 'snd-font 'snd-color
		       'snd-print 'snd-spectrum 'snd-tempnam 'snd-url
		       'snd-urls 'snd-version 'snd-warning 'snd-warning-hook 
		       'sound-file-extensions 'sound-file? 'sound-files-in-directory
		       'sound-loop-info 'sound-properties 'sound-property 'sound-widgets 'sound? 'soundfont-info
		       'sounds 'spectrum-end 'spectro-hop 'spectrum-start 'spectro-x-angle
		       'spectro-x-scale 'spectro-y-angle 'spectro-y-scale 'spectro-z-angle 'spectro-z-scale
		       'spectrum 'speed-control 'speed-control-as-float 'speed-control-as-ratio 'speed-control-as-semitone
		       'speed-control-bounds 'speed-control-style 'speed-control-tones 'square-wave 'square-wave?
		       'squelch-update 'srate 'src 'src-channel 'src-selection
		       'src-sound 'src? 'ssb-am 'ssb-am?
		       'start-playing 'start-playing-hook 'start-playing-selection-hook 'start-progress-report
		       'stop-player 'stop-playing 'stop-playing-hook 'stop-playing-selection-hook 'ncos
		       'ncos? 'nsin 'nsin? 'swap-channels 'sync 'sync-style 'sync-none 'sync-all 'sync-by-sound
		       'sync-max 'syncd-marks 'table-lookup 'table-lookup? 'tap 'tap?
		       'temp-dir 'text-focus-color 'time-graph 'time-graph-style
		       'time-graph-type 'time-graph? 'tiny-font 
		       'tracking-cursor-style 'transform->float-vector
		       'transform-dialog 'transform-framples 'transform-graph 'transform-graph-style 'transform-graph-type
		       'transform-graph? 'transform-normalization 'transform-sample 'transform-size 'transform-type
		       'transform? 'triangle-wave 'triangle-wave? 'tukey-window
		       'two-pole 'two-pole? 'two-zero 'two-zero? 'ultraspherical-window
		       'unbind-key  'undo 'undo-edit 'undo-hook 'unselect-all 'update-hook 'update-lisp-graph
		       'update-sound 'update-time-graph 'update-transform-graph 'variable-graph? 'float-vector
		       'float-vector* 'float-vector+ 'float-vector->channel
		       'float-vector->string 'float-vector-add!
		       'length 'float-vector-max 'float-vector-min 'float-vector-move!
		       'float-vector-multiply! 'float-vector-offset! 'float-vector-peak 'float-vector-ref 'reverse!
		       'float-vector-scale! 'float-vector-set! 'float-vector-subseq 'float-vector-subtract! 'float-vector?
		       'walsh-transform
		       'wave-train 'wave-train? 'wavelet-transform 'wavelet-type
		       'wavo-hop 'wavo-trace 'welch-window 'widget-position
		       'widget-size 'widget-text 'window-height
		       'window-width 'window-x 'window-y 'with-background-processes 'with-file-monitor 'with-gl
		       'with-mix-tags 'with-relative-panes 'with-tracking-cursor 'with-verbose-cursor 
		       'with-inset-graph 'with-interrupts 'with-pointer-focus 'with-smpte-label 'with-toolbar 'with-tooltips 'with-menu-icons
		       'save-as-dialog-src 'save-as-dialog-auto-comment
		       'x->position 'x-axis-as-clock 'x-axis-as-percentage 'x-axis-in-beats 'x-axis-in-measures
		       'x-axis-in-samples 'x-axis-in-seconds 'x-axis-label 'x-axis-style 'x-bounds
		       'x-position-slider 'x-zoom-slider 'xramp-channel 'y->position 'y-axis-label
		       'y-bounds 'y-position-slider 'y-zoom-slider 'zero-pad 'zoom-color
		       'zoom-focus-active 'zoom-focus-left 'zoom-focus-middle 'zoom-focus-right 'zoom-focus-style)))
      (for-each
       (lambda (n)
	 (if (not (defined? n))
	     (set! undef (cons n undef))))
       names)
      (if (pair? undef)
	  (snd-display #__line__ ";undefined: ~A" undef)))
    
    ))

;;; ---------------- test 4: sndlib ----------------

(if (or (not (provided? 'snd-examp.scm))
	(and (defined? 'ramp) ; why this? protection against funcs?
	     (list? ramp)))
    (load "examp.scm"))

(require snd-mix.scm snd-env.scm)

(definstrument (out-samps beg chan data)
  (let ((len (length data)))
     (do ((i 0 (+ i 1)))
	 ((= i len))
       (out-any (+ beg i) (data i) chan))))

(definstrument (out-samps-invert beg chan data)
  (let ((len (length data)))
     (do ((i 0 (+ i 1)))
	 ((= i len))
       (out-any (+ beg i) (- (data i)) chan))))

(define (snd_test_4)
  
  (define (frame->byte file fr)
    (+ (mus-sound-data-location file)
       (* (mus-sound-chans file)
	  (mus-sound-datum-size file)
	  fr)))
  
  (do ((clmtest 0 (+ 1 clmtest))) ((= clmtest tests)) 
    (log-mem clmtest)
    (clear-listener)
    (let ((chns (mus-sound-chans "oboe.snd"))
	  (dl (mus-sound-data-location "oboe.snd"))
	  (fr (mus-sound-framples "oboe.snd"))
	  (smps (mus-sound-samples "oboe.snd"))
	  (len (mus-sound-length "oboe.snd"))
	  (size (mus-sound-datum-size "oboe.snd"))
	  (com (mus-sound-comment "oboe.snd"))
	  (sr (mus-sound-srate "oboe.snd"))
	  (m1 (mus-sound-maxamp-exists? "oboe.snd"))
	  (mal (mus-sound-maxamp "oboe.snd"))
	  (mz (mus-sound-maxamp "z.snd"))
	  (bytes (mus-bytes-per-sample (mus-sound-sample-type "oboe.snd"))))
      (if (or (not (= (car mz) 0))
	      (fneq (cadr mz) 0.0))
	  (snd-display #__line__ ";mus-sound-maxamp z.snd: ~A (~A ~A)" mz (not (= (car mz) 0)) (fneq (cadr mz) 0.0)))
      (let ((formats (list mus-bshort mus-lshort mus-mulaw mus-alaw mus-byte mus-ubyte mus-bfloat mus-lfloat
			   mus-bint mus-lint mus-bintn mus-lintn mus-b24int mus-l24int mus-bdouble mus-ldouble
			   mus-ubshort mus-ulshort mus-bdouble-unscaled mus-ldouble-unscaled mus-bfloat-unscaled 
			   mus-lfloat-unscaled))
	    (sizes (list 2 2 1 1 1 1 4 4 
			 4 4 4 4 3 3 8 8
			 2 2 8 8 4
			 4)))
	(for-each
	 (lambda (frm siz)
	   (if (not (= (mus-bytes-per-sample frm) siz))
	       (snd-display #__line__ ";mus-bytes-per-sample ~A: ~A" (mus-sample-type-name frm) siz)))
	 formats
	 sizes))
      (if (not (string=? (mus-sample-type->string mus-bshort) "mus-bshort"))
	  (snd-display #__line__ ";mus-sample-type->string: ~A" (mus-sample-type->string mus-bshort)))
      (if (not (string=? (mus-header-type->string mus-aifc) "mus-aifc"))
	  (snd-display #__line__ ";mus-header-type->string: ~A" (mus-header-type->string mus-aifc)))
      (mus-sound-report-cache "hiho.tmp")
      (let ((p (open-input-file "hiho.tmp")))
	(if (not p)
	    (snd-display #__line__ ";mus-sound-report-cache->hiho.tmp failed?")
	    (let ((line (read-line p)))
	      (if (or (not (string? line))
		      (and (not (string=? line "sound table:"))
			   (not (string=? line (string-append "sound table:" (string #\newline))))))
		  (snd-display #__line__ ";print-cache 1: ~A?" line))
	      (close-input-port p)
	      (delete-file "hiho.tmp"))))
      (if (not (= chns 1)) (snd-display #__line__ ";oboe: mus-sound-chans ~D?" chns))
      (if (not (= dl 28)) (snd-display #__line__ ";oboe: mus-sound-data-location ~D (~A)?" dl (= dl 28)))
      (if (not (= fr 50828)) (snd-display #__line__ ";oboe: mus-sound-framples ~D?" fr))
      (if (not (= smps 50828)) (snd-display #__line__ ";oboe: mus-sound-samples ~D?" smps))
      (if (not (= len (+ 28 (* 2 50828)))) (snd-display #__line__ ";oboe: mus-sound-length ~D?" len))
      (if (not (= size 2)) (snd-display #__line__ ";oboe: mus-sound-datum-size ~D?" size))
      (if (not (= bytes 2)) (snd-display #__line__ ";oboe: sound-bytes ~D?" bytes))
      (if (not (= sr 22050)) (snd-display #__line__ ";oboe: mus-sound-srate ~D?" sr))
      (if (and m1 (= clmtest 0)) (snd-display #__line__ ";oboe: mus-sound-maxamp-exists before maxamp: ~A" m1))
      (if (not (mus-sound-maxamp-exists? "oboe.snd")) 
	  (snd-display #__line__ ";oboe: not mus-sound-maxamp-exists after maxamp: ~A" (mus-sound-maxamp-exists? "oboe.snd")))
      
      (if (= clmtest 0)
	  (let ((vals (mus-header-raw-defaults)))
	    (if (or (not (list? vals))
		    (not (= (length vals) 3)))
		(snd-display #__line__ ";mus-header-raw-defaults: ~A" vals)
		(let ((sr (car vals))
		      (chns (cadr vals))
		      (frm (caddr vals)))
		  (if (not (= sr 44100)) (snd-display #__line__ ";mus-header-raw-defaults srate: ~A" sr))
		  (if (not (= chns 2)) (snd-display #__line__ ";mus-header-raw-defaults chns: ~A" chns))
		  (if (not (= frm mus-bshort)) (snd-display #__line__ ";mus-header-raw-defaults format: ~A: ~A" frm (mus-sample-type-name frm)))))))
      (set! (mus-header-raw-defaults) (list 12345 3 mus-bdouble-unscaled))
      (let ((vals (mus-header-raw-defaults)))
	(if (or (not (list? vals))
		(not (= (length vals) 3)))
	    (snd-display #__line__ ";set mus-header-raw-defaults: ~A" vals)
	    (let ((sr (car vals))
		  (chns (cadr vals))
		  (frm (caddr vals)))
	      (if (not (= sr 12345)) (snd-display #__line__ ";set mus-header-raw-defaults srate: ~A" sr))
	      (if (not (= chns 3)) (snd-display #__line__ ";set mus-header-raw-defaults chns: ~A" chns))
	      (if (not (= frm mus-bdouble-unscaled)) (snd-display #__line__ ";set mus-header-raw-defaults format: ~A: ~A" frm (mus-sample-type-name frm))))))
      (set! (mus-header-raw-defaults) (list 44100 2 mus-bshort))
      
      (let ((str (strftime "%d-%b %H:%M %Z" (localtime (mus-sound-write-date "oboe.snd")))))
	(if (not (string=? str "23-Nov 06:56 PST"))
	    (snd-display #__line__ ";mus-sound-write-date oboe.snd: ~A?" str)))
      (let ((str (strftime "%d-%b %H:%M %Z" (localtime (mus-sound-write-date "pistol.snd")))))
	(if (not (string=? str "23-Nov 06:56 PST"))
	    (snd-display #__line__ ";mus-sound-write-date pistol.snd: ~A?" str)))
      
      (let ((index (open-sound "oboe.snd"))
	    (long-file-name (let ((name "test"))
			      (do ((i 0 (+ i 1)))
				  ((= i 10)) ; 40 is about the limit in Linux (256 char limit here from OS, not Snd)
				(set! name (string-append name "-test")))
			      (string-append name ".snd"))))
	(if (variable-graph? index) (snd-display #__line__ ";variable-graph thinks anything is a graph..."))
	(if (player? index) (snd-display #__line__ ";player? thinks anything is a player..."))
	(if (not (sound? index)) (snd-display #__line__ ";~A is not a sound?" index))
	(if (sound? #f) (snd-display #__line__ ";sound? #f -> #t?"))
	(if (sound? #t) (snd-display #__line__ ";sound? #t -> #t?"))
	(save-sound-as long-file-name index)
	(close-sound index)
	(set! index (open-sound long-file-name))
	(if (not (sound? index)) (snd-display #__line__ ";can't find test...snd"))
	(if (or (< (length (file-name index)) (length long-file-name))
		(< (length (short-file-name index)) (length long-file-name)))
	    (snd-display #__line__ ";file-name lengths: ~A ~A ~A"
			 (length (file-name index))
			 (length (short-file-name index))
			 (length long-file-name)))
	(close-sound index)
	(mus-sound-forget long-file-name)
	(delete-file long-file-name))
      
      (let ((old-sound-path *mus-sound-path*)
	    (new-path (if (provided? 'osx) "/Users/bil/sf1" "/home/bil/sf1")))
	(set! *mus-sound-path* (list new-path))
	(let ((ind (catch #t (lambda () (open-sound "o2.bicsf")) (lambda args #f))))
	  (if (not (sound? ind))
	      (snd-display #__line__ ";*mus-sound-path*: ~A~%" ind)
	      (begin
		(close-sound ind)
		(set! (mus-sound-path) (list new-path))
		(set! ind (catch #t (lambda () (open-sound "o2.bicsf")) (lambda args #f)))
		(if (not (sound? ind))
		    (snd-display #__line__ ";(mus-sound-path): ~A~%" ind)
		    (close-sound ind)))))
	(set! *mus-sound-path* old-sound-path))
      
      (let ((fsnd (string-append sf-dir "forest.aiff")))
	(if (file-exists? fsnd)
	    (begin
	      (system (format #f "cp ~A fmv.snd" fsnd))
	      (let ((index (open-sound "fmv.snd")))
		(if (not (equal? (sound-loop-info index) (mus-sound-loop-info fsnd)))
		    (snd-display #__line__ ";loop-info: ~A ~A" (sound-loop-info index) (mus-sound-loop-info fsnd)))
		(set! (sound-loop-info index) (list 12000 14000 1 2 3 4))
		(if (not (equal? (sound-loop-info index) (list 12000 14000 1 2 3 4 1 1)))
		    (snd-display #__line__ ";set loop-info: ~A" (sound-loop-info index)))
		(save-sound-as "fmv1.snd" index :header-type mus-aifc)
		(close-sound index)
		(if (not (equal? (mus-sound-loop-info "fmv1.snd") (list 12000 14000 1 2 3 4 1 1)))
		    (snd-display #__line__ ";saved loop-info: ~A" (mus-sound-loop-info "fmv1.snd"))))))
	(let ((index (open-sound "oboe.snd")))
	  (save-sound-as "fmv.snd" index :header-type mus-aifc)
	  (close-sound index))
	(let ((index (open-sound "fmv.snd")))
	  (if (not (null? (sound-loop-info index)))
	      (snd-display #__line__ ";null loop-info: ~A" (sound-loop-info index)))
	  (set! (sound-loop-info index) (list 1200 1400 4 3 2 1))
	  (if (not (equal? (sound-loop-info index) (list 1200 1400 4 3 2 1 1 1)))
	      (snd-display #__line__ ";set null loop-info: ~A" (sound-loop-info index)))
	  (save-sound-as "fmv1.snd" :sound index :header-type mus-aifc)
	  (close-sound index)
	  (if (not (equal? (mus-sound-loop-info "fmv1.snd") (list 1200 1400 4 3 2 1 1 1)))
	      (snd-display #__line__ ";saved null loop-info: ~A" (mus-sound-loop-info "fmv1.snd"))))
	(let ((index (open-sound "fmv.snd")))
	  (set! (sound-loop-info) (list 1200 1400 4 3 2 1 1 0))
	  (if (not (equal? (sound-loop-info index) (list 1200 1400 0 0 2 1 1 0)))
	      (snd-display #__line__ ";set null loop-info (no mode1): ~A" (sound-loop-info index)))
	  (save-sound-as "fmv1.snd" index :header-type mus-aifc)
	  (close-sound index)
	  (if (not (equal? (mus-sound-loop-info "fmv1.snd") (list 1200 1400 0 0 2 1 1 0)))
	      (snd-display #__line__ ";saved null loop-info (no mode1): ~A" (mus-sound-loop-info "fmv1.snd")))))
      
      (if (> (length com) 0) (snd-display #__line__ ";oboe: mus-sound-comment ~A?" com))
      (let ((fsnd (string-append sf-dir "nasahal8.wav")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (if (or (not (string? com)) 
		      (not (string=? com 
				     (string-append "ICRD: 1997-02-22" 
						    (string #\newline)
						    "IENG: Paul R. Roger"
						    (string #\newline)
						    "ISFT: Sound Forge 4.0"
						    (string #\newline)))))
		  (snd-display #__line__ ";mus-sound-comment \"nasahal8.wav\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "8svx-8.snd")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (if (or (not (string? com)) (not (string=? com "File created by Sound Exchange  ")))
		  (snd-display #__line__ ";mus-sound-comment \"8svx-8.snd\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "sun-16-afsp.snd")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (if (or (not (string? com)) (not (string=? com "AFspdate:1981/02/11 23:03:34 UTC")))
		  (snd-display #__line__ ";mus-sound-comment \"sun-16-afsp.snd\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "smp-16.snd")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (if (or (not (string? com)) (not (string=? com "Converted using Sox.                                        ")))
		  (snd-display #__line__ ";mus-sound-comment \"smp-16.snd\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "d40130.au")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (if (or (not (string? com)) (not (string=? com "1994 Jesus Villena")))
		  (snd-display #__line__ ";mus-sound-comment \"d40130.au\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "wood.maud")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (if (or (not (string? com)) (not (string=? com "file written by SOX MAUD-export ")))
		  (snd-display #__line__ ";mus-sound-comment \"wood.maud\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "addf8.sf_mipseb")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (if (or (not (string? com)) 
		      (not (string=? com "date=\"Feb 11 18:03:34 1981\" info=\"Original recorded at 20 kHz, 15-bit D/A, digitally filtered and resampled\" speaker=\"AMK female\" text=\"Add the sum to the product of these three.\" ")))
		  (snd-display #__line__ ";mus-sound-comment \"addf8.sf_mipseb\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "mary-sun4.sig")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (if (or (not (string? com)) (not (string=? com (string-append "MARY HAD A LITTLE LAMB" (string #\newline)))))
		  (snd-display #__line__ ";mus-sound-comment \"mary-sun4.sig\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "nasahal.pat")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (if (or (not (string? com)) (not (string=? com "This patch saved with Sound Forge 3.0.")))
		  (snd-display #__line__ ";mus-sound-comment \"nasahal.pat\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "next-16.snd")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (if (or (not (string? com)) 
		      (not (string=? com ";Written on Mon 1-Jul-91 at 12:10 PDT  at localhost (NeXT) using Allegro CL and clm of 25-June-91")))
		  (snd-display #__line__ ";mus-sound-comment \"next-16.snd\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "wood16.nsp")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (if (or (not (string? com)) (not (string=? com "Created by Snack   ")))
		  (snd-display #__line__ ";mus-sound-comment \"wood16.nsp\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "wood.sdx")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (if (or (not (string? com)) (not (string=? com "1994 Jesus Villena")))
		  (snd-display #__line__ ";mus-sound-comment \"wood.sdx\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "clmcom.aif")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (if (or (not (string? com)) (not (string=? com "this is a comment")))
		  (snd-display #__line__ ";mus-sound-comment \"clmcom.aif\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "anno.aif")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (if (or (not (string? com)) (not (string=? com (string-append "1994 Jesus Villena" (string #\newline)))))
		  (snd-display #__line__ ";mus-sound-comment \"anno.aif\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "telephone.wav")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (if (or (not (string? com)) 
		      (not (string=? com (string-append "sample_byte_format -s2 01"
							(string #\newline)
							"channel_count -i 1"
							(string #\newline)
							"sample_count -i 36461"
							(string #\newline)
							"sample_rate -i 16000"
							(string #\newline)
							"sample_n_bytes -i 2"
							(string #\newline)
							"sample_sig_bits -i 16"
							(string #\newline)))))
		  (snd-display #__line__ ";mus-sound-comment \"telephone.wav\") -> ~A?" com)))))
      
      (if (not (string? (mus-sound-comment (string-append sf-dir "traffic.aiff"))))
	  (snd-display #__line__ ";mus-sound-comment traffic: ~A" (mus-sound-comment (string-append sf-dir "traffic.aiff"))))
      
      (if (= clmtest 0)
	  (begin
	    (if (fneq (cadr mal) .14724) (snd-display #__line__ ";oboe: mus-sound-maxamp ~F?" (cadr mal)))
	    (if (not (= (car mal) 24971)) (snd-display #__line__ ";oboe: mus-sound-maxamp at ~D?" (car mal)))))
      (if (and (not (= (mus-sound-type-specifier "oboe.snd") #x646e732e))  ;little endian reader
	       (not (= (mus-sound-type-specifier "oboe.snd") #x2e736e64))) ;big endian reader
	  (snd-display #__line__ ";oboe: mus-sound-type-specifier: ~X?" (mus-sound-type-specifier "oboe.snd")))
      (if (not (string=? (strftime "%d-%b-%Y %H:%M" (localtime (file-write-date "oboe.snd"))) "23-Nov-2012 06:56"))
	  (snd-display #__line__ ";oboe: file-write-date: ~A?" (strftime "%d-%b-%Y %H:%M" (localtime (file-write-date "oboe.snd")))))
					;	(mus-sound-forget "oboe.snd")
      
      (let ((lasth (do ((i 1 (+ i 1)))
		       ((string=? (mus-header-type-name i) "unknown") i))))
	(if (< lasth 50) (snd-display #__line__ ";header-type[~A] = ~A" lasth (mus-header-type-name lasth))))
      (let ((lasth (do ((i 1 (+ i 1)))
		       ((string=? (mus-sample-type-name i) "unknown") i))))
	(if (< lasth 10) (snd-display #__line__ ";sample-type[~A] = ~A" lasth (mus-sample-type-name lasth))))
      
      (when with-gui
	(set! *transform-normalization* dont-normalize)
	(if (not (= *transform-normalization* dont-normalize))
	    (snd-display #__line__ ";set-transform-normalization none -> ~A" *transform-normalization*))
	(set! *transform-normalization* normalize-globally)
	(if (not (= *transform-normalization* normalize-globally))
	    (snd-display #__line__ ";set-transform-normalization globally -> ~A" *transform-normalization*))
	(set! *transform-normalization* normalize-by-channel)
	(if (not (= *transform-normalization* normalize-by-channel))
	    (snd-display #__line__ ";set-transform-normalization channel -> ~A" *transform-normalization*)))
      
      (let ((ind (new-sound "fmv.snd" 1 22050 mus-ldouble mus-next "set-samples test" 100)))
	(set! (samples 10 3) (make-float-vector 3 .1))
	(if (not (vequal (channel->float-vector 0 20 ind 0) (float-vector 0 0 0 0 0 0 0 0 0 0 .1 .1 .1 0 0 0 0 0 0 0)))
	    (snd-display #__line__ ";1 set samples 0 for .1: ~A" (channel->float-vector 0 20 ind 0)))
	(set! (samples 20 3 ind 0) (make-float-vector 3 .1))
	(if (not (vequal (channel->float-vector 10 20 ind 0) (float-vector .1 .1 .1 0 0 0 0 0 0 0 .1 .1 .1 0 0 0 0 0 0 0)))
	    (snd-display #__line__ ";2 set samples 10 for .1: ~A" (channel->float-vector 10 20 ind 0)))
	(set! (samples 30 3 ind 0 #f "a name") (make-float-vector 3 .1))
	(if (not (vequal (channel->float-vector 20 20 ind 0) (float-vector .1 .1 .1 0 0 0 0 0 0 0 .1 .1 .1 0 0 0 0 0 0 0)))
	    (snd-display #__line__ ";3 set samples 20 for .1: ~A" (channel->float-vector 20 20 ind 0)))
	(set! (samples 0 3 ind 0 #f "a name" 0 1) (make-float-vector 3 .2))
	(if (not (vequal (channel->float-vector 0 20 ind 0) (float-vector .2 .2 .2 0 0 0 0 0 0 0 .1 .1 .1 0 0 0 0 0 0 0)))
	    (snd-display #__line__ ";4 set samples 0 at 1 for .1: ~A" (channel->float-vector 0 20 ind 0)))
	(if (not (vequal (channel->float-vector 20 20 ind 0) (make-float-vector 20 0.0)))
	    (snd-display #__line__ ";5 set samples 20 at 1 for .1: ~A" (channel->float-vector 0 20 ind 0)))
	(let ((nd (new-sound "fmv1.snd" :channels 2)))
	  (float-vector->channel (make-float-vector 10 .5) 0 10 nd 0)
	  (float-vector->channel (make-float-vector 10 .3) 0 10 nd 1)
	  (save-sound-as "fmv1.snd" nd)
	  (close-sound nd))
	(if (not (file-exists? "fmv1.snd")) (snd-display #__line__ ";fmv1 not saved??"))
	(set! (samples 0 10 ind 0 #f "another name" 1) "fmv1.snd")
	(if (not (vequal (channel->float-vector 0 20 ind 0) (float-vector .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .1 .1 .1 0 0 0 0 0 0 0)))
	    (snd-display #__line__ ";6 set samples 0 at 1 for .1: ~A" (channel->float-vector 0 20 ind 0)))
	(set! (samples 5 6 ind 0 #f "another name 7" 0) "fmv1.snd")
	(if (not (vequal (channel->float-vector 0 20 ind 0) (float-vector .3 .3 .3 .3 .3 .5 .5 .5 .5 .5 .5 .1 .1 0 0 0 0 0 0 0)))
	    (snd-display #__line__ ";7 set samples 0 at 1 for .1: ~A" (channel->float-vector 0 20 ind 0)))
	(revert-sound ind)
	(set! (samples 0 10 ind 0 #f "another name 8" 1 0 #f) "fmv1.snd")
	(if (not (vequal (channel->float-vector 0 20 ind 0) (float-vector .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 0 0 0 0 0 0 0 0 0 0)))
	    (snd-display #__line__ ";8 set samples 0 at 1 for .1: ~A" (channel->float-vector 0 20 ind 0)))
	(set! (samples 10 10 ind 0 #f "another name 9" 0 0) "fmv1.snd")
	(if (not (vequal (channel->float-vector 0 20 ind 0) (float-vector 0 0 0 0 0 0 0 0 0 0 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5)))
	    (snd-display #__line__ ";9 set samples 0 at 1 for .1: ~A" (channel->float-vector 0 20 ind 0)))
	(set! (samples 20 10) "fmv1.snd")
	(if (not (vequal (channel->float-vector 10 20 ind 0) (make-float-vector 20 .5)))
	    (snd-display #__line__ ";10 set samples 0 at 1 for .1: ~A" (channel->float-vector 10 20 ind 0)))
	(revert-sound ind)
	(set! (samples 0 10 ind 0 #t "another name" 1 0 #f) "fmv1.snd")
	(if (not (= (framples ind 0) 10)) (snd-display #__line__ ";11 set-samples truncate to ~A" (framples ind 0)))
	(revert-sound ind)
	(delete-file "fmv1.snd")
	
	;; now try to confuse it
	(let ((tag (catch #t 
		     (lambda () (set! (samples 0 10 ind 0) "fmv1.snd"))
		     (lambda args (car args)))))
	  (if (not (eq? tag 'no-such-file)) (snd-display #__line__ ";set-samples, no such file: ~A" tag)))
	(let ((nd (new-sound "fmv1.snd" :channels 1)))
	  (float-vector->channel (make-float-vector 10 .5) 0 10 nd 0)
	  (save-sound-as "fmv1.snd" nd)
	  (close-sound nd))
	(let ((tag (catch #t
		     (lambda () (set! (samples 0 10 ind 0 #f "another name" 1) "fmv1.snd")) ; chan 1 does not exist
		     (lambda args (car args)))))
	  (if (not (eq? tag 'no-such-channel)) (snd-display #__line__ ";set-samples no such channel: ~A" tag)))
	(let ((tag (catch #t
		     (lambda () (set! (samples 0 10 ind 0 #f "another name" -1) "fmv1.snd"))
		     (lambda args (car args)))))
	  (if (not (eq? tag 'no-such-channel)) (snd-display #__line__ ";set-samples no such channel (-1): ~A" tag)))
	(let ((tag (catch #t
		     (lambda () (set! (samples 0 -10) "fmv1.snd"))
		     (lambda args (car args)))))
	  (if (not (eq? tag 'wrong-type-arg)) (snd-display #__line__ ";set-samples (-10): ~A" tag)))
	(let ((tag (catch #t
		     (lambda () (set! (samples -10 10) "fmv1.snd"))
		     (lambda args (car args)))))
	  (if (not (eq? tag 'no-such-sample)) (snd-display #__line__ ";set-samples (beg -10): ~A" tag)))
	(close-sound ind))
      
      (let ((len 100))
	(for-each
	 (lambda (type allowed-diff)
	   (let ((ind (new-sound "test.snd" 1 22050 mus-ldouble mus-next))
		 (v (make-float-vector len))
		 (maxdiff 0.0)
		 (maxpos #f))
	     (set! (v 0) 0.999)
	     (set! (v 1) -1.0)
	     (set! (v 2) .1)
	     (set! (v 3) -.1)
	     (set! (v 4) .01)
	     (set! (v 5) -.01)
	     (set! (v 4) .001)
	     (set! (v 5) -.001)
	     (set! (v 6) 0.0)
	     (do ((i 7 (+ i 1)))
		 ((= i len))
	       (let ((val (random 1.9999)))
		 (if (or (> val 2.0)
			 (< val 0.0))
		     (snd-display #__line__ ";random 2.0 -> ~A?" val))
		 (set! (v i) (- 1.0 val))))
	     (float-vector->channel v 0 len ind 0)
	     (save-sound-as "test1.snd" ind :header-type mus-next :sample-type type)
	     (close-sound ind)
	     (set! ind (open-sound "test1.snd"))
	     (let ((v1 (channel->float-vector 0 len ind 0)))
	       (do ((i 0 (+ i 1)))
		   ((= i len))
		 (let ((diff (abs (- (v i) (v1 i)))))
		   (if (> diff maxdiff)
		       (begin
			 (set! maxdiff diff)
			 (set! maxpos i)))))
	       (if (> maxdiff allowed-diff)
		   (snd-display #__line__ ";[line 2841] ~A: ~A at ~A (~A ~A)" 
				(mus-sample-type-name type) 
				maxdiff maxpos 
				(v maxpos) (v1 maxpos)))
	       (close-sound ind))))
	 (list mus-bshort   mus-lshort   mus-mulaw   mus-alaw   mus-byte  
	       mus-lfloat   mus-bint     mus-lint    mus-b24int mus-l24int
	       mus-ubshort  mus-ulshort  mus-ubyte   mus-bfloat mus-bdouble 
	       mus-ldouble)
	 (list (expt 2 -15) (expt 2 -15) 0.02 0.02 (expt 2 -7)
	       (expt 2 -23) (expt 2 -23) (expt 2 -23) (expt 2 -23) (expt 2 -23) ; assuming sndlib bits=24 here (if int)
	       (expt 2 -15) (expt 2 -15) (expt 2 -7) (expt 2 -23) (expt 2 -23)
	       (expt 2 -23))))
      
      (let* ((ob (view-sound "oboe.snd"))
	     (samp (sample 1000 ob))
	     (old-comment (mus-sound-comment "oboe.snd"))
	     (str (string-append "written " 
				 (strftime "%a %d-%b-%Y %H:%M %Z" 
					   (localtime (current-time))))))
	(set! (comment ob) str)
	(let ((tag (catch #t
		     (lambda ()
		       (save-sound-as "test.snd" ob :header-type mus-aifc :sample-type mus-bdouble))
		     (lambda args (car args)))))
	  (if (eq? tag 'cannot-save) (snd-display #__line__ ";save-sound-as test.snd write trouble")))
	(set! *filter-control-in-hz* #t)
	(let ((ab (open-sound "test.snd")))
	  (if (not (= (header-type ab) mus-aifc)) 
	      (snd-display #__line__ ";save-as aifc -> ~A?" (mus-header-type-name (header-type ab))))
	  (if (not (= (mus-sound-header-type "test.snd") mus-aifc)) 
	      (snd-display #__line__ ";saved-as aifc -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	  (if (fneq (sample 1000 ab) samp) (snd-display #__line__ ";aifc[1000] = ~A?" (sample 1000 ab)))
	  (if (or (not (string? (mus-sound-comment "test.snd")))
		  (not (string=? (mus-sound-comment "test.snd") str)))
	      (snd-display #__line__ ";output-comment: ~A ~A" (mus-sound-comment "test.snd") str))
	  (if (or (not (string? (comment ab)))
		  (not (string=? (comment ab) str)))
	      (snd-display #__line__ ";output-comment (comment): ~A ~A" (comment ab) str))
	  (close-sound ab))
	(if (not (equal? old-comment (mus-sound-comment "oboe.snd")))
	    (snd-display #__line__ ";set-comment overwrote current ~A ~A" old-comment (mus-sound-comment "oboe.snd")))
	(set! *filter-control-in-hz* #f)
	(save-sound-as "test.snd" ob :header-type mus-raw)
	(let ((ab (open-raw-sound "test.snd" 1 22050 mus-bshort)))
	  (if (not (= (header-type ab) mus-raw)) 
	      (snd-display #__line__ ";save-as raw -> ~A?" (mus-header-type-name (header-type ab))))
	  (if (not (= (mus-sound-header-type "test.snd") mus-raw)) 
	      (snd-display #__line__ ";saved-as raw -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	  (if (fneq (sample 1000 ab) samp) (snd-display #__line__ ";raw[1000] = ~A?" (sample 1000 ab)))
	  (close-sound ab))
	(save-sound-as "test.snd" ob :header-type mus-nist :sample-type mus-bint)
	(let ((ab (open-sound "test.snd")))
	  (if (not (= (header-type ab) mus-nist)) 
	      (snd-display #__line__ ";save-as nist -> ~A?" (mus-header-type-name (header-type ab))))
	  (if (not (= (mus-sound-header-type "test.snd") mus-nist)) 
	      (snd-display #__line__ ";saved-as nist -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	  (if (not (= (sample-type ab) mus-bint)) 
	      (snd-display #__line__ ";save-as int -> ~A?" (mus-sample-type-name (sample-type ab))))
	  (if (not (= (mus-sound-sample-type "test.snd") mus-bint)) 
	      (snd-display #__line__ ";saved-as int -> ~A?" (mus-sample-type-name (mus-sound-sample-type "test.snd"))))
	  (if (fneq (sample 1000 ab) samp) (snd-display #__line__ ";nist[1000] = ~A?" (sample 1000 ab)))
	  (close-sound ab))
	(set! (hook-functions output-comment-hook) ())
	(hook-push output-comment-hook
		   (lambda (hook) 
		     (set! (hook 'result) (string-append (hook 'comment) " [written by me]"))))
	(save-sound-as :file "test.snd" :sound ob :header-type mus-riff :sample-type mus-lfloat)
	(set! (hook-functions output-comment-hook) ())
	(let ((ab (open-sound "test.snd")))
	  (if (not (= (header-type ab) mus-riff)) 
	      (snd-display #__line__ ";save-as riff -> ~A?" (mus-header-type-name (header-type ab))))
	  (if (not (= (mus-sound-header-type "test.snd") mus-riff)) 
	      (snd-display #__line__ ";saved-as riff -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	  (if (not (= (sample-type ab) mus-lfloat)) 
	      (snd-display #__line__ ";save-as float -> ~A?" (mus-sample-type-name (sample-type ab))))
	  (if (not (= (mus-sound-sample-type "test.snd") mus-lfloat)) 
	      (snd-display #__line__ ";saved-as float -> ~A?" (mus-sample-type-name (mus-sound-sample-type "test.snd"))))
	  (if (fneq (sample 1000 ab) samp) (snd-display #__line__ ";riff[1000] = ~A?" (sample 1000 ab)))
	  (if (or (not (string? (comment ab)))
		  (not (string=? (comment ab) 
				 (string-append "written " 
						(strftime "%a %d-%b-%Y %H:%M %Z" (localtime (current-time)))
						" [written by me]"))))
	      (snd-display #__line__ ";output-comment-hook: ~A~%(~A)" (comment ab) (mus-sound-comment "test.snd")))
	  (close-sound ab))
	(save-sound-as "test.snd" ob :header-type mus-aiff :sample-type mus-b24int)
	(let ((ab (open-sound "test.snd")))
	  (if (not (= (header-type ab) mus-aiff)) 
	      (snd-display #__line__ ";save-as aiff -> ~A?" (mus-header-type-name (header-type ab))))
	  (if (not (= (mus-sound-header-type "test.snd") mus-aiff)) 
	      (snd-display #__line__ ";saved-as aiff -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	  (if (not (= (sample-type ab) mus-b24int))
	      (snd-display #__line__ ";save-as 24-bit -> ~A?" (mus-sample-type-name (sample-type ab))))
	  (if (not (= (mus-sound-sample-type "test.snd") mus-b24int))
	      (snd-display #__line__ ";saved-as 24-bit -> ~A?" (mus-sample-type-name (mus-sound-sample-type "test.snd"))))
	  (if (fneq (sample 1000 ab) samp) (snd-display #__line__ ";aiff[1000] = ~A?" (sample 1000 ab)))
	  (close-sound ab))
	(save-sound-as "test.snd" ob :header-type mus-ircam :sample-type mus-mulaw)
	(let ((ab (open-sound "test.snd")))
	  (if (not (= (header-type ab) mus-ircam)) 
	      (snd-display #__line__ ";save-as ircam -> ~A?" (mus-header-type-name (header-type ab))))
	  (if (not (= (mus-sound-header-type "test.snd") mus-ircam)) 
	      (snd-display #__line__ ";saved-as ircam -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	  (if (not (= (sample-type ab) mus-mulaw))
	      (snd-display #__line__ ";save-as mulaw -> ~A?" (mus-sample-type-name (sample-type ab))))
	  (if (not (= (mus-sound-sample-type "test.snd") mus-mulaw))
	      (snd-display #__line__ ";saved-as mulaw -> ~A?" (mus-sample-type-name (mus-sound-sample-type "test.snd"))))
	  (if (fneq (sample 1000 ab) samp) (snd-display #__line__ ";ircam[1000] = ~A?" (sample 1000 ab)))
	  (close-sound ab))
	(save-sound-as "test.snd" ob :header-type mus-next :sample-type mus-alaw)
	(let ((ab (open-sound "test.snd")))
	  (if (not (= (header-type ab) mus-next)) 
	      (snd-display #__line__ ";save-as next -> ~A?" (mus-header-type-name (header-type ab))))
	  (if (not (= (mus-sound-header-type "test.snd") mus-next)) 
	      (snd-display #__line__ ";saved-as next -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	  (if (not (= (sample-type ab) mus-alaw)) 
	      (snd-display #__line__ ";save-as alaw -> ~A?" (mus-sample-type-name (sample-type ab))))
	  (if (not (= (mus-sound-sample-type "test.snd") mus-alaw)) 
	      (snd-display #__line__ ";saved-as alaw -> ~A?" (mus-sample-type-name (mus-sound-sample-type "test.snd"))))
	  (if (fneq (sample 1000 ab) samp) (snd-display #__line__ ";next (alaw)[1000] = ~A?" (sample 1000 ab)))
	  (close-sound ab))
	(save-sound-as "test.snd" ob :header-type mus-next :sample-type mus-ldouble)
	(let ((ab (open-sound "test.snd")))
	  (if (not (= (header-type ab) mus-next)) 
	      (snd-display #__line__ ";save-as dbl next -> ~A?" (mus-header-type-name (header-type ab))))
	  (if (not (= (sample-type ab) mus-ldouble)) 
	      (snd-display #__line__ ";save-as dbl -> ~A?" (mus-sample-type-name (sample-type ab))))
	  (if (fneq (sample 1000 ab) samp) (snd-display #__line__ ";next (dbl)[1000] = ~A?" (sample 1000 ab)))
	  (close-sound ab))
	(save-sound-as "test.snd" ob :header-type mus-next :sample-type mus-bshort)
	(let ((ab (open-sound "test.snd")))
	  (if (not (= (header-type ab) mus-next)) 
	      (snd-display #__line__ ";save-as next -> ~A?" (mus-header-type-name (header-type ab))))
	  (if (not (= (mus-sound-header-type "test.snd") mus-next)) 
	      (snd-display #__line__ ";saved-as next -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	  (if (not (= (sample-type ab) mus-bshort)) 
	      (snd-display #__line__ ";save-as short -> ~A?" (mus-sample-type-name (sample-type ab))))
	  (if (not (= (mus-sound-sample-type "test.snd") mus-bshort)) 
	      (snd-display #__line__ ";saved-as short -> ~A?" (mus-sample-type-name (mus-sound-sample-type "test.snd"))))
	  (if (fneq (sample 1000 ab) samp) (snd-display #__line__ ";next (short)[1000] = ~A?" (sample 1000 ab)))
	  (set! (hook-functions update-hook) ())
	  (set! (y-bounds ab 0) (list -3.0 3.0))
	  (set! (sample-type ab) mus-lshort)
	  (if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd"))) ; these set!'s can change the index via update-sound
	  (if (not (= (sample-type ab) mus-lshort)) (snd-display #__line__ ";set sample-type: ~A?" (mus-sample-type-name (sample-type ab))))
	  (when with-gui
	    (if (not (equal? (y-bounds ab 0) (list -3.0 3.0))) (snd-display #__line__ ";set sample type y-bounds: ~A?" (y-bounds ab 0))))
	  (set! (y-bounds ab 0) (list 2.0))
	  (when with-gui
	    (if (not (equal? (y-bounds ab 0) (list -2.0 2.0))) (snd-display #__line__ ";set sample type y-bounds 1: ~A?" (y-bounds ab 0))))
	  (set! (y-bounds ab 0) (list -2.0))
	  (when with-gui
	    (if (not (equal? (y-bounds ab 0) (list -2.0 2.0))) (snd-display #__line__ ";set sample type y-bounds -2: ~A?" (y-bounds ab 0))))
	  (set! (header-type ab) mus-aifc)
	  (if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	  (if (not (= (header-type ab) mus-aifc)) (snd-display #__line__ ";set header-type: ~A?" (mus-header-type-name (header-type ab))))
	  (set! (channels ab) 3)
	  (if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	  (if (not (= (channels ab) 3)) (snd-display #__line__ ";set chans: ~A?" (channels ab)))
	  (set! (data-location ab) 1234)
	  (if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	  (if (not (= (data-location ab) 1234)) (snd-display #__line__ ";set data-location: ~A?" (data-location ab)))
	  (let ((old-size (data-size ab)))
	    (set! (data-size ab) 1234)
	    (if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	    (if (not (= (data-size ab) 1234)) (snd-display #__line__ ";set data-size: ~A?" (data-size ab)))
	    (set! (data-size ab) old-size))
	  (set! (srate ab) 12345)
	  (if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	  (if (not (= (srate ab) 12345)) (snd-display #__line__ ";set srate: ~A?" (srate ab)))
	  (close-sound ab))
	(save-sound-as "test.snd" ob :header-type mus-next :sample-type mus-bfloat)
	(let ((ab (open-sound "test.snd")))
	  (if (not (= (header-type ab) mus-next)) 
	      (snd-display #__line__ ";save-as next -> ~A?" (mus-header-type-name (header-type ab))))
	  (if (not (= (mus-sound-header-type "test.snd") mus-next)) 
	      (snd-display #__line__ ";saved-as next -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	  (if (not (= (sample-type ab) mus-bfloat)) 
	      (snd-display #__line__ ";save-as float -> ~A?" (mus-sample-type-name (sample-type ab))))
	  (if (not (= (mus-sound-sample-type "test.snd") mus-bfloat)) 
	      (snd-display #__line__ ";saved-as float -> ~A?" (mus-sample-type-name (mus-sound-sample-type "test.snd"))))
	  (if (fneq (sample 1000 ab) samp) (snd-display #__line__ ";next (float)[1000] = ~A?" (sample 1000 ab)))
	  (close-sound ab))
	(save-sound-as "test.snd" ob :header-type mus-next :sample-type mus-ldouble)
	(close-sound ob)
	(let ((ab (open-sound "test.snd")))
	  (set! (sample-type) mus-lshort)
	  (if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	  (if (not (= (sample-type) mus-lshort)) (snd-display #__line__ ";set sample-type: ~A?" (mus-sample-type-name (sample-type))))
	  (set! (header-type) mus-aifc)
	  (if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	  (if (not (= (header-type) mus-aifc)) (snd-display #__line__ ";set header-type: ~A?" (mus-header-type-name (header-type))))
	  (set! (channels) 3)
	  (if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	  (if (not (= (channels) 3)) (snd-display #__line__ ";set chans: ~A?" (channels)))
	  (set! (data-location) 1234)
	  (if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	  (if (not (= (data-location) 1234)) (snd-display #__line__ ";set data-location: ~A?" (data-location)))
	  (set! (srate) 12345)
	  (if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	  (if (not (= (srate) 12345)) (snd-display #__line__ ";set srate: ~A?" (srate)))
	  (close-sound ab)))
      
      (let ((ind (open-sound "2a.snd")))
	(save-sound-as "test.snd" :sample-type mus-l24int :header-type mus-riff :channel 0)
	(let ((ind0 (open-sound "test.snd")))
	  (if (not (= (channels ind0) 1)) 
	      (snd-display #__line__ ";save-sound-as :channel 0 chans: ~A" (channels ind0)))
	  (if (not (= (sample-type ind0) mus-l24int)) 
	      (snd-display #__line__ ";save-sound-as :channel 0 sample-type: ~A ~A" (sample-type ind0) (mus-sample-type-name (sample-type ind0))))
	  (if (not (= (header-type ind0) mus-riff))
	      (snd-display #__line__ ";save-sound-as :channel 0 header-type: ~A ~A" (header-type ind0) (mus-header-type-name (header-type ind0))))
	  (if (not (= (srate ind0) (srate ind)))
	      (snd-display #__line__ ";save-sound-as :channel 0 srates: ~A ~A" (srate ind0) (srate ind)))    
	  (if (not (= (framples ind0) (framples ind 0)))
	      (snd-display #__line__ ";save-sound-as :channel 0 framples: ~A ~A" (framples ind0) (framples ind 0)))
	  (if (fneq (maxamp ind0 0) (maxamp ind 0))
	      (snd-display #__line__ ";save-sound-as :channel 0 maxamps: ~A ~A" (maxamp ind0 0) (maxamp ind 0)))
	  (close-sound ind0))
	(save-sound-as "test.snd" :sample-type mus-l24int :header-type mus-riff)
	(let ((ind0 (open-sound "test.snd")))
	  (if (not (= (channels ind0) 2)) 
	      (snd-display #__line__ ";save-sound-as chans: ~A" (channels ind0)))
	  (if (not (= (sample-type ind0) mus-l24int)) 
	      (snd-display #__line__ ";save-sound-as sample-type: ~A ~A" (sample-type ind0) (mus-sample-type-name (sample-type ind0))))
	  (if (not (= (header-type ind0) mus-riff))
	      (snd-display #__line__ ";save-sound-as header-type: ~A ~A" (header-type ind0) (mus-header-type-name (header-type ind0))))
	  (if (not (= (srate ind0) (srate ind)))
	      (snd-display #__line__ ";save-sound-as srates: ~A ~A" (srate ind0) (srate ind)))    
	  (if (not (= (framples ind0) (framples ind 0)))
	      (snd-display #__line__ ";save-sound-as framples: ~A ~A" (framples ind0) (framples ind 0)))
	  (if (fneq (maxamp ind0 0) (maxamp ind 0))
	      (snd-display #__line__ ";save-sound-as maxamps: ~A ~A" (maxamp ind0 0) (maxamp ind 0)))
	  (close-sound ind0))
	(save-sound-as "test.snd" :sample-type mus-b24int :header-type mus-aiff)
	(let ((ind0 (open-sound "test.snd")))
	  (if (not (= (channels ind0) 2)) 
	      (snd-display #__line__ ";save-sound-as chans: ~A" (channels ind0)))
	  (if (not (= (sample-type ind0) mus-b24int)) 
	      (snd-display #__line__ ";save-sound-as sample-type: ~A ~A" (sample-type ind0) (mus-sample-type-name (sample-type ind0))))
	  (if (not (= (header-type ind0) mus-aiff))
	      (snd-display #__line__ ";save-sound-as header-type: ~A ~A" (header-type ind0) (mus-header-type-name (header-type ind0))))
	  (if (not (= (srate ind0) (srate ind)))
	      (snd-display #__line__ ";save-sound-as srates: ~A ~A" (srate ind0) (srate ind)))    
	  (if (not (= (framples ind0) (framples ind 0)))
	      (snd-display #__line__ ";save-sound-as framples: ~A ~A" (framples ind0) (framples ind 0)))
	  (if (fneq (maxamp ind0 0) (maxamp ind 0))
	      (snd-display #__line__ ";save-sound-as maxamps: ~A ~A" (maxamp ind0 0) (maxamp ind 0)))
	  (close-sound ind0))
	(save-sound-as "test.snd" :sample-type mus-bfloat :header-type mus-aifc :channel 1 :srate 12345)
	(let ((ind0 (open-sound "test.snd")))
	  (if (not (= (channels ind0) 1)) 
	      (snd-display #__line__ ";save-sound-as :channel 1 chans: ~A" (channels ind0)))
	  (if (not (= (sample-type ind0) mus-bfloat)) 
	      (snd-display #__line__ ";save-sound-as :channel 1 sample-type: ~A ~A" (sample-type ind0) (mus-sample-type-name (sample-type ind0))))
	  (if (not (= (header-type ind0) mus-aifc))
	      (snd-display #__line__ ";save-sound-as :channel 1 header-type: ~A ~A" (header-type ind0) (mus-header-type-name (header-type ind0))))
	  (if (not (= (srate ind0) 12345))
	      (snd-display #__line__ ";save-sound-as :channel 1 srates: ~A ~A" (srate ind0) (srate ind)))    
	  (if (not (= (framples ind0) (framples ind 1)))
	      (snd-display #__line__ ";save-sound-as :channel 1 framples: ~A ~A" (framples ind0) (framples ind 1)))
	  (if (fneq (maxamp ind0 0) (maxamp ind 1))
	      (snd-display #__line__ ";save-sound-as :channel 1 maxamps: ~A ~A" (maxamp ind0 0) (maxamp ind 1)))
	  (close-sound ind0))
	(save-sound-as "test.snd" :channel 1 :comment "this is a test")
	(let ((ind0 (open-sound "test.snd")))
	  (if (not (= (channels ind0) 1)) 
	      (snd-display #__line__ ";save-sound-as :channel 1 (1) chans: ~A" (channels ind0)))
	  (if (not (= (sample-type ind0) (sample-type ind)))
	      (snd-display #__line__ ";save-sound-as :channel 1 (1) sample-type: ~A ~A" (sample-type ind0) (mus-sample-type-name (sample-type ind0))))
	  (if (not (= (header-type ind0) (header-type ind)))
	      (snd-display #__line__ ";save-sound-as :channel 1 (1) header-type: ~A ~A" (header-type ind0) (mus-header-type-name (header-type ind0))))
	  (if (not (= (srate ind0) (srate ind)))
	      (snd-display #__line__ ";save-sound-as :channel 1 (1) srates: ~A ~A" (srate ind0) (srate ind)))    
	  (if (not (= (framples ind0) (framples ind 1)))
	      (snd-display #__line__ ";save-sound-as :channel 1 (1) framples: ~A ~A" (framples ind0) (framples ind 1)))
	  (if (fneq (maxamp ind0 0) (maxamp ind 1))
	      (snd-display #__line__ ";save-sound-as :channel 1 (1) maxamps: ~A ~A" (maxamp ind0 0) (maxamp ind 1)))
	  (if (not (string=? (comment ind0) "this is a test"))
	      (snd-display #__line__ ";save-sound-as :channel 0 (1) comment: ~A" (comment ind0)))
	  (close-sound ind0))
	(close-sound ind))
      
      (let ((fsnd (string-append sf-dir "t15.aiff")))
	(if (file-exists? fsnd)
	    (let ((ind (open-sound fsnd)))
	      (if (or (fneq (sample 132300 ind 0) .148)
		      (fneq (sample 132300 ind 1) .126))
		  (snd-display #__line__ ";aifc sowt trouble: ~A ~A" (sample 132300 ind 0) (sample 132300 ind 1)))
	      (close-sound ind))))
      (let ((fsnd (string-append sf-dir "M1F1-float64C-AFsp.aif")))
	(if (file-exists? fsnd)
	    (let ((ind (open-sound fsnd)))
	      (if (or (fneq (sample 8000 ind 0) -0.024)
		      (fneq (sample 8000 ind 1) 0.021))
		  (snd-display #__line__ ";aifc fl64 trouble: ~A ~A" (sample 8000 ind 0) (sample 8000 ind 1)))
	      (close-sound ind))))
      
      (for-each (lambda (n vals)
		  (let ((val (catch #t (lambda () 
					 (list (mus-sound-chans n)
					       (mus-sound-srate n)
					       (mus-sound-framples n)))
				    (lambda args (car args)))))
		    (if (and (not (equal? val vals))
			     (not (eq? val 'mus-error)))
			(snd-display #__line__ ";~A: ~A ~A" n val vals))))
		(list (string-append sf-dir "bad_chans.snd")
		      (string-append sf-dir "bad_srate.snd")
		      (string-append sf-dir "bad_data_format.snd")
		      (string-append sf-dir "bad_chans.aifc")
		      (string-append sf-dir "bad_srate.aifc")
		      (string-append sf-dir "bad_length.aifc")
		      (string-append sf-dir "bad_chans.riff")
		      (string-append sf-dir "bad_srate.riff")
		      (string-append sf-dir "bad_chans.nist")
		      (string-append sf-dir "bad_srate.nist")
		      (string-append sf-dir "bad_length.nist"))
		(list (list 0 22050 0)
		      (list 1 0 0)
		      (list 1 22050 4411)
		      (list 0 22050 0)
		      (list 1 0 0)
		      (list 1 22050 -10)
		      (list 0 22050 0)
		      (list 1 0 0)
		      (list 0 22050 0)
		      (list 1 0 0)
		      (list 1 22050 -10)))
      
      (let ((ind (open-sound (string-append "/usr/include/sys/" home-dir "/cl/oboe.snd"))))
	(if (or (not (sound? ind))
		(not (string=? (short-file-name ind) "oboe.snd")))
	    (snd-display #__line__ ";open-sound with slashes: ~A ~A" ind (and (sound? ind) (short-file-name ind))))
	(hook-push bad-header-hook (lambda (hook) (set! (hook 'result) #t)))
	(for-each (lambda (n)
		    (catch #t (lambda () 
				(insert-sound n))
			   (lambda args (car args)))
		    (catch #t (lambda () 
				(convolve-with n))
			   (lambda args (car args)))
		    (catch #t (lambda () 
				(mix n))
			   (lambda args (car args)))
		    (catch #t (lambda () 
				(let ((ind (open-sound n)))
				  (if (and (number? ind)
					   (sound? ind))
				      (close-sound ind))))
			   (lambda args (car args))))
		  (list (string-append sf-dir "bad_chans.snd")
			(string-append sf-dir "bad_srate.snd")
			(string-append sf-dir "bad_chans.aifc")
			(string-append sf-dir "bad_srate.aifc")
			(string-append sf-dir "bad_length.aifc")
			(string-append sf-dir "bad_chans.riff")
			(string-append sf-dir "bad_srate.riff")
			(string-append sf-dir "bad_chans.nist")
			(string-append sf-dir "bad_location.nist")
			(string-append sf-dir "bad_field.nist")
			(string-append sf-dir "bad_srate.nist")
			(string-append sf-dir "bad_length.nist")))
	(close-sound ind))
      
      (for-each close-sound (sounds))
      
      (if (selected-sound)
	  (snd-display #__line__ ";selected-sound ~A ~A" (selected-sound) (sounds)))
      
      (if (file-exists? (string-append (or sf-dir "") "a.sf2"))
	  (let ((fil (open-sound (string-append (or sf-dir "") "a.sf2"))))
	    (if fil
		(let ((loops (and fil (soundfont-info))))
		  (if (or (null? loops)
			  (not (= (caddar loops) 65390))
			  (not (= (cadadr loops) 65490)))
		      (snd-display #__line__ ";soundfont-info: ~A?" loops))
		  (close-sound fil)))))
      
      (if (file-exists? "fmv5.snd") (delete-file "fmv5.snd"))
      (set! *print-length* 12)
      
      (for-each
       (lambda (file)
	 (let ((tag (catch #t
		      (lambda () (open-sound (string-append sf-dir file)))
		      (lambda args args))))
	   (if (not (eq? (car tag) 'mus-error))
	       (snd-display #__line__ ";open-sound ~A: ~A" file tag))))
       (list "trunc.snd" "trunc.aiff" "trunc.wav" "trunc.sf" "trunc.voc" "trunc.nist" "bad.wav" 
	     "trunc1.aiff" "badform.aiff"))
      
      (hook-push open-raw-sound-hook (lambda (hook) (set! (hook 'result) (list 1 22050 mus-bshort))))
      (let ((ind (open-sound (string-append sf-dir "empty.snd"))))
	(if (or (not (= (sample-type ind) mus-bshort))
		(not (= (chans ind) 1))
		(not (= (srate ind) 22050))
		(not (= (data-location ind) 0))
		(not (= (framples ind) 0)))
	    (snd-display #__line__ ";open raw: ~A ~A ~A ~A ~A" (sample-type ind) (chans ind) (srate ind) (data-location ind) (framples ind)))
	(set! (hook-functions open-raw-sound-hook) ())
	(close-sound ind))
      
      (let ((sd (make-float-vector (list 1 1) 0.0)))
	(if (fneq (sd 0 0) 0.0) (snd-display #__line__ ";vector2 ref: ~A" (sd 0 0)))
	(set! (sd 0 0) 1.0)
	(if (fneq (sd 0 0) 1.0) (snd-display #__line__ ";vector2 set: ~A" (sd 0 0)))
	(if (not (equal? sd (let ((sd1 (make-float-vector (list 1 1) 0.0))) (vector-set! sd1 0 0 1.0) sd1)))
	    (snd-display #__line__ ";vector2 set not equal: ~A" sd)))
      
      (let ((sd (make-float-vector (list 2 3) 0.0)))
	(if (fneq (sd 0 0) 0.0) (snd-display #__line__ ";vector2 ref (1): ~A" (sd 0 0)))
	(set! (sd 1 0) 1.0)
	(if (fneq (sd 1 0) 1.0) (snd-display #__line__ ";vector2 set (1 0): ~A" (sd 1 0)))
	(set! (sd 1 2) 2.0)
	(if (fneq (sd 1 2) 2.0) (snd-display #__line__ ";vector2 set (1 2): ~A" (sd 1 2)))
	(if (not (equal? sd (let ((sd1 (make-float-vector (list 2 3) 0.0)))
			      (vector-set! sd1 1 0 1.0)
			      (vector-set! sd1 1 2 2.0)
			      sd1)))
	    (snd-display #__line__ ";vector2 set (3) not equal: ~A" sd)))
      
      ;; check clipping choices
      (let ((ind (view-sound "oboe.snd")))
	(set! *clipping* #f)
	(scale-channel 10.0)
	(save-sound-as "test.snd" ind :header-type mus-next :sample-type mus-ldouble)
	(undo 1 ind 0)
	(let ((ind1 (open-sound "test.snd")))
	  (if (fneq (maxamp ind1 0) (* 10 (maxamp ind 0)))
	      (snd-display #__line__ ";clipping 0: ~A ~A" (maxamp ind1 0) (maxamp ind 0)))
	  (close-sound ind1))
	(delete-file "test.snd")
	(set! *clipping* #t)
	(map-channel (lambda (y) (* y 10.0)) 0 #f ind 0)
	(save-sound-as "test.snd" ind :header-type mus-next :sample-type mus-lshort)
	(undo 1 ind 0)
	(let ((ind1 (open-sound "test.snd")))
	  (if (fneq (maxamp ind1 0) 1.0)
	      (snd-display #__line__ ";clipping 1: ~A ~A" (maxamp ind1 0) (maxamp ind 0)))
	  (close-sound ind1))
	(delete-file "test.snd")
	(set! *clipping* #f)
	(let* ((mx (maxamp ind))
	       (sub (- 1.001 mx)))
	  (map-channel (lambda (y) (+ y sub)) 0 #f ind 0)
	  (save-sound-as "test.snd" ind :header-type mus-next :sample-type mus-lfloat)
	  (let ((ind1 (open-sound "test.snd"))
		(baddy (scan-channel (lambda (y) (< y 0.0)))))
	    (if baddy
		(snd-display #__line__ ";clipping 2: ~A" baddy))
	    (close-sound ind1))
	  (delete-file "test.snd")
	  (set! *clipping* #t)
	  (save-sound-as "test.snd" ind :header-type mus-next :sample-type mus-ldouble)
	  (let ((ind1 (open-sound "test.snd"))
		(baddy (scan-channel (lambda (y) (< y 0.0)))))
	    (if baddy
		(snd-display #__line__ ";clipping 3: ~A ~A" baddy (sample baddy)))
	    (close-sound ind1))
	  (delete-file "test.snd")
	  (set! *clipping* #f))
	(close-sound ind))
      (delete-file "fmv.snd")
      
      (set! *clipping* #f)
      (let ((snd (new-sound "test.snd" :sample-type mus-lshort)))
	(pad-channel 0 10)
	(set! (sample 1) 1.0)
	(set! (sample 2) -1.0)
	(set! (sample 3) 0.9999)
	(set! (sample 4) 2.0)
	(set! (sample 5) -2.0)
	(set! (sample 6) 1.3)
	(set! (sample 7) -1.3)
	(set! (sample 8) 1.8)
	(set! (sample 9) -1.8)
	(save-sound snd)
	(close-sound snd))
      (let ((snd (open-sound "test.snd")))
	(let ((data (channel->float-vector 0 10)))
	  (if (not (vequal data (float-vector 0.000 1.000 -1.000 1.000 0.000 0.000 -0.700 0.700 -0.200 0.200)))
	      (snd-display #__line__ ";unclipped 1: ~A" data)))
	(close-sound snd))
      (mus-sound-forget "test.snd")
      
      (set! *clipping* #t)
      (let ((snd (new-sound "test.snd" :sample-type mus-lshort)))
	(pad-channel 0 10)
	(set! (sample 1) 1.0)
	(set! (sample 2) -1.0)
	(set! (sample 3) 0.9999)
	(set! (sample 4) 2.0)
	(set! (sample 5) -2.0)
	(set! (sample 6) 1.3)
	(set! (sample 7) -1.3)
	(set! (sample 8) 1.8)
	(set! (sample 9) -1.8)
	(save-sound snd)
	(close-sound snd))
      (let ((snd (open-sound "test.snd")))
	(let ((data (channel->float-vector 0 10)))
	  (if (not (vequal data (float-vector 0.000 1.000 -1.000 1.000 1.000 -1.000 1.000 -1.000 1.000 -1.000)))
	      (snd-display #__line__ ";clipped: ~A" data)))
	(close-sound snd))
      (set! *clipping* #f)
      
      (let ((test-data (lambda (file beg dur data)
			 (catch #t
			   (lambda ()
			     (let* ((ind (open-sound file))
				    (ndata (channel->float-vector beg dur ind 0)))
			       (if (not (vequal data ndata))
				   (snd-display #__line__ ";~A: ~A != ~A" file data ndata))
			       (close-sound ind)))
			   (lambda args args)))))
	(test-data (string-append sf-dir "next-dbl.snd") 10 10 (float-vector 0.475 0.491 0.499 0.499 0.492 0.476 0.453 0.423 0.387 0.344))
	(test-data (string-append sf-dir "oboe.ldbl") 1000 10 (float-vector 0.033 0.035 0.034 0.031 0.026 0.020 0.013 0.009 0.005 0.004))
	
	(test-data (string-append sf-dir "next-flt.snd") 10 10 (float-vector 0.475 0.491 0.499 0.499 0.492 0.476 0.453 0.423 0.387 0.344))
	(test-data (string-append sf-dir "clbonef.wav") 1000 10 (float-vector 0.111 0.101 0.070 0.032 -0.014 -0.060 -0.085 -0.108 -0.129 -0.152))
	
	(test-data (string-append sf-dir "next-8.snd") 10 10 (float-vector 0.898 0.945 0.977 0.992 0.992 0.977 0.945 0.906 0.844 0.773))
	(test-data (string-append sf-dir "o2_u8.wave") 1000 10 (float-vector -0.164 -0.219 -0.258 -0.242 -0.180 -0.102 -0.047 0.000 0.039 0.055))
	
	(test-data (string-append sf-dir "next-16.snd") 1000 10 (float-vector -0.026 -0.022 -0.024 -0.030 -0.041 -0.048 -0.050 -0.055 -0.048 -0.033))
	(test-data (string-append sf-dir "o2.wave") 1000 10 (float-vector -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
	
	(test-data (string-append sf-dir "o2_18bit.aiff") 1000 10 (float-vector -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
	(test-data (string-append sf-dir "o2_12bit.aiff") 1000 10 (float-vector -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
	
	(test-data (string-append sf-dir "next24.snd") 1000 10 (float-vector -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
	(test-data (string-append sf-dir "mono24.wav") 1000 10 (float-vector 0.005 0.010 0.016 0.008 -0.007 -0.018 -0.025 -0.021 -0.005 0.001))
	
	(test-data (string-append sf-dir "o2_711u.wave") 1000 10 (float-vector -0.164 -0.219 -0.254 -0.242 -0.172 -0.103 -0.042 0.005 0.042 0.060))
	(test-data (string-append sf-dir "alaw.wav") 1000 10 (float-vector -0.024 -0.048 -0.024 0.000 0.008 0.008 0.000 -0.040 -0.064 -0.024))
	
	;; it is not a bug if these don't match if MUS_SAMPLE_BITS is not 24
	(test-data (string-append sf-dir "b32.pvf") 1000 10 (float-vector -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
	(test-data (string-append sf-dir "b32.wave") 1000 10 (float-vector -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
	(test-data (string-append sf-dir "b32.snd") 1000 10 (float-vector -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
	(test-data (string-append sf-dir "32bit.sf") 1000 10 (float-vector 0.016 0.014 0.013 0.011 0.010 0.010 0.010 0.010 0.012 0.014))
	
	(test-data (string-append sf-dir "nist-shortpack.wav") 10000 10 (float-vector 0.021 0.018 0.014 0.009 0.004 -0.001 -0.004 -0.006 -0.007 -0.008))
	(test-data (string-append sf-dir "wood.sds") 1000 10 (float-vector -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
					;	  (test-data (string-append sf-dir "oboe.g721") 1000 10 (float-vector -0.037 -0.040 -0.040 -0.041 -0.042 -0.038 -0.028 -0.015 -0.005 0.002))
					;	  (test-data (string-append sf-dir "oboe.g723_40") 1000 10 (float-vector -0.037 -0.040 -0.041 -0.041 -0.041 -0.038 -0.028 -0.015 -0.005 0.003))
	(test-data (string-append sf-dir "mus10.snd") 10000 10 (float-vector 0.004 0.001 0.005 0.009 0.017 0.015 0.008 0.011 0.009 0.012))
	(test-data (string-append sf-dir "ieee-text-16.snd") 1000 10 (float-vector -0.052 -0.056 -0.069 -0.077 -0.065 -0.049 -0.054 -0.062 -0.066 -0.074))
	(test-data (string-append sf-dir "hcom-16.snd") 10000 10 (float-vector 0.000 0.000 0.000 0.008 0.000 -0.016 -0.016 -0.016 -0.008 0.000))
	(test-data (string-append sf-dir "ce-c3.w02") 1000 10 (float-vector 0.581 0.598 0.596 0.577 0.552 0.530 0.508 0.479 0.449 0.425))
	(test-data (string-append sf-dir "nasahal.avi") 20000 10 (float-vector 0.390 0.120 -0.399 -0.131 0.464 0.189 -0.458 -0.150 0.593 0.439))
	(test-data (string-append sf-dir "oki.wav") 100 10 (float-vector 0.396 0.564 0.677 0.779 0.761 0.540 0.209 -0.100 -0.301 -0.265))
	
	(test-data (string-append sf-dir "trumps22.adp") 5000 10 (float-vector 0.267 0.278 0.309 0.360 0.383 0.414 0.464 0.475 0.486 0.495))
	)
      
      (let ((errs (list "no error" "no frequency method" "no phase method" "null gen arg to method" "no length method"
			"no describe method" "no data method" "no scaler method"
			"memory allocation failed" 
			"can't open file" "no sample input" "no sample output"
			"no such channel" "no file name provided" "no location method" "no channel method"
			"no such fft window" "unknown sample type" "header read failed"
			"unknown header type" "file descriptors not initialized" "not a sound file" "file closed" "write error"
			"header write failed" "can't open temp file" "interrupted" "bad envelope"
			"audio channels not available" "audio srate not available" "audio sample type not available"
			"no audio input available" "audio configuration not available" 
			"audio write error" "audio size not available" "audio device not available"
			"can't close audio" "can't open audio" "audio read error"
			"can't write audio" "can't read audio" "no audio read permission" 
			"can't close file" "arg out of range" 
			"no channels method" "no hop method" "no width method" "no file-name method" "no ramp method" "no run method"
			"no increment method" "no offset method"
			"no xcoeff method" "no ycoeff method" "no xcoeffs method" "no ycoeffs method" "no reset" "bad size" "can't convert"
			"read error"
			"no feedforward method" "no feedback method" "no interp-type method" "no position method" "no order method" "no copy method"
			"can't translate"
			)))
	(let ((happy #t)
	      (len (length errs)))
	  (do ((i 0 (+ i 1)))
	      ((or (not happy) (= i len)))
	    (if (not (string=? (errs i) (mus-error-type->string i)))
		(begin
		  (snd-display #__line__ ";mus-error-type->string ~D: ~A ~A" i (errs i) (mus-error-type->string i))
		  (set! happy #f))))))
      
					;	  (let ((new-id (mus-make-error "hiho all messed up")))
					;	    (if (not (string=? (mus-error-type->string new-id) "hiho all messed up"))
					;		(snd-display #__line__ ";mus-make-error :~A ~A" new-id (mus-error-type->string new-id))))
      
      (let ((cur-srate (mus-sound-srate "oboe.snd"))
	    (cur-chans (mus-sound-chans "oboe.snd"))
	    (cur-format (mus-sound-sample-type "oboe.snd"))
	    (cur-type (mus-sound-header-type "oboe.snd"))
	    (cur-loc (mus-sound-data-location "oboe.snd"))
	    (cur-samps (mus-sound-samples "oboe.snd")))
	(set! (mus-sound-srate "oboe.snd") (* cur-srate 2))
	(if (not (= (* cur-srate 2) (mus-sound-srate "oboe.snd"))) 
	    (snd-display #__line__ ";set mus-sound-srate: ~A -> ~A" cur-srate (mus-sound-srate "oboe.snd")))
	(set! (mus-sound-samples "oboe.snd") (* cur-samps 2))
	(if (not (= (* cur-samps 2) (mus-sound-samples "oboe.snd"))) 
	    (snd-display #__line__ ";set mus-sound-samples: ~A -> ~A" cur-samps (mus-sound-samples "oboe.snd")))
	(set! (mus-sound-chans "oboe.snd") (* cur-chans 2))
	(if (not (= (* cur-chans 2) (mus-sound-chans "oboe.snd"))) 
	    (snd-display #__line__ ";set mus-sound-chans: ~A -> ~A" cur-chans (mus-sound-chans "oboe.snd")))
	(set! (mus-sound-data-location "oboe.snd") (* cur-loc 2))
	(if (not (= (* cur-loc 2) (mus-sound-data-location "oboe.snd"))) 
	    (snd-display #__line__ ";set mus-sound-data-location: ~A -> ~A" cur-loc (mus-sound-data-location "oboe.snd")))
	(set! (mus-sound-header-type "oboe.snd") mus-nist)
	(if (not (= mus-nist (mus-sound-header-type "oboe.snd"))) 
	    (snd-display #__line__ ";set mus-sound-header-type: ~A -> ~A" cur-type (mus-sound-header-type "oboe.snd")))
	(set! (mus-sound-sample-type "oboe.snd") mus-lintn)
	(if (not (= mus-lintn (mus-sound-sample-type "oboe.snd"))) 
	    (snd-display #__line__ ";set mus-sound-sample-type: ~A -> ~A" cur-format (mus-sound-sample-type "oboe.snd")))
	(set! (mus-sound-srate "oboe.snd") cur-srate)
	(set! (mus-sound-samples "oboe.snd") cur-samps)
	(set! (mus-sound-chans "oboe.snd") cur-chans)
	(set! (mus-sound-data-location "oboe.snd") cur-loc)
	(set! (mus-sound-header-type "oboe.snd") cur-type)
	(set! (mus-sound-sample-type "oboe.snd") cur-format))
      
      (let ((ind (open-sound "oboe.snd")))
	(save-sound-as "test.wave" ind :header-type mus-riff)
	(save-sound-as "test.rf64" ind :header-type mus-rf64)
	(save-sound-as "test.aifc" ind :header-type mus-aifc)
	(close-sound ind)
	
	(for-each
	 (lambda (file)
	   (let ((cur-srate (mus-sound-srate file))
		 (cur-chans (mus-sound-chans file))
		 (cur-format (mus-sound-sample-type file))
		 (cur-type (mus-sound-header-type file))
		 (cur-loc (mus-sound-data-location file))
		 (cur-samps (mus-sound-samples file)))
	     (set! (mus-sound-srate file) (* cur-srate 2))
	     (if (not (= (* cur-srate 2) (mus-sound-srate file))) 
		 (snd-display #__line__ ";~A: set mus-sound-srate: ~A -> ~A" file cur-srate (mus-sound-srate file)))
	     (set! (mus-sound-samples file) (* cur-samps 2))
	     (if (not (= (* cur-samps 2) (mus-sound-samples file))) 
		 (snd-display #__line__ ";~A: set mus-sound-samples: ~A -> ~A" file cur-samps (mus-sound-samples file)))
	     (set! (mus-sound-chans file) (* cur-chans 2))
	     (if (not (= (* cur-chans 2) (mus-sound-chans file))) 
		 (snd-display #__line__ ";~A: set mus-sound-chans: ~A -> ~A" file cur-chans (mus-sound-chans file)))
	     (set! (mus-sound-data-location file) (* cur-loc 2))
	     (if (not (= (* cur-loc 2) (mus-sound-data-location file))) 
		 (snd-display #__line__ ";~A: set mus-sound-data-location: ~A -> ~A" file cur-loc (mus-sound-data-location file)))
	     (set! (mus-sound-header-type file) mus-nist)
	     (if (not (= mus-nist (mus-sound-header-type file))) 
		 (snd-display #__line__ ";~A: set mus-sound-header-type: ~A -> ~A" file cur-type (mus-sound-header-type file)))
	     (set! (mus-sound-sample-type file) mus-lintn)
	     (if (not (= mus-lintn (mus-sound-sample-type file))) 
		 (snd-display #__line__ ";~A: set mus-sound-sample-type: ~A -> ~A" file cur-format (mus-sound-sample-type file)))
	     (set! (mus-sound-srate file) cur-srate)
	     (set! (mus-sound-samples file) cur-samps)
	     (set! (mus-sound-chans file) cur-chans)
	     (set! (mus-sound-data-location file) cur-loc)
	     (set! (mus-sound-header-type file) cur-type)
	     (set! (mus-sound-sample-type file) cur-format)))
	 (list "test.wave" "test.rf64" "test.aifc"))
	
	(for-each 
	 (lambda (file)
	   (let ((ind (open-sound file)))
	     (let ((cur-srate (srate ind))
		   (cur-chans (chans ind))
		   (cur-format (sample-type ind))
		   (cur-type (header-type ind))
		   (cur-loc (data-location ind))
		   (cur-samps (framples ind)))
	       (set! (srate ind) (* cur-srate 2))
	       (if (not (= (* cur-srate 2) (srate ind))) 
		   (snd-display #__line__ ";~A: set srate: ~A -> ~A" file cur-srate (srate ind)))
	       (set! (framples ind) (* cur-samps 2))
	       (if (not (= (* cur-samps 2) (framples ind))) 
		   (snd-display #__line__ ";~A: set framples: ~A -> ~A" file cur-samps (framples ind)))
	       (set! (chans ind) (* cur-chans 2)) ; this can change the index
	       (let ((xind (find-sound file)))
		 (if (not (equal? ind xind))
		     (set! ind xind)))
	       (if (not (= (* cur-chans 2) (chans ind))) 
		   (snd-display #__line__ ";~A: set chans: ~A -> ~A" file cur-chans (chans ind)))
	       (set! (data-location ind) (* cur-loc 2))
	       (if (not (= (* cur-loc 2) (data-location ind))) 
		   (snd-display #__line__ ";~A: set data-location: ~A -> ~A" file cur-loc (data-location ind)))
	       (set! (header-type ind) mus-nist)
	       (if (not (= mus-nist (header-type ind))) 
		   (snd-display #__line__ ";~A: set header-type: ~A -> ~A" file cur-type (header-type ind)))
	       (set! (sample-type ind) mus-lintn)
	       (if (not (= mus-lintn (sample-type ind))) 
		   (snd-display #__line__ ";~A: set sample-type: ~A -> ~A" file cur-format (sample-type ind)))
	       (set! (srate ind) cur-srate)
	       (set! (framples ind) cur-samps)
	       (set! (chans ind) cur-chans)
	       (set! (data-location ind) cur-loc)
	       (set! (header-type ind) cur-type)
	       (set! (sample-type ind) cur-format))
	     (close-sound ind))
	   (if (file-exists? file)
	       (delete-file file)))
	 (list "test.wave" "test.rf64" "test.aifc")))
      
      ;;	  (with-sound (big-file-name :srate 44100 :play #f)
      ;;	    (do ((i 0 (+ i 1))) ((= i 72000))
      ;;	      (fm-violin i .1 440 (+ .01 (* (/ i 72000.0) .9)))))
      
      (if with-big-file
	  (let ((probable-framples (floor (* (floor *clm-srate*) 71999.1)))) ; silence as last .9 secs, so it probably wasn't written
	    (if (not (= (mus-sound-samples big-file-name) 3175160310))
		(snd-display #__line__ ";bigger samples: ~A" (mus-sound-samples big-file-name)))
	    (if (not (= (mus-sound-framples big-file-name) 3175160310))
		(snd-display #__line__ ";bigger framples: ~A" (mus-sound-framples big-file-name)))
	    (if (not (= (mus-sound-framples big-file-name) probable-framples))
		(snd-display #__line__ ";bigger framples: ~A (probable: ~A)" (mus-sound-framples big-file-name) probable-framples))
	    (if (not (= (mus-sound-length big-file-name) 6350320648))
		(snd-display #__line__ ";bigger bytes: ~A" (mus-sound-length big-file-name)))
	    (if (fneq (mus-sound-duration big-file-name) 71999.1015)
		(snd-display #__line__ ";bigger dur: ~A" (mus-sound-duration big-file-name)))
	    (let ((ind (open-sound big-file-name)))
	      (if (not (= (framples ind) 3175160310)) (snd-display #__line__ ";bigger framples: ~A" (framples ind)))
	      (set! big-file-framples (framples ind))
	      (if (not (= (framples ind) probable-framples)) (snd-display #__line__ ";bigger framples: ~A (probable: ~A)" (framples ind) probable-framples))
	      (if (not (= (framples ind 0 0) big-file-framples)) (snd-display #__line__ ";bigger edpos-framples: ~A" (framples ind)))
	      (let ((m1 (add-mark (* (floor *clm-srate*) 50000) ind)))
		(if (not (= (mark-sample m1) (* (floor *clm-srate*) 50000))) (snd-display #__line__ ";bigger mark at: ~A" (mark-sample m1)))
		(set! (mark-sample m1) (* (floor *clm-srate*) 66000))
		(if (not (= (mark-sample m1) (* (floor *clm-srate*) 66000))) (snd-display #__line__ ";bigger mark to: ~A" (mark-sample m1))))
	      (let ((mx (mix-sound "oboe.snd" (* (floor *clm-srate*) 60000))))
		(if (mix? mx)
		    (begin
		      (if (not (= (mix-position mx) (* (floor *clm-srate*) 60000))) (snd-display #__line__ ";bigger mix at: ~A" (mix-position mx)))
		      (set! (mix-position mx) (* (floor *clm-srate*) 61000))
		      (if (not (= (mix-position mx) (* (floor *clm-srate*) 61000))) (snd-display #__line__ ";bigger mix to: ~A" (mix-position mx))))
		    (snd-display #__line__ ";no mix tag from mix-sound"))
		(undo 2))
	      (let ((res (scan-channel (lambda (y) (> (abs y) 0.0)))))
		(if (or (not res)
			(> (cadr res) 100))
		    (snd-display #__line__ ";bigger find not 0.0: ~A" res)))
	      (let ((old-select *selection-creates-region*))
		(set! *selection-creates-region* #f)
		(select-all ind)
		(if (not (= (selection-framples) (framples ind))) (snd-display #__line__ ";bigger select all: ~A ~A" (selection-framples) (framples)))
		(set! (selection-position) (* (floor *clm-srate*) 50000))
		(if (not (= (selection-position) (* (floor *clm-srate*) 50000))) (snd-display #__line__ ";bigger select pos: ~A" (selection-position)))
		(set! (selection-position) 0)
		(set! (selection-framples) (* (floor *clm-srate*) 65000))
		(if (not (= (selection-framples) (* (floor *clm-srate*) 65000))) (snd-display #__line__ ";bigger select len: ~A" (selection-framples)))
		(set! *selection-creates-region* old-select))
	      (set! (cursor ind) (* (floor *clm-srate*) 50000))
	      (if (not (= (cursor ind) (* (floor *clm-srate*) 50000))) (snd-display #__line__ ";bigger cursor: ~A" (cursor ind)))
	      (let ((m1 (add-mark (* 44123 51234) ind)))
		(if (not (= (mark-sample m1) (* 44123 51234))) (snd-display #__line__ ";bigger mark at: ~A" (mark-sample m1)))
		(let ((mid (find-mark (* 44123 51234))))
		  (if (or (not (number? mid)) (not (= mid m1))) (snd-display #__line__ ";bigger mark seach: ~A ~A" mid m1))))
	      (let ((mx (mix-sound "oboe.snd" (* 44123 61234))))
		(let ((mxd (find-mix (* 44123 61234))))
		  (if (or (not (number? mxd)) (not (= mxd mx))) (snd-display #__line__ ";bigger find-mix ~A ~A" mxd mx))))
	      (set! (cursor ind) (* 44123 51234))
	      (if (not (= (cursor ind) (* 44123 51234))) (snd-display #__line__ ";bigger cursor 123: ~A" (cursor ind)))
	      (close-sound ind))))
      
      (let ((ind (new-sound "tmp.snd" 1 22050 mus-l24int mus-riff :size 100000))
	    (old-selection-creates-region *selection-creates-region*))
	(set! *selection-creates-region* #t)
	(let ((incr (/ 1.0 (framples)))
	      (data (make-float-vector (framples))))
	  (outa->fv data (- (* i incr) 0.5))
	  (float-vector->channel data))
	(save-sound)
	(close-sound ind)
	(set! ind (open-sound "tmp.snd"))
	(let ((reg (select-all))
	      (v1 (make-float-vector 100000)))
	  (save-selection "tmp1.snd" 22050 mus-l24int mus-next)
	  (let ((ind1 (open-sound "tmp1.snd")))
	    (let ((incr (/ 1.0 (framples))))
	      (outa->fv v1 (- (* i incr) 0.5))
	      (let ((v0 (samples 0 100000 ind1 0)))
		(if (not (vequal v0 v1))
		    (snd-display #__line__ ";l24 (next) selection not saved correctly? ~A" v0))))
	    (close-sound ind1))
	  
	  (save-selection "tmp1.snd" 22050 mus-l24int mus-aifc)
	  (let ((ind1 (open-sound "tmp1.snd")))
	    (let ((v0 (samples 0 100000 ind1 0)))
	      (if (not (vequal v0 v1))
		  (snd-display #__line__ ";l24 (aifc) selection not saved correctly? ~A" v0)))
	    (close-sound ind1))
	  
	  (save-region reg "tmp1.snd" mus-l24int mus-next)
	  (let ((ind1 (open-sound "tmp1.snd")))
	    (let ((v0 (samples 0 100000 ind1 0)))
	      (if (not (vequal v0 v1))
		  (snd-display #__line__ ";l24 (next) region not saved correctly? ~A" v0)))
	    (close-sound ind1))
	  (delete-file "tmp1.snd")
	  (close-sound ind)
	  (delete-file "tmp.snd"))
	(set! *selection-creates-region* old-selection-creates-region))
      
      (let ((ind (new-sound "tmp.snd" 1 22050 mus-ldouble mus-next :size 10 :comment #f)))
	(map-channel (lambda (y) 1.0))
	(env-channel '(0 0 .1 .1 .2 .2 .3 .3 .4 .4 .5 .5 .6 .6 .7 .7 .8 .8 .9  .9))
	(if (not (vequal (channel->float-vector) (float-vector 0.000 0.100 0.200 0.300 0.400 0.500 0.600 0.700 0.800 0.900)))
	    (snd-display #__line__ ";ramp env by .1: ~A" (channel->float-vector)))
	(close-sound ind))
      )
  
    (set! (hook-functions open-raw-sound-hook) ())
    (hook-push open-raw-sound-hook (lambda (hook) (set! (hook 'result) #t)))
    (set! (hook-functions bad-header-hook) ())
    (hook-push bad-header-hook (lambda (hook) (set! (hook 'result) #t)))
    (if (null? (hook-functions open-raw-sound-hook)) (snd-display #__line__ ";add hook open-raw-sound-hook failed??"))
    (if (null? (hook-functions bad-header-hook)) (snd-display #__line__ ";add hook bad-header-hook failed??"))
    (let* ((magic-words (list ".snd" "FORM" "AIFF" "AIFC" "COMM" "COMT" "INFO" "INST" "inst" "MARK" "SSND"
			      "FVER" "NONE" "ULAW" "ulaw" "ima4" "raw " "sowt" "in32" "in24" "ni23" "fl32"
			      "FL32" "fl64" "twos" "ALAW" "alaw" "APPL" "CLM " "RIFF" "RIFX" "WAVE" "fmt "
			      "data" "fact" "clm " "NIST" "8SVX" "16SV" "Crea" "tive" "SOUN" "D SA" "MPLE"
			      "BODY" "VHDR" "CHAN" "ANNO" "NAME" "2BIT" "HCOM" "FSSD" "%//\n" "%---" "ALaw"
			      "Soun" "MAUD" "MHDR" "MDAT" "mdat" "MThd" "sfbk" "sdta" "shdr" "pdta"
			      "LIST" "GF1P" "ATCH" "$SIG" "NAL_" "GOLD" " SAM" "SRFS" "Diam" "ondW" "CSRE"
			      "SND " "SNIN" "SNDT" "DDSF" "FSMu" "UWFD" "LM89" "SY80" "SY85" "SCRS" "DSPL"
			      "AVI " "strf" "movi" "PRAM" " paf" "fap " "DS16" "HEDR" "HDR8" "SDA_" "SDAB"
			      "SD_B" "NOTE" "file" "=sam" "SU7M" "SU7R" "PVF1" "PVF2" "AUTH" "riff" "TWIN"
			      "IMPS" "SMP1" "Maui" "SDIF"))
	   (len (length magic-words))
	   (ctr 0))
      (for-each
       (lambda (magic)
	 (if (null? (hook-functions open-raw-sound-hook)) (snd-display #__line__ ";open-raw-sound-hook cleared??"))
	 (if (null? (hook-functions bad-header-hook)) (snd-display #__line__ ";bad-header-hook cleared??"))
	 (if (file-exists? "test.snd")
	     (delete-file "test.snd"))
	 (mus-sound-forget "test.snd")
	 ;; try random garbage
	 (with-output-to-file "test.snd"
	   (lambda ()
	     (display magic)
	     (do ((i 0 (+ i 1)))
		 ((= i 128))
	       (write (random 1.0)))))
	 (let ((tag (catch #t
			   (lambda ()
			     (open-sound "test.snd"))
			   (lambda args (car args)))))
	   (if (and (number? tag)
		    (sound? tag))
	       (begin
		 (snd-display #__line__ ";open-sound garbage ~A: ~A -> ~A?" magic tag (file->string "test.snd"))
		 (if (sound? tag) (close-sound tag)))))
	 (delete-file "test.snd")
	 (mus-sound-forget "test.snd")
	 ;; try plausible garbage
	 (with-output-to-file "test.snd"
	   (lambda ()
	     (display magic)
	     (do ((i 0 (+ i 1)))
		 ((= i 128))
	       (write (random 128)))))
	 (let ((tag (catch #t
			   (lambda ()
			     (open-sound "test.snd"))
			   (lambda args (car args)))))
	   (if (and (number? tag)
		    (sound? tag))
	       (begin
		 (snd-display #__line__ ";open-sound plausible garbage ~A: ~A?" magic tag)
		 (if (sound? tag) (close-sound tag)))))
	 (delete-file "test.snd")
	 (mus-sound-forget "test.snd")
	 ;; write very plausible garbage
	 (with-output-to-file "test.snd"
	   (lambda ()
	     (display magic)
	     (do ((i 1 (+ i 1)))
		 ((= i 12))
	       (if (< (+ ctr i) len)
		   (display (magic-words (+ ctr i)))
		   (display (magic-words i))))))
	 (let ((tag (catch #t
			   (lambda ()
			     (open-sound "test.snd"))
			   (lambda args (car args)))))
	   (if (and (number? tag)
		    (sound? tag))
	       (begin
		 (snd-display #__line__ ";open-sound very plausible garbage ~A: ~A?" magic tag)
		 (if (sound? tag) (close-sound tag)))))
	 (set! ctr (+ ctr 1)))
       magic-words))
    (if (file-exists? "test.snd") (delete-file "test.snd"))
    (mus-sound-forget "test.snd")
    

    (with-output-to-file "test.snd"
      (lambda ()
	(display ".snd")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o034) ; location
	(write-byte #o000) (write-byte #o001) (write-byte #o215) (write-byte #o030) ; nominal size
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o022) ; format
	(write-byte #o000) (write-byte #o000) (write-byte #o126) (write-byte #o042) ; srate
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o001) ; chans
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; comment
	(write-byte #o000) (write-byte #o001) ; samp 1
	))
    (if (not (= (mus-sound-sample-type "test.snd") mus-bshort))
	(snd-display #__line__ ";next 18: ~A" (mus-sound-sample-type "test.snd")))
    (delete-file "test.snd")
    (mus-sound-forget "test.snd")
    (with-output-to-file "test.snd"
      (lambda ()
	(display ".snd")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; location
	(write-byte #o000) (write-byte #o001) (write-byte #o215) (write-byte #o030) ; nominal size
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o022) ; format
	(write-byte #o000) (write-byte #o000) (write-byte #o126) (write-byte #o042) ; srate
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o001) ; chans
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; comment
	(write-byte #o000) (write-byte #o001) ; samp 1
	))
    (let ((tag (catch #t
		      (lambda ()
			(open-sound "test.snd"))
		      (lambda args (car args)))))
      (if (and (number? tag)
	       (sound? tag))
	  (begin
	    (snd-display #__line__ ";open-sound next bad location ~A: ~A?" (data-location tag) tag)
	    (close-sound tag))))
    (delete-file "test.snd")
    (mus-sound-forget "test.snd")

    (letrec ((make-aifc-file 
	      (lambda (len auth-lo bits)
		(with-output-to-file "test.aif"
		  (lambda ()
		    (display "FORM")
		    (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o146) ; len
		    (display "AIFCFVER")
		    (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; version chunk size
		    (write-byte #o242) (write-byte #o200) (write-byte #o121) (write-byte #o100) ; version  
		    (display "COMM")
		    (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o046) ; COMM chunk size
		    (write-byte #o000) (write-byte #o001) ; 1 chan
		    (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte len) ; framples
		    (write-byte #o000) (write-byte bits) ; bits
		    (write-byte #o100) (write-byte #o016) (write-byte #o254) (write-byte #o104) (write-byte #o000) 
		    (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ;
		    ;; srate as 80-bit float (sheesh)
		    (display "NONE") ; compression
		    (write-byte #o016) ; pascal string len
		    (display "not compressed")
		    (write-byte #o000)
		    (display "AUTH")
		    (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte auth-lo) ; AUTH chunk size
		    (display "bil")
		    (write-byte #o000)
		    (display "SSND")
		    (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) ; SSND chunk size
		    (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; SSND data loc
		    (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; block size?
		    (write-byte #o000) (write-byte #o101) (write-byte #o000) (write-byte #o100) ; two samples
		    )))))
      (if (file-exists? "test.aif") (delete-file "test.aif"))
      (mus-sound-forget "test.aif")
      ;;correct (make-aifc-file #o002 #o004 #o020)
      (make-aifc-file #o102 #o004 #o020)

      (catch #t
	     (lambda ()
	       (let ((ind (open-sound "test.aif")))
		 (if (not (= (framples ind) 2)) (snd-display #__line__ ";bad framples in header: ~A" (framples ind)))
		 (close-sound ind)))
	     (lambda args (snd-display #__line__ ";~S" args)))
      (delete-file "test.aif")
      (mus-sound-forget "test.aif")
      (make-aifc-file #o002 #o150 #o020)
      (let ((tag (catch #t
			(lambda ()
			  (open-sound "test.aif"))
			(lambda args (car args)))))
	(if (and (number? tag)
		 (sound? tag))
	    (begin
	      (snd-display #__line__ ";open-sound aifc no ssnd chunk ~A: ~A?" (data-location tag) tag)
	      (close-sound tag))))
      (delete-file "test.aif")
      (mus-sound-forget "test.aif")
      (make-aifc-file #o002 #o000 #o020)

      (let ((tag (catch #t
			(lambda ()
			  (open-sound "test.aif"))
			(lambda args (car args)))))
	(if (and (number? tag)
		 (sound? tag))
	    (begin
	      (snd-display #__line__ ";open-sound aifc 0-len auth chunk ~A: ~A?" (data-location tag) tag)
	      (close-sound tag))))
      (delete-file "test.aif")
      (mus-sound-forget "test.aif")
      (make-aifc-file #o002 #o150 #o120)
      (let ((tag (catch #t
			(lambda ()
			  (open-sound "test.aif"))
			(lambda args (car args)))))
	(if (and (number? tag)
		 (sound? tag))
	    (begin
	      (snd-display #__line__ ";open-sound bits 80 ~A: ~A?" (sample-type tag) tag)
	      (close-sound tag))))
      (delete-file "test.aif")
      (mus-sound-forget "test.aif"))

    (with-output-to-file "test.aif"
      (lambda ()
	(display "FORM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o176) ; len
	(display "AIFCFVER")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; version chunk size
	(write-byte #o242) (write-byte #o200) (write-byte #o121) (write-byte #o100) ; version  
	(display "COMM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o046) ; COMM chunk size
	(write-byte #o000) (write-byte #o001) ; 1 chan
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o002) ; framples
	(write-byte #o000) (write-byte #o020) ; bits
	(write-byte #o100) (write-byte #o016) (write-byte #o254) (write-byte #o104) (write-byte #o000) 
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; srate as 80-bit float (sheesh)
	(display "NONE") ; compression
	(write-byte #o016) ; pascal string len
	(display "not compressed")
	(write-byte #o000)
	(display "AUTH")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; AUTH chunk size
	(display "bil")
	(write-byte #o000)
	(display "ANNO")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; AUTH chunk size
	(display "cat")
	(write-byte #o000)
	(display "NAME")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; AUTH chunk size
	(display "dog")
	(write-byte #o000)
	(display "SSND")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) ; SSND chunk size
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; SSND data loc
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; block size?
	(write-byte #o000) (write-byte #o101) (write-byte #o000) (write-byte #o100) ; two samples
	))
    (catch #t
	   (lambda ()
	     (if (not (= (length (mus-sound-comment "test.aif")) 15))
		 (snd-display #__line__ ";aifc 3 aux comments: ~A?" (mus-sound-comment "test.aif"))))
	   (lambda args (snd-display #__line__ ";~S" args)))
    (delete-file "test.aif")
    (mus-sound-forget "test.aif")
    (with-output-to-file "test.aif"
      (lambda ()
	(display "FORM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o142) ; len
	(display "AIFC")
	(display "SSND")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) ; SSND chunk size
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; SSND data loc
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; block size?
	(write-byte #o000) (write-byte #o101) (write-byte #o000) (write-byte #o100) ; two samples
	(display "COMM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o046) ; COMM chunk size
	(write-byte #o000) (write-byte #o001) ; 1 chan
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o002) ; framples
	(write-byte #o000) (write-byte #o020) ; bits
	(write-byte #o100) (write-byte #o016) (write-byte #o254) (write-byte #o104) (write-byte #o000) 
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; srate as 80-bit float (sheesh)
	(display "NONE") ; compression
	(write-byte #o016) ; pascal string len
	(display "not compressed")
	(write-byte #o000)
	(display "COMT")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) 
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) 
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) 
	(display "bil")
	(write-byte #o000)
	))

    (catch #t
	   (lambda ()
	     (if (not (string=? (substring (mus-sound-comment "test.aif") 0 3) "bil"))
		 (snd-display #__line__ ";aifc trailing comt comment: ~A?" (mus-sound-comment "test.aif"))))
	   (lambda args (snd-display #__line__ ";~S" args)))
    (if (not (= (mus-sound-framples "test.aif") 2))
	(snd-display #__line__ ";aifc trailing comt framples: ~A?" (mus-sound-framples "test.aif")))
    (catch #t
	   (lambda ()
	     (let ((ind (open-sound "test.aif")))
	       (if (or (fneq (sample 0) 0.00198)
		       (fneq (sample 1) 0.00195)
		       (fneq (sample 2) 0.0)
		       (fneq (sample 3) 0.0))
		   (snd-display #__line__ ";aifc trailing comt samps: ~A ~A ~A ~A" (sample 0) (sample 1) (sample 2) (sample 3)))
	       (close-sound ind)))
	   (lambda args (snd-display #__line__ ";~S" args)))
    (delete-file "test.aif")
    (mus-sound-forget "test.aif")
    (with-output-to-file "test.aif"
      (lambda ()
	(display "FORM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o142) ; len
	(display "AIFC")
	(display "SSND")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) ; SSND chunk size
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; SSND data loc
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; block size?
	(write-byte #o000) (write-byte #o101) (write-byte #o000) (write-byte #o100) ; two samples
	(display "COMM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o046) ; COMM chunk size
	(write-byte #o000) (write-byte #o001) ; 1 chan
	(write-byte #o000) (write-byte #o000) (write-byte #o100) (write-byte #o102) ; framples
	(write-byte #o000) (write-byte #o020) ; bits
	(write-byte #o100) (write-byte #o016) (write-byte #o254) (write-byte #o104) (write-byte #o000) 
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; srate as 80-bit float (sheesh)
	(display "NONE") ; compression
	(write-byte #o016) ; pascal string len
	(display "not compressed")
	(write-byte #o000)
	(display "COMT")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) 
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) 
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) 
	(display "bil")
	(write-byte #o000)
	))
    (if (or (not (string? (mus-sound-comment "test.aif")))
	    (not (string=? (substring (mus-sound-comment "test.aif") 0 3) "bil")))
	(snd-display #__line__ ";aifc trailing comt comment: ~A?" (mus-sound-comment "test.aif")))
    (if (not (= (mus-sound-framples "test.aif") 2))
	(snd-display #__line__ ";aifc trailing comt (bogus) framples: ~A?" (mus-sound-framples "test.aif")))
    (catch #t
	   (lambda ()
	     (let ((ind (open-sound "test.aif")))
	       (if (or (fneq (sample 0) 0.00198)
		       (fneq (sample 1) 0.00195)
		       (fneq (sample 2) 0.0)
		       (fneq (sample 3) 0.0))
		   (snd-display #__line__ ";aifc trailing comt samps (bogus frame setting): ~A ~A ~A ~A" (sample 0) (sample 1) (sample 2) (sample 3)))
	       (close-sound ind)))
	   (lambda args (snd-display #__line__ ";~S" args)))
    (delete-file "test.aif")
    (mus-sound-forget "test.aif")
    (with-output-to-file "test.aif"
      (lambda ()
	(display "FORM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o142) ; len
	(display "AIFC")
	(display "SSND")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) ; SSND chunk size
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; SSND data loc
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; block size?
	(write-byte #o000) (write-byte #o101) (write-byte #o000) (write-byte #o100) ; two samples
	(display "COMM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o046) ; COMM chunk size
	(write-byte #o000) (write-byte #o001) ; 1 chan
	(write-byte #o000) (write-byte #o000) (write-byte #o100) (write-byte #o102) ; framples
	(write-byte #o000) (write-byte #o020) ; bits
	(write-byte #o100) (write-byte #o016) (write-byte #o254) (write-byte #o104) (write-byte #o000) 
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; srate as 80-bit float (sheesh)
	(display "NONE") ; compression
	(write-byte #o016) ; pascal string len
	(display "not compressed")
	(write-byte #o000)
	(display "SSND")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) ; SSND chunk size
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; SSND data loc
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; block size?
	(write-byte #o000) (write-byte #o101) (write-byte #o000) (write-byte #o100) ; two samples
	))

    (let ((tag (catch #t
		      (lambda ()
			(open-sound "test.aif"))
		      (lambda args (car args)))))
      (if (and (number? tag)
	       (sound? tag))
	  (begin
	    (snd-display #__line__ ";open-sound aifc 2 ssnd chunks ~A: ~A?" (data-location tag) tag)
	    (close-sound tag))))
    (delete-file "test.aif")
    (mus-sound-forget "test.aif")
    
    (with-output-to-file "test.aif"
      (lambda ()
	(display "FORM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o040) ; len
	(display "AIFC")
	(display "SSND")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) ; SSND chunk size
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; SSND data loc
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; block size?
	(write-byte #o000) (write-byte #o101) (write-byte #o000) (write-byte #o100) ; two samples
	))
    (let ((tag (catch #t
		      (lambda ()
			(open-sound "test.aif"))
		      (lambda args (car args)))))
      (if (not (eq? tag 'mus-error))
	  (begin
	    (snd-display #__line__ ";open-sound aifc no comm chunk ~A?" tag)
	    (if (and (number? tag)
		     (sound? tag))
		(close-sound tag)))))
    (delete-file "test.aif")
    (mus-sound-forget "test.aif")
    
    (with-output-to-file "test.aif"
      (lambda ()
					;write AIFC with trailing chunks to try to confuse file->sample
	(display "FORM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o176) ; len
	(display "AIFCFVER")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; version chunk size
	(write-byte #o242) (write-byte #o200) (write-byte #o121) (write-byte #o100) ; version  
	(display "COMM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o046) ; COMM chunk size
	(write-byte #o000) (write-byte #o001) ; 1 chan
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o002) ; framples
	(write-byte #o000) (write-byte #o020) ; bits
	(write-byte #o100) (write-byte #o016) (write-byte #o254) (write-byte #o104) (write-byte #o000) 
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; srate as 80-bit float (sheesh)
	(display "NONE") ; compression
	(write-byte #o016) ; pascal string len
	(display "not compressed")
	(write-byte #o000)
	(display "SSND")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) ; SSND chunk size
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; SSND data loc
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; block size?
	(write-byte #o170) (write-byte #o101) (write-byte #o100) (write-byte #o100) ; two samples
	(display "AUTH")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; AUTH chunk size
	(display "bil")
	(write-byte #o000)
	(display "ANNO")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; AUTH chunk size
	(display "cat")
	(write-byte #o000)
	(display "NAME")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; AUTH chunk size
	(display "dog")
	(write-byte #o000)
	))
    (catch #t
	   (lambda ()
	     (let ((gen (make-file->sample "test.aif")))
	       (if (fneq (gen 0) 0.93948) (snd-display #__line__ ";file->sample chunked 0: ~A" (gen 0)))
	       (if (fneq (gen 1) 0.50195) (snd-display #__line__ ";file->sample chunked 1: ~A" (gen 1)))
	       (if (fneq (gen 2) 0.0) (snd-display #__line__ ";file->sample chunked eof: ~A" (gen 2)))
	       (if (fneq (gen 3) 0.0) (snd-display #__line__ ";file->sample chunked eof+1: ~A" (gen 3))))
	     (let ((file (open-sound "test.aif")))
	       (if (not (= (framples file) 2)) (snd-display #__line__ ";chunked framples: ~A" (framples file)))
	       (if (fneq (sample 0) 0.93948) (snd-display #__line__ ";file chunked 0: ~A" (sample 0)))
	       (if (fneq (sample 1) 0.50195) (snd-display #__line__ ";file chunked 1: ~A" (sample 1)))
	       (if (fneq (sample 2) 0.0) (snd-display #__line__ ";file chunked eof: ~A" (sample 2)))
	       (if (fneq (sample 3) 0.0) (snd-display #__line__ ";file chunked eof+1: ~A" (sample 3)))
	       (close-sound file)))
	   (lambda args (snd-display #__line__ ";~S" args)))
    (catch #t
	   (lambda ()
	     (if (not (= (mus-sound-framples "test.aif") 2)) (snd-display #__line__ ";chunked mus-sound-framples: ~A" (mus-sound-framples "test.aif"))))
	   (lambda args (snd-display #__line__ ";~S" args)))
    (delete-file "test.aif")
    (mus-sound-forget "test.aif")

    (with-output-to-file "test.aif"
      (lambda ()
					;write AIFC with trailing chunks to try to confuse file->sample
	(display "FORM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o176) ; len
	(display "AIFCFVER")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; version chunk size
	(write-byte #o242) (write-byte #o200) (write-byte #o121) (write-byte #o100) ; version  
	(display "SSND")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) ; SSND chunk size
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; SSND data loc
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; block size?
	(write-byte #o170) (write-byte #o101) (write-byte #o100) (write-byte #o100) ; two samples
	(display "COMM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o046) ; COMM chunk size
	(write-byte #o000) (write-byte #o001) ; 1 chan
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o002) ; framples
	(write-byte #o000) (write-byte #o020) ; bits
	(write-byte #o100) (write-byte #o016) (write-byte #o254) (write-byte #o104) (write-byte #o000) 
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; srate as 80-bit float (sheesh)
	(display "NONE") ; compression
	(write-byte #o016) ; pascal string len
	(display "not compressed")
	(write-byte #o000)
	(display "APPL")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte (char->integer #\h))
	(display "CLM ;Written Mon 02-Nov-98 01:44 CST by root at ockeghem (Linux/X86) using Allegro CL, clm of 20-Oct-98")
	(write-byte #o000)
	))
    (catch #t
	   (lambda ()
	     (let ((gen (make-file->sample "test.aif")))
	       (if (fneq (gen 0) 0.93948) (snd-display #__line__ ";file->sample chunked 0: ~A" (gen 0)))
	       (if (fneq (gen 1) 0.50195) (snd-display #__line__ ";file->sample chunked 1: ~A" (gen 1)))
	       (if (fneq (gen 2) 0.0) (snd-display #__line__ ";file->sample chunked eof: ~A" (gen 2)))
	       (if (fneq (gen 3) 0.0) (snd-display #__line__ ";file->sample chunked eof+1: ~A" (gen 3))))
	     (let ((file (open-sound "test.aif")))
	       (if (not (= (framples file) 2)) (snd-display #__line__ ";chunked framples: ~A" (framples file)))
	       (if (fneq (sample 0) 0.93948) (snd-display #__line__ ";file chunked 0: ~A" (sample 0)))
	       (if (fneq (sample 1) 0.50195) (snd-display #__line__ ";file chunked 1: ~A" (sample 1)))
	       (if (fneq (sample 2) 0.0) (snd-display #__line__ ";file chunked eof: ~A" (sample 2)))
	       (if (fneq (sample 3) 0.0) (snd-display #__line__ ";file chunked eof+1: ~A" (sample 3)))
	       (if (or (not (string? (comment)))
		       (not (string=? (comment) ";Written Mon 02-Nov-98 01:44 CST by root at ockeghem (Linux/X86) using Allegro CL, clm of 20-Oct-98")))
		   (snd-display #__line__ ";chunked appl comment: ~A" (comment)))
	       (close-sound file)))
	   (lambda args (snd-display #__line__ ";~S" args)))
    (delete-file "test.aif")
    (mus-sound-forget "test.aif")
    
    (with-output-to-file "test.aif"
      (lambda ()
					;write AIFC with trailing chunks to try to confuse file->sample
	(display "FORM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o176) ; len
	(display "AIFCFVER")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; version chunk size
	(write-byte #o242) (write-byte #o200) (write-byte #o121) (write-byte #o100) ; version  
	(display "SSND")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) ; SSND chunk size
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; SSND data loc
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; block size?
	(write-byte #o170) (write-byte #o101) (write-byte #o100) (write-byte #o100) ; two samples (one frame)
	(display "COMM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o046) ; COMM chunk size
	(write-byte #o000) (write-byte #o002) ; 2 chans
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o001) ; framples
	(write-byte #o000) (write-byte #o020) ; bits
	(write-byte #o100) (write-byte #o016) (write-byte #o254) (write-byte #o104) (write-byte #o000) 
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; srate as 80-bit float (sheesh)
	(display "NONE") ; compression
	(write-byte #o016) ; pascal string len
	(display "not compressed")
	(write-byte #o000)
	(display "APPL")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte (char->integer #\h))
	(display "CLM ;Written Mon 02-Nov-98 01:44 CST by root at ockeghem (Linux/X86) using Allegro CL, clm of 20-Oct-98")
	(write-byte #o000)
	))
    (catch #t
	   (lambda ()
	     (let ((gen (make-file->sample "test.aif")))
	       (if (fneq (gen 0 0) 0.93948) (snd-display #__line__ ";file->sample chunked 0 0: ~A" (gen 0 0)))
	       (if (fneq (gen 0 1) 0.50195) (snd-display #__line__ ";file->sample chunked 0 1: ~A" (gen 0 1)))
	       (if (fneq (gen 1 0) 0.0) (snd-display #__line__ ";file->sample chunked eof(stereo): ~A" (gen 1 0)))
	       (if (fneq (gen 1 1) 0.0) (snd-display #__line__ ";file->sample chunked eof+1 (stereo): ~A" (gen 1 1))))
	     (let ((file (open-sound "test.aif")))
	       (if (not (= (framples file) 1)) (snd-display #__line__ ";chunked framples (1): ~A" (framples file)))
	       (if (fneq (sample 0 file 0) 0.93948) (snd-display #__line__ ";file chunked 0 0: ~A" (sample 0 file 0)))
	       (if (fneq (sample 0 file 1) 0.50195) (snd-display #__line__ ";file chunked 0 1: ~A" (sample 0 file 1)))
	       (if (fneq (sample 1 file 0) 0.0) (snd-display #__line__ ";file chunked eof (stereo): ~A" (sample 1 file 0)))
	       (if (fneq (sample 1 file 1) 0.0) (snd-display #__line__ ";file chunked eof+1 (stereo): ~A" (sample 1 file 1)))
	       (if (or (not (string? (comment)))
		       (not (string=? (comment) ";Written Mon 02-Nov-98 01:44 CST by root at ockeghem (Linux/X86) using Allegro CL, clm of 20-Oct-98")))
		   (snd-display #__line__ ";chunked appl comment (stereo): ~A" (comment)))
	       (close-sound file)))
	   (lambda args (snd-display #__line__ ";~S" args)))
    (delete-file "test.aif")
    (mus-sound-forget "test.aif")

    (let ((files (sound-files-in-directory cwd)))
      (define (difference a b)
	(let ((diffs ()))
	  (for-each
	   (lambda (f)
	     (if (not (member f b)) (set! diffs (cons f diffs))))
	   a)
	  (for-each
	   (lambda (f)
	     (if (not (member f a)) (set! diffs (cons f diffs))))
	   b)
	  diffs))
      (if (null? files) (snd-display #__line__ ";no sound files in ~A?" cwd))
      (let ((files1 (sound-files-in-directory)))
	(if (not (equal? files files1)) (snd-display #__line__ ";different sound files in ~A and default?~%    ~A~%    ~A~%" cwd files files1))
	(let ((files2 (sound-files-in-directory ".")))
	  (if (or (not (equal? files1 files2))
		  (not (equal? files files2)))
	      (snd-display #__line__ ";sound-files-in-directory dot: ~A~%    ~A~% but ~A" (difference files2 files) files2 files)))))
    
    (set! (hook-functions bad-header-hook) ())
    (set! (hook-functions open-raw-sound-hook) ())
    (if (pair? (sounds)) (for-each close-sound (sounds)))
    
    (let ((ind (new-sound :size 0)))
      (if (not (= (framples ind) 0)) (snd-display #__line__ ";new-sound :size 0 -> ~A framples" (framples ind)))
      (if (fneq (sample 0) 0.0) (snd-display #__line__ ";new-sound :size 0 sample 0: ~A" (sample 0)))
      (let ((new-file-name (file-name ind)))
	(close-sound ind)
	(if (file-exists? new-file-name) (delete-file new-file-name))))
    (let ((ind (new-sound :size 1)))
      (if (not (= (framples ind) 1)) (snd-display #__line__ ";new-sound :size 1 -> ~A framples" (framples ind)))
      (if (fneq (sample 0) 0.0) (snd-display #__line__ ";new-sound :size 1 sample 0: ~A" (sample 0)))
      (let ((new-file-name (file-name ind)))
	(close-sound ind)
	(if (file-exists? new-file-name) (delete-file new-file-name))))
    (let ((tag (catch #t
		      (lambda () (new-sound :size -1))
		      (lambda args (car args)))))
      (if (not (eq? tag 'out-of-range))
	  (begin
	    (snd-display #__line__ ";new-sound :size -1: ~A" tag)
	    (if (pair? (sounds)) (for-each close-sound (sounds))))))
    
    (let ((ind (read-ascii (string-append sf-dir "caruso.asc"))))
      (if (not (sound? ind)) 
	  (snd-display #__line__ ";read-ascii can't find ~A (~A)" (string-append sf-dir "caruso.asc") (map file-name (sounds)))
	  (begin
	    (if (fneq (maxamp ind 0) 0.723) (snd-display #__line__ ";read-ascii maxamp: ~A" (maxamp ind 0)))
	    (if (not (= (framples ind 0) 50000)) (snd-display #__line__ ";read-ascii framples: ~A" (framples ind 0)))
	    (if (not (= (srate ind) 44100)) (snd-display #__line__ ";read-ascii srate: ~A" (srate ind)))
	    (set! (srate ind) 8000)
	    (if (or (not (= (framples ind 0) 50000))
		    (fneq (maxamp ind 0) .723))
		(snd-display #__line__ ";set srate clobbered new sound: ~A ~A (~A)" (framples ind 0) (maxamp ind 0) (srate ind)))
	    
	    (close-sound ind))))
    
    (let ((ind (open-sound "oboe.snd")))
      (save-sound-as "test space.snd")
      (close-sound ind)
      (set! ind (open-sound "test space.snd"))
      (if (not (string=? (short-file-name ind) "test space.snd"))
	  (snd-display #__line__ ";file name with space: ~A" (short-file-name ind)))
      (let ((len (framples ind))
	    (slen (mus-sound-framples "test space.snd")))
	(if (not (= len slen)) (snd-display #__line__ ";spaced filename framples: ~A ~A" len slen)))
      (add-mark 1234 ind 0)
      (save-marks ind) ; should write "test space.marks"
      (close-sound ind)
      (set! ind (open-sound "test space.snd"))
      (load (string-append cwd "test space.marks"))
      (if (not (find-mark 1234 ind))
	  (snd-display #__line__ ";space file name save marks: ~A" (marks ind)))
      (let ((rd (make-readin :file "test space.snd")))
	(if (not (string=? (mus-file-name rd) "test space.snd"))
	    (snd-display #__line__ ";file name with space readin: ~A" (mus-file-name rd))))
      (close-sound ind)
      (if (file-exists? "test space.snd")
	  (delete-file "test space.snd"))
      (if (file-exists? "test space.marks")
	  (delete-file "test space.marks")))
    
    (if (directory? "oboe.snd") (snd-display #__line__ ";directory? oboe.snd!"))
    (if (not (directory? ".")) (snd-display #__line__ ";directory? . #f!"))
    (if (not (getenv "PATH")) (snd-display #__line__ ";getenv: no PATH?"))
    (if (not (number? (getpid))) (snd-display #__line__ ";getpid: ~A" (getpid)))
    
    (unless (provided? 'pure-s7)
      (let ((ip (current-input-port)))
	(let ((tag (catch #t (lambda () (set-current-input-port "hiho!")) (lambda args (car args)))))
	  (if (not (eq? tag 'wrong-type-arg)) (snd-display #__line__ ";set-current-input-port tag: ~A" tag))
	  (if (not (equal? ip (current-input-port))) (snd-display #__line__ ";set-current-input-port clobbered port? ~A ~A" ip (current-input-port)))))
    
      (let ((ip (current-output-port)))
	(let ((tag (catch #t (lambda () (set-current-output-port "hiho!")) (lambda args (car args)))))
	  (if (not (eq? tag 'wrong-type-arg)) (snd-display #__line__ ";set-current-output-port tag: ~A" tag))
	  (if (not (equal? ip (current-output-port))) (snd-display #__line__ ";set-current-output-port clobbered port? ~A ~A" ip (current-output-port)))))
    
      (let ((ip (current-error-port)))
	(let ((tag (catch #t (lambda () (set-current-error-port "hiho!")) (lambda args (car args)))))
	  (if (not (eq? tag 'wrong-type-arg)) (snd-display #__line__ ";set-current-error-port tag: ~A" tag))
	  (if (not (equal? ip (current-error-port))) (snd-display #__line__ ";set-current-error-port clobbered port? ~A ~A" ip (current-error-port))))))
    
    (if (not (provided? 'gmp))
	(let* ((LONG_MAX 2147483647)
	       (LONG_MIN -2147483648)
	       (LLONG_MAX most-positive-fixnum)
	       (LLONG_MIN most-negative-fixnum)
	       (ints (list 0 1 -1 10 -10 1234 -1234 LONG_MAX LONG_MIN 65536 -65536))
	       (shorts (list 0 1 -1 10 -10 1234 -1234 32767 -32768 8191 -8191))
	       (longs (list 0 1 -1 11 -11 LONG_MAX LONG_MIN LLONG_MAX LLONG_MIN 1000 -1000))
	       (floats (list 0.0 1.0 -1.0 0.1 -0.1 10.0 -10.0 1234.0 65536.0 -1234.0 -0.003))
	       (doubles (list 0.0 1.0 -1.0 0.1 -0.1 10.0 -10.0 1234.0 65536.0 -1234.0 -0.003)))
	  (load "binary-io.scm")
	  
	  (with-output-to-file "idf1.data"
	    (lambda ()
	      
	      (write-lint32 123)
	      (write-bint32 321)
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(write-lint32 (ints i))
		(write-bint32 (ints i)))
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(write-lint16 (shorts i))
		(write-bint16 (shorts i)))
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(write-lint64 (longs i))
		(write-bint64 (longs i)))
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(write-lfloat32 (floats i))
		(write-bfloat32 (floats i)))
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(write-lfloat64 (doubles i))
		(write-bfloat64 (doubles i)))
	      ))
	  
	  (with-input-from-file "idf1.data" 
	    (lambda ()
	      
	      (define (testf val1 val2 name)
		(if (not (= val1 val2))
		    (if (and (not (eq? name 'lfloat32))
			     (not (eq? name 'bfloat32)))
			(snd-display #__line__ ";testf ~A: ~A != ~A~%" name val1 val2)
			(if (> (abs (- val1 val2)) 1.0e-6)
			    (snd-display #__line__ ";testf ~A: ~A != ~A (~A)~%" name val1 val2 (abs (- val1 val2)))))))
	      
	      (testf (read-lint32) 123 'lint32)
	      (testf (read-bint32) 321 'bint32)
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(testf (read-lint32) (ints i) 'lint32)
		(testf (read-bint32) (ints i) 'bint32))
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(testf (read-lint16) (shorts i) 'lint16)
		(testf (read-bint16) (shorts i) 'bint16))
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(testf (read-lint64) (longs i) 'lint64)
		(testf (read-bint64) (longs i) 'bint64))
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(testf (read-lfloat32) (floats i) 'lfloat32)
		(testf (read-bfloat32) (floats i) 'bfloat32))
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(testf (read-lfloat64) (doubles i) 'lfloat64)
		(testf (read-bfloat64) (doubles i) 'bfloat64))
	      ))
	  ))
    ))



;;; ---------------- test 5: simple overall checks ----------------

(require snd-selection.scm snd-extensions.scm snd-selection.scm snd-dsp.scm snd-pvoc.scm)
(if with-gui (require snd-edit-menu.scm))

(define (snd_test_5)
  (define a-ctr 0)
  (define g-init-val 0)
  
  (define (append-sound filename)
    (insert-sound filename (framples)))
  
  (define (test-edpos test-func func-name change-thunk ind1)
    (let ((fr1 (test-func ind1 0))
	  (fr2 (test-func ind1 0 0))
	  (fr3 (test-func ind1 0 current-edit-position)))
      (if (not (= fr1 fr2 fr3))
	  (snd-display #__line__ ";initial ~A: ~A ~A ~A?" func-name fr1 fr2 fr3))
      (change-thunk)
      (let ((fr5 (test-func ind1 0))
	    (fr6 (test-func ind1 0 1))
	    (fr7 (test-func ind1 0 current-edit-position)))
	(if (not (= fr5 fr6 fr7))
	    (snd-display #__line__ ";~A (edpos 1): ~A ~A ~A?" func-name fr5 fr6 fr7))))
    (revert-sound ind1))
  
  (define (test-edpos-1 test-func func-name ind1)
    (let ((v0 (channel->float-vector 12000 10 ind1 0)))
      (test-func ind1 0)
      (let ((v1 (channel->float-vector 12000 10 ind1 0)))
	(if (vequal v0 v1)
	    (snd-display #__line__ ";~A (0) no change! ~A ~A" func-name v0 v1))
	(test-func ind1 0)
	(let ((v2 (channel->float-vector 12000 10 ind1 0)))
	  (if (not (vequal v1 v2))
	      (snd-display #__line__ ";~A (1) ~A ~A" func-name v1 v2)))))
    (revert-sound ind1))
  
  (define (test-orig func0 func1 func-name ind1)
    (let ((v0 (channel->float-vector 12000 10 ind1 0)))
      (func0 ind1)
      (let ((v1 (channel->float-vector 12000 10 ind1 0)))
	(if (vequal1 v0 v1)
	    (snd-display #__line__ ";~A (orig: 0) no change! ~A ~A" func-name v0 v1))
	(func1 ind1)
	(let ((v2 (channel->float-vector 12000 10 ind1 0)))
	  (if (not (vequal1 v0 v2))
	      (snd-display #__line__ ";~A (orig: 1) ~A ~A" func-name v0 v2))))
      (revert-sound ind1)))
  
  (define* (make-bandpass-2 flo1 fhi1 flo2 fhi2 (len 30))
    (let ((f1 (make-bandpass flo1 fhi1 len))
	   (f2 (make-bandpass flo2 fhi2 len)))
      (float-vector-add! (mus-xcoeffs f1) (mus-xcoeffs f2))
      f1))
  
#|
  (define* (cosine-channel (beg 0) dur snd chn edpos)
    (let ((samps (or dur (framples snd chn))))
      (map-channel
       (let ((incr (/ pi samps))
	     (angle (* -0.5 pi)))
	 (lambda (y)
	   (let ((val (* y (cos angle))))
	     (set! angle (+ angle incr))
	     val)))
       beg dur snd chn edpos)
      ))
|#
  (define* (cosine-channel (beg 0) dur snd chn edpos)
    (let ((samps (or dur (framples snd chn))))
      (map-channel
       (let ((incr (/ pi samps))
	     (angle (* -0.5 pi))
	     (p (make-one-pole 1.0 -1.0)))
	 (one-pole p (- angle incr))
	 (lambda (y)
	   (* y (cos (one-pole p incr)))))
       beg dur snd chn edpos)
      ))

  (define (check-maxamp caller-line ind val name)
    (if (fneq (maxamp ind 0) val) (snd-display #__line__ ";maxamp amp-env ~A: ~A should be ~A" name (maxamp ind) val))
    (let ((pos (scan-channel (lambda (y) (>= (abs y) (- val .0001)))))
	  (maxpos (maxamp-position ind 0)))
      (if (not pos) 
	  (snd-display #__line__ ";actual maxamp ~A vals not right" name)
	  (if (not (= maxpos pos))
	      (snd-display #__line__ ";~A: find and maxamp-position disagree: ~A (~A) ~A (~A)" 
			   name pos (sample pos ind 0) maxpos (sample maxpos ind 0))))
      (let ((mx 0.0)
	    (data #f)
	    (mpos 0)
	    (len (framples ind)))
	(let ((info (float-vector-peak-and-location (samples 0 len ind))))
	  (set! mpos (cadr info))
	  (set! mx (car info)))
	(if (not (= mpos maxpos))
	    (snd-display #__line__ ";(~D) scan and maxamp-position disagree: ~A ~A" caller-line mpos maxpos))
	(if (fneq mx val) (snd-display #__line__ ";(~D) actual ~A max: ~A (correct: ~A)" caller-line name mx val)))))
  
  (define (check-env-vals name gen)
    (let ((len (framples))
	  (reader (make-sampler)))
      (call-with-exit
       (lambda (quit)
	 (do ((i 0 (+ i 1)))
	     ((= i len))
	   (let ((val (env gen))
		 (y (next-sample reader)))
	     (if (fneq val y)
		 (begin
		   (format #t "~%;check-env-vals ~A at ~D: ~A ~A" name i val y)
		   (quit)))))))))

  (define (our-x->position ind x) 
    (let ((ax (axis-info ind 0)))
      (list
       (+ (ax 10) 
	  (/ (* (- x (ax 2))
		(- (ax 12) (ax 10)))
	     (- (ax 4) (ax 2))))
       (x->position x ind))))
  
  (define (region-to-float-vector r c len)
    (let ((rs (make-region-sampler r 0 c))
	  (v (make-float-vector len)))
      (outa->fv v (next-sample rs))))
  
  (define (region2float-vector r c len)
    (region->float-vector r 0 len c))
  
  (if (playing) (snd-display #__line__ ";dac is running??"))
  (do ((clmtest 0 (+ 1 clmtest))) ((= clmtest tests)) 
    (log-mem clmtest)
    
    (let ((ind (open-sound "oboe.snd")))
      (set! (transform-graph? ind 0) #t)
      (set! (transform-graph-type ind 0) graph-as-sonogram)
      (catch 'no-such-axis
	(lambda ()
	  (set! (y-axis-label ind 0 1) "hiho"))
	(lambda args
	  (snd-display #__line__ ";no fft axis: ~A" args)))
      (set! (fft-log-frequency ind 0) #t) ; segfault here originally
      (update-transform-graph ind 0)
      (close-sound ind))
    
    (let ((ind (new-sound "test.snd" :size 10)))
      (float-vector->channel (make-float-vector 10 1.0))
      (env-channel '(0 0 1 1 2 0))
      (let ((data (channel->float-vector)))
	(if (not (vequal data (float-vector 0.000 0.200 0.400 0.600 0.800 1.000 0.750 0.500 0.250 0.000)))
	    (snd-display #__line__ ";pyr 10: ~A" data)))
      (undo)
      (env-channel '((0 0) (1 1) (2 0)))
      (let ((data (channel->float-vector)))
	(if (not (vequal data (float-vector 0.000 0.200 0.400 0.600 0.800 1.000 0.750 0.500 0.250 0.000)))
	    (snd-display #__line__ ";pyr 10: ~A" data)))
      (undo)
      (env-channel (make-env '(0 0 1 1 2 0) :length 10))
      (let ((data (channel->float-vector)))
	(if (not (vequal data (float-vector 0.000 0.200 0.400 0.600 0.800 1.000 0.750 0.500 0.250 0.000)))
	    (snd-display #__line__ ";pyr 10: ~A" data)))
      (undo)
      (close-sound ind))
    
    (for-each
     (lambda (size)
       (let ((ind (new-sound "test.snd" :size size))
	     (incr (/ 1.0 (- size 1)))
	     (e (make-env '(0 0 1 1) :length size)))
	 (float-vector->channel (make-float-vector size 1.0))
	 
	 (ramp-channel 0.0 1.0)
	 (let ((data (channel->float-vector)))
	   (if (or (fneq (data 0) 0.0)
		   (fneq (data (- size 1)) 1.0))
	       (snd-display #__line__ ";ramp-channel ~A end points: ~A ~A" size (data 0) (data (- size 1))))
	   (do ((i 0 (+ i 1)))
	       ((= i size))
	     (let ((val (envelope-interp (* i incr) '(0.0 0.0 1.0 1.0)))
		   (segval (env e)))
	       (if (or (fneq segval val)
		       (fneq (data i) val))
		   (snd-display #__line__ ";ramp-channel ~A of ~A: ramp: ~A, interp: ~A, env: ~A" i size (data i) val segval)))))
	 (undo)
	 (xramp-channel 0.0 1.0 32.0)
	 (let ((e (make-env '(0 0 1 1) :length size :base 32.0)))
	   (let ((data (channel->float-vector)))
	     (if (or (fneq (data 0) 0.0)
		     (fneq (data (- size 1)) 1.0))
		 (snd-display #__line__ ";xramp-channel 32 ~A end points: ~A ~A" size (data 0) (data (- size 1))))
	     (do ((i 0 (+ i 1)))
		 ((= i size))
	       (let ((val (envelope-interp (* i incr) '(0.0 0.0 1.0 1.0) 32.0))
		     (segval (env e)))
		 (if (or (fneq segval val)
			 (fneq (data i) val))
		     (snd-display #__line__ ";xramp-channel 32 ~A of ~A: ramp: ~A, interp: ~A, env: ~A" i size (data i) val segval))))))
	 (undo)
	 (xramp-channel 0.0 1.0 0.4)
	 (let ((e (make-env '(0 0 1 1) :length size :base 0.4)))
	   (let ((data (channel->float-vector)))
	     (if (or (fneq (data 0) 0.0)
		     (fneq (data (- size 1)) 1.0))
		 (snd-display #__line__ ";xramp-channel .4 ~A end points: ~A ~A" size (data 0) (data (- size 1))))
	     (do ((i 0 (+ i 1)))
		 ((= i size))
	       (let ((val (envelope-interp (* i incr) '(0.0 0.0 1.0 1.0) 0.4))
		     (segval (env e)))
		 (if (or (fneq segval val)
			 (fneq (data i) val))
		     (snd-display #__line__ ";xramp-channel .4 ~A of ~A: ramp: ~A, interp: ~A, env: ~A" i size (data i) val segval))))))
	 (undo)
	 (xramp-channel 1.0 -1.0 8.0)
	 (let ((e (make-env '(0 1 1 -1) :length size :base 8.0)))
	   (let ((data (channel->float-vector)))
	     (if (or (fneq (data 0) 1.0)
		     (fneq (data (- size 1)) -1.0))
		 (snd-display #__line__ ";xramp-channel 1 -1 8 ~A end points: ~A ~A" size (data 0) (data (- size 1))))
	     (do ((i 0 (+ i 1)))
		 ((= i size))
	       (let ((segval (env e)))
		 (if (fneq segval (data i))
		     (snd-display #__line__ ";xramp-channel 1 -1 8 ~A of ~A: ramp: ~A, env: ~A" i size (data i) segval))))))
	 (undo)
	 (close-sound ind)))
     (list 10 100 1000))
    
    ;; basic edit tree cases
    (let ((ind (new-sound "test.snd")))
      (if (not (= (redo) 0)) (snd-display #__line__ ";redo with no ops: ~A" (redo)))
      (if (not (= (undo) 0)) (snd-display #__line__ ";undo with no ops: ~A" (undo)))
      
      (if (not (string-=? (display-edits) (string-append "
EDITS: 0

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, end_mark)
")))
	  (snd-display #__line__ ";new 0: ~A" (display-edits)))
      (insert-samples 10 10 (make-float-vector 10))
      (if (not (= (framples) 20)) (snd-display #__line__ ";new 1 framples: ~A" (framples)))
      (if (not (string-=? (display-edits) (string-append "
EDITS: 1

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, end_mark)

 (insert 1 20) ; insert-samples [1:4]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, cp->sounds[-1][0:8, 0.000])
   (at 10, cp->sounds[1][0:9, 1.000]) [buf: 10] 
   (at 20, end_mark)
")))
	  (snd-display #__line__ ";new 1: ~A" (display-edits)))
      (undo)
      (insert-samples 0 10 (make-float-vector 10))
      (if (not (= (framples) 11)) (snd-display #__line__ ";new 2 framples: ~A" (framples))) ; 11 because there was 1 sample when new-sound created 
      (if (not (string-=? (display-edits) (string-append "
EDITS: 1

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, end_mark)

 (insert 0 10) ; insert-samples [1:3]:
   (at 0, cp->sounds[1][0:9, 1.000]) [buf: 10] 
   (at 10, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 11, end_mark)
")))
	  (snd-display #__line__ ";new 2: ~A" (display-edits)))
      (let ((eds (undo 2)))
	(if (not (= eds 2)) (snd-display #__line__ ";new 3 undo: ~A" eds)))
      (insert-samples 0 10 (make-float-vector 10))
      (if (not (= (framples) 11)) (snd-display #__line__ ";new 3 framples: ~A" (framples)))
      (if (not (string-=? (display-edits) (string-append "
EDITS: 1

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, end_mark)

 (insert 0 10) ; insert-samples [1:3]:
   (at 0, cp->sounds[1][0:9, 1.000]) [buf: 10] 
   (at 10, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 11, end_mark)
")))
	  (snd-display #__line__ ";new 3: ~A" (display-edits)))
      (undo)
      (set! (sample 0) .5)
      (if (not (= (framples) 1)) (snd-display #__line__ ";new 4 framples: ~A" (framples)))
      (if (not (string-=? (display-edits) (string-append "
EDITS: 1

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, end_mark)

 (set 0 1) ; set-sample 0 0.5000 [1:2]:
   (at 0, cp->sounds[1][0:0, 1.000]) [buf: 1] 
   (at 1, end_mark)
")))
	  (snd-display #__line__ ";new 4: ~A" (display-edits)))      
      (undo)
      
      (set! (samples 0 10) (make-float-vector 10))
      (if (not (= (framples) 10)) (snd-display #__line__ ";new 5 framples: ~A" (framples)))
      (if (not (string-=? (display-edits) (string-append "
EDITS: 1

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, end_mark)

 (set 0 10) ; set-samples [1:2]:
   (at 0, cp->sounds[1][0:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
")))
	  (snd-display #__line__ ";new 5: ~A" (display-edits)))
      
      (delete-samples 3 4)
      (if (not (= (framples) 6)) (snd-display #__line__ ";new 6 framples: ~A" (framples)))
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (delete 3 4) ; delete-samples 3 4 [2:3]:
   (at 0, cp->sounds[1][0:2, 1.000]) [buf: 10] 
   (at 3, cp->sounds[1][7:9, 1.000]) [buf: 10] 
   (at 6, end_mark)
"))
	  (snd-display #__line__ ";new 6: ~A" (safe-display-edits ind 0 2)))
      
      (set! (samples 1 4) (make-float-vector 4))
      (if (not (= (framples) 6)) (snd-display #__line__ ";new 7 framples: ~A" (framples)))
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (set 1 4) ; set-samples [3:4]:
   (at 0, cp->sounds[1][0:0, 1.000]) [buf: 10] 
   (at 1, cp->sounds[2][0:3, 1.000]) [buf: 4] 
   (at 5, cp->sounds[1][9:9, 1.000]) [buf: 10] 
   (at 6, end_mark)
"))
	  (snd-display #__line__ ";new 7: ~A" (safe-display-edits ind 0 3)))
      (undo 2)
      (insert-samples 2 3 (make-float-vector 3))
      (insert-samples 2 1 (make-float-vector 1))
      (insert-samples 4 1 (make-float-vector 1))
      (insert-samples 15 1 (make-float-vector 1))
      (if (not (= (framples) 16)) (snd-display #__line__ ";new 8 framples: ~A" (framples)))
      (if (not (string-=? (display-edits) (string-append "
EDITS: 5

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, end_mark)

 (set 0 10) ; set-samples [1:2]:
   (at 0, cp->sounds[1][0:9, 1.000]) [buf: 10] 
   (at 10, end_mark)

 (insert 2 3) ; insert-samples [2:4]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[2][0:2, 1.000]) [buf: 3] 
   (at 5, cp->sounds[1][2:9, 1.000]) [buf: 10] 
   (at 13, end_mark)

 (insert 2 1) ; insert-samples [3:5]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[3][0:0, 1.000]) [buf: 1] 
   (at 3, cp->sounds[2][0:2, 1.000]) [buf: 3] 
   (at 6, cp->sounds[1][2:9, 1.000]) [buf: 10] 
   (at 14, end_mark)

 (insert 4 1) ; insert-samples [4:7]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[3][0:0, 1.000]) [buf: 1] 
   (at 3, cp->sounds[2][0:0, 1.000]) [buf: 3] 
   (at 4, cp->sounds[4][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[2][1:2, 1.000]) [buf: 3] 
   (at 7, cp->sounds[1][2:9, 1.000]) [buf: 10] 
   (at 15, end_mark)

 (insert 15 1) ; insert-samples [5:8]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[3][0:0, 1.000]) [buf: 1] 
   (at 3, cp->sounds[2][0:0, 1.000]) [buf: 3] 
   (at 4, cp->sounds[4][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[2][1:2, 1.000]) [buf: 3] 
   (at 7, cp->sounds[1][2:9, 1.000]) [buf: 10] 
   (at 15, cp->sounds[5][0:0, 1.000]) [buf: 1] 
   (at 16, end_mark)
")))
	  (snd-display #__line__ ";new 8: ~A" (display-edits)))
      (delete-samples 2 1)
      (if (not (string-=? (safe-display-edits ind 0 6) "
 (delete 2 1) ; delete-samples 2 1 [6:7]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[2][0:0, 1.000]) [buf: 3] 
   (at 3, cp->sounds[4][0:0, 1.000]) [buf: 1] 
   (at 4, cp->sounds[2][1:2, 1.000]) [buf: 3] 
   (at 6, cp->sounds[1][2:9, 1.000]) [buf: 10] 
   (at 14, cp->sounds[5][0:0, 1.000]) [buf: 1] 
   (at 15, end_mark)
"))
	  (snd-display #__line__ ";new 9: ~A" (safe-display-edits ind 0 6)))
      (delete-samples 0 5)
      (if (not (string-=? (safe-display-edits ind 0 7) "
 (delete 0 5) ; delete-samples 0 5 [7:4]:
   (at 0, cp->sounds[2][2:2, 1.000]) [buf: 3] 
   (at 1, cp->sounds[1][2:9, 1.000]) [buf: 10] 
   (at 9, cp->sounds[5][0:0, 1.000]) [buf: 1] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";new 10: ~A" (safe-display-edits ind 0 7)))
      (delete-samples 6 4)
      (if (not (string-=? (safe-display-edits ind 0 8) "
 (delete 6 4) ; delete-samples 6 4 [8:3]:
   (at 0, cp->sounds[2][2:2, 1.000]) [buf: 3] 
   (at 1, cp->sounds[1][2:6, 1.000]) [buf: 10] 
   (at 6, end_mark)
"))
	  (snd-display #__line__ ";new 11: ~A" (safe-display-edits ind 0 8)))
      (delete-samples 0 1)
      (if (not (string-=? (safe-display-edits ind 0 9) "
 (delete 0 1) ; delete-samples 0 1 [9:2]:
   (at 0, cp->sounds[1][2:6, 1.000]) [buf: 10] 
   (at 5, end_mark)
"))
	  (snd-display #__line__ ";new 12: ~A" (safe-display-edits ind 0 9)))
      
      (delete-samples 0 5)
      (if (not (string-=? (safe-display-edits ind 0 10) "
 (delete 0 5) ; delete-samples 0 5 [10:1]:
   (at 0, end_mark)
"))
	  (snd-display #__line__ ";new 13: ~A" (safe-display-edits ind 0 10)))
      (delete-samples 0 10)
      (if (not (= (edit-position) 10))
	  (snd-display #__line__ ";no-op delete deleted something! ~A" (display-edits)))
      (insert-samples 0 3 (make-float-vector 3))
      (if (not (string-=? (safe-display-edits ind 0 11) "
 (insert 0 3) ; insert-samples [11:2]:
   (at 0, cp->sounds[6][0:2, 1.000]) [buf: 3] 
   (at 3, end_mark)
"))
	  (snd-display #__line__ ";new 14: ~A" (safe-display-edits ind 0 11)))
      (delete-samples 2 1)
      (if (not (string-=? (safe-display-edits ind 0 12) "
 (delete 2 1) ; delete-samples 2 1 [12:2]:
   (at 0, cp->sounds[6][0:1, 1.000]) [buf: 3] 
   (at 2, end_mark)
"))
	  (snd-display #__line__ ";new 15: ~A" (safe-display-edits ind 0 12)))
      (set! (sample 0) .5)
      (if (not (string-=? (safe-display-edits ind 0 13) "
 (set 0 1) ; set-sample 0 0.5000 [13:3]:
   (at 0, cp->sounds[7][0:0, 1.000]) [buf: 1] 
   (at 1, cp->sounds[6][1:1, 1.000]) [buf: 3] 
   (at 2, end_mark)
"))
	  (snd-display #__line__ ";new 16: ~A" (safe-display-edits ind 0 13)))
      (set! (sample 1) .5)
      (if (not (string-=? (safe-display-edits ind 0 14) "
 (set 1 1) ; set-sample 1 0.5000 [14:3]:
   (at 0, cp->sounds[7][0:0, 1.000]) [buf: 1] 
   (at 1, cp->sounds[8][0:0, 1.000]) [buf: 1] 
   (at 2, end_mark)
"))
	  (snd-display #__line__ ";new 17: ~A" (safe-display-edits ind 0 14)))  
      (map-channel (lambda (y) 1.0) 0 10)
      (if (not (string-=? (safe-display-edits ind 0 15) "
 (set 0 10) ; map-channel [15:2]:
   (at 0, cp->sounds[9][0:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";new 18: ~A" (safe-display-edits ind 0 15)))  
      (insert-samples 0 10 (make-float-vector 10))
      (if (not (string-=? (safe-display-edits ind 0 16) "
 (insert 0 10) ; insert-samples [16:3]:
   (at 0, cp->sounds[10][0:9, 1.000]) [buf: 10] 
   (at 10, cp->sounds[9][0:9, 1.000]) [buf: 10] 
   (at 20, end_mark)
"))
	  (snd-display #__line__ ";new 19: ~A" (safe-display-edits ind 0 16)))
      (set! (samples 2 3) (make-float-vector 3))
      (if (not (string-=? (safe-display-edits ind 0 17) "
 (set 2 3) ; set-samples [17:5]:
   (at 0, cp->sounds[10][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[11][0:2, 1.000]) [buf: 3] 
   (at 5, cp->sounds[10][5:9, 1.000]) [buf: 10] 
   (at 10, cp->sounds[9][0:9, 1.000]) [buf: 10] 
   (at 20, end_mark)
"))
	  (snd-display #__line__ ";new 20: ~A" (safe-display-edits ind 0 17)))
      (set! (samples 0 12) (make-float-vector 12))
      (if (not (string-=? (safe-display-edits ind 0 18) "
 (set 0 12) ; set-samples [18:3]:
   (at 0, cp->sounds[12][0:11, 1.000]) [buf: 12] 
   (at 12, cp->sounds[9][2:9, 1.000]) [buf: 10] 
   (at 20, end_mark)
"))
	  (snd-display #__line__ ";new 21: ~A" (safe-display-edits ind 0 18)))
      (set! (samples 30 10) (make-float-vector 10))
      (if (not (string-=? (safe-display-edits ind 0 19) "
 (set 20 21) ; set-samples [19:5]:
   (at 0, cp->sounds[12][0:11, 1.000]) [buf: 12] 
   (at 12, cp->sounds[9][2:9, 1.000]) [buf: 10] 
   (at 20, cp->sounds[-1][0:9, 0.000])
   (at 30, cp->sounds[13][0:9, 1.000]) [buf: 10] 
   (at 40, end_mark)
"))
	  (snd-display #__line__ ";new 21: ~A" (safe-display-edits ind 0 19)))
      (close-sound ind))
    
    ;; scale/ramp
    (let ((ind (new-sound "test.snd")))
      (map-channel (lambda (y) 1.0) 0 10)
      (scale-channel 0.5)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (scale 0 10) ; scale-channel 0.500 0 #f [2:2]:
   (at 0, cp->sounds[1][0:9, 0.500]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";scl 0: ~A" (safe-display-edits ind 0 2)))
      (undo)
      (scale-channel 0.5 0 3)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (scale 0 3) ; scale-channel 0.500 0 3 [2:3]:
   (at 0, cp->sounds[1][0:2, 0.500]) [buf: 10] 
   (at 3, cp->sounds[1][3:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";scl 1: ~A" (safe-display-edits ind 0 2)))
      (undo)
      (scale-channel 0.5 5 5)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (scale 5 5) ; scale-channel 0.500 5 5 [2:3]:
   (at 0, cp->sounds[1][0:4, 1.000]) [buf: 10] 
   (at 5, cp->sounds[1][5:9, 0.500]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";scl 2: ~A" (safe-display-edits ind 0 2)))
      (undo)
      (scale-channel 0.5 2 4)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (scale 2 4) ; scale-channel 0.500 2 4 [2:4]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:5, 0.500]) [buf: 10] 
   (at 6, cp->sounds[1][6:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";scl 2a: ~A" (safe-display-edits ind 0 2)))
      (undo)
      (scale-channel 0.5 10 10)
      (if (not (= (edit-position) 1))
	  (snd-display #__line__ ";scale beyond end edited? ~A" (display-edits)))
      (scale-channel 0.5 100 10)
      (if (not (= (edit-position) 1))
	  (snd-display #__line__ ";scale way beyond end edited? ~A" (display-edits)))
      (scale-channel 0.5 5 10)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (scale 5 5) ; scale-channel 0.500 5 5 [2:3]:
   (at 0, cp->sounds[1][0:4, 1.000]) [buf: 10] 
   (at 5, cp->sounds[1][5:9, 0.500]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";scl 3: ~A" (safe-display-edits ind 0 2)))
      (undo)
      (set! (sample 4) .5)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (set 4 1) ; set-sample 4 0.5000 [2:4]:
   (at 0, cp->sounds[1][0:3, 1.000]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[1][5:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";scl 4: ~A" (safe-display-edits ind 0 2)))
      (scale-channel 0.5 0 4)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 0 4) ; scale-channel 0.500 0 4 [3:4]:
   (at 0, cp->sounds[1][0:3, 0.500]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[1][5:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";scl 5: ~A" (safe-display-edits ind 0 3)))
      (scale-channel 0.5 4 1)
      (if (not (string-=? (safe-display-edits ind 0 4) "
 (scale 4 1) ; scale-channel 0.500 4 1 [4:4]:
   (at 0, cp->sounds[1][0:3, 0.500]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 0.500]) [buf: 1] 
   (at 5, cp->sounds[1][5:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";scl 6: ~A" (safe-display-edits ind 0 4)))
      (scale-channel 0.5 0 7)
      (if (not (string-=? (safe-display-edits ind 0 5) "
 (scale 0 7) ; scale-channel 0.500 0 7 [5:5]:
   (at 0, cp->sounds[1][0:3, 0.250]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 0.250]) [buf: 1] 
   (at 5, cp->sounds[1][5:6, 0.500]) [buf: 10] 
   (at 7, cp->sounds[1][7:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";scl 7: ~A" (safe-display-edits ind 0 5)))
      (scale-channel 0.5 1 4)
      (if (not (string-=? (safe-display-edits ind 0 6) "
 (scale 1 4) ; scale-channel 0.500 1 4 [6:6]:
   (at 0, cp->sounds[1][0:0, 0.250]) [buf: 10] 
   (at 1, cp->sounds[1][1:3, 0.125]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 0.125]) [buf: 1] 
   (at 5, cp->sounds[1][5:6, 0.500]) [buf: 10] 
   (at 7, cp->sounds[1][7:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";scl 8: ~A" (safe-display-edits ind 0 6)))
      (undo 4)
      (scale-channel 0.5 1 8)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 1 8) ; scale-channel 0.500 1 8 [3:6]:
   (at 0, cp->sounds[1][0:0, 1.000]) [buf: 10] 
   (at 1, cp->sounds[1][1:3, 0.500]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 0.500]) [buf: 1] 
   (at 5, cp->sounds[1][5:8, 0.500]) [buf: 10] 
   (at 9, cp->sounds[1][9:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";scl 9: ~A" (safe-display-edits ind 0 3)))
      (undo 2)
      
      (ramp-channel 0.0 1.0)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (ramp 0 10) ; ramp-channel 0.000 1.000 0 #f [2:2]:
   (at 0, cp->sounds[1][0:9, 1.000, [1]-0.000 -> 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";ramp 0: ~A" (safe-display-edits ind 0 2)))
      (scale-channel 0.5)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 0 10) ; scale-channel 0.500 0 #f [3:2]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]-0.000 -> 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";ramp 1: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (scale-channel 0.5 0 5)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 0 5) ; scale-channel 0.500 0 5 [3:3]:
   (at 0, cp->sounds[1][0:4, 0.500, [1]-0.000 -> 0.444]) [buf: 10] 
   (at 5, cp->sounds[1][5:9, 1.000, [1]0.556 -> 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";ramp 2: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (scale-channel 0.5 2 4)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 2 4) ; scale-channel 0.500 2 4 [3:4]:
   (at 0, cp->sounds[1][0:1, 1.000, [1]-0.000 -> 0.111]) [buf: 10] 
   (at 2, cp->sounds[1][2:5, 0.500, [1]0.222 -> 0.556]) [buf: 10] 
   (at 6, cp->sounds[1][6:9, 1.000, [1]0.667 -> 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";ramp 3: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (scale-channel 0.5 5 5)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 5 5) ; scale-channel 0.500 5 5 [3:3]:
   (at 0, cp->sounds[1][0:4, 1.000, [1]-0.000 -> 0.444]) [buf: 10] 
   (at 5, cp->sounds[1][5:9, 0.500, [1]0.556 -> 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";ramp 4: ~A" (safe-display-edits ind 0 3)))
      (undo 2)
      (ramp-channel .2 .6 2 6)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (ramp 2 6) ; ramp-channel 0.200 0.600 2 6 [2:4]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:7, 1.000, [1]0.200 -> 0.600]) [buf: 10] 
   (at 8, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";ramp 5: ~A" (safe-display-edits ind 0 2)))
      (scale-channel 0.5 0 5)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 0 5) ; scale-channel 0.500 0 5 [3:5]:
   (at 0, cp->sounds[1][0:1, 0.500]) [buf: 10] 
   (at 2, cp->sounds[1][2:4, 0.500, [1]0.200 -> 0.360]) [buf: 10] 
   (at 5, cp->sounds[1][5:7, 1.000, [1]0.440 -> 0.600]) [buf: 10] 
   (at 8, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";ramp 6: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (scale-channel 0.5 2 6)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 2 6) ; scale-channel 0.500 2 6 [3:4]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:7, 0.500, [1]0.200 -> 0.600]) [buf: 10] 
   (at 8, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";ramp 7: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (scale-channel 0.5 5 4)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 5 4) ; scale-channel 0.500 5 4 [3:6]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:4, 1.000, [1]0.200 -> 0.360]) [buf: 10] 
   (at 5, cp->sounds[1][5:7, 0.500, [1]0.440 -> 0.600]) [buf: 10] 
   (at 8, cp->sounds[1][8:8, 0.500]) [buf: 10] 
   (at 9, cp->sounds[1][9:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";ramp 8: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (set! (sample 4) .5)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (set 4 1) ; set-sample 4 0.5000 [3:6]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[1][5:7, 1.000, [1]0.440 -> 0.600]) [buf: 10] 
   (at 8, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";ramp 9: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (scale-channel 0.5 4 1)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 4 1) ; scale-channel 0.500 4 1 [3:6]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[1][4:4, 0.500, [1]0.360 -> 0.360]) [buf: 10] 
   (at 5, cp->sounds[1][5:7, 1.000, [1]0.440 -> 0.600]) [buf: 10] 
   (at 8, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";ramp 10: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (delete-sample 4)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 4 1) ; delete-samples 4 1 [3:5]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[1][5:7, 1.000, [1]0.440 -> 0.600]) [buf: 10] 
   (at 7, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 9, end_mark)
"))
	  (snd-display #__line__ ";ramp 11: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (delete-samples 4 2)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 4 2) ; delete-samples 4 2 [3:5]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[1][6:7, 1.000, [1]0.520 -> 0.600]) [buf: 10] 
   (at 6, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 8, end_mark)
"))
	  (snd-display #__line__ ";ramp 12: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (delete-samples 4 3)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 4 3) ; delete-samples 4 3 [3:5]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[1][7:7, 1.000, [1]0.600 -> 0.600]) [buf: 10] 
   (at 5, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 7, end_mark)
"))
	  (snd-display #__line__ ";ramp 13: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (delete-samples 4 4)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 4 4) ; delete-samples 4 4 [3:4]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 6, end_mark)
"))
	  (snd-display #__line__ ";ramp 14: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (delete-samples 4 5)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 4 5) ; delete-samples 4 5 [3:4]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[1][9:9, 1.000]) [buf: 10] 
   (at 5, end_mark)
"))
	  (snd-display #__line__ ";ramp 15: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (scale-channel 0.5 4 2)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 4 2) ; scale-channel 0.500 4 2 [3:6]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[1][4:5, 0.500, [1]0.360 -> 0.440]) [buf: 10] 
   (at 6, cp->sounds[1][6:7, 1.000, [1]0.520 -> 0.600]) [buf: 10] 
   (at 8, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";ramp 16: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (pad-channel 4 1)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (silence 4 1) ; pad-channel [3:6]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[-1][0:0, 0.000])
   (at 5, cp->sounds[1][4:7, 1.000, [1]0.360 -> 0.600]) [buf: 10] 
   (at 9, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 11, end_mark)
"))
	  (snd-display #__line__ ";ramp 17: ~A" (safe-display-edits ind 0 3)))
      (close-sound ind))
    
    ;; xramp
    (let ((ind (new-sound "test.snd"))) ; second main let
      (map-channel (lambda (y) 1.0) 0 10)
      (xramp-channel 0.0 1.0 32.0)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (ramp 0 10) ; xramp-channel 0.000 1.000 32.000 0 #f [2:2]:
   (at 0, cp->sounds[1][0:9, 1.000, [1]0.000 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";xramp 1: ~A" (safe-display-edits ind 0 2)))
      (undo)
      (xramp-channel 0.0 1.0 0.325)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (ramp 0 10) ; xramp-channel 0.000 1.000 0.325 0 #f [2:2]:
   (at 0, cp->sounds[1][0:9, 1.000, [1]0.000 -> 1.000, off: 1.481, scl: -1.481]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";xramp 2: ~A" (safe-display-edits ind 0 2)))
      (undo)
      (xramp-channel 0.0 1.0 0.0)
      (if (not (string-=? (safe-display-edits ind 0 2) (string-append "
 (scale 0 10) ; scale-channel 0.000 0 #f [2:2]:
   (at 0, cp->sounds[0][0:9, 0.000]) [file: " (getcwd) "/test.snd[0]]
   (at 10, end_mark)
")))
	  (snd-display #__line__ ";xramp 3: ~A" (safe-display-edits ind 0 2)))
      (undo)
      (xramp-channel 0.0 1.0 1.0)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (ramp 0 10) ; ramp-channel 0.000 1.000 0 #f [2:2]:
   (at 0, cp->sounds[1][0:9, 1.000, [1]-0.000 -> 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";xramp 4: ~A" (safe-display-edits ind 0 2)))
      (undo)
      (xramp-channel 0.5 1.5 32.0)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (ramp 0 10) ; xramp-channel 0.500 1.500 32.000 0 #f [2:2]:
   (at 0, cp->sounds[1][0:9, 1.000, [1]0.500 -> 1.500, off: 0.468, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";xramp 5: ~A" (safe-display-edits ind 0 2)))
      (if (or (fneq (maxamp) 1.5) (fneq (sample 0) 0.5))
	  (snd-display #__line__ ";xramp 5 vals: ~A ~A" (maxamp) (sample 0)))
      (undo)
      (xramp-channel -0.5 1.5 32.0)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (ramp 0 10) ; xramp-channel -0.500 1.500 32.000 0 #f [2:2]:
   (at 0, cp->sounds[1][0:9, 1.000, [1]-0.500 -> 1.500, off: -0.565, scl: 0.065]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display #__line__ ";xramp 6: ~A" (safe-display-edits ind 0 2)))
      (if (or (fneq (maxamp) 1.5) (fneq (sample 0) -0.5))
	  (snd-display #__line__ ";xramp 6 vals: ~A ~A" (maxamp) (sample 0)))
      (undo)
      (xramp-channel 0.0 1.0 32.0)
      (let ((vals (channel->float-vector))
	    (ctr 0))
	(scale-channel 0.5)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 0 10) ; scale-channel 0.500 0 #f [3:2]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";xramp 7: ~A" (safe-display-edits ind 0 3)))
	(set! ctr 0)
	(let ((p (make-one-pole 1.0 -1.0)))
	  (let ((baddy (scan-channel (lambda (y) (fneq y (* 0.5 (float-vector-ref vals (floor (- (one-pole p 1.0) 1.0)))))))))
	    (if baddy (snd-display #__line__ ";trouble in xramp 7: ~A" baddy))))
	(undo)
	(delete-sample 0)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 0 1) ; delete-samples 0 1 [3:2]:
   (at 0, cp->sounds[1][1:9, 1.000, [1]0.015 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 9, end_mark)
"))
	    (snd-display #__line__ ";xramp 8: ~A" (safe-display-edits ind 0 3)))
	(set! ctr 1)
	(let ((p (make-one-pole 1.0 -1.0)))
	  (let ((baddy (scan-channel (lambda (y) (fneq y (float-vector-ref vals (floor (one-pole p 1.0))))))))
	    (if baddy (snd-display #__line__ ";trouble in xramp 8: ~A" baddy))))
	(undo)
	(delete-samples 0 2)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 0 2) ; delete-samples 0 2 [3:2]:
   (at 0, cp->sounds[1][2:9, 1.000, [1]0.037 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 8, end_mark)
"))
	    (snd-display #__line__ ";xramp 9: ~A" (safe-display-edits ind 0 3)))
	(set! ctr 2)
	(let ((p (make-one-pole 1.0 -1.0)))
	  (one-pole p 1.0)
	  (let ((baddy (scan-channel (lambda (y) (fneq y (float-vector-ref vals (floor (one-pole p 1.0))))))))
	    (if baddy (snd-display #__line__ ";trouble in xramp 9: ~A" baddy))))
	(undo)
	(delete-sample 0)
	(delete-sample 0)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (delete 0 1) ; delete-samples 0 1 [4:2]:
   (at 0, cp->sounds[1][2:9, 1.000, [1]0.037 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 8, end_mark)
"))
	    (snd-display #__line__ ";xramp 10: ~A" (safe-display-edits ind 0 4)))
	(undo 2)
	(delete-sample 4)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 4 1) ; delete-samples 4 1 [3:3]:
   (at 0, cp->sounds[1][0:3, 1.000, [1]0.000 -> 0.070, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 4, cp->sounds[1][5:9, 1.000, [1]0.189 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 9, end_mark)
"))
	    (snd-display #__line__ ";xramp 11: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(delete-samples 4 2)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 4 2) ; delete-samples 4 2 [3:3]:
   (at 0, cp->sounds[1][0:3, 1.000, [1]0.000 -> 0.070, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 4, cp->sounds[1][6:9, 1.000, [1]0.293 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 8, end_mark)
"))
	    (snd-display #__line__ ";xramp 12: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(scale-channel 0.5 4 2)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 4 2) ; scale-channel 0.500 4 2 [3:4]:
   (at 0, cp->sounds[1][0:3, 1.000, [1]0.000 -> 0.070, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 4, cp->sounds[1][4:5, 0.500, [1]0.118 -> 0.189, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 6, cp->sounds[1][6:9, 1.000, [1]0.293 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";xramp 13: ~A" (safe-display-edits ind 0 3)))
	(set! ctr 0)
	(let ((baddy (scan-channel (lambda (y)
				     (if (or (and (> ctr 5) (fneq y (vals ctr)))
					     (and (< ctr 4) (fneq y (vals ctr)))
					     (and (or (= ctr 4) (= ctr 5)) (fneq y (* 0.5 (vals ctr)))))
					 #t
					 (begin (set! ctr (+ ctr 1)) #f))))))
	  (if baddy (snd-display #__line__ ";trouble in xramp 8: ~A" baddy)))
	(undo)
	(scale-channel 0.5 0 2)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 0 2) ; scale-channel 0.500 0 2 [3:3]:
   (at 0, cp->sounds[1][0:1, 0.500, [1]0.000 -> 0.015, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 2, cp->sounds[1][2:9, 1.000, [1]0.037 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";xramp 14: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(pad-channel 4 2)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (silence 4 2) ; pad-channel [3:4]:
   (at 0, cp->sounds[1][0:3, 1.000, [1]0.000 -> 0.070, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 4, cp->sounds[-1][0:1, 0.000])
   (at 6, cp->sounds[1][4:9, 1.000, [1]0.118 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 12, end_mark)
"))
	    (snd-display #__line__ ";xramp 15: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(set! (sample 4) 1.0)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (set 4 1) ; set-sample 4 1.0000 [3:4]:
   (at 0, cp->sounds[1][0:3, 1.000, [1]0.000 -> 0.070, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[1][5:9, 1.000, [1]0.189 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";xramp 16: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(set! (samples 4 2) (make-float-vector 2))
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (set 4 2) ; set-samples [3:4]:
   (at 0, cp->sounds[1][0:3, 1.000, [1]0.000 -> 0.070, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 4, cp->sounds[2][0:1, 1.000]) [buf: 2] 
   (at 6, cp->sounds[1][6:9, 1.000, [1]0.293 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";xramp 17: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(scale-channel 0.5)
	(set! (samples 4 2) (make-float-vector 2))
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (set 4 2) ; set-samples [4:4]:
   (at 0, cp->sounds[1][0:3, 0.500, [1]0.000 -> 0.070, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 4, cp->sounds[2][0:1, 1.000]) [buf: 2] 
   (at 6, cp->sounds[1][6:9, 0.500, [1]0.293 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";xramp 18: ~A" (safe-display-edits ind 0 4)))
	)
      (close-sound ind))
    
    (let ((ind (new-sound "test.snd"))) ; third
      (map-channel (lambda (y) 1.0) 0 100)
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(scale-channel 0.5 (* i 10) 10))
      (ramp-channel 0.0 1.0)
      (if (not (string=? (safe-display-edits ind 0 12) "
 (ramp 0 100) ; ramp-channel 0.000 1.000 0 #f [12:11]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 0.091]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.101 -> 0.192]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.202 -> 0.293]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.303 -> 0.394]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.404 -> 0.495]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.505 -> 0.596]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.606 -> 0.697]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.707 -> 0.798]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.808 -> 0.899]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, [1]0.909 -> 1.000]) [buf: 100] 
   (at 100, end_mark)
"))
	  (snd-display #__line__ ";multi-ramp 1: ~A" (safe-display-edits ind 0 12)))
      (if (fneq (maxamp) 0.5) (snd-display #__line__ ";multi ramp 1 maxamp: ~A" (maxamp)))
      (undo)
      (ramp-channel 0.1 1.0 10 90)
      (if (not (string=? (safe-display-edits ind 0 12) "
 (ramp 10 90) ; ramp-channel 0.100 1.000 10 90 [12:11]:
   (at 0, cp->sounds[1][0:9, 0.500]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.100 -> 0.191]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.201 -> 0.292]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.302 -> 0.393]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.403 -> 0.494]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.504 -> 0.596]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.606 -> 0.697]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.707 -> 0.798]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.808 -> 0.899]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, [1]0.909 -> 1.000]) [buf: 100] 
   (at 100, end_mark)
"))
	  (snd-display #__line__ ";multi-ramp 2: ~A" (safe-display-edits ind 0 12)))
      (if (fneq (maxamp) 0.5) (snd-display #__line__ ";multi ramp 2 maxamp: ~A" (maxamp)))
      (undo)
      (ramp-channel 0.0 0.9 0 90)
      (if (not (string=? (safe-display-edits ind 0 12) "
 (ramp 0 90) ; ramp-channel 0.000 0.900 0 90 [12:11]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 0.091]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.101 -> 0.192]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.202 -> 0.293]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.303 -> 0.394]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.404 -> 0.496]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.506 -> 0.597]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.607 -> 0.698]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.708 -> 0.799]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.809 -> 0.900]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500]) [buf: 100] 
   (at 100, end_mark)
"))
	  (snd-display #__line__ ";multi-ramp 3: ~A" (safe-display-edits ind 0 12)))
      (if (fneq (maxamp) 0.5) (snd-display #__line__ ";multi ramp 3 maxamp: ~A" (maxamp)))
      (if (fneq (sample 89) 0.45) (snd-display #__line__ ";multi ramp 3 sample 89: ~A" (sample 89)))
      (if (fneq (sample 90) 0.5) (snd-display #__line__ ";multi ramp 3 sample 90: ~A" (sample 90)))
      (undo)
      (ramp-channel 0.1 0.9 10 80)
      (if (not (string=? (safe-display-edits ind 0 12) "
 (ramp 10 80) ; ramp-channel 0.100 0.900 10 80 [12:11]:
   (at 0, cp->sounds[1][0:9, 0.500]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.100 -> 0.191]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.201 -> 0.292]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.303 -> 0.394]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.404 -> 0.495]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.505 -> 0.596]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.606 -> 0.697]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.708 -> 0.799]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.809 -> 0.900]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500]) [buf: 100] 
   (at 100, end_mark)
"))
	  (snd-display #__line__ ";multi-ramp 4: ~A" (safe-display-edits ind 0 12)))
      (revert-sound)
      (map-channel (lambda (y) 1.0) 0 100)
      (ramp-channel 0.0 1.0)
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(scale-channel 0.5 (* i 10) 10))
      (if (not (string=? (safe-display-edits ind 0 12) "
 (scale 90 10) ; scale-channel 0.500 90 10 [12:11]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 0.091]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.101 -> 0.192]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.202 -> 0.293]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.303 -> 0.394]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.404 -> 0.495]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.505 -> 0.596]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.606 -> 0.697]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.707 -> 0.798]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.808 -> 0.899]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, [1]0.909 -> 1.000]) [buf: 100] 
   (at 100, end_mark)
"))
	  (snd-display #__line__ ";multi-ramp 5: ~A" (safe-display-edits ind 0 12)))
      (close-sound ind))
    
    (let ((ind (open-sound "oboe.snd")))
      (if (not (= (redo 1 ind 0) 0)) (snd-display #__line__ ";open redo with no ops: ~A" (redo)))
      (if (not (= (undo 1 ind 0) 0)) (snd-display #__line__ ";open undo with no ops: ~A" (undo)))
      (set! (cursor) 1000)
      (delete-sample 321)
      (if (not (= (cursor) 999)) (snd-display #__line__ ";delete-sample before cursor: ~A" (cursor)))
      (if (not (= (cursor ind 0 0) 1000)) (snd-display #__line__ ";delete-sample before cursor (0): ~A" (cursor ind 0 0)))
      (undo)
      (if (not (= (cursor) 1000)) (snd-display #__line__ ";delete-sample after cursor undo: ~A" (cursor)))
      (undo -1)
      (if (not (= (cursor) 999)) (snd-display #__line__ ";delete-sample before cursor redo: ~A" (cursor)))
      (redo -1)
      (delete-sample 1321)
      (if (not (= (cursor) 1000)) (snd-display #__line__ ";delete-sample after cursor: ~A" (cursor)))
      (undo)
      (delete-samples 0 100)
      (if (not (= (cursor) 900)) (snd-display #__line__ ";delete-samples before cursor: ~A" (cursor)))
      (undo)
      (delete-samples 1100 100)
      (if (not (= (cursor) 1000)) (snd-display #__line__ ";delete-samples after cursor: ~A" (cursor)))
      (undo)
      (insert-samples 100 100 (make-float-vector 100))
      (if (not (= (cursor) 1100)) (snd-display #__line__ ";insert-samples before cursor: ~A" (cursor)))
      (undo)
      (insert-samples 1100 100 (make-float-vector 100))
      (if (not (= (cursor) 1000)) (snd-display #__line__ ";insert-samples after cursor: ~A" (cursor)))
      (undo)
      (set! (samples 0 100) (make-float-vector 100))
      (if (not (= (cursor) 1000)) (snd-display #__line__ ";set-samples cursor: ~A" (cursor)))
      (set! (show-axes ind 0) show-x-axis-unlabelled)
      (update-time-graph)
      (set! (show-axes ind 0) show-all-axes-unlabelled)
      (update-time-graph)
      (close-sound ind))
    
    (let ((ind (new-sound "test.snd" :size 100)))
      (float-vector->channel (make-float-vector 3 1.0) 10 8)
      (if (fneq (maxamp ind 0) 1.0)
	  (snd-display #__line__ ";float-vector->channel size mismatch maxamp: ~A" (maxamp ind 0)))
      (if (not (vequal (channel->float-vector 0 20 ind 0)
		       (float-vector 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)))
	  (snd-display #__line__ ";float-vector->channel size mismatch: ~A" (channel->float-vector 0 20 ind 0)))
      (revert-sound ind)
      (set! (samples 10 5) (make-float-vector 3 1.0))
      (if (fneq (maxamp ind 0) 1.0)
	  (snd-display #__line__ ";set samples size mismatch maxamp: ~A" (maxamp ind 0)))
      (if (not (vequal (channel->float-vector 0 20 ind 0)
		       (float-vector 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)))
	  (snd-display #__line__ ";set samples size mismatch: ~A" (channel->float-vector 0 20 ind 0)))
      (revert-sound ind)
      (insert-samples 10 8 (make-float-vector 3 1.0) ind 0)
      (if (fneq (maxamp ind 0) 1.0)
	  (snd-display #__line__ ";insert samples size mismatch maxamp: ~A" (maxamp ind 0)))
      (if (not (vequal (channel->float-vector 0 20 ind 0)
		       (float-vector 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)))
	  (snd-display #__line__ ";insert samples size mismatch: ~A" (channel->float-vector 0 20 ind 0)))
      (close-sound ind))
    
    (let* ((index (open-sound "oboe.snd"))
	   (bnds (x-bounds index))
	   (xp (x-position-slider))
	   (yp (y-position-slider))
	   (xz (x-zoom-slider))
	   (yz (y-zoom-slider)))
      (if (not (string=? (snd-completion " open-so") " open-sound"))
	  (snd-display #__line__ ";completion: ~A" (snd-completion " open-so")))
					;	(if (not (string=? (snd-completion " open-sound") " open-sound"))
					;	    (snd-display #__line__ ";completion: ~A" (snd-completion " open-so")))
      (if (not (string=? (snd-completion " zoom-focus-r") " zoom-focus-right"))
	  (snd-display #__line__ ";completion: ~A" (snd-completion " zoom-focus-r")))
      (play "oboe.snd" :wait #t)
      (play "oboe.snd" :start 12000 :wait #t)
      (play "oboe.snd" :start 12000 :end 15000 :wait #t)
      (play :edit-position (- (edit-position) 1) :wait #t)
      (let ((old-speed (speed-control index))
	    (old-style *speed-control-style*)
	    (old-open (show-controls index)))
	(set! (show-controls index) #t)
	(set! (speed-control index) -2.0)
	(play index :start 12345 :wait #t)
	(set! *speed-control-style* speed-control-as-semitone)
	(set! (speed-control index) 0.5)
	(set! *speed-control-style* speed-control-as-ratio)
	(set! (speed-control index) 0.25)
	(set! (speed-control index) old-speed)
	(set! *speed-control-style* old-style)
	(set! (show-controls index) old-open))
      (let ((k (disk-kspace "oboe.snd")))
	(if (or (not (number? k))
		(<= k 0))
	    (snd-display #__line__ ";disk-kspace = ~A" (disk-kspace "oboe.snd")))
	(set! k (disk-kspace "/baddy/hiho"))
	(if (not (= k -1))
	    (snd-display #__line__ ";disk-kspace of bogus file = ~A" (disk-kspace "/baddy/hiho"))))
      (if (not (= (transform-framples) 0)) (snd-display #__line__ ";transform-framples ~A?" (transform-framples)))
      (set! *transform-size* 512)
      
      (set! (transform-graph?) #t)
      (set! (time-graph?) #t)
      
      (if with-gui
	  (catch #t
	    (lambda ()
	      (if (not (string=? (x-axis-label) "time")) 
		  (snd-display #__line__ ";def time x-axis-label: ~A" (x-axis-label)))
	      (set! (x-axis-label index 0 time-graph) "no time")
	      (if (not (string=? (x-axis-label) "no time")) 
		  (snd-display #__line__ ";time x-axis-label: ~A" (x-axis-label index 0 time-graph)))
	      
	      (update-transform-graph)
	      (if (not (string=? (x-axis-label index 0 transform-graph) "frequency")) 
		  (snd-display #__line__ ";get fft x-axis-label: ~A" (x-axis-label index 0 transform-graph)))
	      (set! (x-axis-label index 0 transform-graph) "hiho")
	      (update-transform-graph)
	      (if (not (string=? (x-axis-label index 0 transform-graph) "hiho")) 
		  (snd-display #__line__ ";set fft x-axis-label: ~A" (x-axis-label index 0 transform-graph)))
	      (set! (x-axis-label index 0 transform-graph) "frequency") ; for later test
	      
	      (graph '(0 0 1 1 2 0) "lisp")
	      (update-lisp-graph)
	      (if (not (string=? (x-axis-label index 0 lisp-graph) "lisp")) 
		  (snd-display #__line__ ";def lisp x-axis-label: ~A" (x-axis-label index 0 lisp-graph)))
	      (set! (x-axis-label index 0 lisp-graph) "no lisp")
	      (if (not (string=? (x-axis-label index 0 lisp-graph) "no lisp")) 
		  (snd-display #__line__ ";lisp x-axis-label: ~A" (x-axis-label index 0 lisp-graph)))
	      
	      (set! (y-axis-label index 0 time-graph) "no amp")
	      (if (not (string=? (y-axis-label) "no amp"))
		  (snd-display #__line__ ";time y-axis-label: ~A" (y-axis-label index 0 time-graph)))
	      (set! (y-axis-label index 0 lisp-graph) "no lamp")
	      (if (not (string=? (y-axis-label index 0 lisp-graph) "no lamp")) 
		  (snd-display #__line__ ";lisp y-axis-label: ~A" (y-axis-label index 0 lisp-graph)))
	      (set! (y-axis-label) #f)
	      (set! (y-axis-label index 0) "no amp")
	      (if (not (string=? (y-axis-label) "no amp")) 
		  (snd-display #__line__ ";time y-axis-label (time): ~A" (y-axis-label index 0 time-graph)))
	      (set! (y-axis-label index) #f))
	    (lambda args (snd-display #__line__ ";axis label error: ~A" args))))
      
      (if with-gui
	  (begin
	    (let ((cr (make-cairo (car (channel-widgets index 0)))))
	      (graph-data (make-float-vector 4) index 0 copy-context #f #f graph-lines cr)
	      (free-cairo cr)
	      (update-lisp-graph))
	    (graph (float-vector 0 0 1 1 2 0))
	    (do ((i 0 (+ i 1))) 
		((= i 32)) 
	      (graph (float-vector 0 1 2)) 
	      (graph (list (float-vector 0 1 2) (float-vector 3 2 1) (float-vector 1 2 3)))
	      (graph (list (float-vector 0 1 2) (float-vector 3 2 1))))
	    (set! (x-bounds) (list 0.0 0.01))
	    (let ((data (make-graph-data)))
	      (if (float-vector? data)
		  (let ((mid (round (* .5 (length data)))))
		    (if (not (= (length data) (+ 1 (- (right-sample) (left-sample)))))
			(snd-display #__line__ ";make-graph-data bounds: ~A ~A -> ~A" (left-sample) (right-sample) (length data)))
		    (if (fneq (data mid)
			      (sample (+ (left-sample) mid)))
			(snd-display #__line__ ";make-graph-data[~D]: ~A ~A" mid (data mid) (sample (+ (left-sample) mid)))))))
	    (let ((data (make-graph-data index 0 0 100 199)))
	      (if (float-vector? data)
		  (begin
		    (if (not (= (length data) 100))
			(snd-display #__line__ ";make-graph-data 100:199: ~A" (length data)))
		    (if (fneq (data 50) (sample 50))
			(snd-display #__line__ ";make-graph-data 50: ~A ~A" (data 50) (sample 50))))))
	    (set! (x-bounds) (list 0.0 0.1))
	    (update-transform-graph)
	    (catch 'no-such-axis
	      (lambda ()
		(if (not (string=? (x-axis-label index 0 transform-graph) "frequency")) 
		    (snd-display #__line__ ";def fft x-axis-label: ~A" (x-axis-label index 0 transform-graph)))
		(set! (x-axis-label index 0 transform-graph) "fourier")
		(if (not (string=? (x-axis-label index 0 transform-graph) "fourier")) 
		    (snd-display #__line__ ";fft x-axis-label: ~A" (x-axis-label index 0 transform-graph)))
		(set! (x-axis-label) "hiho")
		
		(set! (y-axis-label index 0 transform-graph) "spectra")
		(let ((val (y-axis-label index 0 transform-graph)))
		  (if (or (not (string? val))
			  (not (string=? val "spectra")))
		      (snd-display #__line__ ";fft y-axis-label: ~A" val)))
		(set! (y-axis-label) "hiho"))
	      (lambda args (snd-display #__line__ ";transform axis not displayed?")))
	    ))
      
      (if (and (number? (transform-framples))
	       (= (transform-framples) 0))
	  (snd-display #__line__ ";transform-graph? transform-framples ~A?" (transform-framples)))
      (update-transform-graph)
      (let ((tag (catch #t (lambda () (peaks "/baddy/hiho")) (lambda args (car args)))))
	(if (not (eq? tag 'cant-open-file)) (snd-display #__line__ ";peaks bad file: ~A" tag)))
      (peaks "tmp.peaks")
      (let ((p (open-input-file "tmp.peaks")))
	(if (not p)
	    (snd-display #__line__ ";peaks->tmp.peaks failed?")
	    (let ((line (read-line p)))
	      (if (or (not (string? line))
		      (not (string=? "Snd: fft peaks" (substring line 0 14))))
		  (snd-display #__line__ ";peaks 1: ~A?" line))
	      (set! line (read-line p))
	      (set! line (read-line p))
	      (if (and (not (eof-object? line))
		       (or (not (string? line))
			   (and (not (string=? "oboe.snd, fft 512 points beginning at sample 0 (0.000 secs), Blackman2" line))
				(not (string=? (string-append "oboe.snd, fft 512 points beginning at sample 0 (0.000 secs), Blackman2" (string #\newline)) line)))))
		  (snd-display #__line__ ";peaks 2: ~A?" line))
	      (set! line (read-line p))
	      (set! line (read-line p))
	      (close-input-port p))))
      (delete-file "tmp.peaks")
      (peaks)
      (if (and (provided? 'xm) 
	       (or (not ((dialog-widgets) 15))
		   (not ((*motif* 'XtIsManaged) ((dialog-widgets) 15)))))
	  (snd-display #__line__ ";peaks but no help?"))
      (dismiss-all-dialogs)
      (let ((num-transforms 6)
	    (num-transform-graph-types 3))
	(set! (transform-graph? index 0) #t)
	(set! (transform-size index 0) 64)
	(do ((i 0 (+ i 1)))
	    ((= i num-transforms))
	  (set! *transform-type* (integer->transform i))
	  (if (not (transform? (integer->transform i))) (snd-display #__line__ ";transform? ~A?" i))
	  (do ((j 0 (+ j 1)))
	      ((= j num-transform-graph-types))
	    (set! (transform-graph-type index 0) j)
	    (update-transform-graph index 0))))
      (set! *transform-type* fourier-transform)
      (if (not (transform? *transform-type*)) (snd-display #__line__ ";transform? ~A ~A?" *transform-type* fourier-transform))
      (if (not (transform? autocorrelation)) (snd-display #__line__ ";transform? autocorrelation"))
      
      (if (read-only index) (snd-display #__line__ ";read-only open-sound: ~A?" (read-only index)))
      (set! (read-only index) #t)
      (if (not (read-only index)) (snd-display #__line__ ";set-read-only: ~A?" (read-only index)))
      (bind-key #\a 0 (lambda () (set! a-ctr 3)))
      (key (char->integer #\a) 0) 
      (if (not (= a-ctr 3)) (snd-display #__line__ ";bind-key: ~A?" a-ctr))
      (let ((str (with-output-to-string (lambda () (display (procedure-source (key-binding (char->integer #\a) 0)))))))
	(if (not (string=? str "(lambda () (set! a-ctr 3))"))
	    (snd-display #__line__ ";key-binding: ~A?" str)))
      (unbind-key (char->integer #\a) 0)
      (set! a-ctr 0)
      (key (char->integer #\a) 0) 
      (do ((i 0 (+ i 1)))
	  ((= i 5))
	(let ((psf *eps-file*))
	  (if (and psf (string? psf))
	      (begin
		(if (file-exists? psf) (delete-file psf))
		(set! *graph-style* i)
		(graph->ps)
		(if (not (file-exists? psf)) 
		    (snd-display #__line__ ";graph->ps: ~A?" psf)
		    (delete-file psf))))))
      (let ((err (catch 'cannot-print 
		   (lambda () 
		     (graph->ps "/bad/bad.eps"))
		   (lambda args 12345))))
	(if (not (= err 12345)) (snd-display #__line__ ";graph->ps err: ~A?" err)))
      (when with-gui
	(let ((n2 (or (open-sound "2.snd") (open-sound "4.aiff"))))
	  (set! (transform-graph? n2) #t)
	  (set! (channel-style n2) channels-superimposed)
	  (if (not (= (channel-style n2) channels-superimposed)) (snd-display #__line__ ";channel-style->~D: ~A?" channels-superimposed (channel-style n2)))
	  (graph->ps "aaa.eps")
	  (set! (channel-style n2) channels-combined)
	  (if (not (= (channel-style n2) channels-combined)) (snd-display #__line__ ";channel-style->~D: ~A?" channels-combined (channel-style n2)))
	  (graph->ps "aaa.eps")
	  (set! (channel-style n2) channels-separate)
	  (if (not (= (channel-style n2) channels-separate)) (snd-display #__line__ ";channel-style->~D: ~A?" channels-separate (channel-style n2)))
	  (graph->ps "aaa.eps")
	  (close-sound n2)))
      (if (= (channels index) 1)
	  (begin
	    (set! (channel-style index) channels-superimposed)
	    (if (not (= (channel-style index) channels-separate)) (snd-display #__line__ ";channel-style[0]->~D: ~A?" channels-separate (channel-style index)))))
      (set! (sync index) 32)
      (if (not (= (sync index) 32)) (snd-display #__line__ ";sync->32: ~A?" (sync index)))
      (if (< (sync-max) 32) (snd-display #__line__ ";sync-max 32: ~A" (sync-max)))
      (set! (sync index) 0)
      (set! (channel-sync index 0) 12)
      (if (not (= (channel-sync index 0) 12)) (snd-display #__line__ ";sync-chn->12: ~A?" (channel-sync index 0)))
      (set! (channel-sync index 0) 0)
      (if (not (= a-ctr 0)) (snd-display #__line__ ";unbind-key: ~A?" a-ctr))
      (if (fneq xp 0.0) (snd-display #__line__ ";x-position-slider: ~A?" xp))
      (if (fneq yp 0.0) (snd-display #__line__ ";y-position-slider: ~A?" yp))
      (if (and (fneq xz 0.04338) (fneq xz 1.0)) (snd-display #__line__ ";x-zoom-slider: ~A?" xz))
      (if (fneq yz 1.0) (snd-display #__line__ ";y-zoom-slider: ~A?" yz))
      (if (and (or (fneq (car bnds) 0.0) (fneq (cadr bnds) 0.1)) 
	       (or (fneq (car bnds) 0.0) (fneq (cadr bnds) 2.305))) ; open-hook from ~/.snd*
	  (snd-display #__line__ ";x-bounds: ~A?" bnds))
      (if (not (equal? (find-sound "oboe.snd") index)) (snd-display #__line__ ";oboe: index ~D is not ~D?" (find-sound "oboe.snd") index))
      (if (not (sound? index)) (snd-display #__line__ ";oboe: ~D not ok?" index))
      (if (not (= (chans index) 1)) (snd-display #__line__ ";oboe: chans ~D?" (chans index)))
      (if (not (= (channels index) 1)) (snd-display #__line__ ";oboe: channels ~D?" (channels index)))
      (if (not (= (framples index) 50828)) (snd-display #__line__ ";oboe: framples ~D?" (framples index)))
      (if (not (= (srate index) 22050)) (snd-display #__line__ ";oboe: srate ~D?" (srate index)))
      (if (not (= (data-location index) 28)) (snd-display #__line__ ";oboe: location ~D?" (data-location index)))
      (if (not (= (data-size index) (* 50828 2))) (snd-display #__line__ ";oboe: size ~D?" (data-size index)))
      (if (not (= (sample-type index) mus-bshort)) (snd-display #__line__ ";oboe: format ~A?" (sample-type index)))
      (if (fneq (maxamp index) .14724) (snd-display #__line__ ";oboe: maxamp ~F?" (maxamp index)))
      (if (not (= (maxamp-position index) 24971)) (snd-display #__line__ ";oboe: maxamp-position ~A?" (maxamp-position index)))
      (if (> (length (comment index)) 0) (snd-display #__line__ ";oboe: comment ~A?" (comment index)))
      (if (not (= (length "asdf") 4)) (snd-display #__line__ ";string-length: ~A?" (length "asdf")))
      (if (not (string=? (short-file-name index) "oboe.snd")) (snd-display #__line__ ";oboe short name: ~S?" (short-file-name index)))
      (let ((matches (count-matches (lambda (a) (> a .125)))))
	(if (not (= matches 1313)) (snd-display #__line__ ";count-matches: ~A?" matches)))
      (let ((spot (scan-channel (lambda (a) (> a .13)))))
	(if (or (not spot) (not (= spot 8862))) (snd-display #__line__ ";find: ~A?" spot)))
      (set! (right-sample) 3000) 
      (let ((samp (right-sample)))
	(if (> (abs (- samp 3000)) 1) (snd-display #__line__ ";right-sample: ~A?" samp)))
      (set! (left-sample) 1000) 
      (let ((samp (left-sample)))
	(if (> (abs (- samp 1000)) 1) (snd-display #__line__ ";left-sample: ~A?" samp)))
      (let ((eds (edits)))
	(if (not (= (car eds) 0 (cadr eds)))
	    (snd-display #__line__ ";edits: ~A?" eds))
	(if (not (= (edit-position) (car eds)))
	    (snd-display #__line__ ";edit-position: ~A ~A?" (edit-position) eds)))
      (play index :channel 0 :wait #t)
      
      (if (not *selection-creates-region*) (set! *selection-creates-region* #t))
      (select-all index 0) 
      (let ((r0 (car (regions)))
	    (sel (selection)))
	(if (not (selection?)) (snd-display #__line__ ";selection?"))
	(if (not (selection? sel)) (snd-display #__line__ ";selection? sel"))
	(if (not (region? r0)) (snd-display #__line__ ";region?"))
	(if (not (= (selection-chans) 1)) (snd-display #__line__ ";selection-chans(1): ~A" (selection-chans)))
	(if (not (= (channels sel) 1)) (snd-display #__line__ ";generic selection-chans(1): ~A" (channels sel)))
	(if (not (= (selection-srate) (srate index))) (snd-display #__line__ ";selection-srate: ~A ~A" (selection-srate) (srate index)))
	(if (not (= (srate sel) (srate index))) (snd-display #__line__ ";generic selection-srate: ~A ~A" (srate sel) (srate index)))
	(if (fneq (region-maxamp r0) (maxamp index)) (snd-display #__line__ ";region-maxamp (1): ~A?" (region-maxamp r0)))
	(if (not (= (region-maxamp-position r0) (maxamp-position index)))
	    (snd-display #__line__ ";region-maxamp-position (1): ~A ~A?" (region-maxamp-position r0) (maxamp-position index)))
	(if (fneq (selection-maxamp index 0) (maxamp index)) (snd-display #__line__ ";selection-maxamp (1): ~A?" (selection-maxamp index 0)))
	(if (fneq (maxamp sel index 0) (maxamp index)) (snd-display #__line__ ";generic selection-maxamp (1): ~A?" (maxamp sel index 0)))
	(if (not (= (selection-maxamp-position index 0) (maxamp-position index)))
	    (snd-display #__line__ ";selection-maxamp-position (1): ~A ~A?" (selection-maxamp-position index 0) (maxamp-position index)))
	(save-region r0 "temp.dat")
	(if (file-exists? "temp.dat")
	    (delete-file "temp.dat")
	    (snd-display #__line__ ";save-region file disappeared?"))
	(play r0 :wait #t) ;needs to be #t here or it never gets run
	(if (not (= (length (regions)) 1)) (snd-display #__line__ ";regions: ~A?" (regions)))
	(if (not (selection-member? index)) (snd-display #__line__ ";selection-member?: ~A" (selection-member? index)))
	(if (not (= (region-srate r0) 22050)) (snd-display #__line__ ";region-srate: ~A?" (region-srate r0)))
	(if (not (= (region-chans r0) 1)) (snd-display #__line__ ";region-chans: ~A?" (region-chans r0)))
	(if (not (equal? (region-home r0) (list "oboe.snd" 0 50827))) (snd-display #__line__ ";region-home: ~A" (region-home r0)))
	(if (not (= (region-framples r0) 50828)) (snd-display #__line__ ";region-framples: ~A?" (region-framples r0)))
	(if (not (= (selection-framples) 50828)) (snd-display #__line__ ";selection-framples: ~A?" (selection-framples 0)))
	(if (not (= (framples sel) 50828)) (snd-display #__line__ ";generic selection-framples: ~A?" (framples sel)))
	(if (not (= (length sel) 50828)) (snd-display #__line__ ";generic length selection-framples: ~A?" (length sel)))
	(if (not (= (selection-position) 0)) (snd-display #__line__ ";selection-position: ~A?" (selection-position)))
	(if (not (= (region-position r0 0) 0)) (snd-display #__line__ ";region-position: ~A?" (region-position r0 0)))
	(if (fneq (region-maxamp r0) (maxamp index)) (snd-display #__line__ ";region-maxamp: ~A?" (region-maxamp r0)))
	(if (fneq (selection-maxamp index 0) (maxamp index)) (snd-display #__line__ ";selection-maxamp: ~A?" (selection-maxamp index 0)))
	(let ((samps1 (channel->float-vector 0 50827 index 0))
	      (samps2 (region->float-vector r0 0 50828 0))
	      (vr (make-sampler 0 index 0 1)))
	  (if (not (sampler? vr)) (snd-display #__line__ ";~A not sampler?" vr))
	  (if (not (= (sampler-position vr) 0)) (snd-display #__line__ ";initial sampler-position: ~A" (sampler-position vr)))
	  (if (not (equal? (sampler-home vr) (list index 0))) 
	      (snd-display #__line__ ";sampler-home: ~A ~A?" (sampler-home vr) (list index 0)))
	  (if (sampler-at-end? vr) (snd-display #__line__ ";~A init at end?" vr))
	  (let ((err (catch #t
		       (lambda ()
			 (region->float-vector r0 -1 1233))
		       (lambda args (car args)))))
	    (if (not (eq? err 'no-such-sample)) (snd-display #__line__ ";region->float-vector -1: ~A" err)))
	  (let ((err (catch #t
		       (lambda ()
			 (region->float-vector r0 12345678 1))
		       (lambda args (car args)))))
	    ;; should this return 'no-such-sample?
	    (if err (snd-display #__line__ ";region->float-vector 12345678: ~A" err)))
	  (let ((reader-string (format #f "~A" vr)))
	    (if (not (string=? reader-string "#<sampler: oboe.snd[0: 0] from 0, at 0, forward>"))
		(snd-display #__line__ ";sampler actually got: [~S]" reader-string)))
	  (let ((evr vr))
	    (if (not (equal? evr vr)) (snd-display #__line__ ";sampler equal? ~A ~A" vr evr)))
	  (catch 'break
	    (lambda ()
	      (do ((i 0 (+ i 1)))
		  ((= i 50827))
		(if (not (= (if (odd? i) (next-sample vr) (read-sample vr)) (samps1 i) (samps2 i)))
		    (begin
		      (snd-display #__line__ ";readers disagree at ~D" i)
		      (throw 'break)))))
	    (lambda args (car args)))
	  (free-sampler vr)))
      (let ((var (catch #t (lambda () (make-sampler 0 index -1)) (lambda args args))))
	(if (not (eq? (car var) 'no-such-channel))
	    (snd-display #__line__ ";make-sampler bad chan (-1): ~A" var)))
      (let ((var (catch #t (lambda () (make-sampler 0 index 1)) (lambda args args))))
	(if (not (eq? (car var) 'no-such-channel))
	    (snd-display #__line__ ";make-sampler bad chan (1): ~A, ~A" var index)))
      (let ((fd (make-sampler 0)))
	(if (mix-sampler? fd) (snd-display #__line__ ";sampler: mix ~A" fd))
	(if (region-sampler? fd) (snd-display #__line__ ";sampler: region ~A" fd))
	(if (not (sampler? fd)) (snd-display #__line__ ";sampler: normal ~A" fd))
	(if (not (= (sampler-position fd) 0)) (snd-display #__line__ ";sampler: position: ~A" fd))
	(free-sampler fd)
	(let ((str (format #f "~A" fd)))
	  (if (not (string=? (substring str (- (length str) 16)) "at eof or freed>"))
	      (snd-display #__line__ ";freed sampler: ~A [~A]?" str (substring str (- (length str) 16))))))
      (let* ((reg (car (regions)))
	     (chns (region-chans reg))
	     (var (catch #t (lambda () (make-region-sampler reg 0 (+ chns 1))) (lambda args args))))
	(if (not (eq? (car var) 'no-such-channel))
	    (snd-display #__line__ ";make-region-sampler bad chan (2): ~A ~A" var (regions)))
	(let ((tag (catch #t (lambda () (make-region-sampler reg 0 0 -2)) (lambda args args))))
	  (if (not (eq? (car tag) 'no-such-direction))
	      (snd-display #__line__ ";make-region-sampler bad dir (-2): ~A" tag))))
      
      (revert-sound index)
      (insert-sample 100 .5 index) 
      (let ((var (catch #t (lambda () (insert-sound "oboe.snd" 0 1)) (lambda args args))))
	(if (not (eq? (car var) 'no-such-channel))
	    (snd-display #__line__ ";insert-sound bad chan (1): ~A" var)))
      (let ((var (catch #t (lambda () (insert-sample -12 1.0)) (lambda args args))))
	(if (not (eq? (car var) 'no-such-sample))
	    (snd-display #__line__ ";insert-sample bad pos: ~A" var)))
      (set! (show-axes index 0) show-no-axes)
      (update-transform-graph index) 
      (update-time-graph index) 
      (if (or (fneq (sample 100) .5)
	      (not (= (framples index) 50829)))
	  (snd-display #__line__ ";insert-sample: ~A ~A?" (sample 100) (framples index)))
      (let ((v0 (make-vector 3))
	    (v1 (make-float-vector 3)))
	(fill! v1 .75)
	(fill! v0 0.25)
	(insert-samples 200 3 v0 index) 
	(insert-samples 300 3 v1 index) 
	(if (or (fneq (sample 201) .25)
		(fneq (sample 301) .75)
		(not (= (framples index) 50835)))
	    (snd-display #__line__ ";insert-samples: ~A ~A ~A?" (sample 201) (sample 301) (framples index))))
      (save-sound-as "hiho.snd" index 22050 mus-ldouble mus-next)
      (let ((nindex (view-sound "hiho.snd")))
	(if (fneq (sample 101 nindex) (sample 101 index))
	    (snd-display #__line__ ";save-sound-as: ~A ~A?" (sample 101 nindex) (sample 101 index)))
	(if (not (read-only nindex)) (snd-display #__line__ ";read-only view-sound: ~A?" (read-only nindex)))
	
	(set! (speed-control-style nindex) speed-control-as-semitone)
	(if (not (= (speed-control-style nindex) speed-control-as-semitone))
	    (snd-display #__line__ ";speed-control-style set semi: ~A" (speed-control-style nindex)))
	(set! (speed-control-tones nindex) -8)
	(if (not (= (speed-control-tones nindex) 12))
	    (snd-display #__line__ ";speed-control-tones -8: ~A" (speed-control-tones nindex)))
	(set! (speed-control-tones nindex) 18)
	(if (not (= (speed-control-tones nindex) 18))
	    (snd-display #__line__ ";speed-control-tones 18: ~A" (speed-control-tones nindex)))
	(graph->ps "aaa.eps")
	(close-sound nindex))
      (revert-sound index)
      (set! (sample 50 index) .5) 
      (if (fneq (sample 50) .5) (snd-display #__line__ ";set-sample: ~A?" (sample 50)))
      (let ((v0 (make-vector 3 0.25)))
	(set! (samples 60 3 index) v0) 
	(if (or (fneq (sample 60) .25) (fneq (sample 61) .25))
	    (snd-display #__line__ ";set-samples: ~A ~A ~A?" (sample 60) (sample 61) (sample 62))))
      (set! (samples 10 3 index) (list 0.1 0.2 0.3))
      (if (not (vequal (channel->float-vector 10 3 index) (float-vector 0.1 0.2 0.3)))
	  (snd-display #__line__ ";set-samples via list: ~A" (channel->float-vector 10 3 index)))
      (revert-sound index)
      (save-sound-as "temporary.snd" index)
      (set! (samples 100000 20000 index) "temporary.snd")
      (if (not (vequal (channel->float-vector 110000 10) (channel->float-vector 10000 10)))
	  (snd-display #__line__ ";set samples to self: ~A ~A" (channel->float-vector 110000 10) (channel->float-vector 10000 10)))
      (revert-sound index)
      (delete-sample 100 index) 
      (if (not (file-exists? "temporary.snd"))
	  (snd-display #__line__ ";set-samples temp deleted?"))
      (delete-file "temporary.snd")
      (if (not (= (framples index) 50827)) (snd-display #__line__ ";delete-sample: ~A?" (framples index)))
      (delete-samples 0 100 index) 
      (if (not (= (framples index) 50727)) (snd-display #__line__ ";delete-samples: ~A?" (framples index)))
      (revert-sound index)
      (let ((maxa (maxamp index)))
	(scale-to .5 index) 
	(let ((newmaxa (maxamp index)))
	  (if (fneq newmaxa .5) (snd-display #__line__ ";scale-to: ~A?" newmaxa))
	  (undo 1 index) 
	  (scale-by 2.0 index) 
	  (set! newmaxa (maxamp index))
	  (if (fneq newmaxa (* 2.0 maxa)) (snd-display #__line__ ";scale-by: ~A?" newmaxa))
	  (revert-sound index)
	  (scale-by -1 index)
	  (mix "oboe.snd")
	  (if (fneq (maxamp index 0) 0.0) (snd-display #__line__ ";invert+mix->~A" (maxamp)))
	  (revert-sound index)
	  (select-all index) 
	  (if (not (= (length (regions)) 2)) (snd-display #__line__ ";regions(2): ~A?" (regions)))
	  (scale-selection-to .5) 
	  (set! newmaxa (maxamp index))
	  (if (fneq newmaxa .5) (snd-display #__line__ ";scale-selection-to: ~A?" newmaxa))
	  (revert-sound index)
	  (select-all index) 
	  (scale-selection-by 2.0) 
	  (set! newmaxa (maxamp index))
	  (if (fneq newmaxa (* 2.0 maxa)) (snd-display #__line__ ";scale-selection-by: ~A?" newmaxa))
	  (revert-sound index)
	  (with-temporary-selection (lambda () (scale-selection-by 2.0)) 0 (framples) index 0)
	  (set! newmaxa (maxamp index))
	  (if (fneq newmaxa (* 2.0 maxa)) (snd-display #__line__ ";with-temporary-selection: ~A?" newmaxa))
	  (revert-sound index)
	  (let ((samp999 (sample 999 index 0))
		(samp1001 (sample 1001 index 0)))
	    (with-temporary-selection (lambda () (scale-selection-to 2.0)) 1000 1 index 0)
	    (if (fneq (sample 1000 index 0) 2.0) (snd-display #__line__ ";with-temporary-selection 1000: ~A" (sample 1000 index 0)))
	    (if (fneq (sample 999 index 0) samp999) (snd-display #__line__ ";with-temporary-selection 999: ~A from ~A" (sample 999 index 0) samp999))
	    (if (fneq (sample 1001 index 0) samp1001) (snd-display #__line__ ";with-temporary-selection 1001: ~A from ~A" (sample 1001 index 0) samp1001)))
	  (revert-sound index)
	  (make-selection 100 199 index 0)
	  (let ((old-start (selection-position index 0))
		(old-len (selection-framples index 0)))
	    (with-temporary-selection (lambda () (scale-selection-to 2.0)) 1000 1 index 0)
	    (if (not (selection?)) (snd-display #__line__ ";with-temporary-selection restore?"))
	    (if (not (selection-member? index 0)) (snd-display #__line__ ";with-temporary-selection not member?"))
	    (if (not (= (selection-position index 0) old-start)) (snd-display #__line__ ";with-temporary-selection start: ~A" (selection-position index 0)))
	    (if (not (= (selection-framples index 0) old-len)) (snd-display #__line__ ";with-temporary-selection len: ~A" (selection-framples index 0))))
	  (unselect-all)
	  (if (selection-member? index 0) (snd-display #__line__ ";unselect all ~D 0?" index))
	  (revert-sound index)
	  (select-all index) 
	  (let ((rread (make-region-sampler (car (regions)) 0))
		(sread (make-sampler 0 index))
		(rvect (region->float-vector (car (regions)) 0 100))
		(svect (samples 0 100 index)))
	    (if (fneq (rvect 1) (region-sample (car (regions)) 1))
		(snd-display #__line__ ";region-sample: ~A ~A?" (region-sample (car (regions)) 1) (rvect 1)))
	    (do ((i 0 (+ i 1)))
		((= i 100))
	      (let ((rval (next-sample rread))
		    (sval (next-sample sread)))
		(if (fneq rval sval) (snd-display #__line__ ";sample-read: ~A ~A?" rval sval))
		(if (fneq rval (rvect i)) (snd-display #__line__ ";region-samples: ~A ~A?" rval (rvect i)))
		(if (fneq sval (svect i)) (snd-display #__line__ ";samples: ~A ~A?" sval (svect i)))))
	    (free-sampler rread) 
	    (let ((val0 (next-sample sread)))
	      (if (sampler-at-end? sread) (snd-display #__line__ ";premature end?"))
	      (previous-sample sread)
	      (let ((val1 (previous-sample sread)))
		(if (fneq val0 val1) (snd-display #__line__ ";previous-sample: ~A ~A?" val0 val1))))
	    (free-sampler sread))))
      (revert-sound index)
      (let ((s100 (sample 100))
	    (s40 (sample 40))
	    (len (framples))
	    (addlen (mus-sound-framples "fyow.snd")))
	(set! *cursor-style* cursor-line)
	(set! *cursor-size* 25)
	(set! (cursor index) 50) 
	(if (not (= *cursor-style* cursor-line))
	    (snd-display #__line__ ";cursor-style: ~A? " *cursor-style*))
	(if (not (= *cursor-size* 25))
	    (snd-display #__line__ ";cursor-size: ~A? " *cursor-size*))
	(set! *cursor-style* cursor-cross)
	(set! *cursor-size* 15)
	(set! (cursor index 0) 30) 
	(set! *cursor-style* cursor-line)
	(set! (cursor index 0) 20) 
	(if with-gui
	    (begin
	      (set! (cursor-style index 0)
		    (lambda (snd chn ax)
		      (let* ((point (cursor-position))
			     (x (car point))
			     (y (cadr point))
			     (size (floor (/ *cursor-size* 2)))
			     (cr (make-cairo (car (channel-widgets snd chn)))))
			(draw-line (- x size) (- y size) (+ x size) (+ y size) snd chn cursor-context cr)    
			(draw-line (- x size) (+ y size) (+ x size) (- y size) snd chn cursor-context cr)
			(free-cairo cr))))
	      (if (not (procedure? (cursor-style index 0))) (snd-display #__line__ ";set cursor-style to proc: ~A" (cursor-style index 0)))))
	(set! (cursor index) 50)
	(insert-sound "fyow.snd" (cursor) 0 index 0) 
	(if (or (fneq (sample 40) s40) (not (fneq (sample 100) s100)) (fneq (sample 100) 0.001831))
	    (snd-display #__line__ ";insert-sound: ~A?" (sample 100)))
	(if (not (= (framples) (+ len addlen))) (snd-display #__line__ ";insert-sound len: ~A?" (framples)))
	(save-sound-as "not-temporary.snd")
	(insert-samples 0 100 "not-temporary.snd")
	(set! (cursor index 0 0) (- (framples index 0 0) 2))
	(revert-sound)
	(if (not (= (cursor index 0) (- (framples index 0) 2)))
	    (snd-display #__line__ ";set edpos cursor: ~A ~A ~A" (cursor) (cursor index 0 0) (- (framples index 0 0) 2)))
	(if (not (file-exists? "not-temporary.snd"))
	    (snd-display #__line__ ";insert-samples deleted its file?")
	    (delete-file "not-temporary.snd"))
	(let ((id (make-region 0 99)))
	  (insert-region id 60 index) 
	  (if (not (= (framples) (+ len 100))) (snd-display #__line__ ";insert-region len: ~A?" (framples)))
	  (if (fneq (sample 100) s40) (snd-display #__line__ ";insert-region: ~A ~A?" (sample 100) s40))
	  (let ((var (catch #t (lambda () (insert-region (integer->region (+ 1000 (apply max (map region->integer (regions))))) 0)) (lambda args args))))
	    (if (not (eq? (car var) 'no-such-region))
		(snd-display #__line__ ";insert-region bad id: ~A" var)))
	  (save-region id "fmv.snd")
	  (if (not (= (mus-sound-header-type "fmv.snd") mus-next))
	      (snd-display #__line__ ";save-region header: ~A?" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
	  (if (not (= (mus-sound-sample-type "fmv.snd") mus-out-format))
	      (snd-display #__line__ ";save-region format: ~A?" (mus-sample-type-name (mus-sound-sample-type "fmv.snd"))))
	  (if (not (= (mus-sound-srate "fmv.snd") (region-srate id)))
	      (snd-display #__line__ ";save-region srate: ~A (~A)" (mus-sound-srate "fmv.snd") (region-srate id)))
	  (if (not (= (mus-sound-chans "fmv.snd") (region-chans id)))
	      (snd-display #__line__ ";save-region chans: ~A (~A)" (mus-sound-chans "fmv.snd") (region-chans id)))
	  (if (not (= (mus-sound-framples "fmv.snd") (region-framples id)))
	      (snd-display #__line__ ";save-region length: ~A (~A)" (mus-sound-framples "fmv.snd") (region-framples id)))
	  (if (not (= (region-position id 0) 0))
	      (snd-display #__line__ ";save-region position: ~A" (region-position id 0)))
	  (delete-file "fmv.snd")
	  (save-region id "fmv.snd" mus-lshort mus-riff "this is a comment")
	  (if (not (= (mus-sound-header-type "fmv.snd") mus-riff))
	      (snd-display #__line__ ";save-region riff header: ~A?" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
	  (if (not (= (mus-sound-sample-type "fmv.snd") mus-lshort))
	      (snd-display #__line__ ";save-region lshort format: ~A?" (mus-sample-type-name (mus-sound-sample-type "fmv.snd"))))
	  (if (not (= (mus-sound-framples "fmv.snd") (region-framples id)))
	      (snd-display #__line__ ";save-region length: ~A (~A)" (mus-sound-framples "fmv.snd") (region-framples id)))
	  (if (not (string=? (mus-sound-comment "fmv.snd") "this is a comment"))
	      (snd-display #__line__ ";save-region comment: ~A" (mus-sound-comment "fmv.snd")))
	  (delete-file "fmv.snd")
	  (save-region id :file "fmv.snd" :header-type mus-riff :sample-type mus-lshort :comment "this is a comment")
	  (if (not (= (mus-sound-header-type "fmv.snd") mus-riff))
	      (snd-display #__line__ ";save-region opt riff header: ~A?" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
	  (if (not (= (mus-sound-sample-type "fmv.snd") mus-lshort))
	      (snd-display #__line__ ";save-region opt lshort format: ~A?" (mus-sample-type-name (mus-sound-sample-type "fmv.snd"))))
	  (if (not (= (mus-sound-framples "fmv.snd") (region-framples id)))
	      (snd-display #__line__ ";save-region opt length: ~A (~A)" (mus-sound-framples "fmv.snd") (region-framples id)))
	  (if (not (string=? (mus-sound-comment "fmv.snd") "this is a comment"))
	      (snd-display #__line__ ";save-region opt comment: ~A" (mus-sound-comment "fmv.snd")))
	  (delete-file "fmv.snd")
	  (save-region id :comment "this is a comment" :file "fmv.snd" :sample-type mus-lshort :header-type mus-riff)
	  (if (not (= (mus-sound-header-type "fmv.snd") mus-riff))
	      (snd-display #__line__ ";save-region opt1 riff header: ~A?" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
	  (if (not (= (mus-sound-sample-type "fmv.snd") mus-lshort))
	      (snd-display #__line__ ";save-region opt1 lshort format: ~A?" (mus-sample-type-name (mus-sound-sample-type "fmv.snd"))))
	  (if (not (= (mus-sound-framples "fmv.snd") (region-framples id)))
	      (snd-display #__line__ ";save-region opt1 length: ~A (~A)" (mus-sound-framples "fmv.snd") (region-framples id)))
	  (if (not (string=? (mus-sound-comment "fmv.snd") "this is a comment"))
	      (snd-display #__line__ ";save-region opt1 comment: ~A" (mus-sound-comment "fmv.snd")))
	  (delete-file "fmv.snd")
	  (save-region id "fmv.snd" :sample-type mus-bshort)
	  (if (not (= (mus-sound-header-type "fmv.snd") mus-next))
	      (snd-display #__line__ ";save-region opt2 next header: ~A?" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
	  (if (not (= (mus-sound-sample-type "fmv.snd") mus-bshort))
	      (snd-display #__line__ ";save-region opt2 bshort format: ~A?" (mus-sample-type-name (mus-sound-sample-type "fmv.snd"))))
	  (delete-file "fmv.snd")
	  ))
      (close-sound index)
      (let ((var (catch #t (lambda () (new-sound "hi.snd" :channels 0)) (lambda args args))))
	(if (or (not (pair? var))
		(not (eq? (car var) 'out-of-range)))
	    (snd-display #__line__ ";new-sound bad chan: ~A" var)))
      (set! index (new-sound "fmv.snd" 2 22050 mus-ldouble mus-next "unequal lens"))
      (insert-silence 0 1000 index 1)
      (if (or (not (= (framples index 0) 1))
	      (not (= (framples index 1) 1001)))
	  (snd-display #__line__ ";silence 1: ~A ~A" (framples index 0) (framples index 1)))
      (save-sound index)
      (if (or (not (= (framples index 0) 1001))
	      (not (= (framples index 1) 1001)))
	  (snd-display #__line__ ";saved silence 1: ~A ~A" (framples index 0) (framples index 1)))
      (if (not (= (mus-sound-framples "fmv.snd") 1001))
	  (snd-display #__line__ ";saved framers silence 1: ~A" (mus-sound-framples "fmv.snd")))
      (let ((v0 (channel->float-vector 0 1000 index 0))
	    (v1 (channel->float-vector 0 1000 index 1)))
	(if (fneq (float-vector-peak v0) 0.0)
	    (snd-display #__line__ ";auto-pad 0: ~A" (float-vector-peak v0)))
	(if (fneq (float-vector-peak v1) 0.0)
	    (snd-display #__line__ ";silence 0: ~A" (float-vector-peak v1))))
      (close-sound index)
      (delete-file "fmv.snd")
      
      (set! index (new-sound "fmv.snd" 2 22050 mus-ldouble mus-next "unequal lens"))
      (pad-channel 0 1000 index 1)
      (if (or (not (= (framples index 0) 1))
	      (not (= (framples index 1) 1001)))
	  (snd-display #__line__ ";pad-channel 1: ~A ~A" (framples index 0) (framples index 1)))
      (let ((v0 (channel->float-vector 0 1000 index 0))
	    (v1 (channel->float-vector 0 1000 index 1)))
	(if (fneq (float-vector-peak v0) 0.0)
	    (snd-display #__line__ ";pad 0: ~A" (float-vector-peak v0)))
	(if (fneq (float-vector-peak v1) 0.0)
	    (snd-display #__line__ ";pad 1: ~A" (float-vector-peak v1))))
      (map-channel (lambda (n) 1.0) 0 2 index 0)
      (map-channel (lambda (n) 1.0) 0 1002 index 1)
      (pad-channel 0 1000 index 0 1)
      (if (not (= (framples index 1) 1002))
	  (snd-display #__line__ ";pad-channel ed 1: ~A ~A" (framples index 0) (framples index 1)))
      (close-sound index)
      (delete-file "fmv.snd")
      
      (let ((ind (open-sound "1a.snd")))
	(scale-to 1.0 ind 0)
	(make-selection 1000 2000 ind 0)
	(filter-selection-and-smooth .01 (float-vector .25 .5 .5 .5 .25))
					;	  (if (fneq (sample 1500 ind 0) -0.0045776) (snd-display #__line__ ";filter-selection-and-smooth: ~A" (sample 1500 ind 0)))
	(revert-sound ind)
	(close-sound ind))
      
      (set! index (new-sound "fmv.snd" 1 22050 mus-bshort mus-ircam "this is a comment"))
      (let ((v0 (make-float-vector 128)))
	(set! (v0 64) .5)
	(set! (v0 127) .5)
	(float-vector->channel v0 0 128 index 0)
	(make-selection 0 126) 
	(smooth-selection) 
	(set! v0 (channel->float-vector 0 128 index 0))
	(if (or (fneq (sample 127) .5) (fneq (sample 120) .4962) (fneq (sample 32) 0.07431) (fneq (sample 64) 0.25308))
	    (snd-display #__line__ ";smooth-selection: ~A?" v0))
	(revert-sound index)
	(fill! v0 0.0)
	(set! (v0 10) .5)
	
	(float-vector->channel v0)
	(select-all) 
	(let ((old-wid *sinc-width*))
	  (set! *sinc-width* 40)
	  (src-selection 0.5) 
	  (set! *sinc-width* old-wid))
	(set! v0 (channel->float-vector 0 128 index 0))
	(if (or (fneq (sample 20) .5) (fneq (sample 30) 0.0) (fneq (sample 17) -.1057) )
	    (snd-display #__line__ ";src-selection: ~A?" v0))
	(unselect-all)
	(if (selection-member?) (snd-display #__line__ ";unselect-all but still a selection?"))
	(unselect-all)
	(revert-sound index)
	(fill! v0 0.0)
	(set! (v0 10) .5)
	(float-vector->channel v0 0)
	(select-all) 
	(filter-selection '(0 0 .1 1 1 0) 40) 
	(set! v0 (channel->float-vector 0 128 index 0)) 
	(if (or (fneq (sample 29) .1945) (fneq (sample 39) -.0137) (fneq (sample 24) -0.01986))
	    (snd-display #__line__ ";filter-selection: ~A?" v0))
	(revert-sound index)
	(fill! v0 1.0)
	(float-vector->channel v0 0 128 index 0) 
	(select-all) 
	(filter-selection (make-one-zero :a0 .5 :a1 0.0))
	(set! v0 (channel->float-vector 0 128 index 0)) 
	(if (or (fneq (sample 29) .5) (fneq (sample 39) .5) (fneq (sample 24) 0.5))
	    (snd-display #__line__ ";filter-selection one-zero: ~A?" v0))
	(revert-sound index)
	(fill! v0 1.0)
	(float-vector->channel v0 0 128 index 0) 
	(if (file-exists? "fmv5.snd") (delete-file "fmv5.snd"))
	(select-all) 
	(env-selection '(0 0 1 1 2 0) 1.0) 
	(set! v0 (channel->float-vector 0 128 index 0)) 
	(if (or (fneq (sample 64) 1.0) (fneq (sample 20) .3125) (fneq (sample 119) 0.127))
	    (snd-display #__line__ ";env-selection [len: ~A]: ~A ~A ~A ~A?" (selection-framples) (sample 64) (sample 20) (sample 119) v0))
	(save-selection "fmv5.snd" 22050 mus-bint mus-next "") ;1.0->-1.0 if short
	(revert-sound index)
	(let ((tag (catch #t (lambda () (file->array "/baddy/hiho" 0 0 128 v0)) (lambda args (car args)))))
	  (if (not (eq? tag 'no-such-file)) (snd-display #__line__ ";file->array w/o file: ~A" tag)))
	(let ((tag (catch #t (lambda () (file->array "fmv5.snd" 123 0 128 v0)) (lambda args (car args)))))
	  (if (not (eq? tag 'no-such-channel)) (snd-display #__line__ ";file->array w/o channel: ~A" tag)))
	(file->array "fmv5.snd" 0 0 128 v0) 
	(if (or (fneq (v0 64) 1.0) (fneq (v0 20) .3125) (fneq (v0 119) 0.127))
	    (snd-display #__line__ ";save-selection: ~A ~A ~A ~A?" (v0 64) (v0 20) (v0 119) v0))
	(if (not (= (mus-sound-header-type "fmv5.snd") mus-next))
	    (snd-display #__line__ ";save-selection type: ~A?" (mus-header-type-name (mus-sound-header-type "fmv5.snd"))))
	(if (not (= (mus-sound-sample-type "fmv5.snd") mus-bint))
	    (snd-display #__line__ ";save-selection format: ~A?" (mus-sample-type-name (mus-sound-sample-type "fmv5.snd"))))
	(if (not (= (mus-sound-srate "fmv5.snd") 22050))
	    (snd-display #__line__ ";save-selection srate: ~A?" (mus-sound-srate "fmv5.snd")))
	(fill! v0 0.0)
	(set! (v0 100) .5)
	(set! (v0 2) -.5)
	(float-vector->channel v0 0 128 index 0) 
	(select-all) 
	(without-errors (reverse-selection)) 
	(save-selection "fmv4.snd" 44100 mus-lfloat mus-riff "this is a comment")
	(set! v0 (channel->float-vector 0 128 index 0)) 
	(if (or (fneq (sample 27) 0.5) (fneq (sample 125) -.5))
	    (snd-display #__line__ ";reverse-selection: ~A?" v0))
	(file->array "fmv4.snd" 0 0 128 v0) 
	(if (or (fneq (sample 27) 0.5) (fneq (sample 125) -.5))
	    (snd-display #__line__ ";save reverse-selection: ~A?" v0))
	(if (not (= (mus-sound-header-type "fmv4.snd") mus-riff))
	    (snd-display #__line__ ";save-selection type 1: ~A?" (mus-header-type-name (mus-sound-header-type "fmv4.snd"))))
	(if (not (= (mus-sound-sample-type "fmv4.snd") mus-lfloat))
	    (snd-display #__line__ ";save-selection format 1: ~A?" (mus-sample-type-name (mus-sound-sample-type "fmv4.snd"))))
	(if (not (= (mus-sound-srate "fmv4.snd") 44100))
	    (snd-display #__line__ ";save-selection srate 1: ~A?" (mus-sound-srate "fmv4.snd")))
	(if (not (string=? (mus-sound-comment "fmv4.snd") "this is a comment"))
	    (snd-display #__line__ ";save-selection comment: ~A?" (mus-sound-comment "fmv4.snd")))
	(delete-file "fmv4.snd")
	(save-selection :file "fmv4.snd" :header-type mus-riff :sample-type mus-lfloat :srate 44100 :comment "this is a comment")
	(if (not (= (mus-sound-header-type "fmv4.snd") mus-riff))
	    (snd-display #__line__ ";save-selection opt type 1: ~A?" (mus-header-type-name (mus-sound-header-type "fmv4.snd"))))
	(if (not (= (mus-sound-sample-type "fmv4.snd") mus-lfloat))
	    (snd-display #__line__ ";save-selection opt format 1: ~A?" (mus-sample-type-name (mus-sound-sample-type "fmv4.snd"))))
	(if (not (= (mus-sound-srate "fmv4.snd") 44100))
	    (snd-display #__line__ ";save-selection opt srate 1: ~A?" (mus-sound-srate "fmv4.snd")))
	(if (not (string=? (mus-sound-comment "fmv4.snd") "this is a comment"))
	    (snd-display #__line__ ";save-selection opt comment: ~A?" (mus-sound-comment "fmv4.snd")))
	(delete-file "fmv4.snd")
	(save-selection :file "fmv4.snd" :sample-type mus-bfloat :channel 0)
	(if (and (not (= (mus-sound-header-type "fmv4.snd") mus-next))
		 (not (= (mus-sound-header-type "fmv4.snd") mus-ircam)))
	    (snd-display #__line__ ";save-selection opt1 type 1: ~A?" (mus-header-type-name (mus-sound-header-type "fmv4.snd"))))
	(if (not (= (mus-sound-sample-type "fmv4.snd") mus-bfloat))
	    (snd-display #__line__ ";save-selection opt1 format 1: ~A?" (mus-sample-type-name (mus-sound-sample-type "fmv4.snd"))))
	(if (not (= (mus-sound-chans "fmv4.snd") 1))
	    (snd-display #__line__ ";save-selection opt1 chans: ~A?" (mus-sound-chans "fmv4.snd")))
	(delete-file "fmv4.snd")
	(revert-sound index)
	(fill! v0 0.0)
	(set! (v0 2) 1.0)
	(let ((v1 (make-float-vector 256)))
	  (copy v0 v1 0 128)
	  (float-vector->channel v1 0 128 index 0))
	(select-all)
	(if (mus-clipping) (set! (mus-clipping) #f))
	(if *clipping* (set! *clipping* #f))
	(convolve-selection-with "fmv5.snd" .5) 
	(set! v0 (channel->float-vector 0 128 index 0))
	(if (fneq (sample 66) -.5) (snd-display #__line__ ";convolve-selection-with: ~A ~A ~A?" (v0 66) (sample 66) v0))
	(close-sound index))
      (let* ((obind (open-sound "oboe.snd"))
	     (vol (maxamp obind))
	     (dur (framples)))
	(when with-gui
	  (set! (amp-control obind) 2.0)
	  (if (fffneq (amp-control obind) 2.0) (snd-display #__line__ ";set amp-control ~A" (amp-control obind)))
	  (reset-controls obind)
	  (if (ffneq (amp-control obind) 1.0) (snd-display #__line__ ";reset amp-control ~A" (amp-control obind)))
	  (set! (amp-control-bounds obind) (list 0.0 4.0))
	  (if (not (equal? (amp-control-bounds obind) (list 0.0 4.0))) (snd-display #__line__ ";amp-control-bounds: ~A" (amp-control-bounds)))
	  (set! (amp-control obind) 2.0)
	  (if (eq? (without-errors (apply-controls obind)) 'no-such-sound) (snd-display #__line__ ";apply-controls can't find oboe.snd?"))
	  (let ((newamp (maxamp obind)))
	    (if (> (abs (- (* 2.0 vol) newamp)) .05) (snd-display #__line__ ";apply amp: ~A -> ~A?" vol newamp))
	    (set! (amp-control-bounds obind) (list 0.0 8.0))
	    (set! (speed-control-bounds obind) (list 1.0 5.0))
	    (if (not (equal? (speed-control-bounds obind) (list 1.0 5.0))) (snd-display #__line__ ";speed-control-bounds: ~A" (speed-control-bounds)))
	    (set! (speed-control obind) 0.5)
	    (set! (speed-control-bounds obind) (list .05 20.0))
	    (add-mark 1234)
	    (apply-controls obind)
	    (let ((newdur (framples obind)))
	      (set! (speed-control obind) 1.0)
	      (if (>= (- newdur (* 2.0 dur)) 256) (snd-display #__line__ ";apply speed: ~A -> ~A?" dur newdur))
	      ;; within 256 which is apply's buffer size (it always flushes full buffers) 
	      (set! (contrast-control? obind) #t)
	      (set! (contrast-control-bounds obind) (list 0.5 2.5))
	      (if (not (equal? (contrast-control-bounds obind) (list 0.5 2.5))) (snd-display #__line__ ";contrast-control-bounds: ~A" (contrast-control-bounds)))
	      (set! (contrast-control obind) 1.0)
	      (apply-controls obind)
	      (set! (contrast-control-bounds obind) (list 0.0 10.0))
	      (if (not (equal? (contrast-control-bounds obind) (list 0.0 10.0))) (snd-display #__line__ ";contrast-control-bounds (2): ~A" (contrast-control-bounds)))
	      (let ((secamp (maxamp obind))
		    (secdur (framples obind)))
		(if (fneq secamp .989) (snd-display #__line__ ";apply contrast: ~A?" secamp))
		(if (not (= secdur newdur)) (snd-display #__line__ ";apply contrast length: ~A -> ~A?" newdur secdur)))
	      (undo 3 obind)
	      (set! (reverb-control? obind) #t)
	      (set! (reverb-control-scale-bounds obind) (list 0.0 1.0))
	      (if (not (equal? (reverb-control-scale-bounds obind) (list 0.0 1.0))) 
		  (snd-display #__line__ ";reverb-control-scale-bounds: ~A" (reverb-control-scale-bounds)))
	      (set! (reverb-control-length-bounds obind) (list 0.0 2.0))
	      (if (not (equal? (reverb-control-length-bounds obind) (list 0.0 2.0))) 
		  (snd-display #__line__ ";reverb-control-length-bounds: ~A" (reverb-control-length-bounds)))
	      (set! (reverb-control-scale obind) .2)
	      (let ((nowamp (maxamp obind)))
		(apply-controls obind)
		(let ((revamp (maxamp obind))
		      (revdur (framples obind)))
		  (if (ffneq revamp .214) 
		      (snd-display #__line__ ";apply reverb scale: ~A at ~A, scale: ~A previous max: ~A?" 
				   revamp (maxamp-position obind) (reverb-control-scale obind) nowamp))
		  (if (>= (- revdur (+ 50828 (round (* *reverb-control-decay* 22050)))) 256) 
		      (snd-display #__line__ ";apply reverb length: ~A?" revdur))))
	      (undo 1 obind)
	      (set! (expand-control? obind) #t)
	      (set! (expand-control-bounds obind) (list 1.0 3.0))
	      (if (not (equal? (expand-control-bounds obind) (list 1.0 3.0))) (snd-display #__line__ ";expand-control-bounds: ~A" (expand-control-bounds)))
	      (set! (expand-control obind) 1.5)
	      (apply-controls obind)
	      (let ((expamp (maxamp obind))
		    (expdur (framples obind)))
		(if (> (abs (- expamp .152)) .05) (snd-display #__line__ ";apply expand-control scale: ~A?" expamp))
		(if (<= expdur (* 1.25 50828)) (snd-display #__line__ ";apply expand-control length: ~A?" expdur))
		(set! (expand-control-bounds obind) (list 0.001 20.0)))
	      (undo 1 obind)
	      (set! (filter-control? obind) #t)
	      (set! (filter-control-order obind) 40)
	      (set! (filter-control-envelope obind) '(0 0 1 .5 2 0))
	      (apply-controls obind)
	      (let ((fltamp (maxamp obind))
		    (fltdur (framples obind)))
		(if (> (abs (- fltamp .02)) .005) (snd-display #__line__ ";apply filter scale: ~A?" fltamp))
		(if (> (- fltdur (+ 40 50828)) 256) (snd-display #__line__ ";apply filter length: ~A?" fltdur))
		(undo 1 obind)))))
	
	(revert-sound obind)
	(make-selection 1000 1000)
	(scale-selection-to .1)
	(scale-selection-by 2.0)
	(make-selection 2000 2001)
	(scale-selection-by 2.0)
	(scale-selection-to .5)
	(make-selection 1000 2001)
	(scale-selection-to .5)
	(scale-selection-by .5)
	(make-selection 2000 2000)
	(scale-selection-by 2.0)
	(scale-selection-to .5)
	(make-selection 1000 1001)
	(scale-selection-to .1)
	(scale-selection-by 2.0)
	(make-selection 999 2002)
	(scale-selection-to 1.0)
	(scale-selection-by .5)
	(let ((tree (edit-tree))
	      (true-tree '((0 0 0 998 1.0 0.0 0.0 0) 
			   (999 0 999 999 0.999969720840454 0.0 0.0 0) 
			   (1000 0 1000 1000 6.09052181243896 0.0 0.0 0) 
			   (1001 0 1001 1001 0.999969720840454 0.0 0.0 0) 
			   (1002 0 1002 1999 0.499984979629517 0.0 0.0 0) 
			   (2000 0 2000 2000 7.54652404785156 0.0 0.0 0) 
			   (2001 0 2001 2001 3.7732629776001 0.0 0.0 0) 
			   (2002 0 2002 2002 0.999969720840454 0.0 0.0 0) 
			   (2003 0 2003 50827 1.0 0.0 0.0 0) 
			   (50828 -2 0 0 0.0 0.0 0.0 0))))
	  (if (not (= (length tree) (length true-tree)))
	      (snd-display #__line__ ";edit trees are not same length: ~A ~A?" (length tree) (length true-tree))
	      (let ((len (length tree)))
		(do ((i 0 (+ i 1)))
		    ((= i len))
		  (let ((branch (tree i))
			(true-branch (true-tree i)))
		    (if (or (not (= (car branch) (car true-branch)))
			    (not (= (cadr branch) (cadr true-branch)))
			    (not (= (caddr branch) (caddr true-branch)))
			    (not (= (cadddr branch) (cadddr true-branch)))
			    (fneq (branch 4) (true-branch 4)))
			(snd-display #__line__ ";edit trees disagree at ~D: ~A ~A" i branch true-branch)))))))
	(insert-silence 1001 8)
	(insert-silence 900 50)
	(insert-silence 2005 1)
	(insert-silence 999 2)
	(let ((tree (edit-tree))
	      (true-tree '((0 0 0 899 1.0 0.0 0.0 0) 
			   (900 -1 0 49 0.0 0.0 0.0 0) 
			   (950 0 900 948 1.0 0.0 0.0 0) 
			   (999 -1 0 1 0.0 0.0 0.0 0) 
			   (1001 0 949 998 1.0 0.0 0.0 0) 
			   (1051 0 999 999 0.999969720840454 0.0 0.0 0) 
			   (1052 0 1000 1000 6.09052181243896 0.0 0.0 0) 
			   (1053 -1 0 7 0.0 0.0 0.0 0) 
			   (1061 0 1001 1001 0.999969720840454 0.0 0.0 0)
			   (1062 0 1002 1946 0.499984979629517 0.0 0.0 0) 
			   (2007 -1 0 0 0.0 0.0 0.0 0) 
			   (2008 0 1947 1999 0.499984979629517 0.0 0.0 0) 
			   (2061 0 2000 2000 7.54652404785156 0.0 0.0 0) 
			   (2062 0 2001 2001 3.7732629776001 0.0 0.0 0) 
			   (2063 0 2002 2002 0.999969720840454 0.0 0.0 0) 
			   (2064 0 2003 50827 1.0 0.0 0.0 0) 
			   (50889 -2 0 0 0.0 0.0 0.0 0))))
	  (if (not (= (length tree) (length true-tree)))
	      (snd-display #__line__ ";silenced edit trees are not same length: ~A ~A?" (length tree) (length true-tree))
	      (let ((len (length tree)))
		(do ((i 0 (+ i 1)))
		    ((= i len))
		  (let ((branch (tree i))
			(true-branch (true-tree i)))
		    (if (or (not (= (car branch) (car true-branch)))
			    (not (= (cadr branch) (cadr true-branch)))
			    (not (= (caddr branch) (caddr true-branch)))
			    (not (= (cadddr branch) (cadddr true-branch)))
			    (fneq (branch 4) (true-branch 4)))
			(snd-display #__line__ ";silenced edit trees disagree at ~D: ~A ~A" i branch true-branch)))))))
	(if (or (fneq (sample 998) -.03)
		(fneq (sample 999) 0.0)
		(fneq (sample 1000) 0.0)
		(fneq (sample 1001) -.03))
	    (snd-display #__line__ ";insert-silence [999 for 2]: ~A ~A ~A ~A?" (sample 998) (sample 999) (sample 1000) (sample 1001) ))
	(if (or (fneq (sample 2006) -.033)
		(fneq (sample 2007) 0.0)
		(fneq (sample 2008) -.033))
	    (snd-display #__line__ ";insert-silence [2007 for 1]: ~A ~A ~A?" (sample 2006) (sample 2007) (sample 2008)))
	(revert-sound obind)
	(add-mark 1200 obind 0)
	(let ((mark-num (length (marks obind 0))))
	  (scale-by 2.0 obind 0)
	  (let ((mark-now (length (marks obind 0))))
	    (if (not (= mark-num mark-now))
		(snd-display #__line__ ";mark lost after scaling?"))
	    (set! (selection-position) 0)
	    (set! (selection-framples) 100)
	    (scale-selection-to .5)
	    (set! mark-now (length (marks obind 0)))
	    (if (not (= mark-num mark-now))
		(snd-display #__line__ ";mark lost after selection scaling?")))
	  (let ((m1 (add-mark 1000)))
	    (set! (cursor obind 0) 100)
	    (key (char->integer #\u) 4 obind)
	    (key (char->integer #\1) 0 obind)
	    (key (char->integer #\0) 0 obind)
	    (key (char->integer #\0) 0 obind)
	    (key (char->integer #\o) 4 obind)
	    (if (not (= (mark-sample m1) 1100))
		(snd-display #__line__ ";mark after zeros: ~D (1100)? " (mark-sample m1)))
	    (set! (cursor obind) 0)
	    (key (char->integer #\j) 4 obind)
	    (if (not (= (cursor obind) 1100)) (snd-display #__line__ ";c-j to ~A" (cursor obind)))
	    (add-mark 100)
	    (set! (cursor obind) 0)
	    (key (char->integer #\u) 4 obind)
	    (key (char->integer #\2) 0 obind)
	    (key (char->integer #\j) 4 obind)
	    (if (not (= (cursor obind) 1100)) (snd-display #__line__ ";c-u 2 c-j ~A" (cursor obind)))
	    (key (char->integer #\-) 4 obind)
	    (key (char->integer #\j) 4 obind)
	    (if (not (= (cursor obind) 100)) (snd-display #__line__ ";c-- c-j ~A" (cursor obind)))))
	(revert-sound obind)
	(let ((frs (framples obind)))
	  (make-region 0 999 obind 0)
	  (if (not (selection?)) (snd-display #__line__ ";make-region but no selection? ~A" (selection?)))
	  (delete-selection)
	  (if (not (= (framples obind) (- frs 1000)))
	      (snd-display #__line__ ";delete-selection: ~A?" (framples obind)))
	  (let ((val (sample 0 obind 0)))
	    (undo)
	    (if (fneq (sample 1000) val)
		(snd-display #__line__ ";delete-selection val: ~A ~A" val (sample 1000)))
	    (insert-selection)
	    (let ((var (catch #t (lambda () (insert-selection 0 obind 123)) (lambda args args))))
	      (if (not (eq? (car var) 'no-such-channel))
		  (snd-display #__line__ ";insert-selection bad chan: ~A" var)))
	    (let ((var (catch #t (lambda () (mix-selection 0 obind 123)) (lambda args args))))
	      (if (not (eq? (car var) 'no-such-channel))
		  (snd-display #__line__ ";mix-selection bad chan: ~A" var)))
	    (if (not (= (framples obind) (+ frs 1000)))
		(snd-display #__line__ ";insert-selection: ~A?" (framples obind)))
	    (if (fneq (sample 2000) val)
		(snd-display #__line__ ";insert-selection val: ~A ~A" val (sample 2000)))
	    (set! val (sample 900))
	    (mix-selection)
	    (if (fneq (sample 900) (* 2 val))
		(snd-display #__line__ ";mix-selection val: ~A ~A" (* 2 val) (sample 900)))
	    (if (not (= (framples obind) (+ frs 1000)))
		(snd-display #__line__ ";mix-selection len: ~A?" (framples obind)))))
	(close-sound obind))
      
      (let* ((ind (open-sound "2.snd"))
	     (apply-to-sound 0)
	     (apply-to-channel 1)
	     (apply-to-selection 2)
	     (len (framples ind)))
	(set! (sync ind) 1)
	(set! (speed-control ind) .5)
	(apply-controls ind apply-to-sound) ; temp 1
	(if (> (abs (- (framples) (* 2 len))) 256)
	    (snd-display #__line__ ";apply srate .5: ~A ~A" (framples) (* 2 len)))
	(make-selection 0 (framples))
	(set! (speed-control ind) .5)
	(apply-controls ind apply-to-selection) ; temp 2
	(if (> (abs (- (framples) (* 4 len))) 256)
	    (snd-display #__line__ ";apply srate .5 to selection: ~A ~A" (framples) (* 4 len)))
	(env-sound '(0 0 1 1) 0 (framples) 32.0) ; temp 3
	(let ((reg (select-all))) ; make multi-channel region
	  (insert-region reg 0) ; temp 4
	  (insert-selection 0))  ; temp 5
	(revert-sound ind)
	(set! (speed-control) .5)
	(set! (sync ind) 0)
	(set! (selected-channel ind) 1)
	(apply-controls ind apply-to-channel)
	(if (> (abs (- (framples ind 1) (* 2 len))) 256)
	    (snd-display #__line__ ";apply srate .5 to chan 1: ~A ~A" (framples ind 1) (* 2 len)))
	(if (not (= (framples ind 0) len))
	    (snd-display #__line__ ";apply srate .5 but chan 0: ~A ~A" (framples ind 0) len))
	(set! (speed-control ind) .5)
	(apply-controls ind apply-to-sound 1000)
	(make-selection 2000 4000)
	(set! (speed-control ind) .5)
	(apply-controls ind apply-to-selection)
	(set! (selected-channel ind) #f)
	(if (selected-channel ind) (snd-display #__line__ ";selected-channel #f: ~A" (selected-channel ind)))
	(close-sound ind))
      
      (let* ((ind1 (open-sound "oboe.snd"))
	     (mx1 (maxamp ind1 0))
	     (ind2 (open-sound "2.snd"))
	     (mx20 (maxamp ind2 0))
	     (mx21 (maxamp ind2 1)))
	(select-sound ind1)
	(scale-sound-by 2.0)
	(let ((nmx (maxamp ind1 0)))
	  (if (fneq (* 2 mx1) nmx) (snd-display #__line__ ";scale-sound-by 2.0: ~A ~A?" mx1 nmx))
	  (if (not (equal? (edit-fragment 1 ind1 0) (list "scale-channel 2.000 0 #f" "scale" 0 50828)))
	      (snd-display #__line__ ";scale-sound-by: ~A?" (edit-fragment 1 ind1 0))))
	(scale-sound-to 0.5)
	(let ((nmx (maxamp ind1 0)))
	  (if (fneq nmx 0.5) (snd-display #__line__ ";scale-sound-to 0.5: ~A?" nmx))
	  (if (not (equal? (edit-fragment 2 ind1 0) (list "scale-channel 1.698 0 #f" "scale" 0 50828)))
	      (snd-display #__line__ ";scale-sound-to: ~A?" (edit-fragment 2 ind1 0))))
	(scale-sound-by 0.0 0 1000 ind1 0)
	(let ((nmx (maxamp ind1 0)))
	  (if (fneq 0.5 nmx) (snd-display #__line__ ";scale-sound-by 0.0: ~A ~A?" mx1 nmx))
	  (if (not (equal? (edit-fragment 3 ind1 0) (list "scale-channel 0.000 0 1000" "scale" 0 1000)))
	      (snd-display #__line__ ";scale-sound-by 0.0: ~A?" (edit-fragment 3 ind1 0))))
	(let* ((v (channel->float-vector 0 1000 ind1 0))
	       (pk (float-vector-peak v)))
	  (if (fneq pk 0.0) (snd-display #__line__ ";scale-sound-by 0.0 [0:1000]: ~A?" pk)))
	(revert-sound ind1)
	(let ((oldv (channel->float-vector 12000 10 ind1 0)))
	  (scale-sound-by 2.0 12000 10 ind1 0)
	  (let ((newv (channel->float-vector 12000 10 ind1 0)))
	    (do ((i 0 (+ i 1)))
		((= i 10))
	      (if (fneq (* 2.0 (oldv i)) (newv i))
		  (snd-display #__line__ ";scale ~D: ~A ~A?" i (oldv i) (newv i)))))
	  (if (not (equal? (edit-fragment 1 ind1 0) (list "scale-channel 2.000 12000 10" "scale" 12000 10)))
	      (snd-display #__line__ ";scale-sound-by 2.0 [12000:10]: ~A?" (edit-fragment 1 ind1 0))))
	(revert-sound ind1)
	(select-sound ind2)
	(scale-sound-by 2.0)
	(let ((nmx (maxamp ind2 0)))
	  (if (fneq (* 2 mx20) nmx) (snd-display #__line__ ";2:0 scale-sound-by 2.0: ~A ~A?" mx20 nmx)))
	(let ((nmx (maxamp ind2 1)))
	  (if (fneq (* 2 mx21) nmx) (snd-display #__line__ ";2:1 scale-sound-by 2.0: ~A ~A?" mx21 nmx)))
	(scale-sound-to 0.5)
	(let ((nmx (max (maxamp ind2 0) (maxamp ind2 1))))
	  (if (fneq nmx 0.5) (snd-display #__line__ ";2 scale-sound-to 0.5: ~A (~A)?" nmx (maxamp ind2))))
	(scale-sound-by 0.0 0 1000 ind2 1)
	(if (not (equal? (edit-fragment 3 ind2 1) (list "scale-channel 0.000 0 1000" "scale" 0 1000)))
	    (snd-display #__line__ ";2:1 scale-sound-by 0.0: ~A?" (edit-fragment 3 ind2 1)))
	(let* ((v (channel->float-vector 0 1000 ind2 1))
	       (pk (float-vector-peak v)))
	  (if (fneq pk 0.0) (snd-display #__line__ ";2:1 scale-sound-by 0.0 [0:1000]: ~A?" pk)))
	(revert-sound ind2)
	(let ((oldv (channel->float-vector 12000 10 ind2 0)))
	  (scale-sound-by 2.0 12000 10 ind2 0)
	  (let ((newv (channel->float-vector 12000 10 ind2 0)))
	    (do ((i 0 (+ i 1)))
		((= i 10))
	      (if (fneq (* 2.0 (oldv i)) (newv i))
		  (snd-display #__line__ ";2 scale ~D: ~A ~A?" i (oldv i) (newv i))))))
	(revert-sound ind2)
	(set! (sync ind2) 3)
	(set! (sync ind1) 3)
	(scale-sound-by 2.0)
	(let ((nmx (maxamp ind1 0)))
	  (if (fneq mx1 nmx) (snd-display #__line__ ";sync scale-sound-by 2.0: ~A ~A?" mx1 nmx)))
	(let ((nmx (maxamp ind2 0)))
	  (if (fneq (* 2 mx20) nmx) (snd-display #__line__ ";2:0 sync scale-sound-by 2.0: ~A ~A?" mx20 nmx)))
	(let ((nmx (maxamp ind2 1)))
	  (if (fneq (* 2 mx21) nmx) (snd-display #__line__ ";2:1 sync scale-sound-by 2.0: ~A ~A?" mx21 nmx)))
	(scale-sound-to 1.0 20000 40000 ind2 1)
	(let ((nmx (maxamp ind1 0)))
	  (if (fneq mx1 nmx) (snd-display #__line__ ";sync scale-sound-to 1.0: ~A ~A?" mx1 nmx)))
	(let ((nmx (maxamp ind2 0)))
	  (if (fneq (* 2 mx20) nmx) (snd-display #__line__ ";2:0 sync scale-sound-to 1.0: ~A ~A?" mx20 nmx)))
	(let ((nmx (maxamp ind2 1)))
	  (if (fneq nmx 1.0) (snd-display #__line__ ";2:1 sync scale-sound-to 1.0: ~A?" nmx)))
	
	(close-sound ind1)
	(close-sound ind2))
      
      (let ((ind (open-sound "now.snd")))
	(set! (amp-control ind) .5)
	(if (ffneq (amp-control ind) .5) (snd-display #__line__ ";amp-control (.5): ~A?" (amp-control ind)))
	(set! (amp-control ind 0) .25)
	(if (ffneq (amp-control ind) .5) (snd-display #__line__ ";amp-control after local set (.5): ~A?" (amp-control ind)))
	(if (ffneq (amp-control ind 0) .25) (snd-display #__line__ ";amp-control 0 (.25): ~A?" (amp-control ind 0)))
	(set! (amp-control ind) 1.0)
	(if (ffneq (amp-control ind) 1.0) (snd-display #__line__ ";amp-control (1.0): ~A?" (amp-control ind)))
	(if (ffneq (amp-control ind 0) .25) (snd-display #__line__ ";amp-control 0 after set (.25): ~A?" (amp-control ind 0)))
	(set! (transform-graph? ind 0) #t)
	(set! (transform-graph-type ind 0) graph-as-sonogram)
	(update-transform-graph ind 0)
	(when with-motif
	  (let ((val (transform-framples ind 0)))
	    (if (or (not (list? val))
		    (fneq (car val) 1.0)
		    (not (= (caddr val) 256)))
		(snd-display #__line__ ";transform-framples: ~A (~A)" val (transform-size ind 0)))))
	(close-sound ind)
	(set! ind (open-sound "4.aiff"))
	(if (ffneq (amp-control ind) 1.0) (snd-display #__line__ ";amp-control upon open (1.0): ~A?" (amp-control ind)))
	(if (ffneq (amp-control ind 2) 1.0) (snd-display #__line__ ";amp-control 2 upon open (1.0): ~A?" (amp-control ind 2)))
	(set! (amp-control ind) .5)
	(if (ffneq (amp-control ind 2) .5) (snd-display #__line__ ";amp-control 2 after global set (.5): ~A?" (amp-control ind 2)))
	(set! (amp-control ind 2) .25)
	(if (ffneq (amp-control ind 2) .25) (snd-display #__line__ ";amp-control 2 (.25): ~A?" (amp-control ind 2)))
	(if (ffneq (amp-control ind 1) .5) (snd-display #__line__ ";amp-control 1 after local set (.5): ~A?" (amp-control ind 1)))
	(let ((after-ran #f))
	  (set! (hook-functions after-apply-controls-hook) ())
	  (hook-push after-apply-controls-hook (lambda (hook) (set! after-ran (hook 'snd))))
	  (apply-controls ind)
	  (if (not (equal? ind after-ran)) (snd-display #__line__ ";after-apply-controls-hook: ~A?" after-ran))
	  (set! (hook-functions after-apply-controls-hook) ()))
	(revert-sound ind)
	(set! (sync ind) 1)
	(scale-to (float-vector .1 .2))
	(let ((mx (maxamp ind #t)))
	  (if (or (fneq (mx 0) .1)
		  (fneq (mx 1) .2)
		  (fneq (mx 2) .2)
		  (fneq (mx 3) .2))
	      (snd-display #__line__ ";scale to with vector: ~A" mx)))
	(set! (filter-control-envelope ind) '(0 0 1 1))
	(if (not (feql '(0.0 0.0 1.0 1.0) (filter-control-envelope ind))) 
	    (snd-display #__line__ ";set filter-control-envelope: ~A?" (filter-control-envelope ind)))
	(set! (filter-control-order ind) 20)
	(if (not (vequal (filter-control-coeffs ind)
			 (float-vector -0.007 0.010 -0.025 0.029 -0.050 0.055 -0.096 0.109 -0.268 0.241 
				       0.241 -0.268 0.109 -0.096 0.055 -0.050 0.029 -0.025 0.010 -0.007)))
	    (snd-display #__line__ ";highpass coeffs: ~A" (filter-control-coeffs ind)))
	(set! (filter-control-envelope ind) '(0 1 1 0))
	(if (not (vequal (filter-control-coeffs ind)
			 (float-vector 0.003 0.002 0.004 0.002 0.007 0.003 0.014 0.012 0.059 0.394 
				       0.394 0.059 0.012 0.014 0.003 0.007 0.002 0.004 0.002 0.003)))
	    (snd-display #__line__ ";lowpass coeffs: ~A" (filter-control-coeffs ind)))
	(close-sound ind))
      
      (let* ((obind (open-sound "4.aiff"))
	     (amps (maxamp obind #t))
	     (times (maxamp-position obind #t)))
	(if (not (equal? times (list 810071 810071 810071 810071)))
	    (snd-display #__line__ ";4.aiff times: ~A" times))
	(if (< (window-width) 600) 
	    (set! (window-width) 600))
	(if (< (window-height) 600)
	    (set! (window-height) 600))
	(set! (x-bounds obind 0) (list 0.0 0.1))
	(set! (show-axes obind 0) show-x-axis)
	(update-time-graph)
	(set! (amp-control obind) 0.1)
	(select-channel 2)
	(if (eq? (without-errors (apply-controls obind 1)) 'no-such-sound) (snd-display #__line__ ";apply-controls can't find 4.aiff?"))
	(let ((newamps (maxamp obind #t)))
	  (if (or (fneq (car amps) (car newamps))
		  (fneq (cadr amps) (cadr newamps))
		  (> (abs (- (* 0.1 (caddr amps)) (caddr newamps))) .05)
		  (fneq (cadddr amps) (cadddr newamps)))
	      (snd-display #__line__ ";apply amps:~%  ~A ->~%  ~A?" amps newamps))
	  (undo 1 obind 2)
	  (set! (amp-control obind) 0.1)
	  (make-region 0 (framples obind) obind 1)
	  (without-errors (apply-controls obind 2))
	  (set! newamps (maxamp obind #t))
	  (if (or (fneq (car amps) (car newamps))
		  (> (abs (- (* 0.1 (cadr amps)) (cadr newamps))) .05)
		  (fneq (caddr amps) (caddr newamps))
		  (fneq (cadddr amps) (cadddr newamps)))
	      (snd-display #__line__ ";apply selection amp:~%  ~A ->~%  ~A?" amps newamps))
	  (if with-gui
	      (let* ((axinfo (axis-info obind 0 time-graph))
		     (losamp (car axinfo))
		     (hisamp (cadr axinfo))
		     (x0 (axinfo 2))
		     (y0 (axinfo 3))
		     (x1 (axinfo 4))
		     (y1 (axinfo 5))
		     (xpos (+ x0 (* .5 (- x1 x0))))
		     (ypos (+ y0 (* .75 (- y1 y0)))))
		(define (cp-x x) (floor (+ (axinfo 10) 
					   (* (- x x0) (/ (- (axinfo 12) (axinfo 10)) 
							  (- x1 x0))))))
		(define (cp-y y) (floor (+ (axinfo 13) 
					   (* (- y1 y) (/ (- (axinfo 11) (axinfo 13)) 
							  (- y1 y0))))))
		(select-channel 0)
		(set! (cursor obind) 100)
		(let ((xy (cursor-position obind)))
		  (if (fneq (position->x (car xy)) (/ (cursor obind) (srate obind)))
		      (snd-display #__line__ ";cursor-position: ~A ~A ~A?" (car xy) (position->x (car xy)) (/ (cursor obind) (srate obind)))))
		(if (fneq (position->x (x->position xpos)) xpos)
		    (snd-display #__line__ ";x<->position: ~A ~A?" (position->x (x->position xpos)) xpos))
		(if (> (abs (- (position->y (y->position ypos)) ypos)) .5)
		    (snd-display #__line__ ";y<->position: ~A ~A?" (position->y (y->position ypos)) ypos))
		(if (not (= losamp (left-sample obind 0)))
		    (snd-display #__line__ ";axis-info[0 losamp]: ~A ~A?" losamp (left-sample obind 0)))
		(if (not (= hisamp (right-sample obind 0)))
		    (snd-display #__line__ ";axis-info[1 hisamp]: ~A ~A?" hisamp (right-sample obind 0)))
		(if (fneq (axinfo 6) 0.0)
		    (snd-display #__line__ ";axis-info[6 xmin]: ~A?" (axinfo 6)))
		(if (fneq (axinfo 7) -1.0)
		    (snd-display #__line__ ";axis-info[7 ymin]: ~A?" (axinfo 7)))
		(if (fneq (axinfo 9) 1.0)
		    (snd-display #__line__ ";axis-info[9 ymax]: ~A?" (axinfo 9)))
		(if (> (abs (apply - (our-x->position obind x0))) 1) 
		    (snd-display #__line__ ";x0->position: ~A?" (our-x->position obind x0)))
		(if (> (abs (apply - (our-x->position obind x1))) 1) 
		    (snd-display #__line__ ";x1->position: ~A?" (our-x->position obind x1)))
		(if (> (abs (apply - (our-x->position obind (* 0.5 (+ x0 x1))))) 1)
		    (snd-display #__line__ ";xmid->position: ~A?" (our-x->position obind (* 0.5 (+ x0 x1)))))
		(if (not full-test)
		    (begin
		      (if (> (abs (- (x->position xpos) (cp-x xpos))) 1)
			  (snd-display #__line__ ";cp-x .5: ~A ~A?" (x->position xpos) (cp-x xpos)))
		      (if (> (abs (- (y->position ypos) (cp-y ypos))) 1)
			  (snd-display #__line__ ";cp-y .75: ~A ~A?" (y->position ypos) (cp-y ypos)))
		      (do ((i 0 (+ i 1)))
			  ((= i 10))
			(let ((xpos (+ x0 (random (- x1 x0))))
			      (ypos (+ y0 (random (- y1 y0)))))
			  (if (> (abs (- (x->position xpos) (cp-x xpos))) 1)
			      (snd-display #__line__ ";cp-x[~A] ~A: ~A ~A?" i xpos (x->position xpos) (cp-x xpos)))
			  (if (> (abs (- (y->position ypos) (cp-y ypos))) 1)
			      (snd-display #__line__ ";cp-y[~A] ~A: ~A ~A?" i ypos (y->position ypos) (cp-y ypos)))
			  (if (fneq (position->x (cp-x xpos)) xpos)
			      (snd-display #__line__ ";x->position cp-x ~A ~A" xpos (position->x (cp-x xpos))))
			  (if (fffneq (position->y (cp-y ypos)) ypos)
			      (snd-display #__line__ ";y->position cp-y ~A ~A" ypos (position->y (cp-y ypos))))))))
		(set! (left-sample obind 0) 1234)
		(if (not (= 1234 (car (axis-info obind 0))))
		    (snd-display #__line__ ";axis-info[0 losamp at 1234]: ~A ~A?" (car (axis-info obind 0)) (left-sample obind 0)))
		(set! axinfo (axis-info obind 0))
		(set! x0 (axinfo 2))
		(set! x1 (axinfo 4))
		(if (> (abs (apply - (our-x->position obind x0))) 1) 
		    (snd-display #__line__ ";x0a->position: ~A?" (our-x->position obind x0)))
		(if (> (abs (apply - (our-x->position obind x1))) 1) 
		    (snd-display #__line__ ";x1a->position: ~A?" (our-x->position obind x1)))
		(if (> (abs (apply - (our-x->position obind (* 0.5 (+ x0 x1))))) 1)
		    (snd-display #__line__ ";xmida->position: ~A?" (our-x->position obind (* 0.5 (+ x0 x1)))))
		(set! (y-bounds obind 0) (list -2.0 3.0))
		(if (fneq ((axis-info obind 0) 7) -2.0)
		    (snd-display #__line__ ";axis-info[7 ymin -2.0]: ~A?" ((axis-info obind 0) 7)))
		(if (fneq ((axis-info obind 0) 9) 3.0)
		    (snd-display #__line__ ";axis-info[9 ymax 3.0]: ~A?" ((axis-info obind 0) 9)))
		
		))
	  (close-sound obind)))
      
      (let ((ind1 (open-sound "oboe.snd")))
	(test-orig (lambda (snd) (src-sound 2.0 1.0 ind1)) (lambda (snd) (src-sound 0.5 1.0 ind1)) 'src-sound ind1)
	(test-orig (lambda (snd) (src-channel 2.0)) (lambda (snd) (src-channel 0.5)) 'src-channel ind1)
	(test-orig (lambda (snd) (scale-by 2.0 ind1)) (lambda (snd) (scale-by 0.5 ind1)) 'scale-by ind1)
	(test-orig (lambda (snd) (scale-channel 2.0)) (lambda (snd) (scale-channel 0.5)) 'scale-channel ind1)
	(test-orig (lambda (snd) (reverse-sound ind1)) (lambda (snd) (reverse-sound ind1)) 'reverse-sound ind1)
	(test-orig (lambda (snd) (reverse-channel)) (lambda (snd) (reverse-channel)) 'reverse-channel ind1)
	(test-orig (lambda (snd) (env-sound '(0 1.0 1 2.0))) (lambda (snd) (env-sound '(0 1.0 1 0.5))) 'env-sound ind1)
	(test-orig (lambda (snd) (env-sound '(0 1.0 1 2.0 2 1.0))) (lambda (snd) (env-sound '(0 1.0 1 0.5 2 1.0))) 'env-sound ind1)
	(test-orig (lambda (snd) (env-channel (make-env :envelope '(0 1.0 1 2.0) :length (framples))))
		   (lambda (snd) (env-channel (make-env :envelope '((0 1.0) (1 0.5)) :length (framples)))) 'env-channel ind1)
	(test-orig (lambda (snd) (env-channel '(0 1.0 1 2.0)))
		   (lambda (snd) (env-channel '(0 1.0 1 0.5))) 'env-channel ind1)
	(test-orig (lambda (snd) (env-channel (make-env :envelope '(0 2 1 2 2 0.5 3 0.5) :base 0 :length (framples))))
		   (lambda (snd) (env-channel (make-env :envelope '(0 0.5 1 0.5 2 2 3 2) :base 0 :length (framples)))) 'env-channel ind1)
	(test-orig (lambda (snd) (map-channel (lambda (n) (* n 2.0)))) (lambda (snd) (map-channel (lambda (n) (* n 0.5)))) 'map-channel ind1)
	(test-orig (lambda (snd) (map-channel (lambda (n) (* n 2.0)) 1234)) (lambda (snd) (map-channel (lambda (n) (* n 0.5)) 1234)) 'map-channel ind1)
	(test-orig (lambda (snd) (map-channel (lambda (n) (* n 2.0)) 12005 10)) (lambda (snd) (map-channel (lambda (n) (* n 0.5)) 12005 10)) 'map-channel ind1)
	(test-orig (lambda (snd) 
		     (define m1
		       (let ((vect (make-float-vector 2 0.0))) 
			 (lambda (y) 
			   (float-vector-set! vect 0 (float-vector-set! vect 1 (* y 2)))
			   vect)))
		     (map-channel m1))
		   (lambda (snd) 
		     (define m2
		       (let ((outp #f))
			 (lambda (y) 
			   (and (set! outp (not outp)) (* y 0.5)))))
		     (map-channel m2))
		   'map-channel ind1)
	(test-orig (lambda (snd) (map-channel (lambda (n) (* n 2.0)))) (lambda (snd) (map-channel (lambda (n) (* n 0.5)))) 'map-channel ind1)
	(test-orig (lambda (snd) (pad-channel 1000 2000 ind1)) (lambda (snd) (delete-samples 1000 2000 ind1)) 'pad-channel ind1)
	(test-orig (lambda (snd) (clm-channel (make-one-zero :a0 2.0 :a1 0.0)))
		   (lambda (snd) (clm-channel (make-one-zero :a0 0.5 :a1 0.0))) 'clm-channel ind1)
	(test-orig (lambda (snd) (clm-channel (make-one-pole :a0 2.0 :b1 0.0)))
		   (lambda (snd) (clm-channel (make-one-pole :a0 0.5 :b1 0.0))) 'clm-channel ind1)
	(test-orig (lambda (snd) (filter-sound (make-one-zero :a0 2.0 :a1 0.0) 2 ind1 0)) 
		   (lambda (snd) (filter-sound (make-one-zero :a0 0.5 :a1 0.0) 2 ind1 0)) 'filter-sound ind1)
	
	(let ((var (catch #t (lambda () (src-sound '(0 0 1 1))) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display #__line__ ";src-sound env at 0: ~A" var)))
	(let ((var (catch #t (lambda () (src-sound '(0 1 1 -1))) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display #__line__ ";src-sound env through 0: ~A" var)))
	
	(scale-to 1.0 ind1)
	(let ((v0 (make-float-vector 10))
	      (v1 (channel->float-vector 12000 10 ind1 0)))
	  (set! (v0 0) 1.0)
	  (array->file "fmv3.snd" v0 10 22050 1)
	  (copy-file "oboe.snd" "fmv4.snd")
	  (convolve-with "fmv3.snd" 1.0 ind1)
	  (convolve-files "fmv4.snd" "fmv3.snd" 1.0 "fmv5.snd")
	  (let ((v2 (channel->float-vector 12000 10 ind1 0)))
	    (if (not (vequal1 v1 v2))
		(snd-display #__line__ ";~A (orig: 0) ~A ~A" 'convolve-with v1 v2))
	    (file->array "fmv5.snd" 0 12000 10 v2)
	    (if (not (vequal1 v1 v2))
		(snd-display #__line__ ";convolve-files: (orig: 0) ~A ~A" v1 v2)))
	  (delete-file "fmv3.snd")
	  (delete-file "fmv5.snd"))
	(convolve-files "2.snd" "oboe.snd" 0.5 "fmv5.snd")
	(if (or (fneq (cadr (mus-sound-maxamp "fmv5.snd")) 0.25)
		(fneq (cadddr (mus-sound-maxamp "fmv5.snd")) 0.5))
	    (snd-display #__line__ ";convolve-files stereo: ~A" (mus-sound-maxamp "fmv5.snd")))
	(delete-file "fmv5.snd")
	(scale-to .25 ind1)
	(set! (y-bounds ind1) ())
	(if (not (equal? (y-bounds ind1) (list -.25 .25)))
	    (snd-display #__line__ ";y-bounds (): ~A?" (y-bounds ind1)))
	(revert-sound ind1)
	
	(scale-to 1.0 ind1)
	(let ((v0 (make-float-vector 10))
	      (v1 (channel->float-vector 12000 10 ind1 0)))
	  (set! (v0 5) 1.0)
	  (array->file "fmv3.snd" v0 10 22050 1)
	  (convolve-with "fmv3.snd" 1.0 ind1)
	  (convolve-files "fmv4.snd" "fmv3.snd" 1.0 "fmv5.snd")
	  (let ((v2 (channel->float-vector 12005 10 ind1 0)))
	    (if (not (vequal1 v1 v2))
		(snd-display #__line__ ";~A (orig: 2) ~A ~A" 'convolve-with v1 v2))
	    (file->array "fmv5.snd" 0 12005 10 v2)
	    (if (not (vequal1 v1 v2))
		(snd-display #__line__ ";convolve-files: (orig: 2) ~A ~A" v1 v2)))
	  (delete-file "fmv3.snd")
	  (delete-file "fmv4.snd")
	  (delete-file "fmv5.snd"))
	
	(revert-sound ind1)
	(let ((old-val *selection-creates-region*)
	      (old-regions (regions)))
	  (set! *selection-creates-region* #f)
	  (select-all ind1)
	  (set! *selection-creates-region* old-val)
	  (if (not (equal? old-regions (regions)))
	      (snd-display #__line__ ";selection-create-region: ~A -> ~A?" old-regions (regions))))
	(convolve-selection-with "pistol.snd" (maxamp))
	(let ((data (channel->float-vector 12000 10 ind1 0)))
	  (convolve-with "pistol.snd" (maxamp ind1 0 0) ind1 0 0)
	  (let ((new-data (channel->float-vector 12000 10 ind1 0)))
	    (if (not (vequal1 data new-data))
		(snd-display #__line__ ";convolve-selection-with: ~A ~A?" data new-data))))
	(revert-sound ind1)
	(make-selection 1000 2000 ind1)
	(let ((ma (maxamp ind1)))
	  (convolve-selection-with "pistol.snd" ma)
	  (if (fneq (maxamp ind1) ma) (snd-display #__line__ ";convolve-selection-with 1000: ~A ~A?" ma (maxamp ind1))))
	(make-selection 1000 2000 ind1)
	(let ((id (make-region)))
	  (if (not (region? id))
	      (snd-display #__line__ ";make-region argless: ~A" id))
	  (if (not (= (region-framples id 0) (selection-framples)))
	      (snd-display #__line__ ";region/selection-framples: ~A ~A (~A)?" (region-framples id 0) (selection-framples) (region-framples id)))
	  (if (fneq (region-sample id 0) (sample 1000 ind1))
	      (snd-display #__line__ ";region-sample from make-region: ~A ~A?" (region-sample id 0) (sample 1000 ind1))))
	(close-sound ind1))
      (let* ((ind (open-sound "2.snd"))
	     (reg (make-region 0 100 ind #t)))
	(if (not (equal? (region-home reg) (list "2.snd" 0 100))) 
	    (snd-display #__line__ ";make + region-home: ~A" (region-home reg)))
	(if (not (= (region-chans reg) 2))
	    (snd-display #__line__ ";make-region chan #t: ~A" (region-chans reg)))
	(close-sound ind))
      
      (let ((ind1 (open-sound "2.snd")))
	(let ((v0 (channel->float-vector 12000 10 ind1 0))
	      (v1 (channel->float-vector 12000 10 ind1 1)))
	  (swap-channels ind1)
	  (let ((v2 (channel->float-vector 12000 10 ind1 0))
		(v3 (channel->float-vector 12000 10 ind1 1)))
	    (if (or (vequal v0 v2)
		    (vequal v1 v3))
		(snd-display #__line__ ";swap-channels 0: no change! ~A ~A ~A ~A" v0 v2 v1 v3)))
	  (swap-channels ind1)
	  (let ((v2 (channel->float-vector 12000 10 ind1 0))
		(v3 (channel->float-vector 12000 10 ind1 1)))
	    (if (or (not (vequal v0 v2))
		    (not (vequal v1 v3)))
		(snd-display #__line__ ";swap-channels 1: ~A ~A ~A ~A" v0 v2 v1 v3)))
	  ;; as long as we're here...
	  (set! (sync ind1) 0)
	  (set! (cursor ind1 0) 100)
	  (set! (cursor ind1 1) 200)
	  (if (or (not (= (cursor ind1 0) 100)) 
		  (not (= (cursor ind1 1) 200)))
	      (snd-display #__line__ ";cursor: ~A ~A?" (cursor ind1 0) (cursor ind1 1)))
	  (set! (sync ind1) 1)
	  (scale-by (list .5 .25) ind1)
	  (scale-by (float-vector 2.0 4.0) ind1)
	  (revert-sound ind1)
	  (let ((amps (maxamp ind1 #t)))
	    (swap-channels ind1 0 ind1)
	    (let ((newamps (maxamp ind1 #t)))
	      (if (or (fneq (car amps) (cadr newamps))
		      (fneq (cadr amps) (car newamps)))
		  (snd-display #__line__ ";swap-channels with cp def: ~A ~A" amps newamps)))
	    (swap-channels ind1 1)
	    (let ((newamps (maxamp ind1 #t)))
	      (if (or (fneq (car amps) (car newamps))
		      (fneq (cadr amps) (cadr newamps)))
		  (snd-display #__line__ ";swap-channels with cp def 0: ~A ~A" amps newamps))))
	  (close-sound ind1)))
      
      (let ((ind1 (open-sound "oboe.snd"))
	    (ind2 (open-sound "2.snd")))
	(let ((ups1 (count-matches (lambda (n) (> n .1)) 0 ind1 0))
	      (ups2 (let ((count 0)
			  (len (framples ind1))
			  (reader (make-sampler 0 ind1)))
		      (do ((i 0 (+ i 1)))
			  ((= i len) count)
			(if (> (next-sample reader) .1)
			    (set! count (+ count 1)))))))
	  (if (not (= ups1 ups2))
	      (snd-display #__line__ ";scan-chan: ~A ~A?" ups1 ups2))
	  (set! ups1 (count-matches (lambda (n) (> n .03)) 0 ind2 0))
	  (set! ups2 (count-matches (lambda (n) (> n .03)) 0 ind2 1))
	  (let ((ups3 (let ((count 0)
			    (len (framples ind2))
			    (reader (make-sampler 0 ind2 0)))
			(do ((i 0 (+ i 1)))
			    ((= i len) count)
			  (if (> (next-sample reader) .03)
			      (set! count (+ count 1))))))
		(ups4 (let ((count 0)
			    (len (framples ind2))
			    (reader (make-sampler 0 ind2 1)))
			(do ((i 0 (+ i 1)))
			    ((= i len) count)
			  (if (> (next-sample reader) .03)
			      (set! count (+ count 1)))))))
	    (if (not (= ups1 ups3))
		(snd-display #__line__ ";2[0] scan-chan: ~A ~A?" ups1 ups3))
	    (if (not (= ups2 ups4))
		(snd-display #__line__ ";2[1] scan-chan: ~A ~A?" ups2 ups4))))
	(close-sound ind1)
	(close-sound ind2))
      
      (let* ((ind1 (open-sound "oboe.snd"))
	     (len (framples ind1))
	     (ctr #f))
	(map-channel (lambda (n)
		       (and (set! ctr (not ctr))
			    (* n 2.0))))
	(if (> (framples ind1) (+ (/ len 2) 1))
	    (snd-display #__line__ ";map-channel cut: ~A ~A?" len (framples ind1)))
	(revert-sound ind1)
	(set! ctr 0)
	(map-channel (lambda (n)
		       (or (> (set! ctr (+ ctr 1)) 3) n)))
	(if (> ctr 4)
	    (snd-display #__line__ ";map-channel no-edit count: ~A?" ctr))
	(revert-sound ind1)
	(let ((v1 (make-float-vector 2)))
	  (map-channel (lambda (n)
			 (set! (v1 0) n)
			 (set! (v1 1) (* n 3))
			 v1)))
	(if (> (abs (- (framples ind1) (* len 2))) 3)
	    (snd-display #__line__ ";map-channel double: ~A ~A?" len (framples ind1)))
	(revert-sound ind1)
	(let ((otime (maxamp-position ind1)))
	  (set! (sample 1234) .9)
	  (let ((ntime (maxamp-position ind1))
		(nval (maxamp ind1))
		(npos (edit-position ind1 0)))
	    (if (not (= ntime 1234)) (snd-display #__line__ ";maxamp-position 1234: ~A" ntime))
	    (let ((ootime (maxamp-position ind1 0 0)))
	      (if (not (= ootime otime)) (snd-display #__line__ ";maxamp-position edpos 0: ~A ~A" otime ootime)))
	    (let ((nntime (maxamp-position ind1 0 npos)))
	      (if (not (= nntime ntime)) (snd-display #__line__ ";maxamp-position edpos ~D: ~A ~A" npos ntime nntime)))
	    (if (fneq nval .9) (snd-display #__line__ ";maxamp .9: ~A" nval)))
	  (set! (sample 1234) 0.0)
	  (env-channel '(0 0 1 1))
	  (if (not (= (maxamp-position) 35062)) (snd-display #__line__ ";env-channel maxamp-position: ~A" (maxamp-position)))
	  (let ((ootime (maxamp-position ind1 0 0)))
	    (if (not (= ootime otime)) (snd-display #__line__ ";maxamp-position edpos 0(1): ~A ~A" otime ootime)))
	  (let ((nntime (maxamp-position ind1 0 1)))
	    (if (not (= nntime 1234)) (snd-display #__line__ ";maxamp-position edpos 1(1): ~A ~A" 1234 nntime)))
	  (let ((nntime (maxamp-position ind1 0 current-edit-position)))
	    (if (not (= nntime 35062)) (snd-display #__line__ ";maxamp-position edpos current: ~A ~A" 35062 nntime))))
	(revert-sound ind1)
	(make-selection 24000 25000)
	(if (not (= (selection-maxamp-position) 971))
	    (snd-display #__line__ ";selection maxamp position: ~A" (selection-maxamp-position)))
	(let ((reg (make-region 24000 25000)))
	  (if (not (= (region-maxamp-position reg) 971))
	      (snd-display #__line__ ";region maxamp position: ~A" (region-maxamp-position reg))))
	(close-sound ind1))
      (let ((ind1 (open-sound "oboe.snd")))
	(test-edpos maxamp 'maxamp (lambda () (scale-by 2.0 ind1 0)) ind1)
	(test-edpos framples 'framples (lambda () (src-sound 2.0 1.0 ind1 0)) ind1)
	(test-edpos 
	 (lambda* ((snd 0) (chn 0) (edpos current-edit-position)) (count-matches (lambda (n1) (> n1 .1)) 0 snd chn edpos)) 
	 'count-matches
	 (lambda () (scale-by 2.0 ind1 0)) 
	 ind1)
	(test-edpos 
	 (lambda* ((snd 0) (chn 0) (edpos current-edit-position)) (scan-channel (lambda (n2) (> n2 .1)) 0 #f snd chn edpos))
	 'find
	 (lambda () (delete-samples 0 100 ind1 0))
	 ind1)
	(test-edpos 
	 (lambda* ((snd 0) (chn 0) (edpos current-edit-position)) 
	   (let ((p (make-one-pole 1.0 -1.0)))
	     (scan-channel (lambda (n3) 
			     (or (> n3 .1) 
				 (not (one-pole p 1.0))))
			   0 (framples snd chn) snd chn edpos)
	     (floor (one-pole p 0.0))))
	 'scan-chan
	 (lambda () (delete-samples 0 100 ind1 0))
	 ind1)
	
	(src-sound 2.0 1.0 ind1 0)
	(undo 1 ind1 0)
	
	(delete-samples 0 10000 ind1 0)
	(save-sound-as "fmv.snd" ind1 :edit-position 0)
	(save-sound-as "fmv1.snd" ind1 :edit-position 1)
	(let ((var (catch #t (lambda () (save-sound-as "fmv2.snd" ind1 :channel 1234)) (lambda args args))))
	  (if (not (eq? (car var) 'no-such-channel))
	      (snd-display #__line__ ";save-sound-as bad chan: ~A" var)))
	(if (not (= (mus-sound-framples "fmv.snd") (framples ind1 0 0)))
	    (snd-display #__line__ ";save-sound-as (edpos): ~A ~A?" (mus-sound-framples "fmv.snd") (framples ind1 0 0)))
	(if (not (= (mus-sound-framples "fmv1.snd") (framples ind1 0 1)))
	    (snd-display #__line__ ";save-sound-as (edpos 1): ~A ~A?" (mus-sound-framples "fmv.snd") (framples ind1 0 1)))
	(if (= (mus-sound-framples "fmv.snd") (framples ind1 0 1))
	    (snd-display #__line__ ";save-sound-as (edpos 1)(2): ~A ~A?" (mus-sound-framples "fmv.snd") (framples ind1 0 1)))
	(let ((ind2 (open-sound "fmv.snd"))
	      (ind3 (open-sound "fmv1.snd")))
	  (if (not (vequal (channel->float-vector 12000 10 ind1 0 0) (channel->float-vector 12000 10 ind2 0)))
	      (snd-display #__line__ ";save-sound-as (edpos 3): ~A ~A?" (channel->float-vector 12000 10 ind1 0 0) (channel->float-vector 12000 10 ind2 0)))
	  (if (not (vequal (channel->float-vector 12000 10 ind1 0 1) (channel->float-vector 12000 10 ind3 0)))
	      (snd-display #__line__ ";save-sound-as (edpos 4): ~A ~A?" (channel->float-vector 12000 10 ind1 0 1) (channel->float-vector 12000 10 ind3 0)))
	  (if (vequal (channel->float-vector 12000 10 ind2 0) (channel->float-vector 12000 10 ind3 0))
	      (snd-display #__line__ ";save-sound-as (edpos 5): ~A ~A?" (channel->float-vector 12000 10 ind2 0) (channel->float-vector 12000 10 ind3 0)))
	  (select-sound ind3)
	  (set! (comment) "hiho")
	  (if (not (string=? (comment) "hiho")) (snd-display #__line__ ";set! comment no index: ~A" (comment)))
	  (close-sound ind2)
	  (close-sound ind3))
	(delete-file "fmv.snd")
	(delete-file "fmv1.snd")
	
	(test-edpos-1 (lambda (snd pos) (reverse-sound snd 0 pos)) 'reverse-sound ind1)
	(test-edpos-1 (lambda (snd pos) (env-sound '(0 0 1 1 2 0) 0 20000 1.0 snd 0 pos)) 'env-sound ind1)
	(test-edpos-1 (lambda (snd pos) (src-sound 0.5 1.0 snd 0 pos)) 'src-sound ind1)
	(test-edpos-1 (lambda (snd pos) (filter-sound (make-fir-filter 6 (float-vector .1 .2 .3 .3 .2 .1)) 6 snd 0 pos)) 'filter-sound ind1)
	(test-edpos-1 (lambda (snd pos) (convolve-with "pistol.snd" .5 snd 0 pos)) 'convolve-with ind1)
	
	(let ((ind (new-sound "fmv.snd"))
	      (v (make-float-vector 2000))
	      (e (make-env (list 0.0 0.0 1.0 (* 2000 0.2 pi)) :length 2001)))
	  (fill-float-vector v (sin (env e)))
	  (float-vector->channel v 0 2000 ind 0)
	  (filter-sound '(0 0 .09 0 .1 1 .11 0 1 0) 1024)
	  (if (> (maxamp) .025) (snd-display #__line__ ";filter-sound maxamp 1: ~A" (maxamp)))
	  (undo)
	  (filter-sound '(0 0 .19 0 .2 1 .21 0 1 0) 1024)  
	  (if (< (maxamp) .9) (snd-display #__line__ ";filter-sound maxamp 2: ~A" (maxamp)))
	  (undo)
	  (filter-sound '(0 0 .29 0 .3 1 .31 0 1 0) 1024)  
	  (if (> (maxamp) .02) (snd-display #__line__ ";filter-sound maxamp 3: ~A" (maxamp)))
	  
	  (set! *show-sonogram-cursor* #t) 
	  (set! *with-tracking-cursor* #t) 
	  (if (not *with-tracking-cursor*) (snd-display #__line__ ";with-tracking-cursor set to #t: ~A" *with-tracking-cursor*))
	  
	  (set! *transform-graph-type* graph-as-sonogram) 
	  (play :wait #t)
	  (set! (transform-graph?) #t) 
	  
	  (close-sound ind))
	(close-sound ind1))
      
      (let ((ind (open-sound "1a.snd"))) ; from Anders Vinjar
	(set! (with-tracking-cursor) :track-and-return) 
	(set! (cursor) 2000) 
	(let ((here (cursor))) 
	  (play :start (cursor)) 
	  (if (or (not (= here 2000))
		  (not (= (cursor) 2000)))
	      (snd-display #__line__ ";with-tracking-cursor set to :track-and-return: start: ~A, end: ~A" here (cursor))))
	
	(set! (zoom-focus-style) zoom-focus-middle) 
	(when with-motif
	  (set! (x-zoom-slider) .5)
	  (if (fneq (x-position-slider) 0.25) (snd-display #__line__ ";zoom focus middle .5: ~A" (x-position-slider)))
	  (set! (x-zoom-slider) .1)
	  (if (fneq (x-position-slider) 0.45) (snd-display #__line__ ";zoom focus middle .1: ~A" (x-position-slider)))
	  (set! (x-zoom-slider) .9)
	  (if (fneq (x-position-slider) 0.05) (snd-display #__line__ ";zoom focus middle .9: ~A" (x-position-slider)))
	  (set! (zoom-focus-style) zoom-focus-left) 
	  (set! (x-zoom-slider) .1)
	  (if (fneq (x-position-slider) 0.05) (snd-display #__line__ ";zoom focus left .1: ~A" (x-position-slider))))
	
	(close-sound ind))
      
      (let* ((ind (open-sound "oboe.snd"))
	     (mx (maxamp ind 0))
	     (e0 (channel-amp-envs ind 0)))
	
	(define (peak-env-equal? name index e diff)
	  (let ((reader (make-sampler 0 index 0))
		(e-size (length (car e))))
	    (let ((samps-per-bin (ceiling (/ (framples index) e-size)))
		  (mins (car e))
		  (maxs (cadr e))
		  (happy #t)
		  (data #f))
	      (set! data (make-float-vector samps-per-bin))
	      (do ((e-bin 0 (+ e-bin 1)))
		  ((or (not happy) 
		       (= e-bin e-size))
		   happy)
		(do ((k 0 (+ k 1)))
		    ((= k samps-per-bin))
		  (float-vector-set! data k (next-sample reader)))
		
		(let ((mx (float-vector-max data))
		      (mn (float-vector-min data)))
		  (let ((mxdiff (abs (- mx (maxs e-bin))))
			(mndiff (abs (- mn (mins e-bin)))))
		    (if (or (> mxdiff diff)
			    (> mndiff diff))
			(begin
			  (snd-display #__line__ ";~A: peak-env-equal? [bin ~D of ~D]: (~,4F to ~,4F), diff: ~,5F" 
				       name
				       e-bin e-size
				       mn mx
				       (max mxdiff mndiff))
			  (set! happy #f)))))))))
	
	(if (null? e0)
	    (snd-display #__line__ ";no amp env data")
	    (let ((mx1 (float-vector-peak (car e0)))
		  (mx2 (float-vector-peak (cadr e0))))
	      (if (fneq mx (max mx1 mx2))
		  (snd-display #__line__ ";amp env max: ~A ~A ~A" mx mx1 mx2))
	      (peak-env-equal? "straight peak" ind e0 .0001)
	      (scale-by 3.0)
	      (let* ((e1 (channel-amp-envs ind 0 1))
		     (mx3 (float-vector-peak (car e1)))
		     (mx4 (float-vector-peak (cadr e1))))
		(if (or (fneq (* 3.0 mx1) mx3)
			(fneq (* 3.0 mx2) mx4))
		    (snd-display #__line__ ";3.0 amp env max: ~A ~A ~A ~A" mx1 mx2 mx3 mx4))
		(peak-env-equal? "scaled peak" ind e1 .0001))
	      (if (fneq (maxamp ind 0) (* 3 mx)) 
		  (snd-display #__line__ ";maxamp after scale: ~A ~A" mx (maxamp ind 0)))
	      (undo)
	      (set! (selection-member? #t) #f)
	      (set! (selection-member? ind 0) #t)
	      (set! (selection-position ind 0) 20000)
	      (set! (selection-framples ind 0) 12000)
	      (scale-selection-by 3.0)
	      (let* ((e1 (channel-amp-envs ind 0 1))
		     (mx3 (float-vector-peak (car e1)))
		     (mx4 (float-vector-peak (cadr e1))))
		(if (or (fneq (* 3.0 mx1) mx3)
			(fneq (* 3.0 mx2) mx4))
		    (snd-display #__line__ ";selection 3.0 amp env max: ~A ~A ~A ~A" mx1 mx2 mx3 mx4))
		(if (fneq (maxamp ind 0) (* 3 mx)) 
		    (snd-display #__line__ ";maxamp after selection scale: ~A ~A" mx (maxamp ind 0)))
		(peak-env-equal? "selection peak" ind e1 .0001))
	      (map-channel abs)
	      (let* ((e1 (channel-amp-envs ind 0 2))
		     (mx3 (float-vector-peak (car e1)))
		     (mx4 (float-vector-peak (cadr e1))))
		(if (fneq (* 3.0 mx2) mx4)
		    (snd-display #__line__ ";abs selection 3.0 amp env max: ~A ~A ~A ~A" mx1 mx2 mx3 mx4))
		(if (fneq (maxamp ind 0) (* 3 mx)) 
		    (snd-display #__line__ ";maxamp after abs selection scale: ~A ~A" mx (maxamp ind 0)))
		(if (ffneq mx3 0.03)
		    (snd-display #__line__ ";abs max: ~A ~A" mx3 mx4))
		(peak-env-equal? "map-channel peak" ind e1 .0001))
	      (delete-samples 10000 5000)
	      (let* ((e1 (channel-amp-envs ind 0))
		     (mx3 (float-vector-peak (car e1)))
		     (mx4 (float-vector-peak (cadr e1))))
		(if (fneq (* 3.0 mx2) mx4)
		    (snd-display #__line__ ";abs selection 3.0 amp env max: ~A ~A ~A ~A" mx1 mx2 mx3 mx4))
		(if (fneq (maxamp ind 0) (* 3 mx)) 
		    (snd-display #__line__ ";maxamp after abs selection scale: ~A ~A" mx (maxamp ind 0)))
		(if (ffneq mx3 0.03)
		    (snd-display #__line__ ";abs max: ~A ~A" mx3 mx4))
		(peak-env-equal? "delete peak" ind e1 .0001))
	      (scale-selection-by -.333)
	      (let* ((e1 (channel-amp-envs ind 0 4))
		     (mx3 (float-vector-peak (car e1))))
		(if (fneq (maxamp ind 0) mx)
		    (snd-display #__line__ ";maxamp after minus abs selection scale: ~A ~A" mx (maxamp ind 0)))
		(if (fneq (maxamp ind 0) mx3)
		    (snd-display #__line__ ";mx3 maxamp after minus abs selection scale: ~A ~A" mx mx3))
		(peak-env-equal? "scale-selection peak" ind e1 .0001))
	      
	      (revert-sound ind)
	      (ramp-channel 0.0 1.0)
	      (peak-env-equal? "ramp-channel peak" ind (channel-amp-envs ind 0 1) .001)
	      (undo)
	      (env-channel '(0 0 1 1 2 0))
	      (peak-env-equal? "env-channel peak" ind (channel-amp-envs ind 0 1) .002)
	      (undo)
	      (env-channel (make-env '(0 0 1 1 2 0) :scaler 0.5 :length (framples)))
	      (peak-env-equal? "scaled env-channel peak" ind (channel-amp-envs ind 0 1) .002)
	      (undo)
	      (env-channel (make-env '(0 0 1 1 2 0) 0.5 :length (framples)))
	      (peak-env-equal? "scaled nokey env-channel peak" ind (channel-amp-envs ind 0 1) .001)
	      (undo)
	      (env-channel (make-env '(0 0 1 1 2 0) :scaler 0.5 :offset 0.5 :length (framples)))
	      (peak-env-equal? "scaled and offset env-channel peak" ind (channel-amp-envs ind 0 1) .001)
	      (undo)
	      (env-channel (make-env '(0 0 1 1 2 .5 3 0) :base 0.0 :length (framples)))
	      (peak-env-equal? "env-channel base 0.0 peak" ind (channel-amp-envs ind 0 1) .001)
	      (undo)
	      (xramp-channel 0.0 1.0 32.0)
	      (peak-env-equal? "xramp 32.0 peak" ind (channel-amp-envs ind 0 1) .008)
	      (undo)
	      (xramp-channel 0.0 1.0 .032)
	      (peak-env-equal? "xramp .032 peak" ind (channel-amp-envs ind 0 1) .004)
	      (undo)
	      (env-channel (make-env '(0 0 1 1 2 .5 3 0) :base 10.0 :length (framples)))
	      (peak-env-equal? "env-channel base 10.0 peak" ind (channel-amp-envs ind 0 1) .003)
	      (undo)
	      (env-channel (make-env '(0 0 1 1 2 0) :base .10 :length (framples)))
	      (peak-env-equal? "env-channel base .1 peak" ind (channel-amp-envs ind 0 1) .003)
	      (undo)
	      (revert-sound ind)
	      (ramp-channel 0.0 1.0)
	      (ramp-channel 1.0 0.0)
	      (peak-env-equal? "ramp2 peak" ind (channel-amp-envs ind 0 2) .002)
	      
	      (revert-sound ind)
	      (env-channel '(0 0 1 1))
	      (env-channel '(0 0 1 1 2 0))
	      (peak-env-equal? "env ramp2 peak" ind (channel-amp-envs ind 0 2) .002)
	      
	      (revert-sound ind)
	      (ramp-channel 0.0 1.0 12000 5000)
	      (peak-env-equal? "ramp-channel peak" ind (channel-amp-envs ind 0 1) .002)
	      (undo)
	      (env-channel '(0 0 1 1 2 0) 12000 5000)
	      (peak-env-equal? "env-channel peak" ind (channel-amp-envs ind 0 1) .003)
	      (undo)
	      (env-channel (make-env '(0 0 1 1 2 0) :scaler 0.5 :length 5000) 12000 5000)
	      (peak-env-equal? "scaled env-channel peak" ind (channel-amp-envs ind 0 1) .004)
	      (undo)
	      (env-channel (make-env '(0 0 1 1 2 0) 0.5 :length 5000) 12000 5000)
	      (peak-env-equal? "scaled nokey env-channel peak" ind (channel-amp-envs ind 0 1) .004)
	      (undo)
	      (env-channel (make-env '(0 0 1 1 2 0) :scaler 0.5 :offset 0.5 :length 5000) 12000 5000)
	      (peak-env-equal? "scaled and offset env-channel peak" ind (channel-amp-envs ind 0 1) .002)
	      (undo)
	      (xramp-channel 0.0 1.0 32.0 2000 1000)
	      (peak-env-equal? "xramp 32.0 peak (1)" ind (channel-amp-envs ind 0 1) .009)
	      (undo)
	      (xramp-channel 0.0 1.0 .032 2000 1000)
	      (peak-env-equal? "xramp .032 peak (1)" ind (channel-amp-envs ind 0 1) .009)
	      (undo)
	      (env-channel (make-env '(0 0 1 1 2 .5 3 0) :base 10.0 :length 5000) 12000 5000)
	      (peak-env-equal? "env-channel base 10.0 peak" ind (channel-amp-envs ind 0 1) .1)
	      ;; this can be way off because the envelope is not very closely sampled in this case
	      (revert-sound ind)
	      (ramp-channel 0.0 1.0)
	      (ramp-channel 1.0 0.0 2000 1000)
	      (peak-env-equal? "ramp2 peak" ind (channel-amp-envs ind 0 2) .002)
	      
	      (revert-sound ind)
	      (env-channel '(0 0 1 1))
	      (env-channel '(0 0 1 1 2 0) 2000 1000)
	      (peak-env-equal? "env ramp2 peak" ind (channel-amp-envs ind 0 2) .002)
	      
	      (revert-sound ind)
	      (env-channel '(0 0 1 1))
	      (env-channel '(0 0 1 1 2 0))
	      (env-channel '(0 0 1 1) 12000 5000)
	      (peak-env-equal? "env ramp3 peak" ind (channel-amp-envs ind 0 3) .01)
	      
	      (revert-sound ind)
	      
	      ))
	(close-sound ind))
      
      (let ((ind (new-sound "test.snd")))
	(map-channel (lambda (y) 1.0) 0 50001)
	(ramp-channel 0.5 1.0 1000 4000)
	(let* ((peaks (channel-amp-envs ind 0))
	       (mx (cadr peaks))
	       (mn (car peaks)))
	  (call-with-current-continuation
	   (lambda (break)
	     (if (not (continuation? break)) (snd-display #__line__ ";not a continuation: ~A" break))
	     (let ((ln (- (length mn) 4)))
	       (do ((i 0 (+ i 1)))
		   ((= i ln))
		 (if (< (mn i) 0.5) (begin (snd-display #__line__ ";peak min: ~A ~A" (mn i) i) (break #f)))
		 (if (< (mx i) 0.5) (begin (snd-display #__line__ ";peak max: ~A ~A" (mx i) i) (break #f))))))))
	(undo 2)
	(map-channel (lambda (y) -1.0) 0 50001)
	(ramp-channel 0.5 1.0 1000 4000)
	(let* ((peaks (channel-amp-envs ind 0))
	       (mx (cadr peaks))
	       (mn (car peaks))
	       (happy #t)
	       (ln (- (length mn) 4)))
	  (do ((i 0 (+ i 1)))
	      ((or (not happy) 
		   (= i ln)))
	    (if (> (mn i) -0.5) (begin (snd-display #__line__ ";1 peak min: ~A ~A" (mn i) i) (set! happy #f)))
	    (if (> (mx i) -0.5) (begin (snd-display #__line__ ";1 peak max: ~A ~A" (mx i) i) (set! happy #f)))))
	(close-sound ind))
      
      (let ((index (new-sound "fmv.snd" 2 22050 mus-ldouble mus-next "channel tests")))
	(define (test-channel-func func val-func init-val)
	  (let ((len (framples index))
		(chns (chans index))
		(val #f))
	    (set! g-init-val init-val)
	    (do ((k 0 (+ k 1)))
		((= k 2))
	      (set! val (val-func len))
	      (set! (sync index) k)
	      (do ((i 0 (+ i 1)))
		  ((= i chns))
		(map-channel (lambda (n) 0.0) 0 len index i)
		(if (scan-channel (lambda (n) (> (abs n) .001)) 0 len index i)
		    (snd-display #__line__ ";init scan: ~A?" (scan-channel (lambda (n) (> (abs n) 0.001))))))
	      ;; now it's cleared
	      (do ((i 0 (+ i 1)))
		  ((= i chns))
		(map-channel (lambda (n) g-init-val) 0 len index i)
		(func 0 len index i)
		(do ((j 0 (+ j 1)))
		    ((= j chns))
		  (let ((vi (channel->float-vector 0 len index j)))
		    (if (= j i)
			(if (not (vequal vi val))
			    (snd-display #__line__ ";chan func: ~A ~A" vi val))
			(if (scan-channel (lambda (n) (> (abs n) .001)) 0 len index j)
			    (snd-display #__line__ ";chan func leaks? ~A ~A: ~A" i j (scan-channel (lambda (n) (> (abs n) 0.001)) 0 len index j))))))
		(map-channel (lambda (n) 0.0) 0 len index i))
	      (do ((i 0 (+ i 1)))
		  ((= i chns))
		(map-channel (lambda (n) g-init-val) 0 len index i)
		(let ((ed (edit-position index i)))
		  (map-channel (lambda (n) (+ g-init-val 1.0)) 0 len index i)
		  (func 0 len index i ed)
		  (do ((j 0 (+ j 1)))
		      ((= j chns))
		    (let ((vi (channel->float-vector 0 len index j)))
		      (if (= j i)
			  (if (not (vequal vi val))
			      (snd-display #__line__ ";ed chan func: ~A ~A" vi val))
			  (if (scan-channel (lambda (n) (> (abs n) 0.001)) 0 len index j)
			      (snd-display #__line__ ";ed chan func leaks? ~A ~A ~A: ~A" i j ed (scan-channel (lambda (n) (> (abs n) 0.001)) 0 len index j))))))
		  (map-channel (lambda (n) 0.0) 0 len index i)))
	      (let* ((beg (floor (/ len 3)))
		     (dur beg)
		     (nv (val-func dur)))
		(fill! val 0.0)
		(do ((i beg (+ i 1))
		     (j 0 (+ j 1)))
		    ((= j dur))
		  (set! (val i) (nv j)))
		(do ((i 0 (+ i 1)))
		    ((= i chns))
		  (map-channel (lambda (n) g-init-val) beg dur index i)
		  (func beg dur index i)
		  (add-mark beg index i)
		  (do ((j 0 (+ j 1)))
		      ((= j chns))
		    (let ((vi (channel->float-vector 0 len index j)))
		      (if (= j i)
			  (if (not (vequal vi val))
			      (snd-display #__line__ ";chan func n: ~A ~A" vi val))
			  (if (scan-channel (lambda (n) (> (abs n) 0.001)) 0 len index j)
			      (snd-display #__line__ ";dur chan func leaks? ~A ~A: ~A" i j (scan-channel (lambda (n) (> (abs n) 0.001)) 0 len index j))))))
		  (map-channel (lambda (n) 0.0) 0 len index i))))))
	
	(insert-silence 0 10 index 0)
	(insert-silence 0 10 index 1)
	
	(test-channel-func (lambda* (beg dur index chan edpos)
			     (clm-channel (make-env :envelope '(0 0 1 1) :length dur) beg dur index chan edpos))
			   (lambda (dur)
			     (let ((e (make-env :envelope '(0 0 1 1) :length dur))
				   (v (make-float-vector dur)))
			       (do ((i 0 (+ i 1)))
				   ((= i dur))
				 (set! (v i) (env e)))
			       v))
			   0.0)
	
	(test-channel-func (lambda* (beg dur index chan edpos)
			     (clm-channel (make-oscil :frequency 0.0 :initial-phase (/ pi 2)) beg dur index chan edpos))
			   (lambda (dur)
			     (let ((v (make-float-vector dur)))
			       (fill! v 1.0)
			       v))
			   0.0)
	
	(test-channel-func (lambda* (beg dur index chan edpos)
			     (scale-channel 0.5 beg dur index chan edpos))
			   (lambda (dur)
			     (let ((v (make-float-vector dur)))
			       (fill! v 0.5)
			       v))
			   1.0)
	
	(test-channel-func (lambda* (beg dur index chan edpos)
			     (env-channel (make-env :envelope '(0 0 1 1) :length dur) beg dur index chan edpos))
			   (lambda (dur)
			     (let ((e (make-env :envelope '(0 0 1 1) :length dur))
				   (v (make-float-vector dur)))
			       (do ((i 0 (+ i 1)))
				   ((= i dur))
				 (set! (v i) (env e)))
			       v))
			   1.0)
	
	(test-channel-func (lambda* (beg dur index chan edpos)
			     (env-channel '(0 0 1 1) beg dur index chan edpos))
			   (lambda (dur)
			     (let ((e (make-env :envelope '(0 0 1 1) :length dur))
				   (v (make-float-vector dur)))
			       (do ((i 0 (+ i 1)))
				   ((= i dur))
				 (set! (v i) (env e)))
			       v))
			   1.0)
	
	(test-channel-func (lambda* (beg dur index chan edpos)
			     (let ((v (make-float-vector dur)))
			       (fill! v -1.0)
			       (float-vector->channel v beg dur index chan)))
			   (lambda (dur)
			     (let ((v (make-float-vector dur)))
			       (fill! v -1.0)
			       v))
			   1.0)
	
	(test-channel-func (lambda* (beg dur index chan edpos)
			     (delete-samples beg dur index chan edpos)
			     (pad-channel beg dur index chan edpos))
			   make-float-vector
			   1.0)
	
	(test-channel-func (lambda* (beg dur index chan edpos)
			     (let ((v (make-float-vector dur)))
			       (fill! v -1.0)
			       (delete-samples beg dur index chan edpos)
			       (insert-samples beg dur v index chan edpos)))
			   (lambda (dur)
			     (let ((v (make-float-vector dur)))
			       (fill! v -1.0)
			       v))
			   1.0)
	
	(test-channel-func (lambda* (beg dur index chan edpos)
			     (let ((v (make-float-vector dur)))
			       (fill! v -1.0)
			       (set! (samples beg dur index chan #f "test-channel" 0 edpos) v)))
			   (lambda (dur)
			     (let ((v (make-float-vector dur)))
			       (fill! v -1.0)
			       v))
			   1.0)
	
	(test-channel-func (lambda* (beg dur index chan edpos)
			     (env-channel (make-env :envelope '(0 0 1 1) :length dur) beg dur index chan edpos)
			     (reverse-channel beg dur index chan))
			   (lambda (dur)
			     (let ((e (make-env :envelope '(0 1 1 0) :length dur))
				   (v (make-float-vector dur)))
			       (do ((i 0 (+ i 1)))
				   ((= i dur))
				 (set! (v i) (env e)))
			       v))
			   1.0)
	
	(test-channel-func (lambda* (beg dur index chan edpos)
			     (env-channel (make-env :envelope '(0 0 1 1) :length dur) beg dur index chan edpos)
			     (set! (sample (+ beg dur) index chan) 1.0)
			     (smooth-channel beg dur index chan)
			     (if (not (= beg 0))
				 (set! (sample (+ beg dur) index chan) 0.0)))
			   (lambda (dur)
			     (let ((v (make-float-vector dur))
				   (ipi (/ pi dur)))
			       (do ((i 0 (+ i 1)))
				   ((= i dur))
				 (set! (v i) (+ 0.5 (* 0.5 (cos (+ pi (* ipi i)))))))
			       v))
			   1.0)
	
	(let ((old-max (maxamp index #t))
	      (regdata (map (lambda (n)
			      (catch #t
				(lambda ()
				  (region->float-vector n 0 10))
				(lambda args (float-vector))))
			    (regions)))
	      ;; (old-pos0 (edit-position index 0))
	      ;; (old-pos1 (edit-position index 1))
	      (old-reglen (map region-framples (regions)))
	      (s61-files ()))
	  (hook-push save-state-hook
		     (lambda (hook)
		       (set! s61-files (cons (hook 'name) s61-files))))
	  (if (file-exists? "s61.scm") (delete-file "s61.scm"))
	  (save-state "s61.scm")
	  (close-sound index)
	  (for-each forget-region (regions))
	  (load (string-append cwd "s61.scm"))
	  (if (not (equal? old-reglen (map region-framples (regions))))
	      (snd-display #__line__ ";region-framples after save: ~A ~A" old-reglen (map region-framples (regions))))
	  (catch #t
	    (lambda ()
	      (for-each (lambda (n data)
			  (if (not (vequal data (region->float-vector n 0 10)))
			      (snd-display #__line__ ";region after save ~A: ~A ~A" n data (region->float-vector n 0 10))))
			(regions)
			regdata))
	    (lambda args (snd-display #__line__ ";region->float-vector: ~A" args)))
	  (set! index (find-sound "fmv.snd"))
	  (if (not (equal? (maxamp index #t) old-max))
	      (snd-display #__line__ ";maxes: ~A ~A" (maxamp index #t) old-max))
	  (if (not (equal? (edits index) (list 275 0)))
	      (snd-display #__line__ ";saved channel edits: ~A" (edits index)))
	  
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (let ((pos (random (car (edits index)))))
	      (scale-channel (random 2.0) (random 5) (random 5) index 0 pos)
	      (set! (edit-position index) (floor (* (car (edits index)) .7)))))
	  
	  (close-sound index)
	  (for-each forget-region (regions))
	  (for-each
	   (lambda (file)
	     (if (file-exists? file) 
		 (delete-file file)))
	   s61-files)
	  (delete-file "s61.scm")
	  (set! (hook-functions save-state-hook) ())
	  ))
      
      (let ((index (new-sound "fmv.snd" 2 22050 mus-ldouble mus-next "channel tests"))
	    (v (make-float-vector 10))
	    (sw *sinc-width*))
	(set! *sinc-width* 10)
	(set! (v 0) 1.0)
	(float-vector->channel v 0 10 index 0)
	(src-channel 0.5 0 10 index 0)
	(let ((v (make-float-vector 10))
	      (s (make-src :srate 0.5
			   :input (let ((val 1.0))
				    (lambda (dir)
				      (let ((rtn val))
					(set! val 0.0)
					rtn))))))
	  (set! (v 0) (src s))
	  (do ((i 1 (+ i 1)))
	      ((= i 10))
	    (set! (v i) (src s)))
	  (if (not (vequal v (channel->float-vector 0 10 index 0)))
	      (snd-display #__line__ ";src-channel: ~A ~A" v (channel->float-vector 0 10 index 0)))
	  (if (not (vequal (make-float-vector 10) (channel->float-vector 0 10 index 1)))
	      (snd-display #__line__ ";src-channel leaks: ~A" (channel->float-vector 0 10 index 1))))
	(let ((tag (catch #t (lambda () (src-channel 120000.0)) (lambda args args))))
	  (if (not (eq? (car tag) 'mus-error)) (snd-display #__line__ ";src-channel crazy srate: ~A" tag)))
	(let ((tag (catch #t (lambda () (filter-sound (make-snd->sample))) (lambda args args))))
	  (if (not (eq? (car tag) 'mus-error)) (snd-display #__line__ ";filter-sound + un-run gen: ~A" tag)))
	(revert-sound index)
	(float-vector->channel v 0 10 index 1)
	(float-vector->channel v 10 10 index 1)
	(src-channel (make-env :envelope '(1 1 2 2) :length 21) 0 20 index 1)
	(if (not (vequal (channel->float-vector 0 10 index 1) (float-vector 1.000 -0.000 -0.048 0.068 -0.059 0.022 0.030 -0.100 0.273 0.606)))
	    (snd-display #__line__ ";src-channel env: ~A" (channel->float-vector 0 10 index 1)))
	(if (not (vequal (make-float-vector 10) (channel->float-vector 0 10 index 0)))
	    (snd-display #__line__ ";src-channel env leaks: ~A" (channel->float-vector 0 10 index 0)))
	(revert-sound index)
	(float-vector->channel v 0 10 index 1)
	(float-vector->channel v 10 10 index 1)
	(src-channel '(1 1 2 2) 0 20 index 1) ; end is off above -- should be 19 I think
	(if (not (vequal (channel->float-vector 0 10 index 1) (float-vector 1.000 -0.000 -0.051 0.069 -0.056 0.015 0.042 -0.117 0.320 0.568)))
	    (snd-display #__line__ ";src-channel lst: ~A" (channel->float-vector 0 10 index 1)))
	(if (not (vequal (make-float-vector 10) (channel->float-vector 0 10 index 0)))
	    (snd-display #__line__ ";src-channel lst leaks: ~A" (channel->float-vector 0 10 index 0)))
	(set! *sinc-width* sw)
	(close-sound index))
      
      (let ((ind (new-sound :size 100)))
	(for-each
	 (lambda (sr)
	   (revert-sound ind)
	   (set! (sample 50) .5)
	   (set! (sample 51) -.5)
	   (src-channel sr)
	   (let ((v1 (channel->float-vector)))
	     (revert-sound ind)
	     (set! (sample 50) .5)
	     (set! (sample 51) -.5)
	     (src-channel (+ sr .00001))
	     (let ((v2 (channel->float-vector)))
	       (float-vector-abs! (float-vector-subtract! v1 v2))
	       (let ((sum 0.0)
		     (len (min (length v1) (length v2)))
		     (mx (float-vector-peak v1)))
		 (do ((i 0 (+ i 1)))
		     ((= i len))
		   (set! sum (+ sum (float-vector-ref v1 i))))
		 (if (or (> sum .01) ; depends on sinc-width I think
			 (> mx .002))
		     (snd-display #__line__ ";src-channel ~A: diff: ~A ~A~%" sr sum mx))))))
	 (list 0.5 0.75 1.0 1.5 2.0))
	(close-sound ind))
      
      (if (< *max-regions* 8) (set! *max-regions* 8))
      (let* ((ind (open-sound "oboe.snd"))
	     (rid0 (make-region 2000 2020 ind 0))
	     (rid0-data (region2float-vector rid0 0 20)))
	(scale-sound-by 2.0)
	(play rid0 :wait #t)
	(let ((nv (region2float-vector rid0 0 20)))
	  (if (not (vequal rid0-data nv)) (snd-display #__line__ ";deferred region after scaling:~%  ~A~%  ~A" rid0-data nv)))
	(let ((nv (region-to-float-vector rid0 0 20)))
	  (if (not (vequal rid0-data nv)) (snd-display #__line__ ";deferred region after scaling (rs):~%  ~A~%  ~A" rid0-data nv)))
	(undo)
	(scale-by 4.0)
	(play rid0 :wait #t)
	(let ((nv (region2float-vector rid0 0 20)))
	  (if (not (vequal rid0-data nv)) (snd-display #__line__ ";file region after scaling:~%  ~A~%  ~A" rid0-data nv)))
	(let ((nv (region-to-float-vector rid0 0 20)))
	  (if (not (vequal rid0-data nv)) (snd-display #__line__ ";file region after scaling (rs):~%  ~A~%  ~A" rid0-data nv)))
	(let* ((rid1 (make-region 2000 2020 ind 0))
	       (rid1-data (region2float-vector rid1 0 20)))
	  (scale-to .5)
	  (let ((nv (region2float-vector rid1 0 20)))
	    (if (not (vequal rid1-data nv)) (snd-display #__line__ ";deferred region after scale-to:~%  ~A~%  ~A" rid1-data nv)))
	  (close-sound ind)
	  (play rid0 :wait #t)
	  (play rid1 :wait #t)
	  (let ((nv (region2float-vector rid1 0 20)))
	    (if (not (vequal rid1-data nv)) (snd-display #__line__ ";deferred region after close:~%  ~A~%  ~A" rid1-data nv)))
	  (let ((nv (region2float-vector rid0 0 20)))
	    (if (not (vequal rid0-data nv)) (snd-display #__line__ ";file region after close:~%  ~A~%  ~A" rid0-data nv))))
	
	(for-each
	 (lambda (s1 l1 s2 l2)
	   (set! ind (open-sound "2.snd"))
	   (set! (selection-member? #t) #f)
	   (set! (selection-member? ind 0) #t)
	   (set! (selection-position ind 0) s1)
	   (set! (selection-framples ind 0) l1)
	   (set! (selection-member? ind 1) #t)
	   (set! (selection-position ind 1) s2)
	   (set! (selection-framples ind 1) l2)
	   (let* ((rid2 (make-region))
		  (rid20-data (region2float-vector rid2 0 l1))
		  (rid21-data (region2float-vector rid2 1 l2)))
	     (if (not (= (region-chans rid2) 2)) (snd-display #__line__ ";region-chans of sync'd sound: ~A?" (region-chans rid2)))
	     (swap-channels ind 0 ind 1)
	     (let ((nv (region2float-vector rid2 0 l1)))
	       (if (not (vequal rid20-data nv)) (snd-display #__line__ ";deferred region after scaling (20):~%  ~A~%  ~A" rid20-data nv)))
	     (let ((nv (region-to-float-vector rid2 0 l1)))
	       (if (not (vequal rid20-data nv)) (snd-display #__line__ ";deferred region after scaling (20 rs):~%  ~A~%  ~A" rid20-data nv)))
	     (let ((nv (region2float-vector rid2 1 l2)))
	       (if (not (vequal rid21-data nv)) (snd-display #__line__ ";deferred region after scaling (21):~%  ~A~%  ~A" rid21-data nv)))
	     (let ((nv (region-to-float-vector rid2 1 l2)))
	       (if (not (vequal rid21-data nv)) (snd-display #__line__ ";deferred region after scaling (21 rs):~%  ~A~%  ~A" rid21-data nv)))
	     (close-sound ind)
	     (let ((nv (region2float-vector rid2 0 l1)))
	       (if (not (vequal rid20-data nv)) (snd-display #__line__ ";deferred region after scaling (20):~%  ~A~%  ~A" rid20-data nv)))
	     (let ((nv (region-to-float-vector rid2 0 l1)))
	       (if (not (vequal rid20-data nv)) (snd-display #__line__ ";deferred region after scaling (20 rs):~%  ~A~%  ~A" rid20-data nv)))
	     (let ((nv (region2float-vector rid2 1 l2)))
	       (if (not (vequal rid21-data nv)) (snd-display #__line__ ";deferred region after scaling (21):~%  ~A~%  ~A" rid21-data nv)))
	     (let ((nv (region-to-float-vector rid2 1 l2)))
	       (if (not (vequal rid21-data nv)) (snd-display #__line__ ";deferred region after scaling (21 rs):~%  ~A~%  ~A" rid21-data nv)))
	     ))
	 (list 2000 2000 2000 0 2000 0 2000)
	 (list 20 10 20 20 20 10 20)
	 (list 2000 2000 2000 2000 0 2000 0)
	 (list 20 20 10 20 20 20 10)))
      
      (let ((ind (open-sound "obtest.snd")))
	(set! (read-only ind) #t)
	(delete-samples 0 1000 ind 0)
	(let ((val (catch #t
		     (lambda ()
		       (save-sound ind))
		     (lambda args args))))
	  (if (sound? val) (snd-display #__line__ ";save-sound read-only: ~A" val))
	  (if (not (equal? (edits ind) (list 1 0))) (snd-display #__line__ ";read-only ignored? ~A" (edits ind))))
	(set! (read-only ind) #f)
	(revert-sound ind)
	(let ((tag (catch #t
		     (lambda () (save-sound ind))
		     (lambda args args))))
	  (if (not (sound? tag)) (snd-display #__line__ ";save-sound read-write: ~A" tag)))
	(key (char->integer #\j) 4)
	(key (char->integer #\-) 4)
	(key (char->integer #\j) 4)
	(key (char->integer #\j) 4)
	(key (char->integer #\x) 4)
	(key (char->integer #\c) 0)
	(catch #t (lambda () (add-mark 123)) (lambda args #f))
	(key (char->integer #\u) 4)
	(key (char->integer #\6) 4)
	(key (char->integer #\j) 4)
	(key (char->integer #\u) 4)
	(key (char->integer #\6) 4)
	(key (char->integer #\x) 4)
	(key (char->integer #\c) 0)
	(close-sound ind))
      
      (let ((ns (new-sound))
	    (v (make-float-vector 1000)))
	(unselect-all)
	(do ((i 0 (+ i 1))
	     (x 0.0 (+ x .001)))
	    ((= i 1000))
	  (set! (v i) x))
	(float-vector->channel v 0 1000 ns 0)
	(set! (selection-member? ns 0) #t)
	(set! (selection-position ns 0) 200)
	(set! (selection-framples ns 0) 300)
	(delete-selection-and-smooth)
	(if (not (= (framples ns 0) 700))
	    (snd-display #__line__ ";delete-selection-and-smooth framples: ~A" (framples ns 0)))
	(if (fneq (sample 167 ns 0) 0.167) 
	    (snd-display #__line__ ";delete-selection-and-smooth 167: ~A" (sample 167 ns 0)))
	(if (fneq (sample 234 ns 0) 0.534) 
	    (snd-display #__line__ ";delete-selection-and-smooth 234: ~A" (sample 234 ns 0)))
	(if (fneq (sample 210 ns 0) 0.406) 
	    (snd-display #__line__ ";delete-selection-and-smooth 210: ~A" (sample 210 ns 0)))
	(let* ((v1 (channel->float-vector))
	       (maxdiff 0.0)
	       (mindiff 10.0)
	       (ls (v1 0)))
	  (do ((i 1 (+ i 1)))
	      ((= i 700))
	    (let ((diff (- (v1 i) ls)))
	      (set! ls (v1 i))
	      (if (> diff maxdiff) (set! maxdiff diff))
	      (if (< diff mindiff) (set! mindiff diff))))
	  (if (< mindiff .0009)
	      (snd-display #__line__ ";delete-selection-and-smooth min diff: ~A" mindiff))
	  (if (> maxdiff .007)
	      (snd-display #__line__ ";delete-selection-and-smooth max diff: ~A" maxdiff)))
	(close-sound ns))
      
      (let ((ns (new-sound))
	    (v (make-float-vector 1000)))
	(do ((i 0 (+ i 1))
	     (x 0.0 (+ x .001)))
	    ((= i 1000))
	  (set! (v i) x))
	(float-vector->channel v 0 1000 ns 0)
	(delete-samples-and-smooth 200 300 ns 0)
	(if (not (= (framples ns 0) 700))
	    (snd-display #__line__ ";delete-samples-and-smooth framples: ~A" (framples ns 0)))
	(if (fneq (sample 167 ns 0) 0.167) 
	    (snd-display #__line__ ";delete-samples-and-smooth 167: ~A" (sample 167 ns 0)))
	(if (fneq (sample 234 ns 0) 0.534) 
	    (snd-display #__line__ ";delete-samples-and-smooth 234: ~A" (sample 234 ns 0)))
	(if (fneq (sample 210 ns 0) 0.406) 
	    (snd-display #__line__ ";delete-samples-and-smooth 210: ~A" (sample 210 ns 0)))
	(let* ((v1 (channel->float-vector))
	       (maxdiff 0.0)
	       (mindiff 10.0)
	       (ls (v1 0)))
	  (do ((i 1 (+ i 1)))
	      ((= i 700))
	    (let ((diff (- (v1 i) ls)))
	      (set! ls (v1 i))
	      (if (> diff maxdiff) (set! maxdiff diff))
	      (if (< diff mindiff) (set! mindiff diff))))
	  (if (< mindiff .0009)
	      (snd-display #__line__ ";delete-samples-and-smooth min diff: ~A" mindiff))
	  (if (> maxdiff .007)
	      (snd-display #__line__ ";delete-samples-and-smooth max diff: ~A" maxdiff)))
	(close-sound ns))
      
      (let ((old-beg *initial-beg*)
	    (old-dur *initial-dur*)
	    (old-show *show-full-duration*)
	    (old-hook (hook-functions initial-graph-hook)))
	(set! (hook-functions initial-graph-hook) ())
	(set! *show-full-duration* #t)
	(let ((ns (open-sound "1.snd")))
	  (let ((ls (left-sample ns 0))
		(rs (right-sample ns 0))
		(fr (framples ns 0)))
	    (when with-gui
	      (if (not (equal? (list fr ls rs) '(220501 0 220501)))
		  (snd-display #__line__ ";show-full-duration 1: ~A" (list fr ls rs))))
	    (close-sound ns)))
	(set! *show-full-duration* #t)
	(set! *initial-beg* 0.0)
	(set! *initial-dur* 0.2)
	(let ((ns (open-sound "1.snd")))
	  (let ((ls (left-sample ns 0))
		(rs (right-sample ns 0))
		(fr (framples ns 0)))
	    (when with-gui
	      (if (not (equal? (list fr ls rs) '(220501 0 220501)))
		  (snd-display #__line__ ";show-full-duration 2: ~A" (list fr ls rs))))
	    (close-sound ns)))
	(set! *show-full-duration* #f)
	(set! *initial-beg* 0.0)
	(set! *initial-dur* 0.2)
	(let ((ns (open-sound "1.snd")))
	  (let ((ls (left-sample ns 0))
		(rs (right-sample ns 0))
		(fr (framples ns 0)))
	    (if (not (equal? (list fr ls rs) '(220501 0 4410)))
		(snd-display #__line__ ";show-full-duration 3: ~A" (list fr ls rs)))
	    (close-sound ns)))
	(set! *initial-beg* 2.0)
	(set! *initial-dur* 1.0)
	(let ((ns (open-sound "1.snd")))
	  (let ((ls (left-sample ns 0))
		(rs (right-sample ns 0))
		(fr (framples ns 0)))
	    (if (not (equal? (list fr ls rs) '(220501 44100 66150)))
		(snd-display #__line__ ";show-full-duration 4: ~A" (list fr ls rs)))	  
	    (close-sound ns)))
	(set! *initial-beg* old-beg)
	(set! *initial-dur* old-dur)
	(set! *show-full-duration* old-show)
	(set! (hook-functions initial-graph-hook) old-hook))
      
      (set! *show-full-range* #t)
      (let ((ns (open-sound "1a.snd")))
	(if (or (fneq (car (y-bounds ns 0)) -1.0)
		(fneq (cadr (y-bounds ns 0)) 1.0))
	    (snd-display #__line__ ";show-full-range 1a: ~A" (y-bounds ns 0)))
	(close-sound ns))
      (with-sound ("test.snd" :clipped #f :to-snd #f)
	(fm-violin 0 1 440 3.5))
      (let ((ns (open-sound "test.snd")))
	(when with-gui
	  (if (or (fneq (car (y-bounds ns 0)) -3.5)
		  (fneq (cadr (y-bounds ns 0)) 3.5))
	      (snd-display #__line__ ";show-full-range 3.5 test: ~A" (y-bounds ns 0))))
	(with-sound ("test.snd" :clipped #f :to-snd #f)
	  (fm-violin 0 1 440 1.5))
	(update-sound ns)
	(when with-gui
	  (if (or (fneq (car (y-bounds ns 0)) -1.5)
		  (fneq (cadr (y-bounds ns 0)) 1.5))
	      (snd-display #__line__ ";show-full-range 1.5 test: ~A" (y-bounds ns 0))))
	(close-sound ns))
      (set! *show-full-range* #f)
      
      (let ((old-sync *sync-style*))
	(set! *sync-style* sync-none)
	(let ((ns (open-sound "2.snd")))
	  (if (not (= (sync ns) 0))
	      (snd-display #__line__ ";sync-none open: ~A" (sync ns)))
	  (set! (sync ns) 1)
	  (set! *sync-style* sync-by-sound)
	  (let ((ns1 (open-sound "1a.snd")))
	    (if (or ;(= (sync ns1) 0) ; this default changed 12.9
		 (= (sync ns1) 1)
		 (not (= (sync ns) 1)))
		(snd-display #__line__ ";sync-by-sound open: ~A" (list (sync ns) (sync ns1))))
	    (close-sound ns1))
	  (close-sound ns))
	(set! *sync-style* old-sync))
      
      (let ((ind (view-sound "obtest.snd")))
	(delete-samples 0 1000 ind 0)
	(let ((tag (catch #t
		     (lambda () (save-sound ind))
		     (lambda args args))))
	  (if (integer? tag) (snd-display #__line__ ";save-viewed-sound: ~A" tag))
	  (if (not (equal? (edits ind) (list 1 0))) (snd-display #__line__ ";view read-only ignored? ~A" (edits ind))))
	(close-sound ind))
      
      (let ((ind (new-sound "test.snd" 1 22050 mus-ldouble mus-next)))
	(insert-silence 0 150000)
	(map-channel (lambda (y) 0.5))
	(env-sound '(0 0 1 1 2 0))
	(fp 1.0 0.3 20)
	(let ((old-curse *with-tracking-cursor*))
	  (set! *with-tracking-cursor* #t)
	  (play :wait #t)
	  (set! *with-tracking-cursor* old-curse))
	(close-sound ind))
      (let ((ind (new-sound "test.snd" 1 22050 mus-ldouble mus-next)))
	(for-each
	 (lambda (dur)
	   (insert-silence 0 dur)
	   (map-channel (lambda (y) 1.0))
	   (env-sound '(0 0 1 1 2 0))
	   (let ((reader (make-sampler (- (framples) 1) ind 0 -1)))
	     (if (not (= (sampler-position reader) (- (framples) 1))) (snd-display #__line__ ";sampler-position: ~A" (sampler-position reader)))
	     (map-channel (lambda (y) (read-sample reader))))
	   (let ((e (make-env '(0 0 1 1 2 0) :length (+ 1 dur)))
		 (len (framples)))
	     (let ((v0 (make-float-vector len))
		   (v1 (samples 0 len ind 0)))
	       (outa->fv v0 (env e))
	       (if (not (vequal v0 v1))
		   (snd-display #__line__ "~%;trouble in reverse read ~A ~A" v0 v1))))
	   (revert-sound))
	 (list 150 1500 150000))
	(close-sound ind))
      (let ((ind (new-sound "test.snd" 1 22050 mus-ldouble mus-next)))
	(insert-silence 0 1000)
	(map-channel (lambda (y) 1.0))
	(env-sound '(0 0 1 1 2 0))
	(scale-channel 0.0 100 200)
	(let ((reader (make-sampler (- (framples) 1) ind 0 -1)))
	  (map-channel (lambda (y) (read-sample reader))))
	(let ((e (make-env '(0 0 1 1 2 0) :length 1001))
	      (new-reader (make-sampler 0 ind 0))
	      (len (framples)))
	  (call-with-exit
	   (lambda (quit)
	     (do ((old (env e) (env e))
		  (new (read-sample new-reader) (read-sample new-reader))
		  (i 0 (+ i 1)))
		 ((= i len))
	       (if (or (and (or (> i 900) (<= i 700))
			    (fneq old new))
		       (and (> i 700) (<= i 900)
			    (fneq new 0.0)))
		   (begin
		     (format #t "~%;trouble in reverse read 2 at ~D ~A ~A" i old new)
		     (quit)))))))
	(close-sound ind))
      (let ((ind (new-sound "test.snd" 1 22050 mus-ldouble mus-next)))
	(insert-silence 0 150000)
	(map-channel (lambda (y) 1.0))
	(let ((edpos (edit-position)))
	  (do ((i 0 (+ i 1)))
	      ((= i 7))
	    (if (= i 5)
		(scale-channel 0.5 1000 12345))
	    (env-sound '(0 0 1 1 2.5 0 3 1 4 0))
	    (if (= i 1)
		(delete-samples 50 100)
		(if (= i 2)
		    (insert-samples 300 100 (make-float-vector 100 0.5))
		    (if (= i 3)
			(scale-channel 0.0 1000 1000)
			(if (= i 4)
			    (float-vector->channel (make-float-vector 100 .5) 500 100)
			    (if (= i 6)
				(env-sound '(0 1 1 0) 10000 2000))))))
	    (let ((reader (make-sampler (- (framples) 1) ind 0 -1)))
	      (map-channel (lambda (y) (read-sample reader))))
	    (let ((reader (make-sampler (- (framples) 1) ind 0 -1)))
	      (map-channel (lambda (y) (read-sample reader))))
	    (let ((len (framples)))
	      (let ((v0 (samples 0 len ind 0 (- (edit-position ind 0) 2)))
		    (v1 (samples 0 len ind 0)))
		(if (not (vequal v0 v1))
		    (snd-display #__line__ "~%;trouble in reverse read ~A ~A" v0 v1))))
	    (set! (edit-position ind 0) edpos)))
	(close-sound ind))
      (let ((reader #f)
	    (last-proc #f))
	(define (scan-again)
	  (and (not (sampler-at-end? reader))
	       (let ((val (last-proc (reader))))
		 (if val 
		     (list val (- (sampler-position reader) 1))
		     (scan-again)))))
	(define* (my-scan-channel proc)
	  (if proc 
	      (begin
		(set! last-proc proc)
		(set! reader (make-sampler 0))))
	  (scan-again))
	(let ((ind (open-sound "oboe.snd"))
	      (val #f))
	  (let ((samp (sample 1000)))
	    (set! (cursor ind 0) 1000)
	    (if (fneq (sample) samp)
		(snd-display #__line__ ";sample no args: ~A ~A" (sample) samp)))
	  (set! val (my-scan-channel (lambda (y) (> y .1))))
	  (if (not (equal? val (list #t 4423)))
	      (snd-display #__line__ ";my-scan-chan: ~A" val))
	  (set! val (scan-again))
	  (if (not (equal? val (list #t 4463)))
	      (snd-display #__line__ ";scan-again: ~A" val))
	  (set! (cursor) 1000)
	  (set! (sample) .5)
	  (if (fneq (sample 1000) .5)
	      (snd-display #__line__ ";set sample no arg: ~A ~A" (sample 1000) (sample 0)))
	  (close-sound ind)))
      
      ;; edit-menu.scm tests
      (if (defined? 'selection->new)
	  (let ((ind (view-sound "oboe.snd")))
	    (make-selection 1000 1999 ind 0)
	    (let ((newsnd (selection->new)))
	      (if (not (sound? newsnd)) (snd-display #__line__ ";selection->new -> ~A" newsnd))
	      (if (not (= (framples newsnd 0) 1000)) (snd-display #__line__ ";selection->new framples: ~A" (framples newsnd 0)))
	      (if (not (equal? (edits ind 0) (list 0 0))) (snd-display #__line__ ";selection->new edited original? ~A" (edits ind 0)))
	      (let ((newfile (file-name newsnd)))
		(close-sound newsnd)
		(delete-file newfile)
		(mus-sound-forget newfile)))
	    (make-selection 1000 1999 ind 0)
	    (let ((newsnd (cut-selection->new)))
	      (if (not (sound? newsnd)) (snd-display #__line__ ";cut-selection->new -> ~A" newsnd))
	      (if (not (= (framples newsnd 0) 1000)) (snd-display #__line__ ";cut-selection->new framples: ~A" (framples newsnd 0)))
	      (if (not (equal? (edits ind 0) (list 1 0))) (snd-display #__line__ ";cut-selection->new did not edit original? ~A" (edits ind 0)))
	      (if (not (= (framples ind 0) (- (framples ind 0 0) 1000))) 
		  (snd-display #__line__ ";cut-selection->new cut: ~A ~A" (framples ind 0) (- (framples ind 0 0) 1000)))
	      (undo 1 ind 0)
	      (let ((newfile (file-name newsnd)))
		(close-sound newsnd)
		(delete-file newfile)
		(mus-sound-forget newfile)))
	    (make-selection 1000 1999 ind 0)
	    (append-selection)
	    (if (not (= (framples ind 0) (+ (framples ind 0 0) 1000)))
		(snd-display #__line__ ";append-selection: ~A ~A" (framples ind 0) (framples ind 0 0)))
	    (append-sound "oboe.snd")
	    (if (not (= (framples ind 0) (+ (* 2 (framples ind 0 0)) 1000)))
		(snd-display #__line__ ";append-sound: ~A ~A" (framples ind 0) (framples ind 0 0)))
	    (revert-sound ind)
	    (let ((m1 (add-mark 1000))
		  (m2 (add-mark 12000)))
	      (trim-front)
	      (if (not (equal? (edits ind 0) (list 1 0))) (snd-display #__line__ ";time-front did not edit original? ~A" (edits ind 0)))
	      (if (not (= (framples ind 0) (- (framples ind 0 0) 1000))) 
		  (snd-display #__line__ ";trim-front: ~A ~A" (framples ind 0) (- (framples ind 0 0) 1000)))
	      (if (not (= (mark-sample m2) 11000)) (snd-display #__line__ ";trim-front m2: ~A" (mark-sample m2)))
	      (undo 1 ind 0)
	      (trim-back)
	      (if (not (equal? (edits ind 0) (list 1 0))) (snd-display #__line__ ";time-back did not edit original? ~A" (edits ind 0)))
	      (if (not (= (framples ind 0) 12001)) (snd-display #__line__ ";trim-back: ~A" (framples ind 0)))
	      (if (not (= (mark-sample m1) 1000)) (snd-display #__line__ ";trim-back m1: ~A" (mark-sample m1)))
	      (undo 1 ind 0)
	      (add-mark 22000)
	      (crop)
	      (if (not (equal? (edits ind 0) (list 1 0))) (snd-display #__line__ ";crop did not edit original? ~A" (edits ind 0)))
	      (if (not (= (framples ind 0) 21001)) (snd-display #__line__ ";crop: ~A" (framples ind 0)))
	      (undo 1 ind 0)
	      (close-sound ind))))
      
      (let ((ind (new-sound "test.snd")))
	(map-channel (lambda (y) 1.0) 0 1001)
	(env-channel (make-env '(0 1 1 1) :scaler .5 :length 1001))
	(check-maxamp #__line__ ind .5 "simple scaler")
	(check-env-vals "simple scaler" (make-env '(0 1 1 1) :scaler .5 :length 1001))
	(if (= (edit-position) 2)
	    (undo)
	    (snd-display #__line__ ";env+scl was no-op"))
	(env-channel (make-env '(0 1 1 1) :offset .5 :length 1001))
	(check-maxamp #__line__ ind 1.5 "simple offset")
	(check-env-vals "simple offset" (make-env '(0 1 1 1) :offset .5 :length 1001))
	(if (= (edit-position) 2)
	    (undo)
	    (snd-display #__line__ ";env+offset was no-op"))
	(env-channel (make-env '(0 0 1 1 2 0) :offset .5 :scaler 2.0 :length 1001))
	(check-maxamp #__line__ ind 2.5 "off+scl")
	(check-env-vals "off+scl" (make-env '(0 0 1 1 2 0) :offset .5 :scaler 2.0 :length 1001))
	(undo)
	(env-channel (make-env '(0 -0.5 1 0 2 -1) :offset .5 :scaler 2.0 :length 1001))
	(check-maxamp #__line__ ind 1.5 "off+scl #2")
	(let ((mx -12.0))
	  (scan-channel (lambda (y) (not (set! mx (max mx y)))))
	  (if (fneq mx 0.5) (snd-display #__line__ ";non abs max: ~A (correct: 0.5)" mx)))
	(check-env-vals "off+scl #2" (make-env '(0 -0.5 1 0 2 -1) :offset .5 :scaler 2.0 :length 1001))
	(undo)
	(env-sound '(0 .5 1 .75 2 .25) 0 (framples) 32.0)
	(check-maxamp #__line__ ind 0.75 "xramp")
	(check-env-vals "xramp" (make-env '(0 .5 1 .75 2 .25) :base 32.0 :length 1001))
	(undo)
	(env-channel-with-base '(0 .5 1 .75 2 .25) 32.0)
	(check-maxamp #__line__ ind 0.75 "xramp1")
	(check-env-vals "xramp1" (make-env '(0 .5 1 .75 2 .25) :base 32.0 :length 1001))
	
	(close-sound ind))
      
      (let ((hlb (make-hilbert-transform 8))
	    (data (make-float-vector 20)))
	(do ((i 0 (+ i 1)))
	    ((= i 20))
	  (set! (data i) (hilbert-transform hlb (if (= i 0) 1.0 0.0))))
	(if (not (vequal data (float-vector 0.0 -0.010 0.0 -0.046 0.0 -0.152 0.0 -0.614 0.0 0.614 0.0 0.152 0.0 0.046 0.0 0.010 0.0 0.0 0.0 0.0)))
	    (snd-display #__line__ ";hilbert-transform 8 impulse response: ~A" data)))
      
      (let ((hlb (make-hilbert-transform 7))
	    (data (make-float-vector 20)))
	(do ((i 0 (+ i 1)))
	    ((= i 20))
	  (set! (data i) (hilbert-transform hlb (if (= i 0) 1.0 0.0))))
	(if (not (vequal data (float-vector -0.007 0.0 -0.032 0.0 -0.136 0.0 -0.608 0.0 0.608 0.0 0.136 0.0 0.032 0.0 0.007 0.0 0.0 0.0 0.0 0.0)))
	    (snd-display #__line__ ";hilbert-transform 7 impulse response: ~A" data)))
      
      (let ((ind (new-sound "test.snd")))
	(pad-channel 0 1000)
	(set! (sample 100) 1.0)
	(let ((h (make-hilbert-transform 100)))
	  (map-channel (lambda (y) (hilbert-transform h y)))
	  (map-channel (lambda (y) (hilbert-transform h y)))
	  (map-channel (lambda (y) (hilbert-transform h y)))
	  (map-channel (lambda (y) (hilbert-transform h y)))
	  ;; now ideally we'd be back to an impulse
	  (if (> (abs (- (sample 500) .98)) .01)
	      (snd-display #__line__ ";hilbert impulse: ~A" (sample 500)))
	  (set! (sample 500) 0.0)
	  (if (> (maxamp ind 0) .02)
	      (snd-display #__line__ ";hilbert sidelobes: ~A" (maxamp ind 0)))
	  (scale-channel 0.0)
	  (set! (sample 100) 1.0)
	  (set! h (make-hilbert-transform 101))
	  (map-channel (lambda (y) (hilbert-transform h y)))
	  (map-channel (lambda (y) (hilbert-transform h y)))
	  (map-channel (lambda (y) (hilbert-transform h y)))
	  (map-channel (lambda (y) (hilbert-transform h y)))
	  (if (> (abs (- (sample 504) .98)) .01)
	      (snd-display #__line__ ";hilbert 101 impulse: ~A: ~A" (sample 504) (channel->float-vector 498 10)))
	  (set! (sample 504) 0.0)
	  (if (> (maxamp ind 0) .02)
	      (snd-display #__line__ ";hilbert 101 sidelobes: ~A" (maxamp ind 0)))
	  (revert-sound))
	(pad-channel 0 1000)
	(set! (sample 100) 1.0)
	(let ((lo (make-lowpass (* .1 pi) 20))
	      (hi (make-highpass (* .1 pi) 20)))
	  (map-channel (lambda (y) (+ (lowpass lo y) (highpass hi y))))
	  (if (fneq (sample 120) 1.0)
	      (snd-display #__line__ ";lowpass+highpass impulse: ~A" (sample 120)))
	  (set! (sample 120) 0.0)
	  (if (fneq (maxamp ind 0) 0.0)
	      (snd-display #__line__ ";lowpass+highpass sidelobes: ~A" (maxamp ind 0))))
	(undo 2)
	(let ((lo (make-bandpass (* .1 pi) (* .2 pi) 20))
	      (hi (make-bandstop (* .1 pi) (* .2 pi) 20)))
	  (map-channel (lambda (y) (+ (bandpass lo y) (bandstop hi y))))
	  (if (fneq (sample 120) 1.0)
	      (snd-display #__line__ ";bandpass+bandstop impulse: ~A" (sample 120)))
	  (set! (sample 120) 0.0)
	  (if (fneq (maxamp ind 0) 0.0)
	      (snd-display #__line__ ";bandpass+bandstop sidelobes: ~A" (maxamp ind 0))))
	(close-sound ind))
      
      (let ((ind (new-sound "test.snd")))
	(map-channel (lambda (y) (mus-random 1.0)) 0 10000)
	(let ((f2 (make-bandpass-2 (* .12 pi) (* .15 pi) (* .22 pi) (* .25 pi) 100)))
	  (map-channel (lambda (y) (fir-filter f2 y)))
	  (let ((data (channel->float-vector)))
	    (undo)
	    (let ((f1 (make-bandpass (* .12 pi) (* .15 pi) 100))
		  (f2 (make-bandpass (* .22 pi) (* .25 pi) 100)))
	      (map-channel (lambda (y) (+ (fir-filter f1 y) (fir-filter f2 y))))
	      (let ((data1 (channel->float-vector)))
		(float-vector-subtract! data data1)
		(if (> (float-vector-peak data) .00001)
		    (snd-display #__line__ ";fir-filter 2: ~A" (float-vector-peak data))))
	      (undo))))
	(close-sound ind))
      
      (reset-all-hooks)
      
      (let ((ind (new-sound  "test.snd" 1 22050 mus-ldouble mus-next "first ramp re-order tests" 100)))
	(map-channel (lambda (y) 1.0))
	(for-each
	 (lambda (lst)
	   (let ((name (car lst))
		 (try-scale (cadr lst))
		 (f1 (caddr lst))
		 (f2 (cadddr lst))
		 (edpos (edit-position ind 0)))
	     (f1)
	     (let ((v1 (channel->float-vector 0 100 ind 0)))
	       (set! (edit-position ind 0) edpos)
	       (f2)
	       (let ((v2 (channel->float-vector 0 100 ind 0)))
		 (if (not (vequal v1 v2))
		     (snd-display #__line__ ";env reordering test ~A:~%; ~A~%; ~A" name v1 v2))
		 (set! (edit-position ind 0) edpos)))
	     (if try-scale
		 (begin
		   (scale-by 2.0)
		   (f1)
		   (let ((v1 (channel->float-vector 0 100 ind 0)))
		     (set! (edit-position ind 0) edpos)
		     (f2)
		     (scale-by 2.0)
		     (let ((v2 (channel->float-vector 0 100 ind 0)))
		       (if (not (vequal v1 v2))
			   (snd-display #__line__ ";scaled (2) env reordering test ~A:~%; ~A~%; ~A" name v1 v2))
		       (set! (edit-position ind 0) edpos)))
		   (f1)
		   (scale-by .5)
		   (let ((v1 (channel->float-vector 0 100 ind 0)))
		     (set! (edit-position ind 0) edpos)
		     (scale-by .5)
		     (f2)
		     (let ((v2 (channel->float-vector 0 100 ind 0)))
		       (if (not (vequal v1 v2))
			   (snd-display #__line__ ";scaled (.5) env reordering test ~A:~%; ~A~%; ~A" name v1 v2))
		       (set! (edit-position ind 0) edpos)))))))
	 
	 (list (list "ramp-xramp" #t
		     (lambda ()
		       (env-sound '(0 0 1 1 2 0))
		       (env-sound '(0 0 1 1) 0 100 2.0))
		     (lambda ()
		       (env-sound '(0 0 1 1) 0 100 2.0)
		       (env-sound '(0 0 1 1 2 0))))
	       (list "ramp2-xramp (1)" #t
		     (lambda ()
		       (env-sound '(0 0 1 1 2 0))
		       (env-sound '(0 0 1 1 3 0))
		       (env-sound '(0 0 1 1) 0 100 2.0))
		     (lambda ()
		       (env-sound '(0 0 1 1 2 0))
		       (env-sound '(0 0 1 1) 0 100 2.0)
		       (env-sound '(0 0 1 1 3 0))))
	       (list "ramp2-xramp (2)" #t
		     (lambda ()
		       (env-sound '(0 0 1 1 2 0))
		       (env-sound '(0 0 1 1))
		       (env-sound '(0 0 1 1 3 0) 0 100 2.0))
		     (lambda ()
		       (env-sound '(0 0 1 1 3 0) 0 100 2.0)
		       (env-sound '(0 0 1 1 2 0))
		       (env-sound '(0 0 1 1))))
	       (list "xramp2-ramp (1)" #t
		     (lambda ()
		       (env-sound '(0 0 1 1 2 0) 0 100 2.0)
		       (env-sound '(0 0 1 1))
		       (env-sound '(0 0 1 1 3 0) 0 100 3.0))
		     (lambda ()
		       (env-sound '(0 0 1 1 2 0) 0 100 2.0)
		       (env-sound '(0 0 1 1 3 0) 0 100 3.0)
		       (env-sound '(0 0 1 1))))
	       (list "xramp2-ramp (2)" #t
		     (lambda ()
		       (env-sound '(0 0 1 1 2 0) 0 100 2.0)
		       (env-sound '(0 0 1 1 3 0))
		       (env-sound '(0 0 1 1) 0 100 3.0))
		     (lambda ()
		       (env-sound '(0 0 1 1 3 0))
		       (env-sound '(0 0 1 1 2 0) 0 100 2.0)
		       (env-sound '(0 0 1 1) 0 100 3.0)))
	       ))
	(close-sound ind))
      ))
  
  (let ((ind (open-sound "oboe.snd")))
    ;; simple cases
    
    (as-one-edit
     (lambda ()
       (set! (sample 10) 1.0)))
    (if (fneq (sample 10) 1.0) (snd-display #__line__ ";as-one-edit 1: ~A" (sample 10)))
    (if (not (= (edit-position ind 0) 1)) 
	(snd-display #__line__ ";as-one-edit 1 edpos: ~A" (edit-position ind 0))
	(begin
	  (if (not (equal? (edit-fragment 1 ind 0) (list "set-sample 10 1.0000" "set" 10 1)))
	      (snd-display #__line__ ";as-one-edit 1 edlist: ~A" (edit-fragment 1 ind 0)))
	  (if (not (equal? (edit-fragment 0 ind 0) (list "" "init" 0 50828)))
	      (snd-display #__line__ ";as-one-edit 1 original edlist: ~A" (edit-fragment 0 ind 0)))))
    
    (revert-sound ind)
    (as-one-edit
     (lambda ()
       (set! (sample 10) 1.0)
       (map-channel (lambda (y) (* y 2.0)) 0 20 ind 0 #f "map-channel as-one-edit")
       (if (not (= (edit-position ind 0) 2)) (snd-display #__line__ ";as-one-edit 2 edpos internal: ~A" (edit-position ind 0))))
     "as-one-edit test-2")
    (if (fneq (sample 10) 2.0) (snd-display #__line__ ";as-one-edit 2: ~A" (sample 10)))
    (if (not (= (edit-position ind 0) 1)) 
	(snd-display #__line__ ";as-one-edit 2 edpos: ~A" (edit-position ind 0))
	(if (not (equal? (edit-fragment 0 ind 0) (list "" "init" 0 50828)))
	    (snd-display #__line__ ";as-one-edit 2 original edlist: ~A" (edit-fragment 0 ind 0))))
    
    (revert-sound ind)
    (let ((ind2 (open-sound "2a.snd")))
      (set! (sample 1 ind2 0) 1.0)
      (set! (sample 2 ind2 1) 0.5)
      (set! (selected-sound) ind)
      
      (as-one-edit
       (lambda ()
	 (set! (sample 10 ind 0) 1.0)))
      (if (fneq (sample 10 ind 0) 1.0) (snd-display #__line__ ";as-one-edit 3: ~A" (sample 10 ind 0)))
      (if (not (= (edit-position ind 0) 1)) (snd-display #__line__ ";as-one-edit 3 edpos: ~A" (edit-position ind 0)))
      (if (not (= (edit-position ind2 0) 1)) (snd-display #__line__ ";as-one-edit 3 2 edpos: ~A" (edit-position ind2 0)))
      (if (not (= (edit-position ind2 1) 1)) (snd-display #__line__ ";as-one-edit 3 2 1 edpos: ~A" (edit-position ind2 1)))
      (if (not (equal? (edit-fragment 1 ind 0) (list "set-sample 10 1.0000" "set" 10 1)))
	  (snd-display #__line__ ";as-one-edit 3 edlist: ~A" (edit-fragment 1 ind 0)))
      (if (not (equal? (edit-fragment 1 ind2 0) (list "set-sample 1 1.0000" "set" 1 1)))
	  (snd-display #__line__ ";as-one-edit 3 2 edlist: ~A" (edit-fragment 1 ind2 0)))
      (if (not (equal? (edit-fragment 1 ind2 1) (list "set-sample 2 0.5000" "set" 2 1)))
	  (snd-display #__line__ ";as-one-edit 3 2 1 edlist: ~A" (edit-fragment 1 ind2 1)))
      
      (revert-sound ind)
      
      (as-one-edit    
       (lambda ()
	 (set! (sample 10 ind 0) 1.0)
	 (map-channel (lambda (y) (* y 2.0)) 0 20 ind 0 #f "map-channel as-one-edit 2")
	 (if (not (= (edit-position ind 0) 2)) (snd-display #__line__ ";as-one-edit 4 edpos internal: ~A" (edit-position ind 0))))
       "as-one-edit test-4")
      (if (fneq (sample 10) 2.0) (snd-display #__line__ ";as-one-edit 4: ~A" (sample 10 ind 0)))
      (if (not (= (edit-position ind 0) 1)) 
	  (snd-display #__line__ ";as-one-edit 4 edpos: ~A" (edit-position ind 0)))
      (if (not (equal? (edit-fragment 1 ind2 0) (list "set-sample 1 1.0000" "set" 1 1)))
	  (snd-display #__line__ ";as-one-edit 3 2 edlist: ~A" (edit-fragment 1 ind2 0)))
      (if (not (equal? (edit-fragment 1 ind2 1) (list "set-sample 2 0.5000" "set" 2 1)))
	  (snd-display #__line__ ";as-one-edit 3 2 1 edlist: ~A" (edit-fragment 1 ind2 1)))
      
      (revert-sound ind)
      (set! (sample 3 ind 0) 1.0)
      
      (as-one-edit
       (lambda ()
	 (set! (sample 10 ind 0) 1.0)
	 (set! (sample 10 ind2 0) 0.5)
	 (set! (sample 10 ind2 1) 0.4)))
      (if (fneq (sample 3 ind 0) 1.0) (snd-display #__line__ ";as-one-edit 5 (3): ~A" (sample 3 ind 0)))
      (if (fneq (sample 10 ind 0) 1.0) (snd-display #__line__ ";as-one-edit 5 (10): ~A" (sample 10 ind 0)))
      (if (fneq (sample 10 ind2 0) 0.5) (snd-display #__line__ ";as-one-edit 5 (2 10): ~A" (sample 10 ind2 0)))
      (if (fneq (sample 10 ind2 1) 0.4) (snd-display #__line__ ";as-one-edit 5 (2 1 10): ~A" (sample 10 ind2 1)))
      (if (not (= (edit-position ind 0) 2)) (snd-display #__line__ ";as-one-edit 5 edpos: ~A" (edit-position ind 0)))
      (if (not (= (edit-position ind2 0) 2)) (snd-display #__line__ ";as-one-edit 5 2 edpos: ~A" (edit-position ind2 0)))
      (if (not (= (edit-position ind2 1) 2)) (snd-display #__line__ ";as-one-edit 5 2 1 edpos: ~A" (edit-position ind2 1)))
      
      (if (not (equal? (edit-fragment 2 ind 0) (list "set-sample 10 1.0000" "set" 10 1)))
	  (snd-display #__line__ ";as-one-edit 5 edlist 2: ~A" (edit-fragment 1 ind 0)))
      (if (not (equal? (edit-fragment 1 ind 0) (list "set-sample 3 1.0000" "set" 3 1)))
	  (snd-display #__line__ ";as-one-edit 5 edlist 1: ~A" (edit-fragment 1 ind 0)))
      (if (not (equal? (edit-fragment 0 ind 0) (list "" "init" 0 50828)))
	  (snd-display #__line__ ";as-one-edit 5 original edlist: ~A" (edit-fragment 0 ind 0)))
      (if (not (equal? (edit-fragment 2 ind2 0) (list "set-sample 10 0.5000" "set" 10 1)))
	  (snd-display #__line__ ";as-one-edit 5 edlist 2 1: ~A" (edit-fragment 1 ind2 0)))
      
      (as-one-edit
       (lambda ()
	 (map-channel (lambda (y) (* y 2.0)) 0 20 ind 0 #f "map-channel as-one-edit 6")
	 (map-channel (lambda (y) (* y 2.0)) 0 20 ind2 1 #f "map-channel as-one-edit 6 2 1"))
       "as-one-edit test-6")
      
      
      (if (fneq (sample 3 ind 0) 2.0) (snd-display #__line__ ";as-one-edit 6 (3): ~A" (sample 3 ind 0)))
      (if (fneq (sample 10 ind 0) 2.0) (snd-display #__line__ ";as-one-edit 6 (10): ~A" (sample 10 ind 0)))
      (if (fneq (sample 10 ind2 0) 0.5) (snd-display #__line__ ";as-one-edit 6 (2 10): ~A" (sample 10 ind2 0)))
      (if (fneq (sample 10 ind2 1) 0.8) (snd-display #__line__ ";as-one-edit 6 (2 1 10): ~A" (sample 10 ind2 1)))
      (if (not (= (edit-position ind 0) 3)) (snd-display #__line__ ";as-one-edit 6 edpos: ~A" (edit-position ind 0)))
      (if (not (= (edit-position ind2 0) 2)) (snd-display #__line__ ";as-one-edit 6 2 edpos: ~A" (edit-position ind2 0)))
      (if (not (= (edit-position ind2 1) 3)) (snd-display #__line__ ";as-one-edit 6 2 1 edpos: ~A" (edit-position ind2 1)))
      
      (if (not (equal? (edit-fragment 2 ind 0) (list "set-sample 10 1.0000" "set" 10 1)))
	  (snd-display #__line__ ";as-one-edit 5 edlist 2: ~A" (edit-fragment 1 ind 0)))
      (if (not (equal? (edit-fragment 2 ind2 0) (list "set-sample 10 0.5000" "set" 10 1)))
	  (snd-display #__line__ ";as-one-edit 5 edlist 2 1: ~A" (edit-fragment 1 ind2 0)))
      (close-sound ind2))
    
    ;; nested cases
    (revert-sound ind)
    
    (as-one-edit
     (lambda ()
       (set! (sample 100) .9)
       (as-one-edit
	(lambda ()
	  (set! (sample 200) .8)
	  (set! (sample 300) .7)))
       (set! (sample 300) .6)))
    (if (or (fneq (sample 100) .9)
	    (fneq (sample 200) .8)
	    (fneq (sample 300) .6))
	(snd-display #__line__ ";nested as-one-edit 7: ~A ~A ~A" (sample 100) (sample 200) (sample 300)))
    (if (not (= (edit-position ind 0) 1))
	(snd-display #__line__ ";nested as-one-edit 7 edpos: ~A" (edit-position ind 0)))
    (if (squelch-update ind 0)
	(begin
	  (snd-display #__line__ ";nested as-one-edit 7 squelch is on")
	  (set! (squelch-update) #f)))
    (if (not (equal? (edit-fragment 1 ind 0) (list "set-sample 300 0.6000" "set" 100 204)))
	(snd-display #__line__ ";as-one-edit 7 edlist: ~A" (edit-fragment 1 ind 0)))
    
    (revert-sound ind)
    (as-one-edit
     (lambda ()
       (set! (sample 100) .9)
       (as-one-edit
	(lambda ()
	  (set! (sample 200) .8)
	  (set! (sample 300) .7)))
       (set! (sample 300) .6))
     "as-one-edit test-8")
    (if (or (fneq (sample 100) .9)
	    (fneq (sample 200) .8)
	    (fneq (sample 300) .6))
	(snd-display #__line__ ";nested as-one-edit 8: ~A ~A ~A" (sample 100) (sample 200) (sample 300)))
    (if (not (= (edit-position ind 0) 1))
	(snd-display #__line__ ";nested as-one-edit 8 edpos: ~A" (edit-position ind 0)))
    (if (not (equal? (edit-fragment 1 ind 0) (list "as-one-edit test-8" "set" 100 204)))
	(snd-display #__line__ ";as-one-edit 8 edlist: ~A" (edit-fragment 1 ind 0)))
    
    (revert-sound ind)
    (as-one-edit
     (lambda ()
       (set! (sample 100) .9)
       (as-one-edit
	(lambda ()
	  (set! (sample 200) .8)
	  (set! (sample 300) .7))
	"as-one-edit 9 internal")
       (set! (sample 300) .6))
     "as-one-edit test-9")
    (if (or (fneq (sample 100) .9)
	    (fneq (sample 200) .8)
	    (fneq (sample 300) .6))
	(snd-display #__line__ ";nested as-one-edit 9: ~A ~A ~A" (sample 100) (sample 200) (sample 300)))
    (if (not (= (edit-position ind 0) 1))
	(snd-display #__line__ ";nested as-one-edit 9 edpos: ~A" (edit-position ind 0)))
    (if (not (equal? (edit-fragment 1 ind 0) (list "as-one-edit test-9" "set" 100 204)))
	(snd-display #__line__ ";as-one-edit 9 edlist: ~A" (edit-fragment 1 ind 0)))
    
    (revert-sound ind)
    (as-one-edit
     (lambda ()
       (set! (sample 100) .9)
       (as-one-edit
	(lambda ()
	  (set! (sample 200) .8)
	  (as-one-edit
	   (lambda ()
	     (set! (sample 400) .3))
	   "not a name")
	  (set! (sample 300) .7))
	"as-one-edit 10 internal")
       (set! (sample 300) .6))
     "as-one-edit test-10")
    (if (or (fneq (sample 100) .9)
	    (fneq (sample 200) .8)
	    (fneq (sample 300) .6)
	    (fneq (sample 400) .3))
	(snd-display #__line__ ";nested as-one-edit 10: ~A ~A ~A ~A" (sample 100) (sample 200) (sample 300) (sample 400)))
    (if (not (= (edit-position ind 0) 1))
	(snd-display #__line__ ";nested as-one-edit 10 edpos: ~A" (edit-position ind 0)))
    (if (not (equal? (edit-fragment 1 ind 0) (list "as-one-edit test-10" "set" 100 305)))
	(snd-display #__line__ ";as-one-edit 10 edlist: ~A" (edit-fragment 1 ind 0)))
    
    ;; try implicit as-one-edits nested
    (revert-sound ind)
    (env-channel-with-base '(0 0 1 1 2 .5 3 .25 4 0) 0.0 0 #f ind 0)
    (if (not (= (edit-position ind 0) 1)) (snd-display #__line__ ";as-one-edit 11 edpos: ~A" (edit-position ind 0)))
    (if (not (equal? (edit-fragment 1 ind 0) 
		     (list "env-channel-with-base '(0.000 0.000 1.000 1.000 2.000 0.500 3.000 0.250 4.000 0.000) 0.0000 0 #f" "scale" 0 50830)))
	(snd-display #__line__ ";as-one-edit 11: ~A" (edit-fragment 1 ind 0)))
    
    (revert-sound ind)
    (as-one-edit
     (lambda ()
       (env-channel-with-base '(0 0 1 1 2 .5 3 .25 4 0) 0.0 0 #f ind 0))
     "as-one-edit 12")
    (if (not (= (edit-position ind 0) 1)) (snd-display #__line__ ";as-one-edit 12 edpos: ~A" (edit-position ind 0)))
    (if (not (equal? (edit-fragment 1 ind 0) (list "as-one-edit 12" "scale" 0 50830)))
	(snd-display #__line__ ";as-one-edit 12: ~A" (edit-fragment 1 ind 0)))
    
    (revert-sound ind)
    (let ((m1 #f)
	  (m2 #f)
	  (m3 #f)
	  (m4 #f))
      (as-one-edit
       (lambda ()
	 (set! m1 (add-mark 1234 ind 0))
	 (set! (sample 1236 ind 0) .6)
	 (as-one-edit
	  (lambda ()
	    (set! (sample 123 ind 0) .3)
	    (set! m2 (add-mark 1235 ind 0)))
	  "as-one-edit inner 1")
	 (if (not (mark? m1)) (snd-display #__line__ ";as-one-edit stepped on m1: ~A" m1))
	 (if (not (mark? m2)) (snd-display #__line__ ";as-one-edit stepped on m2: ~A" m2))
	 (as-one-edit
	  (lambda ()
	    (set! m3 (add-mark 1238 ind 0))
	    (set! (sample 1238 ind 0) .8))
	  "as-one-edit inner 2")
	 (set! (sample 1239 ind 0) .9)
	 (set! m4 (add-mark 1237 ind 0)))
       "outer as-one-edit")
      (if (not (mark? m1)) (snd-display #__line__ ";second as-one-edit stepped on m1: ~A" m1))
      (if (not (mark? m2)) (snd-display #__line__ ";second as-one-edit stepped on m2: ~A" m2))
      (if (not (mark? m3)) (snd-display #__line__ ";second as-one-edit stepped on m3: ~A" m3))
      (if (not (mark? m4)) (snd-display #__line__ ";second as-one-edit stepped on m4: ~A" m4))
      (if (not (= (mark-sample m1) 1234)) (snd-display #__line__ ";as-one-edit m1 sample: ~A (1234)" (mark-sample m1)))
      (if (not (= (mark-sample m2) 1235)) (snd-display #__line__ ";as-one-edit m2 sample: ~A (1235)" (mark-sample m2)))
      (if (not (= (mark-sample m3) 1238)) (snd-display #__line__ ";as-one-edit m3 sample: ~A (1238)" (mark-sample m3)))
      (if (not (= (mark-sample m4) 1237)) (snd-display #__line__ ";as-one-edit m4 sample: ~A (1237)" (mark-sample m4)))
      (if (not (string=? (display-edits ind 0) (string-append "
EDITS: 1

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:50827, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 50828, end_mark)

 (set 123 1120) ; outer as-one-edit [1:9]:
   (at 0, cp->sounds[0][0:122, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 123, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 124, cp->sounds[0][124:1235, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 1236, cp->sounds[1][0:0, 1.000]) [buf: 1] 
   (at 1237, cp->sounds[0][1237:1237, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 1238, cp->sounds[3][0:0, 1.000]) [buf: 1] 
   (at 1239, cp->sounds[4][0:0, 1.000]) [buf: 1] 
   (at 1240, cp->sounds[0][1240:50827, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 50828, end_mark)
")))
	  (snd-display #__line__ ";as-one-edit edits: ~A" (display-edits ind 0)))
      
      (revert-sound ind))
    
    (let ((m1 #f)
	  (m2 #f)
	  (m3 #f)
	  (m4 #f))
      (as-one-edit
       (lambda ()
	 (set! m1 (mix-float-vector (float-vector .1 .2 .3) 1234 ind 0))
	 (set! (sample 1236 ind 0) .6)
	 (as-one-edit
	  (lambda ()
	    (set! (sample 123 ind 0) .3)
	    (set! m2 (mix-float-vector (float-vector .1 .2 .3) 1235 ind 0)))
	  "as-one-edit inner 1")
	 (if (not (mix? m1)) (snd-display #__line__ ";as-one-edit stepped on m1: ~A" m1))
	 (if (not (mix? m2)) (snd-display #__line__ ";as-one-edit stepped on m2: ~A" m2))
	 (as-one-edit
	  (lambda ()
	    (set! m3 (mix-float-vector (float-vector .1 .2 .3) 1238 ind 0))
	    (set! (sample 1238 ind 0) .8))
	  "as-one-edit inner 2")
	 (set! (sample 1239 ind 0) .9)
	 (set! m4 (mix-float-vector (float-vector .1 .2 .3) 1237 ind 0)))
       "outer as-one-edit")
      (if (not (mix? m1)) (snd-display #__line__ ";second as-one-edit stepped on mx1: ~A" m1))
      (if (not (mix? m2)) (snd-display #__line__ ";second as-one-edit stepped on mx2: ~A" m2))
      (if (not (mix? m3)) (snd-display #__line__ ";second as-one-edit stepped on mx3: ~A" m3))
      (if (not (mix? m4)) (snd-display #__line__ ";second as-one-edit stepped on mx4: ~A" m4))
      (revert-sound ind))
    
    (let ((ind2 #f))
      (as-one-edit
       (lambda ()
	 (set! ind2 (open-sound "pistol.snd"))
	 (set! (sample 100 ind 0) .5)
	 (set! (sample 200 ind2 0) .6))
       "as-one-edit+open")
      (if (not (sound? ind2)) (snd-display #__line__ ";as-one-edit didn't open sound? ~A ~A" ind2 (sounds)))
      (if (not (= (edit-position ind2 0) 1)) (snd-display #__line__ ";edpos as-one-edit opened sound: ~A" (edit-position ind2 0)))
      (if (not (= (edit-position ind 0) 1)) (snd-display #__line__ ";edpos as-one-edit original sound: ~A" (edit-position ind 0)))
      (if (not (equal? (edit-fragment 1 ind 0) (list "as-one-edit+open" "set" 100 1)))
	  (snd-display #__line__ ";as-one-edit open sound edlist orig: ~A" (edit-fragment 1 ind 0)))
      (if (not (equal? (edit-fragment 1 ind2 0) (list "set-sample 200 0.6000" "set" 200 1)))
	  (snd-display #__line__ ";as-one-edit open sound edlist new: ~A" (edit-fragment 1 ind2 0)))
      
      (as-one-edit
       (lambda ()
	 (set! (sample 200 ind 0) .7)
	 (close-sound ind2))
       "as-one-edit+close")
      (if (sound? ind2) 
	  (begin
	    (snd-display #__line__ ";as-one-edit didn't close sound? ~A ~A" ind2 (sounds))
	    (close-sound ind2)))
      (if (not (= (edit-position ind 0) 2)) (snd-display #__line__ ";edpos as-one-edit close original sound: ~A" (edit-position ind 0)))
      (if (not (string=? (display-edits ind 0) (string-append "
EDITS: 2

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:50827, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 50828, end_mark)

 (set 100 1) ; as-one-edit+open [1:4]:
   (at 0, cp->sounds[0][0:99, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 100, cp->sounds[1][0:0, 1.000]) [buf: 1] 
   (at 101, cp->sounds[0][101:50827, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 50828, end_mark)

 (set 200 1) ; as-one-edit+close [2:6]:
   (at 0, cp->sounds[0][0:99, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 100, cp->sounds[1][0:0, 1.000]) [buf: 1] 
   (at 101, cp->sounds[0][101:199, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 200, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 201, cp->sounds[0][201:50827, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 50828, end_mark)
")))
	  (snd-display #__line__ ";as-one-edit open+close: ~A" (display-edits ind 0))))
    
    (close-sound ind))  
  
  (let ((ind1 (open-sound "oboe.snd"))
	(ind2 #f))
    (as-one-edit 
     (lambda ()
       (set! (sample 100 ind1 0) .5)
       (set! ind2 (open-sound "pistol.snd"))
       (as-one-edit
	(lambda ()
	  (set! (sample 200 ind2 0) .5)
	  (close-sound ind1))
	"inner edit")
       (set! (sample 300 ind2 0) .6))
     "outer edit")
    (if (sound? ind1) (snd-display #__line__ ";as-one-edit close inner: ~A ~A" ind1 (sounds)))
    (if (not (sound? ind2)) (snd-display #__line__ ";as-one-edit open inner: ~A ~A" ind2 (sounds)))
    
    (revert-sound ind2)
    (as-one-edit
     (lambda ()
       (set! ind1 (open-sound "oboe.snd"))
       (as-one-edit
	(lambda ()
	  (set! (sample 200 ind1 0) .5))
	"inner edit")
       (set! (sample 100 ind2 0) .4))
     "outer edit")
    (close-sound ind1)
    (close-sound ind2))
  
  (let* ((ind (open-sound "oboe.snd"))
	 (mx (maxamp ind 0)))
    (let ((tag (catch #t
		 (lambda () (as-one-edit (lambda (oops) #f)))
		 (lambda args (car args)))))
      (if (not (eq? tag 'bad-arity))
	  (snd-display #__line__ ";as-one-edit arg? ~A" tag)))
    (let ((tag (catch #t
		 (lambda () (as-one-edit (lambda* (oops) #f)))
		 (lambda args (car args)))))
      (if (not (eq? tag 'bad-arity))
	  (snd-display #__line__ ";as-one-edit arg? ~A" tag)))
    (close-sound ind))
  (let ((ind (new-sound  "test.snd" 1 22050 mus-ldouble mus-next "more tests" 10)))
    ;; offset-channel
    (offset-channel .1)
    (if (not (vequal (channel->float-vector 0 10) (make-float-vector 10 .1)))
	(snd-display #__line__ ";offset-channel (.1): ~A" (channel->float-vector 0 10)))
    (offset-channel -.2 5 5)
    (if (not (vequal (channel->float-vector 0 10) (float-vector .1 .1 .1 .1 .1 -.1 -.1 -.1 -.1 -.1)))
	(snd-display #__line__ ";offset-channel (-.1): ~A" (channel->float-vector 0 10)))
    (undo)
    (offset-channel .9 0 10 ind 0)
    (if (not (vequal (channel->float-vector 0 10) (make-float-vector 10 1.0)))
	(snd-display #__line__ ";offset-channel (1): ~A" (channel->float-vector 0 10)))
    ;; sine-env and sine-ramp...
    (revert-sound ind)
    (map-channel (lambda (y) 1.0))
    (sine-ramp 0.0 1.0)
    (if (not (vequal (channel->float-vector) (float-vector 0.000 0.024 0.095 0.206 0.345 0.500 0.655 0.794 0.905 0.976)))
	(snd-display #__line__ ";sine-ramp 0 1: ~A" (channel->float-vector)))
    (revert-sound ind)
    (offset-channel 1.0)
    (sine-ramp 1.0 0.0)
    (if (not (vequal (channel->float-vector) (float-vector 1.000 0.976 0.905 0.794 0.655 0.500 0.345 0.206 0.095 0.024)))
	(snd-display #__line__ ";sine-ramp 1 0: ~A" (channel->float-vector)))
    (close-sound ind)
    (set! ind (new-sound  "test.snd" 1 22050 mus-ldouble mus-next "sine-env tests" 100))
    (map-channel (lambda (y) 1.0))
    (sine-env-channel '(0 0 1 1 2 -.5 3 1))
    (if (not (= (edit-position ind 0) 2)) (snd-display #__line__ ";as-one-edit sine-env-channel: ~A" (edit-position ind 0)))
    (revert-sound ind)
    (offset-channel -1.0)
    (sine-env-channel '(0 0 1 1 2 1 3 0) 40 20)
    (if (or (not (vequal (channel->float-vector 40 20) (float-vector -0.000 -0.050 -0.188 -0.389 -0.611 -0.812 -0.950 -1.000 -1.000 -1.000
								     -1.000 -1.000 -1.000 -1.000 -1.000 -0.950 -0.812 -0.611 -0.389 -0.188)))
	    (not (vequal (channel->float-vector 30 10) (make-float-vector 10 -1.0))))
	(snd-display #__line__ ";off+sine-env: ~A ~A" (channel->float-vector 40 20) (channel->float-vector 30 10)))
    (revert-sound ind)
    (scale-by 0.0)
    (dither-channel)
    (let ((mx (maxamp)))
      (if (or (< mx .00003) (> mx .0001))
	  (snd-display #__line__ ";dithering: ~A" mx)))
    (revert-sound ind)
    (map-channel (ring-mod 10 (list 0 0 1 (hz->radians 100))))
    (osc-formants .99 (float-vector 400.0 800.0 1200.0) (float-vector 400.0 800.0 1200.0) (float-vector 4.0 2.0 3.0))
    (map-channel (zecho .5 .75 6 10.0))
    (map-channel (flecho .5 .9))
    (filtered-env '(0 0 1 1 2 0))
    (map-channel (formant-filter .99 2400))
    (map-channel (comb-filter .8 32))
    (map-channel (zcomb .8 32 '(0 0 1 10)))
    (map-channel (notch-filter .8 32))
    (let ((ind1 (open-sound "now.snd")))
      (select-sound ind1)
      (if (fneq (maxamp) .309) (snd-display #__line__ ";squelch-vowels init: ~A" (maxamp)))
      (squelch-vowels)
      (if (fneq (maxamp) .047) (snd-display #__line__ ";squelch-vowels maxamp: ~A" (maxamp)))
      (select-sound ind)
      (map-channel (cross-synthesis ind1 .5 128 6.0))
      (revert-sound ind1)
      (fft-edit 40 8000)
      (fft-squelch .1)
      (close-sound ind)
      (revert-sound ind1)
      (scramble-channel .01)
      (revert-sound ind1)
      (close-sound ind1)))
  
  (let ((ind (new-sound  "test.snd" 1 22050 mus-ldouble mus-next "special env tests" 100)))
    (map-channel (lambda (y) 1.0))
    
    (blackman4-ramp 0.0 1.0)
    (let ((vals (channel->float-vector)))
      (undo)
      (blackman4-env-channel '(0 0 1 1))
      (let ((new-vals (channel->float-vector)))
	(if (not (vequal vals new-vals))
	    (snd-display #__line__ ";blackman4-env-channel/ramp: ~A ~A" vals new-vals))
	(undo)
	(blackman4-ramp 0.0 1.0 0 50)
	(set! vals (channel->float-vector))
	(undo)
	(blackman4-env-channel '(0 0 1 1 2 1))
	(set! new-vals (channel->float-vector))
	(if (not (vequal vals new-vals))
	    (snd-display #__line__ ";blackman4-env-channel/ramp 1: ~A ~A" vals new-vals))
	(undo)
	(blackman4-env-channel '(0 0 1 1 2 -.5 3 0))
	(if (not (vequal (channel->float-vector 60 10) (float-vector -0.109 -0.217 -0.313 -0.392 -0.451 -0.488 -0.499 -0.499 -0.499 -0.499)))
	    (snd-display #__line__ ";blackman4 to -.5: ~A" (channel->float-vector 60 10)))
	(undo)
	
	(ramp-squared 0.0 1.0)
	(set! vals (channel->float-vector))
	(undo)
	(env-squared-channel '(0 0 1 1))
	(set! new-vals (channel->float-vector))
	(if (not (vequal vals new-vals))
	    (snd-display #__line__ ";env-squared/ramp: ~A ~A" vals new-vals))
	(undo)
	(ramp-squared 0.0 1.0 #t 0 50)
	(set! vals (channel->float-vector))
	(undo)
	(env-squared-channel '(0 0 1 1 2 1))
	(set! new-vals (channel->float-vector))
	(if (not (vequal vals new-vals))
	    (snd-display #__line__ ";env-squared/ramp 1: ~A ~A" vals new-vals))
	(undo)
	(env-squared-channel '(0 0 1 1 2 -.5 3 0))
	(if (not (vequal (channel->float-vector 60 10) (float-vector -0.450 -0.466 -0.478 -0.488 -0.494 -0.499 -0.500 -0.500 -0.498 -0.496)))
	    (snd-display #__line__ ";env-squared to -.5: ~A" (channel->float-vector 60 10)))
	(undo)
	(env-squared-channel '(0 0 1 1 2 -.5 3 0) #f)
	(if (not (vequal (channel->float-vector 60 10) (float-vector -0.004 -0.080 -0.158 -0.240 -0.324 -0.410 -0.500 -0.500 -0.498 -0.496)))
	    (snd-display #__line__ ";env-squared unsymmetric to -.5: ~A" (channel->float-vector 60 10)))
	(undo)
	
	(ramp-squared 0.0 1.0)
	(set! vals (channel->float-vector))
	(undo)
	(env-expt-channel '(0 0 1 1) 2)
	(set! new-vals (channel->float-vector))
	(if (not (vequal vals new-vals))
	    (snd-display #__line__ ";env-expt2/ramp: ~A ~A" vals new-vals))
	(undo)
	(env-squared-channel '(0 0 1 1 2 -.5 3 0))
	(set! vals (channel->float-vector))
	(undo)
	(env-expt-channel '(0 0 1 1 2 -.5 3 0) 2.0)
	(set! new-vals (channel->float-vector))
	(if (not (vequal vals new-vals))
	    (snd-display #__line__ ";env-expt2/env-squared: ~A ~A" vals new-vals))
	(undo)
	(env-squared-channel '(0 0 1 1 2 -.5 3 0) #f)
	(set! vals (channel->float-vector))
	(undo)
	(env-expt-channel '(0 0 1 1 2 -.5 3 0) 2.0 #f)
	(set! new-vals (channel->float-vector))
	(if (not (vequal vals new-vals))
	    (snd-display #__line__ ";env-expt2/env-squared unsymmetric: ~A ~A" vals new-vals))
	(undo)
	
	(ramp-expt 0.0 1.0 32.0)
	(set! vals (channel->float-vector))
	(undo)
	(env-expt-channel '(0 0 1 1) 32.0)
	(set! new-vals (channel->float-vector))
	(if (not (vequal vals new-vals))
	    (snd-display #__line__ ";env-expt/ramp 32: ~A ~A" vals new-vals))
	(undo)
	(ramp-expt 0.0 1.0 32.0 #f 0 50)
	(set! vals (channel->float-vector))
	(undo)
	(env-expt-channel '(0 0 1 1 2 1) 32.0)
	(set! new-vals (channel->float-vector))
	(if (not (vequal vals new-vals))
	    (snd-display #__line__ ";env-expt/ramp 1 32: ~A ~A" vals new-vals))
	(undo)
	(ramp-expt 0.0 1.0 .1)
	(set! vals (channel->float-vector))
	(undo)
	(env-expt-channel '(0 0 1 1) .1)
	(set! new-vals (channel->float-vector))
	(if (not (vequal vals new-vals))
	    (snd-display #__line__ ";env-expt/ramp .1: ~A ~A" vals new-vals))
	(undo)
	
	(env-expt-channel '(0 0 1 1 2 -.5 3 0) 12.0)
	(if (not (vequal (channel->float-vector 30 10) (float-vector 0.319 0.472 0.691 1.000 0.537 0.208 -0.022 -0.182 -0.291 -0.365)))
	    (snd-display #__line__ ";env-expt to -.5 12.0: ~A" (channel->float-vector 30 10)))
	(undo)
	(env-expt-channel '(0 0 1 1 2 -.5 3 0) 12.0 #f)
	(if (not (vequal (channel->float-vector 30 10) (float-vector 0.319 0.472 0.691 1.000 1.000 1.000 1.000 1.000 1.000 1.000)))
	    (snd-display #__line__ ";env-expt to -.5 12.0 unsymmetric: ~A" (channel->float-vector 30 10)))
	(undo)
	(close-sound ind))))
  
  (let ((ind (new-sound  "test.snd" 1 22050 mus-ldouble mus-next "third ramp re-order tests" 101)))
    (offset-channel 1.0)
    (env-sound '(0 0 1 1))
    (contrast-channel 1.0)
    (let ((reader (make-sampler 0))
	  (happy #t))
      (do ((i 0 (+ i 1))
	   (val 0.0 (+ val .01)))
	  ((or (not happy) (= i 100)))
	(let ((y (reader))
	      (ny (sin (+ (* val 0.5 pi) (* 1.0 (sin (* val 2.0 pi)))))))
	  (if (fneq y ny)
	      (begin
		(snd-display #__line__ ";contrast-channel: ~A ~A ~A" val y ny)
		(set! happy #f))))))
    (close-sound ind))
  
  (let ((ind0 (open-sound "oboe.snd"))
	(ind1 (open-sound "pistol.snd")))
    
    (let ((clip (channel-clipped? ind0 0)))
      (if clip (snd-display #__line__ ";channel-clipped? oboe.snd -> ~A" clip)))
    (scale-to 1.5 ind0 0)
    (let ((clip (channel-clipped? ind0 0)))
      (if (not (member clip (list 4502 4503))) (snd-display #__line__ ";channel-clipped after scale: ~A" clip)))
    (revert-sound ind0)
    
    (ramp-channel 0.0 1.0 0 #f ind1 0)
    (ramp-channel 0.0 1.0 0 #f ind1 0)
    (ramp-channel 0.0 1.0 0 #f ind1 0)
    (ramp-channel 0.0 1.0 0 #f ind1 0)
    (make-selection 1000 2000 ind1 0)
    (set! (sync ind0) 1)
    (set! (selected-sound) ind0)
    (env-selection '(0 0 1 1))
    (if (or (not (= (edit-position ind0 0) 0))
	    (not (= (edit-position ind1 0) 5)))
	(snd-display #__line__ ";selection override of sync field: ~A ~A" (edit-position ind0 0) (edit-position ind1 0)))
    (env-sound '(0 0 1 1 2 0))
    (if (or (not (= (edit-position ind0 0) 1))
	    (not (= (edit-position ind1 0) 5)))
	(snd-display #__line__ ";sync field over selection: ~A ~A" (edit-position ind0 0) (edit-position ind1 0)))
    
    (close-sound ind1)
    (revert-sound ind0)
    (close-sound ind0))
  
  (let ((s1 (open-sound "oboe.snd")))
    (let ((s2 (copy s1)))
      (if (not (sound? s2))
	  (snd-display #__line__ ";copy sound oboe -> ~A" s2)
	  (begin
	    (if (not (= (srate s1) (srate s2))) (snd-display #__line__ ";copy sounds srates: ~A ~A" (srate s1) (srate s2)))
	    (if (not (= (framples s1) (framples s2))) (snd-display #__line__ ";copy sounds framples: ~A ~A" (framples s1) (framples s2)))
	    (if (not (= (chans s1) (chans s2) 1)) (snd-display #__line__ ";copy sounds chans: ~A ~A" (chans s1) (chans s2)))
	    (let ((d1 (channel->float-vector 0 #f s1))
		  (d2 (channel->float-vector 0 #f s2)))
	      (if (not (vequal d1 d2))
		  (snd-display #__line__ ";copied sound not equal? ~A?" (float-vector-peak (float-vector-subtract! d0 d1)))))
	    (close-sound s2))))
    (fill! s1 0.0)
    (if (fneq (maxamp s1) 0.0) (snd-display #__line__ ";fill 1 with 0: ~A" (maxamp s1)))
    (fill! s1 0.3)
    (if (fneq (maxamp s1) 0.3) (snd-display #__line__ ";fill 1 with 0.3: ~A" (maxamp s1)))
    (close-sound s1))
  
  (let ((s1 (open-sound "2a.snd")))
    (let ((s2 (copy s1)))
      (if (not (sound? s2))
	  (snd-display #__line__ ";copy sound 2a -> ~A" s2)
	  (begin
	    (if (not (= (srate s1) (srate s2))) (snd-display #__line__ ";copy sounds srates 2: ~A ~A" (srate s1) (srate s2)))
	    (if (not (= (framples s1) (framples s2))) (snd-display #__line__ ";copy sounds framples 2: ~A ~A" (framples s1) (framples s2)))
	    (if (not (= (chans s1) (chans s2) 2)) (snd-display #__line__ ";copy sounds chans 2: ~A ~A" (chans s1) (chans s2)))
	    (let ((d10 (channel->float-vector 0 #f s1 0))
		  (d11 (channel->float-vector 0 #f s1 1))
		  (d20 (channel->float-vector 0 #f s2 0))
		  (d21 (channel->float-vector 0 #f s2 1)))
	      (if (not (vequal d10 d20))
		  (snd-display #__line__ ";copied sound 2 (0) not equal? ~A?" (float-vector-peak (float-vector-subtract! d10 d20))))
	      (if (not (vequal d11 d21))
		  (snd-display #__line__ ";copied sound 2 (1) not equal? ~A?" (float-vector-peak (float-vector-subtract! d11 d21)))))
	    (close-sound s2))))
    (fill! s1 0.0)
    (if (fneq (maxamp s1) 0.0) (snd-display #__line__ ";fill 2 with 0: ~A" (maxamp s1)))
    (fill! s1 0.3)
    (if (fneq (maxamp s1) 0.3) (snd-display #__line__ ";fill 2 with 0.3: ~A" (maxamp s1)))
    (close-sound s1))
  
  (for-each close-sound (sounds))
  (unselect-all)
  (let ((snd (open-sound "oboe.snd")))
    (make-selection 1000 2000 snd 0)
    (if (not (selection?)) (snd-display #__line__ ";make-selection for copy failed?"))
    (copy (selection))
    (let* ((r1 (channel->float-vector 1000 1000 snd 0))
	   (snds (sounds))
	   (sel (if (equal? (car snds) snd) (cadr snds) (car snds)))
	   (r2 (channel->float-vector 0 1000 sel 0)))
      (if (equal? sel snd)
	  (snd-display #__line__ ";very weird: ~A equal? ~A from ~A (~A ~A ~A)" sel snd snds (car snds) (cadr snds) (equal? (car snds) snd)))
      (if (not (vequal r1 r2))
	  (snd-display #__line__ ";copied selection not equal? ~A?" (float-vector-peak (float-vector-subtract! r1 r2))))
      (close-sound sel)
      (if (not (selection?))
	  (snd-display #__line__ ";copy selection unselected? ~A" (sounds))
	  (begin
	    (fill! (selection) 0.0)
	    (let ((r1 (channel->float-vector 1000 1000 snd 0)))
	      (if (> (float-vector-peak r1) 0.0)
		  (snd-display #__line__ ";fill! selection not 0.0? ~A" (float-vector-peak r1))))
	    (revert-sound snd)
	    (if (not (selection?))
		(snd-display #__line__ ";revert-sound selection unselected?")
		(begin
		  (fill! (selection) 0.3)
		  (let ((r1 (channel->float-vector 1000 1000 snd 0)))
		    (if (or (not (= (float-vector-max r1) 0.3))
			    (not (= (float-vector-min r1) 0.3)))
			(snd-display #__line__ ";fill! selection not 0.3? ~A ~A" (float-vector-min r1) (float-vector-max r1)))))))))
    (for-each close-sound (sounds)))
  
  (let ((snd (open-sound "oboe.snd")))
    (make-selection 1000 2000 snd 0)
    (if (not (selection?)) 
	(snd-display #__line__ ";make-selection failed?")
	(let ((sel-max (maxamp (selection)))
	      (sel-len (length (selection))))
	  (let ((mx (car (selection->mix))))
	    (if (not (mix? mx))
		(snd-display #__line__ ";selection->mix: ~A" mx)
		(let ((mx-rd (make-mix-sampler mx 0))
		      (snd-rd (make-sampler 1000 snd 0))
		      (orig-rd (make-sampler 1000 snd 0 1 0)))
		  (let ((happy #t))
		    (do ((i 0 (+ i 1)))
			((or (not happy) 
			     (= i 1000)))
		      (let ((mx-val (mx-rd))
			    (snd-val (snd-rd))
			    (orig-val (orig-rd)))
			(if (or (fneq mx-val snd-val)
				(fneq snd-val orig-val))
			    (begin
			      (set! happy #f)
			      (snd-display #__line__ ";selection->mix at ~A: ~A ~A ~A" (+ i 1000) mx-val snd-val orig-val))))))
		  (if (not (= (length mx) sel-len 1001)) (snd-display #__line__ ";selection->mix mix length: ~A (~A)" (length mx) sel-len))
		  (if (fneq (maxamp mx) sel-max) (snd-display #__line__ ";selection->mix maxamps: ~A ~A" (maxamp mx) sel-max)))))))
    (for-each close-sound (sounds)))
  
  (let ((snd (open-sound "2.snd")))
    (set! (sync snd) 1)
    ;; make-selection claims it follows the sync field
    (make-selection 2000 3000 snd)
    (if (not (selection?)) 
	(snd-display #__line__ ";make-selection (2) failed?")
	(let ((sel-max (maxamp (selection)))
	      (sel-len (length (selection)))
	      (sel-chns (channels (selection))))
	  (if (not (= sel-chns 2)) (snd-display #__line__ ";make-selection stereo syncd chans: ~A" sel-chns))
	  (if (not (= sel-len 1001)) (snd-display #__line__ ";make-selection stereo length: ~A" sel-len))
	  (let* ((mx-list (selection->mix))
		 (mx0 (car mx-list))
		 (mx1 (cadr mx-list)))
	    (if (or (not (mix? mx0))
		    (not (mix? mx1)))
		(snd-display #__line__ ";selection->mix stereo: ~A ~A" mx0 mx1)
		(let ((mx0-rd (make-mix-sampler mx0 0))
		      (mx1-rd (make-mix-sampler mx1 0))
		      (snd0-rd (make-sampler 2000 snd 0))
		      (snd1-rd (make-sampler 2000 snd 1))
		      (orig0-rd (make-sampler 2000 snd 0 1 0))
		      (orig1-rd (make-sampler 2000 snd 1 1 0)))
		  (let ((happy #t))
		    (do ((i 0 (+ i 1)))
			((or (not happy) 
			     (= i 1000)))
		      (let ((mx0-val (mx0-rd))
			    (mx1-val (mx1-rd))
			    (snd0-val (snd0-rd))
			    (snd1-val (snd1-rd))
			    (orig0-val (orig0-rd))
			    (orig1-val (orig1-rd)))
			(if (or (fneq mx0-val snd0-val)
				(fneq snd0-val orig0-val))
			    (begin
			      (set! happy #f)
			      (snd-display #__line__ ";selection->mix stereo 0 at ~A: ~A ~A ~A" (+ i 2000) mx0-val snd0-val orig0-val)))
			(if (or (fneq mx1-val snd1-val)
				(fneq snd1-val orig1-val))
			    (begin
			      (set! happy #f)
			      (snd-display #__line__ ";selection->mix stereo 1 at ~A: ~A ~A ~A" (+ i 2000) mx1-val snd1-val orig1-val))))))))
	    
	    (if (not (= (length mx0) (length mx1) sel-len 1001))
		(snd-display #__line__ ";selection->mix stereo mix length: ~A ~A (~A)" (length mx0) (length mx1) sel-len))
	    (if (fneq (max (maxamp mx0) (maxamp mx1)) sel-max) 
		(snd-display #__line__ ";selection->mix stereo maxamps: ~A ~A ~A" (maxamp mx0) (maxamp mx1) sel-max)))))
    (for-each close-sound (sounds)))
  
  (let ((ind (new-sound :size 10)))
    (do ((i 0 (+ i 1)))
	((= i 10))
      (set! (sample i ind 0) (* .1 i)))
    (let ((rd (make-sampler 3 ind 0)))
      (let ((val (read-sample-with-direction rd 1)))
	(if (fneq val .3) (snd-display #__line__ ";read-sample-with-direction 3: ~A" val))
	(read-sample-with-direction rd -1)
	(set! val (read-sample-with-direction rd -1))
	(if (fneq val .2) (snd-display #__line__ ";read-sample-with-direction 2: ~A" val))
	(set! val (read-sample-with-direction rd -1))
	(if (fneq val .1) (snd-display #__line__ ";read-sample-with-direction 1: ~A" val))
	(close-sound ind))))
  
  (clear-save-state-files))


;;; ---------------- test 6: float-vectors ----------------

(define (snd_test_6)
  (do ((clmtest 0 (+ 1 clmtest))) ((= clmtest tests)) 
    (log-mem clmtest)
    (let ((v0 (make-float-vector 10))
	  (v1 (make-float-vector 10))
	  (vlst (make-float-vector 3)))
      (if (not (float-vector? v0)) (snd-display #__line__ ";v0 isn't a float-vector?!?"))
      (if (eqv? v0 10) (snd-display #__line__ ";v0 is 10!?"))
      (if (float-vector? 10) (snd-display #__line__ ";10 is a float-vector?"))
      (if (not (= (length v0) 10)) (snd-display #__line__ ";v0 length = ~D?" (length v0)))
      (fill! v0 1.0)
      (fill! v1 0.5)
      (if (equal? v0 v1) (snd-display #__line__ ";float-vector equal? ~A ~A" v0 v1))
      (if (eq? v0 v1) (snd-display #__line__ ";float-vector eq? ~A ~A" v0 v1))
      (if (fneq (float-vector-max v0) 1.0) (snd-display #__line__ ";float-vector max ~A" (float-vector-max v0)))
      (if (fneq (float-vector-min v0) 1.0) (snd-display #__line__ ";float-vector min ~A" (float-vector-max v0)))
      (let ((v2 v1)
	    (v3 (make-float-vector 10))
	    (v4 (make-float-vector 3)))
	(if (not (eq? v1 v2)) (snd-display #__line__ ";float-vector not eq? ~A ~A" v1 v2))
	(fill! v3 0.5) 
	(if (not (equal? v3 v1)) (snd-display #__line__ ";float-vector not equal? ~A ~A" v3 v1))
	(if (equal? v4 v1) (snd-display #__line__ ";len diff float-vector equal? ~A ~A" v4 v1))
	(set! (v3 0) 1.0)
	(if (fneq (v3 0) 1.0) (snd-display #__line__ ";set! float-vector-ref: ~A" (v3 0))))
      (set! (vlst 1) .1)
      (if (not (feql (map values vlst) (list 0.0 0.1 0.0))) (snd-display #__line__ ";vector->list: ~A?" (map values vlst)))
      (let ((v2 (make-float-vector 4)))
	(do ((i 0 (+ i 1)))
	    ((= i 4))
	  (set! (v2 i) i))
	(float-vector-move! v2 3 2 #t)
	(if (or (fneq (v2 3) 2.0) (fneq (v2 2) 1.0))
	    (snd-display #__line__ ";float-vector-move! back: ~A?" v2)))
      
      (if (not (string=? (float-vector->string (float-vector 1.0 2.0)) "(float-vector 1.000 2.000)")) 
	  (snd-display #__line__ ";float-vector->string: ~A" (float-vector->string (float-vector 1.0 2.0))))
      
      (if (not (vequal (float-vector 4 3 2 1) (reverse! (float-vector 1 2 3 4)))) (snd-display #__line__ ";float-vector-reverse: ~A" (reverse! (float-vector 1 2 3 4))))
      (if (not (vequal (float-vector 3 2 1) (reverse! (float-vector 1 2 3)))) (snd-display #__line__ ";float-vector-reverse: ~A" (reverse! (float-vector 1 2 3))))
      (if (not (vequal (float-vector 2 1) (reverse! (float-vector 1 2)))) (snd-display #__line__ ";float-vector-reverse: ~A" (reverse! (float-vector 1 2))))
      (if (not (vequal (float-vector 1) (reverse! (float-vector 1)))) (snd-display #__line__ ";float-vector-reverse: ~A" (reverse! (float-vector 1))))
      (if (not (vequal (float-vector 3 2 1) (reverse (float-vector 1 2 3)))) (snd-display #__line__ ";reverse(float-vector): ~A" (reverse (float-vector 1 2 3))))
      (let ((v (float-vector 3 2 1)))
	(let ((rv (reverse v)))
	  (if (not (vequal rv (float-vector 1 2 3)))
	      (snd-display #__line__ ";reverse(float-vector) -> ~A ~A" v rv))))
      
      (let ((v0 (make-float-vector 3)))
	(let ((var (catch #t (lambda () (v0 10)) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display #__line__ ";float-vector-ref high index: ~A" var)))
	(let ((var (catch #t (lambda () (v0 -1)) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display #__line__ ";float-vector-ref low index: ~A" var)))
	(let ((var (catch #t (lambda () (set! (v0 10) 1.0)) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display #__line__ ";float-vector-set! high index: ~A" var)))
	(let ((var (catch #t (lambda () (set! (v0 -1) 1.0)) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display #__line__ ";float-vector-set! low index: ~A" var)))
	(let ((var (catch #t (lambda () (float-vector-move! v0 10 0 #t)) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display #__line__ ";float-vector-move! high index: ~A" var)))
	(let ((var (catch #t (lambda () (float-vector-move! v0 0 10 #t)) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display #__line__ ";float-vector-move! high 2 index: ~A" var)))
	(let ((var (catch #t (lambda () (float-vector-move! v0 -10 0 #f)) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display #__line__ ";float-vector-move! back high index: ~A" var)))
	(let ((var (catch #t (lambda () (float-vector-move! v0 0 -10 #f)) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display #__line__ ";float-vector-move! back high 2 index: ~A" var))))
      
      (let ((v (float-vector 0.0 1.0 -2.0 -3.0)))
	(if (not (vequal (float-vector-abs! v) (float-vector 0.0 1.0 2.0 3.0)))
	    (snd-display #__line__ ";float-vector-abs! ~A" v)))

      ;; float-vector-add! + shared-vector:
      (let ((fv (float-vector 1 2 3 4 5)))
	(let ((sv (make-shared-vector fv '(4) 1)))
	  (float-vector-add! sv fv)
	  (if (not (vequal fv (float-vector 1.0 3.0 6.0 10.0 15.0)))
	      (snd-display #__line__ ";float-vector+shared-vector: ~A" fv))))
      
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(if (fneq (v0 i) 1.0) (snd-display #__line__ ";fill v0[~D] = ~F?" i (v0 i)))
	(if (fneq (v1 i) 0.5) (snd-display #__line__ ";preset v1[~D] = ~F?" i (v1 i))))
      (float-vector-add! v0 v1)
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(if (fneq (v0 i) 1.5) (snd-display #__line__ ";add v0[~D] = ~F?" i (v0 i))))
      (float-vector-subtract! v0 v1)
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(if (fneq (v0 i) 1.0) (snd-display #__line__ ";subtract v0[~D] = ~F?" i (v0 i))))
      (let ((v2 (copy v0)))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (if (fneq (v2 i) 1.0) (snd-display #__line__ ";copy v0[~D] = ~F?" i (v2 i))))
	(float-vector-scale! v2 5.0)
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (if (fneq (v2 i) 5.0) (snd-display #__line__ ";scale v2[~D] = ~F?" i (v2 i))))
	(float-vector-offset! v0 -1.0)
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (if (fneq (v0 i) 0.0) (snd-display #__line__ ";offset v0[~D] = ~F?" i (v0 i))))
	(float-vector-multiply! v2 v1)
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (if (fneq (v2 i) 2.5) (snd-display #__line__ ";multiply v2[~D] = ~F?" i (v2 i))))
	(if (fneq (float-vector-peak v2) 2.5) (snd-display #__line__ ";v2's peak is ~F?" (float-vector-peak v2)))
	(set! (v2 5) 123.0)
	(if (fneq (float-vector-peak v2) 123.0) (snd-display #__line__ ";v2's set peak is ~F?" (float-vector-peak v2)))
	(let ((vn (make-float-vector 32))
	      (vb (make-float-vector 64))
	      (vs (make-float-vector 3))
	      (vss (make-float-vector 1)))
	  (do ((i 0 (+ i 1)))
	      ((= i 32))
	    (set! (vn i) i))
	  (let ((vnew (float-vector-subseq vn 3)))
	    (if (fneq (vnew 0) 3.0) (snd-display #__line__ ";float-vector-subseq[3:] ~A?" (vnew 0)))
	    (if (not (= (length vnew) 29)) (snd-display #__line__ ";float-vector-subseq[3:] length: ~A?" (length vnew))))
	  (let ((vnew (float-vector-subseq vn 3 8)))
	    (if (fneq (vnew 0) 3.0) (snd-display #__line__ ";float-vector-subseq[3:8] ~A?" (vnew 0)))
	    (if (not (= (length vnew) 6)) (snd-display #__line__ ";float-vector-subseq[3:8] length: ~A?" (length vnew))))
	  (float-vector-subseq vn 3 3 vs)
	  (if (or (fneq (vs 0) 3.0)
		  (fneq (vs 1) 0.0)
		  (fneq (vs 2) 0.0))
	      (snd-display #__line__ ";float-vector-subseq[3:3->vs] ~A?" vs))
	  (float-vector-subseq vn 0 32 vs)
	  (if (not (= (length vs) 3)) (snd-display #__line__ ";float-vector-subseq[0:32->vs] length: ~A?" (length vs)))
	  (float-vector-subseq vn 2 3 vss)
	  (if (fneq (vss 0) 2.0) (snd-display #__line__ ";float-vector-subseq[2:3->vss] ~A?" (vss 0)))
	  (set! (vb 8) 123.0)
	  (float-vector-subseq vn 1 8 vb)
	  (if (fneq (vb 0) 1.0) (snd-display #__line__ ";float-vector-subseq[1:8->vb] ~A?" (vb 0)))
	  (if (fneq (vb 8) 123.0) (snd-display #__line__ ";float-vector-subseq[1:8->vb][8] ~A?" (vb 8))))
	
	(let ((v (make-float-vector 20))
	      (mn 1.0)
	      (mx -1.0))
	  (do ((i 0 (+ i 1)))
	      ((= i 20))
	    (let ((val (mus-random 1.0)))
	      (set! (v i) val)
	      (if (< val mn) (set! mn val))
	      (if (> val mx) (set! mx val))))
	  (if (fneq (float-vector-min v) mn) (snd-display #__line__ ";float-vector-min ran: ~A ~A" (float-vector-min v) mn))
	  (if (fneq (float-vector-max v) mx) (snd-display #__line__ ";float-vector-max ran: ~A ~A" (float-vector-max v) mx))
	  (if (fneq (float-vector-peak v) (max (abs mn) (abs mx))) (snd-display #__line__ ";float-vector-peak ran: ~A ~A ~A" (float-vector-peak v) mn mx)))
	
	(let ((v1 (make-float-vector 3 .1))
	      (v2 (make-float-vector 4 .2)))
	  (let ((val (float-vector+ (copy v1) v2)))
	    (if (not (vequal val (float-vector .3 .3 .3))) (snd-display #__line__ ";float-vector+ .1 .2: ~A" val)))
	  (set! (v1 1) .3)
	  (let ((val (float-vector+ (copy v1) v2)))
	    (if (not (vequal val (float-vector .3 .5 .3))) (snd-display #__line__ ";float-vector+ .1 .2 (1): ~A" val)))
	  (let ((val (float-vector+ (copy v1) 2.0)))
	    (if (not (vequal val (float-vector 2.1 2.3 2.1))) (snd-display #__line__ ";float-vector+ .1 2.0: ~A" val)))
	  (let ((val (float-vector+ 2.0 (copy v1))))
	    (if (not (vequal val (float-vector 2.1 2.3 2.1))) (snd-display #__line__ ";float-vector+ .1 2.0 (1): ~A" val)))
	  (let ((val (float-vector* 2.0 (copy v1))))
	    (if (not (vequal val (float-vector .2 .6 .2))) (snd-display #__line__ ";float-vector* 2.0: ~A" val)))
	  (let ((val (float-vector* (copy v1) 2.0)))
	    (if (not (vequal val (float-vector .2 .6 .2))) (snd-display #__line__ ";float-vector* 2.0 (1): ~A" val)))
	  (let ((val (float-vector* (copy v1) v2)))
	    (if (not (vequal val (float-vector .02 .06 .02))) (snd-display #__line__ ";float-vector* v1 v2: ~A" val))))
	
	(fill! v0 1.0)
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (if (fneq (v0 i) 1.0) (snd-display #__line__ ";map v0[~D] = ~F?" i (v0 i)))))
      
      (if (fneq ((float-vector 1.0 2.0 3.0) 1) 2.0)
	  (snd-display #__line__ ";(float-vector...) = ~A?" ((float-vector 1.0 2.0 3.0) 1)))
      (let ((v1 (float-vector 1 2 3 4)))
	(if (fneq (v1 1) 2.0)
	    (snd-display #__line__ ";(v1 1) = ~A?" (v1 1))))
      
      (when with-gui
	(let ((ind (open-sound "oboe.snd")))
	  (set! (speed-control ind) .5)
	  (play :wait #t)
	  (apply-controls)
	  (revert-sound)
	  (reset-controls ind)
	  ;; try some special cases
	  (apply-controls)
	  (if (not (= (edit-position ind) 0))
	      (snd-display #__line__ ";apply-controls with no:change: ~A: ~A" (edits ind) (edit-tree ind)))
	  (set! (speed-control ind) -1.0)
	  (apply-controls)
	  (if (not (= (edit-position ind) 1))
	      (snd-display #__line__ ";apply-controls with srate -1.0: ~A ~A ~A" (edit-position ind) (edits ind) (edit-tree ind)))
	  (if (> (abs (- (framples ind 0) (framples ind 0 0))) 2)
	      (snd-display #__line__ ";apply-controls srate -1.0 lengths: ~A ~A" (framples ind 0) (framples ind 0 0)))
	  (if (or (fneq (maxamp) .147)
		  (< (abs (sample 9327)) .01))
	      (snd-display #__line__ ";apply-controls srate -1.0 samples: ~A ~A" (maxamp) (sample 9327)))
	  (if (fneq (speed-control ind) 1.0) (snd-display #__line__ ";apply-controls -1.0 -> ~A?" (speed-control ind)))
	  
	  (hook-push after-apply-controls-hook (lambda (hook) 
						 (let ((tag (catch #t 
							      apply-controls 
							      (lambda args args))))
						   (if (not (eq? (car tag) 'cannot-apply-controls))
						       (snd-display #__line__ ";after-apply-controls-hook: recursive attempt apply-controls: ~A" tag)))))
	  (apply-controls)
	  (set! (hook-functions after-apply-controls-hook) ())
	  (revert-sound)
	  (close-sound ind)))
      
      (let ((hi (make-float-vector 3)))
	(let ((tag (catch #t
		     (lambda () (float-vector-subseq hi 1 0))
		     (lambda args (car args)))))
	  (if (not (eq? tag 'out-of-range))
	      (snd-display #__line__ ";float-vector-subseq 1 0: ~A" tag))))
      (let ((v0 (make-float-vector 5 .1))
	    (v1 (make-float-vector 6 .2)))
	(float-vector-add! v0 v1 2)
	(if (not (vequal v0 (float-vector .1 .1 .3 .3 .3)))
	    (snd-display #__line__ ";float-vector-add + offset: ~A" v0)))
      
      ;; check s7 stuff with float-vectors
      (let ((v (float-vector 1.0 2.0 3.0)))
	(if (not (string=? (format #f "~{~A~^-~}" v) "1.0-2.0-3.0"))
	    (snd-display #__line__ ";float-vector in format {}: ~S" (format #f "~{~A~^-~}" v)))
	(if (not (= (length v) 3))
	    (snd-display #__line__ ";float-vector s7 len: ~A" (length v)))
	(if (not (equal? v (copy v)))
	    (snd-display #__line__ ";float-vector s7 copy is not equal? ~A ~A" v (copy v)))
	(let ((val (map floor v)))
	  (if (not (equal? val '(1 2 3)))
	      (snd-display #__line__ ";float-vector s7 map: ~A" val)))
	(let ((val 0))
	  (for-each
	   (lambda (x)
	     (set! val (+ val (floor x))))
	   v)
	  (if (not (eqv? val 6))
	      (snd-display #__line__ ";float-vector s7 for-each: ~A" val)))
	(set! v (reverse v))
	(if (not (vvequal v (float-vector 3.0 2.0 1.0)))
	    (snd-display #__line__ ";float-vector s7 reverse: ~A" v))
	(fill! v 12.0)
	(if (not (vvequal v (float-vector 12.0 12.0 12.0)))
	    (snd-display #__line__ ";float-vector s7 fill: ~A" (fill! v 12.0)))
	)
      
      (let ((sum 0)) 
	(for-each (lambda (n) (set! sum (+ sum n))) (float-vector 1 2 3))
	(if (not (= sum 6.0))
	    (snd-display #__line__ ";object for-each (float-vector): ~A" sum)))
      
      (let ((x (float-vector 0.0))
	    (osc (make-oscil :frequency 440))
	    (e1 (make-env '(0 0 1 1 2 0) :length 100)))
	(do ((i 0 (+ i 1)))
	    ((= i 100))
	  (float-vector-set! x 0 (* (env e1) (oscil osc (float-vector-ref x 0))))))
      
      (if (fneq (float-vector-equal? (float-vector 1.0) (float-vector 1.1) .1) .0909)
	  (snd-display #__line__ ";float-vector-equal? 0.0909: ~A" (float-vector-equal? (float-vector 1.0) (float-vector 1.1) .1)))
      (if (float-vector-equal? (float-vector 1.0) (float-vector 1.1) .01)
	  (snd-display #__line__ ";float-vector-equal? #f: ~A" (float-vector-equal? (float-vector 1.0) (float-vector 1.1) .01)))
      
      )))


;;; ---------------- test 7: colors ----------------

(require snd-rgb.scm)

(define (snd_test_7)
  (define colormap-error-max 0.0)
  (define cfneq (lambda (a b) (> (abs (- a b)) colormap-error-max)))
  (define old-colormap-size *colormap-size*)
  
  (if (or (provided? 'snd-gtk)
	  (provided? 'snd-motif))
      (letrec ((test-color
		(lambda (lst)
		  (if (pair? lst)
		      (let* ((name ((car lst) 0))
			     (getfnc ((car lst) 1))
			     (setfnc (lambda (val) (set! (getfnc) val)))
			     (initval ((car lst) 2)))
			(if (not (color? initval)) (snd-display #__line__ ";~A not color?" initval))
			;; we'll get warnings here if the cell chosen didn't exactly match the one requested -- not a bug
			;; (if (not (equal? (getfnc) initval))
			;;	  (snd-display #__line__ ";~A is not ~A (~A)?" name initval (getfnc)))
			(setfnc beige)
			(if (not (equal? (getfnc) beige))
			    (snd-display #__line__ ";set-~A is not beige (~A)?" name (getfnc)))
			(setfnc initval)
			(test-color (cdr lst)))))))
	
	(let* ((c1 (catch 'no-such-color
			  (lambda () (make-color 0 0 1))
			  (lambda args #f)))
	       (c2 c1)
	       (c3 (catch 'no-such-color
			  (lambda () (make-color 0 0 1))
			  (lambda args #f))))
	  (if (not (equal? c1 c2)) (snd-display #__line__ ";color not equal? ~A ~A?" c1 c2))
	  (if (not (eq? c1 c2)) (snd-display #__line__ ";color not eq? ~A ~A?" c1 c2))
	  ;(if (not (equal? c1 c3)) (snd-display #__line__ ";diff color not equal? ~A ~A?" c1 c3))
	  (if (eq? c1 c3) (snd-display #__line__ ";diff color eq? ~A ~A?" c1 c3))
	  (if (and (not (equal? (color->list c1) (list 0.0 0.0 1.0)))
		   (not (equal? (color->list c1) (list 0.0 0.0 1.0 1.0))))
	      (snd-display #__line__ ";color->list: ~A ~A?" c1 (color->list c1))))

	(if (not (provided? 'snd-motif))
	    (let* ((c1 (catch 'no-such-color
			      (lambda () (make-color 0 0 1 0.5))
			      (lambda args #f)))
		   (c2 c1)
		   (c3 (catch 'no-such-color
			      (lambda () (make-color 0 0 1 0.5))
			      (lambda args #f))))
	      (if (not (equal? c1 c2)) (snd-display #__line__ ";alpha color not equal? ~A ~A?" c1 c2))
	      (if (not (eq? c1 c2)) (snd-display #__line__ ";alpha color not eq? ~A ~A?" c1 c2))
	      ;(if (not (equal? c1 c3)) (snd-display #__line__ ";alpha diff color not equal? ~A ~A?" c1 c3))
	      (if (eq? c1 c3) (snd-display #__line__ ";alpha diff color eq? ~A ~A?" c1 c3))
	      (let ((c4 (catch 'no-such-color
			       (lambda () (make-color 0 0 1 0.0))
			       (lambda args #f))))
		(if (equal? c1 c4) (snd-display #__line__ ";alpha color equal? ~A ~A?" c1 c2)))))

	(do ((i 0 (+ i 1))) 
	    ((not (colormap? (integer->colormap i))))
	  (let ((val (colormap-ref (integer->colormap i) 0))
		(true-val ((list '(0.0 0.0 0.0) '(0.0 0.0 0.0) '(0.0 0.0 0.0) '(0.0 1.0 1.0)
					  '(0.0 0.0 7.01915007248035e-4) '(0.0 0.0 0.0) '(0.0 0.0 0.0)
					  '(0.0 0.0 0.49999) '(1.0 0.0 0.0) '(1.0 0.0 0.0) '(0.0 0.0 1.0)
					  '(1.0 0.0 1.0) '(0.0 0.500007629510948 0.4) '(1.0 0.0 0.0)
					  '(1.0 0.0 0.0) '(0.0 0.0 1.0))
				    i)))
	    (if (not (feql val true-val))
		(snd-display #__line__ ";colormap-ref ~A: ~A (~A)" i val true-val))))
	(catch #t ; might be undefined var as well as no-such-color
	       (lambda () 
		 (test-color
		  (list
		   (list 'basic-color basic-color ivory2)
		   (list 'cursor-color cursor-color red)
		   (list 'data-color data-color black)
		   (list 'enved-waveform-color enved-waveform-color blue)
		   (list 'filter-control-waveform-color filter-control-waveform-color blue)
		   (list 'graph-color graph-color white)
		   (list 'highlight-color highlight-color ivory1)
		   (list 'listener-color listener-color alice-blue)
		   (list 'listener-text-color listener-text-color black)
		   (list 'mark-color mark-color red)
		   (list 'mix-color mix-color dark-gray)
		   (list 'position-color position-color ivory3)
		   (list 'sash-color sash-color light-green)
		   (list 'selected-data-color selected-data-color black)
		   (list 'selected-graph-color selected-graph-color white)
		   (list 'selection-color selection-color lightsteelblue1)
		   (list 'text-focus-color text-focus-color white)
		   (list 'zoom-color zoom-color ivory4)
		   ))
		 
		 (let ((ind (open-sound "oboe.snd")))
		   (set! *selected-data-color* light-green)
		   (set! *data-color* blue)
		   (set! *selected-graph-color* black)
		   (let ((red (make-color-with-catch 1.0 0.0 0.0)))
		     (set! (foreground-color ind 0 cursor-context) red)
		     (let ((col (foreground-color ind 0 cursor-context)))
		       (if (not (feql (color->list col) (color->list red)))
			   (snd-display #__line__ ";set foreground cursor color: ~A ~A" (color->list col) (color->list red))))
		     (set! (foreground-color) blue)
		     (let ((col (foreground-color)))
		       (if (not (feql (color->list col) (color->list blue)))
			   (snd-display #__line__ ";set foreground-color: ~A ~A" (color->list col) (color->list blue))))
		     (set! (foreground-color ind) red)
		     (let ((col (foreground-color ind)))
		       (if (not (feql (color->list col) (color->list red)))
			   (snd-display #__line__ ";set foreground-color with ind (red): ~A ~A" (color->list col) (color->list red))))
		     (set! (foreground-color ind) black)
		     (let ((col (foreground-color ind)))
		       (if (not (feql (color->list col) (color->list black)))
			   (snd-display #__line__ ";set foreground-color with ind (black): ~A ~A" (color->list col) (color->list black)))))
		   (set! *selected-graph-color* (make-color-with-catch 0.96 0.96 0.86))
		   (set! *data-color* black)
		   (set! *selected-data-color* blue)
		   (set! *graph-color* white)
		   (close-sound ind)))
	       (lambda args args))
	
	(if (not (= (length jet-colormap) *colormap-size*))
	    (snd-display #__line__ ";jet-colormap length: ~A ~A" (length jet-colormap) *colormap-size*))
	
	(for-each 
	 (lambda (n err)
	   (set! *colormap-size* n)
	   (set! colormap-error-max err)
	   
	   (do ((i 0 (+ i 1))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r (if (< x 3/4)
			   (* 7/8 x)
			   (- (* 11/8 x) 3/8)))
		    (g (if (< x 3/8)
			   (* 7/8 x)
			   (if (< x 3/4)
			       (- (* 29/24 x) 1/8)
			       (+ (* 7/8 x) 1/8))))
		    (b (if (< x 3/8)
			   (* 29/24 x)
			   (+ (* 7/8 x) 1/8)))
		    (rgb (colormap-ref bone-colormap x))
		    (rgb1 (bone-colormap x))
		    (r1 (rgb 0))
		    (g1 (rgb 1))
		    (b1 (rgb 2))
		    (r2 (rgb1 0))
		    (g2 (rgb1 1))
		    (b2 (rgb1 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) 
			(or (cfneq r r1) 
			    (cfneq g g1) 
			    (cfneq b b1)
			    (cfneq r2 r1) 
			    (cfneq g2 g1) 
			    (cfneq b2 b1)))
		   (snd-display #__line__ ";bone ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (do ((i 0 (+ i 1))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r (if (< x 4/5)
			   (* 5/4 x)
			   1.0))
		    (g (* 4/5 x))
		    (b (* 1/2 x))
		    (rgb (colormap-ref copper-colormap x))
		    (r1 (rgb 0))
		    (g1 (rgb 1))
		    (b1 (rgb 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		   (snd-display #__line__ ";copper ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (do ((i 0 (+ i 1))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r 0.0)
		    (g x)
		    (b (- 1.0 (/ g 2.0)))
		    (rgb (colormap-ref winter-colormap x))
		    (r1 (rgb 0))
		    (g1 (rgb 1))
		    (b1 (rgb 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		   (snd-display #__line__ ";winter ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (do ((i 0 (+ i 1))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r 1.0)
		    (g x)
		    (b 0.0)
		    (rgb (colormap-ref autumn-colormap x))
		    (r1 (rgb 0))
		    (g1 (rgb 1))
		    (b1 (rgb 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		   (snd-display #__line__ ";autumn ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (do ((i 0 (+ i 1))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r x)
		    (g (- 1.0 r))
		    (b 1.0)	     
		    (rgb (colormap-ref cool-colormap x))
		    (r1 (rgb 0))
		    (g1 (rgb 1))
		    (b1 (rgb 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		   (snd-display #__line__ ";cool ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (do ((i 0 (+ i 1))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r (if (< x 3/8)
			   (* 8/3 x)
			   1.0))
		    (g (if (< x 3/8)
			   0.0
			   (if (< x 3/4)
			       (- (* 8/3 x) 1.0)
			       1.0)))
		    (b (if (< x 3/4)
			   0.0
			   (- (* 4 x) 3)))
		    (rgb (colormap-ref hot-colormap x))
		    (r1 (rgb 0))
		    (g1 (rgb 1))
		    (b1 (rgb 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		   (snd-display #__line__ ";hot ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (do ((i 0 (+ i 1))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r (if (< x 3/8)
			   0.0
			   (if (< x 5/8)
			       (- (* 4 x) 3/2)
			       (if (< x 7/8)
				   1.0
				   (+ (* -4 x) 9/2)))))
		    (g (if (< x 1/8)
			   0.0
			   (if (< x 3/8)
			       (- (* 4 x) 1/2)
			       (if (< x 5/8)
				   1.0
				   (if (< x 7/8)
				       (+ (* -4 x) 7/2)
				       0.0)))))
		    (b (if (< x 1/8)
			   (+ (* 4 x) 1/2)
			   (if (< x 3/8)
			       1.0
			       (if (< x 5/8)
				   (+ (* -4 x) 5/2)
				   0.0))))
		    (rgb (colormap-ref jet-colormap x))
		    (r1 (rgb 0))
		    (g1 (rgb 1))
		    (b1 (rgb 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		   (snd-display #__line__ ";jet ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (if (colormap? pink-colormap)
	       (do ((i 0 (+ i 1))) ((= i 10))
		 (let* ((x (random 1.0))
			(r (if (< x 3/8)
			       (* 14/9 x)
			       (+ (* 2/3 x) 1/3)))
			(g (if (< x 3/8)
			       (* 2/3 x)
			       (if (< x 3/4)
				   (- (* 14/9 x) 1/3)
				   (+ (* 2/3 x) 1/3))))			
			(b (if (< x 3/4)
			       (* 2/3 x)
			       (- (* 2 x) 1)))
			(rgb (colormap-ref pink-colormap x))
			(r1 (rgb 0))
			(g1 (rgb 1))
			(b1 (rgb 2)))
		   (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		       (snd-display #__line__ ";pink ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				    x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1))))))
	   
	   (do ((i 0 (+ i 1))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r 1.0)
		    (g x)
		    (b (- 1.0 g))
		    (rgb (colormap-ref spring-colormap x))
		    (r1 (rgb 0))
		    (g1 (rgb 1))
		    (b1 (rgb 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		   (snd-display #__line__ ";spring ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (do ((i 0 (+ i 1))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r x)
		    (g x)
		    (b x)
		    (rgb (colormap-ref gray-colormap x))
		    (r1 (rgb 0))
		    (g1 (rgb 1))
		    (b1 (rgb 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		   (snd-display #__line__ ";gray ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (do ((i 0 (+ i 1))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r 0.0)
		    (g 0.0)
		    (b 0.0)
		    (rgb (colormap-ref black-and-white-colormap x))
		    (r1 (rgb 0))
		    (g1 (rgb 1))
		    (b1 (rgb 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		   (snd-display #__line__ ";black-and-white ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (do ((i 0 (+ i 1))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r x)
		    (g (+ 0.5 (/ r 2)))
		    (b 0.4)
		    (rgb (colormap-ref summer-colormap x))
		    (r1 (rgb 0))
		    (g1 (rgb 1))
		    (b1 (rgb 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		   (snd-display #__line__ ";summer ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (do ((i 0 (+ i 1))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r (if (< x 2/5)
			   1.0
			   (if (< x 3/5)
			       (+ (* -5 x) 3)
			       (if (< x 4/5)
				   0.0
				   (- (* 10/3 x) 8/3)))))
		    (g (if (< x 2/5)
			   (* 5/2 x)
			   (if (< x 3/5)
			       1.0
			       (if (< x 4/5)
				   (+ (* -5 x) 4)
				   0.0))))
		    (b (if (< x 3/5)
			   0.0
			   (if (< x 4/5)
			       (- (* 5 x) 3)
			       1.0)))
		    (rgb (colormap-ref rainbow-colormap x))
		    (r1 (rgb 0))
		    (g1 (rgb 1))
		    (b1 (rgb 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		   (snd-display #__line__ ";rainbow ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (do ((i 0 (+ i 1))) ((= i 10))
	     (let* ((x (random 1.0))
		    (rgb (colormap-ref prism-colormap x)))
	       (if (and (< x (- 1.0 (/ 1.0 n)))
			(not (feql rgb '(1 0 0)))
			(not (feql rgb '(1 0.5 0)))
			(not (feql rgb '(1 1 0)))
			(not (feql rgb '(0 1 0)))
			(not (feql rgb '(0 0 1)))
			(not (feql rgb '(.6667 0 1))))
		   (snd-display #__line__ ";prism ~A" rgb))))
	   
	   (do ((i 0 (+ i 1))) ((= i 10))
	     (let* ((x (random 1.0))
		    (rgb (colormap-ref flag-colormap x)))
	       (if (and (< x (- 1.0 (/ 1.0 n)))
			(not (feql rgb '(1 0 0)))
			(not (feql rgb '(1 1 1)))
			(not (feql rgb '(0 0 1)))
			(not (feql rgb '(0 0 0))))
		   (snd-display #__line__ ";flag: ~A" rgb))))
	   )
	 (list 512 64)
	 (list 0.005 0.04))
	
	(let ((ind (add-colormap "white" (lambda (size) (list (make-float-vector size 1.0) (make-float-vector size 1.0) (make-float-vector size 1.0))))))
	  (if (not (colormap? ind))
	      (snd-display #__line__ ";add-colormap ~A: ~A" ind (colormap? ind)))
	  (if (not (feql (colormap-ref ind 0.5) '(1.0 1.0 1.0)))
	      (snd-display #__line__ ";white colormap: ~A" (colormap-ref ind 0.5)))
	  (let ((tag (catch #t (lambda () (set! *colormap* ind)) (lambda args args))))
	    (if (or (eq? tag 'no-such-colormap)
		    (not (equal? *colormap* ind))
		    (not (= (colormap->integer *colormap*) (colormap->integer ind))))
		(snd-display #__line__ ";colormap white: ~A ~A ~A" tag ind *colormap*)))
	  (if (not (string=? (colormap-name ind) "white"))
	      (snd-display #__line__ ";white colormap name: ~A" (colormap-name ind))))
	
	(let ((tag (catch #t (lambda () (delete-colormap (integer->colormap 1234))) (lambda args (car args)))))
	  (if (not (eq? tag 'no-such-colormap))
	      (snd-display #__line__ ";delete-colormap 1234: ~A" tag)))
	(let ((tag (catch #t (lambda () (colormap-ref (integer->colormap 1234) 0.5)) (lambda args (car args)))))
	  (if (not (eq? tag 'no-such-colormap))
	      (snd-display #__line__ ";colormap-ref 1234: ~A" tag)))
	(let ((tag (catch #t (lambda () (colormap-ref (integer->colormap -1) 0.5)) (lambda args (car args)))))
	  (if (and (not (eq? tag 'no-such-colormap))
		   (not (eq? tag 'wrong-type-arg)))
	      (snd-display #__line__ ";colormap-ref -1: ~A" tag)))
	(let ((tag (catch #t (lambda () (set! *colormap* (integer->colormap 1234))) (lambda args (car args)))))
	  (if (not (eq? tag 'no-such-colormap))
	      (snd-display #__line__ "; set colormap 1234: ~A" tag)))
	(let ((tag (catch #t (lambda () (set! *colormap* (integer->colormap -1))) (lambda args (car args)))))
	  (if (and (not (eq? tag 'no-such-colormap))
		   (not (eq? tag 'wrong-type-arg)))
	      (snd-display #__line__ "; set colormap -1: ~A" tag)))
	(let ((tag (catch #t (lambda () (colormap-ref copper-colormap 2.0)) (lambda args (car args)))))
	  (if (not (eq? tag 'out-of-range))
	      (snd-display #__line__ ";colormap-ref 2.0: ~A" tag)))
	
	(set! *colormap-size* old-colormap-size)
	(if (not (= *colormap-size* old-colormap-size))
	    (snd-display #__line__ ";set colormap-size: ~A ~A" *colormap-size* old-colormap-size))
	
	(if (not (string=? (colormap-name black-and-white-colormap) "black-and-white"))
	    (snd-display #__line__ ";black-and-white: ~A" (colormap-name black-and-white-colormap)))
	(if (not (string=? (colormap-name gray-colormap) "gray"))
	    (snd-display #__line__ ";gray: ~A" (colormap-name gray-colormap)))
	(if (not (string=? (colormap-name rainbow-colormap) "rainbow"))
	    (snd-display #__line__ ";rainbow: ~A" (colormap-name rainbow-colormap)))
	
	(let ()
	  (add-colormap "purple" 
			(lambda (size) 
			  (let ((r (make-float-vector size))
				(g (make-float-vector size))
				(b (make-float-vector size))
				(incr (/ 256.0 size))
				(er (list 0 60 60 116 128 252 192 252 256 60))
				(eg (list 0 0  64 0   128 252 192 252 256 0))
				(eb (list 0 80        128 252 192 0   256 80)))
			    (do ((i 0 (+ i 1))
				 (x 0.0 (+ x incr)))
				((= i size))
			      (set! (r i) (/ (envelope-interp x er) 256.0))
			      (set! (g i) (/ (envelope-interp x eg) 256.0))
			      (set! (b i) (/ (envelope-interp x eb) 256.0)))
			    (list r g b))))
	  (add-colormap "sin" 
			(lambda (size) 
			  (let ((r (make-float-vector size))
				(g (make-float-vector size))
				(b (make-float-vector size))
				(incr (/ (* 2 pi) size)))
			    (do ((i 0 (+ i 1))
				 (x 0.0 (+ x incr)))
				((= i size))
			      (set! (r i) (abs (sin (* 1.5 x))))
			      (set! (g i) (abs (sin (* 3.5 x))))
			      (set! (b i) (abs (sin (* 2.5 x)))))
			    (list r g b))))
	  (add-colormap "another-sin" 
			(lambda (size) 
			  (let ((r (make-float-vector size))
				(g (make-float-vector size))
				(b (make-float-vector size))
				(incr (/ (* 2 pi) size)))
			    (do ((i 0 (+ i 1))
				 (x 0.0 (+ x incr)))
				((= i size))
			      (set! (r i) (abs (sin (* 2.5 x))))
			      (set! (g i) (abs (sin (* 3.5 x))))
			      (set! (b i) (abs (sin (* 4.5 x)))))
			    (list r g b))))

	  (delete-colormap pink-colormap)
	  (if (colormap? pink-colormap)
	      (snd-display #__line__ ";delete-colormap ~A: ~A" pink-colormap (colormap? pink-colormap)))
	  (let ((tag (catch #t (lambda () (set! *colormap* pink-colormap)) (lambda args args))))
	    (if (or (not (eq? (car tag) 'no-such-colormap))
		    (equal? *colormap* pink-colormap))
		(snd-display #__line__ ";delete pink colormap: ~A ~A ~A" tag pink-colormap *colormap*)))
	  
	  (for-each
	   (lambda (n)
	     (set! *colormap-size* n)
	     (do ((i 0 (+ i 1))) 
		 ((= i 10))
	       (let* ((x (random 1.0))
		      (r (if (< x 4/5) (* 5/4 x) 1.0))
		      (g (* 4/5 x))
		      (b (* 1/2 x))
		      (rgb (colormap-ref copper-colormap x))
		      (r1 (rgb 0))
		      (g1 (rgb 1))
		      (b1 (rgb 2)))
		 (if (and (> n 2) (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		     (snd-display #__line__ ";copper size reset ~A: ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				  n x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1))))))
	   (list 1024 256 2 512))
	  (set! *colormap-size* 512))
	
	(set! (hook-functions graph-hook) ())
	)))



;;; ---------------- test 8: clm ----------------

(require snd-moog.scm snd-poly.scm snd-bird.scm snd-v.scm snd-numerics.scm snd-generators.scm)
(if (defined? 'gsl-roots) (require snd-analog-filter.scm))

(defgenerator sa1 freq (coscar #f) (sincar #f) (dly #f) (hlb #f))

(define (copy-test o)
  (let ((p (copy o)))
    (if (not (equal? o p))
	(snd-display #__line__ ";copy ~A != ~A~%" o p))
    (mus-apply o 1.0)
    (if (equal? o p)
	(snd-display #__line__ ";copy/run ~A == ~A~%" o p))
    (set! p (mus-copy o))
    (if (not (equal? o p))
	(snd-display #__line__ ";mus-copy ~A != ~A~%" o p))))

(define (osc-opt)
  (let ((g1 (make-oscil 1000))
	(g2 (make-oscil 1000))
	(g3 (make-oscil 1000))
	(g4 (make-oscil 1000))
	(g5 (make-oscil 1000))
	(g6 (make-oscil 1000))
	(x1 1.0)
	(x2 (hz->radians 100.0))
	(x4 (hz->radians 5.0)))
    (do ((i 0 (+ i 1)))
	((= i 50))
      (let ((o1 (oscil g1 x2))
	    (o2 (* 1.0 (oscil g2 x2)))
	    (o3 (oscil g3 (* x4 20.0)))
	    (o4 (oscil g4 (* 20.0 x4)))
	    (o5 (oscil g5 (* x1 x2)))
	    (o6 (* 1.0 (oscil g6 (* 20.0 x4)))))
	(if (> (abs (- (+ o2 o3 o4 o5 o6) (* 5 o1))) 1e-6)
	    (snd-display #__line__ "~A: ~1,4F ~1,4F ~1,4F ~1,4F ~1,4F ~1,4F" i o1 o2 o3 o4 o5 o6))))))

(define (nrxysin-opt)
  (let ((g1 (make-nrxysin 1000 :n 10 :r .9))
	(g2 (make-nrxysin 1000 :n 10 :r .9))
	(g3 (make-nrxysin 1000 :n 10 :r .9))
	(g4 (make-nrxysin 1000 :n 10 :r .9))
	(g5 (make-nrxysin 1000 :n 10 :r .9))
	(g6 (make-nrxysin 1000 :n 10 :r .9))
	(x1 1.0)
	(x2 (hz->radians 100.0))
	(x4 (hz->radians 5.0)))
    (do ((i 0 (+ i 1)))
	((= i 50))
      (let ((o1 (nrxysin g1 x2))
	    (o2 (* 1.0 (nrxysin g2 x2)))
	    (o3 (nrxysin g3 (* x4 20.0)))
	    (o4 (nrxysin g4 (* 20.0 x4)))
	    (o5 (nrxysin g5 (* x1 x2)))
	    (o6 (* 1.0 (nrxysin g6 (* 20.0 x4)))))
	(if (> (abs (- (+ o2 o3 o4 o5 o6) (* 5 o1))) 1e-6)
	    (format #t "~A: ~1,4F ~1,4F ~1,4F ~1,4F ~1,4F ~1,4F~%" i o1 o2 o3 o4 o5 o6))))))

(define (polywave-opt)
  (let ((g1 (make-polywave 1000 '(1 .5 2 .5)))
	(g2 (make-polywave 1000 '(1 .5 2 .5)))
	(g3 (make-polywave 1000 '(1 .5 2 .5)))
	(g4 (make-polywave 1000 '(1 .5 2 .5)))
	(g5 (make-polywave 1000 '(1 .5 2 .5)))
	(g6 (make-polywave 1000 '(1 .5 2 .5)))
	(x1 1.0)
	(x2 (hz->radians 100.0))
	(x4 (hz->radians 5.0)))
    (do ((i 0 (+ i 1)))
	((= i 50))
      (let ((o1 (polywave g1 x2))
	    (o2 (* 1.0 (polywave g2 x2)))
	    (o3 (polywave g3 (* x4 20.0)))
	    (o4 (polywave g4 (* 20.0 x4)))
	    (o5 (polywave g5 (* x1 x2)))
	    (o6 (* 1.0 (polywave g6 (* 20.0 x4)))))
	(if (> (abs (- (+ o2 o3 o4 o5 o6) (* 5 o1))) 1e-6)
	    (format #t "~A: ~1,4F ~1,4F ~1,4F ~1,4F ~1,4F ~1,4F~%" i o1 o2 o3 o4 o5 o6))))))

(define (test-simple-polywave n offset kind)
  (let ((p (make-polywave 400.0 
			  (let ((h (if offset (list offset 0) (list))))
			    (do ((i 1 (+ i 1)))
				((> i n))
			      (set! h (cons (* i .1) (cons i h))))
			    (reverse h))
			  kind))
	(vp (make-float-vector 200))
	(vo (make-float-vector 200))
	(ob (make-oscil-bank
	     (apply float-vector (let ((frqs (if offset (list 0.0) (list))))
				   (do ((i 1 (+ i 1)))
				       ((> i n))
				     (set! frqs (cons (hz->radians (* i 400.0)) frqs)))
				   (reverse frqs)))
	     (let ((phases (make-float-vector (+ n (if offset 1 0))
					      (if (= kind mus-chebyshev-second-kind) 0.0 (/ pi 2)))))
	       (if (and offset (= kind mus-chebyshev-second-kind))
		   (set! (phases 0) (/ pi 2)))
	       phases)
	     (apply float-vector (let ((amps (if offset (list offset) (list))))
				   (do ((i 1 (+ i 1)))
				       ((> i n))
				     (set! amps (cons (* i .1) amps)))
				   (reverse amps)))
	     #t)))
    (do ((i 0 (+ i 1)))
	((= i 200))
      (float-vector-set! vp i (polywave p)))
    (do ((i 0 (+ i 1)))
	((= i 200))
      (float-vector-set! vo i (oscil-bank ob)))
    (if (not (mus-arrays-equal? vp vo))
	(format *stderr* ";simple polywave ~A ~A ~A: ~A~%    ~A~%    ~A~%~A ~A~%" 
		n offset (if (= kind mus-chebyshev-first-kind) 'first 'second)
		(float-vector-peak (float-vector-subtract! (copy vp) vo))
		vp vo
		p ob))
    
    (let ((temp 0.0))
      (do ((i 0 (+ i 1)))
	  ((= i 200))
	(set! temp (polywave p))
	(vector-set! vp i temp)
	(set! (vo i) (oscil-bank ob)))
      (if (not (mus-arrays-equal? vp vo))
	  (format *stderr* ";simple polywave (temps) ~A ~A ~A: ~A~%    ~A~%    ~A~%~A ~A~%" 
		  n offset (if (= kind mus-chebyshev-first-kind) 'first 'second)
		  (float-vector-peak (float-vector-subtract! (copy vp) vo))
		  vp vo
		  p ob)))

    (let ((t1 (with-sound ("test.snd")
		(do ((i 0 (+ i 1)))
		    ((= i 200))
		  (outa i (polywave p)))))
	  (t2 (with-sound ("tst.snd")
		(do ((i 0 (+ i 1)))
		    ((= i 200))
		  (outa i (oscil-bank ob))))))
      (set! vp (channel->float-vector 0 200 (find-sound t1) 0))
      (set! vo (channel->float-vector 0 200 (find-sound t2) 0))
      
      (if (not (mus-arrays-equal? vp vo))
	  (format *stderr* ";simple polywave (with-sound) n: ~A, offset: ~A, type: ~A (len: ~D ~D): dist: ~A~%    ~A~%    ~A~%~A ~A~%" 
		  n offset (if (= kind mus-chebyshev-first-kind) 'first 'second)
		  (length vp) (length vo)
		  (float-vector-peak (float-vector-subtract! (copy vp) vo))
		  vp vo
		  p ob))
      (close-sound (find-sound t1))
      (close-sound (find-sound t2)))))

(define (test-simple-nsin n)
  (let ((p (make-nsin 400.0 n))
	(vp (make-float-vector 200))
	(vo (make-float-vector 200)))
    (let ((ob (make-oscil-bank 
	       (apply float-vector (let ((frqs ()))
				     (do ((i 1 (+ i 1)))
					 ((> i n))
				       (set! frqs (cons (hz->radians (* i 400.0)) frqs)))
				     (reverse frqs)))
	       (make-float-vector n 0.0)
	       (make-float-vector n (mus-scaler p))
	       #t)))
      (do ((i 0 (+ i 1)))
	  ((= i 200))
	(float-vector-set! vp i (nsin p)))
      (do ((i 0 (+ i 1)))
	  ((= i 200))
	(float-vector-set! vo i (oscil-bank ob)))
      (if (not (mus-arrays-equal? vp vo))
	  (format *stderr* ";simple nsin ~A: ~A~%    ~A~%    ~A~%~A ~A~%" 
		  n 
		  (float-vector-peak (float-vector-subtract! (copy vp) vo))
		  vp vo
		  p ob)))))

(define (test-simple-ncos n)
  (let ((p (make-ncos 400.0 n))
	(vp (make-float-vector 200))
	(vo (make-float-vector 200)))
    (let ((ob (make-oscil-bank 
	       (apply float-vector (let ((frqs ()))
				     (do ((i 1 (+ i 1)))
					 ((> i n))
				       (set! frqs (cons (hz->radians (* i 400.0)) frqs)))
				     (reverse frqs)))
	       (make-float-vector n (/ pi 2.0))
	       (make-float-vector n (mus-scaler p))
	       #t)))
      (do ((i 0 (+ i 1)))
	  ((= i 200))
	(float-vector-set! vp i (ncos p)))
      (do ((i 0 (+ i 1)))
	  ((= i 200))
	(float-vector-set! vo i (oscil-bank ob)))
      (if (not (mus-arrays-equal? vp vo))
	  (format *stderr* ";simple ncos ~A: ~A~%    ~A~%    ~A~%~A ~A~%" 
		  n 
		  (float-vector-peak (float-vector-subtract! (copy vp) vo))
		  vp vo
		  p ob)))))

(define (snd-test-jc-reverb decay-dur low-pass volume amp-env)
  (let ((allpass1 (make-all-pass -0.700 0.700 1051))
	(allpass2 (make-all-pass -0.700 0.700  337))
	(allpass3 (make-all-pass -0.700 0.700  113))
	(comb1 (make-comb 0.742 4799))
	(comb2 (make-comb 0.733 4999))
	(comb3 (make-comb 0.715 5399))
	(comb4 (make-comb 0.697 5801))
	(dur (+ decay-dur (/ (framples) (srate))))
	(outdel (make-delay (seconds->samples .013))))
    (let ((combs (make-comb-bank (vector comb1 comb2 comb3 comb4)))
	  (allpasses (make-all-pass-bank (vector allpass1 allpass2 allpass3))))
      (if (or amp-env low-pass)
	  (let ((flt (and low-pass (make-fir-filter 3 (float-vector 0.25 0.5 0.25))))
		(envA (make-env :envelope (or amp-env '(0 1 1 1)) :scaler volume :duration dur)))
	    (if low-pass
		(map-channel
		 (lambda (inval)
		   (+ inval (delay outdel (* (env envA) (fir-filter flt (comb-bank combs (all-pass-bank allpasses inval)))))))
		 0 (round (* dur (srate))))
		(map-channel
		 (lambda (inval)
		   (+ inval (delay outdel (* (env envA) (comb-bank combs (all-pass-bank allpasses inval))))))
		 0 (round (* dur (srate))))))
	  (map-channel
	   (lambda (inval)
	     (+ inval (delay outdel (* volume (comb-bank combs (all-pass-bank allpasses inval))))))
	   0 (round (* dur (srate))))))))




;;; -------- scissor-tailed flycatcher
;;;
;;; mix a scissor-tailed flycatcher call into the current sound
;;; see bird.scm for lots more birds


(define scissor 
  (let ((documentation "(scissor beg) is the scissor-tailed flycatcher"))
    (lambda (begin-time) ; test 23 also
      (let ((scissorf '(0 0  40 1  60 1  100 0)))
	(bigbird begin-time 0.05 1800 1800 .2 
		 scissorf 
		 '(0 0  25 1  75 1  100 0) 
		 '(1 .5  2 1  3 .5  4 .1  5 .01))))))


(define (snd_test_8)
  
  ;; ----------------
  (define (bumpy)
    (let* ((x 0.0) 
	   (xi (/ 1.0 (framples)))
	   (start 0)
	   (end 1)
	   (scl (exp (/ 4.0 (- end start))))) ; normalize it
      (map-channel (lambda (y) 
		     (let ((val (if (or (<= x start) ; don't divide by zero
					(>= x end))
				    0.0
				    (* (exp (/ -1.0 (- x start))) 
				       (exp (/ -1.0 (- end x)))))))
		       (set! x (+ x xi))
		       (* scl val))))))
  
  ;; ----------------
  (define test-scanned-synthesis
    ;; check out scanned-synthesis
    (lambda (amp dur mass xspring damp)
      (let* ((size 256)
	     (x0 (make-float-vector size))	   
	     (x1 (make-float-vector size))	   
	     (x2 (make-float-vector size)))
	(do ((i 0 (+ i 1)))
	    ((= i 12))
	  (let ((val (sin (/ (* 2 pi i) 12.0))))
	    (set! (x1 (+ i (- (/ size 4) 6))) val)))
	(let ((gen1 (make-table-lookup 440.0 :wave x1))
	      (gen2 (make-table-lookup 440.0 :wave x2))
	      (recompute-samps 30) ;just a quick guess
	      (data (make-float-vector dur)))
	  (do ((i 0 (+ i 1))
	       (k 0.0)
	       (kincr (/ 1.0 recompute-samps)))
	      ((= i dur))
	    (if (>= k 1.0)
		(begin
		  (set! k 0.0)
		  (compute-uniform-circular-string size x0 x1 x2 mass xspring damp))
		(set! k (+ k kincr)))
	    (let ((g1 (table-lookup gen1))
		  (g2 (table-lookup gen2)))
	      (set! (data i) (+ g2 (* k (- g1 g2))))))
	  (let ((curamp (float-vector-peak data)))
	    (float-vector-scale! data (/ amp curamp)))
	  (float-vector->channel data 0 dur)))))
  
  ;; (test-scanned-synthesis .1 10000 1.0 0.1 0.0)
  
  ;; ----------------
  (define* (array-interp-sound-diff snd chn)
    
    (define (envelope->float-vector e len)
      (let ((v (make-float-vector len))
	    (e (make-env e :length len)))
	(do ((i 0 (+ i 1)))
	    ((= i len))
	  (set! (v i) (env e)))
	v))
    
    (let ((tbl (envelope->float-vector (list 0.0 -1.0 1.0 1.0) 1001))
	  (curpos (edit-position snd chn)))
      (map-channel (lambda (y)
		     (array-interp tbl (+ 500.0 (* y 500)) 1000))
		   0 #f snd chn)
      
      (let ((r (make-sampler 0 snd chn 1 curpos))
	    (mx 0.0))
	(scan-channel (lambda (y) 
			(set! mx (max mx (abs (- y (next-sample r))))))
		      0 #f snd chn)
	mx)))
  
  ;; ----------------
  (define make-papoulis-window 
    (let ((documentation "(make-papoulis-window size) returns a papoulis window os the given size"))
      (lambda (n)
	(let ((v (make-float-vector n))
	      (n2 (/ n 2)))
	  (do ((i (- n2) (+ i 1)))
	      ((= i n2))
	    (let* ((ratio (/ i n))
		   (pratio (* 2 pi ratio)))
	      (set! (v (+ i n2)) (+ (/ (abs (sin pratio)) pi)
				    (* (- 1.0 (* 2 (abs ratio)))
				       (cos pratio))))))
	  v))))
      
  ;; ----------------
  (define make-dpss-window 
    (let ((documentation "(make-dpss-window size w) returns a prolate spheriodal (slepian) window of the given size"))
      ;; from Verma, Bilbao, Meng, "The Digital Prolate Spheroidal Window"
      ;; output checked using Julius Smith's dpssw.m, although my "w" is different
      (lambda (n w)
	(let ((mat (make-float-vector (list n n) 0.0))
	      (cw (cos (* 2 pi w))))
	  (do ((i 0 (+ i 1)))
	      ((= i n))
	    (let ((n2 (- (* 0.5 (- n 1)) i))) 
	      (set! (mat i i) (* cw n2 n2))
	      (if (< i (- n 1))
		  (set! (mat i (+ i 1)) (* 0.5 (+ i 1) (- n 1 i))))
	      (if (> i 0)
		  (set! (mat i (- i 1)) (* 0.5 i (- n i))))))
	  (let* ((vc (vector-ref (cadr (gsl-eigenvectors mat)) 0)) ; cadr->vector of fv-vectors
		 (v (copy vc (make-float-vector (length vc))))
		 (pk 0.0))
	    ;; sign of eigenvalue is arbitrary, and eigenvector is scaled to sum to 1.0
	    ;;   but we want peak of 1.0 to serve as fft window
	    (do ((i 0 (+ i 1)))
		((= i n))
	      (if (> (abs (v i)) (abs pk))
		  (set! pk (v i)))) 
	    (float-vector-scale! v (/ 1.0 pk)))))))
  
  ;; ----------------
  (define (test-lpc)
    (define (make-sine n) 
      (let ((data (make-float-vector n 0.0))
	    (incr (/ (* 2.0 pi) n)))
	(do ((i 0 (+ i 1))
	     (x 0.0 (+ x incr)))
	    ((= i n) data) 
	  (set! (data i) (sin x)))))
    (define (make-sines n) 
      (let ((data (make-float-vector n 0.0))
	    (incr (/ (* 2.0 pi) n)))
	(do ((i 0 (+ i 1))
	     (x 0.0 (+ x incr)))
	    ((= i n) data) 
	  (set! (data i) (+ (sin x)
				       (* .25 (sin (* 2.0 x)))
				       (* .125 (sin (* 4.0 x))))))))
    
    (let ((vals (lpc-predict (float-vector 0 1 2 3 4 5 6 7) 8 (lpc-coeffs (float-vector 0 1 2 3 4 5 6 7) 8 4) 4 2)))
      (if (not (vequal vals (float-vector 7.906 8.557)))
	  (snd-display #__line__ ";predict ramp: ~A" vals)))
    (let ((vals (lpc-predict (float-vector 0 1 2 3 4 5 6 7) 8 (lpc-coeffs (float-vector 0 1 2 3 4 5 6 7) 8 7) 7 2)))
      (if (not (vequal vals (float-vector 7.971 8.816))) 
	  (snd-display #__line__ ";predict ramp 1: ~A" vals)))
    (let ((vals (lpc-predict (float-vector 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14) 15 
			     (lpc-coeffs (float-vector 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14) 15 7) 7 5)))
      (if (not (vequal vals (float-vector 14.999 15.995 16.980 17.940 18.851)))
	  (snd-display #__line__ ";predict ramp 2: ~A" vals)))
    (let ((vals (lpc-predict (float-vector 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14) 15 
			     (lpc-coeffs (float-vector 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14) 15 14) 14 5)))
      (if (not (vequal vals (float-vector 15.000 16.000 16.998 17.991 18.971)))
	  (snd-display #__line__ ";predict ramp 3: ~A" vals)))
    (let ((vals (lpc-predict (make-sine 16) 16 (lpc-coeffs (make-sine 16) 16 8) 8 2)))
      (if (not (vequal vals (float-vector 0.000 0.383)))
	  (snd-display #__line__ ";predict sine: ~A" vals)))
    (let ((vals (lpc-predict (make-sine 16) 16 (lpc-coeffs (make-sine 16) 16 8) 8 8)))
      (if (not (vequal vals (float-vector 0.000 0.383 0.707 0.924 1.000 0.924 0.707 0.383)))
	  (snd-display #__line__ ";predict sine 1: ~A" vals)))
    (let ((vals (lpc-predict (make-sines 32) 32 (lpc-coeffs (make-sines 32) 32 8) 8 8)))
      (if (not (vequal vals (float-vector 0.000 0.379 0.686 0.880 0.970 1.001 1.022 1.053)))
	  (snd-display #__line__ ";predict sines: ~A" vals)))
    (let ((vals (lpc-predict (make-sines 32) 32 (lpc-coeffs (make-sines 32) 32 16) 16 8)))
      (if (and (not (vequal vals (float-vector 0.000 0.379 0.684 0.876 0.961 0.987 1.006 1.046)))
	       (not (vequal vals (float-vector 0.000 0.379 0.685 0.876 0.961 0.985 0.998 1.029))))
	  (snd-display #__line__ ";predict sines 1: ~A" vals)))
    (let ((vals (lpc-predict (make-sines 32) 32 (lpc-coeffs (make-sines 32) 32 30) 30 4)))
      (if (and (not (vequal vals (float-vector 0.000 0.379 0.685 0.878)))
	       (not (vequal vals (float-vector 0.000 0.379 0.684 0.875)))) ; double float-vectors
	  (snd-display #__line__ ";predict sines 2: ~A" vals)))
    (let ((vals (lpc-predict (make-sines 64) 64 (lpc-coeffs (make-sines 64) 64 32) 32 8)))
      (if (not (vequal vals (float-vector 0.000 0.195 0.379 0.545 0.684 0.795 0.875 0.927)))
	  (snd-display #__line__ ";predict sines 3: ~A" vals))))
  
  ;; ----------------
  (define (test-unclip-channel)
    (let ((ind (new-sound "test.snd" 2 22050 mus-lfloat mus-next "unclip-channel test" 1)))
      (set! (sync ind) 1)
      
      (mix "oboe.snd" 0 0 ind 0 #f)
      (mix "oboe.snd" 0 0 ind 1 #f)
      (let ((scl (/ 1.01 (maxamp ind 0)))
	    (dur (framples ind 0)))
	(scale-channel scl 0 dur ind 0)
	(scale-channel scl 0 dur ind 1))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (vals 1))
	     (clips (vals 3))
	     (lmax (vals 5)))
	(if (not (= clips 20)) (snd-display #__line__ ";unclip-channel 0 oboe clips: ~A" clips))
	(if (not (= lmax 1)) (snd-display #__line__ ";unclip-channel 0 oboe max len: ~A" lmax))
	(if (fneq umax .999) (snd-display #__line__ ";unclip-channel 0 oboe maxamp: ~A" umax)))
      
      (revert-sound ind)
      (let ((data (make-float-vector 100 0.0))
	    (e (make-env '(0 0 1 .8 1.5 1.0 2.0 1.0 2.5 .8 3.5 0) :length 101))
	    (o (make-oscil 1000)))
	(do ((i 0 (+ i 1))) 
	    ((= i 100) data) 
	  (set! (data i) (* 1.05 (env e) (oscil o))))
	(float-vector->channel data 0 100 ind 0)
	(float-vector->channel data 0 100 ind 1))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (vals 1))
	     (clips (vals 3))
	     (lmax (vals 5)))
	(if (not (= clips 1)) (snd-display #__line__ ";unclip-channel 1 sine clips: ~A" clips))
	(if (not (= lmax 2)) (snd-display #__line__ ";unclip-channel 1 sine max len: ~A" lmax))
	(if (fneq umax .999) (snd-display #__line__ ";unclip-channel 1 sine maxamp: ~A" umax)))
      
      (revert-sound ind)
      (let ((data (make-float-vector 100 0.0))
	    (e (make-env '(0 0 1 .8 1.75 1.0 2.0 1.0 2.25 .8 3.5 0) :length 101))
	    (o (make-oscil 1000)))
	(do ((i 0 (+ i 1))) 
	    ((= i 100) data) 
	  (set! (data i) (* 1.1 (env e) (oscil o))))
	(float-vector->channel data 0 100 ind 0)
	(float-vector->channel data 0 100 ind 1))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (vals 1))
	     (clips (vals 3))
	     (lmax (vals 5)))
	(if (not (= clips 1)) (snd-display #__line__ ";unclip-channel 2 sine clips: ~A" clips))
	(if (not (= lmax 3)) (snd-display #__line__ ";unclip-channel 2 sine max len: ~A" lmax))
	(if (fneq umax .999) (snd-display #__line__ ";unclip-channel 2 sine maxamp: ~A" umax)))
      
      (revert-sound ind)
      (let ((data (make-float-vector 100 0.0))
	    (e (make-env '(0 0 1 .8 1.85 1.0 2.0 1.0 2.15 .8 3.5 0) :length 101))
	    (o1 (make-oscil 1000))
	    (o2 (make-oscil 2000)))
	(do ((i 0 (+ i 1))) 
	    ((= i 100) data) 
	  (set! (data i) (* 1.2 (env e) (+ (* .75 (oscil o1)) (* .25 (oscil o2))))))
	(float-vector->channel data 0 100 ind 0)
	(float-vector->channel data 0 100 ind 1))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (vals 1))
	     (clips (vals 3))
	     (lmax (vals 5)))
	(if (not (= clips 1)) (snd-display #__line__ ";unclip-channel 3 sine clips: ~A" clips))
	(if (not (= lmax 1)) (snd-display #__line__ ";unclip-channel 3 sine max len: ~A" lmax))
	(if (fneq umax .999) (snd-display #__line__ ";unclip-channel 3 sine maxamp: ~A" umax)))
      
      (revert-sound ind)
      (let ((data (make-float-vector 100 0.0))
	    (e (make-env '(0 0 40 .75 45 1.0 50 1.25 55 1.0 60 .75 100 0.0) :length 101))
	    (o1 (make-oscil 1000))
	    (o2 (make-oscil 2000)))
	(do ((i 0 (+ i 1))) 
	    ((= i 100) data) 
	  (set! (data i) (* 1.5 (env e) (+ (* .75 (oscil o1)) (* .25 (oscil o2))))))
	(float-vector->channel data 0 100 ind 0)
	(float-vector->channel data 0 100 ind 1))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (vals 1))
	     (clips (vals 3))
	     (lmax (vals 5)))
	(if (not (= clips 1)) (snd-display #__line__ ";unclip-channel 4 sine clips: ~A" clips))
	(if (not (= lmax 4)) (snd-display #__line__ ";unclip-channel 4 sine max len: ~A" lmax))
	(if (fneq umax .999) (snd-display #__line__ ";unclip-channel 4 sine maxamp: ~A" umax)))
      
      (revert-sound ind)
      (let ((data (make-float-vector 100 0.0))
	    (o1 (make-oscil 1000)))
	(do ((i 0 (+ i 1))) 
	    ((= i 100) data) 
	  (set! (data i) (* .25 (oscil o1))))
	(let ((true-max (float-vector-peak data)))
	  (set! (data 50) (+ (data 50) 1.25))
	  (float-vector->channel data 0 100 ind 0)
	  (float-vector->channel data 0 100 ind 1)
	  
	  (let* ((vals (unclip-channel ind 1))
		 (umax (vals 1))
		 (clips (vals 3))
		 (lmax (vals 5)))
	    (if (not (= clips 1)) (snd-display #__line__ ";unclip-channel 5 click clips: ~A" clips))
	    (if (not (= lmax 1)) (snd-display #__line__ ";unclip-channel 5 click max len: ~A" lmax))
	    (if (fneq umax true-max) (snd-display #__line__ ";unclip-channel 5 click maxamp: ~A ~A" umax true-max)))))
      
      (revert-sound ind)
      (let ((data (make-float-vector 100 0.0))
	    (o1 (make-oscil 1000)))
	(do ((i 0 (+ i 1))) 
	    ((= i 100) data) 
	  (set! (data i) (* .25 (oscil o1))))
	(let ((true-max (float-vector-peak data)))
	  (do ((i 49 (+ i 1)))
	      ((= i 51))
	    (set! (data i) (+ (data i) 1.25)))
	  (float-vector->channel data 0 100 ind 0)
	  (float-vector->channel data 0 100 ind 1)
	  
	  (let* ((vals (unclip-channel ind 1))
		 (umax (vals 1))
		 (clips (vals 3))
		 (lmax (vals 5)))
	    (if (not (= clips 1)) (snd-display #__line__ ";unclip-channel 6 click clips: ~A" clips))
	    (if (not (= lmax 2)) (snd-display #__line__ ";unclip-channel 6 click max len: ~A" lmax))
	    (if (fneq umax true-max) (snd-display #__line__ ";unclip-channel 6 click maxamp: ~A ~A" umax true-max)))))
      
      (revert-sound ind)
      (let ((data (make-float-vector 100 0.0))
	    (o1 (make-oscil 1000)))
	(do ((i 0 (+ i 1))) 
	    ((= i 100) data) 
	  (set! (data i) (* .25 (oscil o1))))
	(let ((true-max (float-vector-peak data)))
	  (do ((i 45 (+ i 1)))
	      ((= i 55))
	    (set! (data i) (+ (data i) 1.25)))
	  (float-vector->channel data 0 100 ind 0)
	  (float-vector->channel data 0 100 ind 1)
	  
	  (let* ((vals (unclip-channel ind 1))
		 (umax (vals 1))
		 (clips (vals 3))
		 (lmax (vals 5)))
	    (if (not (= clips 1)) (snd-display #__line__ ";unclip-channel 7 click clips: ~A" clips))
	    (if (not (= lmax 10)) (snd-display #__line__ ";unclip-channel 7 click max len: ~A" lmax))
	    (if (fneq umax true-max) (snd-display #__line__ ";unclip-channel 7 click maxamp: ~A ~A" umax true-max)))))
      
      (revert-sound ind)
      (let ((data (make-float-vector 100 0.0))
	    (o1 (make-oscil 1000))
	    (o2 (make-oscil 2000)))
	(do ((i 0 (+ i 1))) 
	    ((= i 100) data) 
	  (set! (data i) (* .25 (+ (oscil o1) (oscil o2)))))
	(let ((true-max (float-vector-peak data)))
	  (do ((i 45 (+ i 1)))
	      ((= i 55))
	    (set! (data i) (+ (data i) 1.25)))
	  (float-vector->channel data 0 100 ind 0)
	  (float-vector->channel data 0 100 ind 1)
	  
	  (let* ((vals (unclip-channel ind 1))
		 (umax (vals 1))
		 (clips (vals 3))
		 (lmax (vals 5)))
	    (if (not (= clips 1)) (snd-display #__line__ ";unclip-channel 8 click clips: ~A" clips))
	    (if (not (= lmax 10)) (snd-display #__line__ ";unclip-channel 8 click max len: ~A" lmax))
	    (if (fneq umax true-max) (snd-display #__line__ ";unclip-channel 8 click maxamp: ~A ~A" umax true-max)))))
      
      (revert-sound ind)
      (let ((data (make-float-vector 200 0.0))
	    (o1 (make-oscil 1000))
	    (o2 (make-oscil 2000)))
	(do ((i 0 (+ i 1))) 
	    ((= i 200) data) 
	  (set! (data i) (* .25 (+ (oscil o1) (oscil o2)))))
	(let ((true-max (float-vector-peak data)))
	  (do ((i 45 (+ i 1)))
	      ((= i 55))
	    (set! (data i) (+ (data i) 2.0)))
	  (do ((i 75 (+ i 1)))
	      ((= i 85))
	    (set! (data i) (+ (data i) 2.0)))
	  (float-vector->channel data 0 200 ind 0)
	  (float-vector->channel data 0 200 ind 1)
	  
	  (let* ((vals (unclip-channel ind 1))
		 (umax (vals 1))
		 (clips (vals 3))
		 (lmax (vals 5)))
	    (if (not (= clips 2)) (snd-display #__line__ ";unclip-channel 9 collision clips: ~A" clips))
	    (if (not (= lmax 10)) (snd-display #__line__ ";unclip-channel 9 collision max len: ~A" lmax))
	    (if (fneq umax true-max) (snd-display #__line__ ";unclip-channel 9 collision maxamp: ~A ~A" umax true-max)))))
      
      (revert-sound ind)
      (mix "oboe.snd" 0 0 ind 0 #f)
      (mix "oboe.snd" 0 0 ind 1 #f)
      (scale-sound (/ 1.01 (maxamp ind 0)))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (vals 1))
	     (clips (vals 3))
	     (lmax (vals 5)))
	(if (not (= clips 20)) (snd-display #__line__ ";unclip-channel 10 oboe clips: ~A" clips))
	(if (not (= lmax 1)) (snd-display #__line__ ";unclip-channel 10 oboe max len: ~A" lmax))
	(if (fneq umax 0.999) (snd-display #__line__ ";unclip-channel 10 oboe maxamp: ~A" umax)))
      
      (revert-sound ind)
      (mix "oboe.snd" 0 0 ind 0 #f)
      (mix "oboe.snd" 0 0 ind 1 #f)
      (scale-sound (/ 1.05 (maxamp ind 0)))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (vals 1))
	     (clips (vals 3))
	     (lmax (vals 5)))
	(if (not (= clips 217)) (snd-display #__line__ ";unclip-channel 11 oboe clips: ~A" clips))
	(if (not (= lmax 2)) (snd-display #__line__ ";unclip-channel 11 oboe max len: ~A" lmax))
	(if (fneq umax 0.999) (snd-display #__line__ ";unclip-channel 11 oboe maxamp: ~A" umax)))
      
      (revert-sound ind)
      (mix "oboe.snd" 0 0 ind 0 #f)
      (mix "oboe.snd" 0 0 ind 1 #f)
      (let ((scl (/ 1.2 (maxamp ind 0))))
	(env-sound (make-env (list 0 0 .48 (/ scl 2) .5 scl .52 (/ scl 2) 1.0 0) :length (framples ind 0))))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (vals 1))
	     (clips (vals 3))
	     (lmax (vals 5)))
	(if (not (= clips 28)) (snd-display #__line__ ";unclip-channel 12 oboe clips: ~A" clips))
	(if (not (= lmax 3)) (snd-display #__line__ ";unclip-channel 12 oboe max len: ~A" lmax))
	(if (fneq umax 0.999) (snd-display #__line__ ";unclip-channel 12 oboe maxamp: ~A" umax)))
      
      (close-sound ind)))
  
  ;; ----------------
  (define (analog-filter-tests)
    
    (define v (make-float-vector 1000))

    (define (sweep->bins flt bins)
      (let ((ind (open-sound "sweep.snd")))
	(if (mus-generator? flt)
	    (clm-channel flt)
	    (map-channel flt))
	(let ((mx (maxamp))
	      (resp (make-float-vector bins))
	      (size (round (/ 22050 bins)))
	      (data (channel->float-vector)))
	  (do ((i 0 (+ i 1)))
	      ((= i bins))
	    (float-vector-set! resp i (float-vector-peak (make-shared-vector data (list size) (* i size)))))
	  (close-sound ind)
	  (list mx resp))))
    
    (define (filter-response-max f1)
      (set! (v 0) (f1 1.0))
      (do ((i 1 (+ i 1)))
	  ((= i 1000))
	(set! (v i) (filter f1 0.0)))
      (float-vector-peak v))
    
    (define (filter-equal? f1 f2) ; equalp in clm2xen is too restrictive
      (and (= (mus-order f1) (mus-order f2))
	   (vequal (mus-xcoeffs f1) (mus-xcoeffs f2))
	   (vequal (mus-ycoeffs f1) (mus-ycoeffs f2))))
    
    ;; ---------------- butterworth tests ----------------
    
    (let ((poles (list (float-vector 1.000 1.414 1.000) ; numerous references provide these tables (y[0] is ignored)
		       (float-vector 1.000 1.848 1.000 1.000 0.765 1.000)
		       (float-vector 1.000 1.932 1.000 1.000 1.414 1.000 1.000 0.518 1.000)
		       (float-vector 1.000 1.962 1.000 1.000 1.663 1.000 1.000 1.111 1.000 1.000 0.390 1.000)
		       (float-vector 1.000 1.975 1.000 1.000 1.782 1.000 1.000 1.414 1.000 1.000 0.908 1.000 1.000 0.313 1.000))))
      (do ((i 2 (+ i 2))
	   (k 0 (+ k 1)))
	  ((>= i 12))
	(let ((vals (butterworth-prototype i)))
	  (if (not (vequal (cadr vals) (poles k)))
	      (snd-display #__line__ ";butterworth prototype poles ~A: ~A (~A)" i (cadr vals) (poles k)))
	  (let ((zeros (make-float-vector (* (+ k 1) 3))))
	    (do ((j 2 (+ j 3)))
		((>= j (* (+ k 1) 3)))
	      (set! (zeros j) 1.0))
	    (if (not (vequal (car vals) zeros))
		(snd-display #__line__ ";butterworth prototype zeros ~A: ~A (~A)" i (car vals) zeros)))))
      (do ((cutoff .1 (+ cutoff .1))
	   (m 0 (+ 1 m)))
	  ((= m 3))
	(do ((i 2 (+ i 2))
	     (k 1 (+ k 1)))
	    ((= i 16))
	  (let ((local (make-butterworth-lowpass i cutoff))
		(dsp (make-butter-lp k (* *clm-srate* cutoff))))
	    (if (not (filter-equal? local dsp))
		(snd-display #__line__ ";butterworth lowpass ~A ~A ~A" cutoff local dsp)))
	  (let ((local (make-butterworth-highpass i cutoff))
		(dsp (make-butter-hp k (* *clm-srate* cutoff))))
	    (if (not (filter-equal? local dsp))
		(snd-display #__line__ ";butterworth highpass ~A ~A ~A" cutoff local dsp)))))
      
      (let ((ind (open-sound "oboe.snd")))
	(map-channel (make-eliminate-hum 550))
	(let ((peaker (make-peaking-2 500 1000 1.0)))
	  (map-channel peaker))
	(map-channel (chordalize))
	(close-sound ind))

      (let ((ind (new-sound "sweep.snd" 1 22050 mus-ldouble mus-next #f 22050)))
	(let ((ph (make-one-pole 1.0 -1.0))
	      (fq (make-one-pole 1.0 -1.0))
	      (incr (/ pi 22050.0)))
	  (map-channel
	   (lambda (y)
	     (* .5 (sin (one-pole ph (one-pole fq incr)))))
	   2)) ; make it look like the old form
	(save-sound ind)
	(close-sound ind))
      
      (let* ((f1 (make-butterworth-lowpass 8 .1))
	     (vals (sweep->bins f1 10)))
	(if (fneq (car vals) .5) (snd-display #__line__ ";butterworth lp 8 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.500 0.500 0.359 0.014 0.001 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";butterworth lp 8 .1 spect: ~A" (cadr vals))))
      (let* ((f1 (make-butterworth-lowpass 12 .25))
	     (vals (sweep->bins f1 10)))
	(if (fneq (car vals) .5) (snd-display #__line__ ";butterworth lp 12 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.500 0.500 0.500 0.500 0.499 0.358 0.010 0.000 0.000 0.000)))
	    (snd-display #__line__ ";butterworth lp 12 .25 spect: ~A" (cadr vals))))
      (let* ((f1 (make-butterworth-lowpass 10 .4))
	     (vals (sweep->bins f1 10)))
	(if (fneq (car vals) .5) (snd-display #__line__ ";butterworth lp 10 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (float-vector 0.500 0.500 0.500 0.500 0.500 0.500 0.500 0.499 0.361 0.001)))
		 (not (vequal1 (cadr vals) (float-vector 0.500 0.500 0.500 0.500 0.500 0.500 0.500 0.499 0.360 0.002))))
	    (snd-display #__line__ ";butterworth lp 10 .4 spect: ~A" (cadr vals))))
      
      (do ((i 2 (+ i 2)))
	  ((= i 12))
	(do ((j .1 (+ j .1)))
	    ((>= j .45))
	  (let* ((f1 (make-butterworth-lowpass i j))
		 (mx (filter-response-max f1)))
	    (if (> mx 1.0)
		(snd-display #__line__ ";butter low max ~A ~A: ~A" i j mx)))))
      
      (let* ((f1 (make-butterworth-highpass 8 .1))
	     (vals (sweep->bins f1 10)))
	(if (fneq (car vals) .5) (snd-display #__line__ ";butterworth hp 8 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.001 0.348 0.500 0.500 0.500 0.500 0.500 0.500 0.500 0.500)))
	    (snd-display #__line__ ";butterworth hp 8 .1 spect: ~A" (cadr vals))))
      (let* ((f1 (make-butterworth-highpass 12 .25))
	     (vals (sweep->bins f1 10)))
	(if (fneq (car vals) .5) (snd-display #__line__ ";butterworth hp 12 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.000 0.000 0.000 0.011 0.348 0.500 0.500 0.500 0.500 0.500)))
	    (snd-display #__line__ ";butterworth hp 12 .25 spect: ~A" (cadr vals))))
      (let* ((f1 (make-butterworth-highpass 10 .4))
	     (vals (sweep->bins f1 10)))
	(if (fneq (car vals) .5) (snd-display #__line__ ";butterworth hp 10 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 0.005 0.343 0.501 0.501)))
	    (snd-display #__line__ ";butterworth hp 10 .4 spect: ~A" (cadr vals))))
      
      (let* ((f1 (make-butterworth-bandpass 4 .1 .2))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";butterworth bp 4 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.028 0.350 0.481 0.479 0.346 0.132 0.038 0.009 0.002 0.000)))
	    (snd-display #__line__ ";butterworth bp 4 .1 .2 spect: ~A" (cadr vals))))
      (let* ((f1 (make-butterworth-bandpass 12 .1 .2))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";butterworth bp 12 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (float-vector 0.006 0.317 0.501 0.500 0.358 0.009 0.000 0.000 0.000 0.000)))
		 (not (vequal1 (cadr vals) (float-vector 0.012 0.319 0.501 0.500 0.358 0.009 0.000 0.000 0.000 0.000)))
		 (not (vequal1 (cadr vals) (float-vector 0.000 0.323 0.501 0.500 0.358 0.009 0.000 0.000 0.000 0.000))))
	    (snd-display #__line__ ";butterworth bp 12 .1 .2 spect: ~A" (cadr vals))))
      (let* ((f1 (make-butterworth-bandpass 8 .3 .4))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";butterworth bp 8 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.000 0.000 0.000 0.003 0.034 0.344 0.499 0.499 0.353 0.002)))
	    (snd-display #__line__ ";butterworth bp 8 .3 .4 spect: ~A" (cadr vals))))
      
      (do ((i 2 (+ i 2)))
	  ((= i 12))
	(do ((j .1 (+ j .1)))
	    ((>= j .45))
	  (let* ((f1 (make-butterworth-highpass i j))
		 (mx (filter-response-max f1)))
	    (if (> mx 1.0)
		(snd-display #__line__ ";butter high max ~A ~A: ~A" i j mx)))))
      
      (let* ((f1 (make-butterworth-bandstop 4 .1 .2))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";butterworth bs 4 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.500 0.500 0.347 0.339 0.481 0.499 0.500 0.500 0.500 0.500)))
	    (snd-display #__line__ ";butterworth bs 4 .1 .2 spect: ~A" (cadr vals))))
      (let* ((f1 (make-butterworth-bandstop 12 .1 .2))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";butterworth bs 12 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (float-vector 0.503 0.503 0.364 0.334 0.500 0.500 0.500 0.500 0.500 0.500)))
		 (not (vequal1 (cadr vals) (float-vector 0.502 0.503 0.365 0.334 0.500 0.500 0.500 0.500 0.500 0.500)))
		 (not (vequal1 (cadr vals) (float-vector 0.500 0.500 0.365 0.334 0.500 0.500 0.500 0.500 0.500 0.500))))
	    (snd-display #__line__ ";butterworth bs 12 .1 .2 spect: ~A" (cadr vals))))
      (let* ((f1 (make-butterworth-bandstop 8 .3 .4))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";butterworth bs 8 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.500 0.500 0.500 0.500 0.500 0.498 0.354 0.332 0.500 0.500)))
	    (snd-display #__line__ ";butterworth bs 8 .3 .4 spect: ~A" (cadr vals))))
      
      
      ;; ---------------- Chebyshev ----------------
      
      ;; ripple .01 .1 1 for 2..10 even
      
      (let ((poles-01 (list (float-vector 1.000 4.456 10.426)
			    (float-vector 1.000 0.822 2.006 1.000 1.984 1.299)
			    (float-vector 1.000 0.343 1.372 1.000 0.937 0.939 1.000 1.280 0.506)
			    (float-vector 1.000 0.189 1.196 1.000 0.537 0.925 1.000 0.804 0.542 1.000 0.948 0.272)
			    (float-vector 1.000 0.119 1.121 1.000 0.347 0.940 1.000 0.540 0.646 1.000 0.680 0.352 1.000 0.754 0.170)))
	    (zeros    (list (float-vector 0.000 0.000 1.000)
			    (float-vector 0.000 0.000 0.250 0.000 0.000 1.000)
			    (float-vector 0.000 0.000 0.062 0.000 0.000 1.000 0.000 0.000 1.000)
			    (float-vector 0.000 0.000 0.016 0.000 0.000 1.000 0.000 0.000 1.000 0.000 0.000 1.000)
			    (float-vector 0.000 0.000 0.004 0.000 0.000 1.000 0.000 0.000 1.000 0.000 0.000 1.000 0.000 0.000 1.000)))
	    (poles-1  (list (float-vector 1.000 2.372 3.314)
			    (float-vector 1.000 0.528 1.330 1.000 1.275 0.623)
			    (float-vector 1.000 0.229 1.129 1.000 0.627 0.696 1.000 0.856 0.263)
			    (float-vector 1.000 0.128 1.069 1.000 0.364 0.799 1.000 0.545 0.416 1.000 0.643 0.146)
			    (float-vector 1.000 0.082 1.044 1.000 0.237 0.862 1.000 0.369 0.568 1.000 0.465 0.274 1.000 0.515 0.092)))
	    (poles-10 (list (float-vector 1.000 1.098 1.103)
			    (float-vector 1.000 0.279 0.987 1.000 0.674 0.279)
			    (float-vector 1.000 0.124 0.991 1.000 0.340 0.558 1.000 0.464 0.125)
			    (float-vector 1.000 0.070 0.994 1.000 0.199 0.724 1.000 0.298 0.341 1.000 0.352 0.070)
			    (float-vector 1.000 0.045 0.996 1.000 0.130 0.814 1.000 0.203 0.521 1.000 0.255 0.227 1.000 0.283 0.045))))
	(do ((i 2 (+ i 2))
	     (k 0 (+ k 1)))
	    ((>= i 12))
	  (let ((vals (chebyshev-prototype i .01)))
	    (if (not (vequal1 (cadr vals) (poles-01 k)))
		(snd-display #__line__ ";chebyshev prototype .01 poles ~A: ~A (~A)" i (cadr vals) (poles-01 k))))
	  (let ((vals (chebyshev-prototype i .1)))
	    (if (not (vequal1 (cadr vals) (poles-1 k)))
		(snd-display #__line__ ";chebyshev prototype .1 poles ~A: ~A (~A)" i (cadr vals) (poles-1 k))))
	  (let ((vals (chebyshev-prototype i)))
	    (if (not (vequal1 (cadr vals) (poles-10 k)))
		(snd-display #__line__ ";chebyshev prototype 1 poles ~A: ~A (~A)" i (cadr vals) (poles-10 k)))
	    (if (not (vequal (car vals) (zeros k)))
		(snd-display #__line__ ";chebyshev prototype .01 zeros ~A: ~A (~A)" i (car vals) (zeros k))))))
      
      (let* ((f1 (make-chebyshev-lowpass 8 .1))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";chebyshev lp 8 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (float-vector 0.508 0.512 0.468 0.001 0.000 0.000 0.000 0.000 0.000 0.000)))
		 (not (vequal1 (cadr vals) (float-vector 0.507 0.512 0.467 0.001 0.000 0.000 0.000 0.000 0.000 0.000)))
		 (not (vequal1 (cadr vals) (float-vector 0.508 0.513 0.469 0.001 0.000 0.000 0.000 0.000 0.000 0.000)))
                 (not (vequal1 (cadr vals) (float-vector 0.509 0.508 0.465 0.001 0.000 0.000 0.000 0.000 0.000 0.000))))
	    (snd-display #__line__ ";chebyshev lp 8 .1 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-lowpass 12 .25))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";chebyshev lp 12 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.509 0.500 0.508 0.508 0.507 0.413 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";chebyshev lp 12 .25 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-lowpass 10 .4))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";chebyshev lp 10 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.465 0.493 0.509 0.508 0.477 0.507 0.508 0.507 0.431 0.000)))
	    (snd-display #__line__ ";chebyshev lp 10 .4 spect: ~A" (cadr vals))))
      
      (do ((i 2 (+ i 2)))
	  ((= i 10))
	(do ((j .1 (+ j .1)))
	    ((>= j .45))
	  (let* ((f1 (make-chebyshev-lowpass i j))
		 (mx (filter-response-max f1)))
	    (if (> mx 1.0)
		(snd-display #__line__ ";cheby low max ~A ~A: ~A" i j mx)))))
      
      (let* ((f1 (make-chebyshev-lowpass 8 .1 .01))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .49) (snd-display #__line__ ";chebyshev lp 8 .1 .01 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.492 0.491 0.483 0.006 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";chebyshev lp 8 .1 .01 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-lowpass 12 .25 .1))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .49) (snd-display #__line__ ";chebyshev lp 12 .1 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.488 0.488 0.488 0.488 0.487 0.403 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";chebyshev lp 12 .25 .1 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-lowpass 10 .4 .001))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .49) (snd-display #__line__ ";chebyshev lp 10 .001 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.497 0.497 0.497 0.497 0.497 0.497 0.497 0.497 0.488 0.000)))
	    (snd-display #__line__ ";chebyshev lp 10 .4 .001 spect: ~A" (cadr vals))))
      
      (let* ((f1 (make-chebyshev-highpass 8 .1))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .55) (snd-display #__line__ ";chebyshev hp 8 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.000 0.341 0.551 0.509 0.466 0.501 0.509 0.505 0.481 0.461)))
	    (snd-display #__line__ ";chebyshev hp 8 .1 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-highpass 12 .25))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .55) (snd-display #__line__ ";chebyshev hp 12 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.000 0.000 0.000 0.000 0.299 0.554 0.509 0.509 0.500 0.509)))
	    (snd-display #__line__ ";chebyshev hp 12 .25 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-highpass 10 .4))
	     (vals (sweep->bins f1 10)))
	(if (and (not (vequal1 (cadr vals) (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.297 0.786 0.677)))
		 (not (vequal1 (cadr vals) (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.301 0.788 0.660)))
		 (not (vequal1 (cadr vals) (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.322 0.861 0.724)))
		 (not (vequal1 (cadr vals) (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.262 0.571 0.509))))
	    (snd-display #__line__ ";chebyshev hp 10 .4 spect: ~A" (cadr vals))))
      
      (let* ((f1 (make-chebyshev-highpass 8 .1 .01))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .49) (snd-display #__line__ ";chebyshev hp 8 .1 .01 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.000 0.498 0.498 0.492 0.491 0.492 0.492 0.492 0.491 0.491)))
	    (snd-display #__line__ ";chebyshev hp 8 .1 .01 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-highpass 12 .25 .1))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";chebyshev hp 12 .1 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.000 0.000 0.000 0.000 0.453 0.516 0.489 0.489 0.488 0.488)))
	    (snd-display #__line__ ";chebyshev hp 12 .25 .1 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-highpass 10 .4 .001))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .5) (snd-display #__line__ ";chebyshev hp 10 .001 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 0.002 0.501 0.504 0.504)))
		 (not (vequal1 (cadr vals) (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 0.002 0.503 0.505 0.504)))
		 (not (vequal1 (cadr vals) (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 0.002 0.503 0.501 0.497))))
	    (snd-display #__line__ ";chebyshev hp 10 .4 .001 spect: ~A" (cadr vals))))
      
      (do ((i 2 (+ i 2)))
	  ((= i 10))
	(do ((j .1 (+ j .1)))
	    ((>= j .45))
	  (let* ((f1 (make-chebyshev-highpass i j))
		 (mx (filter-response-max f1)))
	    (if (> mx 1.0)
		(snd-display #__line__ ";cheby high max ~A ~A: ~A" i j mx)))))
      
      (let* ((f1 (make-chebyshev-bandpass 4 .1 .2))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";chebyshev bp 4 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.009 0.449 0.509 0.505 0.442 0.065 0.013 0.003 0.000 0.000)))
	    (snd-display #__line__ ";chebyshev bp 4 .1 .2 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-bandpass 6 .1 .2))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";chebyshev bp 6 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.001 0.376 0.505 0.498 0.412 0.011 0.001 0.000 0.000 0.000)))
	    (snd-display #__line__ ";chebyshev bp 6 .1 .2 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-bandpass 8 .3 .4))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";chebyshev bp 8 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.000 0.000 0.000 0.000 0.002 0.363 0.517 0.513 0.433 0.000)))
	    (snd-display #__line__ ";chebyshev bp 8 .3 .4 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-bandpass 8 .2 .2 .01))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";chebyshev bp 10 .2 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.000 0.000 0.015 0.483 0.482 0.021 0.001 0.000 0.000 0.000)))
	    (snd-display #__line__ ";chebyshev bp 10 .2 spect: ~A" (cadr vals))))
      
      (let* ((f1 (make-chebyshev-bandstop 4 .1 .4))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";chebyshev bs 4 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.509 0.505 0.447 0.033 0.006 0.006 0.033 0.445 0.512 0.509)))
	    (snd-display #__line__ ";chebyshev bs 4 .1 .4 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-bandstop 8 .1 .4))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .51)) .05) (snd-display #__line__ ";chebyshev bs 8 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (float-vector 0.508 0.512 0.468 0.001 0.000 0.000 0.001 0.345 0.551 0.507)))
		 (not (vequal1 (cadr vals) (float-vector 0.507 0.512 0.467 0.001 0.000 0.000 0.001 0.344 0.549 0.508)))
		 (not (vequal1 (cadr vals) (float-vector 0.508 0.513 0.469 0.001 0.000 0.000 0.001 0.345 0.552 0.508)))
		 (not (vequal1 (cadr vals) (float-vector 0.509 0.508 0.465 0.001 0.000 0.000 0.001 0.343 0.548 0.508))))
	    (snd-display #__line__ ";chebyshev bs 8 .1 .4 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-bandstop 8 .1 .4 .01))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";chebyshev bs 8 .01 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.492 0.491 0.483 0.006 0.000 0.000 0.006 0.494 0.495 0.492)))
	    (snd-display #__line__ ";chebyshev bs 8 .1 .4 .01 spect: ~A" (cadr vals))))
      
      
      ;; ---------------- inverse-chebyshev ----------------
      
      (let* ((f1 (make-inverse-chebyshev-lowpass 8 .1))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";inverse-chebyshev lp 8 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (float-vector 0.501 0.496 0.001 0.000 0.001 0.000 0.000 0.000 0.000 0.001)))
		 (not (vequal1 (cadr vals) (float-vector 0.500 0.498 0.001 0.000 0.001 0.000 0.000 0.000 0.000 0.001))))
	    (snd-display #__line__ ";inverse-chebyshev lp 8 .1 spect: ~A" (cadr vals))))
      (let* ((f1 (make-inverse-chebyshev-lowpass 12 .25))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";inverse-chebyshev lp 12 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.500 0.500 0.500 0.500 0.496 0.001 0.001 0.001 0.001 0.001)))
	    (snd-display #__line__ ";inverse-chebyshev lp 12 .25 spect: ~A" (cadr vals))))
      (let* ((f1 (make-inverse-chebyshev-lowpass 10 .4))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";inverse-chebyshev lp 10 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (float-vector 0.500 0.500 0.500 0.500 0.500 0.500 0.500 0.497 0.001 0.001)))
		 (not (vequal1 (cadr vals) (float-vector 0.500 0.500 0.500 0.500 0.500 0.500 0.500 0.497 0.002 0.002))))
	    (snd-display #__line__ ";inverse-chebyshev lp 10 .4 spect: ~A" (cadr vals))))
      (let* ((f1 (make-inverse-chebyshev-lowpass 10 .4 120))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";inverse-chebyshev lp 10 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.501 0.501 0.501 0.501 0.501 0.500 0.345 0.007 0.000 0.000)))
	    (snd-display #__line__ ";inverse-chebyshev lp 10 .4 120 spect: ~A" (cadr vals))))
      
      (do ((i 2 (+ i 2)))
	  ((= i 10))
	(do ((j .1 (+ j .1)))
	    ((>= j .45))
	  (let* ((f1 (make-inverse-chebyshev-lowpass i j))
		 (mx (filter-response-max f1)))
	    (if (> mx 1.0)
		(snd-display #__line__ ";inv cheby low max ~A ~A: ~A" i j mx)))))
      
      (let* ((f1 (make-inverse-chebyshev-highpass 8 .1))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";inverse-chebyshev hp 8 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.001 0.001 0.440 0.505 0.505 0.503 0.502 0.501 0.501 0.501)))
	    (snd-display #__line__ ";inverse-chebyshev hp 8 .1 spect: ~A" (cadr vals))))
      (let* ((f1 (make-inverse-chebyshev-highpass 12 .25))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";inverse-chebyshev hp 12 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.001 0.001 0.001 0.001 0.001 0.505 0.506 0.503 0.501 0.501)))
	    (snd-display #__line__ ";inverse-chebyshev hp 12 .25 spect: ~A" (cadr vals))))
      (let* ((f1 (make-inverse-chebyshev-highpass 10 .4))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";inverse-chebyshev hp 10 .4 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (float-vector 0.000 0.000 0.000 0.001 0.001 0.001 0.001 0.001 0.503 0.503)))
		 (not (vequal1 (cadr vals) (float-vector 0.000 0.000 0.000 0.001 0.001 0.001 0.001 0.001 0.505 0.503)))
		 (not (vequal1 (cadr vals) (float-vector 0.000 0.000 0.000 0.001 0.001 0.001 0.001 0.001 0.509 0.504))))
	    (snd-display #__line__ ";inverse-chebyshev hp 10 .4 spect: ~A" (cadr vals))))
      (let* ((f1 (make-inverse-chebyshev-highpass 10 .1 120))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";inverse-chebyshev hp 10 .1 120 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.000 0.000 0.007 0.328 0.502 0.502 0.502 0.501 0.501 0.501)))
	    (snd-display #__line__ ";inverse-chebyshev hp 10 .1 120 spect: ~A" (cadr vals))))
      
      (do ((i 2 (+ i 2)))
	  ((= i 10))
	(do ((j .1 (+ j .1)))
	    ((>= j .45))
	  (let* ((f1 (make-inverse-chebyshev-highpass i j))
		 (mx (filter-response-max f1)))
	    (if (> mx 1.0)
		(snd-display #__line__ ";inv cheby high max ~A ~A: ~A" i j mx)))))
      
      (let* ((f1 (make-inverse-chebyshev-bandpass 10 .1 .2))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";inverse-chebyshev bp 4 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.001 0.001 0.498 0.485 0.001 0.001 0.000 0.001 0.000 0.001)))
	    (snd-display #__line__ ";inverse-chebyshev bp 10 .1 .2 spect: ~A" (cadr vals))))
      (let* ((f1 (make-inverse-chebyshev-bandpass 10 .1 .2 30))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";inverse-chebyshev bp 6 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (float-vector 0.026 0.025 0.509 0.505 0.020 0.016 0.012 0.016 0.011 0.016)))
		 (not (vequal1 (cadr vals) (float-vector 0.030 0.042 0.511 0.505 0.020 0.016 0.012 0.016 0.011 0.016)))
		 (not (vequal1 (cadr vals) (float-vector 0.022 0.017 0.511 0.505 0.020 0.016 0.012 0.016 0.011 0.016))))
	    (snd-display #__line__ ";inverse-chebyshev bp 10 .1 .2 30 spect: ~A" (cadr vals))))
      (let* ((f1 (make-inverse-chebyshev-bandpass 8 .1 .4))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";inverse-chebyshev bp 8 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.001 0.001 0.440 0.506 0.505 0.503 0.502 0.434 0.001 0.001)))
	    (snd-display #__line__ ";inverse-chebyshev bp 8 .1 .4 spect: ~A" (cadr vals))))
      (let* ((f1 (make-inverse-chebyshev-bandpass 8 .3 .4 40))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";inverse-chebyshev bp 10 .2 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.002 0.005 0.007 0.007 0.005 0.005 0.503 0.505 0.006 0.005)))
	    (snd-display #__line__ ";inverse-chebyshev bp 10 .2 spect: ~A" (cadr vals))))
      
      (let* ((f1 (make-inverse-chebyshev-bandstop 4 .1 .4))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";inverse-chebyshev bs 4 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (float-vector 0.500 0.054 0.001 0.001 0.000 0.000 0.000 0.001 0.055 0.503)))
	    (snd-display #__line__ ";inverse-chebyshev bs 4 .1 .4 spect: ~A" (cadr vals))))
      (let* ((f1 (make-inverse-chebyshev-bandstop 8 .1 .4))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";inverse-chebyshev bs 8 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (float-vector 0.501 0.496 0.001 0.001 0.000 0.000 0.000 0.001 0.507 0.506)))
		 (not (vequal1 (cadr vals) (float-vector 0.506 0.328 0.000 0.000 0.000 0.000 0.000 0.000 0.268 0.511)))
		 (not (vequal1 (cadr vals) (float-vector 0.500 0.498 0.001 0.001 0.000 0.000 0.000 0.001 0.507 0.506))))
	    (snd-display #__line__ ";inverse-chebyshev bs 8 .1 .4 spect: ~A" (cadr vals))))
      (let* ((f1 (make-inverse-chebyshev-bandstop 8 .1 .4 90))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";inverse-chebyshev bs 8 90 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (float-vector 0.505 0.325 0.000 0.000 0.000 0.000 0.000 0.000 0.270 0.506)))
		 (not (vequal1 (cadr vals) (float-vector 0.506 0.328 0.000 0.000 0.000 0.000 0.000 0.000 0.269 0.509)))
		 (not (vequal1 (cadr vals) (float-vector 0.501 0.327 0.000 0.000 0.000 0.000 0.000 0.000 0.268 0.506))))
	    (snd-display #__line__ ";inverse-chebyshev bs 8 .1 .4 90 spect: ~A" (cadr vals))))
      
      
      ;; ---------------- bessel ----------------
      
      ;; checked poly coeff tables, but the prototype has scaling built in
      
      (if (provided? 'gsl)
	  (begin
	    (let* ((f1 (make-bessel-lowpass 4 .1))
		   (vals (sweep->bins f1 10)))
	      (if (fneq (car vals) .5) (snd-display #__line__ ";bessel lp 4 .1 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (float-vector 0.500 0.417 0.209 0.062 0.018 0.005 0.001 0.000 0.000 0.000)))
		  (snd-display #__line__ ";bessel lp 4 .1 spect: ~A" (cadr vals))))
	    
	    (let* ((f1 (make-bessel-lowpass 8 .1))
		   (vals (sweep->bins f1 10)))
	      (if (fneq (car vals) .5) (snd-display #__line__ ";bessel lp 8 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (float-vector 0.499 0.365 0.116 0.010 0.001 0.000 0.000 0.000 0.000 0.000)))
		  (snd-display #__line__ ";bessel lp 8 .1 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-bessel-lowpass 12 .25))
		   (vals (sweep->bins f1 10)))
	      (if (fneq (car vals) .5) (snd-display #__line__ ";bessel lp 12 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (float-vector 0.500 0.477 0.410 0.309 0.185 0.063 0.006 0.000 0.000 0.000)))
		  (snd-display #__line__ ";bessel lp 12 .25 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-bessel-lowpass 10 .4))
		   (vals (sweep->bins f1 10)))
	      (if (fneq (car vals) .5) (snd-display #__line__ ";bessel lp 10 max: ~A" (car vals)))
	      (if (and (not (vequal1 (cadr vals) (float-vector 0.500 0.498 0.491 0.479 0.458 0.423 0.364 0.259 0.086 0.001)))
		       (not (vequal1 (cadr vals) (float-vector 0.500 0.498 0.491 0.479 0.458 0.423 0.364 0.259 0.086 0.002))))
		  (snd-display #__line__ ";bessel lp 10 .4 spect: ~A" (cadr vals))))
	    
	    (do ((i 2 (+ i 2)))
		((= i 12))
	      (do ((j .1 (+ j .1)))
		  ((>= j .45))
		(let* ((f1 (make-bessel-lowpass i j))
		       (mx (filter-response-max f1)))
		  (if (> mx 1.0)
		      (snd-display #__line__ ";bess low max ~A ~A: ~A" i j mx)))))
	    
	    (let* ((f1 (make-bessel-highpass 8 .1))
		   (vals (sweep->bins f1 10)))
	      (if (fneq (car vals) .5) (snd-display #__line__ ";bessel hp 8 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (float-vector 0.001 0.115 0.290 0.386 0.435 0.465 0.483 0.493 0.498 0.500)))
		  (snd-display #__line__ ";bessel hp 8 .1 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-bessel-highpass 12 .25))
		   (vals (sweep->bins f1 10)))
	      (if (fneq (car vals) .5) (snd-display #__line__ ";bessel hp 12 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (float-vector 0.000 0.000 0.000 0.006 0.063 0.181 0.309 0.410 0.477 0.500)))
		  (snd-display #__line__ ";bessel hp 12 .25 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-bessel-highpass 10 .4))
		   (vals (sweep->bins f1 10)))
	      (if (ffneq (car vals) .5) (snd-display #__line__ ";bessel hp 10 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 0.004 0.084 0.343 0.499)))
		  (snd-display #__line__ ";bessel hp 10 .4 spect: ~A" (cadr vals))))
	    
	    (let* ((f1 (make-bessel-bandpass 4 .1 .2))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .245)) .05) (snd-display #__line__ ";bessel bp 4 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (float-vector 0.023 0.176 0.245 0.244 0.179 0.085 0.031 0.008 0.001 0.000)))
		  (snd-display #__line__ ";bessel bp 4 .1 .2 spect: ~A" (cadr vals))))
	    
	    (let* ((f1 (make-bessel-bandstop 12 .1 .2))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";bessel bs 12 max: ~A" (car vals)))
	      (if (and (not (vequal1 (cadr vals) (float-vector 0.498 0.325 0.065 0.066 0.177 0.297 0.389 0.452 0.488 0.500)))
		       (not (vequal1 (cadr vals) (float-vector 0.499 0.324 0.065 0.066 0.177 0.297 0.389 0.452 0.488 0.500))))
		  (snd-display #__line__ ";bessel bs 12 .1 .2 spect: ~A" (cadr vals))))
	    
	    ;; ---------------- elliptic ----------------
	    
	    (let* ((f1 (make-elliptic-lowpass 8 .1))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic lp 8 max: ~A" (car vals)))
	      (if (and (not (vequal1 (cadr vals) (float-vector 0.500 0.515 0.379 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
		       (not (vequal1 (cadr vals) (float-vector 0.500 0.509 0.385 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
		       (not (vequal1 (cadr vals) (float-vector 0.499 0.498 0.373 0.000 0.000 0.000 0.000 0.000 0.000 0.000))))
		  (snd-display #__line__ ";elliptic lp 8 .1 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-lowpass 12 .25))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic lp 12 max: ~A" (car vals)))
	      (if (and (not (vequal1 (cadr vals) (float-vector 0.476 0.500 0.491 0.499 0.494 0.412 0.003 0.001 0.000 0.000)))
		       (not (vequal1 (cadr vals) (float-vector 0.476 0.500 0.491 0.499 0.494 0.561 0.004 0.000 0.000 0.000)))
		       (not (vequal1 (cadr vals) (float-vector 0.476 0.500 0.491 0.499 0.493 0.299 0.006 0.001 0.000 0.000))))
		  (snd-display #__line__ ";elliptic lp 12 .25 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-lowpass 4 .4))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic lp 4 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (float-vector 0.447 0.453 0.462 0.477 0.494 0.500 0.497 0.496 0.445 0.003)))
		  (snd-display #__line__ ";elliptic lp 4 .4 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-lowpass 8 .1 .1))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic lp 8 .1 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (float-vector 0.500 0.499 0.475 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
		  (snd-display #__line__ ";elliptic lp 8 .1 .1 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-lowpass 8 .1 .1 90))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic lp 8 .1 90 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (float-vector 0.500 0.499 0.475 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
		  (snd-display #__line__ ";elliptic lp 8 .1 .1 90 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-lowpass 8 .25 .01 90))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic lp 8 .25 90 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (float-vector 0.500 0.500 0.500 0.500 0.499 0.495 0.001 0.000 0.000 0.000)))
		  (snd-display #__line__ ";elliptic lp 8 .25 .1 90 spect: ~A" (cadr vals))))
	    
	    (let* ((f1 (make-elliptic-highpass 4 .1))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic hp 4 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (float-vector 0.004 0.438 0.516 0.499 0.502 0.495 0.478 0.463 0.453 0.447)))
		  (snd-display #__line__ ";elliptic hp 4 .1 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-highpass 12 .25))
		   (vals (sweep->bins f1 10)))
					;(if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic hp 12 max: ~A" (car vals)))
	      (if (and (not (vequal1 (cadr vals) (float-vector 0.000 0.001 0.001 0.001 0.026 0.934 0.518 0.495 0.503 0.477)))
		       (not (vequal1 (cadr vals) (float-vector 0.000 0.001 0.001 0.001 0.033 1.185 0.519 0.495 0.503 0.477)))
		       (not (vequal1 (cadr vals) (float-vector 0.000 0.001 0.001 0.001 0.018 0.788 0.520 0.495 0.503 0.477))))
		  (snd-display #__line__ ";elliptic hp 12 .25 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-highpass 12 .25 .01 90))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic hp 12 90 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (float-vector 0.000 0.000 0.000 0.000 0.499 0.517 0.503 0.501 0.500 0.500)))
		  (snd-display #__line__ ";elliptic hp 12 .25 90 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-highpass 4 .4))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic hp 4 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (float-vector 0.000 0.000 0.000 0.001 0.001 0.002 0.023 0.447 0.515 0.502)))
		  (snd-display #__line__ ";elliptic hp 4 .4 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-highpass 8 .1 .1))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic hp 8 .1 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (float-vector 0.000 0.478 0.553 0.506 0.499 0.501 0.501 0.499 0.497 0.495)))
		  (snd-display #__line__ ";elliptic hp 8 .1 .1 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-highpass 8 .1 .1 90))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic hp 8 .1 90 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (float-vector 0.000 0.478 0.554 0.506 0.499 0.501 0.501 0.499 0.497 0.495)))
		  (snd-display #__line__ ";elliptic hp 8 .1 .1 90 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-highpass 8 .25 .01 90))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic hp 8 .25 90 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (float-vector 0.000 0.000 0.000 0.001 0.516 0.517 0.507 0.503 0.501 0.500)))
		  (snd-display #__line__ ";elliptic hp 8 .25 .1 90 spect: ~A" (cadr vals))))
	    
	    (let* ((f1 (make-elliptic-bandpass 4 .1 .2 .1))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic bp 4 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (float-vector 0.036 0.546 0.550 0.510 0.501 0.032 0.024 0.009 0.021 0.024)))
		  (snd-display #__line__ ";elliptic bp 4 .1 .2 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-bandpass 6 .1 .2 .1 90))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic bp 6 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (float-vector 0.002 0.511 0.532 0.503 0.492 0.003 0.001 0.001 0.001 0.001)))
		  (snd-display #__line__ ";elliptic bp 6 .1 .2 90 spect: ~A" (cadr vals))))
	    
	    (let* ((f1 (make-elliptic-bandstop 4 .1 .3 .1))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic bs 4 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (float-vector 0.499 0.502 0.498 0.037 0.050 0.540 0.544 0.527 0.526 0.521)))
		  (snd-display #__line__ ";elliptic bs 4 .1 .2 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-bandstop 8 .1 .3 .1 120))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic bs 8 max: ~A" (car vals)))
	      (if (and (not (vequal1 (cadr vals) (float-vector 0.500 0.499 0.476 0.000 0.000 0.495 0.526 0.505 0.501 0.501)))
		       (not (vequal1 (cadr vals) (float-vector 0.500 0.499 0.475 0.000 0.000 0.495 0.526 0.505 0.501 0.501))))
		  (snd-display #__line__ ";elliptic bs 8 .1 .2 spect: ~A" (cadr vals))))
	    ))))
  
  (define (test-polyoid n)
    (let* ((res (with-sound (:channels 2 :clipped #f)
		  (let ((freqs (make-float-vector n))
			(phases (make-float-vector n))           ; for oscil-bank
			(cur-phases (make-float-vector (* 3 n))) ; for polyoid
			(amp (/ 1.0 n)))
		    (do ((i 0 (+ i 1))
			 (j 0 (+ j 3)))
			((= i n))
		      (set! (cur-phases j) (+ i 1))
		      (set! (cur-phases (+ j 1)) (/ 1.0 n))
		      (set! (cur-phases (+ j 2)) (random (* 2 pi)))

		      (set! (freqs i) (hz->radians (+ i 1.0)))
		      (set! (phases i) (cur-phases (+ j 2))))

		    (let ((gen (make-polyoid 1.0 cur-phases))
			  (obank (make-oscil-bank freqs phases (make-float-vector n 1.0) #t)))
		      (do ((i 0 (+ i 1)))
			  ((= i 88200))
			(outa i (* amp (oscil-bank obank))))
		      (do ((i 0 (+ i 1)))
			  ((= i 88200))
			(outb i (polyoid gen 0.0)))))))
	   (snd (find-sound res)))
      (channel-distance snd 0 snd 1)))
  
  ;; ----------------
  (define (poly-roots-tests)
    (letrec ((ceql (lambda (a b)
		     (if (null? a)
			 (null? b)
			 (and (not (null? b))
			      (not (or (fneq (real-part (car a)) (real-part (car b)))
				       (fneq (imag-part (car a)) (imag-part (car b)))))
			      (ceql (cdr a) (cdr b)))))))
      
      ;; degree=0
      (let ((val (poly-roots (float-vector 0.0))))
	(if (pair? val) (snd-display #__line__ ";poly-roots 0.0: ~A" val)))
      (let ((val (poly-roots (float-vector 12.3))))
	(if (pair? val) (snd-display #__line__ ";poly-roots 12.3: ~A" val)))
      
      ;; degree 0 + x=0
      (let ((val (poly-roots (float-vector 0.0 1.0))))
	(if (not (ceql val (list 0.0))) (snd-display #__line__ ";poly-roots 0.0 1.0: ~A" val)))
      (let ((val (poly-roots (float-vector 0.0 0.0 0.0 121.0))))
	(if (not (ceql val (list 0.0 0.0 0.0))) (snd-display #__line__ ";poly-roots 0.0 0.0 0.0 121.0: ~A" val)))
      
      ;; degree=1
      (let ((val (poly-roots (float-vector -1.0 1.0))))
	(if (not (ceql val (list 1.0))) (snd-display #__line__ ";poly-roots -1.0 1.0: ~A" val)))
      (let ((val (poly-roots (float-vector -2.0 4.0))))
	(if (not (ceql val (list 0.5))) (snd-display #__line__ ";poly-roots -2.0 4.0: ~A" val)))
      (let ((val (poly-as-vector-roots (vector 0.0-i 1))))
	(if (not (ceql val (list -0.0+1.0i))) (snd-display #__line__ ";poly-roots: -i 1: ~A" val)))
      
      ;; linear x^n
      (let ((val (poly-roots (float-vector -1.0 0.0 0.0 0.0 1.0))))
	(if (and (not (ceql val (list 0.0-1.0i -1.0 0.0+1.0i 1.0)))
		 (not (ceql val (list 1.0 -1.0 0.0+1.0i -0.0-1.0i))))
	    (snd-display #__line__ ";poly-roots -1.0 0.0 0.0 0.0 1.0: ~A" val)))
      (let ((val (poly-roots (float-vector -16.0 0.0 0.0 0.0 1.0))))
	(if (and (not (ceql val (list 0.0-2.0i -2.0 0.0+2.0i 2.0)))
		 (not (ceql val (list 2.0 -2.0 0.0+2.0i -0.0-2.0i))))
	    (snd-display #__line__ ";poly-roots -16.0 0.0 0.0 0.0 1.0: ~A" val)))
      (let ((val (poly-roots (float-vector -32.0 0 0 0 0 0 0.5))))
	(if (not (ceql val (list 1.0-1.7320i -1.0-1.7320i -2.0 -1.0+1.7320i 1.0+1.7320i 2.0))) (snd-display #__line__ ";poly-roots 32 0 0 0 0 0 0.5: ~A" val)))
      
      ;; linear + x=0
      (let ((val (poly-roots (float-vector 0.0 -2.0 4.0))))
	(if (not (ceql val (list 0.0 0.5))) (snd-display #__line__ ";poly-roots 0.0 -2.0 4.0: ~A" val)))
      
      ;; degree=2
      (let ((val (poly-roots (float-vector -1.0 0.0 1.0))))
	(if (not (ceql val (list 1.0 -1.0))) (snd-display #__line__ ";poly-roots -1.0 0.0 1.0: ~A" val)))
      (let ((val (poly-roots (float-vector 15.0 -8.0 1.0))))
	(if (not (ceql val (list 5.0 3.0))) (snd-display #__line__ ";poly-roots 15.0 -8.0 1.0: ~A" val)))
      (let ((val (poly-roots (float-vector 1 -2 1))))
	(if (not (ceql val (list 1.0 1.0))) (snd-display #__line__ ";poly-roots 1 -2 1: ~A" val)))
      (let ((val (poly-as-vector-roots (vector -1 0.0+2i 1))))
	(if (not (ceql val (list 0.0-1.0i 0.0-1.0i))) (snd-display #__line__ ";poly-roots -1 2i 1: ~A" val)))
      (let ((val (poly-roots (float-vector 1 1 5))))
	(if (not (ceql val (list -0.1+0.43589i -0.1-0.43589i))) (snd-display #__line__ ";poly-roots 1 1 5: ~A" val)))
      
      ;; 2 + x=0
      (let ((val (poly-roots (float-vector 0.0 0.0 -1.0 0.0 1.0))))
	(if (not (ceql val (list 0.0 0.0 1.0 -1.0))) (snd-display #__line__ ";poly-roots 0.0 0.0 -1.0 0.0 1.0: ~A" val)))
      
      ;; quadratic in x^(n/2)
      (let ((vals (poly-roots (float-vector 1.0 0.0 -2.0 0.0 1.0))))
	(if (and (not (ceql vals (list -1.0 1.0 -1.0 1.0)))
		 (not (ceql vals (list 1.0 1.0 -1.0 -1.0))))
	    (snd-display #__line__ ";poly-roots 1 0 -2 0 1: ~A" vals)))
      (let ((vals (poly-roots (float-vector 64.0 0.0 0.0 -16.0 0.0 0.0 1.0))))
	(if (not (ceql vals (list -1.0-1.73205i -1.0+1.73205i 2.0 -1.0-1.73205i -1.0+1.73205i 2.0)))
	    (snd-display #__line__ ";poly-roots 64 0 0 -16 0 0 1: ~A" vals)))
      
      ;; degree=3
      (let ((val (poly-roots (float-vector -15.0 23.0 -9.0 1.0))))
	(if (not (ceql val (list 5.0 1.0 3.0))) (snd-display #__line__ ";poly-roots 5 1 3: ~A" val)))
      (let ((val (poly-roots (float-vector -126 -15 0 1))))
	(if (not (ceql val (list 6.0 -3.0+3.46410i -3.0-3.46410i))) (snd-display #__line__ ";poly-roots -126 -15 0 1: ~A" val)))
      
      (let ((val (poly-roots (float-vector -1 3 -3 1))))
	(if (not (ceql val (list 1.0 1.0 1.0))) (snd-display #__line__ ";poly-roots -1 3 -3 1: ~A" val))) 
      (let ((val (poly-roots (float-vector 1 -1 -1 1))))
	(if (and (not (ceql val (list 1.0 -1.0 1.0))) 
		 (not (ceql val (list -1.0 1.0 1.0))))
	    (snd-display #__line__ ";poly-roots 1 -1 1: ~A" val)))
      (let ((val (poly-roots (float-vector 2 -2 -2 2))))
	(if (and (not (ceql val (list 1.0 -1.0 1.0))) 
		 (not (ceql val (list -1.0 1.0 1.0))))
	    (snd-display #__line__ ";poly-roots 2 -2 -2 2: ~A" val)))
      
      ;; degree=4
					;      (let ((vals (poly-roots (float-vector -15 8 14 -8 1))))
					;	(if (not (ceql vals (list 5.0 3.0 1.0 -1.0))) (snd-display #__line__ ";poly-roots -15 8 14 -8 1: ~A" vals)))
					;      (let ((vals (poly-roots (poly-reduce (poly* (poly* (float-vector 2 1) (float-vector -3 1)) (poly* (float-vector 8 1) (float-vector -9 1)))))))
					;	(if (not (ceql vals (list 9.0 3.0 -2.0 -8.0))) (snd-display #__line__ ";poly-roots 4(1): ~A" vals)))
					;      (let ((vals (poly-roots (poly-reduce (poly* (poly* (float-vector .2 1) (float-vector -3 1)) (poly* (float-vector .8 1) (float-vector -9 1)))))))
					;	(if (not (ceql vals (list 9.0 3.0 -0.2 -0.8))) (snd-display #__line__ ";poly-roots 4(2): ~A" vals)))
					;      (let ((vals (poly-roots (poly-reduce (poly* (poly* (float-vector .02 1) (float-vector -32 1)) (poly* (float-vector .8 1) (float-vector -9 1)))))))
					;	(if (not (ceql vals (list 32.0 9.0 -0.02 -0.8))) (snd-display #__line__ ";poly-roots 4(3): ~A" vals)))
      
      ;; degree>4
					;      (let ((vals (poly-roots (poly-reduce (poly* (float-vector 1 1) (poly* (poly* (float-vector 2 1) (float-vector -3 1)) (poly* (float-vector -1 1) (float-vector -2 1))))))))
					;	(if (not (ceql vals (list 3.0 2.0 -1.0 -2.0 1.0))) 
					;	    (snd-display #__line__ ";poly-roots n(1): ~A from ~A ~A ~A" 
					;			 vals 
					;			 (poly-reduce (poly* (float-vector 1 1) (poly* (poly* (float-vector 2 1) (float-vector -3 1)) (poly* (float-vector -1 1) (float-vector -2 1)))))
					;			 *mus-float-equal-fudge-factor* 
					;			 poly-roots-epsilon)))
      
					;      (let ((vals (poly-roots (poly-reduce (poly* (float-vector 1 1) (poly* (poly* (float-vector 2 1) (float-vector -3 1)) (poly* (float-vector 8 1) (float-vector -9 1))))))))
					;	(if (not (ceql vals (list 9.0 3.0 -2.0 -8.0 -1.0))) (snd-display #__line__ ";poly-roots n(2): ~A" vals)))
					;      (let ((vals (poly-roots (poly-reduce (poly* (float-vector -1 0 1) (poly* (poly* (float-vector 9 1) (float-vector -3 1)) (poly* (float-vector -10 1) (float-vector -2 1))))))))
					;	(if (not (ceql vals (list 10.0 3.0 -1.0 -9.0 2.0 1.0))) (snd-display #__line__ ";poly-roots n(3): ~A" vals)))
					;      (let ((vals (poly-roots (poly-reduce (poly* (float-vector -1 0 1) (poly* (poly* (float-vector -4 0 1) (float-vector -3 1)) (poly* (float-vector -10 1) (float-vector -9 0 1))))))))
					;	(if (not (ceql vals (list 10.0 3.0 -2.0 -3.0 -1.0 3.0 2.0 1.0))) (snd-display #__line__ ";poly-roots n(4): ~A" vals)))
					;      (let ((vals (poly-roots (poly-reduce (poly* (float-vector -1 0 1) (poly* (poly* (float-vector -4 0 1) (float-vector -16 0 1)) (poly* (float-vector -25 0 1) (float-vector -9 0 1))))))))
					;	(if (not (ceql vals (list 5.0 -3.0 -4.0 -5.0 4.0 -2.0 3.0 -1.0 2.0 1.0))) (snd-display #__line__ ";poly-roots n(5): ~A" vals)))
					;      (let ((vals (poly-roots (poly-reduce (poly* (float-vector 1 1) (poly* (poly* (float-vector 2 1) (float-vector -3 1)) (poly* (float-vector 1 1) (float-vector -2 1))))))))
					;	(if (not (ceql vals (list 3.0 -1.0 -1.0 -2.0 2.0))) (snd-display #__line__ ";poly-roots n(6): ~A" vals)))
      (let ((vals (poly-roots (float-vector -64 0 0 0 0 0 1))))
	(if (not (ceql vals (list 0.999999999999999-1.73205080756888i -1.0-1.73205080756888i -2.0 -1.0+1.73205080756888i 1.0+1.73205080756888i 2.0)))
	    (snd-display #__line__ ";poly-roots 64 6: ~A" vals)))
      (let ((vals (poly-roots (float-vector 64 0 0 -16 0 0 1))))
	(if (not (ceql vals (list -1.0-1.73205080756888i -1.0+1.73205080756888i 2.0 -1.0-1.73205080756888i -1.0+1.73205080756888i 2.0)))
	    (snd-display #__line__ ";poly-roots 64 16 6: ~A" vals)))
      (do ((i 0 (+ i 1))) ((= i 10)) (poly-roots (float-vector (random 1.0) (random 1.0) (random 1.0))))
      (do ((i 0 (+ i 1))) ((= i 10)) (poly-roots (float-vector (mus-random 1.0) (mus-random 1.0) (mus-random 1.0))))
      
      (let ((vals1 (convolution (float-vector 1 2 3 0 0 0 0 0) (float-vector 1 2 3 0 0 0 0 0) 8))
	    (vals2 (poly* (float-vector 1 2 3 0) (float-vector 1 2 3 0))))
	(if (not (vequal vals1 vals2))
	    (snd-display #__line__ ";poly* convolve: ~A ~A" vals1 vals2)))
      
      
      (do ((i 0 (+ i 1))) ((= i 10)) 
	(poly-as-vector-roots (vector (complex (mus-random 1.0) (mus-random 1.0)) 
				      (complex (mus-random 1.0) (mus-random 1.0)))))
      (do ((i 0 (+ i 1))) ((= i 10)) 
	(poly-as-vector-roots (vector (complex (mus-random 1.0) (mus-random 1.0)) 
				      (complex (mus-random 1.0) (mus-random 1.0))
				      (complex (mus-random 1.0) (mus-random 1.0)))))
      
      (do ((i 0 (+ i 1))) ((= i 10)) 
	(poly-roots (float-vector (mus-random 1.0) (mus-random 1.0) (mus-random 1.0) (mus-random 1.0))))
      
      (do ((i 0 (+ i 1))) ((= i 10)) 
	(poly-as-vector-roots (vector (complex (mus-random 1.0) (mus-random 1.0)) 
				      (complex (mus-random 1.0) (mus-random 1.0))
				      (complex (mus-random 1.0) (mus-random 1.0))
				      (complex (mus-random 1.0) (mus-random 1.0)))))
      
					;      (do ((i 0 (+ i 1))) ((= i 10)) 
					;	(poly-roots (float-vector (mus-random 1.0) (mus-random 1.0) (mus-random 1.0) (mus-random 1.0) (mus-random 1.0))))
					;      
					;      (do ((i 0 (+ i 1))) ((= i 10)) 
					;	(poly-as-vector-roots (vector (complex (mus-random 1.0) (mus-random 1.0)) 
					;				      (complex (mus-random 1.0) (mus-random 1.0))
					;				      (complex (mus-random 1.0) (mus-random 1.0))
					;				      (complex (mus-random 1.0) (mus-random 1.0))
					;				      (complex (mus-random 1.0) (mus-random 1.0)))))
      
      (do ((i 3 (+ i 1))) ((= i 20)) 
	(let ((v (make-float-vector i 0.0)))
	  (set! (v 0) (mus-random 1.0))
	  (set! (v (- i 1)) 1.0)
	  (poly-roots v)))
      
      (do ((i 3 (+ i 2))) ((= i 21)) 
	(let ((v (make-float-vector i 0.0)))
	  (set! (v 0) (mus-random 1.0))
	  (set! (v (- i 1)) 1.0)
	  (set! (v (/ (- i 1) 2)) 1.0)
	  (poly-roots v)))
      
      (let ((vals (poly-roots (float-vector 1 -1 -1 1))))
	(if (and (not (ceql vals (list 1.0 -1.0 1.0))) 
		 (not (ceql vals (list -1.0 1.0 1.0))))
	    (snd-display #__line__ ";poly-roots 1-1-11: ~A" vals)))
      (let ((vals (poly-roots (float-vector 2 -1 -2 1))))
	(if (not (ceql vals (list 2.0 -1.0 1.0))) (snd-display #__line__ ";poly-roots 2-1-21: ~A" vals)))
      (let ((vals (poly-roots (float-vector -1 1 1 1))))
	(if (not (ceql vals (list 0.543689012692076 -0.771844506346038+1.11514250803994i -0.771844506346038-1.11514250803994i)))
	    (snd-display #__line__ ";poly-roots -1111: ~A" vals)))
      (let ((vals (poly-roots (float-vector -1 3 -3 1))))
	(if (not (ceql vals (list 1.0 1.0 1.0))) (snd-display #__line__ ";poly-roots -13-31: ~A" vals)))
					;      (let ((vals (poly-roots (float-vector 1 -4 6 -4 1))))
					;	(if (not (ceql vals (list 1.0 1.0 1.0 1.0))) (snd-display #__line__ ";poly-roots 1-46-41: ~A" vals)))
      (let ((vals (poly-roots (float-vector 0.5 0 0 1.0))))
	(if (and (not (ceql vals (list 0.396850262992049-0.687364818499302i -0.7937005259841 0.39685026299205+0.687364818499301i)))
		 (not (ceql vals (list 0.39685026299205+0.687364818499301i 0.39685026299205-0.687364818499301i -0.7937005259841)))
		 (not (ceql vals (list -7.9370052598409979172089E-1 3.968502629920498958E-1+6.873648184993013E-1i 3.96850262992049E-1-6.873648184993E-1i))))
	    (snd-display #__line__ ";poly-roots 0..5 3: ~A" vals)))
      (let ((vals (poly-roots (poly* (poly* (poly* (float-vector -1 1) (float-vector 1 1)) (poly* (float-vector -2 1) (float-vector 2 1))) (poly* (float-vector -3 1) (float-vector 3 1))))))
	(if (not (ceql vals (list -3.0 3.0 -1.0 1.0 -2.0 2.0)))
	    (snd-display #__line__ ";cube in 2: ~A" vals)))
      ))

  ;; -----------------
  (define (test-fm-components)
    (if (and (provided? 'gsl)
	     (not (provided? 'gmp)))
	(let ((str (with-output-to-string
		     (lambda ()
		       (fm-complex-component 1200 1000 100 1.0 4.0 0.0 #f)
		       (fm-cascade-component 2000 2000 500 1.5 50 1.0)))))
      (if (not (string=? str ";fm-complex-component add -0.000-0.010i from J-3(1.0) = -0.020 and I5(4.0) = 0.505
;fm-complex-component add 0.163 from J-2(1.0) = 0.115 and I4(4.0) = 1.416
;fm-complex-component add -0.000+1.469i from J-1(1.0) = -0.440 and I3(4.0) = 3.337
;fm-complex-component add -4.914 from J0(1.0) = 0.765 and I2(4.0) = 6.422
;fm-complex-component add 0.000+4.295i from J1(1.0) = 0.440 and I1(4.0) = 9.759
;fm-complex-component add 1.299 from J2(1.0) = 0.115 and I0(4.0) = 11.302
;fm-complex-component add 0.000-0.191i from J3(1.0) = 0.020 and I-1(4.0) = 9.759
;fm-complex-component add -0.016 from J4(1.0) = 0.002 and I-2(4.0) = 6.422
;fm-cascade-component add 0.512 from J0(1.5) = 0.512 and J0(1.0) = 1.000
"))
	  (snd-display #__line__ ";fm-components are unexpected:~%~S" str)))))
  
  ;; ----------------
  (define fltit
    (let ((documentation "(fltit) returns a time-varying filter: (map-channel (fltit))"))
      (lambda ()
	(let* ((coeffs (float-vector .1 .2 .3 .4 .4 .3 .2 .1))
	       (flt (make-fir-filter 8 coeffs))
	       (xcof (mus-xcoeffs flt)) ; maybe a copy?
	       (es (make-float-vector 8)))
	  (do ((i 0 (+ i 1)))
	      ((= i 8))
	    (set! (es i) 0.9994)) ; something like (+ 1.0 (/ (log 1e-5) (* 0.5 *clm-srate*)))
	  (set! (es 5) 1.00002)
	  (lambda (x)
	    (float-vector-multiply! xcof es)
	    (fir-filter flt x))))))
  
;;; (with-sound ("test.snd") (let ((p (make-pulse-train 1000))) (do ((i 0 (+ i 1))) ((= i 44100)) (outa i (* .5 (pulse-train p))))))
;;; (map-channel (fltit))

  
  ;; ----------------
  (define (freq-sweep dur)
    (let ((ph (make-one-pole 1.0 -1.0))
	  (fq (make-one-pole 1.0 -1.0))
	  (incr (/ pi (* dur 1.05 *clm-srate*)))
	  (len (framples)))
      (let ((data (make-float-vector len)))
	(do ((i 2 (+ i 1)))
	    ((= i len))
	  (set! (data i) (sin (one-pole ph (one-pole fq incr)))))
	(float-vector->channel (float-vector-scale! data 0.5)))))

  
  ;; ----------------
  (define* (make-ssb-am-1 freq (order 40))
    (if (even? order) (set! order (+ 1 order)))
    (make-sa1 :freq (abs freq)
	      :coscar (make-oscil freq (* .5 pi))
	      :sincar (make-oscil freq)
	      :dly (make-delay order)
	      :hlb (make-hilbert-transform order)))
  
  ;; ----------------
  (define* (ssb-am-1 gen y (fm-1 0.0))
    (let* ((fm fm-1)
	   (ccos (oscil (gen 'coscar) fm))
	   (csin (oscil (gen 'sincar) fm))
	   (yh (hilbert-transform (gen 'hlb) y))
	   (yd (delay (gen 'dly) y)))
      (if (> (gen 'freq) 0.0)
	  (- (* ccos yd) ; shift up
	     (* csin yh))
	  (+ (* ccos yd) ; shift down
	     (* csin yh)))))
  
  ;; ----------------

  (define (rough-spectrum ind)
    (let ((data (channel->float-vector 0 10000 ind 0))
	  (spect (make-float-vector 10))
	  (g (make-one-pole 1.0 -1.0)))
      (float-vector-multiply! data data)
      (do ((i 0 (+ i 1))
	   (beg 0 (+ beg 1000))
	   (end 999 (+ end 1000)))
	  ((= i 10))
	(mus-reset g)
	(do ((j beg (+ j 1)))
	    ((= j end))
	  (one-pole g (float-vector-ref data j)))
	(float-vector-set! spect i (one-pole g (float-vector-ref data end))))
      (float-vector-scale! spect (/ 1.0 (float-vector-peak spect)))))
  
  ;; ----------------
  (define* (print-and-check gen name desc (desc1 "") (desc2 ""))
    
    (if (not (string=? (mus-name gen) name))
	(snd-display #__line__ ";mus-name ~A: ~A?" name (mus-name gen)))
    (if (and (not (string=? (mus-describe gen) desc))
	     (not (string=? (mus-describe gen) desc1))
	     (not (string=? (mus-describe gen) desc2)))
	(snd-display #__line__ ";mus-describe ~A: ~A?" (mus-name gen) (mus-describe gen)))
    (let ((egen gen))
      (if (not (equal? egen gen))
	  (snd-display #__line__ ";equal? ~A: ~A?" gen egen))))
  
  ;; ----------------
  (define (test-gen-equal g0 g1 g2)
    ;; g0 = g1 at start != g2
    
    (let ((g3 g0))
      (if (not (eq? g0 g3))
	  (snd-display #__line__ ";let ~A not eq?~%    ~A~%    ~A" (mus-name g0) g0 g3))
      (if (eq? g0 g1)
	  (snd-display #__line__ ";arg ~A eq?~%    ~A~%    ~A" (mus-name g0) g0 g1))
      (if (not (equal? g0 g1))
	  (snd-display #__line__ ";~A not equal?~%    ~A~%    ~A" (mus-name g0) g0 g1))
      (if (equal? g0 g2)
	  (snd-display #__line__ ";~A equal?~%    ~A~%    ~A" (mus-name g0) g0 g2))
      (g0)
      (g3)
      (g3)
      (if (not (eq? g0 g3))
	  (snd-display #__line__ ";run let ~A not eq?~%    ~A~%    ~A" (mus-name g0) g0 g3))
      (if (eq? g0 g1)
	  (snd-display #__line__ ";arg ~A eq?~%    ~A~%    ~A" (mus-name g0) g0 g1))
      (if (equal? g0 g1)
	  (snd-display #__line__ ";run ~A equal?~%    ~A~%    ~A" (mus-name g0) g0 g1))
      (if (equal? g0 g2)
	  (snd-display #__line__ ";run ~A equal?~%    ~A~%    ~A" (mus-name g0) g0 g2))
      (let ((data (catch #t (lambda () (mus-data g0)) (lambda args #f))))
	(when (float-vector? data)
	  (let ((g4 (copy g0)))
	    (let ((data4 (catch #t (lambda () (mus-data g4)) (lambda args #f))))
	      (if (not (float-vector? data4)) 
		  (snd-display #__line__ ";~A copy -> mus-data ~A?" (mus-name g0) data4))))))))
  
  ;; ----------------
  (define (fm-test gen)
    (if (not (mus-generator? gen)) (snd-display #__line__ ";~A not a gen?" gen))
    (set! (mus-frequency gen) 0.0)
    (set! (mus-phase gen) 0.0)
    (gen 0.0)
    (if (fneq (mus-phase gen) 0.0) (snd-display #__line__ ";~A phase(0): ~A" gen (mus-phase gen)))
    (gen 1.0)
    (if (fneq (mus-phase gen) 1.0) (snd-display #__line__ ";~A phase(1): ~A" gen (mus-phase gen)))
    (gen 0.0)
    (if (fneq (mus-phase gen) 1.0) (snd-display #__line__ ";~A phase(1, 0): ~A" gen (mus-phase gen)))
    (set! (mus-frequency gen) (radians->hz 2.0))
    (if (fneq (mus-increment gen) 2.0) (snd-display #__line__ ";~A increment: ~A" gen (mus-increment gen)))
    (set! (mus-increment gen) 2.0)
    (if (fneq (mus-frequency gen) (radians->hz 2.0)) (snd-display #__line__ ";~A set increment: ~A ~A" gen (mus-increment gen) (hz->radians (mus-frequency gen))))
    (gen 0.0)
    (if (fneq (mus-phase gen) 3.0) (snd-display #__line__ ";~A phase(1, 2): ~A ~A" gen (mus-phase gen) (mus-frequency gen)))
    (gen 1.0)
    (if (fneq (mus-phase gen) 6.0) (snd-display #__line__ ";~A phase(3, 2, 1): ~A ~A" gen (mus-phase gen) (mus-frequency gen)))
    (do ((i 0 (+ i 1))) ((= i 10)) (gen 10.0))
    (if (fneq (mus-phase gen) (+ 26 (- 100 (* 2 pi 20)))) (snd-display #__line__ ";~A phase (over): ~A ~A" gen (mus-phase gen) (mus-frequency gen)))
    (set! (mus-frequency gen) 0.0)
    (set! (mus-phase gen) 0.0)
    (gen 1234567812345678)
    (gen -1234567812345678)
    (set! (mus-frequency gen) 0.0)
    (set! (mus-phase gen) 0.0)
    (gen -2.0)
    (if (and (fneq (mus-phase gen) -2.0)
	     (fneq (mus-phase gen) (- (* 2 pi) 2.0)))
	(snd-display #__line__ ";phase: ~A freq: ~A" (mus-phase gen) (mus-frequency gen))))
  
  ;; ----------------
  (define* (agc (ramp-speed .001) (window-size 512))
    (let ((maxer (make-moving-max window-size))
	  (mult 1.0))
      (map-channel
       (lambda (y)
	 (let* ((curmax (moving-max maxer y))
		(diff (- 0.5 (* mult curmax)))
		(this-incr (* diff ramp-speed)))
	   (set! mult (+ mult this-incr))
	   (* y mult))))))
  
  ;; ----------------
  (define (numerical-reality-checks)
    ;; a few reality checks from John Burkardt test_values.C
    
    (let ((vals (vector 1.6709637479564564156 1.5707963267948966192 1.4706289056333368229 1.3694384060045658278 1.2661036727794991113 
			1.1592794807274085998 1.0471975511965977462 0.92729521800161223243 0.79539883018414355549 0.64350110879328438680 
			0.45102681179626243254 0.00000000000000000000))
	  (args (vector -0.1 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0))
	  (max-bad 0.0))
      (do ((i 0 (+ i 1)))
	  ((= i 12))
	(let* ((nval (acos (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) (set! max-bad diff))))
      (if (> max-bad 1.0e-15)
	  (snd-display #__line__ ";acos: ~A" max-bad)))
    
    (let ((vals (vector 0.0000000000000000000 0.14130376948564857735 0.44356825438511518913 0.62236250371477866781 0.75643291085695958624 
			0.86701472649056510395 0.96242365011920689500 1.3169578969248167086 1.7627471740390860505 1.8115262724608531070 
			2.0634370688955605467 2.2924316695611776878 2.9932228461263808979 5.2982923656104845907 7.6009022095419886114))
	  (args (vector 1.0 1.01 1.1 1.2 1.3 1.4 1.5 2.0 3.0 3.1415926535897932385 4.0 5.0 10.0 100.0 1000.0))
	  (max-bad 0.0))
      (do ((i 0 (+ i 1)))
	  ((= i 15))
	(let* ((nval (acosh (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) (set! max-bad diff))))
      (if (> max-bad 1.0e-15)
	  (snd-display #__line__ ";acosh: ~A" max-bad)))
    
    (let ((vals (vector -0.10016742116155979635 0.00000000000000000000 0.10016742116155979635 0.20135792079033079146 0.30469265401539750797 
			0.41151684606748801938 0.52359877559829887308 0.64350110879328438680 0.77539749661075306374 0.92729521800161223243 
			1.1197695149986341867 1.5707963267948966192))
	  (args (vector -0.1 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0))
	  (max-bad 0.0))
      (do ((i 0 (+ i 1)))
	  ((= i 12))
	(let* ((nval (asin (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) (set! max-bad diff))))
      (if (> max-bad 1.0e-15)
	  (snd-display #__line__ ";asin: ~A" max-bad)))
    
    (let ((vals (vector -2.3124383412727526203 -0.88137358701954302523 0.00000000000000000000 0.099834078899207563327 0.19869011034924140647 
			0.29567304756342243910 0.39003531977071527608 0.48121182505960344750 0.56882489873224753010 0.65266656608235578681 
			0.73266825604541086415 0.80886693565278246251 0.88137358701954302523 1.4436354751788103425 1.8184464592320668235 
			2.0947125472611012942 2.3124383412727526203 2.9982229502979697388 5.2983423656105887574 7.6009027095419886115))
	  (args (vector -5.0 -1.0 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 2.0 3.0 4.0 5.0 10.0 100.0 1000.0))
	  (max-bad 0.0))
      (do ((i 0 (+ i 1)))
	  ((= i 20))
	(let* ((nval (asinh (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) (set! max-bad diff))
	  (if (> max-bad 1.0e-14)
	      (snd-display #__line__ ";asinh(~A): ~A ~A -> ~A" (vector-ref args i) nval (vector-ref vals i) max-bad)))))
    
    (let ((vals (vector 0.00000000000000000000 0.24497866312686415417 0.32175055439664219340 0.46364760900080611621 0.78539816339744830962 
			1.1071487177940905030 1.2490457723982544258 1.3258176636680324651 1.3734007669450158609 1.4711276743037345919 1.5208379310729538578))
	  (args (vector 0.00000000000000000000 0.25000000000000000000 0.33333333333333333333 0.50000000000000000000 1.0000000000000000000 
			2.0000000000000000000 3.0000000000000000000 4.0000000000000000000 5.0000000000000000000 10.000000000000000000 20.000000000000000000))
	  (max-bad 0.0))
      (do ((i 0 (+ i 1)))
	  ((= i 11))
	(let* ((nval (atan (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) (set! max-bad diff))))
      (if (> max-bad 1.0e-15)
	  (snd-display #__line__ ";atan: ~A" max-bad)))
    
    (let ((vals (vector -0.54930614433405484570 0.00000000000000000000 0.0010000003333335333335 0.10033534773107558064 0.20273255405408219099 
			0.30951960420311171547 0.42364893019360180686 0.54930614433405484570 0.69314718055994530942 0.86730052769405319443 
			1.0986122886681096914 1.4722194895832202300 2.6466524123622461977 3.8002011672502000318 7.2543286192620472067))
	  (args (vector -0.5 0.0 0.001 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.999999))
	  (max-bad 0.0))
      (do ((i 0 (+ i 1)))
	  ((= i 15))
	(let* ((nval (atanh (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) 
	      (set! max-bad diff))
	  (if (> diff 1.0e-10) ; one is > e-11
	      (snd-display #__line__ ";atanh(~A): ~A ~A -> ~A" (vector-ref args i) (vector-ref vals i) nval diff)))))
    
    (let ((vals (vector 0.1000000000000000E+01 0.1010025027795146E+01 0.1040401782229341E+01 0.1092045364317340E+01 0.1166514922869803E+01 
			0.1266065877752008E+01 0.1393725584134064E+01 0.1553395099731217E+01 0.1749980639738909E+01 0.1989559356618051E+01 
			0.2279585302336067E+01 0.3289839144050123E+01 0.4880792585865024E+01 0.7378203432225480E+01 0.1130192195213633E+02 
			0.1748117185560928E+02 0.2723987182360445E+02 0.6723440697647798E+02 0.4275641157218048E+03 0.2815716628466254E+04))
	  (args (vector 0.00E+00 0.20E+00 0.40E+00 0.60E+00 0.80E+00 0.10E+01 0.12E+01 0.14E+01 0.16E+01 0.18E+01 0.20E+01 0.25E+01 0.30E+01 
			0.35E+01 0.40E+01 0.45E+01 0.50E+01 0.60E+01 0.80E+01 
			0.10E+02))
	  (max-bad 0.0))
      (do ((i 0 (+ i 1)))
	  ((= i 20))
	(let* ((nval (bes-i0 (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) 
	      (set! max-bad diff))
	  (if (> diff 1.0e-4)
	      (snd-display #__line__ ";bes-i0(~A): ~A ~A -> ~A" (vector-ref args i) (vector-ref vals i) nval diff)))))
    
    (let ((vals (vector -0.1775967713143383E+00 -0.3971498098638474E+00 -0.2600519549019334E+00 0.2238907791412357E+00 0.7651976865579666E+00 
			0.1000000000000000E+01 0.7651976865579666E+00 0.2238907791412357E+00 -0.2600519549019334E+00 -0.3971498098638474E+00 
			-0.1775967713143383E+00 0.1506452572509969E+00 0.3000792705195556E+00 0.1716508071375539E+00 -0.9033361118287613E-01 
			-0.2459357644513483E+00 -0.1711903004071961E+00 0.4768931079683354E-01 0.2069261023770678E+00 0.1710734761104587E+00 -0.1422447282678077E-01))
	  (args (vector -5.0E+00 -4.0E+00 -3.0E+00 -2.0E+00 -1.0E+00 0.0E+00 1.0E+00 2.0E+00 3.0E+00 4.0E+00 5.0E+00 6.0E+00 7.0E+00 8.0E+00 
			9.0E+00 10.0E+00 11.0E+00 12.0E+00 13.0E+00 14.0E+00 15.0E+00))
	  (max-bad 0.0))
      (do ((i 0 (+ i 1)))
	  ((= i 21))
	(let* ((nval (bes-j0 (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) 
	      (set! max-bad diff))
	  (if (> diff 1.0e-15)
	      (snd-display #__line__ ";bes-j0(~A): ~A ~A -> ~A" (vector-ref args i) (vector-ref vals i) nval diff)))))
    
    (let ((vals (vector 0.3275791375914652E+00 0.6604332802354914E-01 -0.3390589585259365E+00 -0.5767248077568734E+00 -0.4400505857449335E+00 
			0.0000000000000000E+00 0.4400505857449335E+00 0.5767248077568734E+00 0.3390589585259365E+00 -0.6604332802354914E-01 
			-0.3275791375914652E+00 -0.2766838581275656E+00 -0.4682823482345833E-02 0.2346363468539146E+00 0.2453117865733253E+00 
			0.4347274616886144E-01 -0.1767852989567215E+00 -0.2234471044906276E+00 -0.7031805212177837E-01 0.1333751546987933E+00 0.2051040386135228E+00))
	  (args (vector -5.0E+00 -4.0E+00 -3.0E+00 -2.0E+00 -1.0E+00 0.0E+00 1.0E+00 2.0E+00 3.0E+00 4.0E+00 5.0E+00 6.0E+00 7.0E+00 8.0E+00 
			9.0E+00 10.0E+00 11.0E+00 12.0E+00 13.0E+00 14.0E+00 15.0E+00))
	  (max-bad 0.0))
      (do ((i 0 (+ i 1)))
	  ((= i 21))
	(let* ((nval (bes-j1 (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) 
	      (set! max-bad diff))
	  (if (> diff 1.0e-15)
	      (snd-display #__line__ ";bes-j1(~A): ~A ~A -> ~A" (vector-ref args i) (vector-ref vals i) nval diff)))))
    
    (let ((vals (vector 0.1149034849319005E+00 0.3528340286156377E+00 0.4656511627775222E-01 0.2546303136851206E+00 -0.5971280079425882E-01 
			0.2497577302112344E-03 0.7039629755871685E-02 0.2611405461201701E+00 -0.2340615281867936E+00 -0.8140024769656964E-01 
			0.2630615123687453E-09 0.2515386282716737E-06 0.1467802647310474E-02 0.2074861066333589E+00 -0.1138478491494694E+00 
			0.3873503008524658E-24 0.3918972805090754E-18 0.2770330052128942E-10 0.1151336924781340E-04 -0.1167043527595797E+00))
	  (ns (vector 2 2 2 2 2 5 5 5 5 5 10 10 10 10 10 20 20 20 20 20)) 
	  (args (vector 1.0E+00 2.0E+00 5.0E+00 10.0E+00 50.0E+00 1.0E+00 2.0E+00 5.0E+00 10.0E+00 50.0E+00 1.0E+00 2.0E+00 5.0E+00 10.0E+00 
			50.0E+00 1.0E+00 2.0E+00 5.0E+00 10.0E+00 50.0E+00))
	  (max-bad 0.0))
      (do ((i 0 (+ i 1)))
	  ((= i 20))
	(let* ((nval (bes-jn (vector-ref ns i) (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) 
	      (set! max-bad diff))
	  (if (> diff 1.0e-15)
	      (snd-display #__line__ ";bes-jn(~A ~A): ~A ~A -> ~A" (vector-ref ns i) (vector-ref args i) (vector-ref vals i) nval diff)))))
    
    (let ((vals (vector -0.1534238651350367E+01 0.8825696421567696E-01 0.5103756726497451E+00 0.3768500100127904E+00 -0.1694073932506499E-01 
			-0.3085176252490338E+00 -0.2881946839815792E+00 -0.2594974396720926E-01 0.2235214893875662E+00 0.2499366982850247E+00 
			0.5567116728359939E-01 -0.1688473238920795E+00 -0.2252373126343614E+00 -0.7820786452787591E-01 0.1271925685821837E+00 0.2054642960389183E+00))
	  (args (vector 0.1E+00 1.0E+00 2.0E+00 3.0E+00 4.0E+00 5.0E+00 6.0E+00 7.0E+00 8.0E+00 9.0E+00 10.0E+00 11.0E+00 12.0E+00 13.0E+00 14.0E+00 15.0E+00))
	  (max-bad 0.0))
      (do ((i 0 (+ i 1)))
	  ((= i 16))
	(let* ((nval (bes-y0 (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) 
	      (set! max-bad diff))
	  (if (> diff 1.0e-15)
	      (snd-display #__line__ ";bes-y0(~A): ~A ~A -> ~A" (vector-ref args i) (vector-ref vals i) nval diff)))))
    
    (let ((vals (vector -0.6458951094702027E+01 -0.7812128213002887E+00 -0.1070324315409375E+00 0.3246744247918000E+00 0.3979257105571000E+00 
			0.1478631433912268E+00 -0.1750103443003983E+00 -0.3026672370241849E+00 -0.1580604617312475E+00 0.1043145751967159E+00 
			0.2490154242069539E+00 0.1637055374149429E+00 -0.5709921826089652E-01 -0.2100814084206935E+00 -0.1666448418561723E+00 0.2107362803687351E-01))
	  (args (vector 0.1E+00 1.0E+00 2.0E+00 3.0E+00 4.0E+00 5.0E+00 6.0E+00 7.0E+00 8.0E+00 9.0E+00 10.0E+00 11.0E+00 12.0E+00 13.0E+00 14.0E+00 15.0E+00))
	  (max-bad 0.0))
      (do ((i 0 (+ i 1)))
	  ((= i 16))
	(let* ((nval (bes-y1 (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) 
	      (set! max-bad diff))
	  (if (> diff 1.0e-14)
	      (snd-display #__line__ ";bes-y1(~A): ~A ~A -> ~A" (vector-ref args i) (vector-ref vals i) nval diff)))))
    
    (let ((vals (vector -0.1650682606816254E+01 -0.6174081041906827E+00 0.3676628826055245E+00 -0.5868082442208615E-02 0.9579316872759649E-01 
			-0.2604058666258122E+03 -0.9935989128481975E+01 -0.4536948224911019E+00 0.1354030476893623E+00 -0.7854841391308165E-01 
			-0.1216180142786892E+09 -0.1291845422080393E+06 -0.2512911009561010E+02 -0.3598141521834027E+00 0.5723897182053514E-02 
			-40816513889983664.0 -0.5933965296914321E+09 -0.1597483848269626E+04 0.1644263394811578E-01))
	  
	  ;; yn(20, 2.0) prints -40816513889983664.0 but I guess due to float inaccuracies (bes-yn 20 2.0) is -40816513889983672.0?
	  
	  (ns (vector 2 2 2 2 2 5 5 5 5 5 10 10 10 10 10 20 20 20 20))
	  (args (vector 1.0E+00 2.0E+00 5.0E+00 10.0E+00 50.0E+00 1.0E+00 2.0E+00 5.0E+00 10.0E+00 50.0E+00 1.0E+00 2.0E+00 5.0E+00 10.0E+00 
			50.0E+00 2.0E+00 5.0E+00 10.0E+00 50.0E+00))
	  (max-bad 0.0))
      (do ((i 0 (+ i 1)))
	  ((= i 19))
	(let* ((nval (bes-yn (vector-ref ns i) (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) 
	      (set! max-bad diff))
	  (if (and (> diff 1.0e-6)
		   (not (= i 15))) ; see above
	      (snd-display #__line__ ";bes-yn(~A ~A): ~A ~A -> ~A" (vector-ref ns i) (vector-ref args i) (vector-ref vals i) nval diff)))))
    ;; one (20 1.0) is off by a lot but the val is 1e22 
    
    ;; numerics stuff
    (let ((ns (vector 1 6 6 6 15 15 15 15 15 15 15))
	  (ks (vector 0 1 3 5 1  3  5  7  9  11 13))
	  (vals (vector 1 6 20 6 15 455 3003 6435 5005 1365 105)))
      (do ((i 0 (+ i 1)))
	  ((= i 11))
	(let ((nval (binomial-direct (vector-ref ns i) (vector-ref ks i)))
	      (mval (n-choose-k (vector-ref ns i) (vector-ref ks i))))
	  (if (or (not (= nval (vector-ref vals i)))
		  (not (= mval (vector-ref vals i))))
	      (snd-display #__line__ ";binomial(~A ~A): ~A ~A ~A" (vector-ref ns i) (vector-ref ks i) nval mval (vector-ref vals i))))))
    
    (let ((ls (vector 1 1 1 1 1 2 2 2 3 3 3 3 4 5 6 7 8 9 10))
	  (ms (vector 0 0 0 0 1 0 1 2 0 1 2 3 2 2 3 3 4 4 5))
	  (vals (vector 0.000000 0.500000 0.707107 1.000000 -0.866025 -0.125000 -1.29904  2.25000 -0.437500 -0.324759 5.62500 -9.74278 
			4.21875 -4.92187  12.7874  116.685 -1050.67 -2078.49  30086.2))
	  (xs (vector 0.0 0.5 0.7071067 1.0  0.5 0.5 0.5 0.5  0.5 0.5 0.5 0.5  0.5 0.5 0.5 0.5  0.5 0.5 0.5)))
      (do ((i 0 (+ i 1)))
	  ((= i 19))
	(let ((val (plgndr (vector-ref ls i) (vector-ref ms i) (vector-ref xs i))))
	  (if (or (not (real? val))
		  (not (real? (vector-ref vals i)))
		  (> (abs (- val (vector-ref vals i))) 0.1))
	      (snd-display #__line__ ";plgndr(~A ~A ~A) = ~A (~A)" (vector-ref ls i) (vector-ref ms i) (vector-ref xs i) val (vector-ref vals i))))))
    
    (let ((vals (vector  1.0000000000  0.8000000000  0.2800000000  -0.3520000000 -0.8432000000 -0.9971200000 
			 -0.7521920000 -0.2063872000  0.4219724800  0.8815431680  0.9884965888  0.7000513741  0.1315856097))
	  (ns (vector  0  1  2   3  4  5   6  7  8   9 10 11 	   12))
	  (xs (vector    0.8  0.8  0.8     0.8  0.8  0.8     0.8  0.8  0.8     0.8  0.8  0.8     0.8)))
      
      (do ((i 0 (+ i 1)))
	  ((= i 13))
	(let ((val (chebyshev (vector-ref ns i) (vector-ref xs i))))
	  (if (fneq val (vector-ref vals i))
	      (snd-display #__line__ ";chebyshev ~A ~A -> ~A ~A" (vector-ref ns i) (vector-ref xs i) val (vector-ref vals i)))))
      
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(let* ((x (random 10.0))
	       (order (random 10))
	       (val1 (gegenbauer order x 1.0))
	       (val2 (chebyshev order x 2)))
	  (if (fneq val1 val2)
	      (snd-display #__line__ ";gegenbauer/chebyshev (alpha=1) ~A ~A: ~A ~A" order x val1 val2)))))
    
    (let ((as (vector      0.5  0.5  0.5      0.5  0.5  0.5      0.5  0.5  0.5      0.5  0.5  0.0      1.0  2.0  3.0 
			   4.0  5.0  6.0      7.0  8.0  9.0     10.0  3.0  3.0      3.0  3.0  3.0      3.0  3.0  3.0      3.0  3.0  3.0 
			   3.0  3.0  3.0      3.0  3.0))
	  (vals (vector    1.0000000000   0.2000000000  -0.4400000000    -0.2800000000   0.2320000000   0.3075200000 
			   -0.0805760000  -0.2935168000  -0.0395648000     0.2459712000   0.1290720256   0.696706 ; was 0 but explicit formula says 2/n cos(nx)
			   -0.3600000000  -0.0800000000   0.8400000000     2.4000000000   4.6000000000   7.4400000000    10.9200000000  15.0400000000  19.8000000000 
			   25.2000000000  9.0000000000  -0.1612800000 ; was -9 but that is wrong (see G&R explicit formula)
			   -6.6729600000  -8.3750400000  -5.5267200000     0.0000000000   5.5267200000   8.3750400000     6.6729600000   0.1612800000  -9.0000000000  
			   -15.4252800000  -9.6969600000  22.4409600000   100.8892800000 252.0000000000))
	  (ns (vector     0  1  2      3  4  5      6  7  8      9 10  2      2  2  2      2  2  2      2  2  2      2  5  5      5  5  5 
			  5  5  5      5  5  5      5  5  5      5  5))
	  (xs (vector    0.20  0.20  0.20     0.20  0.20  0.20     0.20  0.20  0.20     0.20  0.20  0.40     0.40  0.40  0.40 
			 0.40  0.40  0.40     0.40  0.40  0.40     0.40 -0.50 -0.40    -0.30 -0.20 -0.10     0.00  0.10  0.20 
			 0.30  0.40  0.50     0.60  0.70  0.80     0.90  1.00)))
      
      (define (g3 x alpha)
	(- (* 1/3 alpha x x x (+ (* 4 alpha alpha) (* 12 alpha) 8))
	   (* 2 alpha x (+ alpha 1))))
      
      (define (g5 x alpha)
	(+ (* 1/15 alpha x x x x x (+ (* 4 alpha alpha alpha alpha) 
				      (* 40 alpha alpha alpha)
				      (* 140 alpha alpha)
				      (* 200 alpha)
				      96))
	   (* -1/3 alpha x x x (+ (* 4 alpha alpha alpha)
				  (* 24 alpha alpha)
				  (* 44 alpha)
				  24))
	   (* alpha x (+ (* alpha alpha) (* 3 alpha) 2))))
      
      (do ((i 0 (+ i 1)))
	  ((= i 38))
	(let ((val (gegenbauer (vector-ref ns i) (vector-ref xs i) (vector-ref as i))))
	  (if (fneq val (vector-ref vals i))
	      (snd-display #__line__ ";gegenbauer ~A ~A ~A -> ~A ~A" (vector-ref ns i) (vector-ref xs i) (vector-ref as i) val (vector-ref vals i)))))
      
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(let* ((x (random 10.0))
	       (alpha (random 3.0))
	       (val1 (gegenbauer 3 x alpha))
	       (val2 (g3 x alpha)))
	  (if (fneq val1 val2)
	      (snd-display #__line__ ";gegenbauer 3 ~A ~A: ~A ~A" x alpha val1 val2))))
      
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(let* ((x (random 10.0))
	       (alpha (random 3.0))
	       (val1 (gegenbauer 5 x alpha))
	       (val2 (g5 x alpha)))
	  (if (fneq val1 val2)
	      (snd-display #__line__ ";gegenbauer 5 ~A ~A: ~A ~A" x alpha val1 val2))))
      )
    
    (let ((vals (vector     1.0000000000  0.0000000000 -0.5000000000     -0.6666666667 -0.6250000000 -0.4666666667 
			    -0.2569444444 -0.0404761905  0.1539930556      0.3097442681  0.4189459325  0.4801341791 
			    0.4962122235 -0.4455729167  0.8500000000     -3.1666666667 34.3333333333))
	  (ns (vector     0  1  2      3  4  5      6  7  8      9 10 11     12  5  5      5  5))
	  (xs (vector    1.0  1.0  1.0     1.0  1.0  1.0     1.0  1.0  1.0     1.0  1.0  1.0     1.0  0.5  3.0     5.0 10.0)))
      (do ((i 0 (+ i 1)))
	  ((= i 17))
	(let ((val (laguerre (vector-ref ns i) (vector-ref xs i))))
	  (if (fneq val (vector-ref vals i))
	      (snd-display #__line__ ";laguerre ~A ~A -> ~A ~A" (vector-ref ns i) (vector-ref xs i) val (vector-ref vals i)))))
      )
    
    (let ((vals (vector     1.0            10.0           98.0      940.0          8812.0         80600.0 
			    717880.0       6211600.0      52065680.0 ; was off by factor of 10?
			    421271200      3275529760.0   24329873600.0      171237081280.0 41.0          -8.0      3816.0         3041200.0))
	  (ns (vector     0  1  2      3  4  5      6  7  8      9 10 11     12  5  5      5  5))
	  (xs (vector    5.0  5.0  5.0     5.0  5.0  5.0     5.0  5.0  5.0     5.0  5.0  5.0     5.0  0.5  1.0     3.0 10.0)))
      (do ((i 0 (+ i 1)))
	  ((= i 13))
	(let ((val (hermite (vector-ref ns i) (vector-ref xs i))))
	  (if (fneq val (vector-ref vals i))
	      (snd-display #__line__ ";hermite ~A ~A -> ~A ~A" (vector-ref ns i) (vector-ref xs i) val (vector-ref vals i)))))
      )
    
    (do ((i 0 (+ i 1))) 
	((= i 10))
      (let ((lv (legendre-polynomial (let ((v (make-vector 10 0.0))) 
				       (vector-set! v i 1.0) 
				       v) 
				     0.5))
	    (pv (plgndr i 0 0.5)))
	(if (fneq lv pv)
	    (snd-display #__line__ ";lv: ~A, pv: ~A (~A)" lv pv i))))
    
    (let ((pow-x (lambda (pow x)
		   ;; A&S p798
		   (if (= pow 0)
		       (legendre-polynomial (vector 1) x)
		       (if (= pow 1)
			   (legendre-polynomial (vector 0 1) x)
			   (if (= pow 2)
			       (* (/ 1.0 3.0) (legendre-polynomial (vector 1 0 2) x))
			       (if (= pow 3)
				   (* (/ 1.0 5.0) (legendre-polynomial (vector 0 3 0 2) x))
				   (if (= pow 4)
				       (* (/ 1.0 35.0) (legendre-polynomial (vector 7 0 20 0 8) x))
				       (if (= pow 5)
					   (* (/ 1.0 63.0) (legendre-polynomial (vector 0 27 0 28 0 8) x))
					   (if (= pow 6) 
					       (* (/ 1.0 231.0) (legendre-polynomial (vector 33 0 110 0 72 0 16) x))
					       'oops))))))))))
      (for-each
       (lambda (x)
	 (for-each
	  (lambda (pow)
	    (let ((lv (pow-x pow x))
		  (sv (expt x pow)))
	      (if (fneq lv sv)
		  (snd-display #__line__ ";~A ^ ~A = ~A ~A?" x pow lv sv))))
	  (list 0 1 2 3 4 5 6)))
       (list 2.0 0.5 0.1 -0.5 3.0 0.8)))
    
    (let ((snd (with-sound (:scaled-to 0.5) 
		 (do ((i 0 (+ i 1)) 
		      (x 0.0 (+ x .02))) 
		     ((= i 100)) 
		   (outa i (legendre 20 (cos x)))))))
      (let ((index (find-sound snd)))
	(if (fneq (sample 0 index 0) 0.5) (snd-display #__line__ ";legendre(cos(x)) 0: ~A" (sample 0 index 0)))
	(if (fneq (sample 50 index 0) 0.062572978) (snd-display #__line__ ";legendre(cos(x)) 50: ~A" (sample 50 index 0)))
	(close-sound index)))
    
    
    (let (;(h0 (lambda (x) 1.0))
	  (h1 (lambda (x) (* 2 x)))
	  (h2 (lambda (x) (- (* 4 x x) 2)))
	  (h3 (lambda (x) (- (* 8 x x x) (* 12 x))))
	  (h4 (lambda (x) (+ (* 16 x x x x) (* -48 x x) 12)))
	  (h5 (lambda (x) (+ (* 32 x x x x x) (* -160 x x x) (* 120 x))))
	  (h6 (lambda (x) (+ (* 64 x x x x x x) (* -480 x x x x) (* 720 x x) -120))))
      
      (do ((i 0 (+ i 1)))
	  ((= i 20))
	(let ((x (random 10.0)))
	  (let ((v1 (h1 x))
		(v11 (hermite 1 x))
		(v2 (h2 x))
		(v22 (hermite 2 x))
		(v3 (h3 x))
		(v33 (hermite 3 x))
		(v4 (h4 x))
		(v44 (hermite 4 x))
		(v5 (h5 x))
		(v55 (hermite 5 x))
		(v6 (h6 x))
		(v66 (hermite 6 x)))
	    (if (fneq v1 v11) (snd-display #__line__ ";hermite 1 ~A: ~A ~A" x v1 v11)
		(if (fneq v2 v22) (snd-display #__line__ ";hermite 2 ~A: ~A ~A" x v2 v22)
		    (if (fneq v3 v33) (snd-display #__line__ ";hermite 3 ~A: ~A ~A" x v3 v33)
			(if (fneq v4 v44) (snd-display #__line__ ";hermite 4 ~A: ~A ~A" x v4 v44)
			    (if (fneq v5 v55) (snd-display #__line__ ";hermite 5 ~A: ~A ~A" x v5 v55)
				(if (fneq v6 v66) (snd-display #__line__ ";hermite 6 ~A: ~A ~A" x v6 v66)))))))))))
    
    (let ((lg1 (lambda (x) (- 1 x)))
	  (lg2 (lambda (x) (+ 1 (* 0.5 x x) (* -2 x))))
	  (lag1 (lambda (x a) (+ 1 a (- x))))
	  (lag2 (lambda (x a) (* 0.5 (+ (* x x) 
					(* -2 x (+ a 2))
					(* (+ a 1) (+ a 2))))))
	  (lag3 (lambda (x a) (* (/ -1.0 6.0) (+ (* x x x)
						 (* -3 x x (+ a 3))
						 (* 3 x (+ a 2) (+ a 3))
						 (* -1 (+ a 1) (+ a 2) (+ a 3)))))))
      (let ((x (random 10.0))
	    (a (random 1.0)))
	(let ((v1 (laguerre 1 x))
	      (v11 (lg1 x))
	      (v2 (laguerre 2 x))
	      (v22 (lg2 x))
	      (va1 (lag1 x a))
	      (va11 (laguerre 1 x a))
	      (va2 (lag2 x a))
	      (va22 (laguerre 2 x a))
	      (va3 (lag3 x a))
	      (va33 (laguerre 3 x a)))
	  (if (fneq v1 v11) (snd-display #__line__ ";laguerre 1 ~A: ~A ~A" x v1 v11)
	      (if (fneq v2 v22) (snd-display #__line__ ";laguerre 2 ~A: ~A ~A" x v2 v22)
		  (if (fneq va1 va11) (snd-display #__line__ ";laguerre 1a ~A ~A: ~A ~A" x a va1 va11)
		      (if (fneq va2 va22) (snd-display #__line__ ";laguerre 2a ~A ~A: ~A ~A" x a va2 va22)
			  (if (fneq va3 va33) (snd-display #__line__ ";laguerre 3a ~A ~A: ~A ~A" x a va3 va33)))))))))
    )
  
  ;; ----------------
  ;; start of test
  
  (do ((clmtest 0 (+ 1 clmtest))) ((= clmtest tests))
    
    (log-mem clmtest)
    (numerical-reality-checks)
    
    (if (mus-generator? 321) (snd-display #__line__ ";123 is a gen?"))
    (if (mus-generator? (list 321)) (snd-display #__line__ ";(123) is a gen?"))
    (if (mus-generator? (list 'hi 321)) (snd-display #__line__ ";(hi 123) is a gen?"))
    (set! *clm-srate* 22050)
    (let ((samps (seconds->samples 1.0))
	  (secs (samples->seconds 22050)))
      (if (not (= samps 22050)) (snd-display #__line__ ";seconds->samples: ~A" samps))
      (if (fneq secs 1.0) (snd-display #__line__ ";samples->seconds: ~A" secs)))
    (set! *clm-file-buffer-size* default-file-buffer-size)
    (let ((var (catch #t (lambda () (set! *clm-file-buffer-size* #f)) (lambda args args))))
      (if (not (eq? (car var) 'wrong-type-arg))
	  (snd-display #__line__ ";mus-file-buffer-size bad size: ~A" var)))
    (set! *clm-file-buffer-size* 128)
    (if (not (= *clm-file-buffer-size* 128)) (snd-display #__line__ ";mus-file-buffer-size: ~D?" *clm-file-buffer-size*))
    (set! *clm-file-buffer-size* default-file-buffer-size)
    
    (if (and (not (= *mus-array-print-length* 8)) 
	     (not (= *mus-array-print-length* 12))
	     (not (= *mus-array-print-length* 32)))
	(snd-display #__line__ ";mus-array-print-length: ~D?" *mus-array-print-length*))
    (set! *mus-array-print-length* 32)
    (if (not (= *mus-array-print-length* 32)) (snd-display #__line__ ";set mus-array-print-length: ~D?" *mus-array-print-length*))
    (set! *mus-array-print-length* 8)
    
    (let ((fudge *mus-float-equal-fudge-factor*))
      (if (> (abs (- *mus-float-equal-fudge-factor* 0.0000001)) 0.00000001)
	  (snd-display #__line__ ";mus-float-equal-fudge-factor: ~A?" *mus-float-equal-fudge-factor*))
      (set! *mus-float-equal-fudge-factor* .1)
      (if (fneq *mus-float-equal-fudge-factor* .1) 
	  (snd-display #__line__ ";set mus-float-equal-fudge-factor: ~A?" *mus-float-equal-fudge-factor*))
      (set! *mus-float-equal-fudge-factor* fudge))
    
    (if (fneq *clm-srate* 22050.0) (snd-display #__line__ ";mus-srate: ~F?" *clm-srate*))
    (if (fneq (hz->radians 1.0) 2.84951704088598e-4) (snd-display #__line__ ";hz->radians: ~F?" (hz->radians 1.0)))
    (if (fneq (radians->hz 2.84951704088598e-4) 1.0) (snd-display #__line__ ";radians->hz: ~F?" (radians->hz 2.84951704088598e-4)))
    (if (fneq (radians->degrees 1.0) 57.2957801818848) (snd-display #__line__ ";radians->degrees: ~F?" (radians->degrees 1.0)))
    (if (fneq (degrees->radians 57.2957801818848) 1.0) (snd-display #__line__ ";degrees->radians: ~F?" (degrees->radians 57.2957801818848)))
    (if (fneq (linear->db .25) -12.0411996841431) (snd-display #__line__ ";linear->db: ~F?" (linear->db .25)))
    (if (fneq (db->linear -12.0411996841431) .25) (snd-display #__line__ ";db->linear: ~F?" (db->linear -12.0411996841431)))

    (if (fneq (odd-weight 0.0) 0.0) (snd-display #__line__ ";odd-weight 0.0: ~F?" (odd-weight 0.0)))
    (if (fneq (odd-weight 2.0) 0.0) (snd-display #__line__ ";odd-weight 2.0: ~F?" (odd-weight 2.0)))
    (if (fneq (odd-weight 1.0) 1.0) (snd-display #__line__ ";odd-weight 1.0: ~F?" (odd-weight 1.0)))
    (if (fneq (odd-weight 1.5) 0.5) (snd-display #__line__ ";odd-weight 1.5: ~F?" (odd-weight 1.5)))
    (if (fneq (odd-weight 2.5) 0.5) (snd-display #__line__ ";odd-weight 2.5: ~F?" (odd-weight 2.5)))
    (if (fneq (odd-weight 2.1) 0.1) (snd-display #__line__ ";odd-weight 2.1: ~F?" (odd-weight 2.1)))
    (if (fneq (odd-weight 2.9) 0.9) (snd-display #__line__ ";odd-weight 2.9: ~F?" (odd-weight 2.9)))
    (if (fneq (odd-weight 1.1) 0.9) (snd-display #__line__ ";odd-weight 1.1: ~F?" (odd-weight 1.1)))
    (if (fneq (odd-weight 1.9) 0.1) (snd-display #__line__ ";odd-weight 1.9: ~F?" (odd-weight 1.9)))

    (if (fneq (even-weight 0.0) 1.0) (snd-display #__line__ ";even-weight 0.0: ~F?" (even-weight 0.0)))
    (if (fneq (even-weight 2.0) 1.0) (snd-display #__line__ ";even-weight 2.0: ~F?" (even-weight 2.0)))
    (if (fneq (even-weight 1.0) 0.0) (snd-display #__line__ ";even-weight 1.0: ~F?" (even-weight 1.0)))
    (if (fneq (even-weight 1.5) 0.5) (snd-display #__line__ ";even-weight 1.5: ~F?" (even-weight 1.5)))
    (if (fneq (even-weight 2.5) 0.5) (snd-display #__line__ ";even-weight 2.5: ~F?" (even-weight 2.5)))
    (if (fneq (even-weight 2.1) 0.9) (snd-display #__line__ ";even-weight 2.1: ~F?" (even-weight 2.1)))
    (if (fneq (even-weight 2.9) 0.1) (snd-display #__line__ ";even-weight 2.9: ~F?" (even-weight 2.9)))
    (if (fneq (even-weight 1.1) 0.1) (snd-display #__line__ ";even-weight 1.1: ~F?" (even-weight 1.1)))
    (if (fneq (even-weight 1.9) 0.9) (snd-display #__line__ ";even-weight 1.9: ~F?" (even-weight 1.9)))

    (if (fneq (odd-multiple 0.0 2.0) 2.0) (snd-display #__line__ ";odd-multiple 0.0: ~F?" (odd-multiple 0.0 2.0)))
    (if (fneq (odd-multiple 2.0 2.0) 6.0) (snd-display #__line__ ";odd-multiple 2.0: ~F?" (odd-multiple 2.0 2.0)))
    (if (fneq (odd-multiple 1.0 2.0) 2.0) (snd-display #__line__ ";odd-multiple 1.0: ~F?" (odd-multiple 1.0 2.0)))
    (if (fneq (odd-multiple 1.5 2.0) 2.0) (snd-display #__line__ ";odd-multiple 1.5: ~F?" (odd-multiple 1.5 2.0)))
    (if (fneq (odd-multiple 2.5 2.0) 6.0) (snd-display #__line__ ";odd-multiple 2.5: ~F?" (odd-multiple 2.5 2.0)))
    (if (fneq (odd-multiple 2.1 2.0) 6.0) (snd-display #__line__ ";odd-multiple 2.1: ~F?" (odd-multiple 2.1 2.0)))
    (if (fneq (odd-multiple 2.9 2.0) 6.0) (snd-display #__line__ ";odd-multiple 2.9: ~F?" (odd-multiple 2.9 2.0)))
    (if (fneq (odd-multiple 1.1 2.0) 2.0) (snd-display #__line__ ";odd-multiple 1.1: ~F?" (odd-multiple 1.1 2.0)))
    (if (fneq (odd-multiple 1.9 2.0) 2.0) (snd-display #__line__ ";odd-multiple 1.9: ~F?" (odd-multiple 1.9 2.0)))

    (if (fneq (even-multiple 0.0 2.0) 0.0) (snd-display #__line__ ";even-multiple 0.0: ~F?" (even-multiple 0.0 2.0)))
    (if (fneq (even-multiple 2.0 2.0) 4.0) (snd-display #__line__ ";even-multiple 2.0: ~F?" (even-multiple 2.0 2.0)))
    (if (fneq (even-multiple 1.0 2.0) 4.0) (snd-display #__line__ ";even-multiple 1.0: ~F?" (even-multiple 1.0 2.0)))
    (if (fneq (even-multiple 1.5 2.0) 4.0) (snd-display #__line__ ";even-multiple 1.5: ~F?" (even-multiple 1.5 2.0)))
    (if (fneq (even-multiple 2.5 2.0) 4.0) (snd-display #__line__ ";even-multiple 2.5: ~F?" (even-multiple 2.5 2.0)))
    (if (fneq (even-multiple 2.1 2.0) 4.0) (snd-display #__line__ ";even-multiple 2.1: ~F?" (even-multiple 2.1 2.0)))
    (if (fneq (even-multiple 2.9 2.0) 4.0) (snd-display #__line__ ";even-multiple 2.9: ~F?" (even-multiple 2.9 2.0)))
    (if (fneq (even-multiple 1.1 2.0) 4.0) (snd-display #__line__ ";even-multiple 1.1: ~F?" (even-multiple 1.1 2.0)))
    (if (fneq (even-multiple 1.9 2.0) 4.0) (snd-display #__line__ ";even-multiple 1.9: ~F?" (even-multiple 1.9 2.0)))

    (if (fneq (ring-modulate .4 .5) .2) (snd-display #__line__ ";ring-modulate: ~F?" (ring-modulate .4 .5)))
    (if (fneq (amplitude-modulate 1.0 .5 .4) .7) (snd-display #__line__ ";amplitude-modulate: ~F?" (amplitude-modulate 1.0 .5 .4)))
    (if (fneq (contrast-enhancement 0.1 0.75) (sin (+ (* 0.1 (/ pi 2)) (* .75 (sin (* 0.1 2.0 pi))))))
	(snd-display #__line__ ";contrast-enhancement: ~F (0.562925306221587)" (contrast-enhancement 0.1 0.75)))
    (if (fneq (contrast-enhancement 1.0) 1.0) (snd-display #__line__ ";contrast-enhancement opt: ~A" (contrast-enhancement 1.0)))
    (let ((lv0 (partials->polynomial (float-vector 1 1 2 1) mus-chebyshev-first-kind))
	  (lv1 (partials->polynomial '(1 1 2 1) mus-chebyshev-second-kind))
	  (lv2 (partials->polynomial '(1 1 2 1 3 1 5 1) mus-chebyshev-first-kind))
	  (lv3 (partials->polynomial '(1 1 2 1 3 1 5 1) mus-chebyshev-second-kind))
	  (lv4 (partials->polynomial '(1 1 2 .5 3 .1 6 .01) mus-chebyshev-first-kind))
	  (lv5 (partials->polynomial (list 1 1 2 .5 3 .1 6 .01) mus-chebyshev-second-kind))
	  (lv6 (partials->polynomial (float-vector 1 9 2 3 3 5 4 7 5 1))) ; MLB
	  (lv7 (partials->polynomial '(7 1)))
	  (lv7a (partials->polynomial '(7 1) mus-chebyshev-first-kind))
	  (lv8 (partials->polynomial '(7 1) mus-chebyshev-second-kind))
	  )
      (if (not (fveql lv0 '(-1.000 1.000 2.000) 0)) (snd-display #__line__ ";partials->polynomial(1): ~A?" lv0))
      (if (not (fveql lv1 '(1.000 2.000 0.0) 0)) (snd-display #__line__ ";partials->polynomial(2): ~A?" lv1))
      (if (not (fveql lv2 '(-1.000 3.000 2.000 -16.000 0.000 16.000) 0)) (snd-display #__line__ ";partials->polynomial(3): ~A?" lv2))
      (if (not (fveql lv3 '(1.000 2.000 -8.000 0.000 16.000 0.000) 0)) (snd-display #__line__ ";partials->polynomial(4): ~A?" lv3))
      (if (not (fveql lv4 '(-0.510 0.700 1.180 0.400 -0.480 0.000 0.320) 0)) (snd-display #__line__ ";partials->polynomial(5): ~A?" lv4))
      (if (not (fveql lv5 '(0.900 1.060 0.400 -0.320 0.000 0.320 0.000) 0)) (snd-display #__line__ ";partials->polynomial(6): ~A?" lv5))
      (if (not (vequal lv6 (float-vector 4.000 -1.000 -50.000 0.000 56.000 16.000))) (snd-display #__line__ ";partials->polynomial(7): ~A?" lv6))
      (if (not (vequal lv7 (float-vector 0.000 -7.000 0.000 56.000 0.000 -112.000 0.000 64.000))) (snd-display #__line__ ";partials->polynomial(8): ~A?" lv7))
      (if (not (vequal lv8 (float-vector -1.000 0.000 24.000 0.000 -80.000 0.000 64.000 0.000))) (snd-display #__line__ ";partials->polynomial(9): ~A?" lv8))
      (if (not (vequal lv7 lv7a)) (snd-display #__line__ ";partials->polynomial kind=1? ~A ~A" lv7 lv7a))
      
      (if (not (vequal (normalize-partials (list 1 1 2 1)) (float-vector 1.000 0.500 2.000 0.500)))
	  (snd-display #__line__ ";normalize-partials 1: ~A" (normalize-partials (list 1 1 2 1))))
      (if (not (vequal (normalize-partials (float-vector 1 1 2 1)) (float-vector 1.000 0.500 2.000 0.500)))
	  (snd-display #__line__ ";normalize-partials 2: ~A" (normalize-partials (float-vector 1 1 2 1))))
      (if (not (vequal (normalize-partials (float-vector 1 1 2 -1)) (float-vector 1.000 0.500 2.000 -0.500)))
	  (snd-display #__line__ ";normalize-partials 3: ~A" (normalize-partials (float-vector 1 1 2 -1))))
      (if (not (vequal (normalize-partials (float-vector 1 -.1 2 -.1)) (float-vector 1.000 -0.500 2.000 -0.500)))
	  (snd-display #__line__ ";normalize-partials 4: ~A" (normalize-partials (float-vector 1 -.1 2 -.1))))
      (if (not (vequal (normalize-partials (float-vector 0 2 1 1 4 1)) (float-vector 0.000 0.500 1.000 0.250 4.000 0.250)))
	  (snd-display #__line__ ";normalize-partials 4: ~A" (normalize-partials (float-vector 0 2 1 1 4 1))))
      
      (if (fneq (polynomial lv7 1.0) (cosh (* 7 (acosh 1.0)))) 
	  (snd-display #__line__ ";ccosh cheb 7 1.0: ~A ~A" (polynomial lv7 1.0) (cosh (* 7 (acosh 1.0)))))
      (if (fneq (polynomial lv7 1.0) (cos (* 7 (acos 1.0)))) 
	  (snd-display #__line__ ";cos cheb 7 1.0: ~A ~A" (polynomial lv7 1.0) (cos (* 7 (acos 1.0)))))
      (if (fneq (polynomial lv8 0.5) (/ (sin (* 7 (acos 0.5))) (sin (acos 0.5))))
	  (snd-display #__line__ ";acos cheb 7 1.0: ~A ~A" (polynomial lv8 0.5) (/ (sin (* 7 (acos 0.5))) (sin (acos 0.5)))))
      ;; G&R 8.943 p 984 uses n+1 where we use n in Un? (our numbering keeps harmonics aligned between Tn and Un)
      
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(let ((val (mus-random 1.0)))
	  (if (fneq (polynomial lv7 val) (cosh (* 7 (acosh val)))) 
	      (snd-display #__line__ ";ccosh cheb 7 ~A: ~A ~A" val (polynomial lv7 val) (cosh (* 7 (acosh val)))))
	  (if (fneq (polynomial lv7 val) (cos (* 7 (acos val)))) 
	      (snd-display #__line__ ";cos cheb 7 ~A: ~A ~A" val (polynomial lv7 val) (cos (* 7 (acos val)))))
	  (if (fneq (polynomial lv8 val) (/ (sin (* 7 (acos val))) (sin (acos val))))
	      (snd-display #__line__ ";acos cheb 7 ~A: ~A ~A" val (polynomial lv8 val) (/ (sin (* 7 (acos val))) (sin (acos val)))))))
      )
    
    ;; check phase-quadrature cancellations
    (let ((cos-coeffs (partials->polynomial '(1 1 2 1) mus-chebyshev-first-kind))
	  (sin-coeffs (partials->polynomial (float-vector 1 1 2 1) mus-chebyshev-second-kind))
	  (incr (/ (* 2 pi 440.0) 22050.0)))
      (do ((i 0 (+ i 1))
	   (a 0.0 (+ a incr)))
	  ((= i 1100))
	(let* ((x (cos a))
	       (y (sin a))
	       (cax (polynomial cos-coeffs x))
	       (sax (polynomial sin-coeffs x))
	       (upper (- (* (cos (* 2 a)) cax) (* (sin (* 2 a)) y sax)))
	       (lower (+ (* (cos (* 2 a)) cax) (* (sin (* 2 a)) y sax)))
	       (upper2 (+ (cos (* a 3)) (cos (* a 4))))
	       (lower2 (+ 1.0 (cos a))))
	  (if (or (fneq upper upper2)
		  (fneq lower lower2))
	      (snd-display #__line__ ";~A ~A, ~A ~A" upper upper2 lower lower2)))))
    
    (let ((tag (catch #t (lambda () (harmonicizer 550.0 (list .5 .3 .2) 10)) (lambda args (car args)))))
      (if (not (eq? tag 'no-data)) (snd-display #__line__ ";odd length arg to partials->polynomial: ~A" tag)))
    
    (let ((rdat (make-float-vector 16))
	  (idat (make-float-vector 16))
	  (vdat (make-float-vector 16)))
      (set! (rdat 0) 1.0)
      (set! (vdat 0) 1.0)
      (let ((v0 (spectrum rdat idat (make-fft-window rectangular-window 16) 1)) ;rectangular here to avoid clobbering 0-th data point
	    (v1 (snd-spectrum vdat rectangular-window 16 #t)))
	(do ((i 0 (+ i 1)))
	    ((= i 8)) ;should all be 1.0 (impulse in)
	  (if (fneq (v0 i) (v1 i))
	      (snd-display #__line__ ";spectra not equal 1: ~A ~A" v0 v1))))
      (float-vector-scale! idat 0.0)
      (float-vector-scale! rdat 0.0)
      (set! (rdat 0) 1.0)
      (let ((v0 (spectrum rdat idat (make-fft-window rectangular-window 17) 1)) ;rectangular here to avoid clobbering 0-th data point
	    (v1 (snd-spectrum vdat rectangular-window 16 #t)))
	(do ((i 0 (+ i 1)))
	    ((= i 8)) ;should all be 1.0 (impulse in)
	  (if (fneq (v0 i) (v1 i))
	      (snd-display #__line__ ";spectra not equal 0: ~A ~A" v0 v1))))
      (let ((var (catch #t (lambda () (spectrum rdat idat #f -1)) (lambda args args))))
	(if (or (float-vector? var) 
		(not (eq? (car var) 'out-of-range)))
	    (snd-display #__line__ ";spectrum bad type: ~A" var))))
    
    (let ((rdat (make-float-vector 16))
	  (idat (make-float-vector 16))
	  (xdat (make-float-vector 16))
	  (ydat (make-float-vector 16)))
      (set! (rdat 3) 1.0)
      (set! (xdat 3) 1.0)
      (fft rdat idat 1)
      (mus-fft xdat ydat 16 1)
      (if (fneq (rdat 0) (xdat 0)) (snd-display #__line__ ";ffts: ~A ~A?" rdat xdat))
      (fft rdat idat -1)
      (mus-fft xdat ydat 17 -1) ; mistake is deliberate
      (do ((i 0 (+ i 1)))
	  ((= i 16))
	(if (or (and (= i 3) (or (fneq (rdat i) 16.0) (fneq (xdat i) 16.0)))
		(and (not (= i 3)) (or (fneq (rdat i) 0.0) (fneq (xdat i) 0.0))))
	    (snd-display #__line__ ";fft real[~D]: ~A ~A?" i (rdat i) (xdat i)))
	(if (or (fneq (idat i) 0.0) (fneq (ydat i) 0.0))
	    (snd-display #__line__ ";fft imag[~D]: ~A ~A?" i (idat i) (ydat i))))
      (let ((var (catch #t (lambda () (mus-fft xdat ydat -1 0)) (lambda args args))))
	(if (not (eq? (car var) 'out-of-range))
	    (snd-display #__line__ ";mus-fft bad len: ~A" var))))
    
    (let ((rdat (make-float-vector 20))
	  (idat (make-float-vector 19)))
      (set! (rdat 3) 1.0)
      (mus-fft rdat idat)
      (convolution rdat idat)
      (spectrum rdat idat #f))
    
    (let ((v0 (make-float-vector 10))
	  (v1 (make-float-vector 10)))
      (fill! v0 1.0)
      (fill! v1 0.5)
      (float-vector-multiply! v0 v1)
      (if (fneq (v0 0) 0.5) (snd-display #__line__ ";multiple-arrays: ~F?" (v0 0)))
      (let ((sum (dot-product v0 v1)))
	(if (fneq sum 2.5) (snd-display #__line__ ";dot-product: ~F?" sum)))
      (let ((sum (dot-product v0 v1 10)))
	(if (fneq sum 2.5) (snd-display #__line__ ";dot-product (10): ~F?" sum)))
      (let ((sum (dot-product v0 v1 3)))
	(if (fneq sum 0.75) (snd-display #__line__ ";dot-product (3): ~F?" sum)))
      (fill! v0 0.0)
      (if (fneq (v0 3) 0.0) (snd-display #__line__ ";fill!: ~A?" v0))
      (fill! v0 1.0)
      (fill! v1 0.5)
      (let ((v2 (rectangular->polar v0 v1)))
	(if (fneq (v2 0) 1.118) (snd-display #__line__ ";rectangular->polar: ~A?" v2)))
      (set! (v0 0) 1.0)
      (set! (v1 0) 1.0)
      (rectangular->polar v0 v1)
      (if (or (fneq (v0 0) (sqrt 2.0))
	      (fneq (v1 0) (- (atan 1.0 1.0)))) ;(tan (atan 1.0 1.0)) -> 1.0 
	  (snd-display #__line__ ";rectangular->polar (~A ~A): ~A ~A?" (sqrt 2.0) (- (atan 1.0 1.0)) (v0 0) (v1 0)))
      (polar->rectangular v0 v1)
      (if (or (fneq (v0 0) 1.0)
	      (fneq (v1 0) 1.0))
	  (snd-display #__line__ ";polar->rectangular (1 1): ~A ~A?" (v0 0) (v1 0)))
      
      (let ((ind (open-sound "oboe.snd"))
	    (rl (channel->float-vector 1200 512))
	    (im (make-float-vector 512)))
	(fft rl im 512)
	(let ((rl-copy (copy rl))
	      (im-copy (copy im)))
	  (rectangular->polar rl im)
	  (polar->rectangular rl im)
	  (do ((i 0 (+ i 1)))
	      ((= i 512))
	    (if (or (fneq (rl i) (rl-copy i))
		    (fneq (im i) (im-copy i)))
		(snd-display #__line__ ";polar->rectangular[~D]: ~A ~A ~A ~A" 
			     i 
			     (rl i) (rl-copy i)
			     (im i) (im-copy i)))))
	(close-sound ind)))
    
    (let ((v0 (make-float-vector 8))
	  (v1 (make-float-vector 8)))
      (do ((i 0 (+ i 1))) ((= i 8)) (set! (v0 i) i) (set! (v1 i) (/ (+ i 1))))
      (rectangular->magnitudes v0 v1)
      (if (not (vequal v0 (float-vector 1.000 1.118 2.028 3.010 4.005 5.003 6.002 7.001)))
	  (snd-display #__line__ ";rectangular->magnitudes v0: ~A" v0)))
    
    (let ((v0 (make-float-vector 8))
	  (v1 (make-float-vector 8))
	  (v2 (make-float-vector 8))
	  (v3 (make-float-vector 8)))
      (do ((i 0 (+ i 1)))
	  ((= i 8))
	(let ((val1 (random 1.0))
	      (val2 (random 1.0)))
	  (set! (v0 i) val1)
	  (float-vector-set! v2 i val1)
	  (float-vector-set! v1 i val2)
	  (float-vector-set! v3 i val2)))
      (rectangular->magnitudes v0 v1)
      (rectangular->polar v2 v3)
      (if (not (vequal v0 v2))
	  (snd-display #__line__ ";rectangular->magnitudes|polar: ~A ~A" v0 v2)))
    
    (if (defined? 'edot-product) ; needs complex numbers in C
	(let* ((vals (make-float-vector 1 1.0))
	       (v1 (edot-product 0.0 vals)))
	  (if (fneq v1 1.0) ; exp 0.0 * 1.0
	      (snd-display #__line__ ";edot a 1.0: ~A" v1))
	  (set! (vals 0) 0.0)
	  (set! v1 (edot-product 0.0 vals))
	  (if (fneq v1 0.0) ; exp 0.0 * 0.0
	      (snd-display #__line__ ";edot b 0.0: ~A" v1))
	  (set! vals (make-vector 1 1.0))
	  (set! v1 (edot-product 0.0 vals))  
	  (if (fneq v1 1.0) ; exp 0.0 * 1.0
	      (snd-display #__line__ ";edot c 1.0: ~A" v1))
	  (set! (vals 0) 0.0+i)
	  (set! v1 (edot-product 0.0 vals))
	  (if (cneq v1 0.0+i)
	      (snd-display #__line__ ";edot i: ~A" v1))
	  (set! vals (make-float-vector 4 1.0))
	  (set! v1 (edot-product (* 0.25 2 pi) vals))
	  (let ((v2 (+ (exp (* 0 2 pi))
		       (exp (* 0.25 2 pi))
		       (exp (* 0.5 2 pi))
		       (exp (* 0.75 2 pi)))))
	    (if (fneq v1 v2) (snd-display #__line__ ";edot 4: ~A ~A" v1 v2)))
	  (set! vals (make-vector 4 0.0))  
	  (do ((i 0 (+ i 1)))
	      ((= i 4))
	    (set! (vals i) (+ i 1.0)))
	  (set! v1 (edot-product (* 0.25 2 pi 0.0-i) vals))
	  (let ((v2 (+ (*   (exp (* 0 2 pi 0.0-i)))
		       (* 2 (exp (* 0.25 2 pi 0.0-i)))
		       (* 3 (exp (* 0.5 2 pi 0.0-i)))
		       (* 4 (exp (* 0.75 2 pi 0.0-i))))))
	    (if (cneq v1 v2) (snd-display #__line__ ";edot 4 -i: ~A ~A" v1 v2)))
	  (do ((i 0 (+ i 1)))
	      ((= i 4))
	    (set! (vals i) (+ i 1.0+i)))
	  (set! v1 (edot-product (* 0.25 2 pi 0.0-i) vals))
	  (let ((v2 (+ (* 1+i (exp (* 0 2 pi 0.0-i)))
		       (* 2+i (exp (* 0.25 2 pi 0.0-i)))
		       (* 3+i (exp (* 0.5 2 pi 0.0-i)))
		       (* 4+i (exp (* 0.75 2 pi 0.0-i))))))
	    (if (cneq v1 v2) (snd-display #__line__ ";edot 4 -i * i: ~A ~A" v1 v2)))))
    
    (let ((v0 (make-float-vector 3)))
      (set! (v0 0) 1.0)
      (set! (v0 1) 0.5)
      (set! (v0 2) 0.1)
      (if (or (fneq (polynomial v0 0.0) 1.0)
	      (fneq (polynomial v0 1.0) 1.6)
	      (fneq (polynomial v0 2.0) 2.4))
	  (snd-display #__line__ ";polynomial: ~A ~A ~A?"
		       (polynomial v0 0.0)
		       (polynomial v0 1.0)
		       (polynomial v0 2.0))))
    (if (fneq (polynomial (float-vector 0.0 2.0) 0.5) 1.0) 
	(snd-display #__line__ ";polynomial 2.0 * 0.5: ~A" (polynomial (float-vector 2.0) 0.5)))
    (let ((var (catch #t (lambda () (polynomial #f 1.0)) (lambda args args))))
      (if (not (eq? (car var) 'wrong-type-arg))
	  (snd-display #__line__ ";polynomial empty coeffs: ~A" var)))
    
    (do ((i 0 (+ i 1)))
	((= i 100))
      (let ((arg1 (- (random 100.0) 50.0))
	    (arg2 (- (random 100.0) 50.0)))
	(let ((val1 (modulo arg1 arg2))
	      (val2 (modulo arg1 arg2)))
	  (if (and (> (abs (- val1 val2)) 1e-8)
		   (> (abs (- (abs (- val1 val2)) (abs arg2))) 1e-8))
	      (snd-display #__line__ ";poly ~A ~A: ~A ~A -> ~A~%" arg1 arg2 val1 val2 (abs (- val1 val2)))))))
    
    (let ((err 0.0)
	  (coeffs (float-vector 1.0 0.0 -.4999999963 0.0 .0416666418 0.0 -.0013888397 0.0 .0000247609 0.0 -.0000002605))
	  (pi2 (* pi 0.5)))
      (letrec ((new-cos
		(lambda (x)
		  (let ((xx (abs x)))
		    (if (<= xx pi2)
			(polynomial coeffs xx)
			(let ((nxx (modulo xx (* 2 pi))))
			  (if (<= nxx pi2)
			      (polynomial coeffs nxx)
			      (if (<= nxx pi)
				  (- (polynomial coeffs (- pi nxx)))
				  (if (< nxx (* 1.5 pi))
				      (- (polynomial coeffs (- nxx pi)))
				      (polynomial coeffs (- (* 2 pi) nxx)))))))))))
	(do ((i 0 (+ i 1))
	     (x -10.0 (+ x .01)))
	    ((= i 2000))
	  (let ((diff (abs (- (cos x) (new-cos x)))))
	    (if (> diff err)
		(set! err diff))))
	(if (> err 1.1e-7) (snd-display #__line__ ";new-cos poly err: ~A" err))))
    
    (let ((val (poly+ (float-vector .1 .2 .3) (float-vector 0.0 1.0 2.0 3.0 4.0))))
      (if (not (vequal val (float-vector 0.100 1.200 2.300 3.000 4.000))) (snd-display #__line__ ";poly+ 1: ~A" val)))
    
    (let ((val (poly+ (float-vector .1 .2 .3) .5)))
      (if (not (vequal val (float-vector 0.600 0.200 0.300))) (snd-display #__line__ ";poly+ 2: ~A" val)))
    (let ((val (poly+ .5 (float-vector .1 .2 .3))))
      (if (not (vequal val (float-vector 0.600 0.200 0.300))) (snd-display #__line__ ";poly+ 3: ~A" val)))
    
    (let ((val (poly* (float-vector 1 1) (float-vector -1 1))))
      (if (not (vequal val (float-vector -1.000 0.000 1.000 0.000))) (snd-display #__line__ ";poly* 1: ~A" val)))
    (let ((val (poly* (float-vector -5 1) (float-vector 3 7 2))))
      (if (not (vequal val (float-vector -15.000 -32.000 -3.000 2.000 0.000))) (snd-display #__line__ ";poly* 2: ~A" val)))
    (let ((val (poly* (float-vector -30 -4 2) (float-vector 0.5 1))))
      (if (not (vequal val (float-vector -15.000 -32.000 -3.000 2.000 0.000))) (snd-display #__line__ ";poly* 3: ~A" val)))
    (let ((val (poly* (float-vector -30 -4 2) 0.5)))
      (if (not (vequal val (float-vector -15.000 -2.000 1.000))) (snd-display #__line__ ";poly* 4: ~A" val)))
    (let ((val (poly* 2.0 (float-vector -30 -4 2))))
      (if (not (vequal val (float-vector -60.000 -8.000 4.000))) (snd-display #__line__ ";poly* 5: ~A" val)))
    
    (let ((val (poly/ (float-vector -1.0 -0.0 1.0) (float-vector 1.0 1.0))))
      (if (or (not (vequal (car val) (float-vector -1.000 1.000 0.000)))
	      (not (vequal (cadr val) (float-vector 0.000 0.000 0.000))))
	  (snd-display #__line__ ";poly/ 1: ~A" val)))
    (let ((val (poly/ (float-vector -15 -32 -3 2) (float-vector -5 1))))
      (if (or (not (vequal (car val) (float-vector 3.000 7.000 2.000 0.000)))
	      (not (vequal (cadr val) (float-vector 0.000 0.000 0.000 0.000))))
	  (snd-display #__line__ ";poly/ 2: ~A" val)))
    (let ((val (poly/ (float-vector -15 -32 -3 2) (float-vector 3 1))))
      (if (or (not (vequal (car val) (float-vector -5.000 -9.000 2.000 0.000)))
	      (not (vequal (cadr val) (float-vector 0.000 0.000 0.000 0.000))))
	  (snd-display #__line__ ";poly/ 3: ~A" val)))
    (let ((val (poly/ (float-vector -15 -32 -3 2) (float-vector .5 1))))
      (if (or (not (vequal (car val) (float-vector -30.000 -4.000 2.000 0.000)))
	      (not (vequal (cadr val) (float-vector 0.000 0.000 0.000 0.000))))
	  (snd-display #__line__ ";poly/ 4: ~A" val)))
    (let ((val (poly/ (float-vector -15 -32 -3 2) (float-vector 3 7 2))))
      (if (or (not (vequal (car val) (float-vector -5.000 1.000 0.000 0.000)))
	      (not (vequal (cadr val) (float-vector 0.000 0.000 0.000 0.000))))
	  (snd-display #__line__ ";poly/ 5: ~A" val)))
    (let ((val (poly/ (float-vector -15 -32 -3 2) 2.0)))
      (if (not (vequal (car val) (float-vector -7.500 -16.000 -1.500 1.000)))
	  (snd-display #__line__ ";poly/ 6: ~A" val)))
    (let ((val (poly/ (float-vector -1.0 0.0 0.0 0.0 1.0) (float-vector 1.0 0.0 1.0))))
      (if (or (not (vequal (car val) (float-vector -1.0 0.0 1.0 0.0 0.0)))
	      (not (vequal (cadr val) (make-float-vector 5))))
	  (snd-display #__line__ ";poly/ 7: ~A" val)))
    (let ((val (poly/ (float-vector -1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0) (float-vector 1.0 0.0 0.0 0.0 1.0))))
      (if (or (not (vequal (car val) (float-vector -1.0 0.0 0.0 0.0 1.0 0.0 0.0 0.0 0.0)))
	      (not (vequal (cadr val) (make-float-vector 9))))
	  (snd-display #__line__ ";poly/ 8: ~A" val)))
    (let ((val (poly/ (float-vector -1.0 0.0 1.0) (float-vector -1.0 0.0 1.0))))
      (if (or (not (vequal (car val) (float-vector 1.0 0.0 0.0)))
	      (not (vequal (cadr val) (make-float-vector 3))))
	  (snd-display #__line__ ";poly/ 9: ~A" val)))
    (let ((val (poly/ (float-vector -1.0 0.0 1.0) (float-vector 2.0 1.0))))
      (if (or (not (vequal (car val) (float-vector -2.000 1.000 0.000)))
	      (not (vequal (cadr val) (float-vector 3.000 0.000 0.000))))
	  (snd-display #__line__ ";poly/ 10: ~A" val)))
    (let ((val (poly/ (float-vector 2 1) (float-vector -1.0 0.0 1.0))))
      (if (or (not (vequal (car val) (float-vector 0.0)))
	      (not (vequal (cadr val) (float-vector -1.000 0.000 1.000))))
	  (snd-display #__line__ ";poly/ 11: ~A" val)))
    (let ((val (poly/ (float-vector 1 2 3 0 1) (float-vector 0 0 0 1))))
      (if (or (not (vequal (car val) (float-vector 0.000 1.000 0.000 0.000 0.000)))
	      (not (vequal (cadr val) (float-vector 1.000 2.000 3.000 0.000 0.000))))
	  (snd-display #__line__ ";poly/ 12: ~A" val)))
    
    (let ((ind (open-sound "1a.snd")))
      (let ((v1 (channel->float-vector 0 100 ind 0))
	    (v2 (channel->float-vector 0 100 ind 0)))
	(let ((vals (car (poly/ v1 v2)))
	      (res (make-float-vector 100)))
	  (set! (res 0) 1.0)
	  (if (not (vequal vals res))
	      (snd-display #__line__ ";poly1 1a: ~A" vals))))
      (close-sound ind))
    
    (let ((val (poly-derivative (float-vector 0.5 1.0 2.0 4.0))))
      (if (not (vequal val (float-vector 1.000 4.000 12.000))) (snd-display #__line__ ";poly-derivative: ~A" val)))
    
    (let ((val (poly-reduce (float-vector 1 2 3))))
      (if (not (vequal val (float-vector 1.000 2.000 3.000))) (snd-display #__line__ ";poly-reduce 1: ~A" val)))
    (let ((val (poly-reduce (float-vector 1 2 3 0 0 0))))
      (if (not (vequal val (float-vector 1.000 2.000 3.000))) (snd-display #__line__ ";poly-reduce 2: ~A" val)))
    (let ((val (poly-reduce (float-vector 0 0 0 0 1 0))))
      (if (not (vequal val (float-vector 0.000 0.000 0.000 0.000 1.000))) (snd-display #__line__ ";poly-reduce 3: ~A" val)))
    
    (let ((vals (poly-gcd (poly-reduce (poly* (float-vector 2 1) (float-vector -3 1))) (float-vector 2 1))))
      (if (not (vequal vals (float-vector 2.000 1.000))) (snd-display #__line__ ";poly-gcd 1: ~A" vals)))
    (let ((vals (poly-gcd (poly-reduce (poly* (float-vector 2 1) (float-vector -3 1))) (float-vector 3 1))))
      (if (not (vequal vals (float-vector 0.000))) (snd-display #__line__ ";poly-gcd 2: ~A" vals)))
    (let ((vals (poly-gcd (poly-reduce (poly* (float-vector 2 1) (float-vector -3 1))) (float-vector -3 1))))
      (if (not (vequal vals (float-vector -3.000 1.000))) (snd-display #__line__ ";poly-gcd 2: ~A" vals)))
    (let ((vals (poly-gcd (poly-reduce (poly* (float-vector 8 1) (poly* (float-vector 2 1) (float-vector -3 1)))) (float-vector -3 1))))
      (if (not (vequal vals (float-vector -3.000 1.000))) (snd-display #__line__ ";poly-gcd 3: ~A" vals)))
    (let ((vals (poly-gcd (poly-reduce (poly* (float-vector 8 1) (poly* (float-vector 2 1) (float-vector -3 1)))) (poly-reduce (poly* (float-vector 8 1) (float-vector -3 1))))))
      (if (not (vequal vals (float-vector -24.000 5.000 1.000))) (snd-display #__line__ ";poly-gcd 4: ~A" vals)))
    (let ((vals (poly-gcd (float-vector -1 0 1) (float-vector 2 -2 -1 1))))
      (if (not (vequal vals (float-vector 0.000))) (snd-display #__line__ ";poly-gcd 5: ~A" vals)))
    (let ((vals (poly-gcd (float-vector 2 -2 -1 1) (float-vector -1 0 1))))
      (if (not (vequal vals (float-vector 1.000 -1.000))) (snd-display #__line__ ";poly-gcd 6: ~A" vals)))
    (let ((vals (poly-gcd (float-vector 2 -2 -1 1) (float-vector -2.5 1))))
      (if (not (vequal vals (float-vector 0.000))) (snd-display #__line__ ";poly-gcd 7: ~A" vals)))
    
    (poly-roots-tests)
    
    (let ((val (poly-as-vector-resultant (vector -1 0 1) (vector 1 -2 1))))
      (if (fneq val 0.0) (snd-display #__line__ ";poly-resultant 0: ~A" val)))
    (let ((val (poly-as-vector-resultant (vector -1 0 2) (vector 1 -2 1))))
      (if (fneq val 1.0) (snd-display #__line__ ";poly-resultant 1: ~A" val)))
    (let ((val (poly-as-vector-resultant (vector -1 0 1) (vector 1 1))))
      (if (fneq val 0.0) (snd-display #__line__ ";poly-resultant 2: ~A" val)))
    (let ((val (poly-as-vector-resultant (vector -1 0 1) (vector 2 1))))
      (if (fneq val 3.0) (snd-display #__line__ ";poly-resultant 3: ~A" val)))
    (let ((val (poly-resultant (float-vector -1 0 1) (float-vector 1 -2 1))))
      (if (fneq val 0.0) (snd-display #__line__ ";poly-resultant 0: ~A" val)))
    
    (let ((val (poly-as-vector-discriminant (vector -1 0 1))))
      (if (fneq val -4.0) (snd-display #__line__ ";poly-discriminant 0: ~A" val)))
    (let ((val (poly-as-vector-discriminant (vector 1 -2 1))))
      (if (fneq val 0.0) (snd-display #__line__ ";poly-discriminant 1: ~A" val)))
    (let ((val (poly-discriminant (poly-reduce (poly* (poly* (float-vector -1 1) (float-vector -1 1)) (float-vector 3 1))))))
      (if (fneq val 0.0) (snd-display #__line__ ";poly-discriminant 2: ~A" val)))
    (let ((val (poly-discriminant (poly-reduce (poly* (poly* (poly* (float-vector -1 1) (float-vector -1 1)) (float-vector 3 1)) (float-vector 2 1))))))
      (if (fneq val 0.0) (snd-display #__line__ ";poly-discriminant 3: ~A" val)))
    (let ((val (poly-discriminant (poly-reduce (poly* (poly* (poly* (float-vector 1 1) (float-vector -1 1)) (float-vector 3 1)) (float-vector 2 1))))))
      (if (fneq val 2304.0) (snd-display #__line__ ";poly-discriminant 4: ~A" val)))
    (let ((val (poly-discriminant (poly-reduce (poly* (poly* (poly* (float-vector 1 1) (float-vector -1 1)) (float-vector 3 1)) (float-vector 3 1))))))
      (if (fneq val 0.0) (snd-display #__line__ ";poly-discriminant 5: ~A" val)))
    
    
    (let ((v0 (make-float-vector 10)))
      (do ((i 0 (+ i 1))) ((= i 10))
	(set! (v0 i) i))
      (if (fneq (array-interp v0 3.5) 3.5) (snd-display #__line__ ";array-interp: ~F?" (array-interp v0 3.5)))
      (if (fneq (array-interp v0 13.5) 3.5) (snd-display #__line__ ";array-interp(13.5): ~F?" (array-interp v0 13.5)))
      (if (fneq (array-interp v0 -6.5) 3.5) (snd-display #__line__ ";array-interp(-6.5): ~F?" (array-interp v0 -6.5)))
      (if (fneq (array-interp v0 103.6) 3.6) (snd-display #__line__ ";array-interp(103.5): ~F?" (array-interp v0 103.6)))
      (if (fneq (array-interp v0 -106.6) 3.4) (snd-display #__line__ ";array-interp(-106.6): ~F?" (array-interp v0 -106.6)))
      (if (fneq (array-interp v0 -0.5) 4.5) (snd-display #__line__ ";array-interp(-0.5): ~F?" (array-interp v0 -0.5)))
      ;; interpolating between 9 and 0 here (confusing...)
      (if (fneq (array-interp v0 -0.9) 8.1) (snd-display #__line__ ";array-interp(-0.9): ~F?" (array-interp v0 -0.9)))
      (if (fneq (array-interp v0 -0.1) 0.9) (snd-display #__line__ ";array-interp(-0.1): ~F?" (array-interp v0 -0.1)))
      (if (fneq (array-interp v0 9.1) 8.1) (snd-display #__line__ ";array-interp(9.1): ~F?" (array-interp v0 9.1)))
      (if (fneq (array-interp v0 9.9) 0.9) (snd-display #__line__ ";array-interp(9.9): ~F?" (array-interp v0 9.9)))
      (if (fneq (array-interp v0 10.1) 0.1) (snd-display #__line__ ";array-interp(10.1): ~F?" (array-interp v0 10.1)))
      (let ((var (catch #t (lambda () (array-interp v0 1 -10)) (lambda args args))))
	(if (not (eq? (car var) 'out-of-range))
	    (snd-display #__line__ ";array-interp bad index: ~A" var))))
    
    (let ((ind (open-sound "oboe.snd")))
      (let ((diff (array-interp-sound-diff ind 0)))
	(if (> diff .00001) (snd-display #__line__ ";array-interp-sound-diff: ~A" diff)))
      (close-sound ind))
    
    (let ((v0 (make-float-vector 10)))
      (do ((i 0 (+ i 1))) ((= i 10))
	(set! (v0 i) i))
      (let ((val (mus-interpolate mus-interp-linear 1.5 v0)))
	(if (fneq val 1.5) (snd-display #__line__ ";mus-interpolate linear: ~A" val))
	(set! val (mus-interpolate mus-interp-all-pass 1.5 v0))
	(if (fneq val 1.5) (snd-display #__line__ ";mus-interpolate all-pass: ~A" val))
	(set! val (mus-interpolate mus-interp-none 1.5 v0))
	(if (fneq val 1.0) (snd-display #__line__ ";mus-interpolate none: ~A" val))
	(set! val (mus-interpolate mus-interp-hermite 1.5 v0))
	(if (fneq val 1.5) (snd-display #__line__ ";mus-interpolate hermite: ~A" val))
	(set! val (mus-interpolate mus-interp-bezier 1.5 v0))
	(if (fneq val 1.5) (snd-display #__line__ ";mus-interpolate bezier: ~A" val))
	(set! val (mus-interpolate mus-interp-lagrange 1.5 v0))
	(if (fneq val 1.5) (snd-display #__line__ ";mus-interpolate lagrange: ~A" val))
	(do ((i 0 (+ i 1))) ((= i 10)) (set! (v0 i) (sin (* pi (/ i 5)))))
	(set! val (mus-interpolate mus-interp-linear 1.5 v0))
	(if (fneq val 0.7694) (snd-display #__line__ ";mus-interpolate linear sin: ~A" val))
	(set! val (mus-interpolate mus-interp-all-pass 1.5 v0))
	(if (fneq val 0.7694) (snd-display #__line__ ";mus-interpolate all-pass sin: ~A" val))
	(set! val (mus-interpolate mus-interp-none 1.5 v0))
	(if (fneq val 0.5877) (snd-display #__line__ ";mus-interpolate none sin: ~A" val))
	(set! val (mus-interpolate mus-interp-hermite 1.5 v0))
	(if (fneq val 0.8061) (snd-display #__line__ ";mus-interpolate hermite sin: ~A" val))
	(set! val (mus-interpolate mus-interp-bezier 1.5 v0))
	(if (fneq val 0.6959) (snd-display #__line__ ";mus-interpolate bezier sin: ~A" val))
	(set! val (mus-interpolate mus-interp-lagrange 1.5 v0))
	(if (fneq val 0.7975) (snd-display #__line__ ";mus-interpolate lagrange sin: ~A" val))))
    
    (let ((tag (catch #t (lambda () (mus-interpolate 1234 1.0 (make-float-vector 3))) (lambda args (car args)))))
      (if (not (eq? tag 'out-of-range))
	  (snd-display #__line__ ";mus-interpolate 1234: ~A" tag)))
    (let ((tag (catch #t (lambda () (mus-interpolate mus-interp-linear 1.0 (make-float-vector 3) -1)) (lambda args (car args)))))
      (if (not (eq? tag 'out-of-range))
	  (snd-display #__line__ ";mus-interpolate size -1: ~A" tag)))
    
    (let ((gen (make-delay 3))
	  (gen2 (make-delay 3))
	  (gen1 (make-delay 4 :initial-contents '(1.0 0.5 0.25 0.0)))
	  (gen3 (make-delay 4 :initial-contents (float-vector 1.0 0.5 0.25 0.0)))
	  (v0 (make-float-vector 10))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "delay" 
		       "delay line[3, step]: [0 0 0]")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (delay gen i)))
      (let ((k 0)) (fill-float-vector v1 (let ((val (if (delay? gen2) (delay gen2 k) -1.0))) (set! k (+ k 1)) val)))
      (if (not (vequal v1 v0)) (snd-display #__line__ ";map delay: ~A ~A" v0 v1))
      (if (not (delay? gen)) (snd-display #__line__ ";~A not delay?" gen))
      (if (not (= (mus-length gen) 3)) (snd-display #__line__ ";delay length: ~D?" (mus-length gen)))
      (if (or (fneq (v0 1) 0.0) (fneq (v0 4) 1.0) (fneq (v0 8) 5.0))
	  (snd-display #__line__ ";delay output: ~A" v0))
      (if (or (fneq (delay gen1) 1.0) 
	      (fneq (delay gen1) 0.5)
	      (fneq (delay gen1) 0.25)
	      (fneq (delay gen1) 0.0)
	      (fneq (delay gen1) 0.0))
	  (snd-display #__line__ ";delay with list initial-contents confused"))
      (if (or (fneq (delay gen3) 1.0) 
	      (fneq (delay gen3) 0.5)
	      (fneq (delay gen3) 0.25)
	      (fneq (delay gen3) 0.0)
	      (fneq (delay gen3) 0.0))
	  (snd-display #__line__ ";delay with float-vector initial-contents confused"))
      (let ((var (catch #t (lambda () (make-delay :size #f)) (lambda args args))))
	(if (not (eq? (car var) 'wrong-type-arg))
	    (snd-display #__line__ ";make-delay bad size #f: ~A" var)))
      (let ((var (catch #t (lambda () (make-delay 3 :initial-element (make-oscil))) (lambda args args))))
	(if (not (eq? (car var) 'wrong-type-arg))
	    (snd-display #__line__ ";make-delay bad initial element: ~A" var)))
      (let ((var (catch #t (lambda () (make-delay -3)) (lambda args args))))
	(if (not (eq? (car var) 'out-of-range))
	    (snd-display #__line__ ";make-delay bad size: ~A" var))))
    
    (test-gen-equal (let ((d1 (make-delay 3))) (delay d1 1.0) d1) 
		    (let ((d2 (make-delay 3))) (delay d2 1.0) d2)
		    (let ((d3 (make-delay 4))) (delay d3 1.0) d3))
    (test-gen-equal (make-delay 3 :initial-element 1.0) (make-delay 3 :initial-element 1.0) (make-delay 3 :initial-element 0.5))
    (test-gen-equal (make-delay 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-delay 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-delay 3 :initial-contents '(1.0 1.0 1.0)))
    
    (let ((gen (make-delay 5)))
      (delay gen 1.0)
      (delay gen 0.0)
      (delay gen 0.5)
      (let ((data (copy (mus-data gen))))
	(float-vector-set! (mus-data gen) 0 0.3)
	(if (fneq ((mus-data gen) 0) 0.3)
	    (snd-display #__line__ ";delay data 0: ~A" ((mus-data gen) 0)))
	(set! (data 0) .75)
	(set! (mus-data gen) data)
	(if (fneq ((mus-data gen) 0) 0.75)
	    (snd-display #__line__ ";delay set data 0: ~A" ((mus-data gen) 0)))
	(delay gen 0.0)
	(delay gen 0.0)
	(let ((val (delay gen 0.0)))
	  (if (fneq val 0.75)
	      (snd-display #__line__ ";set delay data: ~A ~A" val (mus-data gen)))))
      (if (mus-data (make-oscil))
	  (snd-display #__line__ ";mus-data osc: ~A" (mus-data (make-oscil)))))
    
    (let ((del (make-delay 5 :max-size 8)))
      (delay del 1.0)
      (do ((i 0 (+ i 1))) ((= i 4)) (delay del 0.0))
      (let ((v0 (make-float-vector 5)))
	(do ((i 0 (+ i 1)))
	    ((= i 5))
	  (set! (v0 i) (delay del 0.0 0.4)))
	(if (not (vequal v0 (float-vector 0.600 0.400 0.000 0.000 0.000)))
	    (snd-display #__line__ ";zdelay: ~A" v0))
	(delay del 1.0)
	(delay del 0.0 0.4)
	(if (not (string=? (mus-describe del) "delay line[5,8, linear]: [0 0 1 0 0]"))
	    (snd-display #__line__ ";describe zdelay: ~A" (mus-describe del)))))
    (let ((tag (catch #t (lambda () 
			   (let ((gen (make-oscil)))
			     (tap gen)))
		      (lambda args (car args)))))
      (if (not (eq? tag 'wrong-type-arg))
	  (snd-display #__line__ ";tap of oscil: ~A" tag)))
    
    (let ((dly (make-delay 3))
	  (flt (make-one-zero .5 .4))
	  (v (make-float-vector 20))
	  (inval 1.0))
      (fill-float-vector v (let ((res (delay dly (+ inval (* (one-zero flt (tap dly)) .6)))))
		    (set! inval 0.0)
		    res))
      (if (not (vequal v (float-vector 0.0 0.0 0.0 1.0 0.0 0.0 0.300 0.240 0.0 0.090 0.144 0.058 0.027 0.065 0.052 0.022 0.026 0.031 0.019 0.013)))
	  (snd-display #__line__ ";tap with low pass: ~A" v)))
    
    (let ((dly (make-delay 3))
	  (v (make-float-vector 20))
	  (inval 1.0))
      (fill-float-vector v (let ((res (delay dly (+ inval (tap dly)))))
		    (set! inval 0.0)
		    res))
      (if (not (vequal v (float-vector 0.0 0.0 0.0 1.0 0.0 0.0 1.0 0.0 0.0 1.0 0.0 0.0 1.0 0.0 0.0 1.0 0.0 0.0 1.0 0.0)))
	  (snd-display #__line__ ";simple tap: ~A" v)))
    
    (let ((dly (make-delay 6))
	  (v (make-float-vector 20))
	  (inval 1.0))
      (if (not (tap? dly)) (snd-display #__line__ ";tap?: ~A" (tap? dly)))
      (fill-float-vector v (let ((res (delay dly (+ inval (tap dly -2.0)))))
		    (set! inval 0.0)
		    res))
      (set! *print-length* (max 20 *print-length*))
      (if (not (vequal v (float-vector 0.0 0.0 0.0 0.0 0.0 0.0 1.0 0.0 0.0 0.0 1.0 0.0 0.0 0.0 1.0 0.0 0.0 0.0 1.0 0.0)))
	  (snd-display #__line__ ";tap back 2: ~A" v)))
    
    (let ((dly (make-delay 3))
	  (flt (make-one-zero .5 .4))
	  (v (make-float-vector 20))
	  (inval 1.0))
      (do ((i 0 (+ i 1)))
	  ((= i 20))
	(set! (v i) (let ((res (delay dly (+ inval (* (one-zero flt (tap dly)) .6)))))
		      (set! inval 0.0)
		      res)))
      (if (not (vequal v (float-vector 0.0 0.0 0.0 1.0 0.0 0.0 0.300 0.240 0.0 0.090 0.144 0.058 0.027 0.065 0.052 0.022 0.026 0.031 0.019 0.013)))
	  (snd-display #__line__ ";tap with low pass: ~A" v)))
    
    (let ((dly (make-delay 3 :initial-element 32.0)))
      (if (not (float-vector? (mus-data dly))) 
	  (snd-display #__line__ ";delay data not float-vector?")
	  (if (not (= (length (mus-data dly)) 3))
	      (snd-display #__line__ ";delay data len not 3: ~A (~A)" (length (mus-data dly)) (mus-data dly))
	      (if (fneq ((mus-data dly) 1) 32.0) (snd-display #__line__ ";delay [1] 32: ~A" ((mus-data dly) 1)))))
      (let ((tag (catch #t (lambda () (set! (mus-length dly) -1)) (lambda args (car args)))))
	(if (not (eq? tag 'out-of-range)) (snd-display #__line__ ";len to -1 -> ~A" tag)))
      (let ((tag (catch #t (lambda () (set! (mus-length dly) 0)) (lambda args (car args)))))
	(if (not (eq? tag 'out-of-range)) (snd-display #__line__ ";len to 0 -> ~A" tag)))
      (let ((tag (catch #t (lambda () (set! (mus-length dly) 100)) (lambda args (car args)))))
	(if (not (eq? tag 'out-of-range)) (snd-display #__line__ ";len to 100 -> ~A" tag)))
      (let ((tag (catch #t (lambda () (set! ((mus-data dly) 100) .1)) (lambda args (car args)))))
	(if (not (eq? tag 'out-of-range)) (snd-display #__line__ ";data 100 to .1 -> ~A" tag)))
      (let ((data (make-float-vector 32 1.0)))
	(set! (mus-data dly) data)
	(if (not (float-vector? (mus-data dly))) (snd-display #__line__ ";set delay data not float-vector?"))
	(if (fneq ((mus-data dly) 1) 1.0) (snd-display #__line__ ";set delay [1] 1: ~A" ((mus-data dly) 1)))
	(if (not (= (length (mus-data dly)) 32)) (snd-display #__line__ ";set delay data len(32): ~A" (length (mus-data dly))))
	(let ((tag (catch #t (lambda () (set! (mus-length dly) 100)) (lambda args (car args)))))
	  (if (not (eq? tag 'out-of-range)) (snd-display #__line__ ";set len to 100 -> ~A" tag)))
	(let ((tag (catch #t (lambda () (set! ((mus-data dly) 100) .1)) (lambda args (car args)))))
	  (if (not (eq? tag 'out-of-range)) (snd-display #__line__ ";set data 100 to .1 -> ~A" tag)))))
    
    (let ((d1 (make-delay 4))
	  (d2 (make-delay 4 :max-size 5 :type mus-interp-linear))
	  (d3 (make-delay 4 :max-size 5 :type mus-interp-all-pass))
	  (d4 (make-delay 4 :max-size 5 :type mus-interp-none))
	  (d5 (make-delay 4 :max-size 4 :type mus-interp-lagrange))
	  (d6 (make-delay 4 :max-size 4 :type mus-interp-hermite))
	  (d7 (make-delay 4 :max-size 4 :type mus-interp-linear))
	  (v1 (make-float-vector 20))
	  (v2 (make-float-vector 20))
	  (v3 (make-float-vector 20))
	  (v4 (make-float-vector 20))
	  (v5 (make-float-vector 20))
	  (v6 (make-float-vector 20))
	  (v7 (make-float-vector 20)))
      (if (not (= (mus-interp-type d1) mus-interp-none)) (snd-display #__line__ ";d1 interp type: ~A" (mus-interp-type d1)))
      (if (not (= (mus-interp-type d2) mus-interp-linear)) (snd-display #__line__ ";d2 interp type: ~A" (mus-interp-type d2)))
      (if (not (= (mus-interp-type d3) mus-interp-all-pass)) (snd-display #__line__ ";d3 interp type: ~A" (mus-interp-type d3)))
      (if (not (= (mus-interp-type d4) mus-interp-none)) (snd-display #__line__ ";d4 interp type: ~A" (mus-interp-type d4)))
      (if (not (= (mus-interp-type d5) mus-interp-lagrange)) (snd-display #__line__ ";d5 interp type: ~A" (mus-interp-type d5)))
      (if (not (= (mus-interp-type d6) mus-interp-hermite)) (snd-display #__line__ ";d6 interp type: ~A" (mus-interp-type d6)))
      (if (not (= (mus-interp-type d7) mus-interp-linear)) (snd-display #__line__ ";d7 interp type: ~A" (mus-interp-type d7)))
      (set! (v1 0) (delay d1 1.0))
      (set! (v2 0) (delay d2 1.0))
      (set! (v3 0) (delay d3 1.0))
      (set! (v4 0) (delay d4 1.0))
      (set! (v5 0) (delay d5 1.0))
      (set! (v6 0) (delay d6 1.0))
      (set! (v7 0) (delay d7 1.0))
      (delay-tick d1 0.0)
      (delay-tick d2 0.0)
      (delay-tick d3 0.0)
      (delay-tick d4 0.0)
      (delay-tick d5 0.0)
      (delay-tick d6 0.0)
      (delay-tick d7 0.0)
      (do ((i 1 (+ i 1))
	   (j -0.2 (- j 0.2)))
	  ((= i 20))
	(set! (v1 i) (tap d1 j))
	(set! (v2 i) (tap d2 j))
	(set! (v3 i) (tap d3 j))
	(set! (v4 i) (tap d4 j))
	(set! (v5 i) (tap d5 j))
	(set! (v6 i) (tap d6 j))
	(set! (v7 i) (tap d7 j)))
      (set! *print-length* (max 20 *print-length*))
      (if (and (not (vequal v1 (float-vector 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0)))
	       (not (vequal v1 (float-vector 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0))))
	  (snd-display #__line__ ";delay interp none (1): ~A" v1))
      (if (not (vequal v2 (float-vector 0.0 0.0 0.0 0.0 0.0 0.0 0.200 0.400 0.600 0.800 1.0 0.800 0.600 0.400 0.200 0.0 0.0 0.0 0.0 0.0)))
	  (snd-display #__line__ ";delay interp linear (2): ~A" v2))
      (if (not (vequal v3 (float-vector 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.600 0.160 0.168 -0.168 0.334 0.199 0.520 0.696 -0.696 0.557 -0.334 0.134 -0.027)))
	  (snd-display #__line__ ";delay interp all-pass (3): ~A" v3))
      (if (and (not (vequal v4 (float-vector 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0)))
	       (not (vequal v4 (float-vector 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0))))
	  (snd-display #__line__ ";delay interp none (4): ~A" v4))
      (if (not (vequal v5 (float-vector 0.0 0.0 0.0 0.0 0.0 0.0 0.120 0.280 0.480 0.720 1.000 0.960 0.840 0.640 0.360 0.000 -0.080 -0.120 -0.120 -0.080)))
	  (snd-display #__line__ ";delay interp lagrange (5): ~A" v5))
      (if (not (vequal v6 (float-vector 0.0 -0.016 -0.048 -0.072 -0.064 0.0 0.168 0.424 0.696 0.912 1.0 0.912 0.696 0.424 0.168 0.0 -0.064 -0.072 -0.048 -0.016)))
	  (snd-display #__line__ ";delay interp hermite (6): ~A" v6))
      (if (not (vequal v7 (float-vector 0.0 0.0 0.0 0.0 0.0 0.0 0.200 0.400 0.600 0.800 1.0 0.800 0.600 0.400 0.200 0.0 0.0 0.0 0.0 0.0)))
	  (snd-display #__line__ ";delay interp linear (7): ~A" v7)))
    
    (let ((dly1 (make-delay :size 2 :max-size 3))
	  (data (make-float-vector 5))
	  (impulse 1.0))
      (do ((i 0 (+ i 1)))
	  ((= i 5))
	(set! (data i) (delay dly1 impulse 0.4)) ; longer line
	(set! impulse 0.0))
      (if (not (vequal data (float-vector 0.0 0.0 0.6 0.4 0.0)))
	  (snd-display #__line__ ";delay size 2, max 3, off 0.4: ~A" data))
      
      (set! dly1 (make-delay :size 2 :max-size 3))
      (set! impulse 1.0)
      (do ((i 0 (+ i 1)))
	  ((= i 5))
	(set! (data i) (delay dly1 impulse -0.4)) ; shorter line
	(set! impulse 0.0))
      (if (not (vequal data (float-vector 0.0 0.4 0.6 0.0 0.0)))
	  (snd-display #__line__ ";delay size 2, max 3, off -0.4: ~A" data))
      
      (set! dly1 (make-delay :size 1 :max-size 2))
      (set! impulse 1.0)
      (do ((i 0 (+ i 1)))
	  ((= i 5))
	(set! (data i) (delay dly1 impulse 0.4))
	(set! impulse 0.0))
      (if (not (vequal data (float-vector 0.0 0.6 0.4 0.0 0.0)))
	  (snd-display #__line__ ";delay size 1, max 2, off 0.4: ~A" data))
      
      (set! dly1 (make-delay :size 0 :max-size 1))
      (set! impulse 1.0)
      (do ((i 0 (+ i 1)))
	  ((= i 5))
	(set! (data i) (delay dly1 impulse 0.4))
	(set! impulse 0.0))
      (if (not (vequal data (float-vector 0.6 0.4 0.0 0.0 0.0)))
	  (snd-display #__line__ ";delay size 0, max 1, off 0.4: ~A" data))
      
      (set! dly1 (make-delay :size 0 :max-size 1))
      (let ((val (delay dly1 0.0)))
	(if (fneq val 0.0) (snd-display #__line__ ";initial delay 0 size val: ~A" val)))
      
      (set! dly1 (make-delay :size 0 :max-size 1))
      (set! impulse 1.0)
      (do ((i 0 (+ i 1)))
	  ((= i 5))
	(set! (data i) (delay dly1 impulse -0.4)) ; shorter than 0? should this be an error?
	(set! impulse 0.0))
      (if (not (vequal data (float-vector 1.4 -0.4 0.0 0.0 0.0))) ; hmmm -- they're asking for undefined values here 
	  (snd-display #__line__ ";delay size 0, max 1, off -0.4: ~A" data))
      
      (set! dly1 (make-delay 0))
      (set! impulse 1.0)
      (do ((i 0 (+ i 1)))
	  ((= i 5))
	(set! (data i) (delay dly1 impulse)) 
	(set! impulse 0.0))
      (if (not (vequal data (float-vector 1 0 0 0 0)))
	  (snd-display #__line__ ";delay size 0: ~A" data))
      (let ((x (delay dly1 0.5)))
	(if (fneq x 0.5)
	    (snd-display #__line__ ";delay size 0 0.5: ~A" x)))
      )
    
    (let ((gen (make-delay :size 0 :max-size 100))
	  (v (make-float-vector 10)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v i) (delay gen 0.5 i)))
      (if (not (vequal v (float-vector 0.500 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";delay 0 -> 100: ~A" v))
      (do ((i 9 (- i 1)))
	  ((< i 0))
	(set! (v i) (delay gen 0.5 i)))
      (if (not (vequal v (float-vector 0.500 0.500 0.500 0.500 0.500 0.500 0.500 0.500 0.500 0.500)))
	  (snd-display #__line__ ";delay 100 -> 0: ~A" v))
      (mus-reset gen)
      (if (not (vequal (mus-data gen) (make-float-vector 100 0.0)))
	  (snd-display #__line__ ";after reset mus-data delay peak: ~A" (float-vector-peak (mus-data gen))))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v i) (delay gen (if (odd? i) 1.0 0.0) (* i .1))))
      (if (not (vequal v (float-vector 0.000 0.900 0.000 0.700 0.000 0.500 0.000 0.300 0.000 0.100)))
	  (snd-display #__line__ ";delay 0 -> 100 .1: ~A (~A)" v gen))
      (mus-reset gen)
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v i) (delay gen (if (odd? i) 1.0 0.0) (+ 1.0 (* i .1)))))
      (if (not (vequal v (float-vector 0.000 0.000 0.800 0.300 0.600 0.500 0.400 0.700 0.200 0.900)))
	  (snd-display #__line__ ";delay 0 -> 100 1.1: ~A" v)))
    
    
    (let ((gen (make-all-pass .4 .6 3))
	  (v0 (make-float-vector 10))
	  (gen1 (make-all-pass .4 .6 3))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "all-pass"
		       "all-pass feedback: 0.400, feedforward: 0.600, line[3, step]:[0 0 0]")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (all-pass gen 1.0)))
      (fill-float-vector v1 (if (all-pass? gen1) (all-pass gen1 1.0) -1.0))
      (if (not (vequal v1 v0)) (snd-display #__line__ ";map all-pass: ~A ~A" v0 v1))
      (if (not (all-pass? gen)) (snd-display #__line__ ";~A not all-pass?" gen))
      (if (not (= (mus-length gen) 3)) (snd-display #__line__ ";all-pass length: ~D?" (mus-length gen)))
      (if (not (= (mus-order gen) 3)) (snd-display #__line__ ";all-pass order: ~D?" (mus-order gen)))
      (if (fneq (mus-feedback gen) .4) (snd-display #__line__ ";all-pass feedback: ~F?" (mus-feedback gen)))
      (if (fneq (mus-feedforward gen) .6) (snd-display #__line__ ";all-pass feedforward: ~F?" (mus-feedforward gen)))
      (if (or (fneq (v0 1) 0.6) (fneq (v0 4) 1.84) (fneq (v0 8) 2.336))
	  (snd-display #__line__ ";all-pass output: ~A" v0))
      (set! (mus-feedback gen) 0.5) 
      (if (fneq (mus-feedback gen) .5) (snd-display #__line__ ";all-pass set-feedback: ~F?" (mus-feedback gen)))
      (set! (mus-feedforward gen) 0.5) 
      (if (fneq (mus-feedforward gen) .5) (snd-display #__line__ ";all-pass set-feedforward: ~F?" (mus-feedforward gen))))
    
    (test-gen-equal (let ((d1 (make-all-pass 0.7 0.5 3))) (all-pass d1 1.0) d1)
		    (let ((d2 (make-all-pass 0.7 0.5 3))) (all-pass d2 1.0) d2) 
		    (let ((d3 (make-all-pass 0.7 0.5 4))) (all-pass d3 1.0) d3))
    (test-gen-equal (make-all-pass 0.7 0.5 3 :initial-element 1.0) 
		    (make-all-pass 0.7 0.5 3 :initial-element 1.0) 
		    (make-all-pass 0.7 0.5 3 :initial-element 0.5))
    (test-gen-equal (make-all-pass 0.7 0.5 3 :initial-element 1.0) 
		    (make-all-pass 0.7 0.5 3 :initial-element 1.0) 
		    (make-all-pass 0.5 0.5 3 :initial-element 1.0))
    (test-gen-equal (make-all-pass 0.7 0.5 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-all-pass 0.7 0.5 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-all-pass 0.7 0.5 3 :initial-contents '(1.0 1.0 1.0)))
    (let ((err (catch #t (lambda () (make-all-pass :feedback .2 :feedforward .1 :size -1)) (lambda args args))))
      (if (not (eq? (car err) 'out-of-range))
	  (snd-display #__line__ ";make-all-pass bad size error message: ~A" err)))
    
    (let ((gen (make-moving-average 4))
	  (v0 (make-float-vector 10))
	  (gen1 (make-moving-average 4))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "moving-average"
		       "moving-average 0.000, line[4]:[0 0 0 0]")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (moving-average gen 1.0)))
      (fill-float-vector v1 (if (moving-average? gen1) (moving-average gen1 1.0) -1.0))
      (if (not (vequal v1 v0)) (snd-display #__line__ ";map average: ~A ~A" v0 v1))
      (if (not (moving-average? gen)) (snd-display #__line__ ";~A not average?" gen))
      (if (not (= (mus-length gen) 4)) (snd-display #__line__ ";average length: ~D?" (mus-length gen)))
      (if (not (= (mus-order gen) 4)) (snd-display #__line__ ";average order: ~D?" (mus-order gen)))
      (if (or (fneq (v0 1) 0.5) (fneq (v0 4) 1.0) (fneq (v0 8) 1.0))
	  (snd-display #__line__ ";average output: ~A" v0)))
    
    (let* ((gen (make-moving-average 8))
	   (val (moving-average gen)))
      (if (fneq val 0.0) (snd-display #__line__ ";empty average: ~A" val))
      (set! val (moving-average gen 1.0))
      (if (fneq val 0.125) (snd-display #__line__ ";average 1: ~A" val))
      (set! val (moving-average gen 1.0))
      (if (fneq val 0.25) (snd-display #__line__ ";average 2: ~A" val))
      (set! val (moving-average gen 0.5))
      (if (fneq val 0.3125) (snd-display #__line__ ";average 2: ~A" val))
      (do ((i 0 (+ i 1))) ((= i 5)) (set! val (moving-average gen 0.0))) 
      (if (fneq val 0.3125) (snd-display #__line__ ";average 6: ~A" val))
      (set! val (moving-average gen 0.0))
      (if (fneq val 0.1875) (snd-display #__line__ ";average 7: ~A" val))
      (set! val (moving-average gen 0.0))
      (if (fneq val 0.0625) (snd-display #__line__ ";average 8: ~A" val))
      (set! val (moving-average gen 0.0))
      (if (fneq val 0.0) (snd-display #__line__ ";average 9: ~A" val))
      )
    (let* ((gen (make-moving-average 10 :initial-element .5))
	   (val (moving-average gen 0.5)))
      (if (fneq val 0.5) (snd-display #__line__ ";average initial-element: ~A" val)))
    (let* ((gen (make-moving-average 3 :initial-contents '(1.0 1.0 1.0)))
	   (val (moving-average gen 1.0)))
      (if (fneq val 1.0) (snd-display #__line__ ";average initial-contents: ~A" val)))
    
    (test-gen-equal (let ((d1 (make-moving-average 3 :initial-contents '(0.7 0.5 3)))) (moving-average d1 1.0) d1)
		    (let ((d2 (make-moving-average 3 :initial-contents (float-vector 0.7 0.5 3)))) (moving-average d2 1.0) d2) 
		    (let ((d3 (make-moving-average 4 :initial-contents '(0.7 0.5 0.1 4)))) (moving-average d3 1.0) d3))
    (test-gen-equal (make-moving-average 3 :initial-element 1.0) 
		    (make-moving-average 3 :initial-element 1.0) 
		    (make-moving-average 3 :initial-element 0.5))
    (test-gen-equal (make-moving-average 3 :initial-element 1.0) 
		    (make-moving-average 3 :initial-element 1.0) 
		    (make-moving-average 4 :initial-element 1.0))
    (test-gen-equal (make-moving-average 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-moving-average 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-moving-average 3 :initial-contents '(1.0 1.0 1.0)))
    (let ((err (catch #t (lambda () (make-moving-average :size -1)) (lambda args args))))
      (if (not (eq? (car err) 'out-of-range))
	  (snd-display #__line__ ";make-average bad size error message: ~A" err)))
    (let ((err (catch #t (lambda () (make-moving-average :size 0)) (lambda args args))))
      (if (not (eq? (car err) 'out-of-range))
	  (snd-display #__line__ ";make-average size==0 error message: ~A" err)))

    (let ((gen (make-moving-max 4))
	  (v0 (make-float-vector 10))
	  (gen1 (make-moving-max 4))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "moving-max"
		       "moving-max 0.000, line[4]:[0 0 0 0]")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (moving-max gen 1.0)))
      (fill-float-vector v1 (if (moving-max? gen1) (moving-max gen1 1.0) -1.0))
      (if (not (vequal v1 v0)) (snd-display #__line__ ";map max: ~A ~A" v0 v1))
      (if (not (moving-max? gen)) (snd-display #__line__ ";~A not max?" gen))
      (if (not (= (mus-length gen) 4)) (snd-display #__line__ ";max length: ~D?" (mus-length gen)))
      (if (not (= (mus-order gen) 4)) (snd-display #__line__ ";max order: ~D?" (mus-order gen)))
      (if (or (fneq (v0 1) 1.0) (fneq (v0 4) 1.0) (fneq (v0 8) 1.0))
	  (snd-display #__line__ ";max output: ~A" v0)))
    
    (let* ((gen (make-moving-max 8))
	   (val (moving-max gen)))
      (if (fneq val 0.0) (snd-display #__line__ ";empty max: ~A" val))
      (set! val (moving-max gen 1.0))
      (if (fneq val 1.0) (snd-display #__line__ ";max 1: ~A" val))
      (set! val (moving-max gen -0.5))
      (if (fneq val 1.0) (snd-display #__line__ ";max 2: ~A" val))
      (set! val (moving-max gen -1.5))
      (if (fneq val 1.5) (snd-display #__line__ ";max 2: ~A" val))
      (do ((i 0 (+ i 1))) ((= i 5)) (set! val (moving-max gen 0.0))) 
      (if (fneq val 1.5) (snd-display #__line__ ";max 6: ~A" val))
      (set! val (moving-max gen 0.0))
      (if (fneq val 1.5) (snd-display #__line__ ";max 7: ~A" val))
      (set! val (moving-max gen 0.0))
      (if (fneq val 1.5) (snd-display #__line__ ";max 8: ~A" val))
      (set! val (moving-max gen 0.0))
      (if (fneq val 0.0) (snd-display #__line__ ";max 9: ~A" val))
      )
    (let* ((gen (make-moving-max 10 :initial-element .5))
	   (val (moving-max gen 0.5)))
      (if (fneq val 0.5) (snd-display #__line__ ";max initial-element: ~A" val)))
    (let* ((gen (make-moving-max 3 :initial-contents '(1.0 1.0 1.0)))
	   (val (moving-max gen 1.0)))
      (if (fneq val 1.0) (snd-display #__line__ ";max initial-contents: ~A" val)))
    
    (test-gen-equal (let ((d1 (make-moving-max 3 :initial-contents '(0.7 0.5 3)))) (moving-max d1 1.0) d1)
		    (let ((d2 (make-moving-max 3 :initial-contents (float-vector 0.7 0.5 3)))) (moving-max d2 1.0) d2) 
		    (let ((d3 (make-moving-max 4 :initial-contents '(0.7 0.5 0.1 4)))) (moving-max d3 1.0) d3))
    (test-gen-equal (make-moving-max 3 :initial-element 1.0) 
		    (make-moving-max 3 :initial-element 1.0) 
		    (make-moving-max 3 :initial-element 0.5))
    (test-gen-equal (make-moving-max 3 :initial-element 1.0) 
		    (make-moving-max 3 :initial-element 1.0) 
		    (make-moving-max 4 :initial-element 1.0))
    (test-gen-equal (make-moving-max 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-moving-max 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-moving-max 3 :initial-contents '(1.0 1.0 1.0)))
    (let ((err (catch #t (lambda () (make-moving-max :size -1)) (lambda args args))))
      (if (not (eq? (car err) 'out-of-range))
	  (snd-display #__line__ ";make-max bad size error message: ~A" err)))
    (let ((err (catch #t (lambda () (make-moving-max :size 0)) (lambda args args))))
      (if (not (eq? (car err) 'out-of-range))
	  (snd-display #__line__ ";make-max size==0 error message: ~A" err)))

    (let ((gen (make-moving-norm 4))
	  (v0 (make-float-vector 10))
	  (gen1 (make-moving-norm 4))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "moving-norm"
		       "moving-norm, max 0.000, y1 5.000, weight 0.800, line[4]:[0 0 0 0]")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (moving-norm gen 1.0)))
      (fill-float-vector v1 (if (moving-norm? gen1) (moving-norm gen1 1.0) -1.0))
      (if (not (vequal v1 v0)) (snd-display #__line__ ";map norm: ~A ~A" v0 v1))
      (if (not (moving-norm? gen)) (snd-display #__line__ ";~A not norm?" gen))
      (if (not (= (mus-length gen) 4)) (snd-display #__line__ ";norm length: ~D?" (mus-length gen)))
      (if (not (= (mus-order gen) 4)) (snd-display #__line__ ";norm order: ~D?" (mus-order gen))))
    
    (let* ((gen (make-moving-norm 8))
	   (val (moving-norm gen)))
      (if (fneq val 1.1236) (snd-display #__line__ ";empty norm: ~A" val))
      (set! val (moving-norm gen 1.0))
      (if (fneq val 1.1084) (snd-display #__line__ ";norm 1: ~A" val))
      (set! val (moving-norm gen -0.5))
      (if (fneq val 1.0952) (snd-display #__line__ ";norm 2: ~A" val))
      (set! val (moving-norm gen -1.5))
      (if (fneq val 1.0222) (snd-display #__line__ ";norm 2: ~A" val))
      (do ((i 0 (+ i 1))) ((= i 5)) (set! val (moving-norm gen 0.0))) 
      (if (fneq val 0.8261) (snd-display #__line__ ";norm 6: ~A" val))
      (set! val (moving-norm gen 0.0))
      (if (fneq val 0.8047) (snd-display #__line__ ";norm 7: ~A" val))
      (set! val (moving-norm gen 0.0))
      (if (fneq val 0.7866) (snd-display #__line__ ";norm 8: ~A" val))
      (set! val (moving-norm gen 0.0))
      (if (fneq val 0.8841) (snd-display #__line__ ";norm 9: ~A" val))
      )
    (let* ((gen (make-moving-norm 10 :initial-element .5))
	   (val (moving-norm gen 0.5)))
      (if (fneq val 1.0476) (snd-display #__line__ ";norm initial-element: ~A" val)))
    (let* ((gen (make-moving-norm 3 :initial-contents '(1.0 1.0 1.0)))
	   (val (moving-norm gen 1.0)))
      (if (fneq val 1.0) (snd-display #__line__ ";norm initial-contents: ~A" val)))
    
    (test-gen-equal (let ((d1 (make-moving-norm 3))) (moving-norm d1 1.0) d1)
		    (let ((d2 (make-moving-norm 3))) (moving-norm d2 1.0) d2) 
		    (let ((d3 (make-moving-norm 4))) (moving-norm d3 1.0) d3))
    (test-gen-equal (make-moving-norm 3 :scaler 1.0) 
		    (make-moving-norm 3 :scaler 1.0) 
		    (make-moving-norm 4 :scaler 1.0))
    (let ((err (catch #t (lambda () (make-moving-norm :size -1)) (lambda args args))))
      (if (not (eq? (car err) 'out-of-range))
	  (snd-display #__line__ ";make-norm bad size error message: ~A" err)))
    (let ((err (catch #t (lambda () (make-moving-norm :size 0)) (lambda args args))))
      (if (not (eq? (car err) 'out-of-range))
	  (snd-display #__line__ ";make-norm size==0 error message: ~A" err)))


    (let ((gen (make-comb .4 3))
	  (v0 (make-float-vector 10))
	  (gen1 (make-comb .4 3))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "comb"
		       "comb scaler: 0.400, line[3, step]: [0 0 0]")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (comb gen 1.0)))
      (fill-float-vector v1 (if (comb? gen1) (comb gen1 1.0) -1.0))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map comb: ~A ~A" v0 v1))
      (if (not (comb? gen)) (snd-display #__line__ ";~A not comb?" gen))
      (if (not (= (mus-length gen) 3)) (snd-display #__line__ ";comb length: ~D?" (mus-length gen)))
      (if (not (= (mus-order gen) 3)) (snd-display #__line__ ";comb order: ~D?" (mus-order gen)))
      (if (fneq (mus-feedback gen) .4) (snd-display #__line__ ";comb feedback: ~F?" (mus-feedback gen)))
      (if (or (fneq (v0 1) 0.0) (fneq (v0 4) 1.0) (fneq (v0 8) 1.4))
	  (snd-display #__line__ ";comb output: ~A" v0)))
    
    (test-gen-equal (let ((d1 (make-comb 0.7 3))) (comb d1 1.0) d1) 
		    (let ((d2 (make-comb 0.7 3))) (comb d2 1.0) d2) 
		    (let ((d3 (make-comb 0.7 4))) (comb d3 1.0) d3))
    (test-gen-equal (make-comb 0.7 3 :initial-element 1.0) 
		    (make-comb 0.7 3 :initial-element 1.0) 
		    (make-comb 0.7 3 :initial-element 0.5))
    (test-gen-equal (make-comb 0.7 3 :initial-element 1.0) 
		    (make-comb 0.7 3 :initial-element 1.0) 
		    (make-comb 0.5 3 :initial-element 1.0))
    (test-gen-equal (make-comb 0.7 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-comb 0.7 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-comb 0.7 3 :initial-contents '(1.0 1.0 1.0)))
    
    (let ((del (make-comb 0.0 5 :max-size 8)))
      (comb del 1.0)
      (do ((i 0 (+ i 1))) ((= i 4)) (comb del 0.0))
      (let ((v0 (make-float-vector 5)))
	(do ((i 0 (+ i 1)))
	    ((= i 5))
	  (set! (v0 i) (comb del 0.0 0.4)))
	(if (not (vequal v0 (float-vector 0.600 0.400 0.000 0.000 0.000))) ; this is assuming interpolation in the delay...
	    (snd-display #__line__ ";zcomb: ~A" v0))
	(comb del 1.0)
	(comb del 0.0 0.4)
	(if (not (string=? (mus-describe del) "comb scaler: 0.000, line[5,8, linear]: [0 0 1 0 0]"))
	    (snd-display #__line__ ";describe zcomb: ~A" (mus-describe del))))
      (set! (mus-feedback del) 1.0)
      (if (fneq (mus-feedback del) 1.0)
	  (snd-display #__line__ ";comb feedback set: ~A" (mus-feedback del))))
    
    
    (let ((gen (make-filtered-comb .4 5 :filter (make-one-zero .3 .7)))
	  (v0 (make-float-vector 20)))
      (print-and-check gen 
		       "filtered-comb"
		       "filtered-comb scaler: 0.400, line[5, step]: [0 0 0 0 0], filter: [one-zero a0: 0.300, a1: 0.700, x1: 0.000]")
      (let ((val 1.0))
	(do ((i 0 (+ i 1)))
	    ((= i 20))
	  (set! (v0 i) (filtered-comb gen val))
	  (set! val 0.0)))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.120 0.280 0.000 0.000 0.000 0.014 0.067 0.078 0.000 0.000)))
	  (snd-display #__line__ ";filtered-comb: ~A" v0))
      (if (not (filtered-comb? gen)) (snd-display #__line__ ";~A not filtered-comb?" gen))
      (if (not (= (mus-length gen) 5)) (snd-display #__line__ ";filtered-comb length: ~D?" (mus-length gen)))
      (if (not (= (mus-order gen) 5)) (snd-display #__line__ ";filtered-comb order: ~D?" (mus-order gen)))
      (if (fneq (mus-feedback gen) .4) (snd-display #__line__ ";filtered-comb feedback: ~F?" (mus-feedback gen))))
    
    (let ((gen (make-filtered-comb .9 5 :filter (make-one-zero .5 .5)))
	  (v0 (make-float-vector 20)))
      (print-and-check gen 
		       "filtered-comb"
		       "filtered-comb scaler: 0.900, line[5, step]: [0 0 0 0 0], filter: [one-zero a0: 0.500, a1: 0.500, x1: 0.000]")
      (let ((val 1.0))
	(do ((i 0 (+ i 1)))
	    ((= i 20))
	  (set! (v0 i) (filtered-comb gen val))
	  (set! val 0.0)))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.450 0.450 0.000 0.000 0.000 0.202 0.405 0.202 0.000 0.000)))
	  (snd-display #__line__ ";filtered-comb .5 .5: ~A" v0)))
    
    (let ((gen (make-filtered-comb .9 5 :filter (make-fir-filter 5 (float-vector .1 .2 .3 .2 .1))))
	  (v0 (make-float-vector 20)))
      (print-and-check gen 
		       "filtered-comb"
		       "filtered-comb scaler: 0.900, line[5, step]: [0 0 0 0 0], filter: [fir-filter order: 5, xs: [0.1 0.2 0.3 0.2 0.1]]")
      (let ((val 1.0))
	(do ((i 0 (+ i 1)))
	    ((= i 20))
	  (set! (v0 i) (filtered-comb gen val))
	  (set! val 0.0)))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.090 0.180 0.270 0.180 0.090 0.008 0.032 0.081 0.130 0.154)))
	  (snd-display #__line__ ";filtered-comb fir: ~A" v0)))
    
    (test-gen-equal (let ((d1 (make-filtered-comb 0.7 3 :filter (make-one-pole .3 .7)))) (filtered-comb d1 1.0) d1) 
		    (let ((d2 (make-filtered-comb 0.7 3 :filter (make-one-pole .3 .7)))) (filtered-comb d2 1.0) d2) 
		    (let ((d3 (make-filtered-comb 0.7 4 :filter (make-one-pole .3 .7)))) (filtered-comb d3 1.0) d3))
    (test-gen-equal (make-filtered-comb 0.7 3 :initial-element 1.0 :filter (make-one-zero .5 .5)) 
		    (make-filtered-comb 0.7 3 :initial-element 1.0 :filter (make-one-zero .5 .5)) 
		    (make-filtered-comb 0.7 3 :initial-element 0.5 :filter (make-one-zero .5 .5)))
    (test-gen-equal (make-filtered-comb 0.7 3 :initial-element 1.0 :filter (make-one-zero .5 .5)) 
		    (make-filtered-comb 0.7 3 :initial-element 1.0 :filter (make-one-zero .5 .5)) 
		    (make-filtered-comb 0.7 3 :initial-element 1.0 :filter (make-one-zero .25 .75)))
    (test-gen-equal (make-filtered-comb 0.7 3 :initial-contents '(1.0 0.0 0.0) :filter (make-one-zero .5 .5)) 
		    (make-filtered-comb 0.7 3 :initial-contents '(1.0 0.0 0.0) :filter (make-one-zero .5 .5)) 
		    (make-filtered-comb 0.7 3 :initial-contents '(1.0 1.0 1.0) :filter (make-one-zero .5 .5)))
    
    (let ((del (make-filtered-comb 0.0 5 :max-size 8 :filter (make-one-zero .5 .5))))
      (filtered-comb del 1.0)
      (do ((i 0 (+ i 1))) ((= i 4)) (filtered-comb del 0.0))
      (let ((v0 (make-float-vector 5)))
	(do ((i 0 (+ i 1)))
	    ((= i 5))
	  (set! (v0 i) (filtered-comb del 0.0 0.4)))
	(if (not (vequal v0 (float-vector 0.600 0.400 0.000 0.000 0.000))) ; this is assuming interpolation in the delay...
	    (snd-display #__line__ ";zfiltered-comb: ~A" v0))
	(filtered-comb del 1.0)
	(filtered-comb del 0.0 0.4)
	(if (not (string=? (mus-describe del)
			   "filtered-comb scaler: 0.000, line[5,8, linear]: [0 0 1 0 0], filter: [one-zero a0: 0.500, a1: 0.500, x1: 0.000]"))
	    (snd-display #__line__ ";describe zfiltered-comb: ~A" (mus-describe del))))
      (set! (mus-feedback del) 1.0)
      (if (fneq (mus-feedback del) 1.0)
	  (snd-display #__line__ ";filtered-comb feedback set: ~A" (mus-feedback del))))
    
    
    (let ((gen (make-notch .4 3))
	  (v0 (make-float-vector 10))
	  (gen1 (make-notch .4 3))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "notch"
		       "notch scaler: 0.400, line[3, step]: [0 0 0]")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (notch gen 1.0)))
      (fill-float-vector v1 (if (notch? gen1) (notch gen1 1.0) -1.0))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map notch: ~A ~A" v0 v1))
      (if (not (notch? gen)) (snd-display #__line__ ";~A not notch?" gen))
      (if (not (= (mus-length gen) 3)) (snd-display #__line__ ";notch length: ~D?" (mus-length gen)))
      (if (not (= (mus-order gen) 3)) (snd-display #__line__ ";notch order: ~D?" (mus-order gen)))
      (if (fneq (mus-feedforward gen) .4) (snd-display #__line__ ";notch feedforward: ~F?" (mus-feedforward gen)))
      (if (or (fneq (v0 1) 0.4) (fneq (v0 4) 1.4) (fneq (v0 8) 1.4))
	  (snd-display #__line__ ";notch output: ~A" v0))
      (set! (mus-feedforward gen) 1.0)
      (if (fneq (mus-feedforward gen) 1.0)
	  (snd-display #__line__ ";notch feedforward set: ~A" (mus-feedforward gen))))
    
    (test-gen-equal (let ((d1 (make-notch 0.7 3))) (notch d1 1.0) d1)
		    (let ((d2 (make-notch 0.7 3))) (notch d2 1.0) d2)
		    (let ((d3 (make-notch 0.7 4))) (notch d3 1.0) d3))
    (test-gen-equal (make-notch 0.7 3 :initial-element 1.0) 
		    (make-notch 0.7 3 :initial-element 1.0) 
		    (make-notch 0.7 3 :initial-element 0.5))
    (test-gen-equal (make-notch 0.7 3 :initial-element 1.0) 
		    (make-notch 0.7 3 :initial-element 1.0) 
		    (make-notch 0.5 3 :initial-element 1.0))
    (test-gen-equal (make-notch 0.7 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-notch 0.7 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-notch 0.7 3 :initial-contents '(1.0 1.0 1.0)))
    
    ;; make sure all-pass is the same as comb/notch given the appropriate feedback/forward settings
    
    (let ((gen (make-comb 0.5 5))
	  (v0 (make-float-vector 11))
	  (in1 1.0))
      (do ((i 0 (+ i 1)))
	  ((= i 11))
	(set! (v0 i) (comb gen in1))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.500)))
	  (snd-display #__line__ ";comb (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.5 0.0 5))
	  (v0 (make-float-vector 11))
	  (in1 1.0))
      (do ((i 0 (+ i 1)))
	  ((= i 11))
	(set! (v0 i) (all-pass gen in1))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.500)))
	  (snd-display #__line__ ";all-pass (5 0 .5): ~A" v0)))
    
    (let ((gen (make-notch 0.5 5))
	  (v0 (make-float-vector 11))
	  (in1 1.0))
      (do ((i 0 (+ i 1)))
	  ((= i 11))
	(set! (v0 i) (notch gen in1))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.500 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";notch (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.0 0.5 5))
	  (v0 (make-float-vector 11))
	  (in1 1.0))
      (do ((i 0 (+ i 1)))
	  ((= i 11))
	(set! (v0 i) (all-pass gen in1))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.500 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";all-pass (5 .5 0): ~A" v0)))
    
    ;; make sure zall-pass is the same as zcomb/znotch given the appropriate feedback/forward and "pm" settings
    
    (let ((gen (make-comb 0.5 5 :max-size 20))
	  (v0 (make-float-vector 11))
	  (in1 1.0))
      (do ((i 0 (+ i 1)))
	  ((= i 11))
	(set! (v0 i) (comb gen in1))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.500)))
	  (snd-display #__line__ ";1comb (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.5 0.0 5 :max-size 20))
	  (v0 (make-float-vector 11))
	  (in1 1.0))
      (do ((i 0 (+ i 1)))
	  ((= i 11))
	(set! (v0 i) (all-pass gen in1))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.500)))
	  (snd-display #__line__ ";1all-pass (5 0 .5): ~A" v0)))
    
    (let ((gen (make-notch 0.5 5 :max-size 20))
	  (v0 (make-float-vector 11))
	  (in1 1.0))
      (do ((i 0 (+ i 1)))
	  ((= i 11))
	(set! (v0 i) (notch gen in1))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.500 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";1notch (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.0 0.5 5 :max-size 20))
	  (v0 (make-float-vector 11))
	  (in1 1.0))
      (do ((i 0 (+ i 1)))
	  ((= i 11))
	(set! (v0 i) (all-pass gen in1))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.500 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";1all-pass (5 .5 0): ~A" v0)))
    
    ;; now actually use the size difference
    
    (let ((gen (make-comb 0.5 5 :max-size 20))
	  (v0 (make-float-vector 20))
	  (in1 1.0))
      (do ((i 0 (+ i 1))
	   (phase 0.0 (+ phase .2)))
	  ((= i 20))
	(set! (v0 i) (comb gen in1 phase))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 0.800 0.400 0.000 0.000 0.000 0.000 0.000 0.160 0.360 0.200 0.040 0.000 0.000 0.000)))
	  (snd-display #__line__ ";2comb (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.5 0.0 5 :max-size 20))
	  (v0 (make-float-vector 20))
	  (in1 1.0))
      (do ((i 0 (+ i 1))
	   (angle 0.0 (+ angle .2)))
	  ((= i 20))
	(set! (v0 i) (all-pass gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 0.800 0.400 0.000 0.000 0.000 0.000 0.000 0.160 0.360 0.200 0.040 0.000 0.000 0.000)))
	  (snd-display #__line__ ";2all-pass (5 0 .5): ~A" v0)))
    
    (let ((gen (make-notch 0.5 5 :max-size 20))
	  (v0 (make-float-vector 20))
	  (in1 1.0))
      (do ((i 0 (+ i 1))
	   (angle 0.0 (+ angle .2)))
	  ((= i 20))
	(set! (v0 i) (notch gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.500 0.000 0.000 0.000 0.000 0.000 0.800 0.400 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";2notch (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.0 0.5 5 :max-size 20))
	  (v0 (make-float-vector 20))
	  (in1 1.0))
      (do ((i 0 (+ i 1))
	   (angle 0.0 (+ angle .2)))
	  ((= i 20))
	(set! (v0 i) (all-pass gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.500 0.000 0.000 0.000 0.000 0.000 0.800 0.400 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";2all-pass (5 .5 0): ~A" v0)))
    
    (let ((gen (make-comb 0.5 5 :max-size 20))
	  (v0 (make-float-vector 20))
	  (in1 1.0))
      (do ((i 0 (+ i 1))
	   (angle 0.0 (- angle .2)))
	  ((= i 20))
	(set! (v0 i) (comb gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.000 0.800 0.000 0.000 0.160 0.160 0.000 0.080 0.064 0.016 0.035 0.013 0.018 0.007 0.007 0.003 0.002)))
	  (snd-display #__line__ ";3comb (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.5 0.0 5 :max-size 20))
	  (v0 (make-float-vector 20))
	  (in1 1.0))
      (do ((i 0 (+ i 1))
	   (angle 0.0 (- angle .2)))
	  ((= i 20))
	(set! (v0 i) (all-pass gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.000 0.800 0.000 0.000 0.160 0.160 0.000 0.080 0.064 0.016 0.035 0.013 0.018 0.007 0.007 0.003 0.002)))
	  (snd-display #__line__ ";3all-pass (5 0 .5): ~A" v0)))
    
    (let ((gen (make-notch 0.5 5 :max-size 20))
	  (v0 (make-float-vector 20))
	  (in1 1.0))
      (do ((i 0 (+ i 1))
	   (angle 0.0 (- angle .2)))
	  ((= i 20))
	(set! (v0 i) (notch gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.500 0.000 0.000 0.000 0.800 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";3notch (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.0 0.5 5 :max-size 20))
	  (v0 (make-float-vector 20))
	  (in1 1.0))
      (do ((i 0 (+ i 1))
	   (angle 0.0 (- angle .2)))
	  ((= i 20))
	(set! (v0 i) (all-pass gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.500 0.000 0.000 0.000 0.800 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";3all-pass (5 .5 0): ~A" v0)))
    
    (let ((gen (make-comb 0.5 5 :max-size 20))
	  (v0 (make-float-vector 20))
	  (in1 1.0))
      (do ((i 0 (+ i 1))
	   (angle 0.0 (+ angle .01)))
	  ((= i 20))
	(set! (v0 i) (comb gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.000 0.000 0.950 0.060 0.000 0.000 0.000 0.428 0.079 0.004 0.000 0.000 0.182 0.067 0.008 0.000 0.000)))
	  (snd-display #__line__ ";4comb (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.5 0.0 5 :max-size 20))
	  (v0 (make-float-vector 20))
	  (in1 1.0))
      (do ((i 0 (+ i 1))
	   (angle 0.0 (+ angle .01)))
	  ((= i 20))
	(set! (v0 i) (all-pass gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.000 0.000 0.950 0.060 0.000 0.000 0.000 0.428 0.079 0.004 0.000 0.000 0.182 0.067 0.008 0.000 0.000)))
	  (snd-display #__line__ ";4all-pass (5 0 .5): ~A" v0)))
    
    (let ((gen (make-notch 0.5 5 :max-size 20))
	  (v0 (make-float-vector 20))
	  (in1 1.0))
      (do ((i 0 (+ i 1))
	   (angle 0.0 (+ angle .01)))
	  ((= i 20))
	(set! (v0 i) (notch gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.500 0.000 0.000 0.000 0.000 0.950 0.060 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";4notch (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.0 0.5 5 :max-size 20))
	  (v0 (make-float-vector 20))
	  (in1 1.0))
      (do ((i 0 (+ i 1))
	   (angle 0.0 (+ angle .01)))
	  ((= i 20))
	(set! (v0 i) (all-pass gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.500 0.000 0.000 0.000 0.000 0.950 0.060 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";4all-pass (5 .5 0): ~A" v0)))
    
    ;; now run off either end of the delay line "by accident"
    
    (let ((gen (make-comb 0.5 5 :max-size 10))
	  (v0 (make-float-vector 20))
	  (in1 1.0))
      (do ((i 0 (+ i 1))
	   (angle 0.0 (+ angle .5)))
	  ((= i 20))
	(set! (v0 i) (comb gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.500 1.000 0.250 0.125 0.094 0.062 0.055 0.047 0.039 0.031 0.029)))
	  (snd-display #__line__ ";5comb (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.5 0.0 5 :max-size 10))
	  (v0 (make-float-vector 20))
	  (in1 1.0))
      (do ((i 0 (+ i 1))
	   (angle 0.0 (+ angle .5)))
	  ((= i 20))
	(set! (v0 i) (all-pass gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.500 1.000 0.250 0.125 0.094 0.062 0.055 0.047 0.039 0.031 0.029)))
	  (snd-display #__line__ ";5all-pass (5 0 .5): ~A" v0)))
    
    (let ((gen (make-notch 0.5 5 :max-size 10))
	  (v0 (make-float-vector 20))
	  (in1 1.0))
      (do ((i 0 (+ i 1))
	   (angle 0.0 (+ angle .5)))
	  ((= i 20))
	(set! (v0 i) (notch gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.500 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.500 1.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";5notch (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.0 0.5 5 :max-size 10))
	  (v0 (make-float-vector 20))
	  (in1 1.0))
      (do ((i 0 (+ i 1))
	   (angle 0.0 (+ angle .5)))
	  ((= i 20))
	(set! (v0 i) (all-pass gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.500 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.500 1.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";5all-pass (5 .5 0): ~A" v0)))
    
    
    (let ((gen (make-comb 0.5 5 :max-size 10))
	  (v0 (make-float-vector 20))
	  (in1 1.0))
      (do ((i 0 (+ i 1))
	   (angle 0.0 (- angle .5)))
	  ((= i 20))
	(set! (v0 i) (comb gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.500 0.000 0.125 0.000 0.031 0.016 0.004 1.000 0.000 0.250 0.031 0.000 0.012 0.002 0.250 0.125 0.008)))
	  (snd-display #__line__ ";6comb (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.5 0.0 5 :max-size 10))
	  (v0 (make-float-vector 20))
	  (in1 1.0))
      (do ((i 0 (+ i 1))
	   (angle 0.0 (- angle .5)))
	  ((= i 20))
	(set! (v0 i) (all-pass gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.500 0.000 0.125 0.000 0.031 0.016 0.004 1.000 0.000 0.250 0.031 0.000 0.012 0.002 0.250 0.125 0.008)))
	  (snd-display #__line__ ";6all-pass (5 0 .5): ~A" v0)))
    
    (let ((gen (make-notch 0.5 5 :max-size 10))
	  (v0 (make-float-vector 20))
	  (in1 1.0))
      (do ((i 0 (+ i 1))
	   (angle 0.0 (- angle .5)))
	  ((= i 20))
	(set! (v0 i) (notch gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.500 0.000 0.000 0.500 0.000 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";6notch (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.0 0.5 5 :max-size 10))
	  (v0 (make-float-vector 20))
	  (in1 1.0))
      (do ((i 0 (+ i 1))
	   (angle 0.0 (- angle .5)))
	  ((= i 20))
	(set! (v0 i) (all-pass gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.500 0.000 0.000 0.500 0.000 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";6all-pass (5 .5 0): ~A" v0)))
    
    (let ((gen (make-filtered-comb 0.5 5 :filter (make-one-zero .5 .5)))
	  (v0 (make-float-vector 21))
	  (in1 1.0))
      (do ((i 0 (+ i 1)))
	  ((= i 21))
	(set! (v0 i) (filtered-comb gen in1))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.250 0.250 
			       0.000 0.000 0.000 0.062 0.125 0.062 0.000 0.000 0.016)))
	  (snd-display #__line__ ";filtered-comb (5 .5): ~A" v0)))
    
    (let ((gen (make-filtered-comb 0.5 5 :filter (make-one-zero .25 .75)))
	  (v0 (make-float-vector 21))
	  (in1 1.0))
      (do ((i 0 (+ i 1)))
	  ((= i 21))
	(set! (v0 i) (filtered-comb gen in1))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.125 0.375 
			       0.000 0.000 0.000 0.016 0.094 0.141 0.000 0.000 0.002)))
	  (snd-display #__line__ ";1filtered-comb (5 .5): ~A" v0)))
    
    (let ((gen (make-filtered-comb 0.5 5 :filter (make-one-zero .25 .75)))
	  (v0 (make-float-vector 21))
	  (in1 1.0))
      (define mus-filtered-comb filtered-comb)
      (do ((i 0 (+ i 1)))
	  ((= i 21))
	(set! (v0 i) (mus-filtered-comb gen in1))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.125 0.375 
			       0.000 0.000 0.000 0.016 0.094 0.141 0.000 0.000 0.002)))
	  (snd-display #__line__ ";1mus-filtered-comb (5 .5): ~A" v0)))
    
    (let ((gen (make-filtered-comb 0.5 5 :filter (make-one-zero .25 .75)))
	  (v0 (make-float-vector 21))
	  (in1 1.0))
      (do ((i 0 (+ i 1)))
	  ((= i 21))
	(set! (v0 i) (filtered-comb gen in1))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.125 0.375 
			       0.000 0.000 0.000 0.016 0.094 0.141 0.000 0.000 0.002)))
	  (snd-display #__line__ ";1run-filtered-comb (5 .5): ~A" v0)))
    
    (let ((gen (make-filtered-comb 0.5 5 :max-size 20 :filter (make-one-zero .5 .5)))
	  (v0 (make-float-vector 20))
	  (in1 1.0))
      (do ((i 0 (+ i 1))
	   (angle 0.0 (+ angle .2)))
	  ((= i 20))
	(set! (v0 i) (filtered-comb gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 0.800 0.400 0.000 0.000 0.000 0.000 0.000 0.080 0.220 0.300 0.140 0.040 0.000 0.000)))
	  (snd-display #__line__ ";2filtered-comb (5 .5): ~A" v0)))
    
    (let ((gen (make-filtered-comb 0.5 5 :max-size 20 :filter (make-one-zero .5 .5)))
	  (v0 (make-float-vector 20))
	  (in1 1.0))
      (do ((i 0 (+ i 1))
	   (angle 0.0 (- angle .2)))
	  ((= i 20))
	(set! (v0 i) (filtered-comb gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.000 0.800 0.000 0.000 0.080 0.200 0.040 0.020 0.068 0.042 0.019 0.026 0.015 0.011 0.009 0.006 0.004)))
	  (snd-display #__line__ ";3filtered-comb (5 .5): ~A" v0)))
    
    (let ((gen (make-filtered-comb 0.5 5 :max-size 20 :filter (make-one-zero .5 .5)))
	  (v0 (make-float-vector 20))
	  (in1 1.0))
      (do ((i 0 (+ i 1))
	   (angle 0.0 (+ angle .01)))
	  ((= i 20))
	(set! (v0 i) (filtered-comb gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (float-vector 0.000 0.000 0.000 0.000 0.000 0.950 0.060 0.000 0.000 0.000 0.214 0.251 0.043 0.002 0.000 0.045 0.106 0.081 0.023 0.003)))
	  (snd-display #__line__ ";4filtered-comb (5 .5): ~A" v0)))
    
    
    (let ((gen (make-one-pole .4 .7))
	  (v0 (make-float-vector 10))
	  (gen1 (make-one-pole .4 .7))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "one-pole"
		       "one-pole a0: 0.400, b1: 0.700, y1: 0.000")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (one-pole gen 1.0)))
      (fill-float-vector v1 (if (one-pole? gen) (one-pole gen1 1.0) -1.0))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map one-pole: ~A ~A" v0 v1))
      (if (not (one-pole? gen)) (snd-display #__line__ ";~A not one-pole?" gen))
      (if (not (= (mus-order gen) 1)) (snd-display #__line__ ";one-pole order: ~D?" (mus-order gen)))
      (if (fneq (mus-xcoeff gen 0) .4) (snd-display #__line__ ";one-pole a0: ~F?" (mus-xcoeff gen 0)))
      (if (fneq (mus-ycoeff gen 1) .7) (snd-display #__line__ ";one-pole b1: ~F?" (mus-ycoeff gen 1)))
      (if (or (fneq (v0 1) 0.120) (fneq (v0 4) 0.275) (fneq (v0 8) 0.245))
	  (snd-display #__line__ ";one-pole output: ~A" v0))
      (if (fneq (mus-ycoeff gen 1) .7) (snd-display #__line__ ";1p ycoeff 1 .7: ~A" gen))
      (set! (mus-ycoeff gen 1) .1)
      (if (fneq (mus-ycoeff gen 1) .1) (snd-display #__line__ ";1p set ycoeff 1 .1: ~A" gen))
      (if (fneq (mus-xcoeff gen 0) .4) (snd-display #__line__ ";1p xcoeff 0 .4: ~A" gen))
      (set! (mus-xcoeff gen 0) .3)
      (if (fneq (mus-xcoeff gen 0) .3) (snd-display #__line__ ";1p set xcoeff 0 .3: ~A" gen)))
    
    
    (let ((gen (make-one-zero .4 .7))
	  (v0 (make-float-vector 10))
	  (gen1 (make-one-zero .4 .7))
	  (v1 (make-float-vector 10)))
      (print-and-check gen
		       "one-zero"
		       "one-zero a0: 0.400, a1: 0.700, x1: 0.000")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (one-zero gen 1.0)))
      (fill-float-vector v1 (if (one-zero? gen) (one-zero gen1 1.0) -1.0))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map one-zero: ~A ~A" v0 v1))
      (if (not (one-zero? gen)) (snd-display #__line__ ";~A not one-zero?" gen))
      (if (not (= (mus-order gen) 1)) (snd-display #__line__ ";one-zero order: ~D?" (mus-order gen)))
      (if (fneq (mus-xcoeff gen 0) .4) (snd-display #__line__ ";one-zero a0: ~F?" (mus-xcoeff gen 0)))
      (if (fneq (mus-xcoeff gen 1) .7) (snd-display #__line__ ";one-zero a1: ~F?" (mus-xcoeff gen 1)))
      (if (fneq (v0 1) 1.1) (snd-display #__line__ ";one-zero output: ~A" v0))
      (if (fneq (mus-xcoeff gen 0) .4) (snd-display #__line__ ";1z xcoeff 0 .4: ~A" gen))
      (set! (mus-xcoeff gen 0) .1)
      (if (fneq (mus-xcoeff gen 0) .1) (snd-display #__line__ ";1z set xcoeff 0 .1: ~A" gen)))
    
    (let ((gen (make-two-zero .4 .7 .3))
	  (v0 (make-float-vector 10))
	  (gen1 (make-two-zero .4 .7 .3))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "two-zero"
		       "two-zero a0: 0.400, a1: 0.700, a2: 0.300, x1: 0.000, x2: 0.000")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (two-zero gen 1.0)))
      (fill-float-vector v1 (if (two-zero? gen1) (two-zero gen1 1.0) -1.0))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map two-zero: ~A ~A" v0 v1))
      (if (not (two-zero? gen)) (snd-display #__line__ ";~A not two-zero?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display #__line__ ";two-zero order: ~D?" (mus-order gen)))
      (if (fneq (mus-xcoeff gen 0) .4) (snd-display #__line__ ";two-zero a0: ~F?" (mus-xcoeff gen 0)))
      (if (fneq (mus-xcoeff gen 1) .7) (snd-display #__line__ ";two-zero a1: ~F?" (mus-xcoeff gen 1)))
      (if (fneq (mus-xcoeff gen 2) .3) (snd-display #__line__ ";two-zero a2: ~F?" (mus-xcoeff gen 2)))
      (if (or (fneq (v0 1) 1.1) (fneq (v0 8) 1.4)) (snd-display #__line__ ";two-zero output: ~A" v0))
      (if (fneq (mus-xcoeff gen 0) .4) (snd-display #__line__ ";2z xcoeff 0 .4: ~A" gen))
      (set! (mus-xcoeff gen 0) .1)
      (if (fneq (mus-xcoeff gen 0) .1) (snd-display #__line__ ";2z set xcoeff 0 .1: ~A" gen))
      (set! (mus-xcoeff gen 0) 1.0)
      (let ((r (mus-scaler gen)))
	(set! (mus-frequency gen) 500.0)
	(if (ffneq (mus-frequency gen) 500.0) (snd-display #__line__ ";set mus-frequency two-zero: ~A" (mus-frequency gen)))
	(if (fneq (mus-scaler gen) r) (snd-display #__line__ ";set mus-frequency two-zero hit r: ~A" (mus-scaler gen)))
	(set! (mus-scaler gen) .99)
	(if (fneq (mus-scaler gen) .99) (snd-display #__line__ ";set mus-scaler two-zero: ~A" (mus-scaler gen)))
	(if (ffneq (mus-frequency gen) 500.0) (snd-display #__line__ ";set mus-scaler hit freq two-zero: ~A" (mus-frequency gen)))
	(let ((g3 (make-two-zero :radius .99 :frequency 500.0)))
	  (if (or (fneq (mus-xcoeff gen 0) (mus-xcoeff g3 0))
		  (fneq (mus-xcoeff gen 1) (mus-xcoeff g3 1))
		  (fneq (mus-xcoeff gen 2) (mus-xcoeff g3 2)))
	      (snd-display #__line__ ";two-zero setters: ~A ~A" gen g3)))))
    
    (let ((gen (make-two-zero .4 .7 .3)))
      (let ((val (gen 1.0)))
	(if (fneq val .4) (snd-display #__line__ ";2zero->0.4: ~A" val))
	(set! val (gen 0.5))
	(if (fneq val .9) (snd-display #__line__ ";2zero->0.9: ~A" val))
	(set! val (gen 1.0))
	(if (fneq val 1.05) (snd-display #__line__ ";2zero->1.05: ~A" val))))
    
    (let ((gen (make-two-pole .4 .7 .3))
	  (v0 (make-float-vector 10))
	  (gen1 (make-two-pole .4 .7 .3))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "two-pole"
		       "two-pole a0: 0.400, b1: 0.700, b2: 0.300, y1: 0.000, y2: 0.000")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (two-pole gen 1.0)))
      (fill-float-vector v1 (if (two-pole? gen1) (two-pole gen1 1.0) -1.0))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map two-pole: ~A ~A" v0 v1))
      (if (not (two-pole? gen)) (snd-display #__line__ ";~A not two-pole?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display #__line__ ";two-pole order: ~D?" (mus-order gen)))
      (if (fneq (mus-xcoeff gen 0) .4) (snd-display #__line__ ";two-pole a0: ~F?" (mus-xcoeff gen 0)))
      (if (fneq (mus-ycoeff gen 1) .7) (snd-display #__line__ ";two-pole b1: ~F?" (mus-ycoeff gen 1)))
      (if (fneq (mus-ycoeff gen 2) .3) (snd-display #__line__ ";two-pole b2: ~F?" (mus-ycoeff gen 2)))
      (if (or (fneq (v0 1) 0.12) (fneq (v0 8) 0.201)) (snd-display #__line__ ";two-pole output: ~A" v0))
      (if (fneq (mus-ycoeff gen 1) .7) (snd-display #__line__ ";2p ycoeff 1 .7: ~A" gen))
      (set! (mus-ycoeff gen 1) .1)
      (if (fneq (mus-ycoeff gen 1) .1) (snd-display #__line__ ";2p set ycoeff 1 .1: ~A" gen))
      (if (fneq (mus-xcoeff gen 0) .4) (snd-display #__line__ ";2p xcoeff 0 .4: ~A" gen))
      (set! (mus-xcoeff gen 0) .3)
      (if (fneq (mus-xcoeff gen 0) .3) (snd-display #__line__ ";2p set xcoeff 0 .3: ~A" gen))
      (set! (mus-xcoeff gen 0) 1.0)
      (let ((r (mus-scaler gen)))
	(set! (mus-frequency gen) 500.0)
	(if (ffneq (mus-frequency gen) 500.0) (snd-display #__line__ ";set mus-frequency two-pole: ~A" (mus-frequency gen)))
	(if (fneq (mus-scaler gen) r) (snd-display #__line__ ";set mus-frequency two-pole hit r: ~A" (mus-scaler gen)))
	(set! (mus-scaler gen) .99)
	(if (fneq (mus-scaler gen) .99) (snd-display #__line__ ";set mus-scaler two-pole: ~A" (mus-scaler gen)))
	(if (ffneq (mus-frequency gen) 500.0) (snd-display #__line__ ";set mus-scaler hit freq two-pole: ~A" (mus-frequency gen)))
	(let ((g3 (make-two-pole :radius .99 :frequency 500.0)))
	  (if (or (fneq (mus-xcoeff gen 0) (mus-xcoeff g3 0))
		  (fneq (mus-ycoeff gen 1) (mus-ycoeff g3 1))
		  (fneq (mus-ycoeff gen 2) (mus-ycoeff g3 2)))
	      (snd-display #__line__ ";two-pole setters: ~A ~A" gen g3)))))
    
    (let ((gen (make-two-pole .4 .7 .3)))
      (let ((val (gen 1.0)))
	(if (fneq val .4) (snd-display #__line__ ";a0->out 2pole: ~A" val))
	(set! val (gen 0.5))
	(if (fneq val -.08) (snd-display #__line__ ";a0->out 2pole (-0.08): ~A" val))
	(set! val (gen 1.0))
	(if (fneq val 0.336) (snd-display #__line__ ";a0->out 2pole (0.336): ~A" val))))
    
    (let ((gen (make-oscil 440.0))
	  (gen1 (make-oscil 440.0))
	  (gen2 (make-oscil 440.0))
	  (v0 (make-float-vector 10))
	  (v1 (make-float-vector 10))
	  (v2 (make-float-vector 10)))
      (print-and-check gen 
		       "oscil"
		       "oscil freq: 440.000Hz, phase: 0.000")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (oscil gen 0.0))
	(set! (v1 i) (mus-apply gen1 0.0 0.0)))
      (fill-float-vector v2 (if (oscil? gen2) (oscil gen2 0.0) -1.0))
      (if (not (vequal v0 v2)) (snd-display #__line__ ";map oscil: ~A ~A" v0 v2))
      (if (not (oscil? gen)) (snd-display #__line__ ";~A not oscil?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display #__line__ ";oscil phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";oscil frequency: ~F?" (mus-frequency gen)))
      (if (not (= (mus-length gen) 1)) (snd-display #__line__ ";oscil cosines: ~D?" (mus-length gen)))
      (if (or (fneq (v0 1) 0.125) (fneq (v0 8) 0.843)) (snd-display #__line__ ";oscil output: ~A" v0))
      (set! (mus-phase gen) 0.0)
      (if (fneq (mus-phase gen) 0.0) (snd-display #__line__ ";oscil set-phase: ~F?" (mus-phase gen)))
      (set! (mus-frequency gen) 100.0)
      (if (fneq (mus-frequency gen) 100.0) (snd-display #__line__ ";oscil set-frequency: ~F?" (mus-frequency gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(if (fneq (v0 i) (v1 i))
	    (snd-display #__line__ ";mus-apply oscil at ~D: ~A ~A?" i (v0 i) (v1 i))))
      (if (fneq (mus-apply) 0.0)
	  (snd-display #__line__ ";(mus-apply): ~A" (mus-apply))))

    ;; we can't (or don't anyway) guarantee optimized arg order evaluation so:
    (let ((o (make-oscil 1000.0)) 
	  (o1 (make-oscil 1000.0))
	  (v (make-float-vector 10))
	  (x 0.0))
      (do ((i 0 (+ i 1))) 
	  ((= i 10))
	(set! x (oscil o (oscil o1) (oscil o1)))
	(set! (v i) x))
      (let ((o4 (make-oscil 1000.0)) 
	    (o5 (make-oscil 1000.0))
	    (v2 (make-float-vector 10))
	    (x1 0.0)
	    (x2 0.0))
	(do ((i 0 (+ i 1))) 
	    ((= i 10))
	  (set! x1 (oscil o5))
	  (set! x2 (oscil o5))
	  (set! (v2 i) (oscil o4 x2 x1)))
	(let ()
	  (define (hi) 
	    (let ((o2 (make-oscil 1000.0)) 
		  (o3 (make-oscil 1000.0)) 
		  (v1 (make-float-vector 10)))
	      (do ((i 0 (+ i 1)))
		  ((= i 10) v1)
		(float-vector-set! v1 i (oscil o2 (oscil o3) (oscil o3))))))
	  (hi)
	  (let ((v1 (hi)))
	    
	    (if (and (not (mus-arrays-equal? v v1))
		     (not (mus-arrays-equal? v2 v1)))
		(format *stderr* ":orig: ~A~%;  v1: ~A~%;  v2: ~A~%" v v1 v2))))))
    (test-fm-components)
    (osc-opt)
    (nrxysin-opt)
    (polywave-opt)
    (do ((i 1 (+ i 1)))
	((= i 6))
      (test-simple-polywave i #f mus-chebyshev-first-kind)
      (test-simple-polywave i .1 mus-chebyshev-first-kind)
      (test-simple-polywave i #f mus-chebyshev-second-kind)
      (test-simple-polywave i .1 mus-chebyshev-second-kind))

    (let ((gen1 (make-oscil 100.0))
	  (gen2 (make-oscil -100.0))
	  (mx 0.0))
      (do ((i 0 (+ i 1)))
	  ((= i 100))
	(set! mx (max mx (abs (+ (gen1) (gen2))))))
      (if (fneq mx 0.0)
	  (snd-display #__line__ ";oscil +-: ~A" mx)))
    
    (let ((gen1 (make-oscil 100.0 (* pi 0.5)))
	  (gen2 (make-oscil -100.0 (* pi 0.5)))
	  (mx 0.0))
      (do ((i 0 (+ i 1)))
	  ((= i 100))
	(set! mx (max mx (abs (- (gen1) (gen2))))))
      (if (fneq mx 0.0)
	  (snd-display #__line__ ";cosil +-: ~A" mx)))
    
    (let ((frqs (float-vector 0.0 0.0))
	  (amps (float-vector 0.0 0.0))
	  (phs (float-vector 0.0 0.0)))
      (let ((ob (make-oscil-bank frqs phs amps)))
	(if (not (oscil-bank? ob)) (snd-display #__line__ ";oscil-bank? ~A" ob))
	(if (not (equal? (mus-data ob) phs)) (snd-display #__line__ ";oscil-bank data: ~A ~A" (mus-data ob) phs))
	(let ((x (oscil-bank ob)))
	  (if (not (= x 0.0)) (snd-display #__line__ ";oscil-bank 0.0: ~A~%" x)))
	(set! (amps 0) 0.5)
	(set! (amps 1) 0.2)
	(let ((x (oscil-bank ob)))
	  (if (not (= x 0.0)) (snd-display #__line__ ";oscil-bank 0.0 (amps): ~A~%" x)))
	(set! (frqs 0) .1)
	(set! (frqs 1) .2)
	(oscil-bank ob)
	(let ((x (oscil-bank ob)))
	  (if (not (morally-equal? x 0.08965057448242633)) (snd-display #__line__ ";oscil-bank 0.09: ~A~%" x)))))
    
    (fm-test (make-oscil))
    (fm-test (make-nrxysin))
    (fm-test (make-nrxycos))
    (fm-test (make-square-wave))
    (fm-test (make-triangle-wave))
    (fm-test (make-ncos))
    (fm-test (make-nsin))
    (fm-test (make-sawtooth-wave))
    (fm-test (make-rand))
    (fm-test (make-rand-interp))
    (fm-test (make-pulse-train))
    
    (let ((gen (make-oscil 440.0))
	  (gen1 (make-oscil 440.0)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(let ((oval (oscil gen .1))
	      (mval (mus-run gen1 .1)))
	  (if (fneq oval mval)
	      (snd-display #__line__ ";mus-run ~A but oscil ~A?" mval oval)))))
    
    (let ((gen (make-oscil 440.0))
	  (gen1 (make-oscil 440.0))
	  (gen2 (make-oscil 440.0))
	  (gen3 (make-oscil 440.0))
	  (fm-index (hz->radians 440.0))
	  (v0 (make-float-vector 10))
	  (v1 (make-float-vector 10)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (oscil gen (* fm-index (oscil gen1 0.0))))
	(set! (v1 i) (mus-apply gen2 (* fm-index (mus-apply gen3 0.0 0.0)) 0.0)))
      (if (or (fneq (v0 1) 0.125) (fneq (v0 6) 0.830) (fneq (v0 8) 0.987))
	  (snd-display #__line__ ";oscil fm output: ~A" v0))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(if (fneq (v0 i) (v1 i))
	    (snd-display #__line__ ";mus-apply fm oscil at ~D: ~A ~A?" i (v0 i) (v1 i)))))
    
    (test-gen-equal (make-oscil 440.0) (make-oscil 440.0) (make-oscil 100.0))
    (test-gen-equal (make-oscil 440.0) (make-oscil 440.0) (make-oscil 440.0 1.0))
    
    (let ((gen (make-oscil 440.0))
	  (gen1 (make-oscil 440.0))
	  (pm-index 2.0)
	  (v0 (make-float-vector 10)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (gen 0.0 (* pm-index (gen1 0.0)))))
      (if (or (fneq (v0 1) 0.367) (fneq (v0 6) 0.854) (fneq (v0 8) 0.437))
	  (snd-display #__line__ ";oscil pm output: ~A" v0)))
    
    (let ((gen (make-oscil 440.0)))
      (do ((i 0 (+ i 1)))
	  ((= i 1100))
	(let ((val1 (sin (mus-phase gen)))
	       (val2 (gen 0.0)))
	  (if (fneq val1 val2)
	      (snd-display #__line__ ";oscil: ~A: ~A ~A" i val1 val2)))))
    
    (let ((gen (make-oscil 440.0 :initial-phase (* pi 0.5)))
	  (incr (/ (* 2 pi 440.0) 22050.0)))
      (do ((i 0 (+ i 1))
	   (a 0.0 (+ a incr)))
	  ((= i 900))
	(let ((val1 (cos a))
	      (val2 (gen 0.0)))
	  (if (fneq val1 val2)
	      (snd-display #__line__ ";oscil (cos): ~A: ~A ~A" i val1 val2)))))
    
    (let ((gen (make-oscil 0.0))
	  (gen1 (make-oscil 40.0))
	  (incr (/ (* 2 pi 40.0) 22050.0)))
      (do ((i 0 (+ i 1))
	   (a 0.0 (+ a incr)))
	  ((= i 1100))
	(let ((val1 (sin (sin a)))
	      (val2 (oscil gen 0.0 (oscil gen1 0.0))))
	  (if (fneq val1 val2)
	      (snd-display #__line__ ";oscil pm: ~A: ~A ~A" i val1 val2)))))
    
    (let ((gen (make-oscil 0.0))
	  (gen1 (make-oscil 40.0))
	  (incr (/ (* 2 pi 40.0) 22050.0))
	  (a1 0.0))
      (do ((i 0 (+ i 1))
	   (a 0.0 (+ a incr)))
	  ((= i 100))
	(let ((fm (sin a))
	      (val1 (sin a1))
	      (val2 (oscil gen (oscil gen1 0.0))))
	  (set! a1 (+ a1 fm))
	  (if (fneq val1 val2)
	      (snd-display #__line__ ";oscil fm: ~A: ~A ~A" i val1 val2)))))
    
    (let ()
      (define (oscil-1-1)
	(let ((osc (make-oscil 440.0)))
	  (let ((v1 (make-vector 10 0.0))
		(v2 (make-vector 10 0.0)))
	    (set! (v1 0) (oscil osc))
	    (set! (v1 1) (oscil osc))
	    (let ((osc (make-oscil 440.0)))
	      (do ((i 0 (+ i 1)))
		  ((= i 10))
		(set! (v2 i) (oscil osc))))
	    (do ((i 2 (+ i 1)))
		((= i 10))
	      (set! (v1 i) (oscil osc)))
	    
	    (if (not (equal? v1 v2))
		(snd-display #__line__ ";oscil-1 shadowing test1: ~A ~A" v1 v2)))))
      
      (define (oscil-1-2)
	(define (ho-1 osc v i)
	  (set! (v i) (oscil osc)))
	(let ((o1 (make-oscil 440.0))
	      (o2 (make-oscil 440.0))
	      (v1 (make-vector 10 0.0))
	      (v2 (make-vector 10 0.0)))
	  (ho-1 o1 v1 0)
	  (ho-1 o1 v1 1)
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (ho-1 o2 v2 i))
	  (do ((i 2 (+ i 1)))
	      ((= i 10))
	    (ho-1 o1 v1 i))
	  (if (not (equal? v1 v2))
	      (snd-display #__line__ ";oscil-1 shadowing test2: ~A ~A" v1 v2))))
      
      (define (oscil-1-3)
	(define (ho)
	  (let ((osc (make-oscil 440.0)))
	    (lambda ()
	      (oscil osc))))
	(let ((o1 (ho))
	      (v1 (make-vector 10 0.0))
	      (v2 (make-vector 10 0.0)))
	  (set! (v1 0) (o1))
	  (set! (v1 1) (o1))
	  (let ((o2 (ho)))
	    (do ((i 0 (+ i 1)))
		((= i 10))
	      (set! (v2 i) (o2))))
	  (do ((i 2 (+ i 1)))
	      ((= i 10))
	    (set! (v1 i) (o1)))
	  (if (not (equal? v1 v2))
	      (snd-display #__line__ ";oscil-1 shadowing test3: ~A ~A" v1 v2))))
      
      (oscil-1-1)
      (oscil-1-2)
      (oscil-1-3))
    
    
    (let ((var (catch #t (lambda () (mus-location (make-oscil))) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";mus-location bad gen: ~A" var)))
    (let ((var (catch #t (lambda () (set! (mus-location (make-oscil)) 0)) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";set mus-location bad gen: ~A" var)))
    (let ((var (catch #t (lambda () (set! (mus-scaler (make-oscil)) 0)) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";set mus-scaler bad gen: ~A" var)))
    (let ((var (catch #t (lambda () (mus-frequency (make-one-pole))) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";mus-frequency bad gen: ~A" var)))
    (let ((var (catch #t (lambda () (set! (mus-frequency (make-one-pole)) 0)) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";set mus-frequency bad gen: ~A" var)))
    (let ((var (catch #t (lambda () (make-delay (* 1024 1024 40))) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display #__line__ ";make-delay huge line: ~A" var)))
    (let ((var (catch #t (lambda () (make-delay 32 :max-size (* 1024 1024 40))) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display #__line__ ";make-delay huge line: ~A" var)))
    
    (let ((size 1000))
      
      (define (test-pm beg end freq amp mc-ratio index)
	(let ((pm (make-oscil (* freq mc-ratio)))
	      (carrier (make-oscil freq)))
	  (do ((i beg (+ i 1)))
	      ((= i end))
	    (outa i (* amp (oscil carrier 0.0 (* index (oscil pm))))))))
      
      (define (test-fm beg end freq amp mc-ratio index)
	(let ((fm (make-oscil (* freq mc-ratio) :initial-phase (/ pi 2.0)))
	      (carrier (make-oscil freq))
	      (fm-index (* (hz->radians freq) mc-ratio index)))
	  (do ((i beg (+ i 1)))
	      ((= i end))
	    (outa i (* amp (oscil carrier (* fm-index (oscil fm))))))))
      
      ;; there's an initial-phase confusion here, so by making the srate high and freq low, we minimize uninteresting off-by-1 troubles
      
      (let ((v1 (with-sound ((make-float-vector size) :srate 441000) (test-pm 0 size 20 1 1 1)))
	    (v2 (with-sound ((make-float-vector size) :srate 441000) (test-fm 0 size 20 1 1 1))))
	(if (not (vequal v1 v2))
	    (snd-display #__line__ ";fm/pm peak diff (1 1): ~A" (float-vector-peak (float-vector-subtract! v1 v2)))))
      
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(let ((ratio (+ 1 (random 4)))
	      (index (random 2.0)))
	  (let ((v1 (with-sound ((make-float-vector size) :srate 441000) (test-pm 0 size 20 1 ratio index)))
		(v2 (with-sound ((make-float-vector size) :srate 441000) (test-fm 0 size 20 1 ratio index))))
	    (if (not (vequal v1 v2))
		(snd-display #__line__ ";fm/pm peak diff ~A ~A: ~A" ratio index (float-vector-peak (float-vector-subtract! v1 v2))))))))
    
    (let ((gen (make-ncos 440.0 10))
	  (v0 (make-float-vector 10))
	  (gen1 (make-ncos 440.0 10))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "ncos"
		       "ncos freq: 440.000Hz, phase: 0.000, n: 10")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (ncos gen 0.0)))
      (fill-float-vector v1 (if (ncos? gen1) (ncos gen1 0.0) -1.0))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map ncos: ~A ~A" v0 v1))
      (if (not (ncos? gen)) (snd-display #__line__ ";~A not ncos?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display #__line__ ";ncos phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";ncos frequency: ~F?" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) .1) (snd-display #__line__ ";ncos scaler: ~F?" (mus-scaler gen)))
      (if (not (= (mus-length gen) 10)) (snd-display #__line__ ";ncos n: ~D?" (mus-length gen)))
      (if (not (= (mus-length gen) 10)) (snd-display #__line__ ";ncos length: ~D?" (mus-length gen)))
      (if (or (fneq (v0 1) 0.722) (fneq (v0 8) -0.143)) (snd-display #__line__ ";ncos output: ~A" v0))
      (set! (mus-scaler gen) .5) (if (fneq (mus-scaler gen) 0.5) (snd-display #__line__ ";ncos set-scaler: ~F?" (mus-scaler gen)))
      (set! (mus-length gen) 5) (if (not (= (mus-length gen) 5)) (snd-display #__line__ ";set ncos n: ~D?" (mus-length gen)))
      (if (fneq (mus-scaler gen) .2) (snd-display #__line__ ";set n->scaler: ~A" (mus-scaler gen))))
    
    (test-gen-equal (make-ncos 440.0 3) (make-ncos 440.0 3) (make-ncos 440.0 5))
    (test-gen-equal (make-ncos 440.0 3) (make-ncos 440.0 3) (make-ncos 400.0 3))
    
    (let ((gen (make-ncos 440 10)))
      (do ((i 0 (+ i 1)))
	  ((= i 1100))
	(let* ((den (sin (* (mus-phase gen) 0.5)))
	       (val1 (if (= 0.0 den)
			 1.0
			 (min 1.0 (* (mus-scaler gen)
				     (- (/ (sin (* (mus-phase gen)
						   (+ (mus-length gen) 0.5)))
					   (* 2.0 den))
					0.5)))))
	       (val2 (gen 0.0)))
	  (if (> (abs (- val1 val2)) .002)
	      (snd-display #__line__ ";ncos: ~A: ~A ~A" i val1 val2)))))
    
    (let ((gen1 (make-ncos 100.0 10))
	  (gen2 (make-ncos -100.0 10))
	  (mx 0.0))
      (do ((i 0 (+ i 1)))
	  ((= i 100))
	(set! mx (max mx (abs (- (gen1) (gen2))))))
      (if (fneq mx 0.0)
	  (snd-display #__line__ ";ncos +-: ~A" mx)))

    (test-simple-ncos 1)
    (test-simple-ncos 3)
    (test-simple-ncos 10)

    
    (let ((gen (make-nsin 440.0 10))
	  (v0 (make-float-vector 10))
	  (gen1 (make-nsin 440.0 10))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "nsin"
		       "nsin freq: 440.000Hz, phase: 0.000, n: 10")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (nsin gen 0.0)))
      (fill-float-vector v1 (if (nsin? gen1) (nsin gen1 0.0) -1.0))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map nsin: ~A ~A" v0 v1))
      (if (not (nsin? gen)) (snd-display #__line__ ";~A not nsin?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display #__line__ ";nsin phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";nsin frequency: ~F?" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) .1315) (snd-display #__line__ ";nsin scaler: ~F?" (mus-scaler gen)))
      (if (not (= (mus-length gen) 10)) (snd-display #__line__ ";nsin n: ~D?" (mus-length gen)))
      (if (not (= (mus-length gen) 10)) (snd-display #__line__ ";nsin length: ~D?" (mus-length gen)))
      (if (or (fneq (v0 1) 0.784) (fneq (v0 8) 0.181)) (snd-display #__line__ ";nsin output: ~A" v0))
      (set! (mus-scaler gen) .5) (if (fneq (mus-scaler gen) 0.5) (snd-display #__line__ ";nsin set-scaler: ~F?" (mus-scaler gen)))
      (set! (mus-length gen) 5) (if (not (= (mus-length gen) 5)) (snd-display #__line__ ";set nsin n: ~D?" (mus-length gen)))
      (if (fneq (mus-scaler gen) .2525) (snd-display #__line__ ";set sines->scaler: ~A" (mus-scaler gen))))
    
    (test-gen-equal (make-nsin 440.0 3) (make-nsin 440.0 3) (make-nsin 440.0 5))
    (test-gen-equal (make-nsin 440.0 3) (make-nsin 440.0 3) (make-nsin 400.0 3))
    
    (let ((gen1 (make-nsin 100.0 10))
	  (gen2 (make-nsin -100.0 10))
	  (mx 0.0))
      (do ((i 0 (+ i 1)))
	  ((= i 100))
	(set! mx (max mx (abs (+ (gen1) (gen2))))))
      (if (fneq mx 0.0)
	  (snd-display #__line__ ";nsin +-: ~A" mx)))
    
    (test-simple-nsin 1)
    (test-simple-nsin 3)
    (test-simple-nsin 10)

    
    (let ((gen (make-nrxysin 440.0))
	  (v0 (make-float-vector 10))
	  (gen1 (make-nrxysin 440.0))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "nrxysin"
                       "nrxysin frequency: 440.000, ratio: 1.000, phase: 0.000, n: 1, r: 0.500")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (nrxysin gen 0.0)))
      (fill-float-vector v1 (if (nrxysin? gen1) (nrxysin gen1 0.0) -1.0))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map nrxysin: ~A ~A" v0 v1))
      (if (not (nrxysin? gen)) (snd-display #__line__ ";~A not nrxysin?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display #__line__ ";nrxysin phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";nrxysin frequency: ~F?" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 0.5) (snd-display #__line__ ";mus-scaler (a) nrxysin: ~A" (mus-scaler gen)))
      (set! (mus-scaler gen) 0.75)
      (if (fneq (mus-scaler gen) 0.75) (snd-display #__line__ ";mus-scaler (set a) nrxysin: ~A" (mus-scaler gen)))
      (if (not (= (mus-length gen) 1)) (snd-display #__line__ ";mus-length nrxysin: ~A" (mus-length gen)))
      (if (fneq (mus-offset gen) 1.0) (snd-display #__line__ ";mus-offset nrxysin: ~A" (mus-offset gen))))
    
    (test-gen-equal (make-nrxysin 440.0) (make-nrxysin 440.0) (make-nrxysin 100.0))
    (test-gen-equal (make-nrxysin 440.0) (make-nrxysin 440.0) (make-nrxysin 440.0 1.5))
    (test-gen-equal (make-nrxysin 440.0) (make-nrxysin 440.0) (make-nrxysin 440.0 :n 3))
    
    (let ((v1 (make-float-vector 10)))
      (with-sound (v1 :srate 44100)
	(let ((gen (make-nrxysin 1000 :n 10 :r .99)))
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (outa i (nrxysin gen)))))
      (if (not (vequal v1 (float-vector 0.000 0.671 0.637 0.186 0.017 0.169 0.202 0.048 0.007 0.105)))
	  (snd-display #__line__ ";ws nrxysin output: ~A" v1)))
    
    
    (let ((gen (make-nrxycos 440.0))
	  (v0 (make-float-vector 10))
	  (gen1 (make-nrxycos 440.0))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "nrxycos"
                       "nrxycos frequency: 440.000, ratio: 1.000, phase: 0.000, n: 1, r: 0.500")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (nrxycos gen 0.0)))
      (fill-float-vector v1 (if (nrxycos? gen1) (nrxycos gen1 0.0) -1.0))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map nrxycos: ~A ~A" v0 v1))
      (if (not (nrxycos? gen)) (snd-display #__line__ ";~A not nrxycos?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display #__line__ ";nrxycos phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";nrxycos frequency: ~F?" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 0.5) (snd-display #__line__ ";mus-scaler (a) nrxycos: ~A" (mus-scaler gen)))
      (set! (mus-scaler gen) 0.75)
      (if (fneq (mus-scaler gen) 0.75) (snd-display #__line__ ";mus-scaler (set a) nrxycos: ~A" (mus-scaler gen)))
      (if (not (= (mus-length gen) 1)) (snd-display #__line__ ";mus-length nrxycos: ~A" (mus-length gen)))
      (if (fneq (mus-offset gen) 1.0) (snd-display #__line__ ";mus-offset nrxycos: ~A" (mus-offset gen))))
    
    (test-gen-equal (make-nrxycos 440.0) (make-nrxycos 440.0) (make-nrxycos 100.0))
    (test-gen-equal (make-nrxycos 440.0) (make-nrxycos 440.0) (make-nrxycos 440.0 1.5))
    (test-gen-equal (make-nrxycos 440.0) (make-nrxycos 440.0) (make-nrxycos 440.0 :n 3))
    
    (let ((v1 (with-sound ((make-float-vector 10) :srate 44100)
			  (let ((gen (make-nrxycos 1000 :n 10 :r .99)))
			    (do ((i 0 (+ i 1)))
				((= i 10))
			      (outa i (nrxycos gen)))))))
      (if (not (vequal v1 (float-vector 1.000 0.602 -0.067 -0.242 -0.007 0.071 -0.087 -0.128 -0.007 0.012)))
	  (snd-display #__line__ ";ws nrxycos output: ~A" v1)))
    
    (let ((gen (make-asymmetric-fm 440.0))
	  (v0 (make-float-vector 10))
	  (gen1 (make-asymmetric-fm 440.0))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "asymmetric-fm"
		       "asymmetric-fm freq: 440.000Hz, phase: 0.000, ratio: 1.000, r: 1.000")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (asymmetric-fm gen 0.0)))
      (fill-float-vector v1 (if (asymmetric-fm? gen1) (asymmetric-fm gen1 0.0) -1.0))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map asymmetric-fm: ~A ~A" v0 v1))
      (if (not (asymmetric-fm? gen)) (snd-display #__line__ ";~A not asymmetric-fm?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display #__line__ ";asymmetric-fm phase: ~F?" (mus-phase gen)))
      (set! (mus-phase gen) 1.0)
      (if (fneq (mus-phase gen) 1.0) (snd-display #__line__ ";set! asymmetric-fm phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";asymmetric-fm frequency: ~F?" (mus-frequency gen)))
      (set! (mus-frequency gen) 100.0)
      (if (fneq (mus-frequency gen) 100.0) (snd-display #__line__ ";set! asymmetric-fm frequency: ~F?" (mus-frequency gen)))
      (if (or (fneq (v0 2) 0.969) (fneq (v0 8) .538)) (snd-display #__line__ ";asymmetric-fm output: ~A" v0))
      (if (fneq (mus-scaler gen) 1.0) (snd-display #__line__ ";mus-scaler (r) asymmetric-fm: ~A" (mus-scaler gen)))
      (set! (mus-scaler gen) 0.5)
      (if (fneq (mus-scaler gen) 0.5) (snd-display #__line__ ";mus-scaler (set r) asymmetric-fm: ~A" (mus-scaler gen)))
      (if (fneq (mus-offset gen) 1.0) (snd-display #__line__ ";mus-offset asymmetric-fm: ~A" (mus-offset gen))))
    
    (test-gen-equal (make-asymmetric-fm 440.0) (make-asymmetric-fm 440.0) (make-asymmetric-fm 100.0))
    (test-gen-equal (make-asymmetric-fm 440.0) (make-asymmetric-fm 440.0) (make-asymmetric-fm 440.0 1.0))
    (test-gen-equal (make-asymmetric-fm 440.0) (make-asymmetric-fm 440.0) (make-asymmetric-fm 440.0 0.0 3))
    
    (let ((gen1 (make-asymmetric-fm 1000 0 1.0 0.1))
	  (gen2 (make-oscil 1000 :initial-phase (* 0.5 pi)))
	  (happy #t))
      (do ((i 0 (+ i 1)))
	  ((or (not happy) (= i 100)))
	(let ((ss (asymmetric-fm gen1 0.0))
	      (os (oscil gen2 0.0)))
	  (if (fneq ss os)
	      (begin
		(snd-display #__line__ ";asymmetric-fm 1: ~A: os: ~A ss: ~A" i os ss)
		(set! happy #f))))))
    
    (for-each
     (lambda (index)
       (for-each
	(lambda (r)
	  (let ((peak (float-vector-peak (with-sound (:clipped #f :output (make-float-vector 1000))
					    (let ((gen (make-asymmetric-fm 2000.0 :ratio .1 :r r)))
					       (do ((i 0 (+ i 1)))
						   ((= i 1000))
						 (outa i (asymmetric-fm gen index))))))))
	    (if (> (abs (- peak 1.0)) .1)
		(snd-display #__line__ ";asymmetric-fm peak: ~A, index: ~A, r: ~A" peak index r))))
	(list -10.0 -1.5 -0.5 0.5 1.0 1.5 10.0)))
     (list 1.0 3.0 10.0))
    
    (let ((float-vector0 (make-float-vector 2048))
	  (float-vector1 (make-float-vector 2048))
	  (gen3 (make-asymmetric-fm 1000 0 1.0 0.2))
	  (gen4 (make-oscil 1000 (* 0.5 pi)))
	  (gen5 (make-oscil 200))
	  (fm1 (hz->radians (* 1.0 .2 1000)))) ; make notions of "index" match
      (do ((i 0 (+ i 1)))
	  ((= i 2048))
	(set! (float-vector0 i) (asymmetric-fm gen3 1.0))
	(set! (float-vector1 i) (oscil gen4 (* fm1 (oscil gen5)))))
      (let ((spectr1 (snd-spectrum float-vector0 rectangular-window 2048 #t))
	    (spectr2 (snd-spectrum float-vector1 rectangular-window 2048 #t))
	    (happy #t))
	(do ((i 1 (+ i 1)))
	    ((or (not happy)
		 (= i 512)))
	  (if (> (abs (- (spectr1 i) (spectr2 i))) .02)
	      (begin
		(snd-display #__line__ ";asymmetric-fm 2: ~A: ~A ~A" i (spectr1 i) (spectr2 i))
		(set! happy #f))))))
    
    (let ((gen (make-asymmetric-fm 40.0 0.0 1.0 0.1))
	  (gen1 (make-asyfm :frequency 40.0 :ratio .1 :index 2.0))
	  (incr (/ (* 2 pi 40.0) *clm-srate*))
	  (r 1.0)
	  (ratio 0.1)
	  (index 2.0))
      (let ((cr (* 0.5 (- r (/ 1.0 r))))
	    (sr (* 0.5 (+ r (/ 1.0 r)))))
	(do ((i 0 (+ i 1))
	     (a 0.0 (+ a incr)))
	    ((= i 1100))
	  (let ((val1 (asymmetric-fm gen 2.0)) ; 1.0=index
		(val3 (asyfm-J gen1 0.0))
		(mth (* ratio a)))
	    (let ((val2 (* (exp (* index cr (+ 1.0 (cos mth))))
			   (cos (+ a (* index sr (sin mth)))))))
	      (if (or (fneq val1 val2)
		      (fneq val1 val3))
		  (snd-display #__line__ ";asyfm by hand: ~A: ~A ~A ~A" i val1 val2 val3)))))))
    
    (let ((float-vector0 (make-float-vector 2048))
	  (float-vector1 (make-float-vector 2048))
	  (gen3 (make-asymmetric-fm 1000 0 2.0 0.1))
	  (gen4 (make-asymmetric-fm 1000 0 0.5 0.1)))
      (do ((i 0 (+ i 1)))
	  ((= i 2048))
	(set! (float-vector0 i) (asymmetric-fm gen3 2.0))
	(set! (float-vector1 i) (asymmetric-fm gen4 2.0)))
      (let ((spectr1 (snd-spectrum float-vector0 rectangular-window 2048 #t))
	    (spectr2 (snd-spectrum float-vector1 rectangular-window 2048 #t))
	    (s1-loc 0)
	    (s2-loc 0))
	(do ((i 1 (+ i 1)))
	    ((= i 256))
	  (if (< (abs (- 1.0 (spectr1 i))) .01) (set! s1-loc i))
	  (if (< (abs (- 1.0 (spectr2 i))) .01) (set! s2-loc i)))
	(if (> s2-loc s1-loc) (snd-display #__line__ ";asymmetric-fm peaks: ~A ~A" s1-loc s2-loc))
	(let ((center (* (/ 22050 2048) .5 (+ s1-loc s2-loc))))
	  (if (> (abs (- 1000 center)) 60) (snd-display #__line__ ";asymmetric-fm center: ~A" center)))
	(set! (mus-scaler gen3) 0.5)
	(do ((i 0 (+ i 1)))
	    ((= i 2048))
	  (set! (float-vector0 i) (asymmetric-fm gen3 2.0)))
	(set! spectr1 (snd-spectrum float-vector0 rectangular-window 2048 #t))
	(do ((i 1 (+ i 1)))
	    ((= i 256))
	  (if (< (abs (- 1.0 (spectr1 i))) .01) (set! s1-loc i)))
	(if (not (= s2-loc s1-loc)) (snd-display #__line__ ";asymmetric-fm set r peaks: ~A ~A" s1-loc s2-loc))
	(do ((i 0 (+ i 1)))
	    ((= i 2048))
	  (set! (float-vector0 i) (asymmetric-fm gen3 2.0)))
	(snd-spectrum float-vector0 rectangular-window 2048 #t 0.0 #t)
	(do ((i 1 (+ i 1)))
	    ((= i 256))
	  (if (< (abs (- 1.0 (float-vector0 i))) .01) (set! s1-loc i)))
	(if (not (= s2-loc s1-loc)) (snd-display #__line__ "asymmetric-fm set r in place peaks: ~A ~A" s1-loc s2-loc))))
    
    (let ((gen (make-asyfm :frequency 2000 :ratio .1))) 
      (asyfm-I gen 0.0))
    
    (do ((i 2 (+ i 1)))
	((= i 40))
      (let ((v (make-float-vector i)))
	(do ((k 0 (+ k 1)))
	    ((= k i))
	  (set! (v k) (expt 1.2 (- k))))
	(let ((f (make-fir-filter i v)))
	  (do ((k 0 (+ k 1))
	       (x 1.0 0.0))
	      ((= k i))
	    (let ((val (fir-filter f x))
		  (exval (expt 1.2 (- k))))
	      (if (> (abs (- val exval)) 1e-12)
		  (format *stderr* ";for-filter ~D at ~D: ~A ~A~%" i k val exval)))))))
    
    (let ((f (make-fir-filter 3 (float-vector 1.0 .5 .25)))
	  (v (make-float-vector 10)))
      (set! (v 0) (f 1.0))
      (do ((i 1 (+ i 1)))
	  ((= i 5))
	(set! (v i) (f 0.0)))
      (set! (v 5) (f 1.0))
      (do ((i 6 (+ i 1)))
	  ((= i 10))
	(set! (v i) (f 0.0)))
      (if (not (mus-arrays-equal? v (float-vector 1.0 0.5 .25 0.0 0.0 1.0 0.5 .25 0.0 0.0)))
	  (format *stderr* ";f3: ~A~%" v)))
    
    (let ((f (make-fir-filter 7 (float-vector .7 .6 .5 .4 .3 .2 .1)))
	  (v (make-float-vector 10)))
      (set! (v 0) (f 1.0))
      (do ((i 1 (+ i 1)))
	  ((= i 10))
	(set! (v i) (f 0.0)))
      (if (not (mus-arrays-equal? v (float-vector .7 .6 .5 .4 .3 .2 .1 0.0 0.0 0.0)))
	  (format *stderr* ";f7: ~A~%" v)))
    
    
    (let ((f (make-iir-filter 3 (float-vector 1.0 .5 .25)))
	  (v (make-float-vector 10)))
      (set! (v 0) (f 1.0))
      (do ((i 1 (+ i 1)))
	  ((= i 5))
	(set! (v i) (f 0.0)))
      (set! (v 5) (f 1.0))
      (do ((i 6 (+ i 1)))
	  ((= i 10))
	(set! (v i) (f 0.0)))
      (if (not (mus-arrays-equal? v (float-vector 1.0 -0.5 0.0 0.125 -0.0625 1.0 -0.484375 -0.0078125 0.125 -0.060546875)))
	  (format *stderr* ";i3: ~A~%" v)))
    
    
    (let ((f (make-iir-filter 7 (float-vector .7 .6 .5 .4 .3 .2 .1)))
	  (v (make-float-vector 30)))
      (set! (v 0) (f 1.0))
      (do ((i 1 (+ i 1)))
	  ((= i 30))
	(set! (v i) (f 0.0)))
      (if (not (mus-arrays-equal? v (float-vector 1.000000 -0.600000 -0.140000 -0.016000 0.019600 0.032240 0.039256 0.045286 
						  -0.048376 -0.021312 -0.001324 0.006140 0.007033 0.004780 0.000657 -0.005043 
						  -0.002420 0.000256 0.001217 0.001013 0.000350 -0.000292 -0.000579 -0.000219 
						  0.000109 0.000192 0.000115 0.000002 -0.000067 -0.000065)))
	  (begin
	    (format *stderr* ";i7: ")
	    (do ((i 0 (+ i 1)))
		((= i 30))
	      (format *stderr* "~,6f " (v i)))
	    (format *stderr* "~%"))))
    
    (let ((x (make-float-vector 3))
	  (y (make-float-vector 3)))
      (do ((i 0 (+ i 1)))
	  ((= i 3))
	(set! (x i) (expt 1.2 (- i)))
	(set! (y i) (expt 1.5 (- i))))
      
      (let ((f (make-filter 3 x y))
	    (v (make-float-vector 10)))
	(set! (v 0) (f 1.0))
	(do ((i 1 (+ i 1)))
	    ((= i 10))
	  (set! (v i) (f 0.0)))
	(if (not (mus-arrays-equal? v (float-vector 1.000000 0.166667 0.138889 -0.166667 0.049383 0.041152 -0.049383 0.014632 0.012193 -0.014632)))
	    (begin
	      (format *stderr* ";g3: ")
	      (do ((i 0 (+ i 1)))
		  ((= i 10))
		(format *stderr* "~,6f " (v i)))
	      (format *stderr* "~%")))))
    
    (let ((x (make-float-vector 9))
	  (y (make-float-vector 9)))
      (do ((i 0 (+ i 1)))
	  ((= i 9))
	(set! (x i) (expt 1.2 (- i)))
	(set! (y i) (expt 1.2 (- i))))
      
      (let ((f (make-filter 9 x y))
	    (v (make-float-vector 30)))
	(set! (v 0) (f 1.0))
	(do ((i 1 (+ i 1)))
	    ((= i 30))
	  (set! (v i) (f 0.0)))
	(if (not (mus-arrays-equal? v (float-vector 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
						    0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)))
	    (begin
	      (format *stderr* ";g9: ")
	      (do ((i 0 (+ i 1)))
		  ((= i 30))
		(format *stderr* "~,6f " (v i)))
	      (format *stderr* "~%")))))
    
    (let ((x (make-float-vector 9))
	  (y (make-float-vector 9)))
      (do ((i 0 (+ i 1)))
	  ((= i 9))
	(set! (x i) (expt 1.2 (- i)))
	(set! (y i) (expt 1.5 (- i))))
      
      (let ((f (make-filter 9 x y))
	    (v (make-float-vector 30)))
	(set! (v 0) (f 1.0))
	(do ((i 1 (+ i 1)))
	    ((= i 30))
	  (set! (v i) (f 0.0)))
	(if (not (mus-arrays-equal? v (float-vector 1.000000 0.166667 0.138889 0.115741 0.096451 0.080376 0.066980 0.055816 0.046514 
						    -0.129033 0.004335 0.003613 0.003011 0.002509 0.002091 0.001742 0.001452 0.001210 
						    -0.003356 0.000113 0.000094 0.000078 0.000065 0.000054 0.000045 0.000038 0.000031
						    -0.000087 0.000003 0.000002)))
	    (begin
	      (format *stderr* ";g9e: ")
	      (do ((i 0 (+ i 1)))
		  ((= i 30))
		(format *stderr* "~,6f " (v i)))
	      (format *stderr* "~%")))))

    (let ((x (make-float-vector 8))
	  (y (make-float-vector 8)))
      (do ((i 0 (+ i 1)))
	  ((= i 8))
	(set! (x i) (expt 1.5 (- i)))
	(set! (y i) (expt 1.2 (- i))))
      
      (let ((f (make-filter 8 x y))
	    (v (make-float-vector 30)))
	(set! (v 0) (f 1.0))
	(do ((i 1 (+ i 1)))
	    ((= i 30))
	  (set! (v i) (f 0.0)))
	(if (not (mus-arrays-equal? v (float-vector 1.000000 -0.166667 -0.111111 -0.074074 -0.049383 -0.032922 -0.021948 -0.014632 
						    0.183795 -0.038761 -0.025841 -0.017227 -0.011485 -0.007657 -0.005104 -0.003403 
						    0.042745 -0.009015 -0.006010 -0.004007 -0.002671 -0.001781 -0.001187 -0.000791 
						    0.009941 -0.002097 -0.001398 -0.000932 -0.000621 -0.000414)))
	    (begin
	      (format *stderr* ";g-8: ")
	      (do ((i 0 (+ i 1)))
		  ((= i 30))
		(format *stderr* "~,6f " (v i)))
	      (format *stderr* "~%")))))

    (let ((x (make-float-vector 18))
	  (y (make-float-vector 18)))
      (do ((i 0 (+ i 1)))
	  ((= i 18))
	(set! (x i) (expt 1.5 (- i)))
	(set! (y i) (expt 1.2 (- i))))
      
      (let ((f (make-filter 18 x y))
	    (v (make-float-vector 30)))
	(set! (v 0) (f 1.0))
	(do ((i 1 (+ i 1)))
	    ((= i 30))
	  (set! (v i) (f 0.0)))
	(if (not (mus-arrays-equal? v (float-vector 1.000000 -0.166667 -0.111111 -0.074074 -0.049383 -0.032922 -0.021948 -0.014632 -0.009755 
						    -0.006503 -0.004335 -0.002890 -0.001927 -0.001285 -0.000856 -0.000571 -0.000381 -0.000254 
						    0.036715 -0.006260 -0.004173 -0.002782 -0.001855 -0.001237 -0.000824 -0.000550 -0.000366 
						    -0.000244 -0.000163 -0.000109)))
	    (begin
	      (format *stderr* ";g-18: ")
	      (do ((i 0 (+ i 1)))
		  ((= i 30))
		(format *stderr* "~,6f " (v i)))
	      (format *stderr* "~%")))))

    (let ((x (make-float-vector 9))
	  (y (make-float-vector 9)))
      (do ((i 0 (+ i 1)))
	  ((= i 9))
	(set! (x i) (expt 1.5 (- i)))
	(set! (y i) (expt 1.2 (- i))))
      
      (let ((f (make-filter 9 x y))
	    (v (make-float-vector 30)))
	(set! (v 0) (f 1.0))
	(do ((i 1 (+ i 1)))
	    ((= i 30))
	  (set! (v i) (f 0.0)))
	(if (not (mus-arrays-equal? v (float-vector 1.000000 -0.166667 -0.111111 -0.074074 -0.049383 -0.032922 
						    -0.021948 -0.014632 -0.009755 0.161291 -0.032301 -0.021534 
						    -0.014356 -0.009571 -0.006380 -0.004254 -0.002836 -0.001891 
						    0.031259 -0.006260 -0.004173 -0.002782 -0.001855 -0.001237 
						    -0.000824 -0.000550 -0.000366 0.006058 -0.001213 -0.000809)))
	    (begin
	      (format *stderr* ";g-9: ")
	      (do ((i 0 (+ i 1)))
		  ((= i 30))
		(format *stderr* "~,6f " (v i)))
	      (format *stderr* "~%")))))
    
    
    (let ((gen (make-fir-filter 3 (float-vector .5 .25 .125)))
	  (v0 (make-float-vector 10))
	  (gen1 (make-fir-filter 3 (float-vector .5 .25 .125)))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "fir-filter"
		       "fir-filter order: 3, xs: [0.5 0.25 0.125]"
		       )
      (set! (v0 0) (fir-filter gen 1.0))
      (do ((i 1 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (fir-filter gen 0.0)))
      (let ((inp 1.0))
	(fill-float-vector v1 (let ((val (if (fir-filter? gen1) (fir-filter gen1 inp) -1.0)))
		       (set! inp 0.0)
		       val)))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map fir-filter: ~A ~A" v0 v1))
      (if (not (fir-filter? gen)) (snd-display #__line__ ";~A not fir-filter?" gen))
      (if (not (= (mus-length gen) 3)) (snd-display #__line__ ";fir-filter length: ~D?" (mus-length gen)))
      (if (or (fneq (v0 1) 0.25) (fneq (v0 2) .125)) (snd-display #__line__ ";fir-filter output: ~A" v0))
      (let ((data (mus-xcoeffs gen)))
	(if (fneq (data 1) .25) (snd-display #__line__ ";fir-filter xcoeffs: ~A?" data)))
      (let ((tag (catch #t (lambda () (mus-xcoeff gen 123)) (lambda args (car args)))))
	(if (not (eq? tag 'mus-error))
	    (snd-display #__line__ ";xcoeff 123: ~A" tag)))
      (let ((tag (catch #t (lambda () (mus-ycoeff gen 123)) (lambda args (car args)))))
	(if (not (eq? tag 'mus-error))
	    (snd-display #__line__ ";fir ycoeff 123: ~A" tag))))
    
    (test-gen-equal (let ((f1 (make-fir-filter 3 (float-vector .5 .25 .125)) )) (fir-filter f1 1.0) f1)
		    (let ((f2 (make-fir-filter 3 (float-vector .5 .25 .125)) )) (fir-filter f2 1.0) f2)
		    (let ((f3 (make-fir-filter 3 (float-vector .75 .25 .125)))) (fir-filter f3 1.0) f3))
    (test-gen-equal (let ((f1 (make-fir-filter 3 (float-vector .5 .25 .125)) )) (fir-filter f1 1.0) f1)
		    (let ((f2 (make-fir-filter 3 (float-vector .5 .25 .125)) )) (fir-filter f2 1.0) f2)
		    (let ((f3 (make-fir-filter 2 (float-vector .5 .25)))) (fir-filter f3 1.0) f3))
    
    (let* ((coeffs (float-vector .1 .2 .3 .4 .4 .3 .2 .1))
	   (flt (make-fir-filter 8 coeffs))
	   (xcof (mus-xcoeffs flt))
	   (es (make-vector 8)))
      (do ((i 0 (+ i 1)))
	  ((= i 8))
	(set! (es i) (make-env (list 0 (coeffs i) 1 0) :length 102)))
      (set! (es 5) (make-env '(0 .4 1 1) :length 102))
      (let ((data (make-float-vector 100)))
	(do ((k 0 (+ k 1)))
	    ((= k 100))
	  (set! (data k) (fir-filter flt (if (= (modulo k 12) 0) 1.0 0.0)))
	  (do ((i 0 (+ i 1)))
	      ((= i 8))
	    (float-vector-set! xcof i (env (vector-ref es i)))))
	(if (or (fneq (data 1) .2)
		(fneq (data 10) 0.0)
		(fneq (data 18) 0.166)
		(fneq (data 89) 0.923))
	    (snd-display #__line__ ";filter xcoeffs: ~A?" data))))
    
    (letrec ((make-f-filter (lambda (coeffs)
			      (list coeffs (make-float-vector (length coeffs)))))
	     (f-filter (lambda (flt x)
			 (let* ((coeffs (car flt))
				(xs (cadr flt))
				(xlen (length xs)))
			   (float-vector-move! xs (- xlen 1) (- xlen 2) #t)
			   (set! (xs 0) x)
			   (dot-product coeffs xs xlen)))))
      (let ((fir1 (make-fir-filter 3 (float-vector 1.0 0.4 0.1)))
	    (fir2 (make-f-filter (float-vector 1.0 0.4 0.1)))
	    (x 1.0)
	    (happy #t))
	(do ((i 0 (+ i 1)))
	    ((or (not happy) (= i 10)))
	  (let ((val1 (fir-filter fir1 x))
		(val2 (f-filter fir2 x)))
	    (set! x 0.0)
	    (if (fneq val1 val2)
		(begin
		  (snd-display #__line__ ";f-filter ~A -> ~A ~A" i val1 val2)
		  (set! happy #f)))))))
    
    (let ((gen (make-spencer-filter)))
      (if (not (fir-filter? gen)) 
	  (snd-display #__line__ ";make-spencer-filter returns ~A?" gen)
	  (begin
	    (if (not (= (mus-order gen) 15)) (snd-display #__line__ ";make-spencer-filter order ~A?" (mus-order gen)))
	    (if (not (vequal (mus-xcoeffs gen) (float-vector -0.009 -0.019 -0.016 0.009 0.066 0.144 0.209 0.231 0.209 0.144 0.066 0.009 -0.016 -0.019 -0.009)))
		(snd-display #__line__ ";make-spencer-filter coeffs: ~A" (mus-xcoeffs gen))))))
    
    (let ((flt (make-savitzky-golay-filter 5 2)))
      (if (not (vequal (mus-xcoeffs flt) (float-vector -0.086 0.343 0.486 0.343 -0.086)))
	  (snd-display #__line__ ";sg 5 2: ~A" (mus-xcoeffs flt))))
    (let ((flt (make-savitzky-golay-filter 11 2)))
      (if (not (vequal (mus-xcoeffs flt) (float-vector -0.084 0.021 0.103 0.161 0.196 0.207 0.196 0.161 0.103 0.021 -0.084)))
	  (snd-display #__line__ ";sg 11 2: ~A" (mus-xcoeffs flt))))
    (let ((flt (make-savitzky-golay-filter 11 4)))
      (if (not (vequal (mus-xcoeffs flt) (float-vector 0.042 -0.105 -0.023 0.140 0.280 0.333 0.280 0.140 -0.023 -0.105 0.042)))
	  (snd-display #__line__ ";sg 11 4: ~A" (mus-xcoeffs flt))))
    (let ((flt (make-savitzky-golay-filter 25 2)))
      (if (not (vequal (mus-xcoeffs flt) (float-vector -0.049 -0.027 -0.006 0.012 0.028 0.043 0.055 0.066 0.075 0.082 0.086 
					      0.089 0.090 0.089 0.086 0.082 0.075 0.066 0.055 0.043 
					      0.028 0.012 -0.006 -0.027 -0.049)))
	  (snd-display #__line__ ";sg 25 2: ~A" (mus-xcoeffs flt))))
    
    (let ((gen (make-iir-filter 3 (float-vector .5 .25 .125)))
	  (v0 (make-float-vector 10))
	  (gen1 (make-iir-filter 3 (float-vector .5 .25 .125)))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "iir-filter"
		       "iir-filter order: 3, ys: [0.5 0.25 0.125]"
		       )
      (set! (v0 0) (iir-filter gen 1.0))
      (do ((i 1 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (iir-filter gen 0.0)))
      (let ((inp 1.0))
	(fill-float-vector v1 (let ((val (if (iir-filter? gen1) (iir-filter gen1 inp) -1.0)))
		       (set! inp 0.0)
		       val)))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map iir-filter: ~A ~A" v0 v1))
      (if (not (iir-filter? gen)) (snd-display #__line__ ";~A not iir-filter?" gen))
      (if (not (= (mus-length gen) 3)) (snd-display #__line__ ";iir-filter length: ~D?" (mus-length gen)))
      (if (or (fneq (v0 1) -0.25) (fneq (v0 2) -.062)) (snd-display #__line__ ";iir-filter output: ~A" v0))
      (let ((data (mus-ycoeffs gen)))
	(if (fneq (data 1) .25) (snd-display #__line__ ";iir-filter ycoeffs: ~A?" data)))
      (let ((tag (catch #t (lambda () (mus-ycoeff gen 123)) (lambda args (car args)))))
	(if (not (eq? tag 'mus-error))
	    (snd-display #__line__ ";ycoeff 123: ~A" tag)))
      (let ((tag (catch #t (lambda () (mus-xcoeff gen 123)) (lambda args (car args)))))
	(if (not (eq? tag 'mus-error))
	    (snd-display #__line__ ";iir xcoeff 123: ~A" tag))))
    
    (test-gen-equal (let ((f1 (make-iir-filter 3 (float-vector .5 .25 .125)))) (iir-filter f1 1.0) f1)
		    (let ((f2 (make-iir-filter 3 (float-vector .5 .25 .125)) )) (iir-filter f2 1.0) f2)
		    (let ((f3 (make-iir-filter 3 (float-vector .75 .25 .125)))) (iir-filter f3 1.0) f3))
    (test-gen-equal (let ((f1 (make-iir-filter 3 (float-vector .5 .25 .125)) )) (iir-filter f1 1.0) f1)
		    (let ((f2 (make-iir-filter 3 (float-vector .5 .25 .125)) )) (iir-filter f2 1.0) f2)
		    (let ((f3 (make-iir-filter 2 (float-vector .5 .25)))) (iir-filter f3 1.0) f3))
    
    (let ((gen (make-filter 3 (float-vector .5 .25 .125) (float-vector .5 .25 .125)))
	  (v0 (make-float-vector 10))
	  (gen1 (make-filter 3 (float-vector .5 .25 .125) (float-vector .5 .25 .125)))
	  (v1 (make-float-vector 10))
	  (gen2 (make-biquad .1 .2 .3 .4 .5)))
      (print-and-check gen 
		       "filter"
		       "filter order: 3, xs: [0.5 0.25 0.125], ys: [0.5 0.25 0.125]"
		       )
      (set! (v0 0) (filter gen 1.0))
      (do ((i 1 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (filter gen 0.0)))
      (let ((inp 1.0))
	(fill-float-vector v1 (let ((val (if (filter? gen1) (filter gen1 inp) -1.0)))
		       (set! inp 0.0)
		       val)))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map filter: ~A ~A" v0 v1))
      (if (not (filter? gen)) (snd-display #__line__ ";~A not filter?" gen))
      (if (not (= (mus-length gen) 3)) (snd-display #__line__ ";filter length: ~D?" (mus-length gen)))
      (if (or (fneq (v0 1) 0.125) (fneq (v0 2) .031)) (snd-display #__line__ ";filter output: ~A" v0))
      (if (not (filter? gen2)) (snd-display #__line__ ";make-biquad: ~A" gen2))
      (let ((xs (mus-xcoeffs gen))
	    (ys (mus-ycoeffs gen)))
	(if (or (not (equal? xs (float-vector .5 .25 .125)))
		(not (equal? xs ys)))
	    (snd-display #__line__ ";mus-xcoeffs: ~A ~A?" xs ys))))
    
    (let ((var (catch #t (lambda () (make-filter :order 2 :xcoeffs (float-vector 1.0 0.5) :ycoeffs (float-vector 2.0 1.0 0.5))) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";make-filter bad coeffs: ~A" var)))
    (let ((var (catch #t (lambda () (make-filter :order 0 :xcoeffs (float-vector 1.0 0.5))) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display #__line__ ";make-filter bad order: ~A" var)))
    (let ((var (catch #t (lambda () (make-fir-filter :order 22 :xcoeffs (float-vector 1.0 0.5))) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";make-fir-filter bad coeffs: ~A" var)))
    (let ((var (catch #t (lambda () (make-iir-filter :order 22 :ycoeffs (float-vector 1.0 0.5))) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";make-iir-filter bad coeffs: ~A" var)))
    (let ((var (catch #t (lambda () (make-fir-filter -1)) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display #__line__ ";make-fir-filter bad order: ~A" var)))
    (let ((var (make-filter :order 2 :ycoeffs (float-vector 1.0 0.5))))
      (if (not (iir-filter? var))
	  (snd-display #__line__ ";make-filter with only y: ~A" var)))
    
    (test-gen-equal (let ((f1 (make-filter 3 (float-vector .5 .25 .125) (float-vector .5 .25 .125)))) (filter f1 1.0) f1)
		    (let ((f2 (make-filter 3 (float-vector .5 .25 .125) (float-vector .5 .25 .125)))) (filter f2 1.0) f2)
		    (let ((f3 (make-filter 3 (float-vector .5 .25 .125) (float-vector .5 .5 .5)))) (filter f3 1.0) f3))
    (test-gen-equal (let ((f1 (make-filter 3 (float-vector .5 .25 .125) (float-vector .5 .25 .125)))) (filter f1 1.0) f1)
		    (let ((f2 (make-filter 3 (float-vector .5 .25 .125) (float-vector .5 .25 .125)))) (filter f2 1.0) f2)
		    (let ((f3 (make-filter 3 (float-vector .5 .5 .125) (float-vector .5 .25 .0625)))) (filter f3 1.0) f3))
    
    (let ((fr (make-fir-filter 6 (float-vector 0 1 2 3 4 5))))
      (if (not (= (mus-length fr) 6)) (snd-display #__line__ ";filter-length: ~A" (mus-length fr))))
    
    (let ((val (cascade->canonical (list (float-vector 1.0 0.0 0.0) (float-vector 1.0 0.5 0.25)))))
      (if (not (vequal val (float-vector 1.000 0.500 0.250 0.000 0.000)))
	  (snd-display #__line__ ";cas2can 0: ~A" val)))
    (let ((val (cascade->canonical (list (float-vector 1.0 1.0 0.0) (float-vector 1.0 0.5 0.25)))))
      (if (not (vequal val (float-vector 1.000 1.500 0.750 0.250 0.000)))
	  (snd-display #__line__ ";cas2can 1: ~A" val)))
    
    (let ((val (cascade->canonical (list (float-vector 1 0.8 0) (float-vector 1 1.4 0.65) (float-vector 1 0 0)))))
      (if (not (vequal val (float-vector 1.000 2.200 1.770 0.520 0.000 0.000 0.000)))
	  (snd-display #__line__ ";cascade->canonical: ~A" val)))
    (let ((val (cascade->canonical (list (float-vector 1 -0.9 0) (float-vector 1 1 0.74) (float-vector 1 -1.6 0.8)))))
      (if (not (vequal val (float-vector 1.000 -1.500 0.480 -0.330 0.938 -0.533 0.000)))
	  (snd-display #__line__ ";cascade->canonical 1: ~A" val)))
    
    (let ((ind (new-sound "test.snd" 1 22050 mus-ldouble mus-next)))
      (pad-channel 0 10000)
      (freq-sweep .45)
      (let ((sp (rough-spectrum ind)))
	(if (and (not (vequal sp (float-vector 0.962 0.998 0.998 0.998 0.998 0.999 0.999 0.998 0.997 1.000)))
		 (not (vequal sp (float-vector 0.963 0.999 0.999 0.999 0.999 0.999 1.000 1.000 0.998 0.997))))
	    (snd-display #__line__ ";initial rough spectrum: ~A" sp)))
      
      (let ((b (make-butter-high-pass 440.0))
	    (v (make-float-vector 10))
	    (d (make-delay 1)))
	(delay d (filter b 1.0))
	(fill-float-vector v (delay d (filter b 0.0)))
	(if (not (vequal v (float-vector 0.915 -0.162 -0.146 -0.131 -0.117 -0.103 -0.090 -0.078 -0.066 -0.056)))
	    (snd-display #__line__ ";butter high: ~A" v))
	(set! b (make-butter-high-pass 1000.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (and (not (vequal sp (float-vector 0.150 0.833 0.980 0.994 0.997 0.998 0.999 0.998 0.997 1.000)))
		   (not (vequal sp (float-vector 0.150 0.833 0.981 0.995 0.998 0.999 1.000 1.000 0.998 0.997))))
	      (snd-display #__line__ ";hp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-butter-low-pass 440.0))
	    (v (make-float-vector 10))
	    (d (make-delay 1)))
	(delay d (filter b 1.0))
	(fill-float-vector v (delay d (filter b 0.0)))
	(if (not (vequal v (float-vector 0.004 0.014 0.026 0.035 0.043 0.049 0.053 0.055 0.057 0.057)))
	    (snd-display #__line__ ";butter low: ~A" v))
	(set! b (make-butter-low-pass 1000.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (vequal sp (float-vector 1.000 0.212 0.024 0.005 0.001 0.000 0.000 0.000 0.000 0.000)))
	      (snd-display #__line__ ";lp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-butter-band-pass 440.0 50.0))
	    (v (make-float-vector 10))
	    (d (make-delay 1)))
	(delay d (filter b 1.0))
	(fill-float-vector v (delay d (filter b 0.0)))
	(if (not (vequal v (float-vector 0.007 0.014 0.013 0.013 0.012 0.011 0.009 0.008 0.007 0.005)))
	    (snd-display #__line__ ";butter bandpass: ~A" v))
	(set! b (make-butter-band-pass 1000.0 500.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (vequal sp (float-vector 0.888 1.000 0.144 0.056 0.027 0.014 0.008 0.004 0.002 0.000)))
	      (snd-display #__line__ ";bp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-butter-band-reject 440.0 50.0))
	    (v (make-float-vector 10))
	    (d (make-delay 1)))
	(delay d (filter b 1.0))
	(fill-float-vector v (delay d (filter b 0.0)))
	(if (not (vequal v (float-vector 0.993 -0.014 -0.013 -0.013 -0.012 -0.011 -0.009 -0.008 -0.007 -0.005)))
	    (snd-display #__line__ ";butter bandstop: ~A" v))
	(set! b (make-butter-band-reject 1000.0 500.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (and (not (vequal sp (float-vector 0.662 0.687 0.953 0.980 0.989 0.994 0.997 0.997 0.997 1.000)))
		   (not (vequal sp (float-vector 0.664 0.689 0.955 0.982 0.992 0.996 0.999 1.000 0.999 0.998))))
	      (snd-display #__line__ ";bs rough spectrum: ~A" sp)))
	(undo))
      
      (if (defined? 'gsl-roots) (analog-filter-tests))
      (test-lpc)
      (test-unclip-channel)
      
      (let ((v (spectrum->coeffs 10 (float-vector 0 1.0 0 0 0 0 0 0 1.0 0)))
	    (v1 (make-fir-coeffs 10 (float-vector 0 1.0 0 0 0 0 0 0 1.0 0))))
	(if (not (vequal v (float-vector -0.190 -0.118 0.000 0.118 0.190 0.190 0.118 0.000 -0.118 -0.190)))
	    (snd-display #__line__ ";spectrum->coeffs: ~A" v))
	(if (not (vequal v v1))
	    (snd-display #__line__ ";spectrum->coeffs v make-fir-coeffs: ~A ~A" v v1)))
      
      (let ((notched-spectr (make-float-vector 20)))
	(set! (notched-spectr 2) 1.0) 
	(let ((v (spectrum->coeffs 20 notched-spectr))
	      (v1 (make-fir-coeffs 20 notched-spectr)))
	  (if (not (vequal v (float-vector 0.095 0.059 -0.000 -0.059 -0.095 -0.095 -0.059 0.000 0.059 0.095 
				  0.095 0.059 0.000 -0.059 -0.095 -0.095 -0.059 -0.000 0.059 0.095)))
	      (snd-display #__line__ ";spectrum->coeffs (notch): ~A" v))
	  (if (not (vequal v v1))
	      (snd-display #__line__ ";spectrum->coeffs v(2) make-fir-coeffs: ~A ~A" v v1))
	  (let ((flt (make-fir-filter 20 v)))
	    (map-channel (lambda (y) (fir-filter flt y)))))
	(let ((sp (rough-spectrum ind)))
	  (if (not (vequal sp (float-vector 0.007 0.493 1.000 0.068 0.030 0.019 0.014 0.011 0.009 0.009)))
	      (snd-display #__line__ ";sp->coeff rough spectrum: ~A" sp)))
	(undo))
      
      (let ((rspect (make-float-vector 20)))
	(do ((i 0 (+ i 1)))
	    ((= i 20))
	  (set! (rspect i) (random 1.0)))
	(let ((v (spectrum->coeffs 20 rspect))
	      (v1 (make-fir-coeffs 20 rspect)))
	  (if (not (vequal v v1))
	      (snd-display #__line__ ";spectrum->coeffs v(3) make-fir-coeffs: ~A ~A" v v1))))
      
      (let ((b (make-highpass (hz->radians 1000.0) 10))
	    (v (make-float-vector 20))
	    (d (make-delay 1)))
	(delay d (fir-filter b 1.0))
	(fill-float-vector v (delay d (fir-filter b 0.0)))
	(if (not (vequal v (float-vector -0.001 -0.002 -0.005 -0.011 -0.021 -0.034 -0.049 -0.065 -0.078 -0.087 
				0.909 -0.087 -0.078 -0.065 -0.049 -0.034 -0.021 -0.011 -0.005 -0.002)))
	    (snd-display #__line__ ";dsp.scm high: ~A" v))
	(set! b (make-highpass (hz->radians 1000.0) 20))
	(map-channel (lambda (y) (fir-filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (and (not (vequal sp (float-vector 0.053 0.774 0.998 0.997 0.997 0.996 0.996 0.996 0.997 1.000)))
		   (not (vequal sp (float-vector 0.053 0.776 1.000 0.998 0.998 0.998 0.998 0.998 0.998 1.000))))
	      (snd-display #__line__ ";dsp hp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-lowpass (hz->radians 1000.0) 10))
	    (v (make-float-vector 20))
	    (d (make-delay 1)))
	(delay d (fir-filter b 1.0))
	(fill-float-vector v (delay d (fir-filter b 0.0)))
	(if (not (vequal v (float-vector 0.001 0.002 0.005 0.011 0.021 0.034 0.049 0.065 0.078 0.087 0.091 0.087 0.078 0.065
				0.049 0.034 0.021 0.011 0.005 0.002)))
	    (snd-display #__line__ ";dsp.scm low: ~A" v))
	(set! b (make-lowpass (hz->radians 1000.0) 20))
	(map-channel (lambda (y) (fir-filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (vequal sp (float-vector 1.000 0.054 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	      (snd-display #__line__ ";dsp lp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-bandpass (hz->radians 1500.0) (hz->radians 2000.0) 10))
	    (v (make-float-vector 20))
	    (d (make-delay 1)))
	(delay d (fir-filter b 1.0))
	(fill-float-vector v (delay d (fir-filter b 0.0)))
	(if (not (vequal v (float-vector 0.001 -0.001 -0.005 -0.011 -0.017 -0.019 -0.013 0.003 0.022 0.039 0.045
				0.039 0.022 0.003 -0.013 -0.019 -0.017 -0.011 -0.005 -0.001)))
	    (snd-display #__line__ ";dsp.scm bp: ~A" v))
	(set! b (make-bandpass (hz->radians 1500.0) (hz->radians 2000.0) 20))
	(map-channel (lambda (y) (fir-filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (vequal sp (float-vector 0.010 1.000 0.154 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	      (snd-display #__line__ ";dsp bp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-bandstop (hz->radians 1500.0) (hz->radians 2000.0) 10))
	    (v (make-float-vector 20))
	    (d (make-delay 1)))
	(delay d (fir-filter b 1.0))
	(fill-float-vector v (delay d (fir-filter b 0.0)))
	(if (not (vequal v (float-vector -0.001 0.001 0.005 0.011 0.017 0.019 0.013 -0.003 -0.022 -0.039 0.955
				-0.039 -0.022 -0.003 0.013 0.019 0.017 0.011 0.005 0.001)))
	    (snd-display #__line__ ";dsp.scm bs: ~A" v))
	(set! b (make-bandstop (hz->radians 1500.0) (hz->radians 2000.0) 20))
	(map-channel (lambda (y) (fir-filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (and (not (vequal sp (float-vector 0.904 0.425 0.821 0.998 0.997 0.996 0.996 0.996 0.997 1.000)))
		   (not (vequal sp (float-vector 0.906 0.425 0.822 1.000 0.999 0.998 0.998 0.998 0.998 1.000))))
	      (snd-display #__line__ ";dsp bs rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-differentiator 10))
	    (v (make-float-vector 20))
	    (d (make-delay 1)))
	(delay d (fir-filter b 1.0))
	(fill-float-vector v (delay d (fir-filter b 0.0)))
	(if (not (vequal v (float-vector -0.008 0.011 -0.021 0.039 -0.066 0.108 -0.171 0.270 -0.456 0.977
				0.000 -0.977 0.456 -0.270 0.171 -0.108 0.066 -0.039 0.021 -0.011)))
	    (snd-display #__line__ ";dsp.scm df: ~A" v))
	(set! b (make-differentiator 20))
	(map-channel (lambda (y) (fir-filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (vequal sp (float-vector 0.004 0.027 0.075 0.147 0.242 0.362 0.506 0.674 0.864 1.000)))
	      (snd-display #__line__ ";dsp df rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-iir-high-pass-2 440.0))
	    (v (make-float-vector 10))
	    (d (make-delay 1)))
	(delay d (filter b 1.0))
	(fill-float-vector v (delay d (filter b 0.0)))
	(if (not (vequal v (float-vector 0.915 -0.162 -0.146 -0.131 -0.117 -0.103 -0.090 -0.078 -0.066 -0.056)))
	    (snd-display #__line__ ";iir-2 high: ~A" v))
	(set! b (make-iir-high-pass-2 1000.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (and (not (vequal sp (float-vector 0.150 0.833 0.980 0.994 0.997 0.998 0.999 0.998 0.997 1.000)))
		   (not (vequal sp (float-vector 0.150 0.833 0.981 0.995 0.998 0.999 1.000 1.000 0.998 0.997))))
	      (snd-display #__line__ ";iir-2 hp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-iir-low-pass-2 440.0))
	    (v (make-float-vector 10))
	    (d (make-delay 1)))
	(delay d (filter b 1.0))
	(fill-float-vector v (delay d (filter b 0.0)))
	(if (not (vequal v (float-vector 0.004 0.014 0.026 0.035 0.043 0.049 0.053 0.055 0.057 0.057)))
	    (snd-display #__line__ ";iir-2 low: ~A" v))
	(set! b (make-iir-low-pass-2 1000.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (vequal sp (float-vector 1.000 0.212 0.024 0.005 0.001 0.000 0.000 0.000 0.000 0.000)))
	      (snd-display #__line__ ";iir-2 lp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-iir-band-pass-2 440.0 490.0))
	    (v (make-float-vector 10))
	    (d (make-delay 1)))
	(delay d (filter b 1.0))
	(fill-float-vector v (delay d (filter b 0.0)))
	(if (not (vequal v (float-vector 0.007 0.014 0.013 0.013 0.012 0.010 0.009 0.008 0.006 0.004)))
	    (snd-display #__line__ ";iir bp-2 bandpass: ~A" v))
	(set! b (make-iir-band-pass-2 1000.0 1500.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (vequal sp (float-vector 0.239 1.000 0.117 0.041 0.019 0.010 0.005 0.003 0.001 0.000)))
	      (snd-display #__line__ ";iir bp-2 rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-iir-band-stop-2 440.0 500.0))
	    (v (make-float-vector 10))
	    (d (make-delay 1)))
	(delay d (filter b 1.0))
	(fill-float-vector v (delay d (filter b 0.0)))
	(if (not (vequal v (float-vector 0.992 -0.017 -0.016 -0.015 -0.014 -0.012 -0.011 -0.009 -0.007 -0.005)))
	    (snd-display #__line__ ";iir-2 bandstop: ~A" v))
	(set! b (make-iir-band-stop-2 1000.0 1500.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (and (not (vequal sp (float-vector 0.836 0.525 0.943 0.979 0.989 0.994 0.997 0.997 0.997 1.000)))
		   (not (vequal sp (float-vector 0.838 0.527 0.945 0.981 0.991 0.996 0.999 1.000 0.999 0.998))))
	      (snd-display #__line__ ";iir bs-2 rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-butter-hp 4 440.0))
	    (v (make-float-vector 10))
	    (d (make-delay 1)))
	(delay d (filter b 1.0))
	(fill-float-vector v (delay d (filter b 0.0)))
	(if (and (not (vequal v (float-vector 0.725 -0.466 -0.315 -0.196 -0.104 -0.036 0.014 0.047 0.0685 0.0775)))
		 (not (vequal v (float-vector 0.725 -0.466 -0.315 -0.196 -0.104 -0.035 0.015 0.049 0.070 0.081)))
		 (not (vequal v (float-vector 0.725 -0.466 -0.315 -0.196 -0.104 -0.035 0.014 0.049 0.069 0.079))))
	    (snd-display #__line__ ";butter hp: ~A" v))
	(set! b (make-butter-hp 4 1000.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (and (not (vequal sp (float-vector 0.0505 0.982 1.000 1.000 0.998 0.998 0.999 0.998 0.996 0.999)))
		   (not (vequal sp (float-vector 0.051 0.982 1.000 1.000 0.998 0.998 0.998 0.999 0.997 0.995)))
		   (not (vequal sp (float-vector 0.051 0.991 1.000 1.000 0.998 0.998 0.999 0.999 0.997 0.995)))
		   (not (vequal sp (float-vector 0.045 0.970 1.000 1.000 0.998 0.998 0.999 0.999 0.997 0.995)))
		   (not (vequal sp (float-vector 0.052 0.971 1.000 1.000 0.998 0.998 0.999 0.999 0.997 0.995))))
	      (snd-display #__line__ ";bhp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-butter-lp 4 440.0))
	    (v (make-float-vector 10))
	    (d (make-delay 1)))
	(delay d (filter b 1.0))
	(fill-float-vector v (delay d (filter b 0.0)))
	(if (not (vequal v (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000))) ;; ???
	    (snd-display #__line__ ";butter lp: ~A" v))
	(set! b (make-butter-lp 4 1000.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (and (not (vequal sp (float-vector 1.000 0.035 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
		   (not (vequal sp (float-vector 1.000 0.038 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000))))
	      (snd-display #__line__ ";blp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-butter-bp 4 440.0 500.0))
	    (v (make-float-vector 10))
	    (d (make-delay 1)))
	(delay d (filter b 1.0))
	(fill-float-vector v (delay d (filter b 0.0)))
	(if (not (vequal v (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";butter bp: ~A" v))
	(set! b (make-butter-bp 4 1000.0 1500.0))
	(map-channel (lambda (y) (filter b y)))
	(undo))
      
      (let ((b (make-butter-bs 4 440.0 500.0))
	    (v (make-float-vector 10))
	    (d (make-delay 1)))
	(delay d (filter b 1.0))
	(fill-float-vector v (delay d (filter b 0.0)))
	(if (and (not (vequal v (float-vector 0.978 -0.043 -0.041 -0.038 -0.035 -0.031 -0.026 -0.0225 -0.015 -0.0085)))
		 (not (vequal v (float-vector 0.978 -0.043 -0.041 -0.038 -0.035 -0.031 -0.027 -0.022 -0.017 -0.011)))
		 (not (vequal v (float-vector 0.978 -0.043 -0.041 -0.038 -0.035 -0.031 -0.027 -0.021 -0.014 -0.011))))
	    (snd-display #__line__ ";butter bs: ~A" v))
	(set! b (make-butter-bs 4 1000.0 1500.0))
	(map-channel (lambda (y) (filter b y)))
	(undo))
      
      (revert-sound)
      (test-scanned-synthesis .1 10000 1.0 0.1 0.0)
      
      (close-sound ind))
    
    (let ((gen (make-sawtooth-wave 440.0))
	  (v0 (make-float-vector 10))
	  (gen1 (make-sawtooth-wave 440.0))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "sawtooth-wave"
		       "sawtooth-wave freq: 440.000Hz, phase: 3.142, amp: 1.000")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (sawtooth-wave gen 0.0)))
      (fill-float-vector v1 (if (sawtooth-wave? gen1) (sawtooth-wave gen1 0.0) -1.0))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map sawtooth: ~A ~A" v0 v1))
      (if (not (sawtooth-wave? gen)) (snd-display #__line__ ";~A not sawtooth-wave?" gen))
      (if (fneq (mus-phase gen) 4.39538) (snd-display #__line__ ";sawtooth-wave phase: ~F?" (mus-phase gen))) ;starts at pi
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";sawtooth-wave frequency: ~F?" (mus-frequency gen)))
      (set! (mus-frequency gen) 100.0)
      (if (fneq (mus-frequency gen) 100.0) (snd-display #__line__ ";set! sawtooth-wave frequency: ~F?" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 1.0) (snd-display #__line__ ";sawtooth-wave scaler: ~F?" (mus-scaler gen)))
      (set! (mus-scaler gen) 0.5)
      (if (fneq (mus-scaler gen) 0.5) (snd-display #__line__ ";set! sawtooth-wave scaler: ~F?" (mus-scaler gen)))
      (if (or (fneq (v0 1) 0.04) (fneq (v0 8) .319)) (snd-display #__line__ ";sawtooth-wave output: ~A" v0)))
    
    (test-gen-equal (make-sawtooth-wave 440.0) (make-sawtooth-wave 440.0) (make-sawtooth-wave 120.0))
    (test-gen-equal (make-sawtooth-wave 440.0) (make-sawtooth-wave 440.0) (make-sawtooth-wave 440.0 1.0 1.0))
    (test-gen-equal (make-sawtooth-wave 440.0) (make-sawtooth-wave 440.0) (make-sawtooth-wave 440.0 0.5))
    
    (let ((gen1 (make-sawtooth-wave 100.0))
	  (gen2 (make-sawtooth-wave -100.0))
	  (mx 0.0))
      (do ((i 0 (+ i 1)))
	  ((= i 100))
	(set! mx (max mx (abs (+ (gen1) (gen2))))))
      (if (fneq mx 0.0)
	  (snd-display #__line__ ";sawtooth +-: ~A" mx)))
    
    (let ((gen (make-square-wave 440.0))
	  (v0 (make-float-vector 10))
	  (gen1 (make-square-wave 440.0))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "square-wave"
		       "square-wave freq: 440.000Hz, phase: 0.000, amp: 1.000")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (square-wave gen 0.0)))
      (let ((w 1.0))
	(fill-float-vector v1 (begin
		       (set! w (mus-width gen1))
		       (if (square-wave? gen1) (square-wave gen1 0.0) -1.0)))
	(if (fneq w 0.5) (snd-display #__line__ ";mus-width opt: ~A" w)))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map square-wave: ~A ~A" v0 v1))
      (if (not (square-wave? gen)) (snd-display #__line__ ";~A not square-wave?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display #__line__ ";square-wave phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";square-wave frequency: ~F?" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 1.0) (snd-display #__line__ ";square-wave scaler: ~F?" (mus-scaler gen)))
      (set! (mus-scaler gen) 0.5)
      (if (fneq (mus-scaler gen) 0.5) (snd-display #__line__ ";set! square-wave scaler: ~F?" (mus-scaler gen)))
      (if (fneq (mus-width gen) 0.5) (snd-display #__line__ ";square-wave width: ~A" (mus-width gen)))
      (set! (mus-width gen) 0.75)
      (if (fneq (mus-width gen) 0.75) (snd-display #__line__ ";set! square-wave width: ~A" (mus-width gen)))
      (if (or (fneq (v0 1) 1.0) (fneq (v0 8) 1.0)) (snd-display #__line__ ";square-wave output: ~A" v0)))
    
    (test-gen-equal (make-square-wave 440.0) (make-square-wave 440.0) (make-square-wave 120.0))
    (test-gen-equal (make-square-wave 440.0) (make-square-wave 440.0) (make-square-wave 440.0 1.0 1.0))
    (test-gen-equal (make-square-wave 440.0) (make-square-wave 440.0) (make-square-wave 440.0 0.5))
    
    (let ((old-srate *clm-srate*))
      (set! *clm-srate* 500.0)
      (let ((gen (make-square-wave 100.0 -0.5 (* pi 0.5)))
	    (v0 (make-float-vector 20)))
	(do ((i 0 (+ i 1)))
	    ((= i 20))
	  (set! (v0 i) (gen)))
	(if (not (vequal v0 (float-vector -0.5 -0.5 0.0 0.0 -0.5 -0.5 -0.5 0.0 0.0 -0.5 -0.5 -0.5 0.0 0.0 -0.5 -0.5 -0.5 0.0 0.0 -0.5)))
	    (snd-display #__line__ ";square-wave -.5: ~A " v0)))
      (set! *clm-srate* old-srate))
    
    (let ((gen (make-triangle-wave 440.0))
	  (gen1 (make-triangle-wave 440.0 1.0 pi))
	  (v0 (make-float-vector 10))
	  (gen2 (make-triangle-wave 440.0))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "triangle-wave"
		       "triangle-wave freq: 440.000Hz, phase: 0.000, amp: 1.000")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (triangle-wave gen 0.0)))
      (fill-float-vector v1 (if (triangle-wave? gen2) (triangle-wave gen2 0.0) -1.0))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map triangle-wave: ~A ~A" v0 v1))
      (if (not (triangle-wave? gen)) (snd-display #__line__ ";~A not triangle-wave?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display #__line__ ";triangle-wave phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-phase gen1) pi) (snd-display #__line__ ";init triangle-wave phase: ~F?" (mus-phase gen1)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";triangle-wave frequency: ~F?" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 1.0) (snd-display #__line__ ";triangle-wave scaler: ~F?" (mus-scaler gen)))
      (set! (mus-scaler gen) 0.5)
      (if (fneq (mus-scaler gen) 0.5) (snd-display #__line__ ";set! triangle-wave scaler: ~F?" (mus-scaler gen)))
      (if (or (fneq (v0 1) 0.080) (fneq (v0 8) 0.639)) (snd-display #__line__ ";triangle-wave output: ~A" v0)))
    
    (let ((gen1 (make-triangle-wave 100.0))
	  (gen2 (make-triangle-wave -100.0))
	  (mx 0.0))
      (do ((i 0 (+ i 1)))
	  ((= i 100))
	(set! mx (max mx (abs (+ (gen1) (gen2))))))
      (if (fneq mx 0.0)
	  (snd-display #__line__ ";triangle +-: ~A" mx)))
    
    (test-gen-equal (make-triangle-wave 440.0) (make-triangle-wave 440.0) (make-triangle-wave 120.0))
    (test-gen-equal (make-triangle-wave 440.0) (make-triangle-wave 440.0) (make-triangle-wave 440.0 1.0 1.0))
    (test-gen-equal (make-triangle-wave 440.0) (make-triangle-wave 440.0) (make-triangle-wave 440.0 0.5))
    
    (let ((gen (make-pulse-train 440.0))
	  (v0 (make-float-vector 10))
	  (gen1 (make-pulse-train 440.0))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "pulse-train"
		       "pulse-train freq: 440.000Hz, phase: 0.000, amp: 1.000")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (pulse-train gen 0.0)))
      (fill-float-vector v1 (if (pulse-train? gen1) (pulse-train gen1 0.0) -1.0))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map pulse-train: ~A ~A" v0 v1))
      (if (not (pulse-train? gen)) (snd-display #__line__ ";~A not pulse-train?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display #__line__ ";pulse-train phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";pulse-train frequency: ~F?" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 1.0) (snd-display #__line__ ";pulse-train scaler: ~F?" (mus-scaler gen)))
      (set! (mus-scaler gen) 0.5)
      (if (fneq (mus-scaler gen) 0.5) (snd-display #__line__ ";set! pulse-train scaler: ~F?" (mus-scaler gen)))
      (if (or (fneq (v0 0) 1.0) (fneq (v0 8) 0.0)) (snd-display #__line__ ";pulse-train output: ~A" v0)))
    
    (test-gen-equal (make-pulse-train 440.0) (make-pulse-train 440.0) (make-pulse-train 120.0))
    (test-gen-equal (make-pulse-train 440.0) (make-pulse-train 440.0) (make-pulse-train 440.0 1.0 1.0))
    (test-gen-equal (make-pulse-train 440.0) (make-pulse-train 440.0) (make-pulse-train 440.0 0.5))
    
    (let ((old-srate *clm-srate*))
      (set! *clm-srate* 500.0)
      (let ((gen (make-pulse-train 100.0 -0.5 (* pi 0.5)))
	    (v0 (make-float-vector 20)))
	(do ((i 0 (+ i 1)))
	    ((= i 20))
	  (set! (v0 i) (gen)))
	(if (not (vequal v0 (float-vector  0.0 0.0 0.0 0.0 -0.5 0.0 0.0 0.0 0.0 -0.5 0.0 0.0 0.0 0.0 -0.5 0.0 0.0 0.0 0.0 -0.5)))
	    (snd-display #__line__ ";pulse-train -.5: ~A " v0)))
      (set! *clm-srate* old-srate))
    
    
    (let ((gen (make-two-pole 1200.0 .1)))
      (if (not (two-pole? gen)) (snd-display #__line__ ";~A not 2-polar?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display #__line__ ";2-polar order: ~D?" (mus-order gen)))
      (if (fneq (mus-xcoeff gen 0) 1.0) (snd-display #__line__ ";2-polar a0: ~F?" (mus-xcoeff gen 0)))
      (if (fneq (mus-ycoeff gen 1) -.188) (snd-display #__line__ ";2-polar b1: ~F?" (mus-ycoeff gen 1)))
      (if (fneq (mus-ycoeff gen 2) .01) (snd-display #__line__ ";2-polar b2: ~F?" (mus-ycoeff gen 2)))
      (if (fneq (mus-frequency gen) 1200.0) (snd-display #__line__ ";freq 2-polar: ~A" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 0.1) (snd-display #__line__ ";scaler 2-polar: ~A" (mus-scaler gen))))
    
    (let ((gen (make-two-pole :frequency 1200.0 :radius .1)))
      (if (not (two-pole? gen)) (snd-display #__line__ ";~A not f2-polar?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display #__line__ ";f2-polar order: ~D?" (mus-order gen)))
      (if (fneq (mus-xcoeff gen 0) 1.0) (snd-display #__line__ ";f2-polar a0: ~F?" (mus-xcoeff gen 0)))
      (if (fneq (mus-ycoeff gen 1) -.188) (snd-display #__line__ ";f2-polar b1: ~F?" (mus-ycoeff gen 1)))
      (if (fneq (mus-ycoeff gen 2) .01) (snd-display #__line__ ";f2-polar b2: ~F?" (mus-ycoeff gen 2)))
      (if (fneq (mus-frequency gen) 1200.0) (snd-display #__line__ ";freq f2-polar: ~A" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 0.1) (snd-display #__line__ ";scaler f2-polar: ~A" (mus-scaler gen))))
    
    (let ((gen (make-two-zero :radius .1 :frequency 1200.0)))
      (if (not (two-zero? gen)) (snd-display #__line__ ";~A not 2-zp?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display #__line__ ";2-zp order: ~D?" (mus-order gen)))
      (if (fneq (mus-xcoeff gen 0) 1.0) (snd-display #__line__ ";2-zp a0: ~F?" (mus-xcoeff gen 0)))
      (if (fneq (mus-xcoeff gen 1) -.188) (snd-display #__line__ ";2-zp a1: ~F?" (mus-xcoeff gen 1)))
      (if (fneq (mus-xcoeff gen 2) .01) (snd-display #__line__ ";2-zp a2: ~F?" (mus-xcoeff gen 2)))
      (if (fneq (mus-frequency gen) 1200.0) (snd-display #__line__ ";freq 2-zp: ~A" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 0.1) (snd-display #__line__ ";scaler 2-zp: ~A" (mus-scaler gen))))
    
    (let ((gen (make-two-zero 1200.0 .1)))
      (if (not (two-zero? gen)) (snd-display #__line__ ";~A not f2-zp?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display #__line__ ";f2-zp order: ~D?" (mus-order gen)))
      (if (fneq (mus-xcoeff gen 0) 1.0) (snd-display #__line__ ";f2-zp a0: ~F?" (mus-xcoeff gen 0)))
      (if (fneq (mus-xcoeff gen 1) -.188) (snd-display #__line__ ";f2-zp a1: ~F?" (mus-xcoeff gen 1)))
      (if (fneq (mus-xcoeff gen 2) .01) (snd-display #__line__ ";f2-zp a2: ~F?" (mus-xcoeff gen 2)))
      (if (fneq (mus-frequency gen) 1200.0) (snd-display #__line__ ";freq f2-zp: ~A" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 0.1) (snd-display #__line__ ";scaler f2-zp: ~A" (mus-scaler gen))))
    
    (let ((gen (make-formant 1200.0 0.9))
	  (v0 (make-float-vector 10))
	  (gen1 (make-formant 1200.0 0.9))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "formant"
		       "formant frequency: 1200.000, radius: 0.900")
      (set! (v0 0) (formant gen 1.0))
      (do ((i 1 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (formant gen 0.0)))
      (let ((inp 1.0))
	(fill-float-vector v1 (let ((val (if (formant? gen1) (formant gen1 inp) -1.0)))
		       (set! inp 0.0)
		       val)))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map formant: ~A ~A" v0 v1))
      (if (not (formant? gen)) (snd-display #__line__ ";~A not formant?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display #__line__ ";formant order: ~D?" (mus-order gen)))
      (if (fneq (mus-frequency gen) 1200.0) (snd-display #__line__ ";formant frequency: ~F?" (mus-frequency gen)))
      (if (or (fneq (v0 0) .095) (fneq (v0 1) .161)) (snd-display #__line__ ";formant output: ~A" v0))
      (if (fneq (mus-scaler gen) 0.9) (snd-display #__line__ ";formant gain: ~F?" (mus-scaler gen)))
      
      (set! (mus-scaler gen) 2.0)
      (if (fneq (mus-scaler gen) 2.0) (snd-display #__line__ ";formant set gain: ~F?" (mus-scaler gen))))
    
    (test-gen-equal (let ((f1 (make-formant 1200.0 0.9))) (formant f1 1.0) f1)
		    (let ((f2 (make-formant 1200.0 0.9))) (formant f2 1.0) f2)
		    (let ((f3 (make-formant 600.0 0.9))) (formant f3 1.0) f3))
    (test-gen-equal (let ((f1 (make-formant 1200.0 0.9))) (formant f1 1.0) f1)
		    (let ((f2 (make-formant 1200.0 0.9))) (formant f2 1.0) f2)
		    (let ((f3 (make-formant 1200.0 0.99))) (formant f3 1.0) f3))
    (test-gen-equal (let ((f1 (make-formant 1200.0 0.9))) (formant f1 1.0) f1)
		    (let ((f2 (make-formant 1200.0 0.9))) (formant f2 1.0) f2)
		    (let ((f3 (make-formant 1200.0 0.5))) (formant f3 1.0) f3))
    
    (let ((fs (make-vector 2))
	  (f0 (make-formant 1000.0 .1))
	  (f1 (make-formant 100.0 .2))
	  (amps (make-float-vector 2 1.0))
	  (val 1.0)
	  (v0 (make-float-vector 10))
	  (v1 (make-float-vector 10)))
      (set! (fs 0) (make-formant 1000.0 .1))
      (set! (fs 1) (make-formant 100.0 .2))
      (set! fs (make-formant-bank fs amps))
      (set! (amps 0) 0.5)
      (set! (amps 1) 0.25)
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (+ (* 0.5 (formant f0 val)) (* 0.25 (formant f1 val))))
	(set! (v1 i) (formant-bank fs val))
	(set! val 0.0))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";formant bank 1: ~A ~A" v0 v1)))
    
    (let ((fs (make-vector 2))
	  (amps (make-float-vector 2 1.0))
	  (val 1.0)
	  (v (make-float-vector 5)))
      (set! (fs 0) (make-formant 1000.0 .1))
      (set! (fs 1) (make-formant 100.0 .2))
      (set! fs (make-formant-bank fs amps))
      (set! (amps 0) 0.5)
      (set! (amps 1) 0.25)
      (fill-float-vector v (let ((res (formant-bank fs val))) (set! val 0.0) res))
      (if (not (vequal v (float-vector 0.368 0.095 -0.346 -0.091 -0.020))) (snd-display #__line__ ";run formant-bank: ~A" v)))
    
    (let ((ob (open-sound "oboe.snd")))
      (define (poltergeist frek amp R gain frek-env R-env)
	;; test courtesy of Anders Vinjar
	(let ((filt (make-formant frek R))
	      (fe (make-env :envelope frek-env :length (framples) :offset frek))
	      (re (make-env :envelope R-env :length (framples) :offset R)))
	  (lambda (y)
	    (let ((outval (* gain (formant filt (* amp y)))))
	      (mus-set-formant-radius-and-frequency filt (env re) (env fe))
	      outval))))
      (map-channel (poltergeist 300 0.1 0.0 30.0 '(0 100 1 4000.0) '(0 0.99 1 .9)))  ;; should sound like "whyieee?"
      (play ob :wait #t)
      (close-sound ob))
    
    (let ((gen (make-firmant 1200.0 0.9))
	  (v0 (make-float-vector 10))
	  (gen1 (make-firmant 1200.0 0.9))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "firmant"
		       "firmant frequency: 1200.000, radius: 0.900")
      (set! (v0 0) (firmant gen 1.0))
      (do ((i 1 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (firmant gen 0.0)))
      (let ((inp 1.0))
	(fill-float-vector v1 (let ((val (if (firmant? gen1) (firmant gen1 inp) -1.0)))
		       (set! inp 0.0)
		       val)))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map firmant: ~A ~A" v0 v1))
      (if (not (firmant? gen)) (snd-display #__line__ ";~A not firmant?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display #__line__ ";firmant order: ~D?" (mus-order gen)))
      (if (fneq (mus-frequency gen) 1200.0) (snd-display #__line__ ";firmant frequency: ~F?" (mus-frequency gen)))
      (if (or (fneq (v0 0) .058) (fneq (v0 1) .099)) (snd-display #__line__ ";firmant output: ~A" v0))
      (if (fneq (mus-scaler gen) 0.9) (snd-display #__line__ ";firmant gain: ~F?" (mus-scaler gen)))
      
      (set! (mus-scaler gen) .20)
      (if (fneq (mus-scaler gen) .20) (snd-display #__line__ ";firmant set gain: ~F?" (mus-scaler gen))))
    
    (test-gen-equal (let ((f1 (make-firmant 1200.0 0.9))) (firmant f1 1.0) f1)
		    (let ((f2 (make-firmant 1200.0 0.9))) (firmant f2 1.0) f2)
		    (let ((f3 (make-firmant 600.0 0.9))) (firmant f3 1.0) f3))
    (test-gen-equal (let ((f1 (make-firmant 1200.0 0.9))) (firmant f1 1.0) f1)
		    (let ((f2 (make-firmant 1200.0 0.9))) (firmant f2 1.0) f2)
		    (let ((f3 (make-firmant 1200.0 0.99))) (firmant f3 1.0) f3))
    (test-gen-equal (let ((f1 (make-firmant 1200.0 0.9))) (firmant f1 1.0) f1)
		    (let ((f2 (make-firmant 1200.0 0.9))) (firmant f2 1.0) f2)
		    (let ((f3 (make-firmant 1200.0 0.5))) (firmant f3 1.0) f3))
    
    (let ((gen (make-fft-window hamming-window 16)))
      (if (not (vequal gen (float-vector 0.080 0.115 0.215 0.364 0.540 0.716 0.865 1.000 1.000 0.865 0.716 0.540 0.364 0.215 0.115 0.080)))
	  (snd-display #__line__ ";hamming window: ~A" gen)))
    (let ((gen (make-fft-window rectangular-window 16)))
      (if (not (vequal gen (float-vector 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000)))
	  (snd-display #__line__ ";rectangular window: ~A" gen)))
    (let ((gen (make-fft-window hann-window 16)))
      (if (not (vequal gen (float-vector 0.000 0.038 0.146 0.309 0.500 0.691 0.854 1.000 1.000 0.854 0.691 0.500 0.309 0.146 0.038 0.000)))
	  (snd-display #__line__ ";hann window: ~A" gen)))
    (let ((gen (make-fft-window welch-window 16)))
      (if (not (vequal gen (float-vector 0.000 0.234 0.438 0.609 0.750 0.859 0.938 1.000 1.000 0.938 0.859 0.750 0.609 0.438 0.234 0.000)))
	  (snd-display #__line__ ";welch window: ~A" gen)))
    (let ((gen (make-fft-window connes-window 16)))
      (if (not (vequal gen (float-vector 0.000 0.055 0.191 0.371 0.562 0.739 0.879 1.000 1.000 0.879 0.739 0.562 0.371 0.191 0.055 0.000)))
	  (snd-display #__line__ ";connes window: ~A" gen)))
    (let ((gen (make-fft-window parzen-window 16)))
      (if (not (vequal gen (float-vector 0.000 0.125 0.250 0.375 0.500 0.625 0.750 1.000 1.000 0.750 0.625 0.500 0.375 0.250 0.125 0.000)))
	  (snd-display #__line__ ";parzen window: ~A" gen)))
    (let ((gen (make-fft-window bartlett-window 16)))
      (if (not (vequal gen (float-vector 0.000 0.125 0.250 0.375 0.500 0.625 0.750 1.000 1.000 0.750 0.625 0.500 0.375 0.250 0.125 0.000)))
	  (snd-display #__line__ ";bartlett window: ~A" gen)))
    (let ((gen (make-fft-window blackman2-window 16)))
      (if (not (vequal gen (float-vector 0.005 0.020 0.071 0.177 0.344 0.558 0.775 1.000 1.000 0.775 0.558 0.344 0.177 0.071 0.020 0.005)))
	  (snd-display #__line__ ";blackman2 window: ~A" gen)))
    (let ((gen (make-fft-window blackman3-window 16)))
      (if (not (vequal gen (float-vector 0.000 0.003 0.022 0.083 0.217 0.435 0.696 1.000 1.000 0.696 0.435 0.217 0.083 0.022 0.003 0.000)))
	  (snd-display #__line__ ";blackman3 window: ~A" gen)))
    (let ((gen (make-fft-window blackman4-window 16)))
      (if (not (vequal gen (float-vector 0.002 0.002 0.003 0.017 0.084 0.263 0.562 1.000 1.000 0.562 0.263 0.084 0.017 0.003 0.002 0.002)))
	  (snd-display #__line__ ";blackman4 window: ~A" gen)))
    
    (let ((gen (make-fft-window blackman5-window 16)))
      (if (not (vequal gen (float-vector 0.000 0.000 0.003 0.022 0.097 0.280 0.574 1.000 1.000 0.574 0.280 0.097 0.022 0.003 0.000 0.000)))
	  (snd-display #__line__ ";blackman5 window: ~A" gen)))
    (let ((gen (make-fft-window blackman6-window 16)))
      (if (not (vequal gen (float-vector 0.000 0.000 0.001 0.011 0.064 0.223 0.520 1.000 1.000 0.520 0.223 0.064 0.011 0.001 0.000 0.000)))
	  (snd-display #__line__ ";blackman6 window: ~A" gen)))
    (let ((gen (make-fft-window blackman7-window 16)))
      (if (not (vequal gen (float-vector 0.000 0.000 0.000 0.006 0.042 0.177 0.471 1.000 1.000 0.471 0.177 0.042 0.006 0.000 0.000 0.000)))
	  (snd-display #__line__ ";blackman7 window: ~A" gen)))
    (let ((gen (make-fft-window blackman8-window 16)))
      (if (not (vequal gen (float-vector 0.000 0.000 0.000 0.003 0.028 0.141 0.426 1.000 1.000 0.426 0.141 0.028 0.003 0.000 0.000 0.000)))
	  (snd-display #__line__ ";blackman8 window: ~A" gen)))
    (let ((gen (make-fft-window blackman9-window 16)))
      (if (not (vequal gen (float-vector 0.000 0.000 0.000 0.001 0.018 0.112 0.385 1.000 1.000 0.385 0.112 0.018 0.001 0.000 0.000 -0.000)))
	  (snd-display #__line__ ";blackman9 window: ~A" gen)))
    (let ((gen (make-fft-window blackman10-window 16)))
      (if (not (vequal gen (float-vector 0.000 0.000 0.000 0.001 0.012 0.089 0.349 1.000 1.000 0.349 0.089 0.012 0.001 0.000 0.000 -0.000)))
	  (snd-display #__line__ ";blackman10 window: ~A" gen)))
    (let ((gen (make-fft-window rv2-window 16)))
      (if (not (vequal gen (float-vector 0.000 0.001 0.021 0.095 0.250 0.478 0.729 1.000 1.000 0.729 0.478 0.250 0.095 0.021 0.001 0.000)))
	  (snd-display #__line__ ";rv2 window: ~A" gen)))
    (let ((gen (make-fft-window rv3-window 16)))
      (if (not (vequal gen (float-vector 0.000 0.000 0.003 0.029 0.125 0.330 0.622 1.000 1.000 0.622 0.330 0.125 0.029 0.003 0.000 0.000)))
	  (snd-display #__line__ ";rv3 window: ~A" gen)))
    (let ((gen (make-fft-window rv4-window 16)))
      (if (not (vequal gen (float-vector 0.000 0.000 0.000 0.009 0.062 0.228 0.531 1.000 1.000 0.531 0.228 0.062 0.009 0.000 0.000 0.000)))
	  (snd-display #__line__ ";rv4 window: ~A" gen)))
    
    (let ((gen (make-fft-window exponential-window 16)))
      (if (not (vequal gen (float-vector 0.000 0.087 0.181 0.283 0.394 0.515 0.646 0.944 0.944 0.646 0.515 0.394 0.283 0.181 0.087 0.000)))
	  (snd-display #__line__ ";exponential window: ~A" gen)))
    (let ((gen (make-fft-window riemann-window 16)))
      (if (not (vequal gen (float-vector 0.000 0.139 0.300 0.471 0.637 0.784 0.900 1.000 1.000 0.900 0.784 0.637 0.471 0.300 0.139 0.000)))
	  (snd-display #__line__ ";riemann window: ~A" gen)))
    (let ((gen (make-fft-window kaiser-window 16 2.5)))
      (if (not (vequal gen (float-vector 0.304 0.426 0.550 0.670 0.779 0.871 0.941 1.000 1.000 0.941 0.871 0.779 0.670 0.550 0.426 0.304)))
	  (snd-display #__line__ ";kaiser window: ~A" gen)))
    (let ((gen (make-fft-window cauchy-window 16 2.5)))
      (if (not (vequal gen (float-vector 0.138 0.173 0.221 0.291 0.390 0.532 0.719 1.000 1.000 0.719 0.532 0.390 0.291 0.221 0.173 0.138)))
	  (snd-display #__line__ ";cauchy window: ~A" gen)))
    (let ((gen (make-fft-window poisson-window 16 2.5)))
      (if (not (vequal gen (float-vector 0.082 0.112 0.153 0.210 0.287 0.392 0.535 1.000 1.000 0.535 0.392 0.287 0.210 0.153 0.112 0.082)))
	  (snd-display #__line__ ";poisson window: ~A" gen)))
    (let ((gen (make-fft-window gaussian-window 16 1.0)))
      (if (not (vequal gen (float-vector 0.607 0.682 0.755 0.823 0.882 0.932 0.969 1.000 1.000 0.969 0.932 0.882 0.823 0.755 0.682 0.607)))
	  (snd-display #__line__ ";gaussian window: ~A" gen)))
    (let ((gen (make-fft-window tukey-window 16)))
      (if (not (vequal gen (float-vector 0.000 0.038 0.146 0.309 0.500 0.691 0.854 1.000 1.000 0.854 0.691 0.500 0.309 0.146 0.038 0.000)))
	  (snd-display #__line__ ";tukey window: ~A" gen)))
    (let ((gen (make-fft-window hann-poisson-window 16)))
      (if (not (vequal gen (float-vector 0.000 0.038 0.146 0.309 0.500 0.691 0.854 1.000 1.000 0.854 0.691 0.500 0.309 0.146 0.038 0.000)))
	  (snd-display #__line__ ";tukey window: ~A" gen)))
    (let ((gen (make-fft-window bohman-window 16)))
      (if (not (vequal gen (float-vector 0.000 0.006 0.048 0.151 0.318 0.533 0.755 1.000 1.000 0.755 0.533 0.318 0.151 0.048 0.006 0.000)))
	  (snd-display #__line__ ";bohman window: ~A" gen)))
    
    (for-each
     (lambda (window-data)
       (let ((window (car window-data))
	     (func (caddr window-data))
	     (name (cadr window-data)))
	 (let ((v1 (make-fft-window window 16))
	       (v2 (make-float-vector 16))
	       (incr (/ (* 2 pi) 16.0)))
	   (do ((i 0 (+ i 1))
		(j 15 (- j 1))
		(ang 0.0 (+ ang incr)))
	       ((> i 8)) ; yikes -- even size + smallness = questionable code...
	     (let ((val (func ang)))
	       (set! (v2 i) val)
	       (set! (v2 j) val)))
	   (if (not (vequal v1 v2)) 
	       (snd-display #__line__ ";~A by hand:~%;  mus: ~A~%;  loc: ~A" name v1 v2)))))
     
     (list 
      (list hann-window "hann" (lambda (ang) 
				 (- 0.5 
				    (* 0.5 (cos ang)))))
      
      (list rv2-window "rv2" (lambda (ang) 
			       (+ .375 
				  (* -0.5 (cos ang)) 
				  (* .125 (cos (* 2 ang))))))
      
      (list rv3-window "rv3" (lambda (ang) 
			       (+ (/ 10.0 32.0) 
				  (* (/ -15.0 32.0) (cos ang)) 
				  (* (/ 6.0 32.0) (cos (* 2 ang))) 
				  (* (/ -1.0 32.0) (cos (* 3 ang))))))
      
      (list rv4-window "rv4" (lambda (ang) 
			       (+ (/ 35.0 128.0)
				  (* (/ -56.0 128.0) (cos ang)) 
				  (* (/ 28.0 128.0) (cos (* 2 ang))) 
				  (* (/ -8.0 128.0) (cos (* 3 ang)))
				  (* (/ 1.0 128.0) (cos (* 4 ang))))))
      
      (list hamming-window "hamming" (lambda (ang)
				       (- 0.54
					  (* 0.46 (cos ang)))))
      
      (list blackman2-window "blackman2" (lambda (ang)
					   (+ 0.42323 
					      (* -0.49755 (cos ang)) 
					      (* 0.07922 (cos (* 2 ang))))))
      
      (list blackman3-window "blackman3" (lambda (ang)
					   (+ 0.35875 
					      (* -0.48829 (cos ang)) 
					      (* 0.14128 (cos (* 2 ang))) 
					      (* -0.01168 (cos (* 3 ang))))))
      
      (list blackman4-window "blackman4" (lambda (ang)
					   (+ 0.287333 
					      (* -0.44716 (cos ang))
					      (* 0.20844 (cos (* 2 ang)))
					      (* -0.05190 (cos (* 3 ang)))
					      (* 0.005149 (cos (* 4 ang))))))
      
      (list blackman5-window "blackman5" (lambda (ang)
					   (+ .293557 
					      (* -.451935 (cos ang))
					      (* .201416 (cos (* 2 ang)))
					      (* -.047926 (cos (* 3 ang)))
					      (* .00502619 (cos (* 4 ang)))
					      (* -.000137555 (cos (* 5 ang))))))
      
      (list blackman6-window "blackman6" (lambda (ang)
					   (+ .271220 
					      (* -.433444 (cos ang))
					      (* .218004 (cos (* 2 ang)))
					      (* -.065785 (cos (* 3 ang)))
					      (* .01076186 (cos (* 4 ang)))
					      (* -.000770012 (cos (* 5 ang)))
					      (* .0000136808 (cos (* 6 ang)))))) 
      
      (list blackman7-window "blackman7" (lambda (ang)
					   (+ .253317 
					      (* -.416327 (cos ang))
					      (* .228839 (cos (* 2 ang)))
					      (* -.081575 (cos (* 3 ang)))
					      (* .01773592 (cos (* 4 ang)))
					      (* -.002096702 (cos (* 5 ang)))
					      (* .0001067741 (cos (* 6 ang)))
					      (* -.0000012807(cos (* 7 ang))))))
      
      (list blackman8-window "blackman8" (lambda (ang)
					   (+ .238433 
					      (* -.400554 (cos ang))
					      (* .235824 (cos (* 2 ang)))
					      (* -.095279 (cos (* 3 ang)))
					      (* .02537395 (cos (* 4 ang)))
					      (* -.00415243  (cos (* 5 ang)))
					      (* .0003685604 (cos (* 6 ang)))
					      (* -.0000138435 (cos (* 7 ang)))
					      (* .000000116180(cos (* 8 ang))))))
      
      (list blackman9-window "blackman9" (lambda (ang)
					   (+ .225734 
					      (* -.386012 (cos ang))
					      (* .240129 (cos (* 2 ang)))
					      (* -.107054 (cos (* 3 ang)))
					      (* .03325916 (cos (* 4 ang)))
					      (* -.00687337  (cos (* 5 ang)))
					      (* .0008751673 (cos (* 6 ang)))
					      (* -.0000600859 (cos (* 7 ang)))
					      (* .000001710716 (cos (* 8 ang)))
					      (* -.00000001027272(cos (* 9 ang))))))
      
      (list blackman10-window "blackman10" (lambda (ang)
					     (+ .215153 
						(* -.373135 (cos ang))
						(* .242424 (cos (* 2 ang)))
						(* -.1166907 (cos (* 3 ang)))
						(* .04077422 (cos (* 4 ang)))
						(* -.01000904 (cos (* 5 ang)))
						(* .0016398069 (cos (* 6 ang)))
						(* -.0001651660 (cos (* 7 ang)))
						(* .000008884663 (cos (* 8 ang)))
						(* -.000000193817 (cos (* 9 ang)))
						(* .000000000848248(cos (* 10 ang))))))
      
      (list rectangular-window "rectangular" (lambda (ang) 1.0))
      
      (list bartlett-window "bartlett" (let ((val 0.0)) 
					 (lambda (ang)
					   (let ((result val))
					     (set! val (+ val (/ 1.0 8)))
					     result))))
      
      (list parzen-window "parzen" (let ((i 0))
				     (lambda (ang)
				       (let ((result (- 1.0 (abs (/ (- i 8) 8.0)))))
					 (set! i (+ i 1))
					 result))))
      
      (list welch-window "welch" (let ((i 0)
				       (sqr (lambda (x) (* x x))))
				   (lambda (ang)
				     (let ((result (- 1.0 (sqr (/ (- i 8) 8.0)))))
				       (set! i (+ i 1))
				       result))))
      
      (list flat-top-window "flat-top" (lambda (ang)
					 (+ 0.2156 
					    (* -0.4160 (cos ang))
					    (* 0.2781 (cos (* 2 ang)))
					    (* -0.0836 (cos (* 3 ang)))
					    (* 0.0069 (cos (* 4 ang))))))
      
      (list bohman-window "bohman" (let ((i 0))
				     (lambda (ang)
				       (let* ((r (/ (- 8 i) 8))
					      (result (+ (* (- 1.0 r) (cos (* pi r)))
							 (* (/ 1.0 pi) (sin (* pi r))))))
					 (set! i (+ i 1))
					 result))))
      
      (list bartlett-hann-window "bartlett-hann" (let ((i 0))
						   (lambda (ang)
						     (let ((result (+ 0.62 
								      (* -0.48 (abs (- (/ i 16.0) 0.5))) 
								      (* 0.38 (cos (* 2 pi (- (/ i 16.0) 0.5)))))))
						       (set! i (+ i 1))
						       result))))
      
      (list connes-window "connes" (let ((i 0)
					 (sqr (lambda (x) (* x x))))
				     (lambda (ang)
				       (let ((result (sqr (- 1.0 (sqr (/ (- i 8) 8.0))))))
					 (set! i (+ i 1))
					 result))))
      
      (list riemann-window "riemann" (let ((i 0))
				       (lambda (ang)
					 (let ((result (if (= 8 i) 
							   1.0
							   (/ (sin (* (/ (* 2 pi) 16.) (- 8 i))) (* (/ (* 2 pi) 16.0) (- 8 i))))))
					   (set! i (+ i 1))
					   result))))
      
      (list exponential-window "exponential" (let ((expsum 1.0))
					       (lambda (ang)
						 (let ((result (- expsum 1.0))) 
						   (set! expsum (* expsum (+ 1.0 (/ (log 2) 8.0))))
						   result))))
      ))
    
    (let ((win (make-fft-window bartlett-hann-window 32))
	  (unhappy #f))
      (do ((i 0 (+ i 1))) 
	  ((or unhappy (= i 32)))
	(let ((val (+ 0.62 (* -0.48 (abs (- (/ i 31) 0.5))) (* 0.38 (cos (* 2 pi (- (/ i 31) 0.5)))))))
	  (if (> (abs (- val (win i))) .03)
	      (begin
		(set! unhappy #t)
		(snd-display #__line__ ";bartlett-hann at ~D: ~A ~A" i val (win i)))))))
    (let ((win (make-fft-window flat-top-window 32))
	  (unhappy #f))
      (do ((i 0 (+ i 1))) 
	  ((or unhappy (= i 32)))
	(let ((val (+ 0.2156 
		      (* -0.4160 (cos (/ (* 2 pi i) 31))) 
		      (* 0.2781 (cos (/ (* 4 pi i) 31))) 
		      (* -0.0836 (cos (/ (* 6 pi i) 31))) 
		      (* 0.0069 (cos (/ (* 8 pi i) 31))))))
	  (if (> (abs (- val (win i))) .1) ; error is much less, of course, in a bigger window
	      (begin
		(set! unhappy #t)
		(snd-display #__line__ ";flat-top at ~D: ~A ~A" i val (win i)))))))
    (catch #t
	   (lambda ()
	     (let ((gen (make-fft-window samaraki-window 16)))
	       (if (not (vequal gen (float-vector 1.000 0.531 0.559 0.583 0.604 0.620 0.631 0.638 0.640 0.638 0.631 0.620 0.604 0.583 0.559 0.531)))
		   (snd-display #__line__ ";samaraki window: ~A" gen)))
	     (let ((gen (make-fft-window ultraspherical-window 16)))
	       (if (not (vequal gen (float-vector 1.000 0.033 0.034 0.035 0.036 0.036 0.037 0.037 0.037 0.037 0.037 0.036 0.036 0.035 0.034 0.033)))
		   (snd-display #__line__ ";ultraspherical window: ~A" gen)))
	     (let ((gen (make-fft-window dolph-chebyshev-window 16)))
	       (if (not (vequal gen (float-vector 1.000 0.033 0.034 0.035 0.036 0.036 0.037 0.037 0.037 0.037 0.037 0.036 0.036 0.035 0.034 0.033)))
		   (snd-display #__line__ ";dolph-chebyshev window: ~A" gen)))
	     
	     (without-errors
	      (let ((gen (make-fft-window dolph-chebyshev-window 16 1.0)))
		(if (not (vequal gen (float-vector 1.000 0.274 0.334 0.393 0.446 0.491 0.525 0.546 0.553 0.546 0.525 0.491 0.446 0.393 0.334 0.274)))
		    (snd-display #__line__ ";dolph-chebyshev window: ~A" gen))))
	     
	     (let ((val1 (make-fft-window ultraspherical-window 16 0.0 0.0))
		   (val2 (make-fft-window dolph-chebyshev-window 16 0.0)))
	       (if (not (vequal val1 val2)) (snd-display #__line__ ";ultra/dolph 0: ~A ~A" val1 val2)))  
	     (let ((val1 (make-fft-window ultraspherical-window 16 0.0 1.0))
		   (val2 (make-fft-window samaraki-window 16 0.0)))
	       (if (not (vequal val1 val2)) (snd-display #__line__ ";ultra/sam 0: ~A ~A" val1 val2)))
	     (let ((val1 (make-fft-window ultraspherical-window 16 0.5 0.0))
		   (val2 (make-fft-window dolph-chebyshev-window 16 0.5)))
	       (if (not (vequal val1 val2)) (snd-display #__line__ ";ultra/dolph 5: ~A ~A" val1 val2)))  
	     (let ((val1 (make-fft-window ultraspherical-window 16 0.5 1.0))
		   (val2 (make-fft-window samaraki-window 16 0.5)))
	       (if (not (vequal val1 val2)) (snd-display #__line__ ";ultra/sam 5: ~A ~A" val1 val2)))
	     (let ((val1 (dolph 16 1.0))
		   (val2 (make-fft-window dolph-chebyshev-window 16 1.0)))
	       (if (not (vequal val1 val2)) (snd-display #__line__ ";dolph/dolph 1: ~A ~A" val1 val2))))
	   (lambda args (snd-display #__line__ ";new windows: ~A" args)))
    
    (if (defined? 'gsl-eigenvectors)
	(begin
	  (let ((win (make-dpss-window 16 .01)))
	    (if (not (vequal win (float-vector 0.964 0.973 0.981 0.987 0.992 0.996 0.999 1.000 1.000 0.999 0.996 0.992 0.987 0.981 0.973 0.964)))
		(snd-display #__line__ ";make-dpss-window 16 .01: ~A" win)))
	  (let ((win (make-dpss-window 16 .1)))
	    (if (not (vequal win (float-vector 0.090 0.193 0.332 0.494 0.664 0.818 0.936 1.000 1.000 0.936 0.818 0.664 0.494 0.332 0.193 0.090)))
		(snd-display #__line__ ";make-dpss-window 16 .1: ~A" win)))
	  (let ((win (make-dpss-window 32 .09)))
	    (if (not (vequal win (float-vector 0.004 0.011 0.025 0.050 0.086 0.138 0.206 0.290 0.388 0.496 0.610 0.722 0.823 0.908 0.968 1.000 
				      1.000 0.968 0.908 0.823 0.722 0.610 0.496 0.388 0.290 0.206 0.138 0.086 0.050 0.025 0.011 0.004)))
		(snd-display #__line__ ";make-dpss-window 32 .09: ~A" win)))
	  
	  (for-each
	   (lambda (n)
	     (for-each
	      (lambda (beta)
		(let ((win1 (make-dpss-window n beta))
		      (win2 (make-fft-window dpss-window n beta)))
		  (if (not (vequal win1 win2))
		      (snd-display #__line__ ";dpss-windows:~%    ~A~%    ~A" win1 win2))))
	      (list .01 .07 .12 .2)))
	   (list 16 32))))
    
    (let ((win (make-papoulis-window 32)))
      (if (not (vequal win (float-vector 0.000 0.001 0.006 0.021 0.048 0.091 0.151 0.227 0.318 0.422 0.533 0.647 0.755 0.852 0.930 0.982 
				1.000 0.982 0.930 0.852 0.755 0.647 0.533 0.422 0.318 0.227 0.151 0.091 0.048 0.021 0.006 0.001)))
	  (snd-display #__line__ ";make-papoulis-window 32: ~A" win)))
    
    (for-each
     (lambda (n)
       (let ((win1 (make-papoulis-window n))
	     (win2 (make-fft-window papoulis-window n)))
	 (if (not (vequal win1 win2))
	     (snd-display #__line__ ";papoulis-windows:~%    ~A~%    ~A" win1 win2))))
     (list 32 64 256))
    
    
    (let ((v0 (make-float-vector 10))
	  (gen (make-env '(0 0 1 1 2 0) :scaler 0.5 :length 11))
	  (v1 (make-float-vector 10))
	  (gen1 (make-env '(0 0 1 1 2 0) :scaler 0.5 :length 11)))
      (print-and-check gen 
		       "env"
		       "env linear, pass: 0 (dur: 11), index: 0, scaler: 0.5000, offset: 0.0000, data: [0 0 1 1 2 0]")
      (if (not (env? gen)) (snd-display #__line__ ";~A not env?" gen))
      (if (fneq (mus-scaler gen) 0.5) (snd-display #__line__ ";env scaler ~F?" (mus-scaler gen)))
      (if (fneq (mus-increment gen) 1.0) (snd-display #__line__ ";env base (1.0): ~A?" (mus-increment gen)))
      (if (not (= (mus-length gen) 11)) (snd-display #__line__ ";env length: ~A" (mus-length gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (env gen)))
      (let ((off 123.0))
	(fill-float-vector v1 (begin
		       (set! off (mus-offset gen1))
		       (if (env? gen1) (env gen1) -1.0)))
	(if (fneq off 0.0) (snd-display #__line__ ";mus-offset opt: ~A" off)))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map env: ~A ~A" v0 v1))
      (if (or (fneq (v0 0) 0.0) (fneq (v0 1) .1) (fneq (v0 6) .4))
	  (snd-display #__line__ ";~A output: ~A" gen v0))
      (if (fneq (env-interp 1.6 gen) 0.2) (snd-display #__line__ ";env-interp ~A at 1.6: ~F?" gen (env-interp 1.5 gen)))
      (set! gen (make-env :envelope '(0 1 1 0) :base 32.0 :length 11))
      (if (fneq (mus-increment gen) 32.0) (snd-display #__line__ ";env base (32.0): ~A?" (mus-increment gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (env gen)))
      (if (or (fneq (v0 0) 1.0) (fneq (v0 1) .698) (fneq (v0 8) .032))
	  (snd-display #__line__ ";~A output: ~A" gen v0))
      (set! gen (make-env :envelope '(0 1 1 0) :base .0325 :length 11))
      (if (fneq (mus-increment gen) .0325) (snd-display #__line__ ";env base (.0325): ~A?" (mus-increment gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (env gen)))
      (if (or (fneq (v0 0) 1.0) (fneq (v0 1) .986) (fneq (v0 8) .513))
	  (snd-display #__line__ ";~A output: ~A" gen v0))
      (set! gen (make-env :envelope '(0 1 1 .5 2 0) :base 0.0 :length 11 :offset 1.0))
      (if (fneq (mus-offset gen) 1.0) (snd-display #__line__ ";mus-offset: ~A" (mus-offset gen)))
      (if (fneq (mus-increment gen) 0.0) (snd-display #__line__ ";env base (0.0): ~A?" (mus-increment gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(if (and (= i 3)
		 (not (= (mus-location gen) 3)))
	    (snd-display #__line__ ";env location: ~A?" (mus-location gen)))
	(set! (v0 i) (env gen)))
      (if (or (fneq (v0 0) 2.0) (fneq (v0 6) 1.5) (fneq (v0 8) 1.5))
	  (snd-display #__line__ ";~A output: ~A" gen v0))
      (if (fneq (env-interp 1.5 gen) 1.5) (snd-display #__line__ ";env-interp ~A at 1.5: ~F?" gen (env-interp 1.5 gen)))
      (set! (mus-location gen) 6)
      (if (not (= (mus-location gen) 6)) (snd-display #__line__ ";set! mus-location ~A (6)?" (mus-location gen)))
      (let ((val (env gen)))
	(if (fneq val 1.5) (snd-display #__line__ ";set! mus-location 6 -> ~A (1.5)?" val)))
      (set! (mus-location gen) 0)
      (let ((val (env gen)))
	(if (fneq val 2.0) (snd-display #__line__ ";set! mus-location 0 -> ~A (2.0)?" val)))
      (let ((gen (make-env '(0 0 1 -1 2 0) :length 11)))
	(do ((i 0 (+ i 1)))
	    ((= i 5))
	  (let ((val (env gen)))
	    (if (fneq val (/ i -5.0)) (snd-display #__line__ ";neg env: ~D ~A" i val))))
	(do ((i 0 (+ i 1)))
	    ((= i 5))
	  (let ((val (env gen)))
	    (if (fneq val (+ -1.0 (/ i 5.0))) (snd-display #__line__ ";neg env: ~D ~A" (+ i 5) val)))))
      (let ((gen (make-env '(0 0 1 -1 2 0) :length 11 :base 0.5))
	    (v (float-vector 0.0 -0.14869 -0.31950 -0.51571 -0.74110 -1.0 -0.74110 -0.51571 -0.31950 -0.14869)))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (let ((val (env gen)))
	    (if (fneq val (v i)) (snd-display #__line__ ";neg exp env: ~D ~A" i val))))
	(mus-apply gen))
      
      (let ((v (make-float-vector 10)))
	(let ((e (make-env '(0 0 1 1) :length 10)))
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (set! (v i) (env e)))
	  (if (not (vequal v (float-vector 0.000 0.111 0.222 0.333 0.444 0.556 0.667 0.778 0.889 1.000)))
	      (snd-display #__line__ ";simple ramp: ~A" v)))
	(let ((v (make-float-vector 10)))
	  (let ((e (make-env '(0 0 1 1) :base 0 :length 8)))
	    (do ((i 0 (+ i 1)))
		((= i 10))
	      (set! (v i) (env e)))
	    (if (not (vequal v (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 1.000 1.000)))
		(snd-display #__line__ ";simple ramp, base 0: ~A" v))))
	(let ((v (make-float-vector 10)))
	  (let ((e (make-env '(0 0 1 1 2 .5) :base 0 :length 8)))
	    (do ((i 0 (+ i 1)))
		((= i 10))
	      (set! (v i) (env e)))
	    (if (not (vequal v (float-vector 0.000 0.000 0.000 0.000 1.000 1.000 1.000 1.000 0.500 0.500)))
		(snd-display #__line__ ";two-step, base 0: ~A" v))))
	(let ((e (make-env '((0 0) (1 1)) :length 10)))
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (set! (v i) (env e)))
	  (if (not (vequal v (float-vector 0.000 0.111 0.222 0.333 0.444 0.556 0.667 0.778 0.889 1.000)))
	      (snd-display #__line__ ";simple ramp embedded: ~A" v)))
	(let ((e (make-env '(0 1 1 0) :length 10)))
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (set! (v i) (env e)))
	  (if (not (vequal v (float-vector 1.000 0.889 0.778 0.667 0.556 0.444 0.333 0.222 0.111 0.000)))
	      (snd-display #__line__ ";simple ramp down: ~A" v)))
	(let ((e (make-env '(0 0 1 1 2 0) :length 10)))
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (set! (v i) (env e)))
	  (if (not (vequal v (float-vector 0.000 0.200 0.400 0.600 0.800 1.000 0.750 0.500 0.250 0.000)))
	      (snd-display #__line__ ";simple pyr: ~A" v)))
	(let ((e (make-env '((0 0) (1 1) (2 0)) :length 10)))
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (set! (v i) (env e)))
	  (if (not (vequal v (float-vector 0.000 0.200 0.400 0.600 0.800 1.000 0.750 0.500 0.250 0.000)))
	      (snd-display #__line__ ";simple pyr embedded: ~A" v)))
	(let ((e (make-env '(0 0 1 1 2 -.5) :length 10)))
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (set! (v i) (env e)))
	  (if (not (vequal v (float-vector 0.000 0.200 0.400 0.600 0.800 1.000 0.625 0.250 -0.125 -0.500)))
	      (snd-display #__line__ ";simple pyr -.5: ~A" v)))
	(let ((e (make-env '((0 0) (1 1) (2 -.5)) :length 10)))
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (set! (v i) (env e)))
	  (if (not (vequal v (float-vector 0.000 0.200 0.400 0.600 0.800 1.000 0.625 0.250 -0.125 -0.500)))
	      (snd-display #__line__ ";simple pyr -.5 embedded: ~A" v)))
	(let ((e (make-env '(0 0 1 1 2 -.5) :length 10)))
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (set! (v i) (env e)))
	  (if (not (vequal v (float-vector 0.000 0.200 0.400 0.600 0.800 1.000 0.625 0.250 -0.125 -0.500)))
	      (snd-display #__line__ ";simple pyr -.5: ~A" v))))
      
      (let ((v (make-float-vector 10)))
	(let ((e (make-env (float-vector 0 0 1 1) :length 10)))
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (set! (v i) (env e)))
	  (if (not (vequal v (float-vector 0.000 0.111 0.222 0.333 0.444 0.556 0.667 0.778 0.889 1.000)))
	      (snd-display #__line__ ";simple ramp: ~A" v)))
	(let ((v (make-float-vector 10)))
	  (let ((e (make-env (float-vector 0 0 1 1) :base 0 :length 8)))
	    (do ((i 0 (+ i 1)))
		((= i 10))
	      (set! (v i) (env e)))
	    (if (not (vequal v (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 1.000 1.000)))
		(snd-display #__line__ ";simple ramp, base 0: ~A" v))))
	(let ((v (make-float-vector 10)))
	  (let ((e (make-env (float-vector 0 0 1 1 2 .5) :base 0 :length 8)))
	    (do ((i 0 (+ i 1)))
		((= i 10))
	      (set! (v i) (env e)))
	    (if (not (vequal v (float-vector 0.000 0.000 0.000 0.000 1.000 1.000 1.000 1.000 0.500 0.500)))
		(snd-display #__line__ ";two-step, base 0: ~A" v))))
	(let ((e (make-env (float-vector 0 1 1 0) :length 10)))
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (set! (v i) (env e)))
	  (if (not (vequal v (float-vector 1.000 0.889 0.778 0.667 0.556 0.444 0.333 0.222 0.111 0.000)))
	      (snd-display #__line__ ";simple ramp down: ~A" v)))
	(let ((e (make-env (float-vector 0 0 1 1 2 0) :length 10)))
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (set! (v i) (env e)))
	  (if (not (vequal v (float-vector 0.000 0.200 0.400 0.600 0.800 1.000 0.750 0.500 0.250 0.000)))
	      (snd-display #__line__ ";simple pyr: ~A" v)))
	(let ((e (make-env (float-vector 0 0 1 1 2 -.5) :length 10)))
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (set! (v i) (env e)))
	  (if (not (vequal v (float-vector 0.000 0.200 0.400 0.600 0.800 1.000 0.625 0.250 -0.125 -0.500)))
	      (snd-display #__line__ ";simple pyr -.5: ~A" v)))
	(let ((e (make-env (float-vector 0 0 1 1 2 -.5) :length 10)))
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (set! (v i) (env e)))
	  (if (not (vequal v (float-vector 0.000 0.200 0.400 0.600 0.800 1.000 0.625 0.250 -0.125 -0.500)))
	      (snd-display #__line__ ";simple pyr -.5: ~A" v))))
      
      (let ((v (make-float-vector 10)))
	(let ((e (make-env (vector 0 0 1 1) :length 10)))
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (set! (v i) (env e)))
	  (if (not (vequal v (float-vector 0.000 0.111 0.222 0.333 0.444 0.556 0.667 0.778 0.889 1.000)))
	      (snd-display #__line__ ";simple ramp: ~A" v)))
	(let ((v (make-float-vector 10)))
	  (let ((e (make-env (vector 0 0 1 1) :base 0 :length 8)))
	    (do ((i 0 (+ i 1)))
		((= i 10))
	      (set! (v i) (env e)))
	    (if (not (vequal v (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 1.000 1.000)))
		(snd-display #__line__ ";simple ramp, base 0: ~A" v))))
	(let ((v (make-float-vector 10)))
	  (let ((e (make-env (vector 0 0 1 1 2 .5) :base 0 :length 8)))
	    (do ((i 0 (+ i 1)))
		((= i 10))
	      (set! (v i) (env e)))
	    (if (not (vequal v (float-vector 0.000 0.000 0.000 0.000 1.000 1.000 1.000 1.000 0.500 0.500)))
		(snd-display #__line__ ";two-step, base 0: ~A" v))))
	(let ((e (make-env (vector 0 1 1 0) :length 10)))
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (set! (v i) (env e)))
	  (if (not (vequal v (float-vector 1.000 0.889 0.778 0.667 0.556 0.444 0.333 0.222 0.111 0.000)))
	      (snd-display #__line__ ";simple ramp down: ~A" v)))
	(let ((e (make-env (vector 0 0 1 1 2 0) :length 10)))
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (set! (v i) (env e)))
	  (if (not (vequal v (float-vector 0.000 0.200 0.400 0.600 0.800 1.000 0.750 0.500 0.250 0.000)))
	      (snd-display #__line__ ";simple pyr: ~A" v)))
	(let ((e (make-env (vector 0 0 1 1 2 -.5) :length 10)))
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (set! (v i) (env e)))
	  (if (not (vequal v (float-vector 0.000 0.200 0.400 0.600 0.800 1.000 0.625 0.250 -0.125 -0.500)))
	      (snd-display #__line__ ";simple pyr -.5: ~A" v)))
	(let ((e (make-env (vector 0 0 1 1 2 -.5) :length 10)))
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (set! (v i) (env e)))
	  (if (not (vequal v (float-vector 0.000 0.200 0.400 0.600 0.800 1.000 0.625 0.250 -0.125 -0.500)))
	      (snd-display #__line__ ";simple pyr -.5: ~A" v))))
      
      (let ((e (make-env '(0 0 1 1) :length 10)))
	(if (fneq (env-interp 1.0 e) 1.0) (snd-display #__line__ ";env-interp 0011 at 1: ~A" (env-interp 1.0 e)))
	(if (fneq (env-interp 2.0 e) 1.0) (snd-display #__line__ ";env-interp 0011 at 2: ~A" (env-interp 2.0 e)))
	(if (fneq (env-interp 0.0 e) 0.0) (snd-display #__line__ ";env-interp 0011 at 0: ~A" (env-interp 0.0 e)))
	(if (fneq (env-interp 0.444 e) 0.444) (snd-display #__line__ ";env-interp 0011 at .444: ~A" (env-interp 0.45 e)))
	(mus-reset e)
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (let ((val (env e)))
	    (if (fneq val (* i .111111)) (snd-display #__line__ ";ramp env over 10: ~A at ~A" val i)))))
      (let ((e (make-env '(0 0 .5 .5 1 1) :base 32 :length 10))
	    (v (float-vector 0.0 0.0243 0.0667 0.1412 0.2716 0.5000 0.5958 0.7090 0.8425 1.0)))
	(do ((i 0 (+ i 1))
	     (x 0.0 (+ x 0.11111)))
	    ((= i 10))
	  (let ((val (env-interp x e)))
	    (if (fneq val (v i)) (snd-display #__line__ ";(0 .5 1) env-interp over 10: ~A at ~A (~A)" val i (v i))))))
      (let ((e (make-env '(0 -1.0 1 1) :base 32 :length 10))
	    (v (float-vector -1.0 -0.9697 -0.9252 -0.8597 -0.7635 -0.6221 -0.4142 -0.1088 0.34017 1.0)))
	(do ((i 0 (+ i 1))
	     (x 0.0 (+ x 0.11111)))
	    ((= i 10))
	  (let ((val (env-interp x e)))
	    (if (fneq val (v i)) (snd-display #__line__ ";(-1 1) env-interp over 10: ~A at ~A (~A)" val i (v i))))))
      (let ((e (make-env '(0 -1.0 .5 .5 1 0) :base 32 :length 10))
	    (v (float-vector -1.0 -0.952 -0.855 -0.661 -0.274 0.5 0.356 0.226 0.107 0.0)))
	(do ((i 0 (+ i 1))
	     (x 0.0 (+ x 0.11111)))
	    ((= i 10))
	  (let ((val (env-interp x e)))
	    (if (fneq val (v i)) (snd-display #__line__ ";(-1 .5 0) env-interp over 10: ~A at ~A (~A)" val i (v i))))))
      (let ((e (make-env '(0 0.0 .5 .5 1 -1.0) :base 32 :length 10))
	    (v (float-vector 0.0 0.085 0.177 0.276 0.384 0.5 -0.397 -0.775 -0.933 -1.0)))
	(do ((i 0 (+ i 1))
	     (x 0.0 (+ x 0.11111)))
	    ((= i 10))
	  (let ((val (env-interp x e)))
	    (if (fneq val (v i)) (snd-display #__line__ ";(0 .5 -1) env-interp over 10: ~A at ~A (~A)" val i (v i))))))
      (let ((e (make-env '(0 0 1 1) :length 10 :base 4.0)))
	(if (fneq (env-interp 1.0 e) 1.0) (snd-display #__line__ ";env-interp 0011 4 at 1: ~A" (env-interp 1.0 e)))
	(if (fneq (env-interp 0.0 e) 0.0) (snd-display #__line__ ";env-interp 0011 4 at 0: ~A" (env-interp 0.0 e)))
	(if (fneq (env-interp 0.45 e) 0.2839) (snd-display #__line__ ";env-interp 0011 4 at .45: ~A" (env-interp 0.45 e))))
      (let ((e (make-env '(0 0 1 1) :length 10 :base 0.2)))
	(if (fneq (env-interp 1.0 e) 1.0) (snd-display #__line__ ";env-interp 0011 2 at 1: ~A" (env-interp 1.0 e)))
	(if (fneq (env-interp 0.0 e) 0.0) (snd-display #__line__ ";env-interp 0011 2 at 0: ~A" (env-interp 0.0 e)))
	(if (fneq (env-interp 0.45 e) 0.6387) (snd-display #__line__ ";env-interp 0011 2 at .45: ~A" (env-interp 0.45 e))))
      
      (let ((val (let ((e (make-env '(0 0 1 1) :length 10 :offset 2.0))) (set! (mus-offset e) 3.0) (mus-offset e))))
	(if (fneq val 3.0) (snd-display #__line__ ";set mus-offset env: ~A" val)))
      
      (let ((e (make-env '(0 0 1 1 2 0) :length 10))
	    (v (make-float-vector 10 0.0)))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (set! (v i) (env e)))
	(if (not (vequal v (float-vector 0.000 0.200 0.400 0.600 0.800 1.000 0.750 0.500 0.250 0.000)))
	    (snd-display #__line__ ";e set off 0: ~A" v))
	(if (not (= (mus-length e) 10)) (snd-display #__line__ ";e set off 0 len: ~A" (mus-length e)))
	(if (fneq (mus-scaler e) 1.0) (snd-display #__line__ ";e set off 0 scl: ~A" (mus-scaler e)))
	(if (fneq (mus-offset e) 0.0) (snd-display #__line__ ";e set off 0 off: ~A" (mus-offset e)))
	(set! (mus-scaler e) 2.0)
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (set! (v i) (env e)))
	(if (not (vequal v (float-vector 0.000 0.400 0.800 1.200 1.600 2.000 1.500 1.000 0.500 0.000)))
	    (snd-display #__line__ ";e set off 1: ~A" v))
	(if (not (= (mus-length e) 10)) (snd-display #__line__ ";e set off 1 len: ~A" (mus-length e)))
	(if (fneq (mus-scaler e) 2.0) (snd-display #__line__ ";e set off 1 scl: ~A" (mus-scaler e)))
	(if (fneq (mus-offset e) 0.0) (snd-display #__line__ ";e set off 1 off: ~A" (mus-offset e)))
	(set! (mus-offset e) 1.0)
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (set! (v i) (env e)))
	(if (not (vequal v (float-vector 1.000 1.400 1.800 2.200 2.600 3.000 2.500 2.000 1.500 1.000)))
	    (snd-display #__line__ ";e set off 2: ~A" v))
	(if (not (= (mus-length e) 10)) (snd-display #__line__ ";e set off 2 len: ~A" (mus-length e)))
	(if (fneq (mus-scaler e) 2.0) (snd-display #__line__ ";e set off 2 scl: ~A" (mus-scaler e)))
	(if (fneq (mus-offset e) 1.0) (snd-display #__line__ ";e set off 2 off: ~A" (mus-offset e)))
	(set! (mus-length e) 19)
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (set! (v i) (env e)))
	(if (not (vequal v (float-vector 1.000 1.222 1.444 1.667 1.889 2.111 2.333 2.556 2.778 3.000)))
	    (snd-display #__line__ ";e set off 3: ~A" v))
	(if (not (= (mus-length e) 19)) (snd-display #__line__ ";e set off 3 len: ~A" (mus-length e)))
	(if (fneq (mus-scaler e) 2.0) (snd-display #__line__ ";e set off 3 scl: ~A" (mus-scaler e)))
	(if (fneq (mus-offset e) 1.0) (snd-display #__line__ ";e set off 3 off: ~A" (mus-offset e))))
      
      (let ((e (make-env (float-vector 0 0 1 1 2 0) :length 10))
	    (v (make-float-vector 10 0.0)))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (set! (v i) (env e)))
	(if (not (vequal v (float-vector 0.000 0.200 0.400 0.600 0.800 1.000 0.750 0.500 0.250 0.000)))
	    (snd-display #__line__ ";e from float-vector: ~A" v)))
      
      (let ((e1 (make-env '(0 0 1 1) :base 32.0 :length 11))
	    (v (float-vector 0.000 0.013 0.032 0.059 0.097 0.150 0.226 0.333 0.484 0.698 1.00)))
	(do ((i 0 (+ i 1)))
	    ((> i 10))
	  (let ((val (env e1)))
	    (if (fneq val (v i))
		(snd-display #__line__ ";exp env direct (32.0): ~A ~A" val (v i))))))
      
      (let ((e1 (make-env '(0 1 1 2) :base 32.0 :length 11))
	    (v (float-vector 1.000 1.013 1.032 1.059 1.097 1.150 1.226 1.333 1.484 1.698 2.00)))
	(do ((i 0 (+ i 1)))
	    ((> i 10))
	  (let ((val (env e1)))
	    (if (fneq val (v i))
		(snd-display #__line__ ";exp env direct (32.0) offset: ~A ~A" val (v i))))))
      (let ((e1 (make-env '((0 1) (1 2)) :base 32.0 :length 11))
	    (v (float-vector 1.000 1.013 1.032 1.059 1.097 1.150 1.226 1.333 1.484 1.698 2.00)))
	(do ((i 0 (+ i 1)))
	    ((> i 10))
	  (let ((val (env e1)))
	    (if (fneq val (v i))
		(snd-display #__line__ ";exp env direct (32.0) offset embedded: ~A ~A" val (v i))))))
      (let ((e1 (make-env '(0 1 1 2) :base 32.0 :length 11))
	    (v (float-vector 1.000 1.013 1.032 1.059 1.097 1.150 1.226 1.333 1.484 1.698 2.00)))
	(do ((i 0 (+ i 1)))
	    ((> i 10))
	  (let ((val (env e1)))
	    (if (fneq val (v i))
		(snd-display #__line__ ";exp env direct (32.0) offset (and dur): ~A ~A" val (v i))))))
      
      (let ((e1 (make-env '(0 0 1 1) :base 0.032 :length 11))
	    (v (float-vector 0.000 0.301 0.514 0.665 0.772 0.848 0.902 0.940 0.967 0.986 1.0)))
	(do ((i 0 (+ i 1)))
	    ((> i 10))
	  (let ((val (env e1)))
	    (if (fneq val (v i))
		(snd-display #__line__ ";exp env direct (.032): ~A ~A" val (v i))))))
      
      (let ((e1 (make-env '(0 0 1 1) :base .03125 :length 11))
	    (e2 (make-env '(0 0 1 1 2 0) :base 32.0 :length 11))
	    (e3 (make-env '(0 0 .1 1 2 0) :base 1.1 :length 101)))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (let ((lv1 (env-interp (* i .1) e1))
		(lv2 (env e1))
		(lv3 (env-interp (* i .2) e2))
		(lv4 (env e2)))
	    (if (ffneq lv1 lv2) (snd-display #__line__ ";env-interp[rmp ~F]: ~A (~A)?" (* .1 i) lv1 lv2))
	    (if (ffneq lv3 lv4) (snd-display #__line__ ";env-interp[pyr ~F]: ~A (~A)?" (* .2 i) lv3 lv4))))
	(do ((i 0 (+ i 1)))
	    ((= i 100))
	  (let ((lv5 (env-interp (* i .02) e3))
		(lv6 (env e3)))
	    (if (ffneq lv5 lv6) (snd-display #__line__ ";env-interp[tri ~F]: ~A (~A)?" (* .02 i) lv5 lv6)))))
      
      (let ((e1 (make-env '(0 0 1 1 2 0) :length 10))
	    (lv1 (make-float-vector 11))
	    (lv2 (make-float-vector 11))
	    (lv3 (make-float-vector 11)))
	(do ((i 0 (+ i 1))) ((= i 11)) (set! (lv1 i) (env e1)))
	(do ((i 0 (+ i 1))) ((= i 11)) (set! (lv2 i) (env e1)))
	(mus-reset e1)
	(do ((i 0 (+ i 1))) ((= i 11)) (set! (lv3 i) (env e1)))
	(if (not (vequal lv1 lv3)) (snd-display #__line__ ";mus-reset: ~A ~A?" lv1 lv3))
	(if (not (vequal lv2 (make-float-vector 11))) (snd-display #__line__ ";mus-reset 1: ~A?" lv2)))
      
      (set! gen (make-env '(0 0 1 1 2 0) :length 11))
      (do ((i 0 (+ i 1))) ((= i 4)) (env gen))
      (let ((val (env gen)))
	(if (fneq val .8) (snd-display #__line__ ";env(5): ~A?" val))
	(mus-reset gen)
	(do ((i 0 (+ i 1))) ((= i 4)) (env gen))
	(set! val (env gen))
	(if (fneq val .8) (snd-display #__line__ ";mus-reset (via reset): ~A?" val))
	(set! (mus-location gen) 6)
	(let ((val (env gen)))
	  (if (fneq val 0.8) (snd-display #__line__ ";set! mus-location 6 -> ~A (0.8)?" val)))))
    
    (let ((gen (make-env '(0 0 1 1) :base .032 :length 12)))
      (set! (mus-location gen) 5)
      (let ((val (env gen)))
	(if (fneq val 0.817)
	    (snd-display #__line__ ";set env location with base: ~A ~A" val gen))))
    (let ((gen (make-env '(0 0 1 1) :base .032 :length 12)))
      (set! (mus-location gen) 5)
      (let ((val (env gen)))
	(if (fneq val 0.817)
	    (snd-display #__line__ ";set env location with base and dur: ~A ~A" val gen))))
    
    (test-gen-equal (make-env '(0 0 1 1 2 0) :scaler 0.5 :length 10) (make-env '(0 0 1 1 2 0) :scaler 0.5 :length 10) (make-env '(0 0 1 1 2 0) :scaler 0.25 :length 10))
    (test-gen-equal (make-env '(0 0 1 1 2 0) :scaler 0.5 :length 10) (make-env '(0 0 1 1 2 0) :scaler 0.5 :length 10) (make-env '(0 0 1 1 2 0) :scaler 0.5 :length 11))
    (test-gen-equal (make-env '(0 0 1 1 2 0) :scaler 0.5 :length 10) (make-env '(0 0 1 1 2 0) :scaler 0.5 :length 10) (make-env '(0 0 1 1 3 0) :scaler 0.5 :length 10))
    (test-gen-equal (make-env '((0 0) (1 1) (2 0)) :scaler 0.5 :length 10) (make-env '(0 0 1 1 2 0) :scaler 0.5 :length 10) (make-env '((0 0) (1 1) (3 0)) :scaler 0.5 :length 10))
    
    (let ((var (catch #t (lambda () (make-env :envelope ())) (lambda args args))))
      (if (not (eq? (car var) 'no-data))
	  (snd-display #__line__ ";make-env null env: ~A" var)))
    (let ((var (catch #t (lambda () (make-env :length 1)) (lambda args args))))
      (if (not (eq? (car var) 'no-data))
	  (snd-display #__line__ ";make-env no env: ~A" var)))
    (let ((var (catch #t (lambda () (make-env :envelope '(0 0) :length -1)) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display #__line__ ";make-env bad dur: ~A" var)))
    (let ((var (catch #t (lambda () (make-env :envelope '(0 0) :duration -1.0)) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display #__line__ ";make-env bad duration: ~A" var)))
    (let ((var (catch #t (lambda () (make-env :envelope '(0 0) :base -1.0)) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display #__line__ ";make-env bad base: ~A" var)))
    (let ((var (catch #t (lambda () (make-env :envelope '(1 1 0 0) :length 11)) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";make-env bad env 1 1 0 0: ~A" var)))
    (let ((var (catch #t (lambda () (make-env :envelope '(0 1 -1 0) :length 11)) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";make-env bad env 0 1 -1 0: ~A" var)))
    (let ((var (catch #t (lambda () (make-env :envelope '(0 1 1 0) :length 11 :length 10)) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";make-env bad end/dur: ~A" var)))
    (let ((var (catch #t (lambda () (make-env :envelope '(0 0 1 1 2 0 1) :duration 1.0)) (lambda args args))))
      (if (not (eq? (car var) 'bad-type))
	  (snd-display #__line__ ";make-env odd length env: ~A" var)))
    (let ((var (catch #t (lambda () (make-env :envelope (list "hi" 0 1 1 2 0) :duration 1.0)) (lambda args args))))
      (if (not (eq? (car var) 'wrong-type-arg))
	  (snd-display #__line__ ";make-env env of non-number: ~A" var)))
    
    ;; env-any
    (let* ((env-any-1 (lambda (e func)
			(let* ((pts (mus-data e))
			       (mus-position mus-channels)
			       (pt (min (* 2 (mus-position e)) (- (length pts) 4)))
			       (val (/ (- (env e) (mus-offset e)) (mus-scaler e)))
			       (y0 (min (pts (+ pt 1)) (pts (+ pt 3))))
			       (y1 (max (pts (+ pt 1)) (pts (+ pt 3))))
			       (new-val (func (/ (- val y0) (- y1 y0)))))
			  (+ (mus-offset e)
			     (* (mus-scaler e)
				(+ y0
				   (* (- y1 y0) new-val)))))))
	   (sine-env-1 (lambda (e)
			 (env-any-1 e (lambda (y)
					(* 0.5 (+ 1.0 (sin (+ (* -0.5 pi) 
							      (* pi y)))))))))
	   (square-env-1 (lambda (e)
			   (env-any-1 e (lambda (y)
					  (* y y)))))
	   
	   (blackman4-env-1 (lambda (e)
			      (env-any-1 e (lambda (y)
					     (let ((cx (cos (* pi y))))
					       (+ 0.084037 (* cx (+ -.29145 (* cx (+ .375696 (* cx (+ -.20762 (* cx .041194)))))))))))))
	   
	   (multi-expt-env-1 (lambda (e expts)
			       (env-any-1 e (lambda (y)
					      (let ((b (expts (modulo (mus-channels e) (length expts)))))
						(/ (- (expt b y) 1.0) (- b 1.0))))))))
      
      
      
      ;; assume sine-env square-env blackman4-env and multi-exp-env are available from generators.scm (8)
      
      (let ((val1 (with-sound ((make-float-vector 20))
			      (let ((e (make-env '(0 0 1 1 2 .25 3 1 4 0) :length 20)))
				(do ((i 0 (+ i 1)))
				    ((= i 20))
				  (outa i (sine-env e))))))
	    
	    (val2 (with-sound ((make-float-vector 20))
			      (let ((e (make-env '(0 0 1 1 2 .25 3 1 4 0) :length 20)))
				 (do ((i 0 (+ i 1)))
				     ((= i 20))
				   (outa i (sine-env e))))))
	    
	    (val3 (with-sound ((make-float-vector 20))
			      (let ((e (make-env '(0 0 1 1 2 .25 3 1 4 0) :length 20)))
				(do ((i 0 (+ i 1)))
				    ((= i 20))
				  (outa i (sine-env-1 e)))))))
	(if (not (vequal val1 val2))
	    (snd-display #__line__ ";sine-env straight and run: ~%;  ~A~%;  ~A" val1 val2))
	(if (not (vequal val1 val3))
	    (snd-display #__line__ ";sine-env straight and scm: ~%;  ~A~%;  ~A" val1 val3)))
      
      
      (let ((val1 (with-sound ((make-float-vector 20))
			      (let ((e (make-env '(0 0 1 1 2 .25 3 1 4 0) :length 20)))
				(do ((i 0 (+ i 1)))
				    ((= i 20))
				  (outa i (square-env e))))))
	    
	    (val2 (with-sound ((make-float-vector 20))
			      (let ((e (make-env '(0 0 1 1 2 .25 3 1 4 0) :length 20)))
				 (do ((i 0 (+ i 1)))
				     ((= i 20))
				   (outa i (square-env e))))))
	    
	    (val3 (with-sound ((make-float-vector 20))
			      (let ((e (make-env '(0 0 1 1 2 .25 3 1 4 0) :length 20)))
				(do ((i 0 (+ i 1)))
				    ((= i 20))
				  (outa i (square-env-1 e)))))))
	(if (not (vequal val1 val2))
	    (snd-display #__line__ ";square-env straight and run: ~%;  ~A~%;  ~A" val1 val2))
	(if (not (vequal val1 val3))
	    (snd-display #__line__ ";square-env straight and scm: ~%;  ~A~%;  ~A" val1 val3)))
      
      (let ((val1 (with-sound ((make-float-vector 20))
			      (let ((e (make-env '(0 0 1 1 2 .25 3 1 4 0) :length 20)))
				(do ((i 0 (+ i 1)))
				    ((= i 20))
				  (outa i (blackman4-env e))))))
	    
	    (val3 (with-sound ((make-float-vector 20))
			      (let ((e (make-env '(0 0 1 1 2 .25 3 1 4 0) :length 20)))
				(do ((i 0 (+ i 1)))
				    ((= i 20))
				  (outa i (blackman4-env-1 e)))))))
	(if (not (vequal val1 val3))
	    (snd-display #__line__ ";blackman4-env straight and scm: ~%;  ~A~%;  ~A" val1 val3)))
      
      
      (let ((val1 (with-sound ((make-float-vector 20))
			      (let ((e (make-env '(0 0 1 1 2 .25 3 1 4 0) :length 20))
				    (bases (float-vector 32.0 0.3 1.5)))
				(do ((i 0 (+ i 1)))
				    ((= i 20))
				  (outa i (multi-expt-env e bases))))))
	    
	    (val2 (with-sound ((make-float-vector 20))
			      (let ((e (make-env '(0 0 1 1 2 .25 3 1 4 0) :length 20))
				    (bases (float-vector 32.0 0.3 1.5)))
				 (do ((i 0 (+ i 1)))
				     ((= i 20))
				   (outa i (multi-expt-env e bases))))))
	    
	    (val3 (with-sound ((make-float-vector 20))
			      (let ((e (make-env '(0 0 1 1 2 .25 3 1 4 0) :length 20))
				    (bases (float-vector 32.0 0.3 1.5)))
				(do ((i 0 (+ i 1)))
				    ((= i 20))
				  (outa i (multi-expt-env-1 e bases)))))))
	(if (not (vequal val1 val2))
	    (snd-display #__line__ ";multi-expt-env straight and run: ~%;  ~A~%;  ~A" val1 val2))
	(if (not (vequal val1 val3))
	    (snd-display #__line__ ";multi-expt-env straight and scm: ~%;  ~A~%;  ~A" val1 val3)))
      
      (let ((val1 (with-sound ((make-float-vector 220))
			      (let ((e1 (make-env '(0 0 1 1 2 .25 3 1 4 0) :length 220))
				    (e2 (make-env '(0 0 1 1 2 .25 3 1 4 0) :length 220)))
				(do ((i 0 (+ i 1)))
				    ((= i 220))
				  (outa i (env-any e1
						   (lambda (y1)
						     (* y1 (env-any e2
								    (lambda (y2)
								      y2))))))))))
	    (val2 (with-sound ((make-float-vector 220))
			      (let ((e1 (make-env '(0 0 1 1 2 .25 3 1 4 0) :length 220))
				    (e2 (make-env '(0 0 1 1 2 .25 3 1 4 0) :length 220)))
				 (do ((i 0 (+ i 1)))
				     ((= i 220))
				   (outa i (env-any e1 ; try it with and without "declare"
						    (lambda (y1)
						      (* y1 (env-any e2
								     (lambda (y2)
								       y2)))))))))))
	(if (not (vequal val1 val2))
	    (snd-display #__line__ ";env-any recursive: ~%;  ~A~%;  ~A" val1 val2))))
    
    (let ((ind (new-sound :size 20)))
      (select-sound ind)
      (map-channel (lambda (y) 1.0))
      (bumpy)
      (let ((vals (channel->float-vector)))
	(if (not (vequal vals (float-vector 0.0 0.0 0.001 0.021 0.105 0.264 0.467 0.673 0.846 0.960 1.000 0.960 0.846 0.673 0.467 0.264 0.105 0.021 0.001 0.0)))
	    (snd-display #__line__ ";bumpy: ~A" vals)))
      (if (fneq (channel-lp-inf) 1.0) ; just a fancy name for maxamp
	  (snd-display #__line__ ";channel-lp-inf: ~A" (channel-lp-inf)))
      (linear-src-channel 2.0)
      (let ((vals (channel->float-vector)))
	(if (not (vequal vals (float-vector 0.000 0.001 0.105 0.467 0.846 1.000 0.846 0.467 0.105 0.001)))
	    (snd-display #__line__ ";linear-src-channel: ~A" vals)))
      (let ((old-clip *clipping*))
	(set! *clipping* #t)
	(save-sound-as "tst.snd")
	(let ((fvals (file->floats "tst.snd")) 
	      (vals (channel->float-vector)))
	  (if (not (vequal vals fvals))
	      (snd-display #__line__ ";file->floats: ~A ~A" vals fvals)))
	(mus-sound-forget "tst.snd")
	(delete-file "tst.snd")
	(set! *clipping* old-clip))
      (let ((hp (make-differentiator)))
	(map-channel (lambda (y)
		       (differentiator hp y))))
      (if (fneq (maxamp) .0013)
	  (snd-display #__line__ ";differentiator: ~A" (maxamp)))
      (revert-sound ind)
      (let ((val (window-rms)))
	(if (fneq val 0.0) (snd-display #__line__ ";window-rms empty: ~A" val))
	(set! (sample 10) 1.0)
	(set! val (window-rms))
	(if (fneq val .218) (snd-display #__line__ ";window-rms 1: ~A" val))
	(let ((vals (window-samples)))
	  (if (or (not (float-vector? vals))
		  (not (= (length vals) 21))
		  (fneq (vals 10) 1.0))
	      (snd-display #__line__ ";window-samples: ~A" vals))))
      (revert-sound ind)
      (let ((new-file-name (file-name ind)))
	(close-sound ind)
	(if (file-exists? new-file-name) (delete-file new-file-name))))
    
    (let ((gen (make-table-lookup 440.0 :wave (partials->wave '(1 1 2 1))))
	  (gen1 (make-table-lookup 440.0 :wave (partials->wave '(1 1 2 1) (make-float-vector 512))))
	  ;;(gen2 (partials->wave '(1 1 2 1 3 1 4 1) #f #t))
	  (gen3 (make-table-lookup))
	  (v0 (make-float-vector 10))
	  (v1 (make-float-vector 10))
	  (gen4 (make-table-lookup 440.0 :wave (partials->wave '(1 1 2 1))))
	  (v2 (make-float-vector 10)))
      (print-and-check gen 
		       "table-lookup"
		       "table-lookup freq: 440.000Hz, phase: 0.000, length: 512, interp: linear")
      (if (not (= (mus-length gen) 512)) (snd-display #__line__ ";table-lookup length: ~A?" (mus-length gen)))
      (if (not (= (mus-length gen3) 512)) (snd-display #__line__ ";default table-lookup length: ~A?" (mus-length gen3)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (table-lookup gen 0.0))
	(set! (v1 i) (mus-apply gen1 0.0)))
      (fill-float-vector v2 (if (table-lookup? gen4) (table-lookup gen4 0.0) -1.0))
      (if (not (vequal v0 v2)) (snd-display #__line__ ";map table-lookup: ~A ~A" v0 v2))
      (set! gen4 (make-table-lookup 440.0 :wave (partials->wave (float-vector 1 1 2 1))))
      (fill-float-vector v2 (table-lookup gen4))
      (if (not (vequal v0 v2)) (snd-display #__line__ ";map table-lookup (no fm): ~A ~A" v0 v2))
      (if (not (table-lookup? gen)) (snd-display #__line__ ";~A not table-lookup?" gen))
      (if (not (float-vector? (mus-data gen))) (snd-display #__line__ ";mus-data table-lookup: ~A" (mus-data gen)))
      (if (fneq (mus-phase gen) 1.253787) (snd-display #__line__ ";table-lookup phase: ~F?" (mus-phase gen)))
      (set! (mus-phase gen) 1.0)
      (if (fneq (mus-phase gen) 1.0) (snd-display #__line__ ";set! table-lookup phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";table-lookup frequency: ~F?" (mus-frequency gen)))
      (set! (mus-frequency gen) 100.0)
      (if (fneq (mus-frequency gen) 100.0) (snd-display #__line__ ";set! table-lookup frequency: ~F?" (mus-frequency gen)))
      (if (or (fneq (v0 1) 0.373) (fneq (v0 8) 1.75)) (snd-display #__line__ ";table-lookup output: ~A" v0))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(if (fneq (v0 i) (v1 i))
	    (snd-display #__line__ ";mus-apply table-lookup at ~D: ~A ~A?" i (v0 i) (v1 i))))
      (set! gen (make-table-lookup 440.0 :wave (phase-partials->wave (list 1 1 0 2 1 (* pi .5)))))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (table-lookup gen 0.0)))
      (if (or (fneq (v0 1) 1.094) (fneq (v0 8) .421)) (snd-display #__line__ ";table-lookup phase output: ~A" v0))
      (if (or (fneq (float-vector-peak (partials->wave '(1 1 2 1))) 1.76035475730896)
	      (fneq (float-vector-peak (partials->wave '(1 1 2 1) #f #t)) 1.0)
	      (fneq (float-vector-peak (partials->wave '(1 1 2 1 3 1 4 1) #f #t)) 1.0))
	  (snd-display #__line__ ";normalized partials?"))
      (set! (mus-data gen) (phase-partials->wave (list 1 1 0 2 1 (* pi .5)) #f #t)))
    
    (let ((tag (catch #t (lambda () (phase-partials->wave (list 1 .3 2 .2))) (lambda args (car args)))))
      (if (not (eq? tag 'wrong-type-arg)) (snd-display #__line__ ";bad length arg to phase-partials->wave: ~A" tag)))
    (let ((tag (catch #t (lambda () (phase-partials->wave (list "hiho" .3 2 .2))) (lambda args (car args)))))
      (if (not (eq? tag 'wrong-type-arg)) (snd-display #__line__ ";bad harmonic arg to phase-partials->wave: ~A" tag)))
    (let ((tag (catch #t (lambda () (phase-partials->wave (list))) (lambda args (car args)))))
      (if (not (eq? tag 'no-data)) (snd-display #__line__ ";nil list to phase-partials->wave: ~A" tag)))
    
    (let ((vals (phase-partials->wave (list 1 1 0) (make-float-vector 16) #f)))
      (do ((i 0 (+ i 1)))
	  ((= i 16))
	(if (fneq (vals i) (sin (/ (* 2 pi i) 16)))
	    (snd-display #__line__ ";phase-partials->wave 1 1 0 at ~D: ~A ~A" i (vals i) (sin (/ (* 2 pi i) 16))))))
    
    (let ((vals (phase-partials->wave (list 1 1 (* .25 pi)) (make-float-vector 16) #f)))
      (do ((i 0 (+ i 1)))
	  ((= i 16))
	(if (fneq (vals i) (sin (+ (* .25 pi) (/ (* 2 pi i) 16))))
	    (snd-display #__line__ ";phase-partials->wave 1 1 .25 at ~D: ~A ~A" i (vals i) (sin (+ (* .25 pi) (/ (* 2 pi i) 16)))))))
    
    (let ((vals (phase-partials->wave (float-vector 1 1 0 2 1 0) (make-float-vector 16) #f)))
      (do ((i 0 (+ i 1)))
	  ((= i 16))
	(if (fneq (vals i) (+ (sin (/ (* 2 pi i) 16)) (sin (/ (* 4 pi i) 16))))
	    (snd-display #__line__ ";phase-partials->wave 1 1 0 2 1 0 at ~D: ~A ~A" i (vals i) 
			 (+ (sin (/ (* 2 pi i) 16)) (sin (/ (* 4 pi i) 16)))))))
    
    (let ((vals (phase-partials->wave (float-vector 1 1 0 2 1 (* .5 pi)) (make-float-vector 16) #f)))
      (do ((i 0 (+ i 1)))
	  ((= i 16))
	(if (fneq (vals i) (+ (sin (/ (* 2 pi i) 16)) (sin (+ (* .5 pi) (/ (* 4 pi i) 16)))))
	    (snd-display #__line__ ";phase-partials->wave 1 1 0 2 1 .5 at ~D: ~A ~A" i (vals i) 
			 (+ (sin (/ (* 2 pi i) 16)) (sin (+ (* .5 pi) (/ (* 4 pi i) 16))))))))
    
    (test-gen-equal (make-table-lookup 440.0 :wave (partials->wave (float-vector 1 1 2 1)))
		    (make-table-lookup 440.0 :wave (partials->wave '(1 1 2 1)))
		    (make-table-lookup 100.0 :wave (partials->wave '(1 1 2 1))))
    (test-gen-equal (make-table-lookup 440.0 :wave (partials->wave '(1 1 2 1)))
		    (make-table-lookup 440.0 :wave (partials->wave '(1 1 2 1)))
		    (make-table-lookup 440.0 :wave (partials->wave '(1 1 2 .5))))
    (test-gen-equal (make-table-lookup-with-env 440.0 '(0 0 1 1))
		    (make-table-lookup-with-env 440.0 (list 0 0 1 1))
		    (make-table-lookup-with-env 440.0 '(0 0 1 1 2 0)))
    (let ((tag (catch #t (lambda () (partials->wave (list .5 .3 .2))) (lambda args (car args)))))
      (if (not (eq? tag 'bad-type)) (snd-display #__line__ ";odd length arg to partials->wave: ~A" tag)))
    
    (let ((hi (make-table-lookup :size 256)))
      (if (not (= (mus-length hi) 256)) (snd-display #__line__ ";table-lookup set length: ~A?" (mus-length hi))))
    (let ((tag (catch #t (lambda () (make-table-lookup :size 0)) (lambda args (car args)))))
      (if (not (eq? tag 'out-of-range)) (snd-display #__line__ ";table-lookup size 0: ~A" tag)))
    
    (let ((gen (make-table-lookup 440.0 :wave (partials->wave '(1 1))))
	  (incr (/ (* 2 pi 440.0) 22050.0)))
      (do ((i 0 (+ i 1))
	   (a 0.0 (+ a incr)))
	  ((= i 1100))
	(let ((val1 (sin a))
	      (val2 (gen 0.0)))
	  (if (fneq val1 val2)
	      (snd-display #__line__ ";table lookup (1 1): ~A: ~A ~A" i val1 val2)))))
    
    (let ((gen (make-table-lookup 4.0 :wave (partials->wave '(1 1))))
	  (incr (/ (* 2 pi 4.0) 22050.0)))
      (do ((i 0 (+ i 1))
	   (a 0.0 (+ a incr)))
	  ((= i 1100))
	(let ((val1 (sin a))
	      (val2 (gen 0.0)))
	  (if (fneq val1 val2)
	      (snd-display #__line__ ";table lookup (1 1) 4: ~A: ~A ~A" i val1 val2)))))
    
    (let ((gen (make-table-lookup 440.0 :wave (partials->wave '(1 .75 3 .25))))
	  (incr (/ (* 2 pi 440.0) 22050.0)))
      (do ((i 0 (+ i 1))
	   (a 0.0 (+ a incr)))
	  ((= i 1100))
	(let ((val1 (+ (* .75 (sin a)) (* .25 (sin (* 3 a)))))
	      (val2 (gen 0.0)))
	  (if (fneq val1 val2)
	      (snd-display #__line__ ";table lookup (1 .75 3 .25): ~A: ~A ~A" i val1 val2)))))
    
    (let ((gen (make-table-lookup 0.0 :wave (partials->wave '(1 1))))
	  (gen1 (make-table-lookup 40.0 :wave (partials->wave '(1 1))))
	  (incr (/ (* 2 pi 40.0) 22050.0))
	  (a1 0.0))
      (do ((i 0 (+ i 1))
	   (a 0.0 (+ a incr)))
	  ((= i 100))
	(let ((fm (sin a))
	      (val1 (sin a1))
	      (val2 (table-lookup gen (table-lookup gen1 0.0))))
	  (set! a1 (+ a1 fm))
	  (if (fneq val1 val2)
	      (snd-display #__line__ ";lookup/lookup fm: ~A: ~A ~A" i val1 val2)))))
    
    (for-each 
     (lambda (args)
       (let ((type (car args))
	     (vals (cadr args)))
	 (let ((tbl1 (make-table-lookup :frequency 0.0 :size 4 :type type)))
	   (float-vector-set! (mus-data tbl1) 1 1.0)
	   (let ((v (make-float-vector 10)))
	     (do ((i 0 (+ i 1)))
		 ((= i 10))
	       (set! (v i) (table-lookup tbl1 (* .1 pi))))
	     (if (and (not (vequal v vals))
		      (not (= type mus-interp-all-pass))
		      (or (not (= type mus-interp-none))
			  (not (vequal v (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 1.000 1.000 1.000 1.000)))))
		 (snd-display #__line__ ";tbl interp ~A: ~A" type v))
	     (if (not (= (mus-interp-type tbl1) type)) (snd-display #__line__ ";tbl interp-type (~A): ~A" type (mus-interp-type tbl1)))))))
     (list 
      (list mus-interp-none (float-vector 0.000 0.000 0.000 0.000 0.000 1.000 1.000 1.000 1.000 1.000))
      (list mus-interp-linear (float-vector 0.000 0.200 0.400 0.600 0.800 1.000 0.800 0.600 0.400 0.200))
      (list mus-interp-lagrange (float-vector 0.000 0.120 0.280 0.480 0.720 1.000 0.960 0.840 0.640 0.360))
      (list mus-interp-all-pass (float-vector 1.000 0.000 0.429 0.143 0.095 0.905 0.397 0.830 0.793 0.912))
      (list mus-interp-hermite (float-vector 0.000 0.168 0.424 0.696 0.912 1.000 0.912 0.696 0.424 0.168))))
    ;; this is different if doubles -- not sure whether it's a bug or not
    
    (let ((size 1000)
	  (tbl-size 1024))
      
      (define (test-tbl beg end freq amp mc-ratio index)
	(let* ((sine (let ((v (make-float-vector tbl-size))
			   (xp (/ (* 2 pi) tbl-size)))
		       (do ((i 0 (+ i 1))
			    (x 0.0 (+ x xp)))
			   ((= i tbl-size) v)
			 (set! (v i) (sin x)))))
	       (fm (make-table-lookup (* mc-ratio freq) :wave sine))
	       (carrier (make-table-lookup freq :wave sine)))
	  (do ((i beg (+ i 1)))
	      ((= i end))
	    (outa i (* amp (table-lookup carrier (* index (table-lookup fm))))))))
      
      (define (test-fm1 beg end freq amp mc-ratio index)
	(let ((fm (make-oscil (* mc-ratio freq)))
	      (carrier (make-oscil freq)))
	  (do ((i beg (+ i 1)))
	      ((= i end))
	    (outa i (* amp (oscil carrier (* index (oscil fm))))))))
      
      (let ((v1 (with-sound ((make-float-vector size) :srate 44100) (test-tbl 0 size 200 1 1 1)))
	    (v2 (with-sound ((make-float-vector size) :srate 44100) (test-fm1 0 size 200 1 1 1))))
	(if (and (not (vequal v1 v2))
		 (> (float-vector-peak (float-vector-subtract! v1 v2)) .002))
	    (snd-display #__line__ ";fm/tbl peak diff (1 1): ~A" (float-vector-peak (float-vector-subtract! v1 v2)))))
      
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(let ((ratio (+ 1 (random 4)))
	      (index (random 0.1)))
	  (let ((v1 (with-sound ((make-float-vector size) :srate 44100) (test-tbl 0 size 20 1 ratio index)))
		(v2 (with-sound ((make-float-vector size) :srate 44100) (test-fm1 0 size 20 1 ratio index))))
	    (if (and (not (vequal v1 v2))
		     (> (float-vector-peak (float-vector-subtract! v1 v2)) .002))
		(snd-display #__line__ ";fm/tbl peak diff ~A ~A: ~A" ratio index (float-vector-peak (float-vector-subtract! v1 v2))))))))
    
    
    (let ((gen0 (make-polyshape 440.0 :coeffs (partials->polynomial '(1 1))))
	  (gen (make-polyshape 440.0 :partials '(1 1) :kind mus-chebyshev-first-kind))
	  (v0 (make-float-vector 10))
	  (gen1 (make-polyshape 440.0))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "polyshape"
		       "polyshape freq: 440.000Hz, phase: 0.000, coeffs[2]: [0 1]")
      (if (not (= (mus-length gen) 2)) (snd-display #__line__ ";polyshape length: ~A?" (mus-length gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(let ((val0 (polyshape gen0 1.0 0.0))
	      (val (polyshape gen 1.0 0.0)))
	  (if (fneq val val0) (snd-display #__line__ ";polyshape: ~A is not ~F?" val val0))
	  (set! (v0 i) val)))
      (fill-float-vector v1 (if (polyshape? gen1) (polyshape gen1 1.0 0.0) -1.0))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map polyshape: ~A ~A" v0 v1))
      (set! gen1 (make-polyshape 440.0 :coeffs (partials->polynomial '(1 1))))
      (fill-float-vector v1 (polyshape gen1 1.0))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";1 map polyshape: ~A ~A" v0 v1))
      (if (not (polyshape? gen)) (snd-display #__line__ ";~A not polyshape?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display #__line__ ";polyshape phase: ~F?" (mus-phase gen)))
      (set! (mus-phase gen) 1.0)
      (if (fneq (mus-phase gen) 1.0) (snd-display #__line__ ";set! polyshape phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";polyshape frequency: ~F?" (mus-frequency gen)))
      (set! (mus-frequency gen) 100.0)
      (if (fneq (mus-frequency gen) 100.0) (snd-display #__line__ ";polyshape frequency: ~F?" (mus-frequency gen)))
      (if (not (float-vector? (mus-data gen))) (snd-display #__line__ ";mus-data polyshape: ~A" (mus-data gen)))
      (if (or (fneq (v0 1) 0.992) (fneq (v0 8) 0.538)) (snd-display #__line__ ";polyshape output: ~A" v0))
      (set! (mus-data gen0) (make-float-vector 32))
      (set! (mus-length gen0) 32)
      (if (not (= (mus-length gen0) 32)) (snd-display #__line__ ";set mus-length polyshape: ~A" (mus-length gen0))))
    
    (test-gen-equal (make-polyshape 440.0 :partials '(1 1)) 
		    (make-polyshape 440.0) 
		    (make-polyshape 100.0 :partials '(1 1)))
    (test-gen-equal (make-polyshape 440.0 :partials '(1 1)) 
		    (make-polyshape 440.0)
		    (make-polyshape 440.0 :partials '(1 1 2 .5)))
    (test-gen-equal (make-polyshape 440.0 :partials '(1 1)) 
		    (make-polyshape 440.0 :partials (float-vector 1 1))
		    (make-polyshape 440.0 :partials '(1 .5)))
    (test-gen-equal (make-polyshape 440.0 :partials (list 1 .1 2 1 3 .5))
		    (make-polyshape 440.0 :partials (float-vector 1 .1 2 1 3 .5))
		    (make-polyshape 440.0 :partials '(1 .1 2 .1 3 .5)))
    
    (let ((gen (make-polyshape 440.0 :partials '(1 1)))
	  (happy #t))
      (do ((i 0 (+ i 1)))
	  ((or (not happy) (= i 1100)))
	(let* ((a (mus-phase gen))
	       (val1 (cos a))
	       (val2 (gen 1.0 0.0)))
	  (if (fneq val1 val2)
	      (begin
		(snd-display #__line__ ";polyshaper (1 1) ~A: ~A ~A" i val1 val2)
		(set! happy #f))))))
    
    (let ((gen (make-polyshape 440.0)) ; check default for partials: '(1 1)
	  (happy #t))
      (do ((i 0 (+ i 1)))
	  ((or (not happy)
	       (= i 1100)))
	(let* ((a (mus-phase gen))
	       (val1 (cos a))
	       (val2 (gen 1.0 0.0)))
	  (if (fneq val1 val2)
	      (begin
		(snd-display #__line__ ";polyshaper default: '(1 1) ~A: ~A ~A" i val1 val2)
		(set! happy #f))))))
    
    (let ((gen (make-polyshape 440.0 :partials (float-vector 1 1)))
	  (happy #t))
      (do ((i 0 (+ i 1)))
	  ((or (not happy) (= i 1100)))
	(let* ((a (mus-phase gen))
	       (val1 (* .5 (cos a)))
	       (val2 (gen 0.5 0.0)))
	  (if (fneq val1 val2)
	      (begin
		(snd-display #__line__ ";polyshaper (1 1) .5 index ~A: ~A ~A" i val1 val2)
		(set! happy #f))))))
    
    (let ((var (catch #t (lambda () (make-polyshape 440.0 :coeffs 3.14)) (lambda args args))))
      (if (not (eq? (car var) 'wrong-type-arg))
	  (snd-display #__line__ ";make-polyshape bad coeffs: ~A" var)))
    
    (let ((gen (make-polyshape 0.0 :coeffs (partials->polynomial '(1 1))))
	  (gen1 (make-polyshape 40.0 :coeffs (partials->polynomial '(1 1))))
	  (a1 0.0)
	  (incr (/ (* 2 pi 40.0) 22050.0))
	  (happy #t))
      (do ((i 0 (+ i 1))
	   (a 0.0 (+ a incr)))
	  ((or (not happy) (= i 400)))
	(let ((fm (cos a))
	       (val1 (cos a1))
	       (val2 (polyshape gen 1.0 (polyshape gen1 1.0))))
	  (set! a1 (+ a1 fm))
	  (if (> (abs (- val1 val2)) .002)
	      (begin
		(snd-display #__line__ ";polyshape fm: ~A: ~A ~A" i val1 val2)
		(set! happy #f))))))
    
    (for-each 
     (lambda (amps name)
       (let ((data1 (make-float-vector 100))
	     (data2 (make-float-vector 100))
	     (data3 (make-float-vector 100))
	     (n (length amps))
	     (incr (hz->radians 1.0)))
	 (do ((i 0 (+ i 1))
	      (angle 0.0 (+ angle incr)))
	     ((= i 100))
	   (float-vector-set! data1 i (mus-chebyshev-t-sum angle amps)))
	 
	 (do ((k 0 (+ k 1))
	      (kincr 0.0 (+ kincr incr)))
	     ((= k n))
	   (do ((i 0 (+ i 1))
		(angle 0.0 (+ angle kincr)))
	       ((= i 100))
	     (float-vector-set! data3 i (cos angle)))
	   (float-vector-scale! data3 (float-vector-ref amps k))
	   (float-vector-add! data2 data3))

	 (let ((fudge *mus-float-equal-fudge-factor*))
	   (set! *mus-float-equal-fudge-factor* .0001)
	   (if (not (mus-arrays-equal? data1 data2))
	       (snd-display #__line__ "~A: ~A~%~A~%" name data1 data2))
	   (set! *mus-float-equal-fudge-factor* fudge))))

     (list (float-vector 0.0 1.0)
	   (float-vector 0.0 0.5 0.25 0.25)
	   (make-float-vector 100 0.01)
	   (make-float-vector 1000 0.001))
     (list 'one-cos
	   'three-cos
	   'hundred-cos
	   'thousand-cos))

    (for-each 
     (lambda (amps name)
       (let ((data1 (make-float-vector 100))
	     (data2 (make-float-vector 100))
	     (data3 (make-float-vector 100))
	     (n (length amps))
	     (incr (hz->radians 1.0)))
	 (do ((i 0 (+ i 1))
	      (angle 0.0 (+ angle incr)))
	     ((= i 100))
	   (float-vector-set! data1 i (mus-chebyshev-u-sum angle amps)))
	 
	 (do ((k 0 (+ k 1))
	      (kincr 0.0 (+ kincr incr)))
	     ((= k n))
	   (do ((i 0 (+ i 1))
		(angle 0.0 (+ angle kincr)))
	       ((= i 100))
	     (float-vector-set! data3 i (sin angle)))
	   (float-vector-scale! data3 (float-vector-ref amps k))
	   (float-vector-add! data2 data3))

	 (let ((fudge *mus-float-equal-fudge-factor*))
	   (set! *mus-float-equal-fudge-factor* .0001)
	   (if (not (mus-arrays-equal? data1 data2))
	       (snd-display #__line__ "~A: ~A~%~A~%" name data1 data2))
	   (set! *mus-float-equal-fudge-factor* fudge))))

     (list (float-vector 0.0 1.0)
	   (float-vector 0.0 0.5 0.25 0.25)
	   (make-float-vector 100 0.01)
	   (make-float-vector 1000 0.001))
     (list 'one-sin
	   'three-sin
	   'hundred-sin
	   'thousand-sin))

    (for-each 
     (lambda (camps samps name)
       (let ((data1 (make-float-vector 100))
	     (data2 (make-float-vector 100))
	     (data3 (make-float-vector 100))
	     (n (length camps))
	     (incr (hz->radians 1.0)))
	 (do ((i 0 (+ i 1))
	      (angle 0.0 (+ angle incr)))
	     ((= i 100))
	   (float-vector-set! data1 i (mus-chebyshev-tu-sum angle camps samps)))
	 
	 (do ((k 0 (+ k 1))
	      (kincr 0.0 (+ kincr incr)))
	     ((= k n))
	   (do ((i 0 (+ i 1))
		(angle 0.0 (+ angle kincr)))
	       ((= i 100))
	     (float-vector-set! data3 i (sin angle)))
	   (float-vector-scale! data3 (float-vector-ref samps k))
	   (float-vector-add! data2 data3)
	   (do ((i 0 (+ i 1))
		(angle 0.0 (+ angle kincr)))
	       ((= i 100))
	     (float-vector-set! data3 i (cos angle)))
	   (float-vector-scale! data3 (float-vector-ref camps k))
	   (float-vector-add! data2 data3))

	 (let ((fudge *mus-float-equal-fudge-factor*))
	   (set! *mus-float-equal-fudge-factor* .0001)
	   (if (not (mus-arrays-equal? data1 data2))
	       (snd-display "~A: ~A~%~A~%" name data1 data2))
	   (set! *mus-float-equal-fudge-factor* fudge))))

     (list (float-vector 0.0 1.0)
	   (float-vector 0.0 0.25 0.0 0.25)
	   (make-float-vector 100 .004)
	   (make-float-vector 1000 0.0005))
     (list (float-vector 0.0 0.0)
	   (float-vector 0.0 0.25 0.25 0.0)
	   (make-float-vector 100 .006)
	   (make-float-vector 1000 0.0005))
     (list 'one-tu
	   'three-tu
	   'hundred-tu
	   'thousand-tu))
    
    ;; polywave
    (let ((gen0 (make-polywave 440.0 '(1 1)))
	  (gen (make-polywave 440.0 :partials '(1 1) :type mus-chebyshev-first-kind))
	  (v0 (make-float-vector 10))
	  (gen1 (make-polywave 440.0))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "polywave"
		       "polywave freq: 440.000Hz, phase: 0.000, coeffs[2]: [0 1]")
      (if (not (= (mus-length gen) 2)) (snd-display #__line__ ";polywave length: ~A?" (mus-length gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(let ((val0 (polywave gen0 0.0))
	      (val (polywave gen 0.0)))
	  (if (fneq val val0) (snd-display #__line__ ";polywave: ~A is not ~F?" val val0))
	  (set! (v0 i) val)))
      (fill-float-vector v1 (if (polywave? gen1) (polywave gen1 0.0) -1.0))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map polywave: ~A ~A" v0 v1))
      (set! gen1 (make-polywave 440.0 (float-vector 1 1)))
      (fill-float-vector v1 (polywave gen1))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";1 map polywave: ~A ~A" v0 v1))
      (if (not (polywave? gen)) (snd-display #__line__ ";~A not polywave?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display #__line__ ";polywave phase: ~F?" (mus-phase gen)))
      (set! (mus-phase gen) 1.0)
      (if (fneq (mus-phase gen) 1.0) (snd-display #__line__ ";set! polywave phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";polywave frequency: ~F?" (mus-frequency gen)))
      (set! (mus-frequency gen) 100.0)
      (if (fneq (mus-frequency gen) 100.0) (snd-display #__line__ ";polywave frequency: ~F?" (mus-frequency gen)))
      (if (not (float-vector? (mus-data gen))) (snd-display #__line__ ";mus-data polywave: ~A" (mus-data gen)))
      (if (or (fneq (v0 1) 0.992) (fneq (v0 8) 0.538)) (snd-display #__line__ ";polywave output: ~A" v0)))
    
    (test-gen-equal (make-polywave 440.0 :partials '(1 1)) 
		    (make-polywave 440.0) 
		    (make-polywave 100.0 :partials '(1 1)))
    (test-gen-equal (make-polywave 440.0 '(1 1)) 
		    (make-polywave 440.0)
		    (make-polywave 440.0 '(1 1 2 .5)))
    (test-gen-equal (make-polywave 440.0 '(1 1)) 
		    (make-polywave 440.0 (float-vector 1 1))
		    (make-polywave 440.0 '(1 .5)))
    (test-gen-equal (make-polywave 440.0 (list 1 .1 2 1 3 .5))
		    (make-polywave 440.0 (float-vector 1 .1 2 1 3 .5))
		    (make-polywave 440.0 '(1 .1 2 .1 3 .5)))
    
    (let ((gen (make-polywave 440.0 '(1 1)))
	  (happy #t))
      (do ((i 0 (+ i 1)))
	  ((or (not happy) (= i 1100)))
	(let* ((a (mus-phase gen))
	       (val1 (cos a))
	       (val2 (gen 0.0)))
	  (if (fneq val1 val2)
	      (begin
		(snd-display #__line__ ";polywaver (1 1) ~A: ~A ~A" i val1 val2)
		(set! happy #f))))))
    
    (let ((gen (make-polywave 440.0)) ; check default for partials: '(1 1)
	  (happy #t))
      (do ((i 0 (+ i 1)))
	  ((or (not happy) (= i 1100)))
	(let* ((a (mus-phase gen))
	       (val1 (cos a))
	       (val2 (gen 0.0)))
	  (if (fneq val1 val2)
	      (begin
		(snd-display #__line__ ";polywaver default: '(1 1) ~A: ~A ~A" i val1 val2)
		(set! happy #f))))))
    
    (let ((gen (make-polywave 440.0 (float-vector 1 1)))
	  (happy #t))
      (set! (mus-scaler gen) 0.5)
      (do ((i 0 (+ i 1)))
	  ((or (not happy) (= i 1100)))
	(let* ((a (mus-phase gen))
	       (val1 (* .5 (cos a)))
	       (val2 (gen 0.0)))
	  (if (fneq val1 val2)
	      (begin
		(snd-display #__line__ ";polywaver (1 1) .5 index ~A: ~A ~A" i val1 val2)
		(set! happy #f))))))
    
    (let ((old-srate *clm-srate*)
	  (v0 (make-float-vector 4410))
	  (v1 (make-float-vector 4410)))
      (set! *clm-srate* 44100)
      (for-each
       (lambda (k)
	 (let ((gen (make-polywave 100.0 (list 1 0.5 k 0.5)))
	       (incr (/ (* 2.0 pi 100.0) 44100))
	       (kincr (/ (* 2.0 k pi 100.0) 44100)))
	   (do ((i 0 (+ i 1)))
	       ((= i 4410))
	     (set! (v0 i) (polywave gen)))
	   (do ((i 0 (+ i 1))
		(ph 0.0 (+ ph incr))
		(kph 0.0 (+ kph kincr)))
	       ((= i 4410))
	     (float-vector-set! v1 i (+ (cos ph) (cos kph))))
	   (float-vector-scale! v1 0.5)
	   (if (not (vequal v0 v1))
	       (snd-display #__line__ ";polywave ~D vs cos: ~A" k (float-vector-peak-and-location (float-vector-subtract! v0 v1))))))
       (list 2 19 20 29 30 39 40 60 100))
      
      (for-each
       (lambda (n)
	 (let ((gen1 (make-polywave 100.0 (list n 1.0)))
	       (gen2 (make-oscil (* n 100.0) (/ pi 2)))
	       (happy #t))
	   (do ((i 0 (+ i 1)))
	       ((or (not happy) (= i 1000)))
	     (let ((val1 (polywave gen1))
		   (val2 (oscil gen2)))
	       (if (fneq val1 val2)
		   (begin
		     (set! happy #f)
		     (snd-display #__line__ ";polywave ~A at ~A: ~A ~A" n i val1 val2)))))))
       (list 1 8 50 128))
      
      (for-each
       (lambda (n)
	 (let ((gen1 (make-polywave 100.0 (list n 1.0) mus-chebyshev-second-kind))
	       (gen2 (make-oscil (* n 100.0)))
	       (happy #t))
	   (do ((i 0 (+ i 1)))
	       ((or (not happy) (= i 1000)))
	     (let ((val1 (polywave gen1))
		   (val2 (oscil gen2)))
	       (if (fneq val1 val2)
		   (begin
		     (set! happy #f)
		     (snd-display #__line__ ";polywave second ~A at ~A: ~A ~A" n i val1 val2)))))))
       (list 1 8 50 128))
      
      (for-each
       (lambda (n)
	 (let ((gen1 (make-polyshape 100.0 :partials (list n 1.0)))
	       (gen2 (make-oscil (* n 100.0) (/ pi 2)))
	       (happy #t))
	   (do ((i 0 (+ i 1)))
	       ((or (not happy) (= i 1000)))
	     (let ((val1 (polyshape gen1))
		   (val2 (oscil gen2)))
	       (if (fneq val1 val2)
		   (begin
		     (set! happy #f)
		     (snd-display #__line__ ";polyshape ~A at ~A: ~A ~A" n i val1 val2)))))))
       (list 1 8 16))
      
      (for-each
       (lambda (n)
	 (let ((gen1 (make-polyshape 100.0 :partials (list n 1.0) :kind mus-chebyshev-second-kind))
	       (gen2 (make-oscil (* n 100.0)))
	       (happy #t))
	   (do ((i 0 (+ i 1)))
	       ((or (not happy) (= i 1000)))
	     (let ((val1 (polyshape gen1))
		   (val2 (oscil gen2)))
	       (if (fneq val1 val2)
		   (begin
		     (set! happy #f)
		     (snd-display #__line__ ";polyshape second ~A at ~A: ~A ~A" n i val1 val2)))))))
       (list 1 8 16))
      
      (for-each
       (lambda (n)
	 (let ((gen1 (make-polywave 100.0 (list n 1.0) mus-chebyshev-first-kind))
	       (gen2 (make-oscil (* n 100.0) (/ pi 2)))
	       (max-dist 0.0))
	    (do ((i 0 (+ i 1)))
		((= i 1000))
	      (let ((val1 (polywave gen1))
		    (val2 (oscil gen2)))
		(set! max-dist (max max-dist (abs (- val1 val2))))))
	   (if (fneq max-dist 0.0)
	       (snd-display #__line__ ";polywave run ~A: ~A" n max-dist))))
       (list 1 3 30 200))
      
      (for-each
       (lambda (n)
	 (let ((gen1 (make-polywave 100.0 (list n 1.0) mus-chebyshev-second-kind))
	       (gen2 (make-oscil (* n 100.0)))
	       (max-dist 0.0))
	    (do ((i 0 (+ i 1)))
		((= i 1000))
	      (let ((val1 (polywave gen1))
		    (val2 (oscil gen2)))
		(set! max-dist (max max-dist (abs (- val1 val2))))))
	   (if (fneq max-dist 0.0)
	       (snd-display #__line__ ";polywave second run ~A: ~A" n max-dist))))
       (list 1 3 30 200))
      
      (for-each
       (lambda (n)
	 (let ((gen1 (make-polyshape 100.0 :partials (list n 1.0) :kind mus-chebyshev-first-kind))
	       (gen2 (make-oscil (* n 100.0) (/ pi 2)))
	       (max-dist 0.0))
	    (do ((i 0 (+ i 1)))
		((= i 1000))
	      (let ((val1 (polyshape gen1))
		    (val2 (oscil gen2)))
		(set! max-dist (max max-dist (abs (- val1 val2))))))
	   (if (fneq max-dist 0.0)
	       (snd-display #__line__ ";polyshape run ~A: ~A" n max-dist))))
       (list 1 3 25))
      
      (for-each
       (lambda (n)
	 (let ((gen1 (make-polyshape 100.0 :partials (list n 1.0) :kind mus-chebyshev-second-kind))
	       (gen2 (make-oscil (* n 100.0)))
	       (max-dist 0.0))
	    (do ((i 0 (+ i 1)))
		((= i 1000))
	      (let ((val1 (polyshape gen1))
		    (val2 (oscil gen2)))
		(set! max-dist (max max-dist (abs (- val1 val2))))))
	   (if (fneq max-dist 0.0)
	       (snd-display #__line__ ";polyshape second run ~A: ~A" n max-dist))))
       (list 1 3 25))
      
      (let ((gen (make-polywave 100.0 (list 1 .9 3 .1 4 0.0))))
	(let ((vals (mus-data gen)))
	  (if (or (not (float-vector? vals))
		  (not (vequal vals (float-vector 0.000 0.900 0.000 0.100 0.00))))
	      (snd-display #__line__ ";polywave mus-data: ~A" vals)
	      (begin
		(float-vector-set! (mus-data gen) 2 .1)
		(float-vector-set! (mus-data gen) 3 0.0)
		(let ((happy #t)
		      (gen1 (make-oscil 100.0 (/ pi 2)))
		      (gen2 (make-oscil 200.0 (/ pi 2))))
		  (do ((i 0 (+ i 1)))
		      ((or (not happy) (= i 1000)))
		    (let ((val1 (polywave gen))
			  (val2 (+ (* .9 (oscil gen1))
				   (* .1 (oscil gen2)))))
		      (if (fneq val1 val2)
			  (begin
			    (set! happy #f)
			    (snd-display #__line__ ";polywave set mus-data at ~A: ~A ~A" i val1 val2))))))))))
      (set! *clm-srate* old-srate))
    
    ;; check dc 
    (do ((i 2 (+ i 1)))
	((= i 7))
      (let ((cfs (make-list (* 2 i) 0.1)))
	(do ((k 0 (+ k 2)))
	    ((>= k (length cfs)))
	  (set! (cfs k) (/ k 2)))
	(let ((p (make-polywave 100.0 cfs mus-chebyshev-second-kind)))
	  (let ((val (polywave p)))
	    (if (fneq val 0.1)
		(snd-display #__line__ ";polywave ~D order second 0-coeff: ~A" i val))))))
    
    (do ((i 2 (+ i 1)))
	((= i 7))
      (let ((cfs (make-list (* 2 i) 0.1)))
	(do ((k 0 (+ k 2)))
	    ((>= k (length cfs)))
	  (set! (cfs k) (/ k 2)))
	(let ((p (make-polywave 100.0 cfs mus-chebyshev-first-kind)))
	  (let ((val (polywave p)))
	    (if (fneq val (* 0.1 i))
		(snd-display #__line__ ";polywave ~D order first 0-coeff: ~A" i val))))))

    (let ((var (catch #t (lambda () (make-polywave 440.0 3.14)) (lambda args args))))
      (if (not (eq? (car var) 'wrong-type-arg))
	  (snd-display #__line__ ";make-polywave bad coeffs: ~A" var)))
    
    (let ((gen (make-wave-train 440.0 0.0 (make-float-vector 20)))
	  (v0 (make-float-vector 10))
	  (gen1 (make-wave-train 440.0 0.0 (make-float-vector 20)))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "wave-train"
		       "wave-train freq: 440.000Hz, phase: 0.000, size: 20, interp: linear")
      (do ((i 0 (+ i 1)))
	  ((= i 20))
	(float-vector-set! (mus-data gen) i (* i .5))
	(float-vector-set! (mus-data gen1) i ((mus-data gen) i)))
      (if (not (= (length (mus-data gen)) 20)) (snd-display #__line__ ";wave-train data length: ~A?" (length (mus-data gen))))
      (if (not (= (mus-length gen) 20)) (snd-display #__line__ ";wave-train length: ~A?" (mus-length gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (wave-train gen 0.0)))
      (fill-float-vector v1 (if (wave-train? gen1) (wave-train gen1) -1.0))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map wave-train: ~A ~A" v0 v1))
      (if (not (wave-train? gen)) (snd-display #__line__ ";~A not wave-train?" gen))
      (if (fneq (mus-phase gen) 0.0) (snd-display #__line__ ";wave-train phase: ~F?" (mus-phase gen)))
      (set! (mus-phase gen) 1.0)
      (if (fneq (mus-phase gen) 1.0) (snd-display #__line__ ";set wave-train phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";wave-train frequency: ~F?" (mus-frequency gen)))
      (set! (mus-frequency gen) 100.0)
      (if (fneq (mus-frequency gen) 100.0) (snd-display #__line__ ";set wave-train freq: ~A" (mus-frequency gen)))
      (if (or (fneq (v0 1) 0.5) (fneq (v0 8) 4.0)) (snd-display #__line__ ";wave-train output: ~A" v0))
      (mus-reset gen)
      (if (fneq (mus-phase gen) 0.0) (snd-display #__line__ ";wt reset phase: ~A" (mus-phase gen)))
      (let ((val (wave-train gen 0.0)))
	(if (fneq val 0.0) (snd-display #__line__ ";wt reset data: ~A" val)))
      (if (not (float-vector? (mus-data gen))) (snd-display #__line__ ";mus-data wave-train: ~A" (mus-data gen)))
      (set! (mus-data gen) (make-float-vector 3)))
    
    (test-gen-equal (make-wave-train 440.0 0.0 (make-float-vector 20)) (make-wave-train 440.0 0.0 (make-float-vector 20)) (make-wave-train 100.0 0.0 (make-float-vector 20)))
    (test-gen-equal (make-wave-train 440.0 0.0 (make-float-vector 20)) (make-wave-train 440.0 0.0 (make-float-vector 20)) (make-wave-train 440.0 1.0 (make-float-vector 20)))
    
    (test-gen-equal (make-wave-train-with-env 440.0 '(0 0 1 1))
		    (make-wave-train-with-env 440.0 (list 0 0 1 1))
		    (make-wave-train-with-env 440.0 '(0 0 1 1 2 0)))
    
    (let ((hi (make-wave-train :size 256)))
      (if (not (= (mus-length hi) 256)) (snd-display #__line__ ";wave-train set length: ~A?" (mus-length hi)))
      (set! (mus-length hi) 128)
      (if (not (= (mus-length hi) 128)) (snd-display #__line__ ";set wave-train set length: ~A?" (mus-length hi))))
    
    (for-each 
     (lambda (args)
       (let ((type (car args))
	     (vals (cadr args)))
	 (let ((tbl1 (make-wave-train :frequency 3000.0 :initial-phase (/ (* 2.0 pi .2) 4) :size 4 :type type)))
	   (float-vector-set! (mus-data tbl1) 1 1.0)
	   (let ((v (make-float-vector 10)))
	     (do ((i 0 (+ i 1)))
		 ((= i 10))
	       (set! (v i) (wave-train tbl1 0.0))) ;(wave-train tbl1 (/ (* 2 pi .2) 4))))
	     (if (not (vequal v vals))
		 (snd-display #__line__ ";wt tbl interp ~A: ~A ~A" type v (mus-describe tbl1)))
	     (if (not (= (mus-interp-type tbl1) type)) (snd-display #__line__ ";wt tbl interp-type (~A): ~A" type (mus-interp-type tbl1)))))))
     (list 
      (list mus-interp-none (float-vector 0.000 1.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 1.000))
      (list mus-interp-linear (float-vector 0.200 0.800 0.000 0.000 0.000 0.000 0.000 0.000 0.200 0.800))
      (list mus-interp-lagrange (float-vector 0.120 0.960 -0.080 0.000 0.000 0.000 0.000 0.000 0.120 0.960))
      (list mus-interp-hermite (float-vector 0.168 0.912 -0.064 -0.016 0.000 0.000 0.000 0.000 0.168 0.912))))
    
    (let ((tag (catch #t (lambda () (make-wave-train :size 0)) (lambda args (car args)))))
      (if (not (eq? tag 'out-of-range)) (snd-display #__line__ ";wave-train size 0: ~A" tag)))
    
    (let ((ind (new-sound "fmv.snd" :size 10 :comment "line 20501")))
      (if (not (= (framples) 10)) (snd-display #__line__ ";new-sound size(10): ~A" (framples)))
      (map-channel (lambda (y) 1.0) 7 8)
      (if (not (= (framples) 15)) (snd-display #__line__ ";map-channel 7 8: ~A" (framples)))
      (map-channel (lambda (y) 1.0))
      (if (not (= (framples) 15)) (snd-display #__line__ ";map-channel (no dur): ~A" (framples)))
      (revert-sound ind)
      (map-channel (lambda (y) 1.0) 9 10)
      (if (not (= (framples) 19)) (snd-display #__line__ ";map-channel 9 10: ~A" (framples)))
      (if (> (edit-position ind 0) 2) (snd-display #__line__ ";map-channel pad edits: ~A" (edit-position ind 0)))
      (revert-sound ind)
      (map-channel (lambda (y) 1.0) 10 10)
      (if (not (= (framples) 20)) (snd-display #__line__ ";map-channel 10 10: ~A" (framples)))
      (if (> (edit-position ind 0) 2) (snd-display #__line__ ";map-channel pad edits (2): ~A" (edit-position ind 0)))
      (revert-sound ind)
      (map-channel (lambda (y) 1.0) 20 10)
      (if (not (= (framples) 30)) (snd-display #__line__ ";map-channel 20 10: ~A" (framples)))
      (if (> (edit-position ind 0) 2) (snd-display #__line__ ";map-channel pad edits (3): ~A" (edit-position ind 0)))
      (revert-sound ind)
      (if (scan-channel (lambda (y) #f) 30 10) (snd-display #__line__ ";scan-channel past end?"))
      (let ((new-file-name (file-name ind)))
	(close-sound ind)
	(if (file-exists? new-file-name) (delete-file new-file-name))))
    
    (let ((ind (new-sound :size 1000)))
      (let* ((table (float-vector 0.0 .1 .2 .3 .4 .5 .6))
	     (gen (make-wave-train 1000.0 :wave table)))
	(map-channel (lambda (y) (wave-train gen)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.6) (snd-display #__line__ ";wt 0 max: ~A" mx)))
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.000 0.100 0.200 0.300 0.400 0.500 0.600 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 
			      0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.100 0.200 0.300 0.400 0.500 0.600)))
	    (snd-display #__line__ ";wt 0 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (channel->float-vector 85 30) 
			 (float-vector 0.000 0.000 0.000 0.000 0.000 0.100 0.200 0.300 0.400 0.500 0.600 0.000 0.000 0.000 0.000 
			      0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.100 0.200 0.300)))
	    (snd-display #__line__ ";wt 0 data 85: ~A" (channel->float-vector 85 30)))
	(undo))
      
      (let* ((table (make-float-vector 10 .1))
	     (gen (make-wave-train 1000.0 :initial-phase pi :wave table))) ; initial-phase is confusing in this context!
	(map-channel (lambda (y) (wave-train gen)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.1) (snd-display #__line__ ";wt 1 max: ~A" mx)))
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.100 0.100 0.100 0.100 0.100 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 
			      0.000 0.000 0.000 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.000)))
	    (let ((op *print-length*))
	      (set! *print-length* 32)
	      (snd-display #__line__ ";wt 1 data: ~A" (channel->float-vector 0 30))
	      (set! *print-length* op)))
	(undo))
      
      (let* ((table (make-float-vector 10 .1))
	     (gen (make-wave-train 2000.0 :wave table)))
	(map-channel (lambda (y) (wave-train gen)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.1) (snd-display #__line__ ";wt 2 max: ~A" mx)))
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.000 0.100 0.100 0.100 
			      0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.100 0.100 0.100 0.100 0.100 0.100 0.100)))
	    (snd-display #__line__ ";wt 2 data: ~A" (channel->float-vector 0 30)))
	(if (and (not (vequal (channel->float-vector 440 30) 
			      (float-vector 0.000 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.000 0.100 0.100 
				   0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.100 0.100 0.100 0.100 0.100 0.100)))
		 ;; if double, round off is just enough different to cause an off-by-1 problem here (and below)
		 (not (vequal (channel->float-vector 440 30) 
			      (float-vector 0.000 0.000 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.100 0.100 
				   0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.100 0.100 0.100 0.100 0.100 0.100))))
	    (snd-display #__line__ ";wt 2 data 440: ~A" (channel->float-vector 440 30)))
	(undo))
      
      (let* ((table (make-float-vector 10 .1))
	     (gen (make-wave-train 3000.0 :wave table)))
	(map-channel (lambda (y) (wave-train gen)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.2) (snd-display #__line__ ";wt 3 max: ~A" mx)))
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.200 0.200 0.100 0.100 0.100 0.100 0.100 
			      0.200 0.200 0.200 0.100 0.100 0.100 0.100 0.100 0.200 0.200 0.100 0.100 0.100 0.100 0.100)))
	    (snd-display #__line__ ";wt 3 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (channel->float-vector 440 30) 
			 (float-vector 0.100 0.200 0.200 0.200 0.100 0.100 0.100 0.100 0.100 0.200 0.200 0.100 0.100 0.100 0.100 
			      0.100 0.200 0.200 0.200 0.100 0.100 0.100 0.100 0.100 0.200 0.200 0.100 0.100 0.100 0.100)))
	    (snd-display #__line__ ";wt 3 data 440: ~A" (channel->float-vector 440 30)))
	(undo))
      
      (let* ((table (make-float-vector 10 .1))
	     (gen (make-wave-train 5000.0 :wave table)))
	(map-channel (lambda (y) (wave-train gen)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.3) (snd-display #__line__ ";wt 4 max: ~A" mx)))
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.100 0.100 0.100 0.100 0.100 0.200 0.200 0.200 0.200 0.300 0.200 0.200 0.200 0.200 0.300 
			      0.200 0.200 0.200 0.300 0.200 0.200 0.200 0.200 0.300 0.200 0.200 0.200 0.300 0.200 0.200)))
	    (snd-display #__line__ ";wt 4 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (channel->float-vector 440 30) 
			 (float-vector 0.200 0.200 0.300 0.200 0.200 0.200 0.300 0.200 0.200 0.200 0.300 0.300 0.200 0.200 0.200 
			      0.300 0.200 0.200 0.200 0.300 0.200 0.200 0.200 0.200 0.300 0.200 0.200 0.200 0.300 0.200)))
	    (snd-display #__line__ ";wt 4 data 440: ~A" (channel->float-vector 440 30)))
	(undo))
      
      (let* ((table (make-float-vector 10 .1))
	     (gen (make-wave-train 1000.0 :wave table))
	     (e (make-env '(0 1 1 2) :length 1001))
	     (base-freq (mus-frequency gen)))
	(map-channel 
	 (lambda (y) 
	   (let ((result (wave-train gen)))
	     (set! (mus-frequency gen) (* base-freq (env e)))
	     result)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.1) (snd-display #__line__ ";wt 5 max: ~A" mx)))
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.000 0.000 0.000 0.000 
			      0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.100 0.100 0.100 0.100 0.100 0.100 0.100)))
	    (snd-display #__line__ ";wt 5 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (channel->float-vector 440 30) 
			 (float-vector 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.000 0.000 0.000 0.000 0.000 0.100 
			      0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.000 0.000 0.000 0.000 0.100)))
	    (snd-display #__line__ ";wt 5 data 440: ~A" (channel->float-vector 440 30)))
	(if (not (vequal (channel->float-vector 900 30) 
			 (float-vector 0.100 0.000 0.000 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.100 
			      0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.000 0.100 0.100 0.100 0.100)))
	    (snd-display #__line__ ";wt 5 data 900: ~A" (channel->float-vector 900 30)))
	(undo))
      
      (let* ((table (make-float-vector 10 .1))
	     (gen (make-wave-train 500.0 :wave table))
	     (ctr 0))
	(map-channel 
	 (lambda (y) 
	   (let ((result (wave-train gen)))
	     (if (> ctr 22)
		 (begin
		   (set! ctr 0)
		   (float-vector-scale! (mus-data gen) 1.05))
		 (set! ctr (+ ctr 1)))
	     result)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.704) (snd-display #__line__ ";wt 6 max: ~A" mx)))
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.000 0.000 0.000 0.000 
			      0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";wt 6 data: ~A" (channel->float-vector 0 30)))
	(if (and (not (vequal (channel->float-vector 440 30) 
			      (float-vector 0.000 0.241 0.241 0.241 0.241 0.241 0.241 0.241 0.241 0.241 0.241 0.000 0.000 0.000 0.000
				   0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
		 (not (vequal (channel->float-vector 440 30) 
			      (float-vector 0.000 0.000 0.241 0.241 0.241 0.241 0.241 0.241 0.241 0.241 0.241 0.241 0.000 0.000 0.000 0.000
				   0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000))))
	    (snd-display #__line__ ";wt 6 data 440: ~A" (channel->float-vector 440 30)))
	(if (not (vequal (channel->float-vector 900 30) 
			 (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 
			      0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.639 0.639 0.639)))
	    (snd-display #__line__ ";wt 6 data 900: ~A" (channel->float-vector 900 30)))
	(undo))
      (let ((fname (file-name ind)))
	(close-sound ind)
	(delete-file fname)))
    
    (let ((gen (make-readin "oboe.snd" 0 1490))
	  (v0 (make-float-vector 10))
	  (gen1 (make-readin "oboe.snd" 0 1490))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "readin"
		       "readin oboe.snd[chan 0], loc: 1490, dir: 1")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (readin gen)))
      (fill-float-vector v1 (if (readin? gen1) 
			 (if (= (mus-channel gen1) 0) 
			     (readin gen1) 
			     1.0) 
			 (if (string=? (mus-file-name gen1) "oboe.snd")
			     -1.0
			     1.0)))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map readin: ~A ~A" v0 v1))
      (if (not (readin? gen)) (snd-display #__line__ ";~A not readin?" gen))
      (if (not (mus-input? gen)) (snd-display #__line__ ";~A not input?" gen))
      (if (not (= (mus-length gen) 50828)) (snd-display #__line__ ";readin length: ~A?" (mus-length gen)))
      (if (not (= (mus-channel gen) 0)) (snd-display #__line__ ";readin chan: ~A?" (mus-channel gen)))
      (if (not (string=? (mus-file-name gen) "oboe.snd")) (snd-display #__line__ ";readin mus-file-name: ~A" (mus-file-name gen)))
      (if (or (fneq (v0 1) -0.009) (fneq (v0 7) .029)) (snd-display #__line__ ";readin output: ~A" v0))
      (set! (mus-location gen) 1000)
      (if (not (= (mus-location gen) 1000)) (snd-display #__line__ ";set! mus-location: ~A?" (mus-location gen)))
      (let ((val (readin gen)))
	(if (fneq val 0.033) (snd-display #__line__ ";set! mus-location readin: ~A?" val)))
      (set! (mus-increment gen) -1)
      (if (fneq (mus-increment gen) -1.0) (snd-display #__line__ ";set increment readin: ~A" (mus-increment gen))))
    (let ((tag (catch #t (lambda () (make-readin "/baddy/hiho" 0 124)) (lambda args args))))
      (if (not (eq? (car tag) 'no-such-file)) (snd-display #__line__ ";make-readin w/o file: ~A" tag)))
    (let ((tag (catch #t (lambda () (make-readin "oboe.snd" 123 124)) (lambda args args))))
      (if (not (eq? (car tag) 'out-of-range)) (snd-display #__line__ ";make-readin with bad chan: ~A" tag)))
    
    (test-gen-equal (make-readin "oboe.snd" 0) (make-readin "oboe.snd" 0) (make-readin "oboe.snd" 0 1230))
    (test-gen-equal (make-readin "oboe.snd" 0 :size 512) (make-readin "oboe.snd" 0 :size 512) (make-readin "pistol.snd" 0 :size 512))
    (test-gen-equal (make-readin "2.snd" 1) (make-readin "2.snd" 1) (make-readin "2.snd" 0))
    
    (let ((gen (make-readin "2.snd" 1 :size 1024))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "readin"
		       "readin 2.snd[chan 1], loc: 0, dir: 1")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (readin gen)))
      (if (not (= (mus-channel gen) 1)) (snd-display #__line__ ";readin chan 1: ~A?" (mus-channel gen)))
      (if (or (fneq (v0 1) 0.010) (fneq (v0 7) -.006)) (snd-display #__line__ ";readin 1 output: ~A" v0))
      (print-and-check gen 
		       "readin"
		       "readin 2.snd[chan 1], loc: 10, dir: 1"))
    
    (let ((gen (make-file->sample "oboe.snd"))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "file->sample"
		       "file->sample oboe.snd")
      (if (not (mus-input? gen)) (snd-display #__line__ ";~A not input?" gen))
      (if (not (= (mus-length gen) 50828)) (snd-display #__line__ ";file->sample length: ~A?" (mus-length gen)))
      (if (not (string=? (mus-file-name gen) "oboe.snd")) (snd-display #__line__ ";file->sample mus-file-name: ~A" (mus-file-name gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (file->sample gen (+ 1490 i))))
      (if (not (file->sample? gen)) (snd-display #__line__ ";~A not file->sample?" gen))
      (if (or (fneq (v0 1) -0.009) (fneq (v0 7) .029)) (snd-display #__line__ ";file->sample output: ~A" v0))
      (if (fneq (mus-increment gen) 0.0) (snd-display #__line__ ";file->sample increment: ~A" (mus-increment gen)))
      (set! (mus-increment gen) 1.0)
      (if (fneq (mus-increment gen) 1.0) (snd-display #__line__ ";file->sample set increment: ~A" (mus-increment gen)))
      (mus-reset gen)) ; a no-op I hope
    
    (let* ((ind (open-sound "oboe.snd"))
	   (gen (make-snd->sample ind))
	   (gen1 (make-snd->sample ind))
	   (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "snd->sample"
		       "snd->sample reading oboe.snd (1 chan) at 0:[no readers]")
      (if (equal? gen gen1) (snd-display #__line__ ";snd->sample eq? not itself?"))
      (if (not (mus-input? gen)) (snd-display #__line__ ";snd->sample ~A not input?" gen))
      (if (not (= (framples ind) (mus-length gen))) (snd-display #__line__ ";snd->sample len: ~A ~A" (framples ind) (mus-length gen)))
      (if (not (string=? (mus-file-name gen) (string-append cwd "oboe.snd")))
	  (snd-display #__line__ ";snd->sample mus-file-name: ~A ~A" (mus-file-name gen) (string-append cwd "oboe.snd")))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (snd->sample gen (+ 1490 i))))
      (if (not (snd->sample? gen)) (snd-display #__line__ ";~A not snd->sample?" gen))
      (if (or (fneq (v0 1) -0.009) (fneq (v0 7) .029)) (snd-display #__line__ ";snd->sample output: ~A" v0))
      (if (not (= (mus-channels gen) 1)) (snd-display #__line__ ";snd->sample channels: ~A" (mus-channels gen)))
      (if (not (= (mus-location gen) 1499)) (snd-display #__line__ ";snd->sample location: ~A" (mus-location gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (ina (+ 1490 i) gen)))
      (if (or (fneq (v0 1) -0.009) (fneq (v0 7) .029)) (snd-display #__line__ ";snd->sample ina output: ~A" v0))
      (close-sound ind))
    
    (let* ((ind (open-sound "2.snd"))
	   (gen (make-snd->sample ind))
	   (v0 (make-float-vector 10)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (snd->sample gen (+ 1490 i) 0))
	(set! (v0 i) (snd->sample gen (+ 1490 i) 1)))
      (print-and-check gen 
		       "snd->sample"
		       "snd->sample reading 2.snd (2 chans) at 1499:[#<sampler: 2.snd[0: 0] from 1490, at 1500, forward>, #<sampler: 2.snd[1: 0] from 1490, at 1500, forward>]")
      (if (not (mus-input? gen)) (snd-display #__line__ ";snd->sample ~A not input?" gen))
      (if (not (string=? (mus-file-name gen) (string-append cwd "2.snd")))
	  (snd-display #__line__ ";snd->sample mus-file-name: ~A ~A" (mus-file-name gen) (string-append cwd "2.snd")))
      (if (not (snd->sample? gen)) (snd-display #__line__ ";~A not snd->sample?" gen))
      (if (not (= (mus-channels gen) 2)) (snd-display #__line__ ";snd->sample channels (2): ~A" (mus-channels gen)))
      (if (not (= (mus-location gen) 1499)) (snd-display #__line__ ";snd->sample location (2): ~A" (mus-location gen)))
      (close-sound ind))
    
    (let ((gen (make-file->frample "oboe.snd"))
	  (v0 (make-float-vector 10))
	  (g1 (float-vector 0.0)))
      (print-and-check gen 
		       "file->frample"
		       "file->frample oboe.snd"
		       "file->frample oboe.snd")
      (if (not (mus-input? gen)) (snd-display #__line__ ";~A not input?" gen))
      (if (not (= (mus-length gen) 50828)) (snd-display #__line__ ";file->frample length: ~A?" (mus-length gen)))
      (if (not (string=? (mus-file-name gen) "oboe.snd")) (snd-display #__line__ ";file->frample mus-file-name: ~A" (mus-file-name gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) ((file->frample gen (+ 1490 i) g1) 0)))
      (if (not (file->frample? gen)) (snd-display #__line__ ";~A not file->frample?" gen))
      (if (or (fneq (v0 1) -0.009) (fneq (v0 7) .029)) (snd-display #__line__ ";file->frample output: ~A" v0)))
    
    (if (file-exists? "fmv.snd") (delete-file "fmv.snd"))
    (if (file-exists? "fmv1.snd") (delete-file "fmv1.snd"))
    (if (file-exists? "fmv2.snd") (delete-file "fmv2.snd"))
    (if (file-exists? "fmv3.snd") (delete-file "fmv3.snd"))
    (let ((gen (make-sample->file "fmv.snd" 2 mus-lshort mus-riff)))
      (print-and-check gen 
		       "sample->file"
		       "sample->file fmv.snd")
      (if (not (mus-output? gen)) (snd-display #__line__ ";~A not output?" gen))
      (if (not (sample->file? gen)) (snd-display #__line__ ";~A not sample->file?" gen))
      (if (not (= (mus-length gen) *clm-file-buffer-size*)) (snd-display #__line__ ";sample->file length: ~A?" (mus-length gen)))
      (let ((genx gen))
	(if (not (equal? genx gen)) (snd-display #__line__ ";sample->file equal? ~A ~A" genx gen)))
      (if (not (string=? (mus-file-name gen) "fmv.snd")) (snd-display #__line__ ";sample->file mus-file-name: ~A" (mus-file-name gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 100))
	(sample->file gen i 0 (* i .001))
	(sample->file gen i 1 (* i .01)))
      (outa 50 .015 gen)
      (outb 50 .15 gen)
      (out-any 60 .015 0 gen)
      (out-any 60 .15 1 gen)
      (mus-close gen))
    (let* ((gen (make-file->sample "fmv.snd"))
	   (val0 (in-any 20 0 gen))
	   (val1 (in-any 20 1 gen))
	   (val2 (ina 30 gen))
	   (val3 (inb 30 gen))
	   (val4 (file->sample gen 40 0))
	   (val5 (file->sample gen 40 1))
	   (val6 (in-any 50 0 gen))
	   (val7 (in-any 50 1 gen))
	   (val8 (in-any 60 0 gen))
	   (val9 (in-any 60 1 gen)))
      (print-and-check gen 
		       "file->sample"
		       "file->sample fmv.snd")
      (if (not (= (mus-channels gen) 2)) (snd-display #__line__ ";make-sample->file chans: ~A?" (mus-channels gen)))
      (if (not (mus-input? gen)) (snd-display #__line__ ";~A not input?" gen))
      (if (or (fneq val0 .02) (fneq val1 .2)) (snd-display #__line__ ";in-any: ~A ~A?" val0 val1))
      (if (or (fneq val2 .03) (fneq val3 .3)) (snd-display #__line__ ";inab: ~A ~A?" val2 val3))
      (if (or (fneq val4 .04) (fneq val5 .4)) (snd-display #__line__ ";sample->file: ~A ~A?" val4 val5))
      (if (or (fneq val6 .065) (fneq val7 .65)) (snd-display #__line__ ";outab: ~A ~A?" val6 val7))
      (if (or (fneq val8 .075) (fneq val9 .75)) (snd-display #__line__ ";out-any: ~A ~A?" val8 val9)))
    
    (let ((gen (make-float-vector 10)))
      (do ((i 0 (+ i 1))
	   (x 0.0 (+ x 0.1)))
	  ((= i 10))
	(outa i x gen))
      (if (not (vequal gen (float-vector 0 .1 .2 .3 .4 .5 .6 .7 .8 .9)))
	  (snd-display #__line__ ";outa->float-vector ramp: ~A" gen))
      (do ((i 0 (+ i 1))
	   (x 0.0 (+ x 0.1)))
	  ((= i 10))
	(outa i x gen))
      (if (not (vequal gen (float-vector-scale! (float-vector 0 .1 .2 .3 .4 .5 .6 .7 .8 .9) 2.0)))
	  (snd-display #__line__ ";outa->float-vector ramp 2: ~A" gen))
      (if (not (= (mus-channels gen) 1)) (snd-display #__line__ ";mus-channels float-vector: ~A" (mus-channels gen))))
    
    (let ((gen (make-float-vector (list 4 100) 0.0)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(outa i .1 gen)
	(outb i .2 gen)
	(outc i .3 gen)
	(outd i .4 gen))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(outa i .01 gen)
	(outb i .02 gen)
	(outc i .03 gen)
	(outd i .04 gen))
      (mus-close gen) ; should be a no-op
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(if (or (fneq (ina i gen) .11)
		(fneq (inb i gen) .22)
		(fneq (in-any i 2 gen) .33)
		(fneq (in-any i 3 gen) .44))
	    (snd-display #__line__ ";4-chan sd out/in[~A]: ~A ~A ~A ~A?" i (ina i gen) (inb i gen) (in-any i 2 gen) (in-any i 3 gen))))  
      (if (not (= (mus-channels gen) 4)) (snd-display #__line__ ";mus-channels sd 4: ~A" (mus-channels gen))))
    
    (let ((gen (make-float-vector (list 4 100) 0.0)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(out-any i .1 0 gen)
	(out-any i .2 1 gen)
	(out-any i .3 2 gen)
	(out-any i .4 3 gen))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(out-any i .01 0 gen)
	(out-any i .02 1 gen)
	(out-any i .03 2 gen)
	(out-any i .04 3 gen))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(if (or (fneq (in-any i 0 gen) .11)
		(fneq (in-any i 1 gen) .22)
		(fneq (in-any i 2 gen) .33)
		(fneq (in-any i 3 gen) .44))
	    (snd-display #__line__ ";4-chan sd out/in-any[~A]: ~A ~A ~A ~A?" i (in-any i 0 gen) (in-any i 1 gen) (in-any i 2 gen) (in-any i 3 gen)))))
    
    (let ((gen (make-oscil 440.0)))
      (let ((tag (catch #t (lambda () (outa 0 .1 gen)) (lambda args (car args)))))
	(if (and (not (eq? tag 'wrong-type-arg)) 
		 (not (eq? tag 'mus-error)))
	    (snd-display #__line__ ";outa -> oscil: ~A" tag))))
    
    (let ((gen (make-sample->file "fmv.snd" 4 mus-lshort mus-riff)))
      (print-and-check gen 
		       "sample->file"
		       "sample->file fmv.snd")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(outa i .1 gen)
	(outb i .2 gen)
	(outc i .3 gen)
	(outd i .4 gen))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(outa i .01 gen)
	(outb i .02 gen)
	(outc i .03 gen)
	(outd i .04 gen))
      (mus-close gen))
    (let ((gen (make-file->sample "fmv.snd")))
      (print-and-check gen 
		       "file->sample"
		       "file->sample fmv.snd")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(if (or (fneq (ina i gen) .11)
		(fneq (inb i gen) .22)
		(fneq (in-any i 2 gen) .33)
		(fneq (in-any i 3 gen) .44))
	    (snd-display #__line__ ";4-chan out/in[~A]: ~A ~A ~A ~A?" i (ina i gen) (inb i gen) (in-any i 2 gen) (in-any i 3 gen)))))
    
    (let ((gen (make-sample->file "fmv.snd" 4 mus-lshort mus-riff)))
       (do ((i 0 (+ i 1)))
	   ((= i 10))
	 (outa i .1 gen)
	 (outb i .2 gen)
	 (outc i .3 gen)
	 (outd i .4 gen))
       (do ((i 0 (+ i 1)))
	   ((= i 10))
	 (outa i .01 gen)
	 (outb i .02 gen)
	 (outc i .03 gen)
	 (outd i .04 gen))
      (mus-close gen))
    (let ((gen (make-file->sample "fmv.snd")))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(if (or (fneq (ina i gen) .11)
		(fneq (inb i gen) .22)
		(fneq (in-any i 2 gen) .33)
		(fneq (in-any i 3 gen) .44))
	    (snd-display #__line__ ";4-chan out/in[~A]: ~A ~A ~A ~A?" i (ina i gen) (inb i gen) (in-any i 2 gen) (in-any i 3 gen)))))
    
    (let ((var (catch #t (lambda () (make-sample->file "fmv.snd" -1 mus-lshort mus-next)) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display #__line__ ";make-sample->file bad chans: ~A" var)))
    (let ((var (catch #t (lambda () (mus-location (make-oscil))) (lambda args args))))
      (if (or (not (list? var)) (not (eq? (car var) 'mus-error)))
	  (snd-display #__line__ ";mus-location oscil: ~A" var)))
    (let ((var (catch #t (lambda () (make-sample->file "fmv.snd" 1 -1 mus-next)) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display #__line__ ";make-sample->file bad format: ~A" var)))
    (let ((var (catch #t (lambda () (make-sample->file "fmv.snd" 1 mus-lshort -1)) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display #__line__ ";make-sample->file bad type: ~A" var)))
    
    (let ((v (vector 1.0 0.5 0.25 0.125 0.0))
	  (v1 (make-float-vector 5 0.0)))
      (do ((i 0 (+ i 1)))
	  ((= i 5))
	(set! (v1 i) (in-any i 0 v)))
      (if (not (vequal v1 (float-vector 1.0 0.5 0.25 0.125 0.0)))
	  (snd-display #__line__ ";vector in-any -> ~A?" v1)))
    
    (let ((invals (make-float-vector 10)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(float-vector-set! invals i (* i 0.1)))
      (let ((result (with-sound ((make-float-vector 10))
				(do ((i 0 (+ i 1)))
				    ((= i 10))
				  (outa i (ina i invals))))))
	(if (not (vequal result (float-vector 0.000 0.100 0.200 0.300 0.400 0.500 0.600 0.700 0.800 0.900)))
	    (snd-display #__line__ ";ina from float-vector: ~A" result))))
    
    (let ((invals (make-float-vector 10)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(float-vector-set! invals i (* i 0.1)))
      (let ((result (with-sound ((make-float-vector 10))
				 (do ((i 0 (+ i 1)))
				     ((= i 10))
				   (outa i (ina i invals))))))
	(if (not (vequal result (float-vector 0.000 0.100 0.200 0.300 0.400 0.500 0.600 0.700 0.800 0.900)))
	    (snd-display #__line__ ";run ina from float-vector: ~A" result))))
    
    (for-each close-sound (sounds))
    
    (let ((vals (with-sound ((make-float-vector 4410))
			    (fm-violin 0 .1 440 .1))))
      (if (fneq (float-vector-peak vals) .1)
	  (snd-display #__line__ ";locsig to float-vector fm-violin peak: ~A" (float-vector-peak vals))))
    
    (let ((vals (with-sound ((make-float-vector (list 2 4410) 0.0))
			    (fm-violin 0 .1 440 .1 :degree 30))))
      (let ((mxs (maxamp vals)))
	(if (fneq mxs 0.0666)
	    (snd-display #__line__ ";locsig to sound-data fm-violin peak: ~A" mxs))))
        
    (let ((gen (make-sample->file "fmv2.snd" 4 mus-bshort mus-aifc)))
      (print-and-check gen 
		       "sample->file"
		       "sample->file fmv2.snd")
      (if (not (mus-output? gen)) (snd-display #__line__ ";~A not output?" gen))
      (if (not (sample->file? gen)) (snd-display #__line__ ";~A not sample->file?" gen))
      (do ((i 0 (+ i 1)))
	  ((= i 100))
	(sample->file gen i 0 (* i .001))
	(sample->file gen i 1 (* i .01))
	(sample->file gen i 2 (* i .002))
	(sample->file gen i 3 (* i .003)))
      (outa 50 .015 gen)
      (outb 50 .15 gen)
      (outc 50 .02 gen)
      (outd 50 .03 gen)
      (out-any 60 .015 0 gen)
      (out-any 60 .15 1 gen)
      (out-any 60 .02 2 gen)
      (out-any 60 .03 3 gen)
      (mus-close gen))
    (let* ((gen (make-file->sample "fmv2.snd"))
	   (val0 (in-any 20 2 gen))
	   (val1 (in-any 20 3 gen))
	   (val2 (file->sample gen 50 2))
	   (val3 (file->sample gen 50 3))
	   (val4 (file->sample gen 60 2))
	   (val5 (file->sample gen 60 3)))
      (if (not (= (mus-channels gen) 4)) (snd-display #__line__ ";make-file->sample (4) chans: ~A?" (mus-channels gen)))
      (if (not (= (mus-increment gen) 0.0)) (snd-display #__line__ ";file->sample increment: ~A" (mus-increment gen))) ; dir never set in this case
      (if (or (fneq val0 .04) (fneq val1 .06)) (snd-display #__line__ ";in-any(0, 4): ~A ~A?" val0 val1))
      (if (or (fneq val2 .12) (fneq val3 .18)) (snd-display #__line__ ";file->sample(4): ~A ~A?" val2 val3))
      (if (or (fneq val4 .14) (fneq val5 .21)) (snd-display #__line__ ";in-any(4, 4): ~A ~A?" val4 val5)))
    
    (if (file-exists? "fmv.snd") (delete-file "fmv.snd"))
    (mus-sound-forget "fmv.snd")
    (let ((sf (make-sample->file "fmv.snd" 2 mus-bshort mus-next "this is a comment")))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(sample->file sf i 0 (* i .1))
	(sample->file sf i 1 (* i .01)))
      (mus-close sf)
      (if (not (= (mus-sound-chans "fmv.snd") 2)) 
	  (snd-display #__line__ ";sample->file chans: ~A" (mus-sound-chans "fmv.snd")))
      (if (not (= (mus-sound-framples "fmv.snd") 10)) 
	  (snd-display #__line__ ";sample->file framples: ~A" (mus-sound-framples "fmv.snd")))
      (if (not (= (mus-sound-samples "fmv.snd") 20)) 
	  (snd-display #__line__ ";sample->file samples: ~A" (mus-sound-samples "fmv.snd")))
      (if (not (= (mus-sound-header-type "fmv.snd") mus-next)) 
	  (snd-display #__line__ ";sample->file type: ~A" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
      (if (not (= (mus-sound-sample-type "fmv.snd") mus-bshort)) 
	  (snd-display #__line__ ";sample->file format: ~A" (mus-sample-type-name (mus-sound-sample-type "fmv.snd"))))
      (if (not (string=? (mus-sound-comment "fmv.snd") "this is a comment"))
	  (snd-display #__line__ ";sample->file comment: ~A" (mus-sound-comment "fmv.snd")))
      (let ((rd (make-file->sample "fmv.snd"))
	    (happy #t))
	(do ((i 0 (+ i 1)))
	    ((or (not happy) (= i 10)))
	  (let ((c0 (file->sample rd i 0))
		(c1 (file->sample rd i 1)))
	    (if (or (fneq c0 (* i .1))
		    (fneq c1 (* i .01)))
		(begin
		  (snd-display #__line__ ";sample->file->sample at ~A: ~A ~A" i c0 c1)
		  (set! happy #f)))))
	(mus-close rd))
      (set! sf (continue-sample->file "fmv.snd"))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(sample->file sf (+ i 5) 0 (* i -.02))
	(sample->file sf (+ i 5) 1 (* i -.01)))
      (mus-close sf)
      (mus-sound-forget "fmv.snd")
      (if (not (= (mus-sound-chans "fmv.snd") 2)) 
	  (snd-display #__line__ ";continue-sample->file chans: ~A" (mus-sound-chans "fmv.snd")))
      (if (not (= (mus-sound-framples "fmv.snd") 15)) 
	  (snd-display #__line__ ";continue-sample->file framples: ~A" (mus-sound-framples "fmv.snd")))
      (if (not (= (mus-sound-samples "fmv.snd") 30)) 
	  (snd-display #__line__ ";continue-sample->file samples: ~A" (mus-sound-samples "fmv.snd")))
      (if (not (= (mus-sound-header-type "fmv.snd") mus-next)) 
	  (snd-display #__line__ ";continue-sample->file type: ~A" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
      (if (not (= (mus-sound-sample-type "fmv.snd") mus-bshort)) 
	  (snd-display #__line__ ";continue-sample->file format: ~A" (mus-sample-type-name (mus-sound-sample-type "fmv.snd"))))
      (if (not (string=? (mus-sound-comment "fmv.snd") "this is a comment"))
	  (snd-display #__line__ ";continue-sample->file comment: ~A" (mus-sound-comment "fmv.snd")))
      (let ((ind (open-sound "fmv.snd")))
	(let ((c0 (channel->float-vector 0 15 ind 0))
	      (c1 (channel->float-vector 0 15 ind 1)))
	  (if (not (vequal c0 (float-vector 0.0 0.1 0.2 0.3 0.4 0.5 0.58 0.66 0.74 0.82 -0.1 -0.12 -0.14 -0.16 -0.18)))
	      (snd-display #__line__ ";continue-sample->file (0): ~A" c0))
	  (if (not (vequal c1 (float-vector 0.0 0.01 0.02 0.03 0.04 0.05 0.05 0.05 0.05 0.05 -0.05 -0.06 -0.07 -0.08 -0.09)))
	      (snd-display #__line__ ";continue-sample->file (1): ~A" c1)))
	(close-sound ind))
      (delete-file "fmv.snd")
      (mus-sound-forget "fmv.snd"))
    
    (let ((f1 (float-vector 1.0 1.0))
	  (f2 (float-vector 0.0 0.0))
	  (m1 (float-vector .5 .25 .125 1.0)))
      (let ((result (frample->frample m1 f1 2 f2 2)))
	(if (not (equal? result (float-vector 0.625 1.25)))
	  (snd-display #__line__ ";frample->frample: ~A" result))))

    (let ((f1 (float-vector 1.0 2.0 3.0))
	  (f2 (float-vector 0.0 0.0 0.0))
	  (m1 (float-vector 1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0)))
      (let ((result (frample->frample m1 f1 3 f2 3)))
	(if (not (equal? result (float-vector 30.0 36.0 42.0)))
	  (snd-display #__line__ ";frample->frample 1: ~A" result))))

    (let ((sf (make-frample->file "fmv.snd" 2 mus-lfloat mus-riff "this is a comment")))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(frample->file sf i (float-vector (* i .1) (* i .01))))
      (mus-close sf)
      (if (not (= (mus-sound-chans "fmv.snd") 2)) 
	  (snd-display #__line__ ";frample->file chans: ~A" (mus-sound-chans "fmv.snd")))
      (if (not (= (mus-sound-framples "fmv.snd") 10)) 
	  (snd-display #__line__ ";frample->file framples: ~A" (mus-sound-framples "fmv.snd")))
      (if (not (= (mus-sound-samples "fmv.snd") 20)) 
	  (snd-display #__line__ ";frample->file samples: ~A" (mus-sound-samples "fmv.snd")))
      (if (not (= (mus-sound-header-type "fmv.snd") mus-riff)) 
	  (snd-display #__line__ ";frample->file type: ~A" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
      (if (not (= (mus-sound-sample-type "fmv.snd") mus-lfloat)) 
	  (snd-display #__line__ ";frample->file format: ~A" (mus-sample-type-name (mus-sound-sample-type "fmv.snd"))))
      (if (not (string=? (mus-sound-comment "fmv.snd") "this is a comment"))
	  (snd-display #__line__ ";frample->file comment: ~A" (mus-sound-comment "fmv.snd")))
      (let ((rd (make-file->frample "fmv.snd"))
	    (f0 (float-vector 0.0 0.0))
	    (happy #t))
	(do ((i 0 (+ i 1)))
	    ((or (not happy) (= i 10)))
	  (file->frample rd i f0)
	  (if (or (not (= (mus-length f0) 2))
		  (fneq (f0 0) (* i .1))
		  (fneq (f0 1) (* i .01)))
	      (begin
		(snd-display #__line__ ";frample->file->frample at ~A: ~A" i f0)
		(set! happy #f))))
	(mus-close rd))
      (set! sf (continue-frample->file "fmv.snd"))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(frample->file sf (+ i 5) (float-vector (* i -.02) (* i -.01))))
      (mus-close sf)
      (mus-sound-forget "fmv.snd")
      (if (not (= (mus-sound-chans "fmv.snd") 2)) 
	  (snd-display #__line__ ";continue-frample->file chans: ~A" (mus-sound-chans "fmv.snd")))
      (if (not (= (mus-sound-framples "fmv.snd") 15)) 
	  (snd-display #__line__ ";continue-frample->file framples: ~A" (mus-sound-framples "fmv.snd")))
      (if (not (= (mus-sound-samples "fmv.snd") 30)) 
	  (snd-display #__line__ ";continue-frample->file samples: ~A" (mus-sound-samples "fmv.snd")))
      (if (not (= (mus-sound-header-type "fmv.snd") mus-riff)) 
	  (snd-display #__line__ ";continue-frample->file type: ~A" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
      (if (not (= (mus-sound-sample-type "fmv.snd") mus-lfloat)) 
	  (snd-display #__line__ ";continue-frample->file format: ~A" (mus-sample-type-name (mus-sound-sample-type "fmv.snd"))))
      (if (not (string=? (mus-sound-comment "fmv.snd") "this is a comment"))
	  (snd-display #__line__ ";continue-frample->file comment: ~A" (mus-sound-comment "fmv.snd")))
      (let ((ind (open-sound "fmv.snd")))
	(let ((c0 (channel->float-vector 0 15 ind 0))
	      (c1 (channel->float-vector 0 15 ind 1)))
	  (if (not (vequal c0 (float-vector 0.0 0.1 0.2 0.3 0.4 0.5 0.58 0.66 0.74 0.82 -0.1 -0.12 -0.14 -0.16 -0.18)))
	      (snd-display #__line__ ";continue-frample->file (0): ~A" c0))
	  (if (not (vequal c1 (float-vector 0.0 0.01 0.02 0.03 0.04 0.05 0.05 0.05 0.05 0.05 -0.05 -0.06 -0.07 -0.08 -0.09)))
	      (snd-display #__line__ ";continue-frample->file (1): ~A" c1)))
	(close-sound ind))
      (delete-file "fmv.snd")
      (mus-sound-forget "fmv.snd"))
    
    (let ((v0 (make-float-vector 1000))
	  (os (make-oscil 440.0)))
      (do ((i 0 (+ i 1)))
	  ((= i 1000))
	(set! (v0 i) (* .1 (oscil os))))
      (array->file "fmv3.snd" v0 10000 22050 1) ; 10000 deliberate
      (let ((v1 (make-float-vector 1000)))
	(file->array "fmv3.snd" 0 0 1000 v1)
	(do ((i 0 (+ i 1)))
	    ((= i 1000))
	  (if (fneq (v0 i) (v1 i)) 
	      (snd-display #__line__ ";array->file->array: ~A ~A ~A?" i (v0 i) (v1 i)))))
      
      (let ((var (catch #t (lambda () (array->file "fmv3.snd" v0 -1 1000 1)) (lambda args args))))
	(if (not (eq? (car var) 'out-of-range))
	    (snd-display #__line__ ";array->file bad samps: ~A" var)))
      (let ((var (catch #t (lambda () (array->file "/bad/baddy/fmv3.snd" v0 1 1000 1)) (lambda args args))))
	(if (not (eq? (car var) 'mus-error))
	    (snd-display #__line__ ";array->file bad file: ~A" var)))
      (let ((var (catch #t (lambda () (file->array "fmv3.snd" -1 0 -1 v0)) (lambda args args))))
	(if (not (eq? (car var) 'out-of-range))
	    (snd-display #__line__ ";file->array bad samps: ~A" var))))
    
    (let ((gen (make-rand 10000.0))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "rand"
		       "rand freq: 10000.000Hz, phase: 0.000, amp: 1.000")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (rand gen)))
      (if (not (rand? gen)) (snd-display #__line__ ";~A not rand?" gen))
      (if (fneq (mus-phase gen) 3.3624296) (snd-display #__line__ ";rand phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 10000.0) (snd-display #__line__ ";rand frequency: ~F?" (mus-frequency gen)))
      (set! (mus-scaler gen) 0.5)
      (if (fneq (mus-scaler gen) 0.5) (snd-display #__line__ ";set! mus-scaler rand: ~A" (mus-scaler gen)))
      (if (= (v0 1) (v0 8)) (snd-display #__line__ ";rand output: ~A" v0)))
    
    (let ((gen (make-rand 10000.0 :envelope '(0 0 1 1)))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "rand"
		       "rand freq: 10000.000Hz, phase: 0.000, amp: 1.000, with distribution envelope")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (rand gen)))
      (if (not (rand? gen)) (snd-display #__line__ ";(dist) ~A not rand?" gen))
      (if (fneq (mus-frequency gen) 10000.0) (snd-display #__line__ ";(dist) rand frequency: ~F?" (mus-frequency gen)))
      (if (= (v0 1) (v0 8)) (snd-display #__line__ ";(dist) rand output: ~A" v0))
      (if (or (not (float-vector? (mus-data gen)))
	      (not (= (mus-length gen) (length (mus-data gen))))
	      (not (= (mus-length gen) 512)))
	  (snd-display #__line__ ";(dist) rand data: ~A ~A" (mus-length gen) (mus-data gen))))
    
    (let ((gen1 (make-rand 10000.0 :envelope '(0 0 1 1)))
	  (gen2 (make-rand 10000.0 :envelope '(0 1 1 0)))
	  (up1 0)
	  (down1 0)
	  (bad1 0)
	  (up2 0)
	  (down2 0)
	  (bad2 0))
      (do ((i 0 (+ i 1)))
	  ((= i 1000))
	(let ((val1 (rand gen1))
	      (val2 (rand gen2)))
	  (if (>= val1 .5)
	      (set! up1 (+ 1 up1))
	      (if (>= val1 0.0)
		  (set! down1 (+ 1 down1))
		  (set! bad1 (+ 1 bad1))))
	  (if (>= val2 .5)
	      (set! up2 (+ 1 up2))
	      (if (>= val2 0.0)
		  (set! down2 (+ 1 down2))
		  (set! bad2 (+ 1 bad2))))))
      (if (or (not (= bad1 0))
	      (not (= bad2 0))
	      (> (* 2 down1) up1)
	      (> (* 2 up2) down2))
	  (snd-display #__line__ "; rand dist: ~A ~A ~A, ~A ~A ~A" down1 up1 bad1 down2 up2 bad2)))
    
					;      (test-gen-equal (make-rand 1000) (make-rand 1000) (make-rand 500))
					;      (test-gen-equal (make-rand 1000) (make-rand 1000) (make-rand 1000 0.5))
    
    (let ((gen (make-rand-interp 100.0 0.0)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(let ((val (rand-interp gen)))
	(if (not (zero? val))
	    (snd-display #__line__ ";rand-interp 0 amp: ~A" val)))))

    (let ((gen (make-rand-interp 4000.0))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "rand-interp"
		       (mus-describe gen))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (rand-interp gen 0.0)))
      (if (not (rand-interp? gen)) (snd-display #__line__ ";~A not rand-interp?" gen))
      (if (fneq (mus-phase gen) 5.114882) (snd-display #__line__ ";rand-interp phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 4000.0) (snd-display #__line__ ";rand-interp frequency: ~F?" (mus-frequency gen)))
      (set! (mus-scaler gen) 0.5)
      (if (fneq (mus-scaler gen) 0.5) (snd-display #__line__ ";set! mus-scaler rand-interp: ~A" (mus-scaler gen)))
      (if (= (v0 1) (v0 8)) (snd-display #__line__ ";rand-interp output: ~A" v0)))
    
    (let ((gen (make-rand-interp 4000.0 :envelope '(-1 1 0 0 1 1)))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "rand-interp"
		       (mus-describe gen))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (rand-interp gen 0.0)))
      (if (not (rand-interp? gen)) (snd-display #__line__ ";(dist) ~A not rand-interp?" gen))
      (if (= (v0 1) (v0 8)) (snd-display #__line__ ";(dist) rand-interp output: ~A" v0))
      (if (or (not (float-vector? (mus-data gen)))
	      (not (= (mus-length gen) (length (mus-data gen))))
	      (not (= (mus-length gen) 512)))
	  (snd-display #__line__ ";(dist) rand-interp data: ~A ~A" (mus-length gen) (mus-data gen))))
    
    (let ((gen (make-rand 10000.0 1.0))
	  (gen1 (make-rand-interp 10000.0 1.0)))
      (do ((i 0 (+ i 1)))
	  ((= i 1000))
	(let ((val1 (gen 0.0))
	      (val2 (gen1 0.0)))
	  (if (or (> val1 1.0)
		  (< val1 -1.0))
	      (snd-display #__line__ ";rand: ~A ~A" val1 gen))
	  (if (or (> val2 1.0)
		  (< val2 -1.0))
	      (snd-display #__line__ ";rand-interp: ~A ~A" val2 gen1)))))
    
    (let ((gen (make-rand 10000.0 :distribution (inverse-integrate '(0 0 1 1))))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "rand"
		       "rand freq: 10000.000Hz, phase: 0.000, amp: 1.000, with distribution envelope")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (rand gen)))
      (if (not (rand? gen)) (snd-display #__line__ ";(dist 2) ~A not rand?" gen))
      (if (fneq (mus-frequency gen) 10000.0) (snd-display #__line__ ";(dist 2) rand frequency: ~F?" (mus-frequency gen)))
      (if (= (v0 1) (v0 8)) (snd-display #__line__ ";(dist 2) rand output: ~A" v0))
      (if (or (not (float-vector? (mus-data gen)))
	      (not (= (mus-length gen) (length (mus-data gen))))
	      (not (= (mus-length gen) 512)))
	  (snd-display #__line__ ";(dist 2) rand data: ~A ~A" (mus-length gen) (mus-data gen))))
    
    (let ((gen1 (make-rand 10000.0 :distribution (inverse-integrate '(0 0 1 1))))
	  (gen2 (make-rand 10000.0 :distribution (inverse-integrate '(0 1 1 0))))
	  (up1 0)
	  (down1 0)
	  (bad1 0)
	  (up2 0)
	  (down2 0)
	  (bad2 0))
      (do ((i 0 (+ i 1)))
	  ((= i 1000))
	(let ((val1 (rand gen1))
	      (val2 (rand gen2)))
	  (if (>= val1 .5)
	      (set! up1 (+ 1 up1))
	      (if (>= val1 0.0)
		  (set! down1 (+ 1 down1))
		  (set! bad1 (+ 1 bad1))))
	  (if (>= val2 .5)
	      (set! up2 (+ 1 up2))
	      (if (>= val2 0.0)
		  (set! down2 (+ 1 down2))
		  (set! bad2 (+ 1 bad2))))))
      (if (or (not (= bad1 0))
	      (not (= bad2 0))
	      (> (* 2.5 down1) up1)
	      (> (* 2.0 up2) down2))
	  (snd-display #__line__ "; rand dist 2: ~A ~A ~A, ~A ~A ~A" down1 up1 bad1 down2 up2 bad2))) ; 234 766 0, 705 295 0
    
    (let ((ind (new-sound :size 100)))
      (select-sound ind)
      (map-channel (lambda (y) (any-random 1.0 '(0 1 1 1))))
      (let ((place (scan-channel (lambda (y) (not (<= 0.0 y 1.0)))))) ; (or (< y 0.0) (> y 1.0))))))
	(if place (snd-display #__line__ ";any-random 0 to 1: ~A" place)))
      (if (< (maxamp) .5) (snd-display #__line__ ";any-random maxamp: ~A" (maxamp))) ; possible, but extremely unlikely
      (let ((avg 0.0))
	(scan-channel (lambda (y) (set! avg (+ avg y)) #f))
	(if (> (abs (- (/ avg (framples)) .5)) .2) (snd-display #__line__ ";any-random skewed?")))
      (let ((g (gaussian-distribution 1.0))) 
	(map-channel (lambda (y) (any-random 1.0 g))))
      (let ((g (pareto-distribution 1.0))) 
	(map-channel (lambda (y) (any-random 1.0 g))))
      (let ((new-file-name (file-name ind)))
	(close-sound ind)
	(if (file-exists? new-file-name) (delete-file new-file-name))))
    
    (let ((v1 (inverse-integrate '(-1 1 1 1))))
      (if (fneq (v1 4) -0.984)
	  (snd-display #__line__ ";inverse-integrate -1 to 1 uniform: ~A" v1)))
    (let ((v1 (inverse-integrate '(0 1 1 1))))
      (if (fneq (v1 4) .008)
	  (snd-display #__line__ ";inverse-integrate 0 to 1 uniform: ~A" v1)))
    (let ((v1 (inverse-integrate '(0 1 1 0))))
      (if (fneq (v1 4) .004)
	  (snd-display #__line__ ";inverse-integrate 0 to 1 1 to 0: ~A" v1)))
    (let ((v1 (inverse-integrate '(0 0 .5 1 1 0))))
      (if (fneq (v1 4) .073)
	  (snd-display #__line__ ";inverse-integrate triangle: ~A" v1)))
    (let ((v1 (inverse-integrate (gaussian-envelope 1.0))))
      (if (fneq (v1 4) -0.593)
	  (snd-display #__line__ ";inverse-integrate gaussian: ~A" v1)))
    
    (let ((minp 1.0)
	  (maxp -1.0))
      (do ((i 0 (+ i 1)))
	  ((= i 1100))
	(let ((val1 (mus-random 1.0)))
	  (if (< val1 minp) (set! minp val1))
	  (if (> val1 maxp) (set! maxp val1))
	  (if (or (> val1 1.0)
		  (< val1 -1.0))
	      (snd-display #__line__ ";mus-random: ~A" val1))))
      (if (or (< maxp .9)
	      (> minp -.9))
	  (snd-display #__line__ ";mus-random: ~A ~A" minp maxp))
      (set! minp 12.0)
      (set! maxp -12.0)
      (do ((i 0 (+ i 1)))
	  ((= i 1100))
	(let ((val1 (mus-random 12.0)))
	  (if (< val1 minp) (set! minp val1))
	  (if (> val1 maxp) (set! maxp val1))
	  (if (or (> val1 12.0)
		  (< val1 -12.0))
	      (snd-display #__line__ ";mus-random (12): ~A" val1))))
      (if (or (< maxp 11.0)
	      (> minp -11.0))
	  (snd-display #__line__ ";mus-random (12): ~A ~A" minp maxp)))
    
    (let ((v (lambda (n) ; chi^2 or mus-random
	       (let ((hits (make-vector 10 0)))
		 (do ((i 0 (+ 1 i )))
		     ((= i n))
		   (let ((y (floor (+ 5 (mus-random 5.0)))))
		     (set! (hits y) (+ 1 (vector-ref hits y)))))
		 (let ((sum 0.0)
		       (p (/ n 10.0)))
		   (do ((i 0 (+ i 1)))
		       ((= i 10) sum)
		     (let ((num (- (vector-ref hits i) p)))
		       (set! sum (+ sum (/ (* num num) p))))))))))
      
      ;;:(v 10000)
      ;;#(999 1017 1002 1024 1048 971 963 1000 980 996) 5.8
      ;; if less than 3 complain
      
      (let ((vr (v 10000)))
	(if (< vr 3.0)
	    (snd-display #__line__ ";mus-random not so random? ~A (chi)" vr))))
    
    (let ((v1 (lambda (n)
		(let ((hits (make-vector 10 0))
		      (gen (make-rand 22050.0 5)))
		  (do ((i 0 (+ 1 i )))
		      ((= i n))
		    (let ((y (floor (+ 5 (rand gen)))))
		      (set! (hits y) (+ 1 (vector-ref hits y)))))
		  (let ((sum 0.0)
			(p (/ n 10.0)))
		    (do ((i 0 (+ i 1)))
			((= i 10) sum)
		      (let ((num (- (vector-ref hits i) p)))
			(set! sum (+ sum (/ (* num num) p))))))))))
      
      ;;:(v1 10000)
      ;;#(979 1015 977 1008 954 1049 997 1020 1015 986) 6.606
      
      (let ((vr (v1 10000)))
	(if (< vr 3.5)
	    (snd-display #__line__ ";rand not so random? ~A (chi)" vr))))
    
    (let ((data (make-float-vector 65536)))
      (do ((i 0 (+ i 1)))
	  ((= i 65536))
	(set! (data i) (mus-random 1.0)))
      (let* ((ndat (snd-spectrum data rectangular-window 65536 #t 0.0 #f #f))
	     (peak (float-vector-peak ndat))
	     (sum 0.0))
	(if (> peak 1000.0)
	    (snd-display #__line__ ";mus-random spectral peak: ~A" peak))
	(do ((i 0 (+ i 1)))
	    ((= i 32768))
	  (set! sum (+ sum (float-vector-ref ndat i))))
	(if (> (/ sum 32768.0) 200.0)
	    (snd-display #__line__ ";random average: ~A ~A" (/ sum 32768.0) (ndat 0)))
	(do ((i 0 (+ i 1)))
	    ((= i 65536))
	  (set! (data i) (mus-random 1.0)))
	(autocorrelate data)
	(set! (data 0) 0.0)
	(let ((pk (float-vector-peak data)))
	  (if (> pk 1000)
	      (snd-display #__line__ ";random autocorrelate peak: ~A" (float-vector-peak data)))
	  (set! sum 0.0)
	  (float-vector-abs! data)
	  (do ((i 0 (+ i 1)))
	      ((= i 32768))
	    (set! sum (+ sum (float-vector-ref data i))))
	  (if (> (/ sum 32768.0) 200.0)
	      (snd-display #__line__ ";random autocorrelate average: ~A" (/ sum 32768.0))))))
    
    (set! (locsig-type) mus-interp-linear)
    (let* ((gen (make-locsig 30.0 :channels 2))
	   (gen1 (make-locsig 60.0 :channels 2))
	   (gen2 (make-locsig 60.0 :channels 4))
	   (gen200 (make-locsig 200.0 :channels 4))
	   (gen3 gen1))
      (locsig gen 0 1.0)
      (print-and-check gen 
		       "locsig"
		       "locsig chans 2, outn: [0.667 0.333], interp: linear")
      (if (not (locsig? gen)) (snd-display #__line__ ";~A not locsig?" gen))
      (if (not (eq? gen1 gen3)) (snd-display #__line__ ";locsig eq? ~A ~A" gen1 gen3))
      (if (not (equal? gen1 gen3)) (snd-display #__line__ ";locsig equal? ~A ~A" gen1 gen3))
      (if (eq? gen1 gen2) (snd-display #__line__ ";locsig 1 eq? ~A ~A" gen1 gen2))
      (if (equal? gen gen1) (snd-display #__line__ ";locsig 2 equal? ~A ~A" gen gen1))
      (if (equal? gen gen2) (snd-display #__line__ ";locsig 3 equal? ~A ~A" gen gen2))
      (if (or (fneq (locsig-ref gen 0) .667) (fneq (locsig-ref gen 1) .333))
	  (snd-display #__line__ ";locsig ref: ~F ~F?" (locsig-ref gen 0) (locsig-ref gen 1)))
      (if (not (vequal (mus-data gen) (float-vector 0.667 0.333)))
	  (snd-display #__line__ ";locsig gen outn: ~A" (mus-data gen)))
      (if (not (vequal (mus-data gen1) (float-vector 0.333 0.667)))
	  (snd-display #__line__ ";locsig gen2 outn: ~A" (mus-data gen1)))
      (if (not (vequal (mus-data gen2) (float-vector 0.333 0.667 0.000 0.000)))
	  (snd-display #__line__ ";locsig gen2 outn: ~A" (mus-data gen2)))
      (if (not (vequal (mus-data gen200) (float-vector 0.000 0.000 0.778 0.222)))
	  (snd-display #__line__ ";locsig gen200 outn: ~A" (mus-data gen200)))
      (locsig-set! gen 0 .25)
      (if (not (vequal (mus-data gen) (float-vector 0.250 0.333)))
	  (snd-display #__line__ ";locsig gen .25 outn: ~A" (mus-data gen)))
      (locsig gen 0 1.0)
      (locsig-set! gen 0 .5)
      (if (not (vequal (mus-data gen) (float-vector 0.500 0.333)))
	  (snd-display #__line__ ";locsig gen .5 outn: ~A" (mus-data gen)))
      (locsig gen 0 1.0)
      (set! gen (make-locsig 120.0 2.0 .1 :channels 4))
      (if (not (vequal (mus-data gen) (float-vector 0.000 0.333 0.167 0.000)))
	  (snd-display #__line__ ";locsig gen 120 outn: ~A" (mus-data gen)))
      (locsig gen 0 1.0)
      (set! gen (make-locsig 300.0 2.0 .1 :channels 4))
      (if (not (vequal (mus-data gen) (float-vector 0.167 0.000 0.000 0.333)))
	  (snd-display #__line__ ";locsig gen 300 outn: ~A" (mus-data gen)))
      (locsig gen 0 1.0)
      (move-locsig gen1 90.0 1.0)
      (if (not (vequal (mus-data gen1) (float-vector 0.000 1.000)))
	  (snd-display #__line__ ";locsig gen1 90 outn: ~A" (mus-data gen1)))
      (move-locsig gen1 0.0 1.0)
      (if (not (vequal (mus-data gen1) (float-vector 1.000 0.000)))
	  (snd-display #__line__ ";locsig gen1 0 outn: ~A" (mus-data gen1)))
      (move-locsig gen1 45.0 1.0)
      (if (not (vequal (mus-data gen1) (float-vector 0.500 0.500)))
	  (snd-display #__line__ ";locsig gen1 45 outn: ~A" (mus-data gen1)))
      (move-locsig gen1 135.0 2.0)
      (if (not (vequal (mus-data gen1) (float-vector 0.000 0.500)))
	  (snd-display #__line__ ";locsig gen1 135 outn: ~A" (mus-data gen1)))
      (move-locsig gen1 -270.0 3.0)
      (if (not (vequal (mus-data gen1) (float-vector 0.333 0.0)))
	  (snd-display #__line__ ";locsig gen1 -270 outn: ~A" (mus-data gen1))))
    
    (for-each
     (lambda (chans)
      (let* ((loc (make-locsig :channels chans))
	     (last (make-float-vector chans))
	     (data (mus-data loc)))
	;; do a full circle looking for jumps
	(move-locsig loc -400.0 1.0)
	(copy data last)
	(do ((x -400.0 (+ x 10.0)))
	    ((> x 400.0))
	  (move-locsig loc x 1.0)
	  (if (or (< (float-vector-min data) 0.0)
		  (> (float-vector-max data) 1.0))
	      (format #t ";locsig, chans: ~D, degree: ~F, ~A~%" chans x data))
	  (let ((diff (float-vector-peak (float-vector-subtract! last data))))
	    (copy data last)
	    (if (> diff .25)
		(format #t ";locsig, increment ~F with deg ~F~%" diff x))))))
     (list 1 2 4 5 8))
    
    (for-each 
     (lambda (chans)
       (let ((m1 (make-locsig :channels chans)))
	 (if (or (not (= (mus-channels m1) chans))
		 (not (= (mus-length m1) chans)))
	     (snd-display #__line__ ";locsig ~A chans but: ~A ~A" chans (mus-channels m1) (mus-length m1)))
	 (do ((i 0 (+ i 1)))
	     ((= i chans))
	   (locsig-set! m1 i (* i .1)))
	 (do ((i 0 (+ i 1)))
	     ((= i chans))
	   (if (fneq (locsig-ref m1 i) (* i .1))
	       (snd-display #__line__ ";locsig[~A] = ~A (~A)?" i (locsig-ref m1 i) (* i .1))))))
     (list 1 2 4 8))
    
    (let ((var (catch #t (lambda () (make-locsig :channels 0)) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";make-locsig bad (0) chans: ~A" var)))
    (let ((var (catch #t (lambda () (make-locsig :channels -2)) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display #__line__ ";make-locsig bad (-2) chans: ~A" var)))
    (let ((var (catch #t (lambda () (make-locsig :output 1)) (lambda args args))))
      (if (not (eq? (car var) 'wrong-type-arg))
	  (snd-display #__line__ ";make-locsig bad output: ~A" var)))
    (let ((var (catch #t (lambda () (locsig-ref (make-locsig) 1)) (lambda args args))))
      (if (and (pair? var)
	       (not (eq? (car var) 'mus-error)))
	  (snd-display #__line__ ";locsig-ref bad chan: ~A" var)))
    (let ((var (catch #t (lambda () (make-locsig :revout 1)) (lambda args args))))
      (if (and (pair? var)
	       (not (eq? (car var) 'wrong-type-arg)))
	  (snd-display #__line__ ";make-locsig bad revout: ~A" var)))
    (let ((var (catch #t (lambda () (let ((locs (make-locsig 200 :channels 2))) (locsig-ref locs -1))) (lambda args args))))
      (if (and (pair? var)
	       (not (eq? (car var) 'mus-error)))
	  (snd-display #__line__ ";locsig-ref bad chan: ~A" var)))
    (let ((var (catch #t (lambda () (let ((locs (make-locsig))) (locsig-set! locs 2 .1))) (lambda args args))))
      (if (and (pair? var)
	       (not (eq? (car var) 'mus-error)))
	  (snd-display #__line__ ";locsig-set! bad chan (2): ~A" var)))
    (let ((var (catch #t (lambda () (let ((locs (make-locsig :reverb .1))) (locsig-reverb-ref locs 2))) (lambda args args))))
      (if (and (pair? var)
	       (not (eq? (car var) 'mus-error)))
	  (snd-display #__line__ ";locsig-reverb-ref bad reverb chan (2): ~A" var)))
    (let ((var (catch #t (lambda () (let ((locs (make-locsig :reverb .1))) (locsig-reverb-set! locs 2 .1))) (lambda args args))))
      (if (and (pair? var)
	       (not (eq? (car var) 'mus-error)))
	  (snd-display #__line__ ";locsig-reverb-set! bad reverb chan (2): ~A" var)))
    
    (let ((locs (make-locsig :channels 8 :degree 0)))
      (move-locsig locs 180 1.0)
      (if (fneq (locsig-ref locs 0) 0.0) (snd-display #__line__ ";move-locsig by jump: ~A" (mus-data locs)))
      (if (not (vequal (mus-data locs) (float-vector 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";move-locsig by jump data: ~A" (mus-data locs)))
      (move-locsig locs 120.0 1.0)
      (if (not (vequal (mus-data locs) (float-vector 0.000 0.000 0.333 0.667 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";move-locsig by jump 120 data: ~A" (mus-data locs)))
      (move-locsig locs -20.0 1.0)
      (if (not (vequal (mus-data locs) (float-vector 0.556 0.000 0.000 0.000 0.000 0.000 0.000 0.444)))
	  (snd-display #__line__ ";move-locsig by jump -20 data: ~A" (mus-data locs))))
    
    (let ((sf (make-sample->file "fmv4.snd" 8 mus-bshort mus-next "this is a comment"))
	  (sfrev (make-sample->file "fmv4.reverb" 8 mus-bshort mus-next "this is a comment")))
      (let ((locs (make-locsig :channels 8 :degree 0 :distance 1.0 :reverb 0.1 
			       :output sf :revout sfrev :type mus-interp-linear)))
	(if (not (vequal (mus-data locs) (float-vector 1.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";ws not move-locsig by jump data: ~A" (mus-data locs)))
	(if (not (vequal (mus-xcoeffs locs) (float-vector 0.100 0.000 0.000 0.000 0.0 0.0 0.0 0.0)))
	    (snd-display #__line__ ";ws not move-locsig by jump rev data: ~A" (mus-xcoeffs locs)))
	(move-locsig locs 180 2.0)
	(if (fneq (locsig-ref locs 0) 0.0) (snd-display #__line__ ";ws move-locsig by jump: ~A" (mus-data locs)))
	(if (not (vequal (mus-data locs) (float-vector 0.000 0.000 0.000 0.000 0.500 0.000 0.000 0.000)))
	    (snd-display #__line__ ";ws move-locsig by jump data: ~A" (mus-data locs)))
	(if (not (vequal (mus-xcoeffs locs) (float-vector 0.000 0.000 0.000 0.000 0.071 0.000 0.000 0.000)))
	    (snd-display #__line__ ";ws move-locsig by jump rev data: ~A" (mus-xcoeffs locs)))
	(move-locsig locs 120.0 3.0)
	(if (not (vequal (mus-data locs) (float-vector 0.000 0.000 0.111 0.222 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";ws move-locsig by jump 120 data: ~A" (mus-data locs)))
	(if (not (vequal (mus-xcoeffs locs) (float-vector 0.000 0.000 0.019 0.038 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";ws move-locsig by jump 120 rev data: ~A" (mus-xcoeffs locs)))
	(move-locsig locs -20.0 4.0)
	(if (not (vequal (mus-data locs) (float-vector 0.139 0.000 0.000 0.000 0.000 0.000 0.000 0.111)))
	    (snd-display #__line__ ";ws move-locsig by jump -20 data: ~A" (mus-data locs)))
	(if (not (vequal (mus-xcoeffs locs) (float-vector 0.028 0.000 0.000 0.000 0.000 0.000 0.000 0.022)))
	    (snd-display #__line__ ";ws move-locsig by jump -20 rev data: ~A" (mus-xcoeffs locs))))
      (mus-close sf)
      (mus-close sfrev))
    
    (if (file-exists? "fmv4.snd") (delete-file "fmv4.snd"))
    (if (file-exists? "fmv4.reverb") (delete-file "fmv4.reverb"))
    (mus-sound-prune)
    
    (for-each
     (lambda (ht)
       (let ((ind (find-sound (with-sound (:channels 8)
					  (do ((i 0 (+ i 1)))
					      ((= i 8))
					    (locsig (make-locsig :degree (* i 45) :output *output*) i 0.5))))))
	 (do ((i 0 (+ i 1)))
	     ((= i 8))
	   (let ((samps (channel->float-vector 0 8 ind i)))
	     (do ((k 0 (+ k 1)))
		 ((= k 8))
	       (if (and (= k i) (fneq (samps k) 0.5))
		   (snd-display #__line__ ";8 out ~A chan ~A samp ~A (0.5): ~A" (mus-header-type->string ht) i k (samps k)))
	       (if (and (not (= i k)) (fneq (samps k) 0.0))
		   (snd-display #__line__ ";8 out ~A chan ~A samp ~A (0.0): ~A" (mus-header-type->string ht) i k (samps k))))))
	 (close-sound ind)))
     (list mus-caff mus-aifc mus-next mus-riff mus-rf64))
    
    (let* ((gen (make-frample->file "fmv4.snd" 2 mus-bshort mus-next))
	   (rev (make-frample->file "fmv4.reverb" 1 mus-bshort mus-next))
	   (lc (make-locsig 60.0 :reverb .1 :channels 2 :output gen :revout rev)))
      (do ((i 0 (+ i 1)))
	  ((= i 100))
	(locsig lc i 1.0))
      (if (fneq (locsig-reverb-ref lc 0) .1) (snd-display #__line__ ";locsig reverb ref: ~A?" (locsig-reverb-ref lc 0)))
      (locsig-reverb-set! lc 0 .2)
      (if (fneq (locsig-reverb-ref lc 0) .2) (snd-display #__line__ ";locsig reverb set: ~A?" (locsig-reverb-ref lc 0)))
      (mus-close gen)
      (mus-close rev)
      (let ((v0 (make-float-vector 100))
	    (v1 (make-float-vector 100))
	    (v2 (make-float-vector 100)))
	(file->array "fmv4.snd" 0 0 100 v0)
	(file->array "fmv4.snd" 1 0 100 v1)
	(file->array "fmv4.reverb" 0 0 100 v2)
	(if (fneq (v2 0) .1) (snd-display #__line__ ";locsig reverb: ~A?" v2))
	(if (fneq (* 2 (v0 0)) (v1 0)) (snd-display #__line__ ";locsig direct: ~A ~A?" (v0 0) (v1 0)))))
    
    (let* ((gen (make-frample->file "fmv4.snd" 4 mus-bshort mus-next))
	   (rev (make-frample->file "fmv4.reverb" 4 mus-bshort mus-next))
	   (lc (make-locsig 60.0 :reverb .1 :channels 4 :distance 4.0 :output gen :revout rev)))
      (print-and-check lc
		       "locsig"
		       "locsig chans 4, outn: [0.083 0.167 0.000 0.000], revn: [0.017 0.033 0.000 0.000], interp: linear")
      (do ((i 0 (+ i 1)))
	  ((= i 100))
	(locsig lc i 1.0))
      (do ((i 0 (+ i 1)))
	  ((= i 4))
	(locsig-reverb-set! lc i (* i .1))
	(if (fneq (locsig-reverb-ref lc i) (* i .1))
	    (snd-display #__line__ ";locsig reverb set![~A]: ~A?" i (locsig-reverb-ref lc i))))
      (print-and-check lc
		       "locsig"
		       "locsig chans 4, outn: [0.083 0.167 0.000 0.000], revn: [0.000 0.100 0.200 0.300], interp: linear")
      (if (not (float-vector? (mus-data lc))) (snd-display #__line__ ";out data locsig: ~A" (mus-data lc)))
      (if (not (float-vector? (mus-xcoeffs lc))) (snd-display #__line__ ";rev data locsig: ~A" (mus-xcoeffs lc)))
      (let ((xcs (mus-xcoeffs lc)))
	(if (fneq (mus-xcoeff lc 0) (xcs 0)) (snd-display #__line__ ";locsig xcoeff: ~A ~A" (mus-xcoeff lc 0) (xcs 0)))
	(if (fneq (mus-xcoeff lc 1) .1) (snd-display #__line__ ";locsig xcoeff 1: ~A ~A (.1)" (mus-xcoeff lc 0) (xcs 0))))
      (mus-close gen)
      (mus-close rev))
    
    (print-and-check (make-locsig 160 :channels 4)
		     "locsig"
		     "locsig chans 4, outn: [0.000 0.222 0.778 0.000], interp: linear")
    (print-and-check (make-locsig -200 :channels 4)
		     "locsig"
		     "locsig chans 4, outn: [0.000 0.222 0.778 0.000], interp: linear")
    (print-and-check (make-locsig 160 :channels 4 :distance .5)
		     "locsig"
		     "locsig chans 4, outn: [0.000 0.222 0.778 0.000], interp: linear")
    (print-and-check (make-locsig 320 :channels 4)
		     "locsig"
		     "locsig chans 4, outn: [0.556 0.000 0.000 0.444], interp: linear")
    (print-and-check (make-locsig -40 :channels 4)
		     "locsig"
		     "locsig chans 4, outn: [0.556 0.000 0.000 0.444], interp: linear")
    (print-and-check (make-locsig 320 :channels 2)
		     "locsig"
		     "locsig chans 2, outn: [0.000 1.000], interp: linear")
    (print-and-check (make-locsig -40 :channels 2)
		     "locsig"
		     "locsig chans 2, outn: [1.000 0.000], interp: linear")
    (print-and-check (make-locsig 160 :channels 4 :output (make-float-vector (list 4 10) 0.0))
		     "locsig"
		     "locsig chans 4, outn: [0.000 0.222 0.778 0.000], interp: linear")
    (print-and-check (make-locsig 0 :channels 1 :output (make-float-vector 10))
		     "locsig"
		     "locsig chans 1, outn: [1.000], interp: linear")
    (letrec ((locsig-data
	      (lambda (gen)
		(let* ((chans (mus-channels gen))
		       (dat (make-float-vector chans)))
		  (do ((i 0 (+ i 1)))
		      ((= i chans))
		    (set! (dat i) (locsig-ref gen i)))
		  dat))))
      (let ((gen (make-locsig -.1 :channels 8)))
	(if (not (vequal (locsig-data gen) (float-vector 0.998 0.000 0.000 0.000 0.000 0.000 0.000 0.002)))
	    (snd-display #__line__ ";locsig -.1(8): ~A" (locsig-data gen)))
	(set! gen (make-locsig -359.9 :channels 8))
	(if (not (vequal (locsig-data gen) (float-vector 0.998 0.002 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";locsig -359.9(8): ~A" (locsig-data gen)))
	(set! gen (make-locsig -359.9 :channels 4))
	(if (not (vequal (locsig-data gen) (float-vector 0.999 0.001 0.000 0.000)))
	    (snd-display #__line__ ";locsig -359.9(4): ~A" (locsig-data gen)))
	(set! gen (make-locsig -360.1 :channels 8))
	(if (not (vequal (locsig-data gen) (float-vector 0.998 0.000 0.000 0.000 0.000 0.000 0.000 0.002)))
	    (snd-display #__line__ ";locsig -360.1(8): ~A" (locsig-data gen)))
	(set! gen (make-locsig -700 :channels 8))
	(if (not (vequal (locsig-data gen) (float-vector 0.556 0.444 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";locsig -700(8): ~A" (locsig-data gen)))
	(set! gen (make-locsig -700 :channels 2))
	(if (not (vequal (locsig-data gen) (float-vector 1.000 0.000)))
	    (snd-display #__line__ ";locsig -700(2): ~A" (locsig-data gen)))
	(set! gen (make-locsig 20 :channels 2))
	(if (not (vequal (locsig-data gen) (float-vector 0.778 0.222)))
	    (snd-display #__line__ ";locsig 20(2): ~A" (locsig-data gen)))
	(set! gen (make-locsig 123456.0 :channels 8))
	(if (not (vequal (locsig-data gen) (float-vector 0.467 0.000 0.000 0.000 0.000 0.000 0.000 0.533)))
	    (snd-display #__line__ ";locsig 123456(8): ~A" (locsig-data gen)))
	(set! gen (make-locsig 336.0 :channels 8))
	(if (not (vequal (locsig-data gen) (float-vector 0.467 0.000 0.000 0.000 0.000 0.000 0.000 0.533)))
	    (snd-display #__line__ ";locsig 336(8): ~A" (locsig-data gen)))
	(set! gen (make-locsig -123456.0 :channels 8))
	(if (not (vequal (locsig-data gen) (float-vector 0.467 0.533 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";locsig -123456(8): ~A" (locsig-data gen)))
	(set! gen (make-locsig 24.0 :channels 8))
	(if (not (vequal (locsig-data gen) (float-vector 0.467 0.533 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";locsig 24(8): ~A" (locsig-data gen)))))
    
    (for-each 
     (lambda (rev-chans)
       
       (define (locsig-scalers chans degree type)
	 (define (xmodulo a b)
	   (let ((pos (floor (/ a b))))
	     (- a (* pos b))))
	 (if (= chans 1)
	     (float-vector 1.0)
	     (let* ((deg (if (= chans 2)
			     (max 0.0 (min 90.0 degree))
			     (xmodulo degree 360.0)))
		    (degs-per-chan (if (= chans 2)
				       90.0
				       (/ 360.0 chans)))
		    (pos (/ deg degs-per-chan))
		    (left (floor pos))
		    (right (xmodulo (+ left 1) chans))
		    (frac (- pos left))
		    (v (make-float-vector chans)))
	       (if (= type mus-interp-linear)
		   (begin
		     (set! (v left) (- 1.0 frac))
		     (set! (v right) frac))
		   (let* ((ldeg (* (/ pi 2) (- 0.5 frac)))
			  (norm (/ (sqrt 2.0) 2.0))
			  (c (cos ldeg))
			  (s (sin ldeg)))
		     (set! (v left) (* norm (+ c s)))
		     (set! (v right) (* norm (- c s)))))
	       v)))
       
       (if (file-exists? "test.reverb") (delete-file "test.reverb"))
       (let ((revfile (and (> rev-chans 0)
			   (make-frample->file "test.reverb" rev-chans mus-bshort mus-next)))
	     (happy #t))
	 (for-each
	  (lambda (type)
	    ;; global type def as well as local par override etc
	    
	    (if happy
		(begin
		  (set! (locsig-type) type)
		  (if (not (= (locsig-type) type)) (snd-display #__line__ ";locsig-type: ~A ~A" type (locsig-type)))
		  
		  (for-each 
		   (lambda (deg)
		     (let ((gen (make-locsig deg :channels 1 :revout revfile :reverb .1 :distance 2.0))
			   (revs (if revfile (locsig-scalers rev-chans deg type))))
		       (if (not (= (mus-channels gen) 1)) (snd-display #__line__ ";locsig ~A: ~A" deg gen))
		       (if (fneq (locsig-ref gen 0) 0.5) (snd-display #__line__ ";locsig scaler[~A] ~A: ~A" type deg (locsig-ref gen 0)))
		       (if revfile
			   (do ((i 0 (+ i 1)))
			       ((or (not happy) (= i rev-chans)))
			     (if (fneq (locsig-reverb-ref gen i) (* (/ .1 (sqrt 2.0)) (revs i)))
				 (begin 
				   (snd-display #__line__ ";mono locrev[~A] ~A at ~A: ~A ~A" 
						type gen deg 
						(locsig-reverb-ref gen i) 
						(* (/ .1 (sqrt 2.0)) (revs i)))
				   (set! happy #f)))))))
		   (list 0.0 45.0 90.0 1234.0))
		  
		  (for-each
		   (lambda (ltype)
		     (for-each 
		      (lambda (deg)
			(let ((gen (make-locsig deg :channels 1 :type ltype)))
			  (if (not (= (mus-channels gen) 1)) (snd-display #__line__ ";locsig ~A: ~A" deg gen))
			  (if (fneq (locsig-ref gen 0) 1.0) (snd-display #__line__ ";locsig[~A] scaler ~A: ~A" ltype deg (locsig-ref gen 0)))))
		      (list 0.0 45.0 90.0 1234.0)))
		   (list mus-interp-linear mus-interp-sinusoidal))
		  
		  (for-each
		   (lambda (chans)
		     (for-each 
		      (lambda (deg)
			(let ((gen (make-locsig deg :channels chans :revout revfile :reverb .1)))
			  (if (not (= (mus-channels gen) chans)) (snd-display #__line__ ";multi locsig ~A: ~A" deg gen))
			  (let ((scalers (locsig-scalers chans deg type))
				(revs (if revfile (locsig-scalers rev-chans deg type))))
			    (do ((i 0 (+ i 1)))
				((or (not happy) (= i chans)))
			      (if (fneq (locsig-ref gen i) (scalers i)) 
				  (begin 
				    (snd-display #__line__ ";locsig[~A] ~A at ~A: ~A ~A" type gen deg (locsig-ref gen i) (scalers i)) 
				    (set! happy #f))))
			    (if revfile
				(do ((i 0 (+ i 1)))
				    ((or (not happy) (= i rev-chans)))
				  (if (fneq (locsig-reverb-ref gen i) (* .1 (revs i)))
				      (begin 
					(snd-display #__line__ ";locrev[~A] ~A at ~A: ~A ~A" 
						     type gen deg 
						     (locsig-reverb-ref gen i) 
						     (* .1 (revs i)))
					(set! happy #f))))))))
		      (list 0.0 45.0 90.0 120.0 180.0 275.0 315.0 300.0 15.0 1234.0)))
		   (list 2 3 4 5 8 12 16 24))
		  
		  (for-each
		   (lambda (chans)
		     (for-each 
		      (lambda (ltype)
			(for-each
			 (lambda (deg)
			   (let ((gen (make-locsig deg :channels chans :type ltype :revout revfile :reverb .1)))
			     (if (not (= (mus-channels gen) chans)) (snd-display #__line__ ";stereo locsig ~A: ~A" deg gen))
			     (let ((scalers (locsig-scalers chans deg ltype))
				   (revs (if revfile (locsig-scalers rev-chans deg ltype))))
			       (do ((i 0 (+ i 1)))
				   ((or (not happy) (= i chans)))
				 (if (fneq (locsig-ref gen i) (scalers i)) 
				     (begin
				       (snd-display #__line__ ";locsig[~A] ~A at ~A: ~A ~A" ltype gen deg (locsig-ref gen i) (scalers i))
				       (set! happy #f))))
			       (if revfile
				   (do ((i 0 (+ i 1)))
				       ((or (not happy) (= i rev-chans)))
				     (if (fneq (locsig-reverb-ref gen i) (* .1 (revs i)))
					 (begin 
					   (snd-display #__line__ ";locrev[~A] ~A at ~A: ~A ~A" 
							type gen deg 
							(locsig-reverb-ref gen i) 
							(* .1 (revs i)))
					   (set! happy #f))))))))
			 (list 0.0 45.0 90.0 120.0 180.0 275.0 315.0 300.0 15.0 1234.0)))
		      (list mus-interp-linear mus-interp-sinusoidal)))
		   (list 2 3 4 5 8 12 16 24))
		  )))
	  (list mus-interp-linear mus-interp-sinusoidal))
	 (if revfile (mus-close revfile))))
     (list 0 1 2 4))
    
    (set! (locsig-type) mus-interp-linear)
    (let* ((outp (make-float-vector (list 1 10) 0.0))
	   (gen (make-locsig 0.0 :output outp)))
      (if (not (= (mus-channels gen) 1)) (snd-display #__line__ ";make-locsig->sd chans (1): ~A" (mus-channels gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(locsig gen i 1.0))
      (if (not (vequal (outp 0) (make-float-vector 10 1.0)))
	  (snd-display #__line__ ";locsig->sd chan 0: ~A" (outp 0))))
    
    (let* ((outp (make-float-vector (list 2 10) 0.0))
	   (gen (make-locsig 0.0 :output outp)))
      (if (not (= (mus-channels gen) 2)) (snd-display #__line__ ";make-locsig->sd chans: ~A" (mus-channels gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(locsig gen i 1.0))
      (if (not (vequal (outp 0) (make-float-vector 10 1.0)))
	  (snd-display #__line__ ";locsig->sd chan 0: ~A" (outp 0)))
      (if (not (vequal (outp 1) (make-float-vector 10 0.0)))
	  (snd-display #__line__ ";locsig->sd chan 1: ~A" (outp 1))))
    
    (let* ((outp (make-float-vector (list 2 10) 0.0))
	   (gen (make-locsig 45.0 :output outp)))
      (if (not (= (mus-channels gen) 2)) (snd-display #__line__ ";make-locsig->sd chans: ~A" (mus-channels gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(locsig gen i 1.0))
      (if (not (vequal (outp 0) (make-float-vector 10 0.5)))
	  (snd-display #__line__ ";locsig->sd chan 0 (0.5): ~A (~A)" (outp 0) gen))
      (if (not (vequal (outp 1) (make-float-vector 10 0.5)))
	  (snd-display #__line__ ";locsig->sd chan 1 (0.5): ~A" (outp 1)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(locsig gen i 0.5))
      (if (not (vequal (outp 0) (make-float-vector 10 0.75)))
	  (snd-display #__line__ ";locsig->sd chan 0 (0.75) (~A): ~A" (outp 0) gen))
      (if (not (vequal (outp 1) (make-float-vector 10 0.75)))
	  (snd-display #__line__ ";locsig->sd chan 1 (0.75): ~A" (outp 1))))
    
    (let* ((outp (make-float-vector 10))
	   (gen (make-locsig 0.0 :output outp)))
      (if (not (= (mus-channels gen) 1)) (snd-display #__line__ ";make-locsig->float-vector chans: ~A" (mus-channels gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(locsig gen i 1.0))
      (if (not (vequal outp (make-float-vector 10 1.0)))
	  (snd-display #__line__ ";locsig->float-vector chan 0: ~A" outp))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(locsig gen i 0.5))
      (if (not (vequal outp (make-float-vector 10 1.5)))
	  (snd-display #__line__ ";locsig->float-vector chan 0: ~A" outp)))
    
    (let* ((outp (make-float-vector 10))
	   (gen (make-locsig 45.0 :channels 2 :output outp)))
      (if (not (= (mus-channels gen) 2)) (snd-display #__line__ ";make-locsig->float-vector chans (2): ~A" (mus-channels gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(locsig gen i 1.0))
      (if (not (vequal outp (make-float-vector 10 0.5)))
	  (snd-display #__line__ ";locsig(2)->float-vector chan 0: ~A" outp))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(locsig gen i 0.5))
      (if (not (vequal outp (make-float-vector 10 0.75)))
	  (snd-display #__line__ ";locsig(2)->float-vector chan 0: ~A" outp)))
    
    (let* ((outp (make-float-vector (list 4 10) 0.0))
	   (gen (make-locsig 135.0 :output outp)))
      (if (not (= (mus-channels gen) 4)) (snd-display #__line__ ";make-locsig->sd chans (4): ~A" (mus-channels gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(locsig gen i 1.0))
      (if (not (vequal (outp 0) (make-float-vector 10 0.0)))
	  (snd-display #__line__ ";locsig(4)->sd chan 0 (0.5): ~A" (outp 0)))
      (if (not (vequal (outp 1) (make-float-vector 10 0.5)))
	  (snd-display #__line__ ";locsig(4)->sd chan 1 (0.5) (~A): ~A" (outp 1) gen))
      (if (not (vequal (outp 2) (make-float-vector 10 0.5)))
	  (snd-display #__line__ ";locsig(4)->sd chan 2 (0.5): ~A" (outp 2)))
      (if (not (vequal (outp 3) (make-float-vector 10 0.0)))
	  (snd-display #__line__ ";locsig(4)->sd chan 3 (0.5): ~A" (outp 3))))

    (set! *mus-array-print-length* 8)
    (let* ((outf1 (make-frample->file "fmv.snd" 1 mus-ldouble mus-next))
	   (outf4 (make-frample->file "fmv1.snd" 4 mus-ldouble mus-next))
	   (revf (make-frample->file "fmv2.snd" 1 mus-ldouble mus-next))
	   (start 0)
	   (end 1000)
	   (dur 1.0)
	   (gen1 (make-move-sound (list 0 1000 1 0
					(make-delay 32) 
					(make-env '(0 0 1 1) :length 1001) 
					(make-env '(0 0 1 1) :length 1001)
					(vector (make-delay 32)) 
					(vector (make-env '(0 0 1 1) :length 1001)) 
					#f
					(vector 0 1))
				  outf1))
	   (gen2 (make-move-sound (list start end 4 0
					(make-delay 12) 
					(make-env '(0 0 10 1) :duration dur)
					#f
					(make-vector 4 #f)
					(vector (make-env '(0 0 1 1 2 0 3 0 4 0) :duration dur)
						(make-env '(0 0 1 0 2 1 3 0 4 0) :duration dur)
						(make-env '(0 0 1 0 2 0 3 1 4 0) :duration dur)
						(make-env '(0 0 1 0 2 0 3 0 4 1) :duration dur))
					#f
					(vector 0 1 2 3))
				  outf4))
	   (gen3 (make-move-sound (list 0 1000 1 1
					(make-delay 32) 
					(make-env '(0 0 1 1) :length 1001) 
					(make-env '(0 0 1 1) :length 1001)
					(vector (make-delay 32)) 
					(vector (make-env '(0 0 1 1) :length 1001)) 
					(vector (make-env '(0 1 1 1) :length 1001))
					(vector 0 1))
				  outf1 revf)))
      
      (print-and-check gen1
		       "move-sound"
		       "move-sound start: 0, end: 1000, out chans 1, rev chans: 0
  doppler delay line[32, step]: [0 0 0 0 0 0 0 0...(0: 0, 0: 0)]
  doppler env linear, pass: 0 (dur: 1001), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 0 1 1]
  global reverb env linear, pass: 0 (dur: 1001), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 0 1 1]
  out_delays[1]:
    [0]: delay line[32, step]: [0 0 0 0 0 0 0 0...(0: 0, 0: 0)]
  out_envs[1]:
    [0]: env linear, pass: 0 (dur: 1001), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 0 1 1]
  rev_envs: nil
  out_map[1]: (0)
  free: arrays: true, gens: false
")
      
      (print-and-check gen2
		       "move-sound"
		       "move-sound start: 0, end: 1000, out chans 4, rev chans: 0
  doppler delay line[12, step]: [0 0 0 0 0 0 0 0...(0: 0, 0: 0)]
  doppler env linear, pass: 0 (dur: 22050), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 0 10 1]
  global reverb null
  out_delays[4]:
    [0]: nil
    [1]: nil
    [2]: nil
    [3]: nil
  out_envs[4]:
    [0]: env linear, pass: 0 (dur: 22050), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 0 1 1 2 0 3 0...(0: 0, 8: 4)]
    [1]: env linear, pass: 0 (dur: 22050), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 0 1 0 2 1 3 0...(0: 0, 8: 4)]
    [2]: env linear, pass: 0 (dur: 22050), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 0 1 0 2 0 3 1...(0: 0, 8: 4)]
    [3]: env linear, pass: 0 (dur: 22050), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 0 1 0 2 0 3 0...(0: 0, 8: 4)]
  rev_envs: nil
  out_map[4]: (0 1 2 3)
  free: arrays: true, gens: false
")
      
      (print-and-check gen3
		       "move-sound"
		       "move-sound start: 0, end: 1000, out chans 1, rev chans: 1
  doppler delay line[32, step]: [0 0 0 0 0 0 0 0...(0: 0, 0: 0)]
  doppler env linear, pass: 0 (dur: 1001), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 0 1 1]
  global reverb env linear, pass: 0 (dur: 1001), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 0 1 1]
  out_delays[1]:
    [0]: delay line[32, step]: [0 0 0 0 0 0 0 0...(0: 0, 0: 0)]
  out_envs[1]:
    [0]: env linear, pass: 0 (dur: 1001), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 0 1 1]
  rev_envs[1]:
    [0]: env linear, pass: 0 (dur: 1001), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 1 1 1]
  out_map[1]: (0)
  free: arrays: true, gens: false
")
      
      (if (not (move-sound? gen1)) (snd-display #__line__ ";move-sound?"))
      (if (equal? gen1 gen2) (snd-display #__line__ ";move-sounds are equal?"))
      (if (not (= (mus-channels gen1) 1)) (snd-display #__line__ ";mus-channels move-sound (1): ~A" (mus-channels gen1)))
      (if (not (= (mus-channels gen2) 4)) (snd-display #__line__ ";mus-channels move-sound (4): ~A" (mus-channels gen2)))
      (mus-reset gen1) ; a no-op
      
      (let ((v (make-float-vector 10 0.0)))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (set! (v i) (+ (move-sound gen1 i 0.5)
			   (gen2 i 0.25)
			   (move-sound gen3 i 0.125))))
	(if (not (vequal v (make-float-vector 10 0.875)))
	    (snd-display #__line__ ";move-sound output: ~A" v)))
      
      (let ((var (catch #t (lambda () (make-move-sound (list 0 1000 1 0 (make-oscil 32) (make-env '(0 0 1 1) :length 1001) 
							     (make-env '(0 0 1 1) :length 1001) (vector (make-delay 32)) 
							     (vector (make-env '(0 0 1 1) :length 1001)) #f (vector 0 1))
						       outf1))
			(lambda args args))))
	(if (not (eq? (car var) 'wrong-type-arg))
	    (snd-display #__line__ ";make-move-sound bad doppler delay: ~A" var)))
      (let ((var (catch #t (lambda () (make-move-sound (list 0 1000 1 0 (make-oscil 32) (make-env '(0 0 1 1) :length 1001) 
							     (make-env '(0 0 1 1) :length 1001) (vector (make-delay 32)))
						       outf1))
			(lambda args args))))
	(if (not (eq? (car var) 'wrong-type-arg))
	    (snd-display #__line__ ";make-move-sound truncated list: ~A" var)))
      (let ((var (catch #t (lambda () (make-move-sound (list 0 1000 1 0 (make-delay 32) (make-env '(0 0 1 1) :length 1001) 
							     #f (vector #f)
							     (vector (make-env '(0 0 1 1) :length 1001)) #f #f)
						       outf1))
			(lambda args args))))
	(if (not (eq? (car var) 'wrong-type-arg))
	    (snd-display #__line__ ";make-move-sound no out map: ~A" var)))
      
      
      (mus-close outf1) 
      (mus-close outf4) 
      (mus-close revf)
      
      (if (file-exists? "fmv.snd") (delete-file "fmv.snd"))
      (if (file-exists? "fmv1.snd") (delete-file "fmv1.snd"))
      (if (file-exists? "fmv2.snd") (delete-file "fmv2.snd"))
      (mus-sound-prune))
    
    (let* ((vo (make-float-vector 1000))
	   (gen1 (make-move-sound (list 0 1000 1 0
					(make-delay 32) 
					(make-env '(0 0 1 1) :length 1001) 
					(make-env '(0 0 1 1) :length 1001)
					(vector (make-delay 32)) 
					(vector (make-env '(0 0 1 1) :length 1001)) 
					#f
					(vector 0 1))
				  vo))
	   (start -1))
      (do ((i 0 (+ i 1)))
	  ((= i 1000))
	(move-sound gen1 i 0.5)
	(if (and (< start 0)
		 (fneq (vo i) 0.0))
	    (set! start i)))
      (if (not (= start 64))
	  (snd-display #__line__ ";move-sound float-vector output start: ~A" start))
      (if (fneq (float-vector-peak vo) 0.484)
	  (snd-display #__line__ ";move-sound float-vector output: ~A" (float-vector-peak vo))))
    
    (let* ((vo (make-float-vector (list 1 1000) 0.0))
	   (gen1 (make-move-sound (list 0 1000 1 0
					(make-delay 32) 
					(make-env '(0 0 1 1) :length 1001) 
					(make-env '(0 0 1 1) :length 1001)
					(vector (make-delay 32)) 
					(vector (make-env '(0 0 1 1) :length 1001)) 
					#f
					(vector 0 1))
				  vo))
	   (start -1))
      (do ((i 0 (+ i 1)))
	  ((= i 1000))
	(move-sound gen1 i 0.5)
	(if (and (< start 0)
		 (fneq (vo 0 i) 0.0))
	    (set! start i)))
      (if (not (= start 64))
	  (snd-display #__line__ ";move-sound sd output start: ~A" start))
      (if (fneq (maxamp vo) 0.484)
	  (snd-display #__line__ ";move-sound sd output: ~A" (maxamp vo))))
    
    (let* ((vo (make-float-vector 1000))
	   (gen1 (make-move-sound (list 0 1000 1 0
					(make-delay 32) 
					(make-env '(0 0 1 1) :length 1001) 
					(make-env '(0 0 1 1) :length 1001)
					(vector (make-delay 32)) 
					(vector (make-env '(0 0 1 1) :length 1001)) 
					#f
					(vector 0 1))
				  vo))
	   (start -1))
       (do ((i 0 (+ i 1)))
	   ((= i 1000))
	 (move-sound gen1 i 0.5)
	 (if (and (< start 0)
		  (> (abs (vo i)) 0.001))
	     (set! start i)))
      (if (not (= start 64))
	  (snd-display #__line__ ";move-sound opt float-vector output start: ~A" start))
      (if (fneq (float-vector-peak vo) 0.484)
	  (snd-display #__line__ ";move-sound opt float-vector output: ~A" (float-vector-peak vo))))
    
    (let* ((vo (make-float-vector (list 1 1000) 0.0))
	   (gen1 (make-move-sound (list 0 1000 1 0
					(make-delay 32) 
					(make-env '(0 0 1 1) :length 1001) 
					(make-env '(0 0 1 1) :length 1001)
					(vector (make-delay 32)) 
					(vector (make-env '(0 0 1 1) :length 1001)) 
					#f
					(vector 0 1))
				  vo))
	   (start -1))
       (do ((i 0 (+ i 1)))
	   ((= i 1000))
	 (move-sound gen1 i 0.5)
	 (if (and (< start 0)
		  (> (abs (vo 0 i)) 0.001))
	     (set! start i)))
      (if (not (= start 64))
	  (snd-display #__line__ ";move-sound opt sd output start: ~A" start))
      (if (fneq (maxamp vo) 0.484)
	  (snd-display #__line__ ";move-sound opt sd output: ~A" (maxamp vo))))
    
    (let ((var (catch #t (lambda () (make-src :width -1)) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display #__line__ ";make-src bad width: ~A" var)))
    
    (let ((s1 (make-src (lambda (y) 1.0) 2.0)))
      (src s1 25.0) ; try to tickle segfault
      (src s1 25.0)
      (src s1 125.0)
      (src s1 -25.0)
      (src s1 -125.0))
    (do ((i 0 (+ i 1)))
	((= i 10))
      (make-src (lambda (y) 1.0) 1.5 :width (+ 5 (* i 10))))
    
    (let ((ctr 0.0))
      (let ((gen (make-src :srate 2.0 :input (lambda (dir) (let ((val ctr)) (set! ctr (+ ctr 1)) val))))
	    (v0 (make-float-vector 10)))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (set! (v0 i) (src gen 0.0)))
	(set! ctr 0.0) ; will be accessed within reset
	(mus-reset gen)
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (let ((old-val (v0 i))
		(new-val (src gen 0.0)))
	    (if (fneq old-val new-val)
		(snd-display #__line__ ";reset src ~A ~A ~A" i old-val new-val))))))
    
    (let ()
      (define (so1 s p)
	(src s (env p)))
      
      (let ((s1 (make-src :srate 2.0 :input (make-readin "oboe.snd" 0 10000)))
	    (s2 (make-src :srate 2.0 :input (make-readin "oboe.snd" 0 10000)))
	    (s3 (make-src :srate 2.0 :input (make-readin "oboe.snd" 0 10000)))
	    (e1 (make-env '(0 1 2 0.5) :duration 1000))
	    (e2 (make-env '(0 1 2 0.5) :duration 1000))
	    (e3 (make-env '(0 1 2 0.5) :duration 1000)))
	(do ((i 0 (+ i 1)))
	    ((= i 100))
	  (let ((x1 (src s1 (env e1)))
		(ex2 (env e2)))
	    (let ((x2 (src s2 ex2))
		  (x3 (so1 s3 e3)))
	      (if (not (= x1 x2 x3))
		  (format #t "~D ~A ~A ~A~%" i x1 x2 x3)))))))

    (let ((gen (make-granulate :expansion 2.0 :input (make-readin "oboe.snd" 0 4000 1 2048)))
	  (v0 (make-float-vector 1000))
	  (v1 (make-float-vector 1000))
	  (rd1b (make-readin :file "oboe.snd" :channel 0 :start 4000 :direction 1 :size *clm-file-buffer-size*)))
      (let ((gen1 (make-granulate :expansion 2.0
				  :input (lambda (dir) (readin rd1b)))))
	(print-and-check gen 
			 "granulate"
			 "granulate expansion: 2.000 (551/1102), scaler: 0.600, length: 0.150 secs (3308 samps), ramp: 0.060")
	(do ((i 0 (+ i 1)))
	    ((= i 1000))
	  (set! (v0 i) (granulate gen)))
	(fill-float-vector v1 (if (granulate? gen1) (granulate gen1) -1.0))
	(let ((worst (abs (- (float-vector-peak v0) (float-vector-peak v1)))))
	  (if (> worst .01) (snd-display #__line__ ";run granulate: ~A" worst)))
	(let ((genx gen1))
	  (if (not (equal? genx gen1))
	      (snd-display #__line__ ";granulate equal? ~A ~A ~A" genx gen1 (equal? genx gen1))))
	(if (equal? gen gen1) (snd-display #__line__ ";granulate equal? ~A ~A" gen gen1))
	(if (= (float-vector-peak v0) 0.0) (snd-display #__line__ ";granulate output peak: ~F?" (float-vector-peak v0)))
	(if (not (granulate? gen)) (snd-display #__line__ ";~A not granulate?" gen))
	(if (fneq (mus-increment gen) 2.0) (snd-display #__line__ ";granulate increment: ~F?" (mus-increment gen)))
	(if (fneq (mus-scaler gen) 0.6) (snd-display #__line__ ";granulate scaler: ~F?" (mus-scaler gen)))
	(if (ffneq (mus-frequency gen) 0.05) (snd-display #__line__ ";granulate frequency: ~F?" (mus-frequency gen)))
	(if (not (= (mus-ramp gen) 1323)) (snd-display #__line__ ";granulate ramp: ~F?" (mus-ramp gen)))
	(if (not (= (mus-length gen) 3308)) (snd-display #__line__ ";granulate length: ~A?" (mus-length gen)))
	(if (not (= (mus-hop gen) 1102)) (snd-display #__line__ ";granulate hop: ~A?" (mus-hop gen)))
	(set! (mus-hop gen) 1000) (if (not (= (mus-hop gen) 1000)) (snd-display #__line__ ";granulate set-hop: ~A?" (mus-hop gen)))
	(set! (mus-ramp gen) 1000) (if (not (= (mus-ramp gen) 1000)) (snd-display #__line__ ";granulate set-ramp: ~A?" (mus-ramp gen)))
	(set! (mus-length gen) 3000) (if (not (= (mus-length gen) 3000)) (snd-display #__line__ ";granulate set-length: ~A?" (mus-length gen)))
	(set! (mus-increment gen) 3.0)
	(if (> (abs (- (mus-increment gen) 3.0)) .01) (snd-display #__line__ ";granulate set-increment: ~F?" (mus-increment gen)))
	(set! (mus-increment gen) 0.0) ; should be a no-op
	(if (> (abs (- (mus-increment gen) 3.0)) .01) (snd-display #__line__ ";granulate set-increment 0.0: ~F?" (mus-increment gen)))
	(set! (mus-location gen) 1)
	(if (not (= (mus-location gen) 1)) (snd-display #__line__ ";mus-location grn: ~A" (mus-location gen)))
	(set! (mus-frequency gen) .1)
	(if (fneq (mus-frequency gen) .1) (snd-display #__line__ ";set granulate freq: ~A" (mus-frequency gen))))
      (let ((var (catch #t (lambda () (make-granulate :hop 35.0 :length 35.0)) (lambda args args))))
	(if (not (eq? (car var) 'out-of-range))
	    (snd-display #__line__ ";make-granulate bad sizes: ~A" var))))
    
    (let ((ind (new-sound :size 10)))
      (set! (sample 2) .1)
      (set! (sample 6) -.5)
      (let ((rd (make-sampler)))
	(let ((vals (map values rd)))
	  (if (not (morally-equal? vals '(0.0 0.0 0.1 0.0 0.0 0.0 -0.5 0.0 0.0 0.0)))
	      (snd-display #__line__ ";rd new: ~A" vals))))
      (close-sound ind))
    (let ((ind (open-sound "oboe.snd"))
	  (mx (maxamp)))
      (let ((rd (make-sampler 0)))
	(if (not (= (length rd) 50828))
	    (snd-display #__line__ ";sampler (oboe) length: ~A" (length rd)))
	(let ((grn (make-granulate :expansion 2.0
				   :input (lambda (dir) (read-sample rd))
				   :edit (lambda (g)
					   (float-vector-scale! (mus-data g) 2.0)
					   0))))
	  (map-channel (lambda (y) (granulate grn)))
	  (if (or (< (/ (maxamp) mx) 1.4) (> (/ mx (maxamp)) 2.5))
	      (snd-display #__line__ ";gran edit 2* (0): ~A ~A" mx (maxamp)))
	  (undo)))
      (let ((rd (make-sampler 0)))
	(let ((grn (make-granulate :expansion 2.0
				   :input (lambda (dir) (read-sample rd))
				   :edit (lambda (g)
					   (float-vector-scale! (mus-data g) 4.0)
					   0))))
	  (map-channel (lambda (y) (granulate grn)))
	  (if (or (< (/ (maxamp) mx) 3.0) (> (/ mx (maxamp)) 6.0))
	      (snd-display #__line__ ";gran edit 4* (0): ~A ~A" mx (maxamp)))
	  (revert-sound ind)))
      (let* ((rd (make-sampler 0))
	     (grn (make-granulate :expansion 2.0
				  :input (lambda (dir) (read-sample rd))
				  :edit (lambda (g)
					  (float-vector-scale! (mus-data g) 2.0)
					  0))))
	(map-channel (lambda (y) (granulate grn)))
	(if (or (< (/ (maxamp) mx) 1.4) (> (/ mx (maxamp)) 2.5))
	    (snd-display #__line__ ";gran edit 2* (1): ~A ~A" mx (maxamp)))
	(undo)
	(let* ((rd (make-sampler 0))
	       (grn (make-granulate :expansion 2.0
				   :edit (lambda (g)
					   (float-vector-scale! (mus-data g) 4.0)
					   0)
				   :input (lambda (dir) (read-sample rd)))))
	  (map-channel (lambda (y) (granulate grn)))
	  (if (or (< (/ (maxamp) mx) 2.9) (> (/ mx (maxamp)) 6.0))
	      (snd-display #__line__ ";gran edit 4* (1): ~A ~A" mx (maxamp)))
	  (revert-sound ind)))
      (let ((grn (make-granulate :expansion 2.0 
				 :input (make-sampler 0)
				 :edit (lambda (g)
					 (float-vector-scale! (mus-data g) 2.0)
					 0))))
	(map-channel (lambda (y) (granulate grn)))
	(if (or (< (/ (maxamp) mx) 1.4) (> (/ mx (maxamp)) 2.5))
	    (snd-display #__line__ ";gran edit 2* (2): ~A ~A" mx (maxamp)))
	(undo)
	(let* ((rd (make-sampler 0))
	       (grn (make-granulate :expansion 2.0
				    :input (lambda (dir) (read-sample rd))
				    :edit (lambda (g) (float-vector-scale! (mus-data g) 4.0) 0))))
	  (map-channel (lambda (y) (granulate grn)))
	  (if (or (< (/ (maxamp) mx) 3.0) (> (/ mx (maxamp)) 6.0))
	      (snd-display #__line__ ";gran edit 4* (2): ~A ~A" mx (maxamp)))))
      (close-sound ind))
    
    (let ((ind (open-sound "oboe.snd")))
      (let* ((rd (make-sampler 0))
	     (grn (make-granulate :expansion 2.0 :length .01 :hop .05 :input (lambda (dir) (next-sample rd)))))
	(map-channel (lambda (y) (granulate grn)))
	(let ((mx (maxamp)))
	  (if (> mx .2) (snd-display #__line__ ";trouble in granulate len .01 hop .05: ~A" mx))
	  (undo)))
      (let* ((rd (make-sampler 0))
	     (grn (make-granulate :expansion 2.0 :length .04 :hop .05 :input (lambda (dir) (next-sample rd)))))
	(map-channel (lambda (y) (granulate grn)))
	(let ((mx (maxamp)))
	  (if (> mx .2) (snd-display #__line__ ";trouble in granulate len .04 hop .05: ~A" mx))
	  (undo)))
      (let* ((rd (make-sampler 0))
	     (grn (make-granulate :expansion 2.0 :length .01 :hop .25 :input (lambda (dir) (next-sample rd)))))
	(map-channel (lambda (y) (granulate grn)))
	(let ((mx (maxamp)))
	  (if (> mx .2) (snd-display #__line__ ";trouble in granulate len .01 hop .25: ~A" mx))
	  (undo)))
      (let* ((rd (make-sampler 0))
	     (grn (make-granulate :expansion 2.0 :length .4 :hop .5 :input (lambda (dir) (next-sample rd)))))
	(map-channel (lambda (y) (granulate grn)))
	(let ((mx (maxamp)))
	  (if (> mx .2) (snd-display #__line__ ";trouble in granulate len .4 hop .5: ~A" mx))
	  (undo)))
      (close-sound ind))
    
    (let ((ind (new-sound :size 1000)))
      (let ((gen (make-granulate :jitter 0.0 :hop .004 :length .001 :input (lambda (dir) .1))))
	(map-channel (lambda (y) (granulate gen)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.06) (snd-display #__line__ ";gran 0 max: ~A" mx)))
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.000 0.007 0.013 0.020 0.027 0.033 0.040 0.047 0.053 0.060 0.060 0.060 0.060 0.060 0.060 0.053 
			      0.047 0.040 0.033 0.027 0.020 0.013 0.007 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";gran 0 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (channel->float-vector 85 30) 
			 (float-vector 0.000 0.000 0.000 0.000 0.007 0.013 0.020 0.027 0.033 0.040 0.047 0.053 0.060 0.060 0.060 0.060
			      0.060 0.060 0.053 0.047 0.040 0.033 0.027 0.020 0.013 0.007 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";gran 0 data 85: ~A" (channel->float-vector 85 30)))
	(undo))
      
      (let ((gen (make-granulate :jitter 0.0 :hop .002 :length .001 :input (lambda (dir) .1))))
	(map-channel (lambda (y) (granulate gen)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.06) (snd-display #__line__ ";gran 1 max: ~A" mx)))
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.000 0.007 0.013 0.020 0.027 0.033 0.040 0.047 0.053 0.060 0.060 0.060 0.060 0.060 0.060 0.053 
			      0.047 0.040 0.033 0.027 0.020 0.013 0.007 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";gran 1 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (channel->float-vector 40 30) 
			 (float-vector 0.000 0.000 0.000 0.000 0.000 0.007 0.013 0.020 0.027 0.033 0.040 0.047 0.053 0.060 0.060 0.060 
			      0.060 0.060 0.060 0.053 0.047 0.040 0.033 0.027 0.020 0.013 0.007 0.000 0.000 0.000)))
	    (snd-display #__line__ ";gran 1 data 40: ~A" (channel->float-vector 85 30)))
	(undo))
      
      (let ((gen (make-granulate :jitter 0.0 :hop .002 :length .001 :ramp .1 :input (lambda (dir) .1))))
	(map-channel (lambda (y) (granulate gen)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.06) (snd-display #__line__ ";gran 2 max: ~A" mx)))
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.000 0.030 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 
			      0.060 0.060 0.060 0.060 0.060 0.060 0.030 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";gran 2 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (channel->float-vector 40 30) 
			 (float-vector 0.000 0.000 0.000 0.000 0.000 0.030 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060
			      0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.030 0.000 0.000 0.000)))
	    (snd-display #__line__ ";gran 2 data 40: ~A" (channel->float-vector 40 30)))
	(undo))
      
      (let ((gen (make-granulate :jitter 0.0 :hop .002 :length .001 :ramp .5 :input (lambda (dir) .1))))
	(map-channel (lambda (y) (granulate gen)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.06) (snd-display #__line__ ";gran 3 max: ~A" mx)))
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.000 0.005 0.011 0.016 0.022 0.027 0.033 0.038 0.044 0.049 0.055 0.060 0.060 0.055 0.049 0.044 
			      0.038 0.033 0.027 0.022 0.016 0.011 0.005 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";gran 3 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (channel->float-vector 85 30) 
			 (float-vector 0.000 0.000 0.000 0.000 0.005 0.011 0.016 0.022 0.027 0.033 0.038 0.044 0.049 0.055 0.060 0.060 
			      0.055 0.049 0.044 0.038 0.033 0.027 0.022 0.016 0.011 0.005 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";gran 3 data 85: ~A" (channel->float-vector 85 30)))
	(undo))
      
      (let ((gen (make-granulate :jitter 0.0 :hop .001 :length .001 :ramp .5 :input (lambda (dir) .1))))
	(map-channel (lambda (y) (granulate gen)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.06) (snd-display #__line__ ";gran 4 max: ~A" mx)))
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.000 0.005 0.011 0.016 0.022 0.027 0.033 0.038 0.044 0.049 0.055 0.060 0.060 0.055 0.049 0.044 
			      0.038 0.033 0.027 0.022 0.016 0.011 0.005 0.005 0.011 0.016 0.022 0.027 0.033 0.038)))
	    (snd-display #__line__ ";gran 4 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (channel->float-vector 85 30) 
			 (float-vector 0.022 0.016 0.011 0.005 0.005 0.011 0.016 0.022 0.027 0.033 0.038 0.044 0.049 0.055 0.060 0.060 
			      0.055 0.049 0.044 0.038 0.033 0.027 0.022 0.016 0.011 0.005 0.005 0.011 0.016 0.022)))
	    (snd-display #__line__ ";gran 4 data 85: ~A" (channel->float-vector 85 30)))
	(undo))
      
      (let ((gen (make-granulate :jitter 0.0 :hop .001 :length .001 :ramp .25 :scaler 1.0 :input (lambda (dir) .1))))
	(map-channel (lambda (y) (granulate gen)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.1) (snd-display #__line__ ";gran 5 max: ~A" mx)))
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.000 0.020 0.040 0.060 0.080 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 
			      0.100 0.100 0.100 0.080 0.060 0.040 0.020 0.020 0.040 0.060 0.080 0.100 0.100 0.100)))
	    (snd-display #__line__ ";gran 5 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (channel->float-vector 85 30) 
			 (float-vector 0.080 0.060 0.040 0.020 0.020 0.040 0.060 0.080 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 
			      0.100 0.100 0.100 0.100 0.100 0.100 0.080 0.060 0.040 0.020 0.020 0.040 0.060 0.080)))
	    (snd-display #__line__ ";gran 5 data 85: ~A" (channel->float-vector 85 30)))
	(undo))
      
      (let ((gen (make-granulate :jitter 0.0 :hop .001 :length .002 :ramp .5 :scaler 1.0 :input (lambda (dir) .1))))
	(map-channel (lambda (y) (granulate gen)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.105) (snd-display #__line__ ";gran 6 max: ~A" mx)))
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.000 0.005 0.009 0.014 0.018 0.023 0.027 0.032 0.036 0.041 0.045 0.050 0.055 0.059 0.064 0.068 
			      0.073 0.077 0.082 0.086 0.091 0.095 0.100 0.105 0.105 0.105 0.105 0.105 0.105 0.105)))
	    (snd-display #__line__ ";gran 6 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (channel->float-vector 85 30) 
			 (float-vector 0.105 0.105 0.105 0.105 0.105 0.105 0.105 0.105 0.105 0.105 0.105 0.105 0.105 0.105 0.105 0.105 
			      0.105 0.105 0.105 0.105 0.105 0.105 0.105 0.105 0.105 0.105 0.105 0.105 0.105 0.105)))
	    (snd-display #__line__ ";gran 6 data 85: ~A" (channel->float-vector 85 30)))
	(undo))
      
      (let ((gen (make-granulate :jitter 0.0 :hop .001 :length .005 :ramp .5 :scaler 1.0 :input (lambda (dir) .1))))
	(map-channel (lambda (y) (granulate gen)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.264) (snd-display #__line__ ";gran 7 max: ~A" mx)))
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.000 0.002 0.004 0.005 0.007 0.009 0.011 0.013 0.015 0.016 0.018 0.020 0.022 0.024 0.025 0.027 
			      0.029 0.031 0.033 0.035 0.036 0.038 0.040 0.044 0.047 0.051 0.055 0.058 0.062 0.065)))
	    (snd-display #__line__ ";gran 7 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (channel->float-vector 85 30) 
			 (float-vector 0.244 0.244 0.244 0.244 0.245 0.247 0.249 0.251 0.253 0.255 0.256 0.258 0.260 0.262 0.264 0.264 
			      0.262 0.260 0.258 0.256 0.255 0.253 0.251 0.249 0.247 0.245 0.245 0.247 0.249 0.251)))
	    (snd-display #__line__ ";gran 7 data 85: ~A" (channel->float-vector 85 30)))
	(undo))
      
      (let ((gen (make-granulate :jitter 0.0 :hop .01 :length .001 :ramp .5 :scaler 1.0 :expansion 2.0 :input (lambda (dir) .1))))
	(map-channel (lambda (y) (granulate gen)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.1) (snd-display #__line__ ";gran 8 max: ~A" mx)))
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.000 0.009 0.018 0.027 0.036 0.045 0.055 0.064 0.073 0.082 0.091 0.100 0.100 0.091 0.082 0.073 
			      0.064 0.055 0.045 0.036 0.027 0.018 0.009 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";gran 8 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (channel->float-vector 220 30) 
			 (float-vector 0.000 0.009 0.018 0.027 0.036 0.045 0.055 0.064 0.073 0.082 0.091 0.100 0.100 0.091 0.082 0.073 
			      0.064 0.055 0.045 0.036 0.027 0.018 0.009 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";gran 8 data 220: ~A" (channel->float-vector 220 30)))
	(undo))
      
      (let ((gen (make-granulate :jitter 0.0 :hop .01 :length .001 :ramp .5 :scaler 1.0 :expansion 0.5 :input (lambda (dir) .1))))
	(map-channel (lambda (y) (granulate gen)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.1) (snd-display #__line__ ";gran 9 max: ~A" mx))) ; same as 8 because expansion hits the input counter
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.000 0.009 0.018 0.027 0.036 0.045 0.055 0.064 0.073 0.082 0.091 0.100 0.100 0.091 0.082 0.073 
			      0.064 0.055 0.045 0.036 0.027 0.018 0.009 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";gran 9 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (channel->float-vector 220 30) 
			 (float-vector 0.000 0.009 0.018 0.027 0.036 0.045 0.055 0.064 0.073 0.082 0.091 0.100 0.100 0.091 0.082 0.073 
			      0.064 0.055 0.045 0.036 0.027 0.018 0.009 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";gran 9 data 220: ~A" (channel->float-vector 220 30)))
	(undo))
      
      (let ((gen (make-granulate :jitter 0.0 :hop .001 :length .005 :ramp .5 :scaler 1.0
				 :input (lambda (dir) .1)
				 :edit (lambda (g)
					 (float-vector-scale! (mus-data g) 2.0)
					 0))))
	(map-channel (lambda (y) (granulate gen)))
	(let ((mx (maxamp)))
	  (if (fneq mx (* 2 0.264)) (snd-display #__line__ ";gran 10 max: ~A" mx)))
	(if (not (vequal (float-vector-scale! (channel->float-vector 0 30) 0.5)
			 (float-vector 0.000 0.002 0.004 0.005 0.007 0.009 0.011 0.013 0.015 0.016 0.018 0.020 0.022 0.024 0.025 0.027 
			      0.029 0.031 0.033 0.035 0.036 0.038 0.040 0.044 0.047 0.051 0.055 0.058 0.062 0.065)))
	    (snd-display #__line__ ";gran 10 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (float-vector-scale! (channel->float-vector 85 30) 0.5)
			 (float-vector 0.244 0.244 0.244 0.244 0.245 0.247 0.249 0.251 0.253 0.255 0.256 0.258 0.260 0.262 0.264 0.264 
			      0.262 0.260 0.258 0.256 0.255 0.253 0.251 0.249 0.247 0.245 0.245 0.247 0.249 0.251)))
	    (snd-display #__line__ ";gran 10 data 85: ~A" (channel->float-vector 85 30)))
	(undo))
      
      (let ((forward #t)
	    (ctr -0.5)
	    (incr .001))
	(let ((f1 (lambda (dir) 
		    (set! ctr (+ ctr incr))))
	      (f2 (lambda (g)
		    (if forward ; no change to data
			(set! forward #f)
			(let ((len (mus-length g)))
			  (let ((grain (make-shared-vector (mus-data g) (list len))))
			    (set! forward #t)
			    (reverse! grain)))) ; should get ramps going up then down across overall rising ramp
		    (mus-length g))))
	  (let ((gen (make-granulate :jitter 0.0 :hop .005 :length .002 :ramp 0.0 :scaler 1.0 :input f1 :edit f2)))
	    (map-channel (lambda (y) (granulate gen)))))
	(let ((mx (maxamp)))
	  (if (> mx 0.6) (snd-display #__line__ ";gran 11 max: ~A" mx)))
	(if (not (vequal (channel->float-vector 0 30)
			 (float-vector -0.499 -0.498 -0.497 -0.496 -0.495 -0.494 -0.493 -0.492 -0.491 -0.490 -0.489 -0.488 -0.487 -0.486 
			      -0.485 -0.484 -0.483 -0.482 -0.481 -0.480 -0.479 -0.478 -0.477 -0.476 -0.475 -0.474 -0.473 -0.472 -0.471 -0.470)))
	    (snd-display #__line__ ";gran 11 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (channel->float-vector 100 30)
			 (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 -0.345 -0.346 -0.347 -0.348 -0.349 
			      -0.350 -0.351 -0.352 -0.353 -0.354 -0.355 -0.356 -0.357 -0.358 -0.359 -0.360 -0.361 -0.362 -0.363 -0.364)))
	    (snd-display #__line__ ";gran 11 data 100: ~A" (channel->float-vector 100 30)))
	(undo))
      
      (let* ((ctr -0.5)
	     (incr .001)
	     (gen (make-granulate :jitter 0.0 :hop .005 :length .002 :ramp 0.0 :scaler 1.0
				  :input (lambda (dir) (set! ctr (+ ctr incr))))))
	(map-channel (lambda (y) (granulate gen)))
	(let ((mx (maxamp)))
	  (if (> mx 0.6) (snd-display #__line__ ";gran 12 max: ~A" mx)))
	(if (not (vequal (channel->float-vector 0 30)
			 (float-vector -0.499 -0.498 -0.497 -0.496 -0.495 -0.494 -0.493 -0.492 -0.491 -0.490 -0.489 -0.488 -0.487 -0.486 
			      -0.485 -0.484 -0.483 -0.482 -0.481 -0.480 -0.479 -0.478 -0.477 -0.476 -0.475 -0.474 -0.473 -0.472 -0.471 -0.470)))
	    (snd-display #__line__ ";gran 12 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (channel->float-vector 100 30)
			 (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 -0.389 -0.388 -0.387 -0.386 -0.385 
			      -0.384 -0.383 -0.382 -0.381 -0.380 -0.379 -0.378 -0.377 -0.376 -0.375 -0.374 -0.373 -0.372 -0.371 -0.370)))
	    (snd-display #__line__ ";gran 12 data 100: ~A" (channel->float-vector 100 30)))
	(undo))
      
      (let ((gen (make-granulate :jitter 0.0 :hop .001 :length .005 :ramp .5 :scaler 1.0
				 :input (lambda (dir) .1)
				 :edit (lambda (g)
					 (float-vector-scale! (mus-data g) 2.0)
					 0))))
	(map-channel (lambda (y) (granulate gen)))
	(let ((mx (maxamp)))
	  (if (> mx .6) (snd-display #__line__ ";gran 13 max: ~A" mx)))
	(if (not (vequal (float-vector-scale! (channel->float-vector 0 30) 0.5)
			 (float-vector 0.000 0.002 0.004 0.005 0.007 0.009 0.011 0.013 0.015 0.016 0.018 0.020 0.022 0.024 0.025 0.027 
			      0.029 0.031 0.033 0.035 0.036 0.038 0.040 0.044 0.047 0.051 0.055 0.058 0.062 0.065)))
	    (snd-display #__line__ ";gran 13 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (float-vector-scale! (channel->float-vector 85 30) 0.5)
			 (float-vector 0.244 0.244 0.244 0.244 0.245 0.247 0.249 0.251 0.253 0.255 0.256 0.258 0.260 0.262 0.264 0.264 
			      0.262 0.260 0.258 0.256 0.255 0.253 0.251 0.249 0.247 0.245 0.245 0.247 0.249 0.251)))
	    (snd-display #__line__ ";gran 13 data 85: ~A" (channel->float-vector 85 30)))
	(undo))
      
      (let* ((forward #t)
	     (ctr -0.5)
	     (incr .001)
	     (gen (make-granulate :jitter 0.0 :hop .005 :length .002 :ramp 0.0 :scaler 1.0
				  :input (lambda (dir) (set! ctr (+ ctr incr)))
				  :edit (lambda (g)
					  (if forward
					      (set! forward #f)
					      (let ((len (mus-length g)))
						(let ((grain (make-shared-vector (mus-data g) (list len))))
						  (set! forward #t)
						  (reverse! grain))))
					  (mus-length g)))))
	(map-channel (lambda (y) (granulate gen)))
	(let ((mx (maxamp)))
	  (if (> mx 0.6) (snd-display #__line__ ";gran 14 max: ~A" mx)))
	(if (not (vequal (channel->float-vector 0 30)
			 (float-vector -0.499 -0.498 -0.497 -0.496 -0.495 -0.494 -0.493 -0.492 -0.491 -0.490 -0.489 -0.488 -0.487 -0.486 
			      -0.485 -0.484 -0.483 -0.482 -0.481 -0.480 -0.479 -0.478 -0.477 -0.476 -0.475 -0.474 -0.473 -0.472 -0.471 -0.470)))
	    (snd-display #__line__ ";gran 14 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (channel->float-vector 100 30)
			 (float-vector 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 -0.345 -0.346 -0.347 -0.348 -0.349 
			      -0.350 -0.351 -0.352 -0.353 -0.354 -0.355 -0.356 -0.357 -0.358 -0.359 -0.360 -0.361 -0.362 -0.363 -0.364)))
	    (snd-display #__line__ ";gran 14 data 100: ~A" (channel->float-vector 100 30)))
	(undo))
      
      (let* ((gen (make-granulate :jitter 0.0 :hop .004 :length .001 :ramp 0.0 :input (lambda (dir) .1)))
	     (e (make-env '(0 0 1 .5) :length 1001))
	     (base-ramp-len (mus-length gen)))
	(map-channel 
	 (lambda (y) 
	   (let ((result (granulate gen)))
	     (set! (mus-ramp gen) (round (* base-ramp-len (env e))))
	     result)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.06) (snd-display #__line__ ";granf 0 max: ~A" mx)))
	(if (> (abs (- (mus-ramp gen) (* .5 (mus-length gen)))) 1)
	    (snd-display #__line__ ";granf 0 ramp: ~A ~A" (mus-ramp gen) (mus-length gen)))
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 
			      0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";granf 0 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (channel->float-vector 440 30) 
			 (float-vector 0.000 0.012 0.024 0.036 0.048 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 
			      0.060 0.060 0.060 0.060 0.060 0.048 0.036 0.024 0.012 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";granf 0 data 440: ~A" (channel->float-vector 440 30)))
	(if (not (vequal (channel->float-vector 880 30) 
			 (float-vector 0.000 0.006 0.012 0.018 0.024 0.030 0.036 0.042 0.048 0.054 0.060 0.060 0.060 0.060 
			      0.054 0.048 0.042 0.036 0.030 0.024 0.018 0.012 0.006 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";granf 0 data 880: ~A" (channel->float-vector 880 30)))
	(undo))
      
      
      (let* ((gen (make-granulate :jitter 0.0 :hop .004 :length .001 :ramp 0.0 :input (lambda (dir) .1)))
	     (e (make-env '(0 1 1 .25) :length 1001))
	     (base-hop-len (mus-hop gen)))
	(map-channel 
	 (lambda (y) 
	   (let ((result (granulate gen)))
	     (set! (mus-hop gen) (round (* base-hop-len (env e))))
	     result)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.06) (snd-display #__line__ ";granf 1 max: ~A" mx)))
	(if (> (abs (- (mus-hop gen) (* .001 *clm-srate*))) 1)
	    (snd-display #__line__ ";granf 1 hop: ~A ~A, ~A ~A" (mus-hop gen) (abs (- (mus-hop gen) (* .001 (srate)))) (srate) *clm-srate*))
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 
			      0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";granf 1 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (channel->float-vector 900 30) 
			 (float-vector 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.000 0.000 
			      0.000 0.000 0.000 0.000 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060)))
	    (snd-display #__line__ ";granf 1 data 900: ~A" (channel->float-vector 900 30)))
	(undo))
      
      (let* ((gen (make-granulate :jitter 0.0 :hop .004 :length .001 :ramp 0.0 :input  (lambda (dir) .1)))
	     (e (make-env '(0 1 1 .25) :length 1001))
	     (base-freq (mus-frequency gen)))
	(map-channel 
	 (lambda (y) 
	   (let ((result (granulate gen)))
	     (set! (mus-frequency gen) (* base-freq (env e)))
	     result)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.06) (snd-display #__line__ ";granf 2 max: ~A" mx)))
	(if (> (abs (- (mus-hop gen) (* .001 *clm-srate*))) 1)
	    (snd-display #__line__ ";granf 2 hop: ~A" (mus-hop gen)))
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 
			      0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";granf 2 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (channel->float-vector 900 30) 
			 (float-vector 0.060 0.060 0.060 0.060 0.060 0.000 0.000 0.000 0.000 0.000 0.000 0.060 0.060 0.060 
			      0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060)))
	    (snd-display #__line__ ";granf 2 data 900: ~A" (channel->float-vector 900 30)))
	(undo))
      
      (let ((gen (make-granulate :jitter 0.0 :hop .002 :length .001 :ramp 0.0 :scaler 1.0 :input (lambda (dir) .1))))
	(map-channel (lambda (y) (granulate gen)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.1) (snd-display #__line__ ";granf 3 max: ~A" mx)))
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 
			      0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";gran 3 data: ~A" (channel->float-vector 0 30)))
	(undo))
      
      (let ((gen (make-granulate :jitter 0.0 :hop .004 :length .001 :ramp 0.0 :scaler 1.0 :input (lambda (dir) .1)))
	    (e (make-env '(0 1 1 0.0) :length 1001)))
	(map-channel 
	 (lambda (y) 
	   (let ((result (granulate gen)))
	     (set! (mus-scaler gen) (env e))
	     result)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.1) (snd-display #__line__ ";granf 4 max: ~A" mx)))
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 
			      0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";granf 4 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (channel->float-vector 440 30) 
			 (float-vector 0.056 0.056 0.056 0.056 0.056 0.056 0.056 0.056 0.056 0.056 0.056 0.056 0.056 0.056 
			      0.056 0.056 0.056 0.056 0.056 0.056 0.056 0.056 0.056 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";granf 4 data 440: ~A" (channel->float-vector 440 30)))
	(if (not (vequal (channel->float-vector 900 30) 
			 (float-vector 0.012 0.012 0.012 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 
			      0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";granf 4 data 900: ~A" (channel->float-vector 900 30)))
	(undo))
      
      (let* ((gen (make-granulate :jitter 0.0 :hop .006 :length .001 :ramp 0.0 :max-size 2200 :input  (lambda (dir) .1)))
	     (e (make-env '(0 1 1 5) :length 1001))
	     (base-len (mus-length gen)))
	(map-channel 
	 (lambda (y) 
	   (let ((result (granulate gen)))
	     (set! (mus-length gen) (round (* base-len (env e))))
	     result)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.06) (snd-display #__line__ ";granf 5 max: ~A" mx)))
	(if (> (abs (- (mus-length gen) (* 5 base-len))) 10)
	    (snd-display #__line__ ";granf 5 length: ~A ~A" (mus-length gen) (* 5 base-len)))
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 
			      0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";granf 5 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (channel->float-vector 440 30) 
			 (float-vector 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 
			      0.060 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";granf 5 data 440: ~A" (channel->float-vector 440 30)))
	(if (not (vequal (channel->float-vector 800 30) 
			 (float-vector 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 
			      0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060)))
	    (snd-display #__line__ ";granf 5 data 800: ~A" (channel->float-vector 800 30)))
	(undo))
      
      (let* ((gen (make-granulate :jitter 0.0 :hop .006 :length .005 :ramp 0.0 :max-size 2200 :input (lambda (dir) .1)))
	     (e (make-env '(0 1 1 .2) :length 1001))
	     (base-len (mus-length gen)))
	(map-channel 
	 (lambda (y) 
	   (let ((result (granulate gen)))
	     (set! (mus-length gen) (round (* base-len (env e))))
	     result)))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.06) (snd-display #__line__ ";granf 6 max: ~A" mx)))
	(if (> (abs (- (mus-length gen) (* .2 base-len))) 4)
	    (snd-display #__line__ ";granf 6 length: ~A ~A" (mus-length gen) (* .2 base-len)))
	(if (not (vequal (channel->float-vector 0 30) 
			 (float-vector 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 
			      0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060)))
	    (snd-display #__line__ ";granf 6 data: ~A" (channel->float-vector 0 30)))
	(if (not (vequal (channel->float-vector 820 30) 
			 (float-vector 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.000 0.000 
			      0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";granf 6 data 820: ~A" (channel->float-vector 820 30)))
	(undo))
      
      (let ((max-list (lambda ()
			(let ((pts ()) 
			      (samp 0)
			      (lasty 0.0))
			  (scan-channel (lambda (y) 
					  (if (and (< lasty 0.1)
						   (>= y .1))
					      (set! pts (cons samp pts)))
					  (set! lasty y)
					  (set! samp (+ samp 1))
					  #f)) 
			  (reverse pts)))))
	(let ((gen (make-granulate :jitter 0.0 :hop .01 :length .001 :ramp .5 :scaler 1.0 :expansion 0.5 :input (lambda (dir) .1))))
	  (map-channel (lambda (y) (granulate gen)))
	  (let ((vals (max-list)))
	    (if (not (equal? vals (list 11 231 451 671 891)))
		(snd-display #__line__ ";grn jitter 0 max: ~A" vals)))
	  (undo))
	
	(let ((oldvals #f))
	  (let ((gen (make-granulate :jitter 0.3 :hop .01 :length .001 :ramp .5 :scaler 1.0 :expansion 0.5 :input (lambda (dir) .1))))
	    (map-channel (lambda (y) (granulate gen)))
	    ;; (11 232 490 736 982) or whatever
	    (let ((vals (max-list)))
	      (if (equal? vals (list 11 231 451 671 891))
		  (snd-display #__line__ ";grn jitter 0.3 max: ~A" vals))
	      (set! oldvals vals))
	    (undo))
	  
	  (let ((gen (make-granulate :jitter 0.3 :hop .01 :length .001 :ramp .5 :scaler 1.0 :expansion 0.5 :input (lambda (dir) .1))))
	    (map-channel (lambda (y) (granulate gen)))
	    (let ((vals (max-list)))
	      (if (equal? vals oldvals)
		  (snd-display #__line__ ";grn jitter 0.3 max: ~A ~A" vals oldvals)))
	    (undo)))
	
	(let ((oldvals #f)
	      (seed 0))
	  (let ((gen (make-granulate :jitter 1.0 :hop .01 :length .001 :ramp .5 :scaler 1.0 :expansion 0.5 :input (lambda (dir) .1))))
	    (set! seed (mus-location gen))
	    (map-channel (lambda (y) (granulate gen)))
	    (set! oldvals (max-list))
	    (undo))
	  
	  (let ((gen (make-granulate :jitter 1.0 :hop .01 :length .001 :ramp .5 :scaler 1.0 :expansion 0.5 :input (lambda (dir) .1))))
	    (set! (mus-location gen) seed)
	    (map-channel (lambda (y) (granulate gen)))
	    (let ((vals (max-list)))
	      (if (not (equal? vals oldvals))
		  (snd-display #__line__ ";grn jitter 1.0 max with seed: ~A ~A" vals oldvals)))
	    (undo))))
      
      (let ((fname (file-name ind)))
	(close-sound ind)
	(delete-file fname)
	(if (and with-motif
		 (view-files-dialog #f))
	    (begin
	      (set! (view-files-files (view-files-dialog #f)) ())
	      (if (pair? (view-files-files (view-files-dialog #f)))
		  (snd-display #__line__ ";set vf files list null: ~A" (view-files-files (view-files-dialog #f)))))))
      )
    
    ;; granulate with jitter=0, small hop (comb filter effect)
    (let ((ind (new-sound "tmp.snd" 1 22050 mus-ldouble mus-next :size 10000)))
      (let ((gen (make-granulate :expansion 20.0
				 :input (lambda (dir) .01)
				 :length .00995
				 :hop .01
				 :ramp 0.0
				 :scaler 1.0
				 :jitter 0.0)))
	(clm-channel gen) ; -> .01 max (stable)
	(if (fneq (maxamp) .01) (snd-display #__line__ ";granulate stable 1: ~A" (maxamp)))
	(let ((minval (scan-channel (lambda (y) (< y .0099)))))
	  (if minval (snd-display #__line__ ";granulate stable 1 min: ~A" minval)))
	(undo)
	(set! gen (make-granulate :expansion 20.0
				  :input (lambda (dir) .1)
				  :length .00995
				  :hop .01
				  :ramp 0.0
				  :scaler 0.5
				  :jitter 0.0))
	(clm-channel gen) ; -> .05 max (stable)
	(if (fneq (maxamp) .05) (snd-display #__line__ ";granulate stable 2: ~A" (maxamp)))
	(let ((minval (scan-channel (lambda (y) (< y .0499)))))
	  (if minval (snd-display #__line__ ";granulate stable 2 min: ~A" minval)))
	(undo)
	
	(set! gen (make-granulate :expansion 10.0
				  :input (lambda (dir) .05)
				  :length .099975
				  :hop .1
				  :ramp 0.0
				  :scaler 1.0
				  :jitter 0.0))
	(clm-channel gen) ; -> .05 max (stable)
	(if (fneq (maxamp) .05) (snd-display #__line__ ";granulate stable 3: ~A" (maxamp)))
	(let ((minval (scan-channel (lambda (y) (< y .0499)))))
	  (if minval (snd-display #__line__ ";granulate stable 3 min: ~A ~A" minval (sample (cadr minval)))))
	(undo)
	
	(let ((ctr -0.0001))
	  (set! gen (make-granulate :expansion 2.0
				    :input (lambda (dir) (set! ctr (+ ctr .0001)))
				    :length .01
				    :hop .1
				    :ramp 0.0
				    :scaler 1.0
				    :jitter 0.0))
	  (clm-channel gen)
	  (if (fneq (maxamp) .462) (snd-display #__line__ ";granulate ramped 4: ~A" (maxamp)))
	  (let ((vals (count-matches (lambda (y) (> (abs y) 0.0)))))
	    (if (> (abs (- vals 1104)) 10) (snd-display #__line__ ";granulate ramped 4 not 0.0: ~A" vals)))
	  (if (or (not (vequal (channel->float-vector 2203 10)
			       (float-vector 0.000 0.000 0.110 0.110 0.110 0.111 0.111 0.111 0.111 0.111)))
		  (not (vequal (channel->float-vector 4523 10)
			       (float-vector 0.232 0.232 0.232 0.232 0.232 0.232 0.232 0.232 0.233 0.233)))
		  (not (vequal (channel->float-vector 8928 10)
			       (float-vector 0.452 0.452 0.452 0.452 0.452 0.452 0.452 0.452 0.452 0.452))))
	      (snd-display #__line__ ";granulate ramped 4 data off: ~A ~A ~A" 
			   (channel->float-vector 2203 10) (channel->float-vector 4523 10) (channel->float-vector 8928 10)))
	  (undo)
	  
	  (let ((e (make-env '(0 0 1 1) :length 10000)))
	    (set! gen (make-granulate :expansion 2.0
				      :input (lambda (dir) (env e))
				      :length .00995
				      :hop .01
				      :ramp 0.0
				      :scaler 1.0
				      :jitter 0.0)))
	  (clm-channel gen)
	  (if (fneq (maxamp) .505) (snd-display #__line__ ";granulate ramped 5: ~A" (maxamp)))
	  (let* ((mxoff 0.0)
		 (mx (maxamp))
		 (len (framples))
		 (cur 0.0)
		 (incr (/ mx len)))
	    (scan-channel (lambda (y) 
			    (let ((diff (abs (- cur y)))) 
			      (if (> diff mxoff) (set! mxoff diff))
			      (set! cur (+ cur incr))
			      #f)))
	    (if (> mxoff .02) (snd-display #__line__ ";granulate ramped 5 mxoff: ~A" mxoff))) ; .0108 actually
	  (undo)
	  
	  (let ((e (make-env '(0 0 1 1) :length 10000)))
	  (set! gen (make-granulate :expansion 2.0
				    :input (lambda (dir) (env e))
				    :length .00995
				    :hop .01
				    :ramp 0.5
				    :scaler 1.0
				    :jitter 0.0)))
	  (clm-channel gen)
	  (if (fneq (maxamp) .495) (snd-display #__line__ ";granulate ramped 6: ~A" (maxamp)))
	  (if (or (not (vequal (channel->float-vector 2000 10)
			       (float-vector 0.018 0.019 0.020 0.021 0.022 0.023 0.024 0.025 0.026 0.027)))
		  (not (vequal (channel->float-vector 8000 10)
			       (float-vector 0.294 0.298 0.301 0.305 0.309 0.313 0.316 0.320 0.324 0.328))))
	      (snd-display #__line__ ";granulate ramped 6 data: ~A ~A"
			   (channel->float-vector 2000 10) (channel->float-vector 8000 10)))
	  (undo)
	  
	  (let ((e (make-env '(0 0 1 1) :length 10000)))
	  (set! gen (make-granulate :expansion 2.0
				    :input (lambda (dir) (env e))
				    :length .00995
				    :hop .01
				    :ramp 0.25
				    :scaler 1.0
				    :jitter 0.0)))
	  (clm-channel gen)
	  (if (fneq (maxamp) .505) (snd-display #__line__ ";granulate ramped 7: ~A" (maxamp)))
	  (if (or (not (vequal (channel->float-vector 2000 10)
			       (float-vector 0.037 0.039 0.040 0.042 0.044 0.046 0.048 0.050 0.052 0.054)))
		  (not (vequal (channel->float-vector 8000 10)
			       (float-vector 0.404 0.404 0.404 0.404 0.404 0.405 0.405 0.405 0.405 0.405))))
	      (snd-display #__line__ ";granulate ramped 7 data: ~A ~A"
			   (channel->float-vector 2000 10) (channel->float-vector 8000 10)))
	  (undo)
	  
	  (let ((e (make-env '(0 0 1 1) :length 10000)))
	  (set! gen (make-granulate :expansion 2.0
				    :input (lambda (dir) (env e))
				    :length .05
				    :hop .01
				    :ramp 0.25
				    :scaler 0.1
				    :jitter 0.0)))
	  (clm-channel gen)
	  (if (fneq (maxamp) .201) (snd-display #__line__ ";granulate ramped 7: ~A" (maxamp)))
	  (let* ((mxoff 0.0)
		 (mx (maxamp))
		 (len (framples))
		 (cur 0.0)
		 (incr (/ mx len)))
	    (scan-channel (lambda (y) 
			    (let ((diff (abs (- cur y)))) 
			      (if (> diff mxoff) (set! mxoff diff))
			      (set! cur (+ cur incr))
			      #f)))
	    (if (> mxoff .01) (snd-display #__line__ ";granulate ramped 7 mxoff: ~A" mxoff))) ; .0097 actually
	  (undo)
	  
	  (let ((e (make-env '(0 0 1 1) :length 10000)))
	  (set! gen (make-granulate :expansion 2.0
				    :input (lambda (dir) (env e))
				    :length .1
				    :hop .01
				    :ramp 0.1
				    :scaler 0.1
				    :jitter 0.0)))
	  (clm-channel gen)
	  (if (fneq (maxamp) .501) (snd-display #__line__ ";granulate ramped 8: ~A" (maxamp)))
	  (let* ((mxoff 0.0)
		 (mx (maxamp))
		 (len (- (framples) 2000))
		 (cur (sample 2000))
		 (incr (/ (- mx cur) len)))
	    (scan-channel (lambda (y) 
			    (let ((diff (abs (- cur y)))) 
			      (if (> diff mxoff) (set! mxoff diff))
			      (set! cur (+ cur incr))
			      #f))
			  2000)
	    (if (> mxoff .001) (snd-display #__line__ ";granulate ramped 8 mxoff: ~A" mxoff)))
	  (undo)
	  
	  (let ((e (make-env '(0 0 1 1) :length 10000)))
	  (set! gen (make-granulate :expansion 2.0
				    :input (lambda (dir) (env e))
				    :length .4
				    :hop .01
				    :ramp 0.4
				    :scaler 0.025
				    :jitter 0.0)))
	  (clm-channel gen)
	  (if (fneq (maxamp) .433) (snd-display #__line__ ";granulate ramped 9: ~A" (maxamp)))
	  (undo)
	  (close-sound ind))))
    
    (let ((v0 (make-float-vector 32))
	  (v1 (make-float-vector 256))
	  (v2 (make-float-vector 256))
	  (v01 (make-float-vector 32))
	  (v11 (make-float-vector 256))
	  (v21 (make-float-vector 256)))
      (do ((i 1 (+ i 1)))
	  ((= i 16))
	(set! (v0 i) (/ 1.0 i))
	(set! (v01 i) (/ 1.0 i)))
      (set! (v1 0) 1.0)
      (set! (v11 0) 1.0)
      (let ((n -1)
	    (n1 -1))
	(let ((gen (make-convolve :filter v0 :input (lambda (dir) (set! n (+ n 1)) (v1 n))))
	      (gen1 (make-convolve :filter v01 :input (lambda (dir) (set! n1 (+ n1 1)) (v11 n1)))))
	  (print-and-check gen 
			   "convolve"
			   "convolve size: 64")
	  (if (not (convolve? gen)) (snd-display #__line__ ";~A not convolve?" gen))
	  (let ((genx gen1))
	    (if (not (equal? genx gen1)) (snd-display #__line__ ";convolve equal?: ~A ~A ~A" genx gen1 (equal? genx gen1))))
	  (if (equal? gen gen1) (snd-display #__line__ ";convolve equal? ~A ~A" gen gen1))
	  (if (not (= (mus-length gen) 64)) (snd-display #__line__ ";convolve fft len: ~D?" (mus-length gen)))
	  (do ((i 0 (+ i 1)))
	      ((= i 128))
	    (set! (v2 i) (convolve gen)))
	  (fill-float-vector v21 (if (convolve? gen1) (convolve gen1) -1.0))
	  (if (not (vequal v2 v21)) (snd-display #__line__ ";run gran: ~A ~A" v2 v21))
	  (if (or (fneq (v2 0) 0.0)
		  (fneq (v2 1) 1.0)
		  (fneq (v2 4) 0.25)
		  (fneq (v2 7) 0.143))
	      (snd-display #__line__ ";convolve output: ~A?" v2)))
      
	(convolve-files "oboe.snd" "fyow.snd" .5 "fmv.snd")
	(if (fneq (cadr (mus-sound-maxamp "fmv.snd")) .5) 
	    (snd-display #__line__ ";convolve-files: ~A is not .5?" (cadr (mus-sound-maxamp "fmv.snd"))))
	))

    (let ((flt (float-vector 1.0 0.5 0.1 0.2 0.3 0.4 0.5 1.0))
	  (data (float-vector 0.0 1.0 0.0 0.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0))
	  (ctr -1))
      (let ((res (make-float-vector 16))
	    (g (make-convolve :filter flt
			      :input (lambda (dir)
				       (set! ctr (+ ctr 1))
				       (data ctr)))))
	(do ((i 0 (+ i 1)))
	    ((= i 16))
	  (set! (res i) (convolve g)))
	(if (not (vequal res (float-vector 0.0 1.0 0.5 0.1 1.2 0.8 0.5 0.7 1.3 0.4 0.5 1.0 0.0 0.0 0.0 0.0)))
	    (snd-display #__line__ ";convolve: ~A~%" res))))
    
    (let ((ind (new-sound "fmv.snd")))
      (set! (sample 1) .1)
      (save-sound ind)
      (if (not (equal? (edits ind 0) (list 0 0)))
	  (snd-display #__line__ ";weird: edits not cleared after save-sound?: ~A" (edits ind 0)))
      (close-sound ind)
      (set! ind (open-sound "fmv.snd"))
      (if (not (= (framples ind 0) 2))
	  (snd-display #__line__ ";save-sound 2 samps: ~A?" (framples ind 0)))
      (if (or (fneq (sample 0) 0.0)
	      (fneq (sample 1) 0.1))
	  (snd-display #__line__ ";save-sound: ~A ~A?" (sample 0) (sample 1)))
      (do ((i 3 (+ i 1)))
	  ((= i 6))
	(set! (sample i) (* i .1))
	(save-sound ind)
	(if (not (equal? (edits ind 0) (list 0 0)))
	    (snd-display #__line__ ";weird: edits not cleared after save-sound ~A?: ~A" i (edits ind 0)))
	(close-sound ind)
	(set! ind (open-sound "fmv.snd"))
	(if (not (= (framples ind 0) (+ i 1)))
	    (snd-display #__line__ ";save-sound ~A samps: ~A?" (+ i 1) (framples ind 0)))
	(if (or (fneq (sample 0) 0.0)
		(fneq (sample 1) 0.1)
		(fneq (sample i) (* i 0.1)))
	    (snd-display #__line__ ";save-sound ~A: ~A ~A ~A?" i (sample 0) (sample 1) (sample i))))
      (close-sound ind))
    
    (let ((ind (new-sound "test.snd" :srate 22050 :channels 1 :size 1000))
	  (gen (make-ssb-am 100.0)))
      (map-channel (lambda (y) (ssb-am gen)))
      (if (fneq (maxamp) 0.0) (snd-display #__line__ ";ssb-am 0.0: ~A" (maxamp)))
      (let ((gen1 (make-oscil 220.0)))
	(map-channel (lambda (y) (* 0.5 (oscil gen1))))
	(set! gen (make-ssb-am 100.0 100))
	(map-channel (lambda (y) (ssb-am gen y)))
	(delete-samples 0 200)
	(set! gen1 (make-oscil 320.0 :initial-phase (asin (* 2 (sample 0))))) ; depends on rising side
	(map-channel (lambda (y) (- y (* 0.5 (oscil gen1)))))
	(if (> (maxamp) .004) (snd-display #__line__ ";ssb-am cancelled: ~A" (maxamp)))
	(undo 3)
	(set! gen (make-ssb-am 100.0 100))
	(let ((hx (hz->radians 50.0)))
	  (map-channel (lambda (y) (ssb-am gen y hx))))
	(delete-samples 0 180)
	(set! gen1 (make-oscil 370.0 :initial-phase (asin (* 2 (sample 0))))) ; depends on rising side
	(map-channel (lambda (y) (- y (* 0.5 (oscil gen1)))))
	(if (> (maxamp) .004) (snd-display #__line__ ";ssb-am fm cancelled: ~A" (maxamp)))
	(close-sound ind)))
    
    (let* ((ind (new-sound "test.snd" :srate 22050 :channels 1 :size 1000))
	   (scl (/ (* 2 pi) 50))
	   (x (- scl)))
      (map-channel (lambda (y) (sin (set! x (+ x scl)))))
      ;; 441 Hz 
      (ssb-bank 441 882 1 100)
      (delete-samples 0 217)
      (let ((gen1 (make-oscil 882.0 :initial-phase (asin (sample 0)))))
	(map-channel (lambda (y) (- y (oscil gen1))))
	(if (> (maxamp) .04) (snd-display #__line__ ";ssb-bank cancelled: ~A" (maxamp))))
      (close-sound ind))
    
    (if *output* 
	(begin
	  (snd-display #__line__ ";*output* ~A" *output*)
	  (set! *output* #f)))
    
    (let ((nind (new-sound "fmv.snd" 1 22050 mus-bshort mus-aifc "this is a comment")))
      (time (mix-float-vector (with-temp-sound (:output (make-float-vector 22050)) (fm-violin 0 1 440 .1)) 0 nind 0))
      (play nind :wait #t)
      (save-sound nind)
      (if (not (sound? nind)) (snd-display #__line__ ";save sound clobbered ~A?" nind))
      (let ((oboe-index (or (find-sound "oboe.snd") (open-sound "oboe.snd"))))
	(if (equal? oboe-index nind) (snd-display #__line__ ";find-sound found bogus case: ~A" oboe-index))
	(cnvtest oboe-index nind .1) 
	(select-sound nind)
	(select-channel 0)
	(if (not (equal? (selected-sound) nind)) (snd-display #__line__ ";selected-sound: ~A?" (selected-sound)))
	(if (not (= (selected-channel) 0)) (snd-display #__line__ ";selected-channel: ~A?" (selected-channel)))
	(snd-test-jc-reverb 1.0 #f .1 #f) 
	(play nind :wait #t)
	(voiced->unvoiced 1.0 256 2.0 2.0) 
	(pulse-voice 80 20.0 1.0 1024 0.01)
	(map-channel (fltit))
	(close-sound oboe-index))
      (if (not (sound? nind)) (snd-display #__line__ ";close sound clobbered ~A?" nind))
      (let ((fr (framples nind 0)))
	(do ((k 0 (+ k 1)))
	    ((= k 10))
	  (delete-samples 10 100 nind 0)
	  (save-sound nind)) ;flush out memory leaks here
	(if (not (= (framples nind 0) (- fr 1000)))
	    (snd-display #__line__ ";delete-samples: ~A ~A" fr (framples nind 0))))
      (revert-sound nind)
      (close-sound nind))
    (if (file-exists? "fmv.snd") (delete-file "fmv.snd"))
    
    (let ((nind (new-sound "fmv.snd")))
      (if (not (= (header-type nind) *default-output-header-type*))
	  (snd-display #__line__ ";new-sound default header-type: ~A ~A?"
		       (mus-header-type-name (header-type nind))
		       (mus-header-type-name *default-output-header-type*)))
      (if (not (= (sample-type nind) *default-output-sample-type*))
	  (snd-display #__line__ ";new-sound default sample-type: ~A ~A?"
		       (mus-sample-type-name (sample-type nind))
		       (mus-sample-type-name *default-output-sample-type*)))
      (if (not (= (chans nind) *default-output-chans*))
	  (snd-display #__line__ ";new-sound default chans: ~A ~A?" (chans nind) *default-output-chans*))
      (if (not (= (srate nind) *default-output-srate*))
	  (snd-display #__line__ ";new-sound default srate: ~A ~A?" (srate nind) *default-output-srate*))
      (close-sound nind)
      (if (file-exists? "fmv.snd") (delete-file "fmv.snd")))
    (let ((nind (new-sound "fmv.snd" 1 22050 mus-bshort mus-nist "this is a comment")))
      (set! (sample 0 nind) 1.0) 
      (start-progress-report nind)
      (convolve-with "oboe.snd") 
      (progress-report .1 nind)
      (if (fneq (sample 1000) 0.223) (snd-display #__line__ ";convolve-with: ~A?" (sample 1000)))
      (progress-report .3 nind)
      (revert-sound nind)
      (progress-report .5 nind)
      (set! (sample 200) .0001) 
      (set! (sample 100) 1.0) 
      (progress-report .8 nind)
      (smooth-sound 0 100) 
      (finish-progress-report nind)
      (if (or (fneq (sample 50) .5) (fneq (sample 30) 0.20608) (fneq (sample 90) 0.9755))
	  (snd-display #__line__ ";smooth: ~A ~A ~A?" (sample 50) (sample 30) (sample 90)))
      (undo) 
      (let ((old-wid *sinc-width*))
	(set! *sinc-width* 40) 
	(set! (sample 100) 0.5) 
	(if (fneq (sample 100) 0.5) (snd-display #__line__ ";set-sample 100: ~A?" (sample 100)))
	(src-sound .1) 
	(set! *sinc-width* old-wid))
      (if (or (fneq (sample 1000) 0.5) (fneq (sample 1024) 0.0625) (fneq (sample 1010) 0.0))
	  (snd-display #__line__ ";src-sound: ~A ~A ~A?" (sample 1000) (sample 1024) (sample 1010)))
      (revert-sound)
      (close-sound nind))
    (let ((nind (new-sound "fmv.snd" 1 22050 mus-lshort mus-riff "this is a comment" 22050)))
      (if (not (= (framples nind) 22050)) (snd-display #__line__ "; new-sound initial-length: ~A" (framples nind)))
      (mix "pistol.snd") 
      (map-channel (expsrc 2.0 nind)) 
      (undo) 
      (let ((eds (edits)))
	(if (not (= (car eds) 1 (cadr eds)))
	    (snd-display #__line__ ";undo edits: ~A?" eds))
	(if (not (= (edit-position) (car eds)))
	    (snd-display #__line__ ";undo edit-position: ~A ~A?" (edit-position) eds)))
      (expsnd '(0 1 2 .4)) 
      (map-channel (comb-chord .95 100 .3)) 
      (map-channel (formants .99 900 .02 1800 .01 2700)) 
      (map-channel (moving-formant .99 '(0 1200 1 2400))) 
      (scale-to .3) 
      (let ((eds (edits)))
	(if (or (not (= (car eds) 6)) (not (= (cadr eds) 0)))
	    (snd-display #__line__ ";edits(6): ~A?" eds))
	(if (not (= (edit-position) (car eds)))
	    (snd-display #__line__ ";edit-position(6): ~A ~A?" (edit-position) eds)))
      (set! (edit-position) 1)
      (if (not (= (edit-position) 1))
	  (snd-display #__line__ ";set edit-position(1) ~A?" (edit-position)))
      (set! (edit-position) 4)
      (if (not (= (edit-position) 4))
	  (snd-display #__line__ ";set edit-position(4): ~A?" (edit-position)))
      (revert-sound nind)
      (mix "pistol.snd") 
      (map-channel (zecho .5 .75 6 10.0) 0 65000) 
      (map-channel (am 440)) 
      (add-mark 1200)
      (add-mark 2300)
      (key (char->integer #\x) 4)
      (key (char->integer #\c) 0) ; trigger mark-define-region
      (reverse-sound nind) 
      (revert-sound nind)
      (let ((mid (mix-sound "pistol.snd" 0)))
	(if (and (mix? mid)
		 (not (equal? (mix-home mid) (list (selected-sound) 0 #f 0))))
	    (snd-display #__line__ ";mix-sound mix-home: ~A" (mix-home mid))))
      (hello-dentist 40.0 .1) 
      (fp 1.0 .3 20) 
      (revert-sound nind)
      (enveloped-mix "oboe.snd" 0 '(0 0 1 1 2 0)) 
      (if all-args (pvoc :pitch 0.5 :time 1.0 :snd nind))
      (revert-sound nind)
      (close-sound nind))
    
    (if (and all-args (defined? 'edot-product))
	(let ((ind (new-sound :size 100))
	      (len 100))
	  (set! (sample 10) 0.5)
	  (set! (sample 30) -0.8)
	  (stretch-sound-via-dft 2.0 ind 0)
	  (let ((new-len (framples ind 0)))
	    (if (> (abs (- (* 2 len) new-len)) 10)
		(snd-display #__line__ ";stretch-sound-via-dft: ~A ~A" len new-len)))
	  (close-sound ind)))
    
    (let ((make-mix-output (lambda (name i)
			     (if (or (= i 0) (= i 1)) 
				 name
				 (continue-sample->file name))))
	  (make-mix-input (lambda (name i)
			    (if (or (= i 0) (= i 2))
				name
				(make-file->frample name)))))
      (define (mus-file-mix-1 outf . args)
	(apply mus-file-mix outf args)	
	(if (not (string? outf))
	    (mus-close outf)))

      (do ((k 0 (+ k 1)))
	  ((= k 4))
	(if (file-exists? "fmv.snd") (delete-file "fmv.snd"))
	(if (file-exists? "fmv1.snd") (delete-file "fmv1.snd"))
	(if (file-exists? "fmv2.snd") (delete-file "fmv2.snd"))
	(if (file-exists? "fmv3.snd") (delete-file "fmv3.snd"))
	(let ((v0 (make-float-vector 12)))
	  (fill! v0 0.1)
	  (array->file "fmv1.snd" v0 12 22050 1)
	  (fill! v0 0.2)
	  (array->file "fmv2.snd" v0 12 22050 2)
	  (fill! v0 0.3)
	  (array->file "fmv3.snd" v0 12 22050 4)

	  (do ((i 0 (+ i 1))) ((= i 12)) (set! (v0 i) (* i .01)))
	  (array->file "fmv.snd" v0 12 22050 1)
	  (mus-file-mix-1 (make-mix-output "fmv.snd" k) (make-mix-input "fmv1.snd" k))
	  (file->array "fmv.snd" 0 0 12 v0)

	  ;; v0: #(0.1 0.11 0.12 0.13 0.14 0.15 0.16 0.17 0.18 0.19 0.2 0.21)
	  (let ((happy #t))
	    (do ((i 0 (+ i 1))) 
		((or (not happy) (= i 12)))
	      (if (fneq (v0 i) (+ 0.1 (* i .01))) 
		  (begin
		    (snd-display #__line__ ";~D mus-file-mix(1->1): ~A?" k v0)
		    (set! happy #f)))))

	  (mus-file-mix-1 (make-mix-output "fmv.snd" k) (make-mix-input "fmv2.snd" k) 3 9 0 (float-vector 0.3 0.0 0.7 0.0))
	  (file->array "fmv.snd" 0 0 12 v0)

	  ;; v0: #(0.1 0.11 0.12 0.33 0.34 0.35 0.36 0.37 0.38 0.19 0.2 0.21)
	  (if (or (fneq (v0 0) .1) (fneq (v0 3) .33) (fneq (v0 9) .19)) (snd-display #__line__ ";~D mus-file-mix(2->1): ~A?" k v0))
	  (mus-file-mix-1 (make-mix-output "fmv.snd" k) (make-mix-input "fmv3.snd" k))
	  (file->array "fmv.snd" 0 0 12 v0)

	  ;; ?? v0: #(0.4 0.41 0.42 0.33 0.34 0.35 0.36 0.37 0.38 0.19 0.2 0.21)
	  (if (or (fneq (v0 0) .4) (fneq (v0 3) .33)) (snd-display #__line__ ";~D mus-file-mix(4->1): ~A?" k v0))
	  (let ((e0 (make-env '(0 0 1 1) :length 11))
		(vf (make-vector 1))
		(vf1 (make-vector 1)))
	    (set! (vf 0) vf1)
	    (set! (vf1 0) e0)
	    (mus-file-mix-1 (make-mix-output "fmv.snd" k) (make-mix-input "fmv1.snd" k) 0 12 0 (float-vector 1.0) vf)
	    (file->array "fmv.snd" 0 0 12 v0)

	    ;; ?? v0: #(0.4 0.42 0.4400000000000001 0.36 0.38 0.4 0.42 0.44 0.46 0.28 0.3 0.31)
	    (if (or (fneq (v0 0) .4) (fneq (v0 3) .360) (fneq (v0 9) .28)) (snd-display #__line__ ";~D mus-file-mix(env): ~A?" k v0))
	    (mus-file-mix-1 (make-mix-output "fmv.snd" k) (make-mix-input "fmv2.snd" k) 0 12 0 (float-vector 1.0 1.0 1.0 1.0) vf)) 
	  ;; clm2xen should protect us here
	  (let ((vf (make-vector 2))
		(vf1 (make-vector 2))
		(vf2 (make-vector 2)))
	    (set! (vf 0) vf1)
	    (set! (vf 1) vf2)
	    (set! (vf1 0) (make-env '(0 0 1 1) :length 10))
	    (set! (vf2 1) (make-env '(0 0 1 1) :length 10))
	    (mus-file-mix-1 (make-mix-output "fmv.snd" k) (make-mix-input "fmv2.snd" k) 0 12 0 (float-vector 1.0 1.0 1.0 1.0) vf)
	    (let ((tag (catch #t
			 (lambda ()
			   (set! (vf 0) (make-oscil))
			   (mus-file-mix-1 (make-mix-output "fmv.snd" k) (make-mix-input "fmv2.snd" k) 0 12 0 (float-vector 1.0 1.0 1.0 1.0) vf))
			 (lambda args (car args)))))
	      (if (not (eq? tag 'bad-type))
		  (snd-display #__line__ ";~D mix w oscil-vect: ~A" k tag)))
	    (set! (vf 0) vf1)
	    (set! (vf 1) vf2)
	    (let ((tag (catch #t
			 (lambda ()
			   (set! (vf1 0) (make-oscil))
			   (set! (vf2 1) 0+i)
			   (mus-file-mix-1 (make-mix-output "fmv.snd" k) (make-mix-input "fmv2.snd" k) 0 12 0 (float-vector 1.0 1.0 1.0 1.0) vf))
			 (lambda args (car args)))))
	      (if (not (eq? tag 'bad-type))
		  (snd-display #__line__ ";~D mix w oscil-env: ~A" k tag))))
	  (delete-file "fmv.snd")
	  (do ((i 0 (+ i 1))) ((= i 12)) (set! (v0 i) (* i .01)))
	  (array->file "fmv.snd" v0 12 22050 4)
	  (mus-file-mix-1 (make-mix-output "fmv.snd" k) (make-mix-input "fmv1.snd" k))
	  (file->array "fmv.snd" 0 0 3 v0) ; chan 0 start 0 len 3

	  ;; v0: #(0.1 0.14 0.18 0.03 0.04 0.05 0.06 0.07000000000000001 0.08 0.09 0.1 0.11)
	  (if (or (fneq (v0 0) .1) (fneq (v0 2) .18)) (snd-display #__line__ ";~D mus-file-mix(1->4): ~A?" k v0))
	  (mus-file-mix-1 (make-mix-output "fmv.snd" k) (make-mix-input "fmv2.snd" k)  0 3 0 (float-vector 0.3 0.0 0.7 0.0))
	  (file->array "fmv.snd" 0 0 3 v0)

	  ;; v0: #(0.3 0.34 0.38 0.03 0.04 0.05 0.06 0.07000000000000001 0.08 0.09 0.1 0.11)
	  (if (or (fneq (v0 0) .3) (fneq (v0 2) .38)) (snd-display #__line__ ";~D mus-file-mix(2->4): ~A?" k v0))
	  (mus-file-mix-1 (make-mix-output "fmv.snd" k) (make-mix-input "fmv3.snd" k) 0 2 0)
	  (file->array "fmv.snd" 0 0 3 v0)

	  ;;  v0: #(0.6000000000000001 0.6400000000000001 0.38 0.03 0.04 0.05 0.06 0.07000000000000001 0.08 0.09 0.1 0.11)
	  (if (or (fneq (v0 0) .6) (fneq (v0 2) .38)) (snd-display #__line__ ";~D mus-file-mix(4->4): ~A?" k v0)))
	
	(if (file-exists? "fmv.snd") (delete-file "fmv.snd"))
	(let ((v0 (make-float-vector 12))
	      (len (mus-sound-framples "oboe.snd")))
	  (array->file "fmv.snd" v0 12 22050 1)
	  (mus-file-mix-1 (make-mix-output "fmv.snd" k) (make-mix-input "oboe.snd" k))
	  (mus-file-mix-1 (make-mix-output "fmv.snd" k) (make-mix-input "oboe.snd" k) 0 len 0 (float-vector 0.5))
	  (let ((egen (make-vector 1))
		(outv (make-vector 1)))
	    (set! (outv 0) egen)
	    (set! (egen 0) (make-env :envelope '(0 0 1 1) :length len))
	    (mus-file-mix-1 (make-mix-output "fmv.snd" k) (make-mix-input "oboe.snd" k) 0 len 0 #f outv)
	    (set! (egen 0) (make-env :envelope '(0 1 1 0) :length len))
	    (mus-file-mix-1 (make-mix-output "fmv.snd" k) (make-mix-input "oboe.snd" k) 0 len 0 (float-vector 1.0) outv))
	  (let ((ind-oboe (open-sound "oboe.snd"))
		(ind-mix (open-sound "fmv.snd")))
	    (if (not (vequal (channel->float-vector 1000 10 ind-oboe)
			     (float-vector-scale! (channel->float-vector 1000 10 ind-mix) (/ 1.0 2.5))))
		(snd-display #__line__ ";~D mus-file-mix 1 chan: ~A ~A" k
			     (channel->float-vector 1000 10 ind-oboe)
			     (channel->float-vector 1000 10 ind-mix)))
	    (close-sound ind-oboe)
	    (close-sound ind-mix))
	  (delete-file "fmv.snd")
	  (let ((v0 (make-float-vector 12))
		(len (mus-sound-framples "2.snd")))
	    (array->file "fmv.snd" v0 12 22050 2)
	    (if (not (= (mus-sound-chans "fmv.snd") 2))
		(snd-display #__line__ ";~D array->file chans? ~A" k (mus-sound-chans "fmv.snd")))
	    (mus-file-mix-1 (make-mix-output "fmv.snd" k) (make-mix-input "2.snd" k))
	    (mus-file-mix-1 (make-mix-output "fmv.snd" k) (make-mix-input "2.snd" k) 0 len 0 (float-vector 0.5 0.0 0.0 0.5))
	    (let ((egen0 (make-vector 2))
		  (egen1 (make-vector 2))
		  (outv (make-vector 2)))
	      (set! (outv 0) egen0)
	      (set! (outv 1) egen1)
	      (set! (egen0 0) (make-env :envelope '(0 0 1 1) :length len))
	      (set! (egen1 1) (make-env :envelope '(0 0 1 1) :length len))
	      (mus-file-mix-1 (make-mix-output "fmv.snd" k) (make-mix-input "2.snd" k) 0 len 0 #f outv))
	    (let ((ind-mix (open-sound "fmv.snd")))
	      (if (not (= (channels ind-mix) 2))
		  (snd-display #__line__ ";~D fmv re-read chans? ~A ~A" k (mus-sound-chans "fmv.snd") (channels ind-mix)))
	      (if (not (vequal (channel->float-vector 1000 10 ind-mix 0)
			       (float-vector 0.003 0.010 0.012 0.011 0.008 0.004 0.002 0.002 0.007 0.017)))
		  (snd-display #__line__ ";~D mus-file-mix 2 chan (2.snd written: ~A): ~A ~A" k
			       (strftime "%d-%b %H:%M %Z" (localtime (mus-sound-write-date "2.snd")))
			       (channel->float-vector 1000 10 ind-mix 0)
			       (channel->float-vector 1000 10 ind-mix 1)))
	      (close-sound ind-mix)
	      (delete-file "fmv.snd"))))
	); end do loop
      ); end let
    
    
    (let ()
      ;; someday this should be expanded
      (if (pair? (sounds))
	  (for-each close-sound (sounds)))

      (catch #t (lambda () (mus-file-mix-with-envs rd 0 1000 (float-vector))) (lambda args 'error))
      
      (with-sound ("flat.snd") 
	(do ((i 0 (+ i 1)))
	    ((= i 1000))
	  (outa i 1.0)))
      
      (with-sound ("mix.snd")
	(let ((rd (vector (make-readin "flat.snd"))))
	  (mus-file-mix-with-envs rd 0 1000 (float-vector 0.5) #f #f #f #f)))
      
      (let ((ind (find-sound "mix.snd")))
	(if (sound? ind)
	    (if (fneq (sample 100 ind) 0.5)
		(snd-display #__line__ ";mus-file-mix-with-envs 1: ~A" (sample 100 ind)))
	    (snd-display #__line__ ";mus-file-mix-with envs 1: no output? ~A" (map short-file-name (sounds)))))
      
      (with-sound ("mix.snd")
	(let ((rd (vector (make-readin "flat.snd")))
	      (es (vector (make-env '(0 0 1 1) :length 1000))))
	  (mus-file-mix-with-envs rd 0 1000 (float-vector 0.0) #f es #f #f)))
      
      (let ((ind (find-sound "mix.snd")))
	(if (sound? ind)
	    (if (fneq (sample 100 ind) 0.1)
		(snd-display #__line__ ";mus-file-mix-with-envs 2: ~A" (sample 100 ind)))
	    (snd-display #__line__ ";mus-file-mix-with envs 2: no output? ~A" (map short-file-name (sounds)))))
      
      (with-sound ("mix.snd" 2 :clipped #f)
	(let ((rd (vector (make-readin "flat.snd") 
			  (make-readin "flat.snd")))
	      (es (vector (make-env '(0 0 1 1) :length 1000 :scaler .1) 
			  (make-env '(0 1 1 0) :length 1000 :scaler .1)
			  (make-env '(0 1 1 1) :length 1000 :scaler .5)
			  (make-env '(0 1 1 1) :length 1000 :scaler -.5))))
	  (mus-file-mix-with-envs rd 0 1000 (float-vector 0.0 0.0 0.0 0.0) #f es #f #f)))
      
      (let ((ind (find-sound "mix.snd")))
	(if (sound? ind)
	    (begin
	      (if (fneq (sample 100 ind 0) 0.51)
		  (snd-display #__line__ ";mus-file-mix-with-envs 3 chan 0: ~A" (sample 100 ind 0)))
	      (if (fneq (sample 100 ind 1) -0.41)
		  (snd-display #__line__ ";mus-file-mix-with-envs 3 chan 1: ~A" (sample 100 ind 1))))
	    (snd-display #__line__ ";mus-file-mix-with envs 3: no output? ~A" (map short-file-name (sounds)))))
      
      (with-sound ("mix.snd" 2 :clipped #f)
	(let ((rd (vector (make-readin "flat.snd")))
	      (es (vector (make-env '(0 0 1 1) :length 1000 :scaler .3) 
			  (make-env '(0 1 1 0) :length 1000 :scaler .4))))
	  (mus-file-mix-with-envs rd 0 1000 (float-vector 0.0 0.0 0.0 0.0) #f es #f #f)))
      
      (let ((ind (find-sound "mix.snd")))
	(if (sound? ind)
	    (begin
	      (if (fneq (sample 100 ind 0) 0.03)
		  (snd-display #__line__ ";mus-file-mix-with-envs 4 chan 0: ~A" (sample 100 ind 0)))
	      (if (fneq (sample 100 ind 1) 0.36)
		  (snd-display #__line__ ";mus-file-mix-with-envs 4 chan 1: ~A" (sample 100 ind 1))))
	    (snd-display #__line__ ";mus-file-mix-with envs 4: no output? ~A" (map short-file-name (sounds)))))
      
      (with-sound ("mix.snd" 1 :clipped #f)
	(let ((rd (vector (make-readin "flat.snd")
			  (make-readin "flat.snd")))
	      (es (vector (make-env '(0 0 1 1) :length 1000 :scaler .3) 
			  (make-env '(0 1 1 0) :length 1000 :scaler .4))))
	  (mus-file-mix-with-envs rd 0 1000 (float-vector 0.0 0.0 0.0 0.0) #f es #f #f)))
      
      (let ((ind (find-sound "mix.snd")))
	(if (sound? ind)
	    (if (fneq (sample 100 ind) 0.39)
		(snd-display #__line__ ";mus-file-mix-with-envs 5: ~A" (sample 100 ind)))
	    (snd-display #__line__ ";mus-file-mix-with envs 5: no output? ~A" (map short-file-name (sounds)))))
      
      (with-sound ("flat.snd") 
	(outa 99 0.5)
	(outa 100 1.0)
	(outa 101 0.5))
      
      (require snd-jcrev.scm)
      
      (with-sound ("mix.snd" :reverb jc-reverb)
	(let ((rd (vector (make-readin "flat.snd"))))
	  (mus-file-mix-with-envs rd 0 1000 (float-vector 0.5) (float-vector 0.1) #f #f #f)))
      
      (with-sound ("mix.snd" :reverb jc-reverb)
	(let* ((rd (vector (make-readin "flat.snd") 
			   (make-readin "flat.snd"))) 
	       (srcs (vector (make-src :input (vector-ref rd 0) :srate 2.0)
			     (make-src :input (vector-ref rd 1) :srate 0.5))))
	  (mus-file-mix-with-envs rd 0 1000 (float-vector 1.0 1.0 0.5 0.5) (float-vector 0.1) #f srcs #f)))
      
      (let ((ind (find-sound "mix.snd")))
	(if (sound? ind)
	    (if (fneq (sample 200 ind) 0.5)
		(snd-display #__line__ ";mus-file-mix-with-envs 7: ~A" (sample 200 ind)))
	    (snd-display #__line__ ";mus-file-mix-with envs 7: no output? ~A" (map short-file-name (sounds)))))

      (for-each close-sound (sounds))
      (delete-file "flat.snd")
      (delete-file "mix.snd")
      )


    (let* ((gen (make-phase-vocoder #f 512 4 256 1.0 #f #f #f))
	   (val (catch #t (lambda () (phase-vocoder gen)) (lambda args (car args)))))
      (if (fneq val 0.0) (snd-display #__line__ ";simple no-in pv call: ~A" val))
      (set! val (catch #t (lambda () (set! gen (make-phase-vocoder :fft-size 1234))) (lambda args (car args))))
      (if (not (eq? val 'out-of-range)) (snd-display #__line__ ";pv bad fft: ~A" val))
      )
    
    (let* ((ind (open-sound "oboe.snd"))
	   (pi2 (* 2.0 pi))
	   (reader (make-sampler 0))
	   (pv (make-phase-vocoder (lambda (dir) (next-sample reader))
				   512 4 128 1.0
				   #f ;no change to analysis
				   #f ;no change to edits
				   #f ;no change to synthesis
				   )))
      (if (not (phase-vocoder? pv)) (snd-display #__line__ ";~A not phase-vocoder?" pv))
      (print-and-check pv 
		       "phase-vocoder"
		       "phase-vocoder outctr: 128, interp: 128, filptr: 0, N: 512, D: 128, in_data: nil")
      (let ((val (let ((pv (make-phase-vocoder))) (set! (mus-location pv) 120) (mus-location pv))))
	(if (not (= val 120)) (snd-display #__line__ ";pv set outctr: ~A" val)))
      
      (select-sound ind)
      (map-channel (lambda (val) (phase-vocoder pv)))
      (float-vector-set! (phase-vocoder-amp-increments pv) 0 .1)
      (if (fneq ((phase-vocoder-amp-increments pv) 0) .1)
	  (snd-display #__line__ ";set phase-vocoder-amp-increments: ~A?" ((phase-vocoder-amp-increments pv) 0)))
      (float-vector-set! (phase-vocoder-amps pv) 0 .1)
      (if (fneq ((phase-vocoder-amps pv) 0) .1)
	  (snd-display #__line__ ";set phase-vocoder-amps: ~A?" ((phase-vocoder-amps pv) 0)))
      (float-vector-set! (phase-vocoder-phases pv) 0 .1)
      (if (fneq ((phase-vocoder-phases pv) 0) .1)
	  (snd-display #__line__ ";set phase-vocoder-phases: ~A?" ((phase-vocoder-phases pv) 0)))
      (float-vector-set! (phase-vocoder-phase-increments pv) 0 .1)
      (if (fneq ((phase-vocoder-phase-increments pv) 0) .1)
	  (snd-display #__line__ ";set phase-vocoder-phase-increments: ~A?" ((phase-vocoder-phase-increments pv) 0)))
      (float-vector-set! (phase-vocoder-freqs pv) 0 .1)
      (if (fneq ((phase-vocoder-freqs pv) 0) .1)
	  (snd-display #__line__ ";set phase-vocoder-freqs: ~A?" ((phase-vocoder-freqs pv) 0)))
      (undo 1)
      (free-sampler reader)
      (let ((lastphases (make-float-vector 512))
	    (diffs (make-float-vector 512)))
	(define (efunc v)
	  ;; new editing func changes pitch
	  (let ((N (mus-length v)) ;mus-increment => interp, mus-data => in-data
		(D (mus-hop v))
		(freqs (phase-vocoder-freqs v)))
	    (copy freqs diffs)
	    (float-vector-subtract! diffs lastphases)
	    (copy freqs lastphases)
	    (let ((N2 (floor (/ N 2)))
		  (pscl (/ 1.0 D))
		  (kscl (/ pi2 N)))
	      (do ((k 0 (+ k 1))
		   (kx 0.0 (+ kx kscl)))
		  ((= k N2))
		(float-vector-set! freqs k (* 0.5 (+ (* pscl (remainder (float-vector-ref diffs k) pi2)) kx)))))
	    #f))
	(set! reader (make-sampler 0))
	(set! pv (make-phase-vocoder (lambda (dir) (next-sample reader))
				     512 4 128 1.0
				     #f ;no change to analysis
				     efunc
				     #f ; no change to synthesis
				     ))
	(map-channel (lambda (val) (phase-vocoder pv))))
      (undo 1)
      (free-sampler reader)
      (set! reader (make-sampler 0))
      (set! pv (make-phase-vocoder (lambda (dir) (next-sample reader))
				   512 4 (* 128 2) 1.0
				   #f ;no change to analysis
				   #f ;no change to edits
				   #f ;no change to synthesis
				   ))
      (let* ((len 1000)
	     (data (make-float-vector len)))
	(fill-float-vector data (phase-vocoder pv))
	(set! (samples 0 len) data))
      (undo 1)
      (free-sampler reader)
      
      (let ((incalls 0)
	    (outcalls 0))
	(set! reader (make-sampler 0))
	(set! pv (make-phase-vocoder (lambda (dir) (next-sample reader))
				     512 4 (* 128 2) 1.0
				     (lambda (v infunc)
				       (set! incalls (+ incalls 1))
				       #t)
				     #f ;no change to edits
				     (lambda (v)
				       (set! outcalls (+ outcalls 1))
				       0.0)
				     ))
	(let* ((len 1000)
	       (data (make-float-vector len)))
	  (fill-float-vector data (phase-vocoder pv))
	  (set! (samples 0 len) data))
	(undo 1)
	(free-sampler reader)
	(if (or (= incalls 0)
		(= outcalls 0))
	    (snd-display #__line__ ";phase-vocoder incalls: ~A, outcalls: ~A" incalls outcalls)))
      (let ((tag (catch #t 
		   (lambda () (make-phase-vocoder #f 512 4 256 1.0 (lambda (a b c) #f) #f #f)) 
		   (lambda args args))))
	(if (not (eq? (car tag) 'bad-arity)) (snd-display #__line__ ";make-phase-vocoder bad analyze func: ~A" tag)))
      (let ((tag (catch #t
		   (lambda () (make-phase-vocoder #f 512 4 256 1.0 (lambda (a b) 0.0) (lambda (a b c) #f) #f)) 
		   (lambda args args))))
	(if (not (eq? (car tag) 'bad-arity)) (snd-display #__line__ ";make-phase-vocoder bad edit func: ~A" tag)))
      (let ((tag (catch #t 
		   (lambda () (make-phase-vocoder #f 512 4 256 1.0 (lambda (a b) 0.0) (lambda (a) #f) (lambda (a b) 0)))
		   (lambda args args))))
	(if (not (eq? (car tag) 'bad-arity)) (snd-display #__line__ ";make-phase-vocoder bad synthesize func: ~A" tag)))
      (let ((geno (make-phase-vocoder (lambda (dir) 0.0))))
	(let ((genx (make-phase-vocoder :input (lambda (dir) 0.0))))
	  (if (equal? geno genx) (snd-display #__line__ ";phase-vocoder equal? ~A ~A" geno genx))
	  (if (fneq (mus-frequency genx) 1.0) (snd-display #__line__ ";mus-frequency phase-vocoder: ~A" (mus-frequency genx)))
	  (set! (mus-frequency genx) 2.0)
	  (if (fneq (mus-frequency genx) 2.0) (snd-display #__line__ ";set mus-frequency phase-vocoder: ~A" (mus-frequency genx)))
	  (if (fneq (mus-increment genx) 128) (snd-display #__line__ ";mus-increment phase-vocoder: ~A" (mus-increment genx)))
	  (set! (mus-increment genx) 256)
	  (if (fneq (mus-increment genx) 256) (snd-displ