/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.htm.core;

import edu.jhu.htm.core.Convex;
import edu.jhu.htm.core.HTMindexImp;
import edu.jhu.htm.core.HTMrange;
import edu.jhu.htm.core.Vector3d;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Domain {
    List convexes_ = new ArrayList();
    protected int olevel = 20;

    public void setOlevel(int n) {
        this.olevel = n;
        if (this.convexes_ != null && this.convexes_.size() > 0) {
            Iterator iterator = this.convexes_.iterator();
            while (iterator.hasNext()) {
                ((Convex)iterator.next()).setOlevel(this.olevel);
            }
        }
    }

    public int getOlevel() {
        return this.olevel;
    }

    public void add(Convex convex) {
        this.convexes_.add(convex);
        convex.setOlevel(this.olevel);
    }

    public boolean intersect(HTMindexImp hTMindexImp, HTMrange hTMrange, boolean bl) {
        int n = 0;
        while (n < this.convexes_.size()) {
            this.getConvex(n).intersect(hTMindexImp, hTMrange, bl);
            ++n;
        }
        return true;
    }

    public Convex getConvex(int n) {
        return (Convex)this.convexes_.get(n);
    }

    public int getNumberOfConvexes() {
        return this.convexes_.size();
    }

    public String toString() {
        String string = "#DOMAIN\n" + this.convexes_.size() + '\n';
        int n = 0;
        while (n < this.convexes_.size()) {
            string = string + this.getConvex(n).toString();
            ++n;
        }
        return string;
    }

    public void clear() {
        this.convexes_.clear();
    }

    public Domain simplify() {
        int n = 0;
        while (n < this.convexes_.size()) {
            this.getConvex(n).simplify();
            ++n;
        }
        return this;
    }

    public boolean contains(Vector3d vector3d) {
        boolean bl = false;
        int n = 0;
        while (n < this.convexes_.size()) {
            if (this.getConvex(n).contains(vector3d)) {
                return true;
            }
            ++n;
        }
        return bl;
    }

    public void add(Domain domain) {
        int n = 0;
        while (n < domain.convexes_.size()) {
            this.add(domain.getConvex(n));
            ++n;
        }
    }
}

