/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.db.DBColumn;
import adql.parser.feature.LanguageFeature;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.NullADQLIterator;
import adql.query.TextPosition;
import adql.query.from.ADQLTable;

public class ColumnReference
implements ADQLObject {
    public static final LanguageFeature FEATURE = new LanguageFeature(null, "COLUMN_REF", false, "Reference to an item of the SELECT clause (i.e. ref. to an output column).");
    private TextPosition position = null;
    private int columnIndex;
    private DBColumn dbLink = null;
    private ADQLTable adqlTable = null;
    private boolean caseSensitive = false;

    public ColumnReference(int index) throws ArrayIndexOutOfBoundsException {
        if (index <= 0) {
            throw new IndexOutOfBoundsException("Impossible to make a reference to the " + index + "th column: a column index must be greater or equal 1 !");
        }
        this.columnIndex = index;
    }

    public ColumnReference(ColumnReference toCopy) {
        this.caseSensitive = toCopy.caseSensitive;
        this.columnIndex = toCopy.columnIndex;
    }

    @Override
    public LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    @Override
    public final TextPosition getPosition() {
        return this.position;
    }

    public void setPosition(TextPosition pos) {
        this.position = pos;
    }

    public final int getColumnIndex() {
        return this.columnIndex;
    }

    public final boolean setColumnIndex(int index) {
        if (index > 0) {
            this.columnIndex = index;
            return true;
        }
        return false;
    }

    public final boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public final void setCaseSensitive(boolean sensitive) {
        this.caseSensitive = sensitive;
    }

    public final DBColumn getDBLink() {
        return this.dbLink;
    }

    public final void setDBLink(DBColumn dbLink) {
        this.dbLink = dbLink;
    }

    @Deprecated
    public final ADQLTable getAdqlTable() {
        return this.adqlTable;
    }

    @Deprecated
    public final void setAdqlTable(ADQLTable adqlTable) {
        this.adqlTable = adqlTable;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new ColumnReference(this);
    }

    @Override
    public String getName() {
        return this.columnIndex + "";
    }

    @Override
    public final ADQLIterator adqlIterator() {
        return new NullADQLIterator();
    }

    @Override
    public String toADQL() {
        return "" + this.columnIndex;
    }
}

