/* ====================================================================
 * Copyright (c) 2007,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_BLAMEVIEWMODEL_H
#define _SC_BLAMEVIEWMODEL_H

// sc
#include "sublib/TargetId.h"
#include "svn/Revision.h"
#include "svn/BlameLineTypes.h"
#include "util/String.h"
class ScModel;
class Bookmark;
class BlameParam;
namespace sc {
  class Error;
}

// qt
#include <QtCore/QObject>



class BlameViewModel : public QObject, public TargetId
{
  typedef QObject super;
   Q_OBJECT;

public:
  BlameViewModel( const sc::String& name, Bookmark* bm, ScModel* model );
  ~BlameViewModel();

  // QObject
  bool event( QEvent* e );

  const sc::String& getName() const;
  svn::RevisionPtr getStartRevision();
  svn::RevisionPtr getStopRevision();

  // commands
public slots:
  void blame();
  void result( BlameParam*, const sc::Error* );

  void setStartRevision( svn::RevisionPtr );
  void setStopRevision( svn::RevisionPtr );

signals:
  void addBlameLine( svn::BlameLinePtr );
  void doneBlame();

private:
  sc::String       _name;

  Bookmark*        _bookmark;
  ScModel*         _model;

  // state
  svn::RevisionPtr _revStart;
  svn::RevisionPtr _revStop;
};

#endif // _SC_BLAMEVIEWMODEL_H
