/* ====================================================================
 * Copyright (c) 2008        Martin Hauner
 *                           http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _RPVIEWENTRY_H
#define _RPVIEWENTRY_H

// sc
#include "RpViewItem.h"
#include "svn/DirEntryTypes.h"

// qt
#include <QtCore/QVariant>


/** RpViewItem item implementation for svn::DirEntry objects. */
class RpViewEntry : public RpViewItem
{
public:
  RpViewEntry( svn::DirEntryPtr entry );

  svn::DirEntryPtr entry() const;

  // RpViewItem
  bool isDir() const;
  const sc::String& path() const;

private:
  svn::DirEntryPtr _entry;
};


/** RpViewItemData implemetation for RpViewEntry items. */
class RpViewEntryData : public RpViewItemData
{
public:
  RpViewEntryData();

  /* WcViewItem overwrites. */
  QString data( int column, const RpViewItem* ) const;
  QString header( int column ) const;
  Qt::Alignment alignment( int column ) const;
  int columns() const;
};

#endif // _RPVIEWENTRY_H
