#include <SyFi.h>
#include <fstream>

using namespace GiNaC; 
using namespace SyFi; 
using namespace std; 

int main() {

    initSyFi(2); 

    archive ar; 

    int order = 2; 


    ex polynom_space = legendre(order,nsd, "a"); 
    cout <<"polynom_space "<<polynom_space<<endl; 
    ar.archive_ex(polynom_space, "polynom_space"); 

    ex p = polynom_space.op(0); 
    cout <<"polynom p = "<<p<<endl; 
    ar.archive_ex(p, "p"); 

    ex dpdx = diff(p,x);   
    cout <<"dpdx = "<<dpdx<<endl; 
    ar.archive_ex(dpdx, "dpdx"); 

    ex p0 = lst(-1,-1);
    ex p1 = lst(1,1);

    Rectangle rectangle(p0,p1) ;
    ex basis = polynom_space.op(2); 
    for (unsigned int i=0; i< basis.nops(); i++) {
        cout <<"i "<<i<<endl; 
        ex integrand = p*basis.op(i); 
        ex ai = rectangle.integrate(integrand); 
        cout <<"ai "<<ai<<endl; 

	ar.archive_ex(ai, istr("a", i).c_str()); 
    }

    ofstream vfile("legendre.gar.v"); 
    vfile << ar; vfile.close(); 
    if(!compare_archives("legendre.gar.v", "legendre.gar.r")) { 
	    cerr << "Failure!" << endl;
	    return -1;
    }

    return 0; 

}


