from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


crash_handler_lite = _Mock()

getcwd = _Mock()

input = _Mock()

os = _Mock()

pformat = _Mock()

print_function = _Mock()

sys = _Mock()

sys_info = _Mock()

traceback = _Mock()

ultratb = _Mock()

_default_message_template = "Oops, {app_name} crashed. We do our best to make it stable, but...\n\nA crash report was automatically generated with the following information:\n  - A verbatim copy of the crash traceback.\n  - A copy of your input history during this session.\n  - Data on your current {app_name} configuration.\n\nIt was left in the file named:\n\t'{crash_report_fname}'\nIf you can email this file to the developers, the information in it will help\nthem in understanding and correcting the problem.\n\nYou can mail it to: {contact_name} at {contact_email}\nwith the subject '{app_name} Crash Report'.\n\nIf you want to do it now, the following command will work (under Unix):\nmail -s '{app_name} Crash Report' {contact_email} < {crash_report_fname}\n\nTo ensure accurate tracking of this issue, please file a report about it at:\n{bug_tracker}\n"

_lite_message_template = '\nIf you suspect this is an IPython bug, please report it at:\n    https://github.com/ipython/ipython/issues\nor send an email to the mailing list at {email}\n\nYou can print a more detailed traceback right now with "%tb", or use "%debug"\nto interactively debug it.\n\nExtra-detailed tracebacks for bug-reporting purposes can be enabled via:\n    {config}Application.verbose_crash=True\n'

author_email = 'ipython-dev@scipy.org'

class CrashHandler(_Mock):
  pass
  message_template = "Oops, {app_name} crashed. We do our best to make it stable, but...\n\nA crash report was automatically generated with the following information:\n  - A verbatim copy of the crash traceback.\n  - A copy of your input history during this session.\n  - Data on your current {app_name} configuration.\n\nIt was left in the file named:\n\t'{crash_report_fname}'\nIf you can email this file to the developers, the information in it will help\nthem in understanding and correcting the problem.\n\nYou can mail it to: {contact_name} at {contact_email}\nwith the subject '{app_name} Crash Report'.\n\nIf you want to do it now, the following command will work (under Unix):\nmail -s '{app_name} Crash Report' {contact_email} < {crash_report_fname}\n\nTo ensure accurate tracking of this issue, please file a report about it at:\n{bug_tracker}\n"
  section_sep = '\n\n***************************************************************************\n\n'

